/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.master.account.common.AccountConstant;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.basedata.FaDepreciationModeInfo;
import com.kingdee.eas.fi.fa.basedata.FaDepreciationPeriodEnum;
import com.kingdee.eas.fi.fa.manage.FaAccountBalanceCollection;
import com.kingdee.eas.fi.fa.manage.FaAccountBalanceFactory;
import com.kingdee.eas.fi.fa.manage.FaAccountBalanceInfo;
import com.kingdee.eas.fi.fa.manage.FaBakCardInfo;
import com.kingdee.eas.fi.fa.manage.FaBakCostCenterCollection;
import com.kingdee.eas.fi.fa.manage.FaBakCostCenterInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCardCollection;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCostCenterInfo;
import com.kingdee.eas.fi.fa.manage.FaDepreciationEntryFactory;
import com.kingdee.eas.fi.fa.manage.FaDepreciationEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaDepreciationFactory;
import com.kingdee.eas.fi.fa.manage.FaEvalDepreciationFactory;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.FaMonCardInfo;
import com.kingdee.eas.fi.fa.manage.FaMonCostCenterCollection;
import com.kingdee.eas.fi.fa.manage.FaMonCostCenterInfo;
import com.kingdee.eas.fi.fa.manage.IFaAccountBalance;
import com.kingdee.eas.fi.fa.manage.IFaCurCard;
import com.kingdee.eas.fi.fa.manage.IFaDepreciation;
import com.kingdee.eas.fi.fa.manage.app.FaDepreCalculator;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class FaDepLocalUtils
extends FaLocalUtils {
    private static final Logger logger = Logger.getLogger(FaDepLocalUtils.class);
    private static final int IDS_LENGTH = 999;

    public static String getSplitInSql(String strCompanyInclude, String mark) {
        int i;
        String[] IDsArr;
        int num;
        logger.error((Object)"strCompanyInclude start---------------------------------------------------------------");
        logger.error((Object)strCompanyInclude);
        logger.error((Object)"strCompanyInclude end---------------------------------------------------------------");
        if (strCompanyInclude.indexOf("(") >= 0) {
            strCompanyInclude = strCompanyInclude.replace(" ", "");
            strCompanyInclude = strCompanyInclude.replace("(", "");
            strCompanyInclude = strCompanyInclude.replace(")", "");
        }
        if ((num = 999) > (IDsArr = strCompanyInclude.split(",")).length) {
            if (strCompanyInclude.indexOf("(") >= 0) {
                return new StringBuffer(" in ").append(strCompanyInclude).toString();
            }
            return new StringBuffer(" in (").append(strCompanyInclude).append(")").toString();
        }
        StringBuilder sqlStr = new StringBuilder();
        StringBuilder IDs = new StringBuilder();
        StringBuilder lastIDs = new StringBuilder();
        int lastIndex = 0;
        for (i = 0; i < IDsArr.length; ++i) {
            IDs.append(IDsArr[i]).append(",");
            if ((i + 1) % num != 0) continue;
            String ss = IDs.substring(0, IDs.lastIndexOf(","));
            if (i + 1 == num) {
                sqlStr.append("  in (").append(ss).append(")");
            } else {
                sqlStr.append(" or " + mark + " in (").append(ss).append(")");
            }
            IDs = new StringBuilder();
            lastIndex = i;
        }
        for (i = lastIndex + 1; i < IDsArr.length; ++i) {
            lastIDs.append(IDsArr[i]).append(",");
        }
        if (lastIDs.length() > 0) {
            sqlStr.append("  or " + mark + " in (").append(lastIDs.substring(0, IDs.lastIndexOf(","))).append(")");
        }
        String aaa = sqlStr.toString();
        logger.error((Object)"or in start ---------------------------------------------------------------");
        logger.error((Object)aaa);
        logger.error((Object)"or in end---------------------------------------------------------------");
        return sqlStr.toString();
    }

    public static FaCurCardCollection getCardDepInfoById(Context ctx, Set cardIdList) throws BOSException, EASBizException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.getSelector().add(new SelectorItemInfo("deprTTerm"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("accuDepr"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("accuDeprTYear"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("accuDeprAll"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("neatValue"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("neatAmt"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("deprTermCount"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("deprMethod.id"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("deprMethod.number"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)cardIdList, CompareType.INCLUDE));
        entityViewInfo.setFilter(filter);
        IFaCurCard iCurCard = FaCurCardFactory.getLocalInstance(ctx);
        return iCurCard.getFaCurCardCollection(entityViewInfo);
    }

    public static void updateCardDep(FaCurCardInfo card, HashMap depResult) throws BOSException {
        if (depResult == null) {
            return;
        }
        BigDecimal depRate = depResult.get(FaDepreCalculator.FA_DEP_RATE) != null ? (BigDecimal)depResult.get(FaDepreCalculator.FA_DEP_RATE) : new BigDecimal("0");
        BigDecimal dep = depResult.get(FaDepreCalculator.FA_DEP_AMOUNT) != null ? (BigDecimal)depResult.get(FaDepreCalculator.FA_DEP_AMOUNT) : new BigDecimal("0");
        card.setDeprTTerm(dep);
        card.setMonthDepreRate(depRate);
        BigDecimal accuDepr = card.getAccuDepr() == null ? new BigDecimal("0") : card.getAccuDepr();
        card.setAccuDepr(accuDepr.add(dep));
        BigDecimal accuDeprTYear = card.getAccuDeprTYear() == null ? new BigDecimal("0") : card.getAccuDeprTYear();
        card.setAccuDeprTYear(accuDeprTYear.add(dep));
        BigDecimal accuDeprAll = card.getAccuDeprAll() == null ? new BigDecimal("0") : card.getAccuDeprAll();
        card.setAccuDeprAll(accuDeprAll.add(dep));
        BigDecimal neatValue = card.getNeatValue() == null ? new BigDecimal("0") : card.getNeatValue();
        card.setNeatValue(neatValue.subtract(dep));
        BigDecimal neatAmt = card.getNeatAmt() == null ? new BigDecimal("0") : card.getNeatAmt();
        card.setNeatAmt(neatAmt.subtract(dep));
        if (!FaDepLocalUtils.isWorkLoadMethod((FaDepreciationModeInfo)card.getDeprMethod())) {
            BigDecimal depTerm = card.getDeprTermCount() == null ? new BigDecimal("0") : card.getDeprTermCount();
            card.setDeprTermCount(depTerm.add(new BigDecimal("1")));
        }
    }

    public static void updateCardDepForTax(FaCurCardInfo card, HashMap depResult) throws BOSException {
        if (depResult == null) {
            return;
        }
        BigDecimal depRate = depResult.get(FaDepreCalculator.FA_DEP_RATE) != null ? (BigDecimal)depResult.get(FaDepreCalculator.FA_DEP_RATE) : new BigDecimal("0");
        BigDecimal dep = depResult.get(FaDepreCalculator.FA_DEP_AMOUNT) != null ? (BigDecimal)depResult.get(FaDepreCalculator.FA_DEP_AMOUNT) : new BigDecimal("0");
        card.setEvalDeprTTerm(dep);
        card.setEvalMonthRate(depRate);
        BigDecimal accuDepr = card.getEvalAddDepr() == null ? new BigDecimal("0") : card.getEvalAddDepr();
        card.setEvalAddDepr(accuDepr.add(dep));
        BigDecimal accuDeprTYear = card.getEvalYearDepr() == null ? new BigDecimal("0") : card.getEvalYearDepr();
        card.setEvalYearDepr(accuDeprTYear.add(dep));
        BigDecimal neatValue = card.getEvalNeatValue() == null ? new BigDecimal("0") : card.getEvalNeatValue();
        card.setEvalNeatValue(neatValue.subtract(dep));
        BigDecimal neatAmt = card.getEvalNeatAmt() == null ? new BigDecimal("0") : card.getEvalNeatAmt();
        card.setEvalNeatAmt(neatAmt.subtract(dep));
        if (!FaDepLocalUtils.isWorkLoadMethod((FaDepreciationModeInfo)card.getEvalDeprMode())) {
            BigDecimal depTerm = card.getEvalDeprPeriodNum() == null ? new BigDecimal("0") : card.getEvalDeprPeriodNum();
            card.setEvalDeprPeriodNum(depTerm.add(new BigDecimal("1")));
            BigDecimal leftPeriod = card.getEvalTaxLeftPeriod() == null ? new BigDecimal("0") : card.getEvalTaxLeftPeriod();
            card.setEvalTaxLeftPeriod(leftPeriod.subtract(new BigDecimal("1")).compareTo(new BigDecimal("0")) == 1 ? leftPeriod.subtract(new BigDecimal("1")) : new BigDecimal("0"));
        }
    }

    public static void updateCardDep(FaCurCardInfo card, FaDepreciationEntryInfo depEntry) throws BOSException {
        BigDecimal deprValue = depEntry.getDepreciation().subtract(depEntry.getWellCost());
        card.setWellDeprValue(deprValue);
        card.setDeprTTerm(depEntry.getDepreciation());
        card.setMonthDepreRate(depEntry.getMonthDepreRate());
        BigDecimal accuDepr = card.getAccuDepr() == null ? new BigDecimal("0") : card.getAccuDepr();
        card.setAccuDepr(accuDepr.add(deprValue));
        BigDecimal accuDeprTYear = card.getAccuDeprTYear() == null ? new BigDecimal("0") : card.getAccuDeprTYear();
        card.setAccuDeprTYear(accuDeprTYear.add(deprValue));
        BigDecimal accuDeprAll = card.getAccuDeprAll() == null ? new BigDecimal("0") : card.getAccuDeprAll();
        card.setAccuDeprAll(accuDeprAll.add(deprValue));
        BigDecimal neatValue = card.getAssetValue() == null ? new BigDecimal("0") : card.getAssetValue();
        card.setNeatValue(neatValue.subtract(card.getAccuDepr()));
        BigDecimal decValue = card.getDecValue() == null ? new BigDecimal("0") : card.getDecValue();
        card.setNeatAmt(card.getNeatValue().subtract(decValue));
        if (!FaDepLocalUtils.isWorkLoadMethod((FaDepreciationModeInfo)card.getDeprMethod())) {
            BigDecimal depTerm = card.getDeprTermCount() == null ? new BigDecimal("0") : card.getDeprTermCount();
            card.setDeprTermCount(depTerm.add(new BigDecimal("1")));
        }
    }

    public static void removeCardDep(FaCurCardInfo card) throws BOSException {
        BigDecimal accuDeprTYear;
        BigDecimal accuDepr;
        BigDecimal dep;
        if (card.getDeprTTerm() != null) {
            dep = card.getDeprTTerm() == null ? new BigDecimal("0") : card.getDeprTTerm();
            card.setDeprTTerm(new BigDecimal("0"));
            accuDepr = card.getAccuDepr() == null ? new BigDecimal("0") : card.getAccuDepr();
            card.setAccuDepr(accuDepr.subtract(dep));
            accuDeprTYear = card.getAccuDeprTYear() == null ? new BigDecimal("0") : card.getAccuDeprTYear();
            card.setAccuDeprTYear(accuDeprTYear.subtract(dep));
            BigDecimal accuDeprAll = card.getAccuDeprAll() == null ? new BigDecimal("0") : card.getAccuDeprAll();
            card.setAccuDeprAll(accuDeprAll.subtract(dep));
            BigDecimal neatValue = card.getNeatValue() == null ? new BigDecimal("0") : card.getNeatValue();
            card.setNeatValue(neatValue.add(dep));
            BigDecimal neatAmt = card.getNeatAmt() == null ? new BigDecimal("0") : card.getNeatAmt();
            card.setNeatAmt(neatAmt.add(dep));
            if (!FaDepLocalUtils.isWorkLoadMethod((FaDepreciationModeInfo)card.getDeprMethod())) {
                BigDecimal depTerm = card.getDeprTermCount() == null ? new BigDecimal("0") : card.getDeprTermCount();
                card.setDeprTermCount(depTerm.subtract(new BigDecimal("1")));
                if (card.getDeprTermCount().compareTo(new BigDecimal("0")) < 0) {
                    card.setDeprTermCount(new BigDecimal("0"));
                }
            }
        }
        if (card.getEvalDeprTTerm() != null) {
            dep = card.getEvalDeprTTerm() == null ? new BigDecimal("0") : card.getEvalDeprTTerm();
            card.setEvalDeprTTerm(new BigDecimal("0"));
            accuDepr = card.getEvalAddDepr() == null ? new BigDecimal("0") : card.getEvalAddDepr();
            card.setEvalAddDepr(accuDepr.subtract(dep));
            accuDeprTYear = card.getEvalYearDepr() == null ? new BigDecimal("0") : card.getEvalYearDepr();
            card.setEvalYearDepr(accuDeprTYear.subtract(dep));
            BigDecimal neatValue = card.getEvalNeatValue() == null ? new BigDecimal("0") : card.getEvalNeatValue();
            card.setEvalNeatValue(neatValue.add(dep));
            BigDecimal neatAmt = card.getEvalNeatAmt() == null ? new BigDecimal("0") : card.getEvalNeatAmt();
            card.setEvalNeatAmt(neatAmt.add(dep));
            if (!FaDepLocalUtils.isWorkLoadMethod((FaDepreciationModeInfo)card.getEvalDeprMode())) {
                BigDecimal depTerm = card.getEvalDeprPeriodNum() == null ? new BigDecimal("0") : card.getEvalDeprPeriodNum();
                card.setEvalDeprPeriodNum(depTerm.subtract(new BigDecimal("1")));
                if (card.getEvalDeprPeriodNum().compareTo(new BigDecimal("0")) < 0) {
                    card.setEvalDeprPeriodNum(new BigDecimal("0"));
                }
                BigDecimal leftTerm = card.getEvalTaxLeftPeriod() == null ? new BigDecimal("0") : card.getEvalTaxLeftPeriod();
                card.setEvalTaxLeftPeriod(leftTerm.add(new BigDecimal("1")));
            }
        }
    }

    public static void updateBalance(FaAccountBalanceInfo balance, BigDecimal dep) {
        BigDecimal creditFor = balance.getDepreCreditFor() == null ? new BigDecimal("0") : balance.getDepreCreditFor();
        balance.setDepreCreditFor(creditFor.add(dep));
        BigDecimal endBalance = balance.getDepreEndBalanceFor() == null ? new BigDecimal("0") : balance.getDepreEndBalanceFor();
        balance.setDepreEndBalanceFor(endBalance.add(dep));
        BigDecimal yearDep = balance.getAddUpYearDepre() == null ? new BigDecimal("0") : balance.getAddUpYearDepre();
        balance.setAddUpYearDepre(yearDep.add(dep));
        balance.setDepreTerm(dep);
    }

    public static void updateBalance(FaAccountBalanceInfo balance, FaDepreciationEntryInfo depEntry) {
        BigDecimal deprValue = depEntry.getDepreciation().subtract(depEntry.getWellCost());
        BigDecimal creditFor = balance.getDepreCreditFor() == null ? new BigDecimal("0") : balance.getDepreCreditFor();
        balance.setDepreCreditFor(creditFor.add(deprValue));
        BigDecimal beginBalance = balance.getDepreBeginBalanceFor() == null ? new BigDecimal("0") : balance.getDepreBeginBalanceFor();
        BigDecimal debitFor = balance.getDepreDebitFor() == null ? new BigDecimal("0") : balance.getDepreDebitFor();
        balance.setDepreEndBalanceFor(beginBalance.add(balance.getDepreCreditFor()).subtract(debitFor));
        BigDecimal yearDep = balance.getAddUpYearDepre() == null ? new BigDecimal("0") : balance.getAddUpYearDepre();
        balance.setAddUpYearDepre(yearDep.add(deprValue));
        balance.setDepreTerm(depEntry.getDepreciation());
    }

    public static FaAccountBalanceCollection getBalanceCollection(Context ctx, EntityViewInfo entityViewInfo) throws BOSException, EASBizException {
        IFaAccountBalance iBalance = FaAccountBalanceFactory.getLocalInstance(ctx);
        return iBalance.getFaAccountBalanceCollection(entityViewInfo);
    }

    public static boolean ifAlreadyCal(Context ctx, PeriodInfo period) throws BOSException, EASBizException {
        if (period == null) {
            throw new BOSException("period is null");
        }
        IFaDepreciation iDep = FaDepreciationFactory.getLocalInstance(ctx);
        String strCompanyOrgUnitInfoID = FaDepLocalUtils.getCurrentCompanyId(ctx);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("period", (Object)period.getId().toString(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("company", (Object)strCompanyOrgUnitInfoID, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("depType", (Object)new Integer(0), CompareType.EQUALS));
        boolean result = iDep.exists(filterInfo);
        if (!result) {
            filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("period", (Object)period.getId().toString(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("company", (Object)strCompanyOrgUnitInfoID, CompareType.EQUALS));
            result = FaEvalDepreciationFactory.getLocalInstance(ctx).exists(filterInfo);
        }
        return result;
    }

    public static boolean ifAlreadyCal(Context ctx, PeriodInfo period, String strCompanyId) throws BOSException, EASBizException {
        if (period == null) {
            throw new BOSException("period is null");
        }
        if (strCompanyId.indexOf("'") != -1) {
            throw new IllegalArgumentException(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"83_FaLocalUtils", (Locale)ctx.getOriginLocale()));
        }
        IFaDepreciation iDep = FaDepreciationFactory.getLocalInstance(ctx);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("period", (Object)period.getId().toString(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("company", (Object)strCompanyId, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("depType", (Object)new Integer(0), CompareType.EQUALS));
        boolean result = iDep.exists(filterInfo);
        if (!result) {
            filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("period", (Object)period.getId().toString(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("company", (Object)strCompanyId, CompareType.EQUALS));
            result = FaEvalDepreciationFactory.getLocalInstance(ctx).exists(filterInfo);
        }
        return result;
    }

    public static boolean ifCardAlreadyCal(Context ctx, String periodID, String strCompanyId, String cardId) throws BOSException, EASBizException {
        if (periodID == null || periodID == "") {
            throw new BOSException("period is null");
        }
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT TOP 1 ENTRY.FID\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append("  FROM T_FA_FADEPRECIATION FaDepr\t\t\t\t\t\t\t\t\t\n");
        sql.append("  RIGHT  OUTER JOIN T_FA_FADEPRECIATIONENTRY ENTRY \t\t\t\t\t\n");
        sql.append("  ON FaDepr.FID = ENTRY.FLNKFADEPREENTRY\t\t\t\t\t\t\t\n");
        sql.append("  WHERE FaDepr.FPERIOD = ? \t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append("   AND FaDepr.FCOMPANYID = ?\t\t\t\t\t\t\t\t\t\t\n");
        sql.append("   AND FaDepr.FDEPTYPE = ? \t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append("   AND FaDepr.FCHECKEDSTATUS = ? \t\t\t\t\t\t\t\t\t\n");
        sql.append("   AND ENTRY.FSTATE = ? \t\t\t\t\t\t\t\t\t        \n");
        sql.append("   AND ENTRY.FFACURCARDID = ? \t\t\t\t\t\t\t\t\t\t\n");
        Object[] sqlPara = new Object[]{periodID, strCompanyId, new Integer(0), new Integer(2), new Integer(3), cardId};
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])sqlPara);
        try {
            if (rowSet.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    public static FilterInfo getDepCardFilter(Context ctx, boolean part, String companyId) throws EASBizException, BOSException {
        String newGovermentAccountingSystem;
        String strCompanyOrgUnitInfoID = companyId;
        PeriodInfo currPeriod = FaDepLocalUtils.getCurrentPeriod(ctx, strCompanyOrgUnitInfoID);
        HashSet laterPeriodIdVector = FaLocalUtils.getLaterPeriodIdSet(ctx, currPeriod.getId().toString());
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("effectedStatus", (Object)new Integer(2), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("bizStatus", (Object)new String("%99"), CompareType.LIKE));
        filterInfo.getFilterItems().add(new FilterItemInfo("checkedStatus", (Object)new Integer(2), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("blockedStatus", (Object)new Integer(1), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("bizStatus", (Object)new String("%99"), CompareType.LIKE));
        filterInfo.getFilterItems().add(new FilterItemInfo("leaseStatus", (Object)new Integer(2), CompareType.NOTEQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("deprMethod", null, CompareType.NOTEQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("assetCat.DepreciationPolicy.DeprRule", (Object)new Integer(1), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("assetCat.DepreciationPolicy.DeprRule", (Object)new Integer(0), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("company", (Object)strCompanyOrgUnitInfoID, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("bizStatus", (Object)"9999", CompareType.NOTEQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("bizStatus", (Object)"9999", CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)new Integer(2), CompareType.NOTEQUALS));
        if (laterPeriodIdVector.size() > 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("period.id", (Object)laterPeriodIdVector, CompareType.NOTINCLUDE));
        }
        String mask = "#0 and #1 and #2 and #3 and #4 and #5 and #6 and (#7 or (#8)) and #9 and (#10 or (#11 and #12))";
        if (laterPeriodIdVector.size() > 0) {
            mask = mask + " and #13";
        }
        if (part) {
            filterInfo.getFilterItems().add(new FilterItemInfo("isNeedReDepr", (Object)"1", CompareType.EQUALS));
            mask = laterPeriodIdVector.size() > 0 ? mask + " and #14" : mask + " and #13";
        }
        filterInfo.setMaskString(mask);
        Map paramMap = FaDepLocalUtils.getParamNewGovermentAccSystem(ctx);
        String string = newGovermentAccountingSystem = paramMap.get(AccountConstant.GovermentAccountingSystem) != null ? (String)paramMap.get(AccountConstant.GovermentAccountingSystem) : "false";
        if ("true".equalsIgnoreCase(newGovermentAccountingSystem)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("assetCat.notCalDep", (Object)new Integer(0), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("assetCat.notCalDep", null, CompareType.EQUALS));
            filterInfo.setMaskString(filterInfo.getMaskString() + " and (#" + (filterInfo.getFilterItems().size() - 2) + " or (#" + (filterInfo.getFilterItems().size() - 1) + "))");
        }
        return filterInfo;
    }

    public static Map getParamNewGovermentAccSystem(Context ctx, String companyId) throws EASBizException, BOSException {
        HashMap result = new HashMap();
        HashMap<String, Object> paramKeys = new HashMap<String, Object>();
        paramKeys.put(AccountConstant.GovermentAccountingSystem, null);
        result = ParamManager.getParamHashMap((Context)ctx, paramKeys);
        return result;
    }

    public static Map getParamNewGovermentAccSystem(Context ctx) throws EASBizException, BOSException {
        HashMap result = new HashMap();
        HashMap<String, Object> paramKeys = new HashMap<String, Object>();
        paramKeys.put(AccountConstant.GovermentAccountingSystem, null);
        result = ParamManager.getParamHashMap((Context)ctx, paramKeys);
        return result;
    }

    public static FilterInfo getDepCardFilterOfDeprMethodNull(Context ctx, boolean part, String companyId) {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("effectedStatus", (Object)new Integer(2), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("hasDisabled", (Object)"0", CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("checkedStatus", (Object)new Integer(2), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("blockedStatus", (Object)new Integer(1), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("bizStatus", (Object)new String("%99"), CompareType.LIKE));
        filterInfo.getFilterItems().add(new FilterItemInfo("deprMethod", null, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("company", (Object)companyId, CompareType.EQUALS));
        String mask = "#0 and #1 and #2 and #3 and #4 and #5 and #6 ";
        filterInfo.setMaskString(mask);
        return filterInfo;
    }

    public static FaCurCardInfo monCard2CurCard(Context ctx, FaMonCardInfo monCard) {
        if (monCard == null) {
            return null;
        }
        FaCurCardInfo card = new FaCurCardInfo();
        Enumeration enumKeys = monCard.keys();
        while (enumKeys.hasMoreElements()) {
            String element = (String)enumKeys.nextElement();
            if (element.equalsIgnoreCase("faCurCard")) continue;
            if (element.equalsIgnoreCase("faMonCostCenter")) {
                FaMonCostCenterCollection monCenter = monCard.getFaMonCostCenter();
                for (int i = 0; i < monCenter.size(); ++i) {
                    FaMonCostCenterInfo monCosterInfo = monCenter.get(i);
                    card.getFaCurCostCenter().add(FaDepLocalUtils.monCenterInfo2CurCenterInfo(monCosterInfo));
                }
                continue;
            }
            card.put(element, monCard.get(element));
        }
        try {
            FaManageUtils.copyMultiAsstActInfo(monCard, card, true);
        }
        catch (Exception e) {
            logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"86_FaDepLocalUtils", (Locale)ctx.getOriginLocale()));
            logger.error((Object)e);
        }
        card.setId(monCard.getFaCurCard().getId());
        return card;
    }

    public static FaCurCardInfo bakCard2CurCard(Context ctx, FaBakCardInfo bakCard) {
        if (bakCard == null) {
            return null;
        }
        FaCurCardInfo card = new FaCurCardInfo();
        Enumeration enumKeys = bakCard.keys();
        while (enumKeys.hasMoreElements()) {
            String element = (String)enumKeys.nextElement();
            if (element.equalsIgnoreCase("faCurCard")) continue;
            if (element.equalsIgnoreCase("faBakCostCenter")) {
                FaBakCostCenterCollection bakCenter = bakCard.getFaBakCostCenter();
                for (int i = 0; i < bakCenter.size(); ++i) {
                    FaBakCostCenterInfo bakCosterInfo = bakCenter.get(i);
                    card.getFaCurCostCenter().add(FaDepLocalUtils.bakCenterInfo2CurCenterInfo(bakCosterInfo));
                }
                continue;
            }
            card.put(element, bakCard.get(element));
        }
        try {
            FaManageUtils.copyMultiAsstActInfo(bakCard, card, true);
        }
        catch (Exception e) {
            logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"87_FaDepLocalUtils", (Locale)ctx.getOriginLocale()));
            logger.error((Object)e);
        }
        card.setId(bakCard.getFaCurCard().getId());
        return card;
    }

    public static FaCurCostCenterInfo monCenterInfo2CurCenterInfo(FaMonCostCenterInfo monCosterInfo) {
        FaCurCostCenterInfo costInfo = new FaCurCostCenterInfo();
        Enumeration enumKeys = monCosterInfo.keys();
        while (enumKeys.hasMoreElements()) {
            String element = (String)enumKeys.nextElement();
            costInfo.put(element, monCosterInfo.get(element));
        }
        return costInfo;
    }

    public static FaCurCostCenterInfo bakCenterInfo2CurCenterInfo(FaBakCostCenterInfo bakCosterInfo) {
        FaCurCostCenterInfo costInfo = new FaCurCostCenterInfo();
        Enumeration enumKeys = bakCosterInfo.keys();
        while (enumKeys.hasMoreElements()) {
            String element = (String)enumKeys.nextElement();
            costInfo.put(element, bakCosterInfo.get(element));
        }
        return costInfo;
    }

    public static boolean ifDepGenFV(Context ctx) throws BOSException, EASBizException {
        return FaDepLocalUtils.ifDepGenFV(ctx, FaDepLocalUtils.getCurrentPeriod(ctx));
    }

    public static boolean ifDepGenFV(Context ctx, String companyId) throws BOSException, EASBizException {
        PeriodInfo companyPeriodInfo = FaDepLocalUtils.getCurrentPeriod(ctx, companyId);
        return FaDepLocalUtils.ifDepGenFV(ctx, companyPeriodInfo, companyId);
    }

    public static boolean ifDepGenFV(Context ctx, PeriodInfo period, String strCompanyOrgUnitInfoID) throws BOSException, EASBizException {
        boolean normalDepHadGen = true;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT TOP 1 FaDepr.FID\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append("  FROM T_FA_FADEPRECIATION FaDepr\t\t\t\t\t\t\t\t\t\n");
        sql.append(" WHERE FaDepr.FPERIOD = ? \t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append("   AND FaDepr.FCOMPANYID = ?\t\t\t\t\t\t\t\t\t\t\n");
        sql.append("   AND (FaDepr.FFIVOUCHERED = 0 OR FaDepr.FFIVOUCHERED IS NULL) \t\n");
        sql.append("   AND FaDepr.FDEPTYPE = ? \t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append("   AND EXISTS (SELECT 1 FROM T_FA_FaDepreciationEntry DeprEntry WHERE DeprEntry.FLnkFaDepreEntry = FaDepr.FID)\t\n");
        Object[] sqlPara = new Object[]{period.getId().toString(), strCompanyOrgUnitInfoID, new Integer(0)};
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])sqlPara);
        try {
            if (rowSet.next()) {
                normalDepHadGen = false;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        boolean coalDepHadGen = true;
        if (normalDepHadGen) {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("LnkFaDepreEntry.period.id", (Object)period.getId().toString(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("LnkFaDepreEntry.company.id", (Object)strCompanyOrgUnitInfoID, CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("LnkFaDepreEntry.fiVouchered", (Object)"0", CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("LnkFaDepreEntry.fiVouchered", null, CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("LnkFaDepreEntry.depType", (Object)new Integer(1), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("depreciation", (Object)new BigDecimal("0"), CompareType.GREATER));
            filterInfo.setMaskString("#0 and #1 and (#2 or #3) and #4 and #5");
            coalDepHadGen = !FaDepreciationEntryFactory.getLocalInstance(ctx).exists(filterInfo);
        }
        return normalDepHadGen && coalDepHadGen;
    }

    public static boolean ifDepGenFV(Context ctx, PeriodInfo period) throws BOSException, EASBizException {
        String strCompanyOrgUnitInfoID = FaDepLocalUtils.getCurrentCompanyId(ctx);
        StringBuffer sql = new StringBuffer();
        sql.append("select 1 from t_fa_fadepreciation dep ");
        sql.append(" where dep.fperiod = ? and dep.fcompanyid = ? ");
        sql.append(" and (dep.ffiVouchered = 0 OR dep.ffiVouchered IS NULL) ");
        sql.append(" and dep.fdepType = ? ");
        sql.append(" and exists (select 1 from t_fa_fadepreciationentry entry where entry.flnkfadepreentry = dep.fid) ");
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{period.getId().toString(), strCompanyOrgUnitInfoID, new Integer(0)});
        boolean normalDepHadGen = true;
        try {
            if (result.next()) {
                normalDepHadGen = false;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        boolean coalDepHadGen = true;
        if (normalDepHadGen) {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("LnkFaDepreEntry.period.id", (Object)period.getId().toString(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("LnkFaDepreEntry.company.id", (Object)strCompanyOrgUnitInfoID, CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("LnkFaDepreEntry.fiVouchered", (Object)"0", CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("LnkFaDepreEntry.fiVouchered", null, CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("LnkFaDepreEntry.depType", (Object)new Integer(1), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("depreciation", (Object)new BigDecimal("0"), CompareType.GREATER));
            filterInfo.setMaskString("#0 and #1 and (#2 or #3) and #4 and #5");
            coalDepHadGen = !FaDepreciationEntryFactory.getLocalInstance(ctx).exists(filterInfo);
        }
        return normalDepHadGen && coalDepHadGen;
    }

    public static int getDeprRatePrecision(Context ctx, String companyId) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)companyId));
        IParamControl paramControl = ParamControlFactory.getLocalInstance((Context)ctx);
        String parame = paramControl.getParamValue((IObjectPK)pk, "FA_007");
        if (parame != null && parame.trim().length() > 0) {
            Integer returnValue = new Integer(parame);
            return returnValue + 2;
        }
        return 6;
    }

    public static boolean isLastPeriodAll(FaCurCardInfo card) throws BOSException {
        if (card.getAssetCat() == null) {
            throw new BOSException("card.getAssetCat()==null in FaDepLocalUtils.isLastPeriodAll method");
        }
        if (card.getAssetCat().getDepreciationPolicy() == null) {
            throw new BOSException("card.getAssetCat().getDepreciationPolicy()==null in FaDepLocalUtils.isLastPeriodAll method");
        }
        return card.getAssetCat().getDepreciationPolicy().isTailDispose();
    }

    public static boolean isYearDepCal(FaCurCardInfo card) throws BOSException {
        if (card.getDeprMethod() == null) {
            throw new BOSException("card.getDeprMethod()==null in FaDepLocalUtils.isYearDepCal method");
        }
        return card.getDeprMethod().getPeriod().equals((Object)FaDepreciationPeriodEnum.YEAR);
    }

    public static HashSet getUnauditCardIdVector(Context ctx, String depInfoId, String evalDepInfoId) throws BOSException {
        try {
            depInfoId = depInfoId == null ? " " : depInfoId;
            evalDepInfoId = evalDepInfoId == null ? " " : evalDepInfoId;
            String sql = "select ffacurcardid from t_fa_fadepreciationentry where FLnkFaDepreEntry=? and fstate <> 3 union select ffacurcardid from t_fa_faevaldepreciationentry where FLnkFaDepreEntry=? and fstate <> 3";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{depInfoId, evalDepInfoId});
            HashSet<String> v = new HashSet<String>();
            while (rs.next()) {
                v.add(rs.getString(1));
            }
            return v;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static boolean isLastTwoYear(FaCurCardInfo card) throws BOSException {
        BigDecimal useTermCount = card.getUseTermCount();
        BigDecimal depTermCount = card.getDeprTermCount() == null ? new BigDecimal(0) : card.getDeprTermCount();
        BigDecimal temp = useTermCount.subtract(depTermCount);
        boolean isDoubleSyn = FaLocalUtils.isDoubleSubtractDynMethod((FaDepreciationModeInfo)card.getDeprMethod());
        if (temp.compareTo(new BigDecimal(24)) <= 0) {
            return isDoubleSyn;
        }
        return false;
    }

    public static HashMap getUpdateEvalCard(Context ctx, String curPeriodID, String companyID, String depmethodNumber) throws EASBizException, BOSException {
        HashMap result = new HashMap();
        PeriodInfo prePeriod = PeriodUtils.getPrePeriodInfo((Context)ctx, (IObjectPK)new ObjectUuidPK(curPeriodID));
        if (prePeriod != null && prePeriod.isIsAdjustPeriod()) {
            prePeriod = PeriodUtils.getPrePeriodInfo((Context)ctx, (IObjectPK)new ObjectUuidPK(prePeriod.getId().toString()));
        }
        if (prePeriod != null && prePeriod.getId() != null) {
            String depSQL = "select fid as id from T_FA_FaEvalDepreciation where fperiod=? and fcompanyid=?";
            Object[] depPara = new Object[]{prePeriod.getId().toString(), companyID};
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)depSQL, (Object[])depPara);
            HashMap<Integer, BigDecimal> cardMap = null;
            try {
                if (rowSet.next()) {
                    rowSet = DbUtil.executeQuery((Context)ctx, (String)FaDepLocalUtils.getUpdateLastEvalDepCard(ctx, curPeriodID, prePeriod.getId().toString(), companyID, FaLocalUtils.getMethodID(ctx, depmethodNumber)).toString());
                    while (rowSet.next()) {
                        cardMap = new HashMap<Integer, BigDecimal>();
                        String cardId = rowSet.getString("curcardid");
                        BigDecimal depreciation = rowSet.getBigDecimal("fdepreciation");
                        BigDecimal depRate = rowSet.getBigDecimal("fmonthdeprerate");
                        cardMap.put(FaDepreCalculator.FA_DEP_AMOUNT, depreciation);
                        cardMap.put(FaDepreCalculator.FA_DEP_RATE, depRate);
                        result.put(cardId, cardMap);
                    }
                    return result;
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return null;
    }

    public static String getUpdateLastEvalDepCard(Context ctx, String prePeriodID, String companyID, String depmethodID, String cardID) {
        StringBuffer result = new StringBuffer();
        result.append("SELECT depentry.fmonthdeprerate AS fmonthdeprerate, depentry.FDepreciation AS fdepreciation, \n");
        result.append("       depentry.fshoulddepre AS fshoulddepre \n");
        result.append("  from t_fa_faevaldepreciationentry depentry \n");
        result.append("  inner join t_fa_faevaldepreciation dep on dep.fid = depentry.flnkfadepreentry \n");
        result.append("  and dep.fperiod = '").append(prePeriodID).append("' and dep.fcompanyid = '").append(companyID).append("' and depentry.ffacurcardid = '").append(cardID).append("' \n");
        result.append("  inner join  t_fa_facurcard curcard on depentry.ffacurcardid = curcard.fid \n");
        result.append("  inner join  t_fa_cat t1 on curcard.fassetcatid = t1.fid\n");
        result.append("  inner join  t_fa_depreciationpolicy t2 ON t1.fdepreciationpolicyid = t2.fid\n");
        result.append("  inner join  t_fa_famoncard moncard ON moncard.ffacurcardid = curcard.fid and moncard.ffaperiodid = dep.fperiod \n");
        result.append("  left outer join (select faccudepr, fdeprtermcount, ffacurcardid FROM t_fa_famoncard WHERE ffaperiodid IS NULL AND fcompanyid = '" + companyID + "') initcard ON moncard.ffacurcardid = initcard.ffacurcardid\n");
        result.append("   where moncard.fhaschanged != 2\n");
        result.append("   AND moncard.fhascleared = 0\n");
        result.append("   AND curcard.FEvalDeprModeID = '" + depmethodID + "'\n");
        result.append("   AND (curcard.fhaschanged = 3 OR curcard.fhaschanged = 0  OR  curcard.fhaschanged = 2 )\n");
        result.append("   AND (curcard.fhascleared = 0 OR (t2.fstartdeprtime = 1 AND curcard.fhascleared != 0))\n");
        result.append("   AND NOT (    curcard.foriginflag = 0\n");
        result.append("            AND curcard.fisinitchange != 1\n");
        result.append("            AND t2.finitoldasset != 1\n");
        result.append("            AND (initcard.fdeprtermcount != 0 OR initcard.faccudepr != 0)\n");
        result.append("            )\n");
        result.append("   AND (   (moncard.fusetermcount - moncard.fdeprtermcount > 1)\n");
        result.append("      OR ((moncard.fusetermcount - moncard.fdeprtermcount <= 1) AND t2.ftaildispose = 0)\n");
        result.append("       )\n");
        result.append("   AND (curcard.fassetvalue - curcard.faccudepr - curcard.fdecvalue - curcard.fneatremvalue - depentry.FDepreciation >= 0\n");
        result.append("       )");
        return result.toString();
    }
}

