/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.service.ServiceContext;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaAppLogForBusinessTypeEnum;
import com.kingdee.eas.fi.fa.manage.FaDispatchDirectionWebEnum;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.app.AbstractFaDepreciationBatchFacadeControllerBean;
import com.kingdee.eas.fi.fa.manage.app.FaDepCalExecutor;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.fa.manage.app.falog.event.FaMethodCalcOrderEnum;
import com.kingdee.eas.fi.fa.manage.app.falog.utils.FaRPCMethodMappingUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class FaDepreciationBatchFacadeControllerBean
extends AbstractFaDepreciationBatchFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.fa.manage.app.FaDepreciationBatchFacadeControllerBean");

    @Override
    protected List _getInitDepreciationData(Context ctx) throws BOSException, EASBizException {
        ArrayList resultList = new ArrayList();
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        IPermission iPermission = PermissionFactory.getLocalInstance((Context)ctx);
        FullOrgUnitCollection permCompany = null;
        permCompany = iPermission.getAuthorizedOrg((IObjectPK)new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId()), OrgType.Company, null, "fa_dep_cal");
        if (permCompany == null || permCompany.size() == 0) {
            return resultList;
        }
        StringBuffer sbFilter = new StringBuffer();
        boolean isOnlyShowChildCompany = FaManageUtils.getFaParamValue(ctx, "FA_206", company.getId().toString());
        if (isOnlyShowChildCompany) {
            HashMap childCompanyMap = FaLocalUtils.getChildCompanyByParrentId(ctx, company.getId().toString());
            for (int i = 0; i < permCompany.size(); ++i) {
                String permCompanyId = permCompany.get(i).getId().toString();
                if (childCompanyMap.containsKey(permCompanyId)) continue;
                childCompanyMap.remove(permCompanyId);
            }
            for (Object key : childCompanyMap.keySet()) {
                String childCompanyId = key.toString();
                if (sbFilter.length() == 0) {
                    sbFilter.append("'").append(childCompanyId).append("'");
                    continue;
                }
                sbFilter.append(",'").append(childCompanyId).append("'");
            }
        } else {
            for (int i = 0; i < permCompany.size(); ++i) {
                if (i == 0) {
                    sbFilter.append("'").append(permCompany.get(i).getId().toString()).append("'");
                    continue;
                }
                sbFilter.append(",'").append(permCompany.get(i).getId().toString()).append("'");
            }
        }
        String sql = "select a.fid comId, b.fcurrentperiodid periodId, a.fnumber, a.fname_l2 fname, a.fcontrolunitid cuid,\t\r\n\t\td.fperiodyear curYear, d.fperiodnumber curPeriod, d.fid periodId \t        \r\n\t\tfrom t_org_company a \t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n      inner join t_pm_orgrange as range on a.fid = range.forgid               \t\r\n\t\tinner join t_bd_systemstatusctrol b on a.fid=b.fcompanyid \t\t\t\t\t\r\n\t\tinner join t_bd_systemstatus c on c.fid=b.fsystemstatusid\t\t\t\t\t\r\n\t\tinner join t_bd_period d on d.fid=b.fcurrentperiodid \t\t\t\t\t\t\r\n\t\twhere c.fname=14 and a.fisbizunit=1 \t\tand a.fid in (" + sbFilter.toString() + ")\t\t\t\t\t\t\t\t\t\t\r\n      and range.ftype=10 and  range.fuserid = '" + ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() + "'   \r\n\t\tand a.fIsBizUnit = 1\t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n\t\torder by a.fnumber\t\t\t\t\t\t\t\t\r\n";
        FaDispatchDirectionWebEnum dispatchDirection = null;
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (set != null) {
            try {
                while (set.next()) {
                    HashMap<String, Object> dataMap = new HashMap<String, Object>();
                    dataMap.put("id", set.getString("comId"));
                    dataMap.put("number", set.getString("fnumber"));
                    dataMap.put("name", set.getString("fname"));
                    dataMap.put("periodId", set.getString("periodId"));
                    dataMap.put("curPeriod", set.getString("curYear") + "." + set.getString("curPeriod"));
                    FaDepCalExecutor executor = new FaDepCalExecutor(set.getString("comId"));
                    dataMap.put("isDepreciated", executor.ifAlreadyCal(ctx));
                    dataMap.put("isAudited", executor.isAudited(ctx));
                    dataMap.put("isVoucherSaved", executor.isVoucherSaved(ctx));
                    dataMap.put("msg", "");
                    boolean isDepreciated = executor.ifAlreadyCal(ctx);
                    boolean isAudited = executor.isAudited(ctx);
                    boolean isVoucherSaved = executor.isVoucherSaved(ctx);
                    if (!isDepreciated) {
                        dispatchDirection = FaDispatchDirectionWebEnum.NONDEPRECIABLE;
                    } else if (isDepreciated && !isAudited) {
                        dispatchDirection = FaDispatchDirectionWebEnum.DEPRECIABLE;
                    } else if (isDepreciated && isAudited && !isVoucherSaved) {
                        dispatchDirection = FaDispatchDirectionWebEnum.AUDITED;
                    } else if (isDepreciated && isAudited && isVoucherSaved) {
                        dispatchDirection = FaDispatchDirectionWebEnum.VOUCHERSAVE;
                    }
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("alias", dispatchDirection.getAlias());
                    map.put("value", dispatchDirection.getValue());
                    dataMap.put("status", map);
                    resultList.add(dataMap);
                }
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        return resultList;
    }

    @Override
    protected boolean _checkBeforeCal(Context ctx, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        FaDepCalExecutor executor = new FaDepCalExecutor(company.getId().toString());
        return executor._checkBeforeCal(ctx);
    }

    @Override
    protected void _auditBill(Context ctx, String periodID, String companyID, String depInfoID) throws BOSException, EASBizException {
        FaDepCalExecutor executor = new FaDepCalExecutor(companyID);
        if (!executor.ifAlreadyCal(ctx)) {
            throw new EASBizException(new NumericExceptionSubItem("1", executor.getResource(ctx, "com.kingdee.eas.fi.fa.manage.FaDepreciationResource", "FaDepCal_NoAuditEntry")));
        }
        executor._auditBill(ctx, periodID, companyID, depInfoID);
    }

    @Override
    protected boolean _hasCardOfDeprMethodNull(Context ctx, Map hmPara, String companyId) throws BOSException, EASBizException {
        FaDepCalExecutor executor = new FaDepCalExecutor(companyId);
        return executor._hasCardOfDeprMethodNull(ctx, (HashMap)hmPara);
    }

    @Override
    protected boolean _permission(Context ctx, String companyId, String perm) throws BOSException, EASBizException {
        ObjectUuidPK userPk = new ObjectUuidPK(BOSUuid.read((String)ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString()));
        ObjectUuidPK orgPk = new ObjectUuidPK(BOSUuid.read((String)companyId));
        return PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission((IObjectPK)userPk, (IObjectPK)orgPk, perm);
    }

    @Override
    protected boolean _ifAlreadyCal(Context ctx, String comanyId) throws BOSException, EASBizException {
        FaDepCalExecutor executor = new FaDepCalExecutor(comanyId);
        return executor.ifAlreadyCal(ctx);
    }

    @Override
    protected boolean _isAudited(Context ctx, String comanyId) throws BOSException, EASBizException {
        FaDepCalExecutor executor = new FaDepCalExecutor(comanyId);
        return executor.isAudited(ctx);
    }

    @Override
    protected boolean _isVoucherSaved(Context ctx, String comyanyId) throws BOSException, EASBizException {
        FaDepCalExecutor executor = new FaDepCalExecutor(comyanyId);
        return executor.isVoucherSaved(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected HashMap _calDep(Context ctx, HashMap hmPara, String companyId) throws BOSException, EASBizException {
        FaDepCalExecutor executor = null;
        executor = companyId == null || "".equals(companyId) ? new FaDepCalExecutor() : new FaDepCalExecutor(companyId);
        ctx.put((Object)"disablePermissionForKScript", (Object)new Boolean(true));
        try {
            HashMap hashMap = executor._calDep(ctx, hmPara);
            return hashMap;
        }
        finally {
            ctx.put((Object)"disablePermissionForKScript", (Object)new Boolean(false));
        }
    }

    protected void invokeServiceBefore(ServiceContext svcCtx) throws BOSException {
        FaRPCMethodMappingUtils.invokeRPCMethodEventListener(svcCtx, FaAppLogForBusinessTypeEnum.FA_DEP_BATCH, FaMethodCalcOrderEnum.BEFORE);
        super.invokeServiceBefore(svcCtx);
    }

    protected void invokeServiceAfter(ServiceContext svcCtx) throws BOSException {
        FaRPCMethodMappingUtils.invokeRPCMethodEventListener(svcCtx, FaAppLogForBusinessTypeEnum.FA_DEP_BATCH, FaMethodCalcOrderEnum.AFTER);
        super.invokeServiceAfter(svcCtx);
    }
}

