/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.google.gson.internal.LinkedTreeMap;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationEntryCollection;
import com.kingdee.bos.metadata.bot.BOTRelationEntryInfo;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.configure.Project;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ep.client.util.UictUtils;
import com.kingdee.eas.fi.cas.CasWebException;
import com.kingdee.eas.fi.fa.basedata.FaResUtil;
import com.kingdee.eas.fi.fa.facade.app.util.FaServerUtil;
import com.kingdee.eas.fi.fa.manage.FaBillBaseInfo;
import com.kingdee.eas.fi.fa.manage.FaBillBizProcessor;
import com.kingdee.eas.fi.fa.manage.FaBizCardFactory;
import com.kingdee.eas.fi.fa.manage.FaBizCardInfo;
import com.kingdee.eas.fi.fa.manage.FaBizStatusEnum;
import com.kingdee.eas.fi.fa.manage.FaCardException;
import com.kingdee.eas.fi.fa.manage.FaClearBillInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCardCollection;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaDepCalFacadeFactory;
import com.kingdee.eas.fi.fa.manage.FaDepreciationEntryFactory;
import com.kingdee.eas.fi.fa.manage.FaDepreciationFactory;
import com.kingdee.eas.fi.fa.manage.FaDispatchBillCollection;
import com.kingdee.eas.fi.fa.manage.FaDispatchBillEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaDispatchBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaDispatchBillException;
import com.kingdee.eas.fi.fa.manage.FaDispatchBillFactory;
import com.kingdee.eas.fi.fa.manage.FaDispatchBillInfo;
import com.kingdee.eas.fi.fa.manage.FaDispatchDirectionEnum;
import com.kingdee.eas.fi.fa.manage.FaEvalDepreciationEntryFactory;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.IFaCurCard;
import com.kingdee.eas.fi.fa.manage.IFaDispatchBill;
import com.kingdee.eas.fi.fa.manage.app.AbstractFaDispatchBillWebFacadeControllerBean;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.fa.manage.app.PrcFaCoreManager;
import com.kingdee.eas.fi.fa.manage.app.PrcFaDispatchStrategy;
import com.kingdee.eas.fi.fa.manage.common.BatchBillProcessResult;
import com.kingdee.eas.framework.BlockedStatusEnum;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class FaDispatchBillWebFacadeControllerBean
extends AbstractFaDispatchBillWebFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.fa.manage.app.FaDispatchBillWebFacadeControllerBean");
    private String resource = "com.kingdee.eas.fi.fa.manage.FaResource";
    private static final String FA_WE_RESOUSE = "com.kingdee.eas.fi.fa.manage.FaWebResource";
    private static final String FA_DEF_PROJECT_ID = "tBj8Gt3jAcrgQ8CoPwoByiyY1lE=";

    @Override
    protected Map _delete(Context ctx, String[] pks) throws BOSException, EASBizException {
        BatchBillProcessResult resultList = new BatchBillProcessResult();
        PrcFaCoreManager prcFaCoreManager = new PrcFaCoreManager(new PrcFaDispatchStrategy());
        IFaDispatchBill billBase = FaDispatchBillFactory.getLocalInstance(ctx);
        String permissionName = "fa_carddispatch_delete";
        HashMap permissionMap = new HashMap();
        int success = 0;
        for (int i = 0; i < pks.length; ++i) {
            String pk = pks[i];
            try {
                boolean isPermission;
                if (!billBase.exists((IObjectPK)new ObjectUuidPK(pk))) {
                    throw new EASBizException(EASBizException.CHECKEXIST);
                }
                FaDispatchBillInfo outBillInfo = (FaDispatchBillInfo)billBase.getValue((IObjectPK)new ObjectUuidPK(pk), this.getPermissionSelctor());
                if (permissionMap.get(outBillInfo.getCompany().getId().toString()) != null) {
                    HashMap map = (HashMap)permissionMap.get(outBillInfo.getCompany().getId().toString());
                    isPermission = (Boolean)map.get("isPermission");
                    if (!isPermission) {
                        String companyName = (String)map.get("companyName");
                        String number = (String)map.get("number");
                        String msg = MessageFormat.format(EASResource.getString((String)FA_WE_RESOUSE, (String)"NODELETE_THISBILL", (Locale)ctx.getOriginLocale()), companyName);
                        throw new CasWebException(new NumericExceptionSubItem("NODELETE_THISBILL", msg));
                    }
                } else {
                    HashMap<String, Object> companyMap = new HashMap<String, Object>();
                    isPermission = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(outBillInfo.getCompany().getId().toString()), permissionName);
                    companyMap.put("companyName", outBillInfo.getCompany().getName());
                    companyMap.put("isPermission", isPermission);
                    companyMap.put("number", outBillInfo.getNumber());
                    permissionMap.put(outBillInfo.getCompany().getId().toString(), companyMap);
                    if (!isPermission) {
                        String msg = MessageFormat.format(EASResource.getString((String)FA_WE_RESOUSE, (String)"NODELETE_THISBILL", (Locale)ctx.getOriginLocale()), outBillInfo.getCompany().getName());
                        throw new CasWebException(new NumericExceptionSubItem("NODELETE_THISBILL", msg));
                    }
                }
                FaDispatchBillFactory.getLocalInstance(ctx).delete((IObjectPK)new ObjectUuidPK(pk));
                ++success;
                continue;
            }
            catch (Exception e) {
                BatchBillProcessResult result = new BatchBillProcessResult();
                logger.error((Object)e.getMessage());
                e.printStackTrace();
                result.setIconType("error");
                result.setInfo(e.getMessage());
                resultList.getDetailMsgList().add(result);
            }
        }
        if (success == pks.length) {
            String msg = EASResource.getString((String)FA_WE_RESOUSE, (String)"DELETEALL_SUCCESS", (Locale)ctx.getOriginLocale());
            resultList.setSummaryMsg(msg);
        } else {
            String msg = MessageFormat.format(EASResource.getString((String)FA_WE_RESOUSE, (String)"DELETE_SUCCESSFUL_FAILURE", (Locale)ctx.getOriginLocale()), String.valueOf(success), String.valueOf(pks.length - success));
            resultList.setSummaryMsg(msg);
        }
        return resultList;
    }

    @Override
    protected Map _passAudit(Context ctx, String[] pks) throws BOSException, EASBizException {
        IFaDispatchBill billBase = FaDispatchBillFactory.getLocalInstance(ctx);
        BatchBillProcessResult resultList = new BatchBillProcessResult();
        int success = 0;
        String permissionName = "fa_carddispatch_audit";
        HashMap permissionMap = new HashMap();
        for (int i = 0; i < pks.length; ++i) {
            String pkStr = pks[i];
            ObjectUuidPK pk = new ObjectUuidPK(pkStr);
            StringBuffer billNumber = new StringBuffer();
            try {
                boolean isPermission;
                if (!billBase.exists((IObjectPK)pk)) {
                    throw new EASBizException(EASBizException.CHECKEXIST);
                }
                FaDispatchBillInfo outBillInfo = (FaDispatchBillInfo)billBase.getValue((IObjectPK)pk, this.getPassAuditSelector());
                String billNumberStr = EASResource.getString((String)FA_WE_RESOUSE, (String)"BILLNUMBER", (Locale)ctx.getOriginLocale());
                billNumber.append(billNumberStr + outBillInfo.getNumber());
                if (permissionMap.get(outBillInfo.getCompany().getId().toString()) != null) {
                    HashMap map = (HashMap)permissionMap.get(outBillInfo.getCompany().getId().toString());
                    isPermission = (Boolean)map.get("isPermission");
                    if (!isPermission) {
                        String companyName = (String)map.get("companyName");
                        String number = (String)map.get("number");
                        String msg = MessageFormat.format(EASResource.getString((String)FA_WE_RESOUSE, (String)"NOPASSAUDIT_THISBILL", (Locale)ctx.getOriginLocale()), companyName);
                        throw new CasWebException(new NumericExceptionSubItem("NOPASSAUDIT_THISBILL", msg));
                    }
                } else {
                    HashMap<String, Object> companyMap = new HashMap<String, Object>();
                    isPermission = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(outBillInfo.getCompany().getId().toString()), permissionName);
                    companyMap.put("companyName", outBillInfo.getCompany().getName());
                    companyMap.put("isPermission", isPermission);
                    companyMap.put("number", outBillInfo.getNumber());
                    permissionMap.put(outBillInfo.getCompany().getId().toString(), companyMap);
                    if (!isPermission) {
                        String msg = MessageFormat.format(EASResource.getString((String)FA_WE_RESOUSE, (String)"NOPASSAUDIT_THISBILL", (Locale)ctx.getOriginLocale()), outBillInfo.getCompany().getName());
                        throw new CasWebException(new NumericExceptionSubItem("NOPASSAUDIT_THISBILL", msg));
                    }
                }
                FaBillBizProcessor.lockTable(ctx, pk.toString());
                FaBillBaseInfo model = (FaBillBaseInfo)billBase.getValue((IObjectPK)pk, this.getSelfSelctor());
                PrcFaCoreManager prcFaCoreManager = new PrcFaCoreManager(new PrcFaDispatchStrategy());
                prcFaCoreManager.getFaManageStrategy().checkForAudit(ctx, (IObjectPK)pk);
                prcFaCoreManager.getFaManageStrategy().auditBill(ctx, (IObjectValue)model);
                if (outBillInfo.getDispatchDirection() == FaDispatchDirectionEnum.IN) {
                    throw new FaDispatchBillException(FaDispatchBillException.COMPANYNOTMATCH);
                }
                FaDispatchBillEntryCollection outBillEnties = outBillInfo.getFaDispatchBillEntry();
                this.batchUpdateCurCard(ctx, pk.toString(), outBillInfo, "0701", 1);
                billBase.passAuditSelf((IObjectPK)pk, outBillInfo);
                outBillInfo.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
                outBillInfo.setCheckedStatus(CheckedStatusEnum.AUDITED);
                outBillInfo.setAuditTime(new Date());
                outBillInfo.setBizDate(new Date());
                FaDispatchBillInfo inBillInfo = (FaDispatchBillInfo)outBillInfo.clone();
                inBillInfo.setCU(inBillInfo.getInCompany().getCU());
                inBillInfo.setCompany(inBillInfo.getInCompany());
                inBillInfo.setDispatchDirection(FaDispatchDirectionEnum.IN);
                inBillInfo.setRefBillUuid(pk.toString());
                inBillInfo.setId(null);
                inBillInfo.setVoucher(null);
                inBillInfo.setPeriod(FaLocalUtils.getFACurrentPeriod(inBillInfo.getCompany().getId().toString(), ctx));
                inBillInfo.getFaDispatchBillEntry().clear();
                int billEntryCnt = outBillEnties.size();
                for (int j = 0; j < billEntryCnt; ++j) {
                    FaDispatchBillEntryInfo inBillEntry = (FaDispatchBillEntryInfo)outBillEnties.get(j).clone();
                    inBillEntry.setId(null);
                    inBillEntry.setFaDispatchBill(inBillInfo);
                    inBillInfo.getFaDispatchBillEntry().add(inBillEntry);
                }
                IObjectPK inBillInfoPk = billBase.addnew((CoreBaseInfo)inBillInfo);
                outBillInfo.setRefBillUuid(inBillInfoPk.toString());
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("refBillUuid"));
                billBase.updatePartial(outBillInfo, sic);
                ++success;
                continue;
            }
            catch (Exception e) {
                BatchBillProcessResult result = new BatchBillProcessResult();
                logger.error((Object)e.getMessage());
                e.printStackTrace();
                result.setIconType("error");
                result.setInfo(billNumber + "," + e.getMessage());
                resultList.getDetailMsgList().add(result);
            }
        }
        if (success == pks.length) {
            String msg = EASResource.getString((String)FA_WE_RESOUSE, (String)"ALL_PASSAUDIT_SUCCESS", (Locale)ctx.getOriginLocale());
            resultList.setSummaryMsg(msg);
        } else {
            String msg = MessageFormat.format(EASResource.getString((String)FA_WE_RESOUSE, (String)"AUDIT_SUCCESSFUL_FAILURE", (Locale)ctx.getOriginLocale()), String.valueOf(success), String.valueOf(pks.length - success));
            resultList.setSummaryMsg(msg);
        }
        return resultList;
    }

    @Override
    protected Map _unpassAudit(Context ctx, String[] pks) throws BOSException, EASBizException {
        IFaDispatchBill billBase = FaDispatchBillFactory.getLocalInstance(ctx);
        BatchBillProcessResult resultList = new BatchBillProcessResult();
        int success = 0;
        String permissionName = "fa_carddispatch_unaudit";
        HashMap permissionMap = new HashMap();
        for (int i = 0; i < pks.length; ++i) {
            String pkStr = pks[i];
            ObjectUuidPK pk = new ObjectUuidPK(pkStr);
            StringBuffer billNumber = new StringBuffer();
            try {
                boolean isPermission;
                if (!billBase.exists((IObjectPK)pk)) {
                    throw new EASBizException(EASBizException.CHECKEXIST);
                }
                FaDispatchBillInfo outBillInfo = (FaDispatchBillInfo)billBase.getValue((IObjectPK)pk, this.getUnPassAuditSelector());
                String billNumberStr = EASResource.getString((String)FA_WE_RESOUSE, (String)"BILLNUMBER", (Locale)ctx.getOriginLocale());
                billNumber.append(billNumberStr + outBillInfo.getNumber());
                if (permissionMap.get(outBillInfo.getCompany().getId().toString()) != null) {
                    HashMap map = (HashMap)permissionMap.get(outBillInfo.getCompany().getId().toString());
                    isPermission = (Boolean)map.get("isPermission");
                    if (!isPermission) {
                        String companyName = (String)map.get("companyName");
                        String number = (String)map.get("number");
                        String msg = MessageFormat.format(EASResource.getString((String)FA_WE_RESOUSE, (String)"NOUNPASSAUDI_THISBILL", (Locale)ctx.getOriginLocale()), companyName);
                        throw new CasWebException(new NumericExceptionSubItem("NOUNPASSAUDI_THISBILL", msg));
                    }
                } else {
                    HashMap<String, Object> companyMap = new HashMap<String, Object>();
                    isPermission = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(outBillInfo.getCompany().getId().toString()), permissionName);
                    companyMap.put("companyName", outBillInfo.getCompany().getName());
                    companyMap.put("isPermission", isPermission);
                    companyMap.put("number", outBillInfo.getNumber());
                    permissionMap.put(outBillInfo.getCompany().getId().toString(), companyMap);
                    if (!isPermission) {
                        String msg = MessageFormat.format(EASResource.getString((String)FA_WE_RESOUSE, (String)"NOUNPASSAUDI_THISBILL", (Locale)ctx.getOriginLocale()), outBillInfo.getCompany().getName());
                        throw new CasWebException(new NumericExceptionSubItem("NOUNPASSAUDI_THISBILL", msg));
                    }
                }
                FaBillBizProcessor.lockTable(ctx, pk.toString());
                FaBillBaseInfo model = (FaBillBaseInfo)billBase.getValue((IObjectPK)pk, this.getSelfSelctor());
                PrcFaCoreManager prcFaCoreManager = new PrcFaCoreManager(new PrcFaDispatchStrategy());
                prcFaCoreManager.getFaManageStrategy().checkForUnAudit(ctx, (IObjectPK)pk);
                prcFaCoreManager.getFaManageStrategy().unAuditBill(ctx, (IObjectValue)model);
                if (outBillInfo.getDispatchDirection() == FaDispatchDirectionEnum.IN) {
                    throw new FaDispatchBillException(FaDispatchBillException.COMPANYNOTMATCH);
                }
                boolean canUnAudit = true;
                NumericExceptionSubItem dispExption = null;
                if (outBillInfo.isHasAffirmed()) {
                    dispExption = FaDispatchBillException.DISPATCHBILLHASCONFIRMED;
                    canUnAudit = false;
                }
                if (outBillInfo.getFaClearBill() != null && outBillInfo.getFaClearBill().getCheckedStatus() == CheckedStatusEnum.AUDITED) {
                    canUnAudit = false;
                    dispExption = FaDispatchBillException.CLEARBILLHASCONFIRM;
                }
                if (!canUnAudit) {
                    throw new FaDispatchBillException(dispExption);
                }
                IFaDispatchBill iDispatchBill = FaDispatchBillFactory.getLocalInstance(ctx);
                outBillInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
                String inBillInfoPk = outBillInfo.getRefBillUuid();
                outBillInfo.setRefBillUuid(null);
                iDispatchBill.update((IObjectPK)pk, (CoreBaseInfo)outBillInfo);
                this.batchUpdateCurCard(ctx, null, outBillInfo, "0601", 1);
                if (inBillInfoPk != null && inBillInfoPk.trim().length() > 0) {
                    iDispatchBill.deleteSelf((IObjectPK)new ObjectUuidPK(inBillInfoPk));
                }
                billBase.unpassAuditSelf((IObjectPK)pk, outBillInfo);
                ++success;
                continue;
            }
            catch (Exception e) {
                BatchBillProcessResult result = new BatchBillProcessResult();
                logger.error((Object)e.getMessage());
                e.printStackTrace();
                result.setIconType("error");
                result.setInfo(billNumber + "," + e.getMessage());
                resultList.getDetailMsgList().add(result);
            }
        }
        if (success == pks.length) {
            String msg = EASResource.getString((String)FA_WE_RESOUSE, (String)"ALL_UNPASSAUDIT_SUCCESS", (Locale)ctx.getOriginLocale());
            resultList.setSummaryMsg(msg);
        } else {
            String msg = MessageFormat.format(EASResource.getString((String)FA_WE_RESOUSE, (String)"UNAUDIT_SUCCESSFUL_FAILURE", (Locale)ctx.getOriginLocale()), String.valueOf(success), String.valueOf(pks.length - success));
            resultList.setSummaryMsg(msg);
        }
        return resultList;
    }

    protected SelectorItemCollection getSelfSelctor() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("auditor.id"));
        sic.add(new SelectorItemInfo("handler.id"));
        sic.add(new SelectorItemInfo("period.id"));
        return sic;
    }

    protected SelectorItemCollection getPermissionSelctor() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("number"));
        return sic;
    }

    private SelectorItemCollection getPassAuditSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("FaDispatchBillEntry.*"));
        sic.add(new SelectorItemInfo("FaDispatchBillEntry.faBizCard.*"));
        sic.add(new SelectorItemInfo("FaDispatchBillEntry.faCurCard.*"));
        sic.add(new SelectorItemInfo("inCompany.CU.id"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("number"));
        return sic;
    }

    private void batchUpdateCurCard(Context ctx, String pk, FaDispatchBillInfo outBillInfo, String status, int blockedStatus) throws BOSException {
        FaDispatchBillEntryCollection outBillEnties = outBillInfo.getFaDispatchBillEntry();
        int billEntryCnt = outBillEnties.size();
        String[] outBillEntryPks = new String[billEntryCnt];
        for (int i = 0; i < billEntryCnt; ++i) {
            outBillEntryPks[i] = outBillEnties.get(i).getFaCurCard().getId().toString();
        }
        if (billEntryCnt > 0) {
            String[] columns = new String[]{"fbizStatus", "flastBillID", "fBlockedstatus"};
            Object[] values = new Object[]{status, pk, new Integer(blockedStatus)};
            StringBuffer sql = null;
            int size1 = outBillEntryPks.length;
            for (int i = 0; i < size1; ++i) {
                ArrayList<Object> cloneValues = new ArrayList<Object>();
                sql = new StringBuffer("UPDATE T_FA_FACURCARD SET ");
                int size2 = columns.length;
                for (int j = 0; j < size2; ++j) {
                    if (values[j] == null) {
                        sql.append(columns[j] + " = null , ");
                        continue;
                    }
                    sql.append(columns[j] + " = ? , ");
                    cloneValues.add(values[j]);
                }
                String execSql = sql.substring(0, sql.length() - ", ".length()) + " WHERE FID = '" + outBillEntryPks[i] + "'";
                DbUtil.execute((Context)ctx, (String)execSql, (Object[])cloneValues.toArray());
            }
        }
    }

    private SelectorItemCollection getUnPassAuditSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("FaDispatchBillEntry.*"));
        sic.add(new SelectorItemInfo("faClearBill.*"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("number"));
        return sic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _affirmFaDispatchBill(Context ctx, String[] pks) throws BOSException, EASBizException {
        BatchBillProcessResult resultMap = new BatchBillProcessResult();
        IFaDispatchBill iFadispatchbill = FaDispatchBillFactory.getLocalInstance(ctx);
        List<String> list = Arrays.asList(pks);
        ArrayList<String> billids = new ArrayList<String>();
        billids.addAll(list);
        ArrayList refids = this.getRefBillIds(billids, ctx);
        ArrayList allmutexIds = new ArrayList(billids);
        allmutexIds.addAll(refids);
        IFaDispatchBill billBase = FaDispatchBillFactory.getLocalInstance(ctx);
        String permissionName = "fa_carddispatch_affirm";
        HashMap permissionMap = new HashMap();
        try {
            this.requestMutex(allmutexIds, ctx);
            int success = 0;
            int size = billids.size();
            for (int i = 0; i < size; ++i) {
                StringBuffer billNumber = new StringBuffer();
                try {
                    boolean isPermission;
                    if (!billBase.exists((IObjectPK)new ObjectUuidPK(billids.get(i).toString()))) {
                        throw new EASBizException(EASBizException.CHECKEXIST);
                    }
                    FaDispatchBillInfo outBillInfoPer = (FaDispatchBillInfo)billBase.getValue((IObjectPK)new ObjectUuidPK(billids.get(i).toString()), this.getPermissionSelctor());
                    String billNumberStr = EASResource.getString((String)FA_WE_RESOUSE, (String)"BILLNUMBER", (Locale)ctx.getOriginLocale());
                    billNumber.append(billNumberStr + outBillInfoPer.getNumber());
                    if (permissionMap.get(outBillInfoPer.getCompany().getId().toString()) != null) {
                        HashMap map = (HashMap)permissionMap.get(outBillInfoPer.getCompany().getId().toString());
                        isPermission = (Boolean)map.get("isPermission");
                        if (!isPermission) {
                            String companyName = (String)map.get("companyName");
                            String msg = MessageFormat.format(EASResource.getString((String)FA_WE_RESOUSE, (String)"NOAFFIRMF_THISBILL", (Locale)ctx.getOriginLocale()), companyName);
                            throw new CasWebException(new NumericExceptionSubItem("NOAFFIRMF_THISBILL", msg));
                        }
                    } else {
                        HashMap<String, Object> companyMap = new HashMap<String, Object>();
                        isPermission = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(outBillInfoPer.getCompany().getId().toString()), permissionName);
                        companyMap.put("companyName", outBillInfoPer.getCompany().getName());
                        companyMap.put("isPermission", isPermission);
                        companyMap.put("number", outBillInfoPer.getNumber());
                        permissionMap.put(outBillInfoPer.getCompany().getId().toString(), companyMap);
                        if (!isPermission) {
                            String msg = MessageFormat.format(EASResource.getString((String)FA_WE_RESOUSE, (String)"NOAFFIRMF_THISBILL", (Locale)ctx.getOriginLocale()), outBillInfoPer.getCompany().getName());
                            throw new CasWebException(new NumericExceptionSubItem("NOAFFIRMF_THISBILL", msg));
                        }
                    }
                    iFadispatchbill.affirm((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)((String)billids.get(i)))));
                    ++success;
                    continue;
                }
                catch (Exception e) {
                    BatchBillProcessResult result = new BatchBillProcessResult();
                    logger.error((Object)e.getMessage());
                    e.printStackTrace();
                    result.setIconType("error");
                    result.setInfo(billNumber + "," + e.getMessage());
                    resultMap.getDetailMsgList().add(result);
                }
            }
            if (success == billids.size()) {
                String msg = EASResource.getString((String)FA_WE_RESOUSE, (String)"ALL_AFFIRM_SUCCESS", (Locale)ctx.getOriginLocale());
                resultMap.setSummaryMsg(msg);
            } else {
                String msg = MessageFormat.format(EASResource.getString((String)FA_WE_RESOUSE, (String)"AFFIRM_SUCCESSFUL_FAILURE", (Locale)ctx.getOriginLocale()), String.valueOf(success), String.valueOf(pks.length - success));
                resultMap.setSummaryMsg(msg);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            e.printStackTrace();
            resultMap.put("summaryMsg", (resultMap.get("summaryMsg") == null ? "" : resultMap.get("summaryMsg")) + e.getMessage());
            resultMap.put("MsgDetail", e.toString());
        }
        finally {
            IMutexServiceControl mutexService = MutexServiceControlFactory.getLocalInstance((Context)ctx);
            mutexService.batchReleaseObjIDForUpdate(allmutexIds);
        }
        return resultMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _unAffirmFaDispatchBill(Context ctx, String[] pks) throws BOSException, EASBizException {
        BatchBillProcessResult resultMap = new BatchBillProcessResult();
        List<String> list = Arrays.asList(pks);
        ArrayList<String> billids = new ArrayList<String>();
        billids.addAll(list);
        ArrayList refids = this.getRefBillIds(billids, ctx);
        ArrayList allmutexIds = new ArrayList(billids);
        allmutexIds.addAll(refids);
        IFaDispatchBill billBase = FaDispatchBillFactory.getLocalInstance(ctx);
        try {
            this.requestMutex(allmutexIds, ctx);
            IFaDispatchBill iDispatchBill = FaDispatchBillFactory.getLocalInstance(ctx);
            int success = 0;
            String permissionName = "fa_carddispatch_unaffirm";
            HashMap permissionMap = new HashMap();
            int size = billids.size();
            for (int i = 0; i < size; ++i) {
                StringBuffer billNumber = new StringBuffer();
                try {
                    boolean isPermission;
                    if (!billBase.exists((IObjectPK)new ObjectUuidPK(billids.get(i).toString()))) {
                        throw new EASBizException(EASBizException.CHECKEXIST);
                    }
                    FaDispatchBillInfo outBillInfoPer = (FaDispatchBillInfo)billBase.getValue((IObjectPK)new ObjectUuidPK(billids.get(i).toString()), this.getPermissionSelctor());
                    String billNumberStr = EASResource.getString((String)FA_WE_RESOUSE, (String)"BILLNUMBER", (Locale)ctx.getOriginLocale());
                    billNumber.append(billNumberStr + outBillInfoPer.getNumber());
                    if (permissionMap.get(outBillInfoPer.getCompany().getId().toString()) != null) {
                        HashMap map = (HashMap)permissionMap.get(outBillInfoPer.getCompany().getId().toString());
                        isPermission = (Boolean)map.get("isPermission");
                        if (!isPermission) {
                            String companyName = (String)map.get("companyName");
                            String number = (String)map.get("number");
                            String msg = MessageFormat.format(EASResource.getString((String)FA_WE_RESOUSE, (String)"NOUNAFFIRM_THISBILL", (Locale)ctx.getOriginLocale()), companyName);
                            throw new CasWebException(new NumericExceptionSubItem("NOUNAFFIRM_THISBILL", msg));
                        }
                    } else {
                        HashMap<String, Object> companyMap = new HashMap<String, Object>();
                        isPermission = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(outBillInfoPer.getCompany().getId().toString()), permissionName);
                        companyMap.put("companyName", outBillInfoPer.getCompany().getName());
                        companyMap.put("isPermission", isPermission);
                        companyMap.put("number", outBillInfoPer.getNumber());
                        permissionMap.put(outBillInfoPer.getCompany().getId().toString(), companyMap);
                        if (!isPermission) {
                            String msg = MessageFormat.format(EASResource.getString((String)FA_WE_RESOUSE, (String)"NOUNAFFIRM_THISBILL", (Locale)ctx.getOriginLocale()), outBillInfoPer.getCompany().getName());
                            throw new CasWebException(new NumericExceptionSubItem("NOUNAFFIRM_THISBILL", msg));
                        }
                    }
                    FaDispatchBillInfo inBillInfo = iDispatchBill.getFaDispatchBillInfo((IObjectPK)new ObjectUuidPK(billids.get(i).toString()), this.getUnAffirmSelector());
                    FaDispatchBillEntryCollection inBillEnties = inBillInfo.getFaDispatchBillEntry();
                    IEnactmentService service = EnactmentServiceFactory.createRemoteEnactService();
                    if (inBillInfo.getDispatchDirection() == FaDispatchDirectionEnum.OUT) {
                        throw new FaDispatchBillException(FaDispatchBillException.COMPANYNOTMATCH);
                    }
                    if (!inBillInfo.isHasAffirmed()) {
                        throw new FaDispatchBillException(FaDispatchBillException.BILLHASUNCONFIRMED);
                    }
                    for (int j = 0; j < inBillEnties.size(); ++j) {
                        ProcessInstInfo[] procInsts;
                        FaCurCardInfo newCard = inBillEnties.get(j).getNewCard();
                        if (newCard.getCheckedStatus() == CheckedStatusEnum.AUDITED) {
                            throw new FaDispatchBillException(FaDispatchBillException.NEWBILLAUDITED);
                        }
                        if (newCard.getBizStatus() != FaBizStatusEnum.ADDING || (procInsts = service.getProcessInstanceByHoldedObjectId(newCard.getId().toString())).length == 0 || procInsts.length == 1) continue;
                        throw new FaCardException(FaCardException.CANNOT_BE_UNAFFIRM, new Object[]{newCard.getNumber()});
                    }
                    iDispatchBill.unAffirm((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)((String)billids.get(i)))));
                    ++success;
                    continue;
                }
                catch (Exception e) {
                    BatchBillProcessResult result = new BatchBillProcessResult();
                    logger.error((Object)e.getMessage());
                    e.printStackTrace();
                    result.setIconType("error");
                    result.setInfo(billNumber + "," + e.getMessage());
                    resultMap.getDetailMsgList().add(result);
                }
            }
            if (success == pks.length) {
                String msg = EASResource.getString((String)FA_WE_RESOUSE, (String)"ALL_UNAFFIRM_SUCCESS", (Locale)ctx.getOriginLocale());
                resultMap.setSummaryMsg(msg);
            } else {
                String msg = MessageFormat.format(EASResource.getString((String)FA_WE_RESOUSE, (String)"UNAFFIRM_SUCCESSFUL_FAILURE", (Locale)ctx.getOriginLocale()), String.valueOf(success), String.valueOf(pks.length - success));
                resultMap.setSummaryMsg(msg);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            e.printStackTrace();
            resultMap.put("summaryMsg", (resultMap.get("summaryMsg") == null ? "" : resultMap.get("summaryMsg")) + e.getMessage());
            resultMap.put("MsgDetail", e.toString());
        }
        finally {
            IMutexServiceControl mutexService = MutexServiceControlFactory.getLocalInstance((Context)ctx);
            mutexService.batchReleaseObjIDForUpdate(allmutexIds);
        }
        return resultMap;
    }

    private SelectorItemCollection getUnAffirmSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("dispatchDirection"));
        sic.add(new SelectorItemInfo("hasAffirmed"));
        sic.add(new SelectorItemInfo("FaDispatchBillEntry.newCard.checkedStatus"));
        sic.add(new SelectorItemInfo("FaDispatchBillEntry.newCard.bizStatus"));
        sic.add(new SelectorItemInfo("FaDispatchBillEntry.newCard.id"));
        sic.add(new SelectorItemInfo("FaDispatchBillEntry.newCard.number"));
        return sic;
    }

    private ArrayList getRefBillIds(ArrayList billids, Context ctx) throws BOSException {
        if (billids == null || billids.size() == 0) {
            return new ArrayList();
        }
        ArrayList<String> list = new ArrayList<String>();
        StringBuffer idbuff = new StringBuffer();
        int size = billids.size();
        for (int i = 0; i < size; ++i) {
            idbuff.append("'" + billids.get(i) + "',");
        }
        FaDispatchBillCollection billinfos = FaDispatchBillFactory.getLocalInstance(ctx).getFaDispatchBillCollection("select refBillUuid where id in (" + idbuff.substring(0, idbuff.length() - 1) + ")");
        for (int i = 0; i < billinfos.size(); ++i) {
            list.add(billinfos.get(i).getRefBillUuid().toString());
        }
        return list;
    }

    public void requestMutex(List ids, Context ctx) throws EASBizException, BOSException {
        IMutexServiceControl mutexServiceControl = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        boolean flag = true;
        for (int i = 0; i < ids.size(); ++i) {
            flag = mutexServiceControl.requestObjIDForUpdate(ids.get(i).toString());
            if (flag) continue;
            String strInfo = ResourceBase.getString((String)"com.kingdee.eas.fi.ar.ArApBillResource", (String)"DataMutex", (Locale)ctx.getLocale());
            throw new EASBizException(new NumericExceptionSubItem("DataMutex", strInfo));
        }
    }

    @Override
    protected Map _checkFunctionPermission(Context ctx, Map argJsonMap) throws BOSException, EASBizException {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        try {
            String permissionName = (String)argJsonMap.get("permissionName");
            String companyId = (String)argJsonMap.get("companyId");
            boolean isPermission = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(companyId), permissionName);
            result.put("isPermission", isPermission);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            e.printStackTrace();
        }
        return result;
    }

    @Override
    protected Map _addNewCardToEditUiGrid(Context ctx, Map paramMap) throws BOSException, EASBizException {
        HashMap<String, Object> mapResult = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> loadData = new ArrayList<Map<String, Object>>();
        FaDispatchBillEntryCollection currentGridBillCollection = new FaDispatchBillEntryCollection();
        String newSelectedIdSetString = paramMap.get("newSelectedIdSetString").toString();
        String curcardIDsInCurrentDispatchBillEdit = paramMap.get("curcardIDsInCurrentDispatchBillEdit").toString();
        String[] cardIdAfterMerge = new String[]{};
        for (String newSelectedId : cardIdAfterMerge = this.getStringIntersection(newSelectedIdSetString, curcardIDsInCurrentDispatchBillEdit)) {
            FaCurCardInfo curCard = this.getCurCardInfo(newSelectedId, ctx);
            if (this.isNeedDepreciation(curCard, ctx)) {
                mapResult.put("error", FaResUtil.getRes((String)"hasNoDpr"));
                return mapResult;
            }
            EffectedStatusEnum effectedStatus = curCard.getEffectedStatus();
            CheckedStatusEnum checkedStatus = curCard.getCheckedStatus();
            BlockedStatusEnum blockedStatus = curCard.getBlockedStatus();
            DeletedStatusEnum deletedStatus = curCard.getDeletedStatus();
            FaBizStatusEnum bizStatus = curCard.getBizStatus();
            if (effectedStatus == null || effectedStatus != EffectedStatusEnum.EFFECTED || checkedStatus == null || checkedStatus != CheckedStatusEnum.AUDITED || blockedStatus == null || blockedStatus != BlockedStatusEnum.UNBLOCKED || deletedStatus == null || deletedStatus != DeletedStatusEnum.NORMAL || !bizStatus.getValue().endsWith("99")) continue;
            PeriodInfo curPeriod = this.getCurrentPeriod(curCard.getCompany().getId().toString(), ctx);
            boolean isStartDeprTime = curCard.getAssetCat().getDepreciationPolicy().getStartDeprTime().getValue() != 0;
            boolean isDep = FaDepreciationEntryFactory.getLocalInstance(ctx).exists("select fid where LnkFaDepreEntry.period.id='" + curPeriod.getId().toString() + "' and LnkFaDepreEntry.company.id='" + curCard.getCompany().getId().toString() + "' and faCurCard.id='" + curCard.getId().toString() + "'");
            if (!isDep) {
                isDep = FaEvalDepreciationEntryFactory.getLocalInstance(ctx).exists("select fid where LnkFaDepreEntry.period.id='" + curPeriod.getId().toString() + "' and LnkFaDepreEntry.company.id='" + curCard.getCompany().getId().toString() + "' and faCurCard.id='" + curCard.getId().toString() + "'");
            }
            FaDispatchBillEntryInfo billInfo = this.calOtherBillData(curCard, isStartDeprTime, isDep);
            Map<String, Object> row = this.convtDisEntryBillToRow(billInfo);
            loadData.add(row);
        }
        mapResult.put("onloadData", loadData);
        return mapResult;
    }

    private String[] getStringIntersection(String newSelectedIdSetString, String curcardIDsInCurrentDispatchBillEdit) {
        String[] cardIdAfterMerge;
        if (!curcardIDsInCurrentDispatchBillEdit.equals("")) {
            String notRepeatIdStrInNewSelectedCard = "";
            String[] newSelectedIdSetStringArray = newSelectedIdSetString.split(",");
            String[] curcardIDsInCurrentDispatchBillEditArray = curcardIDsInCurrentDispatchBillEdit.split(",");
            for (String newSelectedId : newSelectedIdSetStringArray) {
                boolean isSame = false;
                for (String curcardIDInCurrentDispatchBill : curcardIDsInCurrentDispatchBillEditArray) {
                    if (!newSelectedId.equals(curcardIDInCurrentDispatchBill)) continue;
                    isSame = true;
                }
                if (isSame) continue;
                notRepeatIdStrInNewSelectedCard = notRepeatIdStrInNewSelectedCard + newSelectedId + ",";
            }
            cardIdAfterMerge = (notRepeatIdStrInNewSelectedCard + curcardIDsInCurrentDispatchBillEdit).split(",");
        } else {
            cardIdAfterMerge = newSelectedIdSetString.split(",");
        }
        return cardIdAfterMerge;
    }

    @Override
    protected Map _save(Context ctx, IObjectValue dataObject) throws BOSException, EASBizException {
        HashMap<String, String> resultList = new HashMap<String, String>();
        IObjectPK objectPK = null;
        try {
            FaDispatchBillInfo info = (FaDispatchBillInfo)dataObject;
            FaDispatchBillEntryCollection entryCollection = info.getFaDispatchBillEntry();
            for (int i = 0; i < entryCollection.size(); ++i) {
                FaDispatchBillEntryInfo entryInfo = entryCollection.get(i);
                if (!((Boolean)entryInfo.get("isnewdata")).booleanValue()) {
                    entryInfo.setId(BOSUuid.read((String)entryInfo.get("entryid").toString()));
                }
                FaCurCardInfo faCurCardInfo = this.getFaCurCard(entryInfo);
                entryInfo.setFaCurCard(faCurCardInfo);
                this.setBizCardInfoForEntry(entryInfo, ctx);
            }
            IFaDispatchBill iFaDispatchBill = FaDispatchBillFactory.getLocalInstance(ctx);
            objectPK = this.getSavePk(ctx, iFaDispatchBill, info);
            resultList.put("pkId", objectPK.toString());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            e.printStackTrace();
            resultList.put("summaryMsg", e.getMessage());
            resultList.put("detailMsg", e.toString());
        }
        return resultList;
    }

    public UserInfo chkPermittedUser(Context ctx, BOSUuid companyId, PersonInfo principal, boolean checkClearPermit) throws BOSException, EASBizException {
        IPermission iPermission = PermissionFactory.getLocalInstance((Context)ctx);
        UserCollection userCollection = UserFactory.getLocalInstance((Context)ctx).getUserCollection(" where person = '" + principal.getId() + "'");
        if (userCollection.size() == 0) {
            String releatedUser = checkClearPermit ? FaResUtil.getRes((String)"allocateOut", (Locale)ctx.getOriginLocale()) : FaResUtil.getRes((String)"allocateIn", (Locale)ctx.getOriginLocale());
            throw new FaDispatchBillException(FaDispatchBillException.NOUSRRELEATETOPERSON, new Object[]{releatedUser});
        }
        UserInfo userInfo = null;
        int size = userCollection.size();
        for (int i = 0; i < size; ++i) {
            try {
                if (checkClearPermit) {
                    iPermission.checkFunctionPermission((IObjectPK)new ObjectUuidPK(userCollection.get(i).getId()), (IObjectPK)new ObjectUuidPK(companyId), "fa_cardclean_addnew");
                } else {
                    iPermission.checkFunctionPermission((IObjectPK)new ObjectUuidPK(userCollection.get(i).getId()), (IObjectPK)new ObjectUuidPK(companyId), "fa_card_addNew");
                    iPermission.checkFunctionPermission((IObjectPK)new ObjectUuidPK(userCollection.get(i).getId()), (IObjectPK)new ObjectUuidPK(companyId), "fa_carddispatch_update");
                }
                userInfo = userCollection.get(i);
                break;
            }
            catch (PermissionException e) {
                continue;
            }
        }
        if (userInfo == null) {
            String userName = principal.getName();
            if (checkClearPermit) {
                throw new FaDispatchBillException(FaDispatchBillException.NOPERMADDCLEARBILL, new Object[]{userName});
            }
            throw new FaDispatchBillException(FaDispatchBillException.NOPERMADDCARDMODIDISPATCHBILL, new Object[]{userName});
        }
        return userInfo;
    }

    private IObjectPK getSavePk(Context ctx, IFaDispatchBill iFaDispatchBill, FaDispatchBillInfo info) throws Exception {
        IObjectPK objectPK = null;
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        BOTRelationCollection btpRelationCollection = FaDispatchBillWebFacadeControllerBean.getBOTRelationColFromExtendProperty(ctx, (IObjectValue)info);
        if (info.get("id") != null) {
            if (btpRelationCollection == null || btpRelationCollection.size() == 0) {
                btpRelationCollection = iBTPManager.getRelationCollection(info.get("id").toString());
            }
            objectPK = btpRelationCollection != null && btpRelationCollection.size() > 0 ? iBTPManager.saveRelations((CoreBillBaseInfo)info, btpRelationCollection) : iFaDispatchBill.save((CoreBaseInfo)info);
        } else {
            objectPK = iFaDispatchBill.save((CoreBaseInfo)info);
        }
        return objectPK;
    }

    private IObjectPK getSubmitPk(Context ctx, IFaDispatchBill iFaDispatchBill, FaDispatchBillInfo info) throws Exception {
        IObjectPK objectPK = null;
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        BOTRelationCollection btpRelationCollection = FaDispatchBillWebFacadeControllerBean.getBOTRelationColFromExtendProperty(ctx, (IObjectValue)info);
        if (info.get("id") != null) {
            if (btpRelationCollection == null || btpRelationCollection.size() == 0) {
                btpRelationCollection = iBTPManager.getRelationCollection(info.get("id").toString());
            }
            objectPK = btpRelationCollection != null && btpRelationCollection.size() > 0 ? iBTPManager.submitRelations((CoreBillBaseInfo)info, btpRelationCollection) : iFaDispatchBill.submit((CoreBaseInfo)info);
        } else {
            objectPK = iFaDispatchBill.submit((CoreBaseInfo)info);
        }
        return objectPK;
    }

    public static BOTRelationCollection getBOTRelationColFromExtendProperty(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        if (model == null) {
            return null;
        }
        BOTRelationCollection botCol = new BOTRelationCollection();
        if (model.getExtendedProperty("botrelation") != null) {
            Object o;
            String botrelationStr = model.getExtendedProperty("botrelation");
            ArrayList list = (ArrayList)JSONUtils.convertJsonToObject((Context)ctx, (String)botrelationStr, ArrayList.class);
            for (int i = 0; i < list.size(); ++i) {
                LinkedTreeMap map = (LinkedTreeMap)list.get(i);
                Iterator iterator = map.keySet().iterator();
                BOTRelationInfo info = new BOTRelationInfo();
                while (iterator.hasNext()) {
                    String key = iterator.next().toString();
                    if (map.get((Object)key) == null || "date".equals(key)) continue;
                    if ("isEffected".equals(key)) {
                        info.setIsEffected(false);
                        continue;
                    }
                    if ("relationEntries".equals(key)) {
                        info.put(key, (Object)FaDispatchBillWebFacadeControllerBean.getBOTEntryRelation((ArrayList)map.get((Object)key), info));
                        continue;
                    }
                    info.put(key, map.get((Object)key));
                }
                botCol.add(info);
            }
            if (model.containsKey("relationColl") && !EmptyUtil.isEmpty((Object)(o = model.get("relationColl"))) && o instanceof String) {
                model.put("relationColl", (Object)botCol);
            }
            return botCol;
        }
        return null;
    }

    private static BOTRelationEntryCollection getBOTEntryRelation(ArrayList list, BOTRelationInfo relationinfo) {
        if (list == null || list.size() == 0) {
            return null;
        }
        BOTRelationEntryCollection botCol = new BOTRelationEntryCollection();
        for (int i = 0; i < list.size(); ++i) {
            LinkedTreeMap map = (LinkedTreeMap)list.get(i);
            Iterator iterator = map.keySet().iterator();
            BOTRelationEntryInfo info = new BOTRelationEntryInfo();
            while (iterator.hasNext()) {
                String key = iterator.next().toString();
                if (map.get((Object)key) == null) continue;
                info.put(key, map.get((Object)key));
            }
            info.put("relation", (Object)relationinfo);
            botCol.add(info);
        }
        return botCol;
    }

    private CompanyOrgUnitInfo getCurrentOrgUnitInfo(Context ctx) throws EASBizException, BOSException {
        CompanyOrgUnitInfo mainOrgUnit = null;
        mainOrgUnit = (CompanyOrgUnitInfo)FaServerUtil.getDefaultMainBizOrg((Context)ctx, (OrgType)OrgType.Company, (String)"fa_card_addNew");
        return mainOrgUnit;
    }

    @Override
    protected Map _submit(Context ctx, IObjectValue dataObject) throws BOSException, EASBizException {
        HashMap<String, String> resultList = new HashMap<String, String>();
        IObjectPK objectPK = null;
        try {
            FaDispatchBillInfo info = (FaDispatchBillInfo)dataObject;
            PeriodInfo item = this.getCurrentPeriod(info.getCompany().getId().toString(), ctx);
            info.setPeriod(item);
            BOTRelationCollection relations = new BOTRelationCollection();
            FaDispatchBillEntryCollection entryCollection = info.getFaDispatchBillEntry();
            this.chkPermittedUser(ctx, info.getOutCompany().getId(), info.getOutPrincipal(), true);
            this.chkPermittedUser(ctx, info.getInCompany().getId(), info.getInPrincipal(), false);
            for (int i = 0; i < entryCollection.size(); ++i) {
                FaDispatchBillEntryInfo entryInfo = entryCollection.get(i);
                if (!((Boolean)entryInfo.get("isnewdata")).booleanValue()) {
                    entryInfo.setId(BOSUuid.read((String)entryInfo.get("entryid").toString()));
                }
                FaCurCardInfo faCurCardInfo = this.getFaCurCard(entryInfo);
                entryInfo.setFaCurCard(faCurCardInfo);
                this.setBizCardInfoForEntry(entryInfo, ctx);
            }
            IFaDispatchBill iFaDispatchBill = FaDispatchBillFactory.getLocalInstance(ctx);
            objectPK = this.getSubmitPk(ctx, iFaDispatchBill, info);
            resultList.put("pkId", objectPK.toString());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            e.printStackTrace();
            resultList.put("summaryMsg", e.getMessage());
            resultList.put("detailMsg", e.toString());
        }
        return resultList;
    }

    private void setBizCardInfoForEntry(FaDispatchBillEntryInfo entryInfo, Context ctx) throws EASBizException, BOSException {
        if (entryInfo.get("faBizCardId") == null || entryInfo.get("faBizCardId").toString().equals("")) {
            FaBizCardInfo faBizCardInfo = new FaBizCardInfo();
            FaCurCardInfo curCard = this.getCurCardInfo(entryInfo.get("facurcardid").toString(), ctx);
            faBizCardInfo = FaManageUtils.CurCard2BizCard(curCard);
            faBizCardInfo.setId(BOSUuid.create((BOSObjectType)faBizCardInfo.getBOSType()));
            FaBizCardFactory.getLocalInstance(ctx).save((CoreBaseInfo)faBizCardInfo);
            entryInfo.setFaBizCard(faBizCardInfo);
        } else {
            FaBizCardInfo faBizCardInfo = new FaBizCardInfo();
            faBizCardInfo.setId(BOSUuid.read((String)entryInfo.get("faBizCardId").toString()));
            entryInfo.setFaBizCard(faBizCardInfo);
        }
    }

    private FaCurCardInfo getFaCurCard(FaDispatchBillEntryInfo entryInfo) {
        FaCurCardInfo faCurCardInfo = new FaCurCardInfo();
        faCurCardInfo.setId(BOSUuid.read((String)entryInfo.get("facurcardid").toString()));
        return faCurCardInfo;
    }

    private FaDispatchBillEntryInfo calOtherBillData(FaCurCardInfo curCard, boolean isStartDeprTime, boolean isDep) {
        FaDispatchBillEntryInfo billEntryInfo = new FaDispatchBillEntryInfo();
        billEntryInfo.setFaBizCard(FaManageUtils.CurCard2BizCard(curCard));
        billEntryInfo.setFaCurCard(curCard);
        billEntryInfo.setQuantity(curCard.getAssetAmt());
        billEntryInfo.setAssetValue(curCard.getAssetValue());
        if (!isDep || isStartDeprTime) {
            billEntryInfo.setNeatValue(curCard.getNeatValue());
            billEntryInfo.setAccuDepr(curCard.getAccuDepr());
        } else {
            BigDecimal zero = new BigDecimal("0");
            BigDecimal termDepr = curCard.getDeprTTerm() == null ? zero : curCard.getDeprTTerm();
            billEntryInfo.setNeatValue(curCard.getNeatValue().add(termDepr));
            billEntryInfo.setAccuDepr(curCard.getAccuDepr().subtract(termDepr));
        }
        billEntryInfo.setEvaluateValue(curCard.getInitEvalValue());
        return billEntryInfo;
    }

    protected FaCurCardInfo getCurCardInfo(String curCardID, Context ctx) throws EASBizException, BOSException {
        FaCurCardInfo curCardInfo = new FaCurCardInfo();
        SelectorItemCollection sic = this.getFaDefPropertySelectors(this.getCurCardSelectors(0), ctx);
        curCardInfo = FaCurCardFactory.getLocalInstance(ctx).getFaCurCardInfo((IObjectPK)new ObjectUuidPK(curCardID), sic);
        return curCardInfo;
    }

    private PeriodInfo getCurrentPeriod(String orgIDs, Context ctx) throws BOSException, EASBizException {
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgIDs));
        ArrayList<CompanyOrgUnitInfo> list = new ArrayList<CompanyOrgUnitInfo>();
        list.add(aCompanyOrgUnitInfo);
        HashMap zipData = FaDepreciationFactory.getLocalInstance(ctx).getZipDataForRPC(list);
        PeriodInfo currentPeriod = (PeriodInfo)zipData.get("currPeriod");
        return currentPeriod;
    }

    protected boolean isNeedDepreciation(FaCurCardInfo cardInfo, Context ctx) throws EASBizException, BOSException {
        FaCurCardCollection cardCollection = new FaCurCardCollection();
        cardCollection.add(cardInfo);
        return this.isNeedDepreciation(cardCollection, ctx);
    }

    protected boolean isNeedDepreciation(FaCurCardCollection cardCollection, Context ctx) throws EASBizException, BOSException {
        boolean result = false;
        result = FaDepCalFacadeFactory.getLocalInstance(ctx).isNeedDep(cardCollection);
        return result;
    }

    private Map<String, Object> convtDisEntryBillToRow(FaDispatchBillEntryInfo billInfo) {
        HashMap<String, Object> row = new HashMap<String, Object>();
        row.put("number", billInfo.getFaBizCard().getNumber() == null ? "" : billInfo.getFaBizCard().getNumber());
        row.put("groupNumber", billInfo.getFaBizCard().getGroupNumber() == null ? "" : billInfo.getFaBizCard().getGroupNumber());
        row.put("barCode", billInfo.getFaCurCard().getBarCode() == null ? "" : billInfo.getFaCurCard().getBarCode());
        row.put("assetName", billInfo.getFaBizCard().getAssetName() == null ? "" : billInfo.getFaBizCard().getAssetName());
        row.put("assetCat", billInfo.getFaBizCard().getAssetCat() == null ? "" : billInfo.getFaBizCard().getAssetCat().getName());
        row.put("specs", billInfo.getFaBizCard().getSpecs() == null ? "" : billInfo.getFaBizCard().getSpecs());
        row.put("useStatus", billInfo.getFaBizCard().getUseStatus() == null ? "" : billInfo.getFaBizCard().getUseStatus().getName());
        row.put("storeCity", billInfo.getFaBizCard().getStoreCity() == null ? "" : billInfo.getFaBizCard().getStoreCity().getName());
        row.put("keeper", billInfo.getFaBizCard().getKeeper() == null ? "" : billInfo.getFaBizCard().getKeeper().getName());
        row.put("measureUnit", billInfo.getFaBizCard().getMeasureUnit() == null ? "" : billInfo.getFaBizCard().getMeasureUnit().getName());
        row.put("assetAmt", billInfo.getFaBizCard().getAssetAmt() == null ? "" : billInfo.getFaBizCard().getAssetAmt());
        row.put("quantity", billInfo.getQuantity() == null ? "" : billInfo.getQuantity());
        row.put("assetValue", billInfo.getAssetValue() == null ? "" : billInfo.getAssetValue());
        row.put("accuDepr", billInfo.getAccuDepr() == null ? "" : billInfo.getAccuDepr());
        row.put("neatValue", billInfo.getNeatValue() == null ? "" : billInfo.getNeatValue());
        row.put("evaluateValue", billInfo.getEvaluateValue() == null ? "" : billInfo.getEvaluateValue());
        if (billInfo.getDescription() != null) {
            row.put("description", billInfo.getDescription() == null ? "" : billInfo.getDescription());
        }
        if (billInfo.getFaBizCard().getId() != null) {
            row.put("faBizCardId", billInfo.getFaBizCard() == null ? "" : billInfo.getFaBizCard().getId().toString());
        }
        row.put("faCurCardId", billInfo.getFaCurCard() == null ? "" : billInfo.getFaCurCard().getId().toString());
        row.put("initEvalValue", billInfo.getFaBizCard().getInitEvalValue());
        row.put("isEvaledBefore", billInfo.getFaBizCard().get("isEvaledBefore").toString());
        row.put("calcuByEvaluate", billInfo.getFaBizCard().getAssetCat().get("calcuByEvaluate").toString());
        row.put("isNewData", "true");
        return row;
    }

    public SelectorItemCollection getCurCardSelectors(int cardType) {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("assetCat.id"));
        sic.add(new SelectorItemInfo("assetCat.number"));
        sic.add(new SelectorItemInfo("assetCat.name"));
        sic.add(new SelectorItemInfo("assetCat.useLimit"));
        sic.add(new SelectorItemInfo("assetCat.prePureRate"));
        sic.add(new SelectorItemInfo("assetCat.depreRule"));
        sic.add(new SelectorItemInfo("assetCat.isLeaf"));
        sic.add(new SelectorItemInfo("assetCat.numberRule"));
        sic.add(new SelectorItemInfo("assetCat.calcuByEvaluate"));
        sic.add(new SelectorItemInfo("assetCat.displayName"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.OldChange"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.TotalDeprChange"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.DevalueChange"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.LeaveValueChange"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.ChargeAccoutChange"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.UsedLifeChange"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.DeprMethodChange"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.EvaluateChange"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.CostCenterChange"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.UseStatusChange"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.TailDispose"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.StartDeprTime"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.DeprRule"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.StartDeprTime"));
        sic.add(new SelectorItemInfo("measureUnit.id"));
        sic.add(new SelectorItemInfo("measureUnit.name"));
        sic.add(new SelectorItemInfo("measureUnit.number"));
        sic.add(new SelectorItemInfo("storeCity.id"));
        sic.add(new SelectorItemInfo("storeCity.name"));
        sic.add(new SelectorItemInfo("storeCity.number"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("dept.id"));
        sic.add(new SelectorItemInfo("dept.name"));
        sic.add(new SelectorItemInfo("dept.number"));
        sic.add(new SelectorItemInfo("keeper.id"));
        sic.add(new SelectorItemInfo("keeper.name"));
        sic.add(new SelectorItemInfo("keeper.number"));
        sic.add(new SelectorItemInfo("originType"));
        sic.add(new SelectorItemInfo("originMethod.id"));
        sic.add(new SelectorItemInfo("originMethod.name"));
        sic.add(new SelectorItemInfo("originMethod.number"));
        sic.add(new SelectorItemInfo("originMethod.isLeaf"));
        sic.add(new SelectorItemInfo("useStatus.id"));
        sic.add(new SelectorItemInfo("useStatus.name"));
        sic.add(new SelectorItemInfo("useStatus.number"));
        sic.add(new SelectorItemInfo("useStatus.isLeaf"));
        sic.add(new SelectorItemInfo("useStatus.isDepreciation"));
        sic.add(new SelectorItemInfo("economicPurp.id"));
        sic.add(new SelectorItemInfo("economicPurp.name"));
        sic.add(new SelectorItemInfo("economicPurp.number"));
        sic.add(new SelectorItemInfo("economicPurp.isLeaf"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.isoCode"));
        sic.add(new SelectorItemInfo("currency.sign"));
        sic.add(new SelectorItemInfo("currency.baseUnit"));
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("deprMethod.*"));
        sic.add(new SelectorItemInfo("measureUnitWL.id"));
        sic.add(new SelectorItemInfo("measureUnitWL.name"));
        sic.add(new SelectorItemInfo("measureUnitWL.number"));
        sic.add(new SelectorItemInfo("accountAsset.id"));
        sic.add(new SelectorItemInfo("accountAsset.name"));
        sic.add(new SelectorItemInfo("accountAsset.number"));
        sic.add(new SelectorItemInfo("accountAsset.isLeaf"));
        sic.add(new SelectorItemInfo("accountAccuDepr.id"));
        sic.add(new SelectorItemInfo("accountAccuDepr.name"));
        sic.add(new SelectorItemInfo("accountAccuDepr.number"));
        sic.add(new SelectorItemInfo("accountAccuDepr.isLeaf"));
        sic.add(new SelectorItemInfo("accountDecValue.id"));
        sic.add(new SelectorItemInfo("accountDecValue.name"));
        sic.add(new SelectorItemInfo("accountDecValue.number"));
        sic.add(new SelectorItemInfo("accountDecValue.isLeaf"));
        sic.add(new SelectorItemInfo("company.baseCurrency.*"));
        sic.add(new SelectorItemInfo("accountAsset.longName"));
        sic.add(new SelectorItemInfo("accountAccuDepr.longName"));
        sic.add(new SelectorItemInfo("accountDecValue.longName"));
        sic.add(new SelectorItemInfo("period.beginDate"));
        sic.add(new SelectorItemInfo("period.endDate"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("evalDeprMode.number"));
        sic.add(new SelectorItemInfo("evalDeprMode.name"));
        sic.add(new SelectorItemInfo("evalDeprMode.isWorkload"));
        sic.add(new SelectorItemInfo("evalDeprMode.isCustom"));
        sic.add(new SelectorItemInfo("evalDeprMode.depValuePolicy"));
        sic.add(new SelectorItemInfo("evalDeprMode.id"));
        sic.add(new SelectorItemInfo("evalDeprMode.period"));
        sic.add(new SelectorItemInfo("evalDeprPeriodNum"));
        sic.add(new SelectorItemInfo("evalMonthRate"));
        sic.add(new SelectorItemInfo("evalAddDepr"));
        sic.add(new SelectorItemInfo("evalRemValue"));
        sic.add(new SelectorItemInfo("evalYearDepr"));
        sic.add(new SelectorItemInfo("evalDecValue"));
        sic.add(new SelectorItemInfo("evalUseTermCount"));
        sic.add(new SelectorItemInfo("evalNeatValue"));
        sic.add(new SelectorItemInfo("evalNeatAmt"));
        sic.add(new SelectorItemInfo("evalAssetValue"));
        sic.add(new SelectorItemInfo("evalTaxLeftPeriod"));
        sic.add(new SelectorItemInfo("evalDeprTTerm"));
        sic.add(new SelectorItemInfo("evalNeatLeftRate"));
        String card = cardType == 0 ? "faCur" : (cardType == 1 ? "faBiz" : "faBak");
        sic.add(card + "Facility.id");
        sic.add(card + "Facility.seq");
        sic.add(card + "Facility.facilityNumber");
        sic.add(card + "Facility.facilityName");
        sic.add(card + "Facility.facilityModel");
        sic.add(card + "Facility.registerDate");
        sic.add(card + "Facility.quantity");
        sic.add(card + "Facility.amount");
        sic.add(card + "Facility.remark");
        sic.add(card + "Facility.measureUnit.id");
        sic.add(card + "Facility.measureUnit.number");
        sic.add(card + "Facility.measureUnit.name");
        sic.add(card + "Facility.storePlace.id");
        sic.add(card + "Facility.storePlace.name");
        sic.add(card + "Facility.storePlace.number");
        sic.add(card + "Facility.keeper.name");
        sic.add(card + "Facility.keeper.number");
        sic.add(card + "CostCenter.id");
        sic.add(card + "CostCenter.apportionScale");
        sic.add(card + "CostCenter.accountView.name");
        sic.add(card + "CostCenter.accountView.number");
        sic.add(card + "CostCenter.accountView.isLeaf");
        sic.add(card + "CostCenter." + card + "AsstActComposit.seq");
        sic.add(card + "CostCenter." + card + "AsstActComposit.asstActType.*");
        sic.add(card + "CostCenter." + card + "AsstActComposit.asstActItem.*");
        sic.add(card + "CostCenter.asstActType.*");
        sic.add(card + "CostCenter.asstActItem.*");
        sic.add(card + "CostCenter.seq");
        sic.add(card + "CostCenter.remark");
        sic.add(card + "CostCenter.accountView.longName");
        sic.add(card + "Department.id");
        sic.add(card + "Department.usage");
        sic.add(card + "Department.remark");
        sic.add(card + "Department.useDepartment.id");
        sic.add(card + "Department.useDepartment.name");
        sic.add(card + "Department.useDepartment.number");
        sic.add(card + "Department.useDepartment.displayName");
        sic.add(card + "Department.usePerson.id");
        sic.add(card + "Department.usePerson.name");
        sic.add(card + "Department.usePerson.name");
        sic.add(card + "Department.usePerson.number");
        return sic;
    }

    private SelectorItemCollection getFaDefPropertySelectors(SelectorItemCollection sic, Context ctx) {
        EntityObjectInfo pv = FaDispatchBillWebFacadeControllerBean.loadEntity("com.kingdee.eas.fi.fa.def.app.FaDefPropertyValue", ctx);
        PropertyCollection propertyCol = pv.getProperties();
        if (propertyCol.size() > 0) {
            for (int i = 0; i < propertyCol.size(); ++i) {
                PropertyInfo info = propertyCol.get(i);
                if (info instanceof LinkPropertyInfo) {
                    sic.add("propertyValue." + info.getName() + ".id");
                    sic.add("propertyValue." + info.getName() + ".number");
                    sic.add("propertyValue." + info.getName() + ".name");
                    continue;
                }
                sic.add("propertyValue." + info.getName());
            }
        }
        sic.add("propertyValue.id");
        return sic;
    }

    private static EntityObjectInfo loadEntity(String pk, Context ctx) {
        Project depend = new Project(FA_DEF_PROJECT_ID);
        if (ctx == null) {
            return UictUtils.loadEntity((IMetaDataPK)new MetaDataPK(pk), (Project)depend);
        }
        IMetaDataLoader loader = FaDispatchBillWebFacadeControllerBean.getMDloader(ctx);
        BOSObjectType type = MetaDataTypeList.ENTITY;
        Project.Projects projects = Project.Projects.getProjects((Project[])new Project[]{depend}, null);
        EntityObjectInfo entity = (EntityObjectInfo)loader.get(type, (IMetaDataPK)MetaDataPK.create((String)pk), projects);
        return entity;
    }

    private static IMetaDataLoader getMDloader(Context ctx) {
        return MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
    }

    @Override
    protected Map _calcDispAmount(Context ctx, Map argJsonMap) throws EASBizException, BOSException {
        HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>();
        String faCurcardId = (String)argJsonMap.get("faCurcardId");
        String currencyPrecisionStr = argJsonMap.get("currencyPrecision").toString();
        int currencyPrecision = Integer.parseInt(currencyPrecisionStr);
        String dispCountStr = (String)argJsonMap.get("quantity");
        BigDecimal dispCount = new BigDecimal(dispCountStr);
        String isEvaledBeforeStr = (String)argJsonMap.get("isEvaledBefore");
        String calcuByEvaluateStr = (String)argJsonMap.get("calcuByEvaluate");
        String companyId = (String)argJsonMap.get("companyId");
        String curCardIsDep = (String)argJsonMap.get("curCardIsDep");
        String faCurCardAssetAmtStr = (String)argJsonMap.get("faCurCardAssetAmt");
        BigDecimal faCurCardAssetAmt = new BigDecimal(faCurCardAssetAmtStr);
        String depStartDeprTimeValueStr = (String)argJsonMap.get("depStartDeprTimeValue");
        String faCurCardAssetValueStr = (String)argJsonMap.get("faCurCardAssetValue");
        BigDecimal faCurCardAssetValue = new BigDecimal(faCurCardAssetValueStr);
        String faCurCardAccuDeprStr = (String)argJsonMap.get("faCurCardAccuDepr");
        BigDecimal faCurCardAccuDepr = new BigDecimal(faCurCardAccuDeprStr);
        String faCurCardDeprTTermStr = (String)argJsonMap.get("faCurCardDeprTTerm");
        BigDecimal faCurCardDeprTTerm = new BigDecimal(faCurCardDeprTTermStr);
        String faCurCardInitEvalValueStr = (String)argJsonMap.get("faCurCardInitEvalValue");
        BigDecimal faCurCardInitEvalValue = new BigDecimal(faCurCardInitEvalValueStr);
        BigDecimal assetAmt = faCurCardAssetAmt;
        int scale = currencyPrecision;
        boolean isStartDeprTime = Integer.parseInt(depStartDeprTimeValueStr) != 0;
        boolean isDep = Boolean.valueOf(curCardIsDep);
        result.put("assetValue", faCurCardAssetValue.multiply(dispCount).divide(assetAmt, scale, 4));
        BigDecimal accuDepr = faCurCardAccuDepr;
        if (isDep && !isStartDeprTime) {
            BigDecimal zero = new BigDecimal("0");
            BigDecimal termDepr = faCurCardDeprTTerm == null ? zero : faCurCardDeprTTerm;
            accuDepr = accuDepr.subtract(termDepr);
        }
        result.put("accuDepr", accuDepr.multiply(dispCount).divide(assetAmt, scale, 4));
        result.put("evaluateValue", faCurCardInitEvalValue.multiply(dispCount).divide(assetAmt, scale, 4));
        boolean isEvaledBefore = Boolean.valueOf(isEvaledBeforeStr);
        boolean calcuByEvaluate = Boolean.valueOf(calcuByEvaluateStr);
        isEvaledBefore = isEvaledBefore && calcuByEvaluate;
        BigDecimal neatValue = isEvaledBefore ? ((BigDecimal)result.get("evaluateValue")).subtract((BigDecimal)result.get("accuDepr")) : ((BigDecimal)result.get("assetValue")).subtract((BigDecimal)result.get("accuDepr"));
        result.put("neatValue", neatValue);
        return result;
    }

    @Override
    protected Map _getFaCurCardGridData(Context ctx, Map argJsonMap) throws BOSException, EASBizException {
        HashMap<String, Comparable<Boolean>> result = new HashMap<String, Comparable<Boolean>>();
        String faCurcardId = (String)argJsonMap.get("faCurcardId");
        IFaCurCard billBase = FaCurCardFactory.getLocalInstance(ctx);
        FaCurCardInfo curCard = (FaCurCardInfo)billBase.getValue((IObjectPK)new ObjectUuidPK(faCurcardId), this.getFaCurCardInfoSelector());
        PeriodInfo curPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)curCard.getCompany());
        boolean isDep = FaDepreciationEntryFactory.getLocalInstance(ctx).exists("select fid where LnkFaDepreEntry.period.id='" + curPeriod.getId().toString() + "' and LnkFaDepreEntry.company.id='" + curCard.getCompany().getId().toString() + "' and faCurCard.id='" + curCard.getId().toString() + "'");
        if (!isDep) {
            isDep = FaEvalDepreciationEntryFactory.getLocalInstance(ctx).exists("select fid where LnkFaDepreEntry.period.id='" + curPeriod.getId().toString() + "' and LnkFaDepreEntry.company.id='" + curCard.getCompany().getId().toString() + "' and faCurCard.id='" + curCard.getId().toString() + "'");
        }
        result.put("curCardIsDep", Boolean.valueOf(isDep));
        result.put("depStartDeprTimeValue", Integer.valueOf(curCard.getAssetCat().getDepreciationPolicy().getStartDeprTime().getValue()));
        result.put("assetAmt", (Comparable<Boolean>)((Object)(curCard.getAssetAmt() == null ? Integer.valueOf(0) : curCard.getAssetAmt())));
        result.put("assetValue", (Comparable<Boolean>)((Object)(curCard.getAssetValue() == null ? Integer.valueOf(0) : curCard.getAssetValue())));
        result.put("accuDepr", (Comparable<Boolean>)((Object)(curCard.getAccuDepr() == null ? Integer.valueOf(0) : curCard.getAccuDepr())));
        result.put("deprTTerm", (Comparable<Boolean>)((Object)(curCard.getDeprTTerm() == null ? Integer.valueOf(0) : curCard.getDeprTTerm())));
        result.put("initEvalValue", (Comparable<Boolean>)((Object)(curCard.getInitEvalValue() == null ? Integer.valueOf(0) : curCard.getInitEvalValue())));
        return result;
    }

    private SelectorItemCollection getFaCurCardInfoSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.StartDeprTime"));
        return sic;
    }

    @Override
    protected String _checkFunctionAdd(Context ctx, Map argJsonMap) throws BOSException, EASBizException {
        boolean isPermission;
        String companyId = (String)argJsonMap.get("companyId");
        if (companyId != null) {
            companyId = companyId.split(",")[0];
        }
        if (!(isPermission = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(companyId), "fa_carddispatch_addnew"))) {
            String msg = EASResource.getString((String)FA_WE_RESOUSE, (String)"NO_ADD_PERMISSION", (Locale)ctx.getOriginLocale());
            throw new CasWebException(new NumericExceptionSubItem("NO_ADD_PERMISSION", msg));
        }
        SelectorItemCollection sic = FaServerUtil.getOrgInfoSelector((OrgType)OrgType.Company);
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId), sic);
        if (company.getInvalidDate() != null && DateTimeUtils.dayBefore((Date)company.getInvalidDate(), (Date)new Date())) {
            throw new CasWebException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"Company_Disabled", (Locale)ctx.getOriginLocale())));
        }
        PeriodInfo currenctPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (IObjectPK)new ObjectUuidPK(companyId));
        if (currenctPeriod == null) {
            String strMsg = EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"notConfigStartPeriod", (Locale)ctx.getOriginLocale());
            throw new CasWebException(new NumericExceptionSubItem("1", strMsg));
        }
        Boolean isInitEnd = SystemStatusCtrolUtils.isStart((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (IObjectPK)new ObjectUuidPK(companyId));
        if (!isInitEnd.booleanValue()) {
            String strMsg = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"FaCurCardEditUI_FANotEndInit", (Locale)ctx.getOriginLocale());
            throw new CasWebException(new NumericExceptionSubItem("1", strMsg));
        }
        FaDispatchBillInfo baseInfo = new FaDispatchBillInfo();
        ICodingRuleManager iCodingRuleManager = null;
        if (baseInfo.getCompany() == null) {
            baseInfo.setCompany(company);
        }
        iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        boolean isCodingRule = iCodingRuleManager.isExist((IObjectValue)baseInfo, company.getId().toString());
        boolean isViewCodeRule = iCodingRuleManager.isAddView((IObjectValue)baseInfo, company.getId().toString());
        return "success";
    }

    @Override
    protected boolean _checkForEdit(Context ctx, Map argJsonMap) throws BOSException, EASBizException {
        String billId = (String)argJsonMap.get("billId");
        FaDispatchBillInfo info = new FaDispatchBillInfo();
        info.setId(BOSUuid.read((String)billId));
        PrcFaCoreManager prcFaCoreManager = new PrcFaCoreManager(new PrcFaDispatchStrategy());
        try {
            prcFaCoreManager.getFaManageStrategy().checkForEdit(ctx, (IObjectValue)info);
            IFaDispatchBill billBase = FaDispatchBillFactory.getLocalInstance(ctx);
            FaDispatchBillInfo outBillInfo = (FaDispatchBillInfo)billBase.getValue((IObjectPK)new ObjectUuidPK(billId), this.getPermissionSelctor());
            ObjectUuidPK comapnyPK = new ObjectUuidPK(outBillInfo.getCompany().getId());
            ObjectUuidPK curUserPK = new ObjectUuidPK(((UserInfo)ctx.get((Object)"UserInfo")).getId());
            if (!PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission((IObjectPK)curUserPK, (IObjectPK)comapnyPK, "fa_carddispatch_update")) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)e.getMessage());
            return false;
        }
        return true;
    }

    @Override
    protected Map _dispatchDateOnChange(Context ctx, Map argJsonMap) throws BOSException, EASBizException {
        HashMap<String, String> result = new HashMap<String, String>();
        Date changeDate = (Date)argJsonMap.get("changeDate");
        String companyId = (String)argJsonMap.get("companyId");
        try {
            CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
            company.setId(BOSUuid.read((String)companyId));
            PeriodInfo aPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)company);
            if (aPeriodInfo != null && (DateTimeUtils.dayBefore((Date)changeDate, (Date)aPeriodInfo.getBeginDate()) || DateTimeUtils.dayAfter((Date)changeDate, (Date)aPeriodInfo.getEndDate()))) {
                String msg = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"FaDispatchBillEditUI_DispatchDateError", (Locale)ctx.getOriginLocale());
                throw new CasWebException(new NumericExceptionSubItem("FaDispatchBillEditUI_DispatchDateError", msg));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            e.printStackTrace();
            result.put("summaryMsg", e.getMessage());
            result.put("detailMsg", e.toString());
        }
        return result;
    }

    @Override
    protected Map _inCompanyOnChange(Context ctx, Map argJsonMap) throws BOSException, EASBizException {
        HashMap<String, String> result = new HashMap<String, String>();
        String inCompanyId = (String)argJsonMap.get("inCompanyId");
        CompanyOrgUnitInfo inCompany = new CompanyOrgUnitInfo();
        inCompany.setId(BOSUuid.read((String)inCompanyId));
        String outCompanyId = (String)argJsonMap.get("outCompanyId");
        CompanyOrgUnitInfo outCompany = new CompanyOrgUnitInfo();
        outCompany.setId(BOSUuid.read((String)outCompanyId));
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(inCompanyId));
        if (!aCompanyOrgUnitInfo.isIsBizUnit()) {
            throw new EASBizException(new NumericExceptionSubItem("DataMutex", EASResource.getString((String)this.resource, (String)"curCompanyIsVirtual", (Locale)ctx.getOriginLocale())));
        }
        boolean isInitEnd = SystemStatusCtrolUtils.isStart(null, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)inCompany);
        if (!isInitEnd) {
            String msg = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"FaDispatchInCompany", (Locale)ctx.getOriginLocale());
            msg = msg + EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"FaCurCardEditUI_FANotEndInit", (Locale)ctx.getOriginLocale());
            throw new CasWebException(new NumericExceptionSubItem("FaCurCardEditUI_FANotEndInit", msg));
        }
        PeriodInfo periodOut = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)outCompany);
        PeriodInfo periodIn = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)inCompany);
        if (periodIn == null) {
            String strMsg = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"FaDispatchInCompany", (Locale)ctx.getOriginLocale()) + EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardInitResource", (String)"FaCardPeriodIsNull", (Locale)ctx.getOriginLocale());
            throw new CasWebException(new NumericExceptionSubItem("FaCardPeriodIsNull", strMsg));
        }
        if (periodOut.getPeriodYear() != periodIn.getPeriodYear() || periodOut.getPeriodNumber() != periodIn.getPeriodNumber()) {
            String msg_currentPeriod = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"CurrentPeriodIs", (Locale)ctx.getOriginLocale());
            String msg_year = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose", (String)"year", (Locale)ctx.getOriginLocale());
            String msg_period = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose", (String)"period", (Locale)ctx.getOriginLocale());
            String msg_outCompany = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"FaDispatchOutCompany", (Locale)ctx.getOriginLocale());
            String msg_inCompany = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"FaDispatchInCompany", (Locale)ctx.getOriginLocale());
            String msg_notSamePeriodForDispatch = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"NotSamePeriodForDispatch", (Locale)ctx.getOriginLocale());
            String strMsg = msg_outCompany + msg_currentPeriod + periodOut.getPeriodYear() + msg_year + periodOut.getPeriodNumber() + msg_period + "\uff0c" + msg_inCompany + msg_currentPeriod + periodIn.getPeriodYear() + msg_year + periodIn.getPeriodNumber() + msg_period + "\uff0c" + msg_notSamePeriodForDispatch;
            throw new CasWebException(new NumericExceptionSubItem("msg_notSamePeriodForDispatch", strMsg));
        }
        result.put("status", "success");
        return result;
    }

    @Override
    protected Map _checkBeforeTraceDown(Context ctx, Map argJsonMap) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            String modelID = (String)argJsonMap.get("modelID");
            String msgTxt = FaResUtil.getRes((String)"noDestinationBill");
            IFaDispatchBill iFadispatchBill = FaDispatchBillFactory.getLocalInstance(ctx);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("inCompany.id"));
            sic.add(new SelectorItemInfo("FaDispatchBillEntry.newCard.id"));
            sic.add(new SelectorItemInfo("faClearBill"));
            sic.add(new SelectorItemInfo("faClearBill.id"));
            sic.add(new SelectorItemInfo("checkedStatus"));
            sic.add(new SelectorItemInfo("company.id"));
            FaDispatchBillInfo billInfo = iFadispatchBill.getFaDispatchBillInfo((IObjectPK)new ObjectUuidPK(modelID), sic);
            FaDispatchBillEntryCollection billEnties = billInfo.getFaDispatchBillEntry();
            if (billInfo.getCheckedStatus().getValue() != 2) {
                result.put("summaryMsg", msgTxt);
                return result;
            }
            Vector<String> v1 = new Vector<String>();
            if (billInfo.getCompany().getId().toString().equals(billInfo.getInCompany().getId().toString())) {
                int size = billEnties.size();
                for (int i = 0; i < size; ++i) {
                    FaDispatchBillEntryInfo billEntry = billEnties.get(i);
                    if (billEntry.getNewCard() == null) {
                        result.put("summaryMsg", msgTxt);
                        return result;
                    }
                    String newCardId = billEntry.getNewCard().getId().toString();
                    v1.add(newCardId);
                }
                if (v1.size() > 0) {
                    result.put("idList", v1);
                    result.put("uipk", "com.kingdee.eas.fi.fa.FaCurCardBillTraceDown");
                } else {
                    MsgBox.showInfo((String)msgTxt);
                }
            } else {
                FaClearBillInfo clearBillInfo = billInfo.getFaClearBill();
                if (clearBillInfo == null) {
                    result.put("summaryMsg", msgTxt);
                    return result;
                }
                v1.add(clearBillInfo.getId().toString());
                result.put("idList", v1);
                result.put("uipk", "com.kingdee.eas.fi.fa.FaClearBillTraceDown");
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            e.printStackTrace();
            result.put("summaryMsg", e.getMessage());
            result.put("detailMsg", e.toString());
        }
        return result;
    }

    @Override
    protected Map _getPermissionsByCompany(Context ctx, Map argJsonMap) throws BOSException, EASBizException {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        String companyId = (String)argJsonMap.get("companyId");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("companyId", companyId);
        try {
            String addPermission = this._checkFunctionAdd(ctx, map);
            if (addPermission.equals("success")) {
                result.put("addPermission", true);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            e.printStackTrace();
            result.put("addPermission", false);
        }
        boolean updatePermission = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(companyId), "fa_carddispatch_update");
        if (updatePermission) {
            result.put("updatePermission", true);
        } else {
            result.put("updatePermission", false);
        }
        boolean deletePermission = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(companyId), "fa_carddispatch_delete");
        if (deletePermission) {
            result.put("deletePermission", true);
        } else {
            result.put("deletePermission", false);
        }
        boolean auditPermission = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(companyId), "fa_carddispatch_audit");
        if (auditPermission) {
            result.put("auditPermission", true);
        } else {
            result.put("auditPermission", false);
        }
        boolean unAuditPermission = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(companyId), "fa_carddispatch_unaudit");
        if (unAuditPermission) {
            result.put("unAuditPermission", true);
        } else {
            result.put("unAuditPermission", false);
        }
        return result;
    }

    private void checkForUseWorkFlow(Context ctx, FaDispatchBillInfo billInfo) throws FaCardException, EASBizException, BOSException {
        if (FaManageUtils.isUseWorkflow(ctx, billInfo.getCompany().getId().toString(), this.getClass())) {
            String msg = ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"WORKFLOW_ENABLE", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{billInfo.getCompany().getName() + "\uff08" + billInfo.getCompany().getNumber() + "\uff09", billInfo.getNumber()});
            throw new EASBizException(new NumericExceptionSubItem("01", msg));
        }
    }

    private void checkAuditWithWorkFlow(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        FaDispatchBillInfo faDispatchBillInfo;
        if (model == null) {
            model = FaDispatchBillFactory.getLocalInstance(ctx).getFaDispatchBillInfo(pk, new SelectorItemCollection());
        }
        if ((faDispatchBillInfo = (FaDispatchBillInfo)model) == null) {
            throw new IllegalArgumentException();
        }
        SelectorItemCollection sicOfChangeBill = new SelectorItemCollection();
        sicOfChangeBill.add(new SelectorItemInfo("number"));
        sicOfChangeBill.add(new SelectorItemInfo("company.id"));
        sicOfChangeBill.add(new SelectorItemInfo("company.name"));
        sicOfChangeBill.add(new SelectorItemInfo("company.number"));
        faDispatchBillInfo = FaDispatchBillFactory.getLocalInstance(ctx).getFaDispatchBillInfo((IObjectPK)new ObjectUuidPK(faDispatchBillInfo.getId()), sicOfChangeBill);
        this.checkForUseWorkFlow(ctx, faDispatchBillInfo);
    }
}

