/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.ServiceContext;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.dap.DAPTransformResult;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.basedata.FaEvaItemAssetInfo;
import com.kingdee.eas.fi.fa.basedata.FaEvaItemOddUseLifeInfo;
import com.kingdee.eas.fi.fa.basedata.FaEvaSchemeInfo;
import com.kingdee.eas.fi.fa.basedata.FaUtils;
import com.kingdee.eas.fi.fa.manage.FaAppLogForBusinessTypeEnum;
import com.kingdee.eas.fi.fa.manage.FaBillBizProcessor;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaEvaSumCollection;
import com.kingdee.eas.fi.fa.manage.FaEvaSumFactory;
import com.kingdee.eas.fi.fa.manage.FaEvaSumInfo;
import com.kingdee.eas.fi.fa.manage.FaEvaluateBillEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaEvaluateBillException;
import com.kingdee.eas.fi.fa.manage.FaEvaluateBillFactory;
import com.kingdee.eas.fi.fa.manage.FaEvaluateBillInfo;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.FaPublishedStatusEnum;
import com.kingdee.eas.fi.fa.manage.app.AbstractFaEvaluateBillControllerBean;
import com.kingdee.eas.fi.fa.manage.app.AbstractPrcFaManageStrategy;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.fa.manage.app.PrcFaCoreManager;
import com.kingdee.eas.fi.fa.manage.app.PrcFaEvaStrategy;
import com.kingdee.eas.fi.fa.manage.app.falog.event.FaMethodCalcOrderEnum;
import com.kingdee.eas.fi.fa.manage.app.falog.utils.FaRPCMethodMappingUtils;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class FaEvaluateBillControllerBean
extends AbstractFaEvaluateBillControllerBean {
    private static final BigDecimal ZERO = new BigDecimal("0");

    @Override
    protected AbstractPrcFaManageStrategy getBillStrategy() {
        return new PrcFaEvaStrategy();
    }

    @Override
    public String getMasterTable() {
        return "T_FA_FaEvaluateBill";
    }

    @Override
    protected void _publish(Context ctx, IObjectPK id) throws BOSException, EASBizException {
        FaEvaluateBillInfo info = this.getFaEvaluateBillInfo(ctx, "select id,publishedStatus,checkedStatus,company.id,period.id where id ='" + id + "'");
        FaLocalUtils.checkPeriodConsistent(ctx, info.getCompany(), info.getPeriod(), true);
        if (info.getCheckedStatus() == CheckedStatusEnum.UNAUDITED) {
            throw new FaEvaluateBillException(FaEvaluateBillException.BILL_UNAUDIT);
        }
        if (info.getPublishedStatus() == FaPublishedStatusEnum.PUBLISHED) {
            throw new FaEvaluateBillException(FaEvaluateBillException.BILL_HAS_PUBLISH);
        }
        info.setPublishedStatus(FaPublishedStatusEnum.PUBLISHED);
        SelectorItemCollection sic = this.getPublishSelector();
        this.updatePartial(ctx, info, sic);
    }

    @Override
    protected void _unPublish(Context ctx, IObjectPK id) throws BOSException, EASBizException {
        FaEvaluateBillInfo info = this.getFaEvaluateBillInfo(ctx, "select id,publishedStatus,checkedStatus,company.id,period.id where id ='" + id + "'");
        FaLocalUtils.checkPeriodConsistent(ctx, info.getCompany(), info.getPeriod(), true);
        if (info.getCheckedStatus() == CheckedStatusEnum.UNAUDITED) {
            throw new FaEvaluateBillException(FaEvaluateBillException.BILL_UNAUDIT);
        }
        if (info.getPublishedStatus() == FaPublishedStatusEnum.UNPUBLISHED) {
            throw new FaEvaluateBillException(FaEvaluateBillException.BILL_HAS_UNPUBLISH);
        }
        info.setPublishedStatus(FaPublishedStatusEnum.UNPUBLISHED);
        SelectorItemCollection sic = this.getPublishSelector();
        this.updatePartial(ctx, info, sic);
    }

    @Override
    protected List _hasChanged(Context ctx, List ids, FaEvaSchemeInfo evaScheme, PeriodInfo period) throws BOSException, EASBizException {
        ArrayList<String> result = new ArrayList<String>();
        if (evaScheme == null || ids == null || ids.size() == 0) {
            return result;
        }
        List evaItemList = FaUtils.getItemInfo((String)evaScheme.getFaEvaItem());
        boolean isAssetEva = evaItemList.contains(new FaEvaItemAssetInfo());
        boolean isOddUseLifeEva = evaItemList.contains(new FaEvaItemOddUseLifeInfo());
        if (isAssetEva || isOddUseLifeEva) {
            try {
                StringBuffer selectCause = new StringBuffer("select bizCard.fnumber ");
                StringBuffer whereCause = new StringBuffer("where (");
                if (isAssetEva) {
                    whereCause.append("bizCard.fAssetValue - bakCard.fAssetValue != 0 ");
                }
                if (isOddUseLifeEva) {
                    if (isAssetEva) {
                        whereCause.append("or ");
                    }
                    whereCause.append("bizCard.fUseTermCount - bakCard.fUseTermCount != 0 ");
                }
                whereCause.append(") ");
                StringBuffer selectSql = selectCause.append("from t_fa_fachangebill bill inner join t_fa_fachangebillentry entry on bill.fid = entry.FChangeBillID ").append("inner join t_fa_fabizcard bizCard on bizCard.fid = entry.fBizCardId inner join t_fa_fabakcard bakCard on bizCard.FFaBakCardID = bakCard.fid ").append(whereCause).append("and bill.FCheckedStatus = ? and bill.FPeriodID = ? and bakCard.FFaCurCardID in (" + this.getIds(ids, "bakCard.FFaCurCardID") + ")");
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString(), (Object[])new Object[]{new Integer(2), period.getId().toString()});
                while (rs.next()) {
                    result.add(rs.getString(1));
                }
                if (evaScheme.isClearDepreciation()) {
                    selectSql = new StringBuffer("select card.fnumber from t_fa_facurcard card inner join t_fa_cat cat on card.FAssetCatID = cat.fid ").append("inner join T_FA_DepreciationPolicy deprpolicy on deprpolicy.fid = cat.FDepreciationPolicyID ").append("where deprpolicy.FEvaluateChange = 1 and card.FDeprTTerm > ? and card.fid in (" + this.getIds(ids, "card.fid") + ")");
                    rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString(), (Object[])new Object[]{ZERO});
                    while (rs.next()) {
                        result.add(rs.getString(1));
                    }
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        return result;
    }

    @Override
    protected DAPTransformResult _generateVoucher(Context ctx, IObjectCollection sourceBillCollection, IObjectPK botMappingPK) throws BOSException, EASBizException {
        PrcFaCoreManager prcFaCoreManager = new PrcFaCoreManager(this.getBillStrategy());
        HashSet<String> set = new HashSet<String>();
        int size = sourceBillCollection.size();
        for (int i = 0; i < size; ++i) {
            set.add(sourceBillCollection.getObject(i).get("id").toString());
        }
        if (set.size() > 0) {
            EntityViewInfo v = new EntityViewInfo();
            v.getSelector().addObjectCollection((IObjectCollection)this.getBOTPSelectors());
            FilterInfo f = new FilterInfo();
            v.setFilter(f);
            f.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
            sourceBillCollection = FaEvaluateBillFactory.getLocalInstance(ctx).getCoreBillBaseCollection(v);
        }
        int size2 = sourceBillCollection.size();
        for (int i = 0; i < size2; ++i) {
            FaEvaluateBillInfo info = (FaEvaluateBillInfo)sourceBillCollection.getObject(i);
            if (info == null) continue;
            prcFaCoreManager.getFaManageStrategy().checkForOperate(ctx, info, 2);
            if (!info.getEvaluateScheme().isAssetUnite()) continue;
            this.insertEvaSum(ctx, info);
            BigDecimal initEvaValue = ZERO;
            BigDecimal lastEvaValue = ZERO;
            int size22 = info.getEvaSum().size();
            for (int j = 0; j < size22; ++j) {
                initEvaValue = initEvaValue.add(info.getEvaSum().get(j).getEvaValueSum());
                lastEvaValue = lastEvaValue.add(info.getEvaSum().get(j).getLastEvaValueSum());
            }
            if (initEvaValue.compareTo(lastEvaValue) != 0) continue;
            throw new FaEvaluateBillException(FaEvaluateBillException.NOT_NEED_VOUCHER, new Object[]{info.getNumber()});
        }
        return super._generateVoucher(ctx, sourceBillCollection, botMappingPK);
    }

    public SelectorItemCollection getBOTPSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("faEvaluateBillEntry.faCurCard.accountAsset.id"));
        sic.add(new SelectorItemInfo("faEvaluateBillEntry.faCurCard.accountAccuDepr.id"));
        sic.add(new SelectorItemInfo("faEvaluateBillEntry.faCurCard.accountDecValue.id"));
        sic.add(new SelectorItemInfo("faEvaluateBillEntry.faCurCard.initEvalValue"));
        sic.add(new SelectorItemInfo("faEvaluateBillEntry.faCurCard.lastEvalValue"));
        sic.add(new SelectorItemInfo("faEvaluateBillEntry.faCurCard.assetValue"));
        sic.add(new SelectorItemInfo("faEvaluateBillEntry.faCurCard.accountAsset"));
        sic.add(new SelectorItemInfo("faEvaluateBillEntry.faCurCard.accuDeprAll"));
        sic.add(new SelectorItemInfo("faEvaluateBillEntry.faCurCard.assetCat.id"));
        sic.add(new SelectorItemInfo("faEvaluateBillEntry.faBizCard.accuDepr"));
        sic.add(new SelectorItemInfo("evaluateScheme.*"));
        sic.add(new SelectorItemInfo("evaSum.*"));
        return sic;
    }

    @Override
    protected boolean _hasNotGenVoucherValue(Context ctx, String periodID, String companyID) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        boolean isRelAcct = SystemStatusCtrolUtils.isRelAccount((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)company);
        boolean isAfterVoucher = Boolean.valueOf((String)FaManageUtils.getFAParameter(company.getId(), ctx).get("FA_006"));
        if (isRelAcct && isAfterVoucher) {
            try {
                StringBuffer sql = new StringBuffer("select bill.fid from t_fa_faevaluatebill bill left outer join t_fa_faevaluatebillentry entry on bill.fid = entry.FFaEvaluateBillID ").append("left outer join t_fa_faevasum evasum on bill.fid = evasum.FEvaBillID where bill.fcompanyid = ? and fperiodid = ? and fcheckedstatus = ? ");
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyID, periodID, new Integer(1)});
                if (rs.next()) {
                    return true;
                }
                sql = new StringBuffer("select bill.fid from t_fa_faevaluatebillentry entry ").append("inner join t_fa_facurcard card on card.fid = entry.fcurcardid ").append("inner join t_fa_faevaluatebill bill on bill.fid = entry.FFaEvaluateBillID ").append("left outer join t_fa_faevavalue evaValue on entry.fid = evaValue.FEvaEntryID ").append("inner join t_fa_faevascheme evaScheme on evaScheme.fid = bill.FEvaluateSchemeID ").append("where bill.fid in (select fid from t_fa_faevaluatebill where fcompanyid = ? and  fperiodid= ? and ffivouchered = 0) ").append("and evaScheme.FAllRule = 1 and evaScheme.FAssetUnite = 0 ");
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyID, periodID});
                if (rs.next()) {
                    return true;
                }
                sql = new StringBuffer("select bill.fid from t_fa_faevaluatebillentry entry ").append("inner join t_fa_facurcard card on card.fid = entry.fcurcardid ").append("inner join t_fa_faevaluatebill bill on bill.fid = entry.FFaEvaluateBillID ").append("left outer join t_fa_faevavalue evaValue on entry.fid = evaValue.FEvaEntryID ").append("inner join t_fa_faevascheme evaScheme on evaScheme.fid = bill.FEvaluateSchemeID ").append("where bill.fid in (select fid from t_fa_faevaluatebill where fcompanyid = ? and  fperiodid= ? and ffivouchered = 0) ").append("and evaScheme.FAllRule = 1 and evaScheme.FAssetUnite = 1 and evaValue.fmaintype = ? and evaValue.fsubtype = ? ").append("group by bill.fid having sum(case when evaValue.fid is not null then card.FInitEvalValue else card.fassetValue end) != ").append("sum(case when evaValue.fid is not null then card.FLastEvalValue else card.FInitEvalValue end)");
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyID, periodID, new Integer(1), "00"});
                if (rs.next()) {
                    return true;
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        return false;
    }

    @Override
    protected FaEvaluateBillInfo _getValueByChgBillId(Context ctx, String id) throws BOSException, EASBizException {
        try {
            String selectSql = "select bill.fid ,bill.ffivouchered from t_fa_faevaluatebill bill inner join t_fa_faevaluatebillentry entry on bill.fid = entry.FFaEvaluateBillID inner join t_fa_fachangebill change on entry.FFaChangeBillID = change.fid where change.fid = ?";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql, (Object[])new Object[]{id});
            if (rs.next()) {
                String evaId = rs.getString(1);
                return this.getFaEvaluateBillInfo(ctx, "select id,number,fiVouchered where id = '" + evaId + "'");
            }
            return null;
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    @Override
    protected EntityViewInfo _getEntityViewForListUI(Context ctx, EntityViewInfo entityViewInfo) throws BOSException {
        String companyId = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        if (entityViewInfo == null) {
            entityViewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
            entityViewInfo.setFilter(filter);
            entityViewInfo.getSorter().add(new SorterItemInfo("id"));
            return entityViewInfo;
        }
        FilterItemCollection filters = entityViewInfo.getFilter().getFilterItems();
        StringBuffer sql = new StringBuffer("select distinct bill.fid from t_fa_faevaluatebill bill ").append("inner join t_fa_faevaluatebillentry entry on bill.fid = entry.FFaEvaluateBillID ").append("inner join t_fa_fabizCard bizCard on entry.fbizcardid = bizCard.fid ").append("inner join t_fa_cat cat on cat.fid = bizCard.FAssetCatID ").append("inner join t_org_company comp on comp.fid = bill.fcompanyid ").append("where bill.fcompanyid ='" + companyId + "' ");
        ArrayList<Integer> replaceFilterIndex = new ArrayList<Integer>();
        int size = filters.size();
        for (int i = 0; i < size; ++i) {
            FilterItemInfo filter = filters.get(i);
            String propertyName = filter.getPropertyName();
            String compareValue = filter.getCompareValue().toString();
            if (propertyName.equals("faEvaluateBillEntry.faBizCard.assetCat.id")) {
                sql.append("and cat.fid ='" + compareValue + "' ");
                replaceFilterIndex.add(new Integer(i));
                continue;
            }
            if (!propertyName.equals("faEvaluateBillEntry.faBizCard.assetCat.number")) continue;
            if (filter.getCompareType() == CompareType.GREATER_EQUALS) {
                sql.append("and bizCard.fnumber >= '" + compareValue + "' ");
            } else {
                sql.append("and bizCard.fnumber <= '" + compareValue + "' ");
            }
            replaceFilterIndex.add(new Integer(i));
        }
        if (replaceFilterIndex.size() > 0) {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            HashSet<String> evaBillIds = new HashSet<String>();
            try {
                while (rs.next()) {
                    evaBillIds.add(rs.getString(1));
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            if (evaBillIds.size() > 0) {
                FilterItemInfo newFilter = new FilterItemInfo("id", evaBillIds, CompareType.INCLUDE);
                int size2 = filters.size();
                for (int j = 0; j < size2; ++j) {
                    if (!replaceFilterIndex.contains(new Integer(j))) continue;
                    filters.removeObject(j);
                    filters.addObject(j, (IObjectValue)newFilter);
                }
            } else {
                filters.add(new FilterItemInfo("id", null, CompareType.EQUALS));
                entityViewInfo.getFilter().setMaskString(null);
            }
        }
        entityViewInfo.getSorter().add(new SorterItemInfo("id"));
        return entityViewInfo;
    }

    private SelectorItemCollection getPublishSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("publishedStatus"));
        return sic;
    }

    private String getIds(List curCardIds, String columnName) {
        StringBuffer idsBuffer = new StringBuffer(100);
        int cardSize = curCardIds.size();
        for (int i = 0; i < cardSize - 1; ++i) {
            if ((i + 1) % 900 == 0 && i + 1 < cardSize) {
                idsBuffer.append("'" + curCardIds.get(i) + "') or " + columnName + " in(");
                continue;
            }
            idsBuffer.append("'" + curCardIds.get(i) + "',");
        }
        idsBuffer.append("'" + curCardIds.get(curCardIds.size() - 1) + "'");
        return idsBuffer.toString();
    }

    private void insertEvaSum(Context ctx, FaEvaluateBillInfo info) throws BOSException, EASBizException {
        String catId = info.getFaEvaluateBillEntry().get(0).getFaCurCard().getAssetCat().getId().toString();
        String companyId = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        String selectSql = "select sum(finitevalvalue) , sum(fassetValue) , sum(faccudeprall) ,sum(faccudepr), sum(FLastEvalValue) from t_fa_facurcard where FAssetCatID = ? and FCompanyId = '" + companyId + "' and FEffectedStatus = 2 and FDeletedStatus = 1";
        if (!FaLocalUtils.getCurrentPeriod(ctx).getId().toString().equals(info.getPeriod().getId().toString())) {
            throw new FaEvaluateBillException(FaEvaluateBillException.PERIOD_NOT_EQUALS);
        }
        boolean existNotFinishBiz = FaCurCardFactory.getLocalInstance(ctx).exists("where bizstatus not like '%99' and assetCat.id = '" + catId + "' and company.id ='" + companyId + "'");
        if (existNotFinishBiz) {
            throw new FaEvaluateBillException(FaEvaluateBillException.EXIST_UNFINISH_BIZ);
        }
        DbUtil.execute((Context)ctx, (String)"delete from t_fa_faevasum where FEvaBillID = ?", (Object[])new Object[]{info.getId().toString()});
        try {
            FaEvaSumCollection evaSums = new FaEvaSumCollection();
            info.put("evaSum", (Object)evaSums);
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql, (Object[])new Object[]{catId});
            while (rs.next()) {
                FaEvaSumInfo evaSumInfo = new FaEvaSumInfo();
                evaSumInfo.setEvaBill(info);
                evaSumInfo.setAccountView(null);
                evaSumInfo.setEvaValueSum(rs.getBigDecimal(1) == null ? ZERO : rs.getBigDecimal(1));
                evaSumInfo.setAssetValue(rs.getBigDecimal(2) == null ? ZERO : rs.getBigDecimal(2));
                evaSumInfo.setAccuDeprAllSum(rs.getBigDecimal(3) == null ? ZERO : rs.getBigDecimal(3));
                evaSumInfo.setAccuDeprSum(rs.getBigDecimal(4) == null ? ZERO : rs.getBigDecimal(4));
                evaSumInfo.setLastEvaValueSum(rs.getBigDecimal(5) == null ? ZERO : rs.getBigDecimal(5));
                FaEvaSumFactory.getLocalInstance(ctx).addnew(evaSumInfo);
                evaSums.add(evaSumInfo);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        VoucherInfo voucher = FaLocalUtils.LookVoucherInfo(ctx, bOTRelationInfo);
        if (bOTBillOperStateEnum == BOTBillOperStateEnum.ADDNEW) {
            DbUtil.execute((Context)ctx, (String)("update T_FA_FaEvaluateBill   set FFiVouchered = 1 ,FVoucher='" + voucher.getId() + "',FVoucherNumber='" + voucher.getNumber() + "',FAbstract ='" + voucher.getVoucherAbstract() + "'  where fid = ?"), (Object[])new Object[]{srcBillVO.get("id").toString()});
        } else if (bOTBillOperStateEnum == BOTBillOperStateEnum.DELETE) {
            DbUtil.execute((Context)ctx, (String)"update T_FA_FaEvaluateBill   set FFiVouchered = 0 ,FVoucher=null, FVoucherNumber=null,FAbstract = null where fid = ?", (Object[])new Object[]{srcBillVO.get("id").toString()});
        } else if (bOTBillOperStateEnum == BOTBillOperStateEnum.EDIT) {
            DbUtil.execute((Context)ctx, (String)("update T_FA_FaEvaluateBill   set FVoucherNumber = '" + voucher.getNumber() + "',FAbstract  ='" + voucher.getVoucherAbstract() + "'  where fid = ?"), (Object[])new Object[]{srcBillVO.get("id").toString()});
        } else {
            super._reverseSave(ctx, srcBillPK, srcBillVO, bOTBillOperStateEnum, bOTRelationInfo);
        }
    }

    @Override
    protected void checkBeforeSave(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FaEvaluateBillInfo evaluateBill = (FaEvaluateBillInfo)model;
        FaEvaluateBillEntryCollection entryColl = evaluateBill.getFaEvaluateBillEntry();
        int size = entryColl.size();
        for (int i = 0; i < size; ++i) {
            FaCurCardInfo card = entryColl.get(i).getFaCurCard();
            if (card == null || card.getId() == null || card.getLastUpdateTime() == null) continue;
            FaBillBizProcessor.lockFaCurCard(ctx, card.getId().toString());
            FaBillBizProcessor.checkFaCurCardVersion(ctx, card.getId().toString(), card.getLastUpdateTime());
        }
    }

    @Override
    protected void checkBeforeSubmit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FaEvaluateBillInfo evaluateBill = (FaEvaluateBillInfo)model;
        FaEvaluateBillEntryCollection entryColl = evaluateBill.getFaEvaluateBillEntry();
        int size = entryColl.size();
        for (int i = 0; i < size; ++i) {
            FaCurCardInfo card = entryColl.get(i).getFaCurCard();
            if (card == null || card.getId() == null || card.getLastUpdateTime() == null) continue;
            FaBillBizProcessor.lockFaCurCard(ctx, card.getId().toString());
            FaBillBizProcessor.checkFaCurCardVersion(ctx, card.getId().toString(), card.getLastUpdateTime());
        }
    }

    protected void invokeServiceBefore(ServiceContext svcCtx) throws BOSException {
        FaRPCMethodMappingUtils.invokeRPCMethodEventListener(svcCtx, FaAppLogForBusinessTypeEnum.FA_EVALUATE, FaMethodCalcOrderEnum.BEFORE);
        super.invokeServiceBefore(svcCtx);
    }

    protected void invokeServiceAfter(ServiceContext svcCtx) throws BOSException {
        FaRPCMethodMappingUtils.invokeRPCMethodEventListener(svcCtx, FaAppLogForBusinessTypeEnum.FA_EVALUATE, FaMethodCalcOrderEnum.AFTER);
        super.invokeServiceAfter(svcCtx);
    }
}

