/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrolChecker;
import com.kingdee.eas.basedata.assistant.PeriodException;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolCollection;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.basedata.FaBasicException;
import com.kingdee.eas.fi.fa.manage.FALeaseContractFactory;
import com.kingdee.eas.fi.fa.manage.FaBorrowingFactory;
import com.kingdee.eas.fi.fa.manage.FaChangeBillFactory;
import com.kingdee.eas.fi.fa.manage.FaClearBillFactory;
import com.kingdee.eas.fi.fa.manage.FaCombinBillFactory;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaDecValueFactory;
import com.kingdee.eas.fi.fa.manage.FaDepreciationFactory;
import com.kingdee.eas.fi.fa.manage.FaDepreciationInfo;
import com.kingdee.eas.fi.fa.manage.FaDispatchBillFactory;
import com.kingdee.eas.fi.fa.manage.FaEvaluateBillFactory;
import com.kingdee.eas.fi.fa.manage.FaLeaseBillFactory;
import com.kingdee.eas.fi.fa.manage.FaLeaseInBillFactory;
import com.kingdee.eas.fi.fa.manage.FaMaintainFactory;
import com.kingdee.eas.fi.fa.manage.FaMortagBillFactory;
import com.kingdee.eas.fi.fa.manage.FaPeriodException;
import com.kingdee.eas.fi.fa.manage.FaRefundingFactory;
import com.kingdee.eas.fi.fa.manage.FaRequisitionedBillFactory;
import com.kingdee.eas.fi.fa.manage.FaReturnFactory;
import com.kingdee.eas.fi.fa.manage.FaSplitBillFactory;
import com.kingdee.eas.fi.fa.manage.FaStocktakingBillFactory;
import com.kingdee.eas.fi.fa.manage.FaStocktakingTaskBillFactory;
import com.kingdee.eas.framework.IBillBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.Locale;
import org.apache.log4j.Logger;

public class FaHasNewBizIsRef
implements ISystemStatusCtrolChecker {
    private static final Logger logger = Logger.getLogger(FaHasNewBizIsRef.class);
    private static final String RESOURCE_PATH = "com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource";

    public void check(Context ctx, SystemStatusCtrolCollection objCol) throws PeriodException {
        try {
            ISystemStatusCtrol iSystemStatusCtrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
            int count = objCol.size();
            for (int i = 0; i < count; ++i) {
                SystemStatusInfo systemStatusInfo;
                SystemStatusCtrolInfo newInfo = (SystemStatusCtrolInfo)objCol.getObject(i);
                if (newInfo.getId() == null || !(systemStatusInfo = newInfo.getSystemStatus()).getName().equals((Object)SystemEnum.FIXEDASSETS)) continue;
                String companyId = newInfo.getCompany().getId().toString();
                ObjectUuidPK sysPK = new ObjectUuidPK(newInfo.getId().toString());
                SystemStatusCtrolInfo oldInfo = (SystemStatusCtrolInfo)iSystemStatusCtrol.getValue((IObjectPK)sysPK);
                if (newInfo.getStartPeriod() != null && oldInfo.getStartPeriod() != null) {
                    if (oldInfo.getStartPeriod() != null && newInfo.getStartPeriod().getId().equals((Object)oldInfo.getStartPeriod().getId())) continue;
                    this.checkFaStartPeriod(ctx, companyId);
                    continue;
                }
                if (newInfo.getStartPeriod() == null && oldInfo.getStartPeriod() != null) {
                    this.checkFaStartPeriod(ctx, companyId);
                }
                if (newInfo.getStartPeriod() == null || oldInfo.getStartPeriod() != null) continue;
                this.checkFaStartPeriod(ctx, companyId);
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            throw new PeriodException(PeriodException.SYSTEM_STATUS_CTROL_CHECK_ERROR, (Throwable)e, new Object[]{e.getMessage()});
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw new PeriodException(PeriodException.SYSTEM_STATUS_CTROL_CHECK_ERROR, (Throwable)e, new Object[]{e.getMessage()});
        }
    }

    public void checkFaStartPeriod(Context ctx, String companyId) throws PeriodException {
        this.checkIsInitEnd(ctx, companyId);
        this.checkIsExistBiz(ctx, companyId);
    }

    public void checkIsExistBiz(Context ctx, String companyId) throws PeriodException {
        try {
            FilterInfo curCardFilter = new FilterInfo();
            curCardFilter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId, CompareType.EQUALS));
            curCardFilter.getFilterItems().add(new FilterItemInfo("originFlag", (Object)new Integer(0), CompareType.NOTEQUALS));
            if (FaCurCardFactory.getLocalInstance(ctx).exists(curCardFilter)) {
                FaBasicException faBasicException = new FaBasicException(FaBasicException.ISREF_HAS_NEW_BIZ, new Object[]{ResourceBase.getString((String)RESOURCE_PATH, (String)"118_FaHasNewBizIsRef", (Locale)ctx.getOriginLocale())});
                String exceptionCardMsg = faBasicException.getMessage(ctx.getLocale());
                throw new PeriodException(PeriodException.SYSTEM_STATUS_CTROL_CHECK_ERROR, new Object[]{exceptionCardMsg});
            }
            IBillBase[] iBizBases = new IBillBase[]{FaChangeBillFactory.getLocalInstance(ctx), FaClearBillFactory.getLocalInstance(ctx), FaDecValueFactory.getLocalInstance(ctx), FaSplitBillFactory.getLocalInstance(ctx), FaCombinBillFactory.getLocalInstance(ctx), FaDispatchBillFactory.getLocalInstance(ctx), FaMortagBillFactory.getLocalInstance(ctx), FaLeaseBillFactory.getLocalInstance(ctx), FaEvaluateBillFactory.getLocalInstance(ctx), FaStocktakingTaskBillFactory.getLocalInstance(ctx), FaStocktakingBillFactory.getLocalInstance(ctx), FaLeaseInBillFactory.getLocalInstance(ctx), FALeaseContractFactory.getLocalInstance(ctx), FaMaintainFactory.getLocalInstance(ctx), FaRequisitionedBillFactory.getLocalInstance(ctx), FaRefundingFactory.getLocalInstance(ctx), FaBorrowingFactory.getLocalInstance(ctx), FaReturnFactory.getLocalInstance(ctx), FaDepreciationFactory.getLocalInstance(ctx)};
            String[] billEntryNameStr = new String[]{ResourceBase.getString((String)RESOURCE_PATH, (String)"119_FaHasNewBizIsRef", (Locale)ctx.getOriginLocale()), ResourceBase.getString((String)RESOURCE_PATH, (String)"120_FaHasNewBizIsRef", (Locale)ctx.getOriginLocale()), ResourceBase.getString((String)RESOURCE_PATH, (String)"121_FaHasNewBizIsRef", (Locale)ctx.getOriginLocale()), ResourceBase.getString((String)RESOURCE_PATH, (String)"122_FaHasNewBizIsRef", (Locale)ctx.getOriginLocale()), ResourceBase.getString((String)RESOURCE_PATH, (String)"123_FaHasNewBizIsRef", (Locale)ctx.getOriginLocale()), ResourceBase.getString((String)RESOURCE_PATH, (String)"124_FaHasNewBizIsRef", (Locale)ctx.getOriginLocale()), ResourceBase.getString((String)RESOURCE_PATH, (String)"125_FaHasNewBizIsRef", (Locale)ctx.getOriginLocale()), ResourceBase.getString((String)RESOURCE_PATH, (String)"126_FaHasNewBizIsRef", (Locale)ctx.getOriginLocale()), ResourceBase.getString((String)RESOURCE_PATH, (String)"127_FaHasNewBizIsRef", (Locale)ctx.getOriginLocale()), ResourceBase.getString((String)RESOURCE_PATH, (String)"128_FaHasNewBizIsRef", (Locale)ctx.getOriginLocale()), ResourceBase.getString((String)RESOURCE_PATH, (String)"129_FaHasNewBizIsRef", (Locale)ctx.getOriginLocale()), ResourceBase.getString((String)RESOURCE_PATH, (String)"130_FaHasNewBizIsRef", (Locale)ctx.getOriginLocale()), ResourceBase.getString((String)RESOURCE_PATH, (String)"131_FaHasNewBizIsRef", (Locale)ctx.getOriginLocale()), ResourceBase.getString((String)RESOURCE_PATH, (String)"132_FaHasNewBizIsRef", (Locale)ctx.getOriginLocale()), ResourceBase.getString((String)RESOURCE_PATH, (String)"133_FaHasNewBizIsRef", (Locale)ctx.getOriginLocale()), ResourceBase.getString((String)RESOURCE_PATH, (String)"134_FaHasNewBizIsRef", (Locale)ctx.getOriginLocale()), ResourceBase.getString((String)RESOURCE_PATH, (String)"135_FaHasNewBizIsRef", (Locale)ctx.getOriginLocale()), ResourceBase.getString((String)RESOURCE_PATH, (String)"136_FaHasNewBizIsRef", (Locale)ctx.getOriginLocale()), ResourceBase.getString((String)RESOURCE_PATH, (String)"137_FaHasNewBizIsRef", (Locale)ctx.getOriginLocale())};
            int size = iBizBases.length;
            for (int i = 0; i < size; ++i) {
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId, CompareType.EQUALS));
                if (iBizBases[i].getType().equals((Object)new FaDepreciationInfo().getBOSType())) {
                    StringBuffer sql = new StringBuffer();
                    sql.append("select 1 from T_FA_FaDepreciationEntry where flnkfadepreentry in(");
                    sql.append("select fid from T_FA_FaDepreciation where fcompanyid = ?)");
                    IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyId});
                    if (result == null || result.size() == 0) {
                        DbUtil.execute((Context)ctx, (String)"delete from T_FA_FaDepreciation where fcompanyid = ?", (Object[])new Object[]{companyId});
                    }
                }
                if (!iBizBases[i].exists(filter)) continue;
                FaBasicException faBasicException = new FaBasicException(FaBasicException.ISREF_HAS_NEW_BIZ, new Object[]{billEntryNameStr[i]});
                String exceptionMsg = faBasicException.getMessage(ctx.getLocale());
                throw new PeriodException(PeriodException.SYSTEM_STATUS_CTROL_CHECK_ERROR, new Object[]{exceptionMsg});
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            throw new PeriodException(PeriodException.SYSTEM_STATUS_CTROL_CHECK_ERROR, (Throwable)e, new Object[]{e.getMessage()});
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw new PeriodException(PeriodException.SYSTEM_STATUS_CTROL_CHECK_ERROR, (Throwable)e, new Object[]{e.getMessage()});
        }
    }

    public void checkIsInitEnd(Context ctx, String companyId) throws PeriodException {
        try {
            CompanyOrgUnitInfo companyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
            boolean isInitEnd = SystemStatusCtrolUtils.isStart((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)companyOrgUnitInfo);
            if (isInitEnd) {
                FaPeriodException faPeriodException = new FaPeriodException(FaPeriodException.FAHASENDINIT);
                String exceptionCardMsg = faPeriodException.getMessage(ctx.getLocale());
                throw new PeriodException(PeriodException.SYSTEM_STATUS_CTROL_CHECK_ERROR, new Object[]{exceptionCardMsg});
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            throw new PeriodException(PeriodException.SYSTEM_STATUS_CTROL_CHECK_ERROR, (Throwable)e, new Object[]{e.getMessage()});
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw new PeriodException(PeriodException.SYSTEM_STATUS_CTROL_CHECK_ERROR, (Throwable)e, new Object[]{e.getMessage()});
        }
    }
}

