/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.dap.DAPTransformResult;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaLeaseBalanceBillFactory;
import com.kingdee.eas.fi.fa.manage.FaLeaseBalanceBillInfo;
import com.kingdee.eas.fi.fa.manage.FaLeaseBalanceEntryFactory;
import com.kingdee.eas.fi.fa.manage.FaLeaseBalanceEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaLeaseBillInfo;
import com.kingdee.eas.fi.fa.manage.FaLeaseException;
import com.kingdee.eas.fi.fa.manage.FaLeaseInBillInfo;
import com.kingdee.eas.fi.fa.manage.IFaLeaseBalanceBill;
import com.kingdee.eas.fi.fa.manage.IFaLeaseBalanceEntry;
import com.kingdee.eas.fi.fa.manage.LeaseDirectionEnum;
import com.kingdee.eas.fi.fa.manage.app.AbstractFaLeaseBalanceEntryControllerBean;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;

public class FaLeaseBalanceEntryControllerBean
extends AbstractFaLeaseBalanceEntryControllerBean {
    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FaLeaseBalanceEntryInfo info = (FaLeaseBalanceEntryInfo)model;
        PeriodInfo currentPeriod = FaLocalUtils.getCurrentPeriod(ctx);
        if (!currentPeriod.getId().toString().equals(info.getPeriod().getId().toString())) {
            throw new FaLeaseException(FaLeaseException.PAYMENTNOTSYNC);
        }
        info.setPeriod(FaLocalUtils.getCurrentPeriod(ctx));
        info.setCheckStatus(false);
        info.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        info.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        info.setFiVouchered(false);
        if (info.getId() == null) {
            String leaseBillId = info.get("billId").toString();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new String("lastUpdateTime"));
            IObjectValue leaseBill = DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(BOSUuid.getBOSObjectType((String)leaseBillId, (boolean)true), (IObjectPK)new ObjectUuidPK(leaseBillId), sic);
            Timestamp time = leaseBill.getTimestamp("lastUpdateTime");
            if (time.getTime() != info.getTimestamp("lastUpdateTime").getTime()) {
                throw new FaLeaseException(FaLeaseException.PAYMENTNOTSYNC);
            }
            this.setNumber(ctx, info);
            info.setCreateTime(new Timestamp(System.currentTimeMillis()));
            info.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
            boolean isLeaseOutBill = BOSUuid.getBOSObjectType((String)leaseBillId, (boolean)true).toString().equals(new FaLeaseBillInfo().getBOSType().toString());
            this.setBalanceInfo(ctx, info, isLeaseOutBill);
            return super._submit(ctx, (IObjectValue)info);
        }
        FaLeaseBalanceEntryInfo entrySaved = FaLeaseBalanceEntryFactory.getLocalInstance(ctx).getFaLeaseBalanceEntryInfo((IObjectPK)new ObjectUuidPK(info.getId()));
        if (entrySaved.isCheckStatus()) {
            throw new FaLeaseException(FaLeaseException.PAYMENTHASCHECK);
        }
        if (entrySaved.getCheckedStatus().getValue() == 2) {
            throw new FaLeaseException(FaLeaseException.PAYMENTHASAUDIT);
        }
        info.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        info.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
        return super._submit(ctx, (IObjectValue)info);
    }

    private void setBalanceInfo(Context ctx, FaLeaseBalanceEntryInfo entryInfo, boolean isLeaseOutBill) throws BOSException, EASBizException {
        String leaseBillId = entryInfo.get("billId").toString();
        IFaLeaseBalanceBill iBalance = FaLeaseBalanceBillFactory.getLocalInstance(ctx);
        CoreBaseCollection balances = iBalance.getCollection("select *,company.number where leaseOutBill.id='" + leaseBillId + "' or leaseInBill.id='" + leaseBillId + "'");
        if (balances.size() == 0) {
            FaLeaseBalanceBillInfo info = new FaLeaseBalanceBillInfo();
            info.setLeaseDC(isLeaseOutBill ? LeaseDirectionEnum.LeaseOut : LeaseDirectionEnum.LeaseIn);
            info.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
            info.setCreateTime(new Timestamp(System.currentTimeMillis()));
            info.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
            info.setCompany(ContextUtil.getCurrentFIUnit((Context)ctx));
            if (isLeaseOutBill) {
                FaLeaseBillInfo leaseBill = new FaLeaseBillInfo();
                leaseBill.setId(BOSUuid.read((String)leaseBillId));
                info.setLeaseOutBill(leaseBill);
            } else {
                FaLeaseInBillInfo leaseBill = new FaLeaseInBillInfo();
                leaseBill.setId(BOSUuid.read((String)leaseBillId));
                info.setLeaseInBill(leaseBill);
            }
            FaLeaseBalanceBillFactory.getLocalInstance(ctx).submit((CoreBaseInfo)info);
            entryInfo.setBill(info);
        } else {
            int seq = entryInfo.getSeq();
            IFaLeaseBalanceEntry iBalEntry = FaLeaseBalanceEntryFactory.getLocalInstance(ctx);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("bill.id", (Object)((FaLeaseBalanceBillInfo)balances.get(0)).getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("seq", (Object)new Integer(seq)));
            if (iBalEntry.exists(filter)) {
                IObjectValue billInfo = DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(BOSUuid.getBOSObjectType((String)leaseBillId, (boolean)true), (IObjectPK)new ObjectUuidPK(leaseBillId));
                int payMode = billInfo.getInt("payMode");
                if (payMode != 5) {
                    throw new FaLeaseException(FaLeaseException.PAYMENTNOTSYNC);
                }
                String sql = "select max(fseq) from t_fa_faleasebalanceentry where fbillid=?";
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{((FaLeaseBalanceBillInfo)balances.get(0)).getId().toString()});
                int result = 1;
                try {
                    rs.next();
                    result = rs.getInt(1) + 1;
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
                entryInfo.setSeq(result);
            }
            entryInfo.setBill((FaLeaseBalanceBillInfo)balances.get(0));
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        FaLeaseBalanceEntryInfo entry = FaLeaseBalanceEntryFactory.getLocalInstance(ctx).getFaLeaseBalanceEntryInfo(pk);
        FaLeaseBalanceBillInfo bill = FaLeaseBalanceBillFactory.getLocalInstance(ctx).getFaLeaseBalanceBillInfo("select id,entry.id where id='" + entry.getBill().getId() + "'");
        FaLeaseBalanceEntryInfo entrySaved = FaLeaseBalanceEntryFactory.getLocalInstance(ctx).getFaLeaseBalanceEntryInfo(pk);
        if (entrySaved.getCheckedStatus().getValue() == 2) {
            throw new FaLeaseException(FaLeaseException.PAYMENTHASAUDIT);
        }
        if (entrySaved.isCheckStatus()) {
            throw new FaLeaseException(FaLeaseException.PAYMENTHASCHECK);
        }
        String companyId = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        ICodingRuleManager iCodingRule = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (iCodingRule.isUseIntermitNumber((IObjectValue)entry, companyId, "isPayment")) {
            iCodingRule.recycleNumber((IObjectValue)entry, companyId, "isPayment", "", entry.getNumber());
        }
        if (bill.getEntry().size() == 1 && bill.getEntry().get(0).getId().toString().equals(pk.toString())) {
            FaLeaseBalanceBillFactory.getLocalInstance(ctx).delete((IObjectPK)new ObjectUuidPK(bill.getId()));
        } else {
            super._delete(ctx, pk);
        }
    }

    protected DAPTransformResult _generateVoucher(Context ctx, IObjectCollection sourceBillCollection, IObjectPK botMappingPK) throws BOSException, EASBizException {
        return super._generateVoucher(ctx, sourceBillCollection, botMappingPK);
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        if (bOTBillOperStateEnum == BOTBillOperStateEnum.ADDNEW) {
            String id = srcBillVO.getBOSUuid("id").toString();
            ArrayList relationCollection = BOTRelationFactory.getLocalInstance((Context)ctx).getDestObjIdByDestType(id, new VoucherInfo().getBOSType().toString());
            DbUtil.execute((Context)ctx, (String)"update T_FA_FaLeaseBalanceEntry set FFiVouchered =1 where fid = ?", (Object[])new Object[]{id});
        } else {
            super._reverseSave(ctx, srcBillPK, srcBillVO, bOTBillOperStateEnum, bOTRelationInfo);
        }
    }

    protected boolean _deleteVoucher(Context ctx, IObjectPK sourceBillPk) throws EASBizException, BOSException {
        boolean result = super._deleteVoucher(ctx, sourceBillPk);
        DbUtil.execute((Context)ctx, (String)"update T_FA_FaLeaseBalanceEntry set FVoucherID=null,FFiVouchered =0 where fid = ?", (Object[])new Object[]{sourceBillPk.toString()});
        return result;
    }

    private void setNumber(Context ctx, FaLeaseBalanceEntryInfo info) throws EASBizException, BOSException {
        String strCompanyID = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String number = "";
        int maxCycleNum = 100;
        String filterString = "where number = '" + number + "' and company.id = '" + strCompanyID + "' " + (info.get("id") != null ? "and id !='" + info.get("id") + "'" : "");
        while (number == null || number.equals("") || this._exists(ctx, filterString)) {
            if (--maxCycleNum == 0) {
                throw new CodingRuleException(CodingRuleException.ERROR_REFERENCE_INVALID);
            }
            number = iCodingRuleManager.getNumber((IObjectValue)info, strCompanyID, "isPayment", "");
            filterString = "where number = '" + number + "' and company.id = '" + strCompanyID + "' " + (info.get("id") != null ? "and id !='" + info.get("id") + "'" : "");
        }
        info.setNumber(number);
    }
}

