/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.ServiceContext;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaAppLogForBusinessTypeEnum;
import com.kingdee.eas.fi.fa.manage.FaBillBizProcessor;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaMortagBillEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaMortagBillInfo;
import com.kingdee.eas.fi.fa.manage.app.AbstractFaMortagBillControllerBean;
import com.kingdee.eas.fi.fa.manage.app.AbstractPrcFaManageStrategy;
import com.kingdee.eas.fi.fa.manage.app.PrcFaMortagStrategy;
import com.kingdee.eas.fi.fa.manage.app.falog.event.FaMethodCalcOrderEnum;
import com.kingdee.eas.fi.fa.manage.app.falog.utils.FaRPCMethodMappingUtils;
import org.apache.log4j.Logger;

public class FaMortagBillControllerBean
extends AbstractFaMortagBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.fa.manage.app.FaMortagBillControllerBean");

    @Override
    protected AbstractPrcFaManageStrategy getBillStrategy() {
        return new PrcFaMortagStrategy();
    }

    @Override
    public String getMasterTable() {
        return "T_FA_FaMortagBill";
    }

    @Override
    protected boolean _hasNotAuditValue(Context ctx, String periodID, String companyID) throws BOSException, EASBizException {
        FilterInfo auditFilter = new FilterInfo();
        auditFilter.getFilterItems().add(new FilterItemInfo("period", (Object)periodID, CompareType.EQUALS));
        auditFilter.getFilterItems().add(new FilterItemInfo("company", (Object)companyID, CompareType.EQUALS));
        auditFilter.getFilterItems().add(new FilterItemInfo("effectedStatus", (Object)new Integer(2), CompareType.NOTEQUALS));
        return this.exists(ctx, auditFilter);
    }

    @Override
    protected void checkBeforeSave(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FaMortagBillInfo mortagBill = (FaMortagBillInfo)model;
        FaMortagBillEntryCollection entryColl = mortagBill.getFaMortagBillEntry();
        int size = entryColl.size();
        for (int i = 0; i < size; ++i) {
            FaCurCardInfo card = entryColl.get(i).getFaCurCard();
            if (card == null || card.getId() == null || card.getLastUpdateTime() == null) continue;
            FaBillBizProcessor.lockFaCurCard(ctx, card.getId().toString());
            FaBillBizProcessor.checkFaCurCardVersion(ctx, card.getId().toString(), card.getLastUpdateTime());
        }
    }

    @Override
    protected void checkBeforeSubmit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FaMortagBillInfo mortagBill = (FaMortagBillInfo)model;
        FaMortagBillEntryCollection entryColl = mortagBill.getFaMortagBillEntry();
        int size = entryColl.size();
        for (int i = 0; i < size; ++i) {
            FaCurCardInfo card = entryColl.get(i).getFaCurCard();
            if (card == null || card.getId() == null || card.getLastUpdateTime() == null) continue;
            FaBillBizProcessor.lockFaCurCard(ctx, card.getId().toString());
            FaBillBizProcessor.checkFaCurCardVersion(ctx, card.getId().toString(), card.getLastUpdateTime());
        }
    }

    protected void invokeServiceBefore(ServiceContext svcCtx) throws BOSException {
        FaRPCMethodMappingUtils.invokeRPCMethodEventListener(svcCtx, FaAppLogForBusinessTypeEnum.FA_MORTAG, FaMethodCalcOrderEnum.BEFORE);
        super.invokeServiceBefore(svcCtx);
    }

    protected void invokeServiceAfter(ServiceContext svcCtx) throws BOSException {
        FaRPCMethodMappingUtils.invokeRPCMethodEventListener(svcCtx, FaAppLogForBusinessTypeEnum.FA_MORTAG, FaMethodCalcOrderEnum.AFTER);
        super.invokeServiceAfter(svcCtx);
    }
}

