/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.common.DCInfo;
import com.kingdee.eas.base.common.DCManager;
import com.kingdee.eas.fi.fa.manage.app.FaQuartzJob;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class FaRefreshDSJob
extends FaQuartzJob {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.FaRefreshDSJob");

    public void execute(JobExecutionContext ctx) throws JobExecutionException {
        try {
            ArrayList newList = DCManager.getInstance().getDCList();
            Vector ctxs = (Vector)ctx.getJobDetail().getJobDataMap().get((Object)"ctxs");
            this.refreshContextList(newList, ctxs);
        }
        catch (Exception ex) {
            logger.error((Object)"refresh DS error!", (Throwable)ex);
        }
    }

    private void refreshContextList(List newList, Vector ctxs) throws BOSException {
        this.addContext(newList, ctxs);
        this.removeContext(newList, ctxs);
    }

    private void addContext(List newList, Vector ctxs) throws BOSException {
        for (int i = 0; i < newList.size(); ++i) {
            Context ctx;
            DCInfo info = (DCInfo)newList.get(i);
            boolean isFound = false;
            for (int j = 0; j < ctxs.size(); ++j) {
                if (!info.getNumber().equals(((Context)ctxs.get(j)).getAIS())) continue;
                isFound = true;
                break;
            }
            if (isFound || !this.isContextUsable(ctx = this.createContext(info), "Fa refresh ds error,")) continue;
            ctxs.add(ctx);
        }
    }

    private void removeContext(List newList, Vector ctxs) {
        if (ctxs.size() > newList.size()) {
            for (int i = 0; i < ctxs.size(); ++i) {
                boolean isFound = false;
                for (int j = 0; j < newList.size(); ++j) {
                    if (!((Context)ctxs.get(i)).getAIS().equals(((DCInfo)newList.get(j)).getNumber())) continue;
                    isFound = true;
                    break;
                }
                if (isFound) continue;
                ctxs.remove(i);
                --i;
            }
        }
    }

    private Context createContext(DCInfo dc) {
        Context ctx = new Context(null, dc.getSolutionName(), dc.getNumber(), null);
        ctx.setUserName(dc.getUserName());
        ctx.put((Object)"dbType", (Object)this.getDBType(dc.getDBType()));
        return ctx;
    }

    private String getDBType(int dbType) {
        switch (dbType) {
            case 0: {
                return "MS SQL Server";
            }
            case 1: {
                return "DB2";
            }
        }
        return "Oracle";
    }
}

