/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationEntryCollection;
import com.kingdee.bos.metadata.bot.BOTRelationEntryInfo;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.dap.DAPTransformResult;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.IPaymentBill;
import com.kingdee.eas.fi.cas.IReceivingBill;
import com.kingdee.eas.fi.cas.PaymentBillCollection;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.ReceivingBillFactory;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.fa.manage.FaLeaseInBillNewFactory;
import com.kingdee.eas.fi.fa.manage.FaLeaseInBillNewInfo;
import com.kingdee.eas.fi.fa.manage.FaLeaseSourceTypeEnum;
import com.kingdee.eas.fi.fa.manage.FaLeaseTypeEnum;
import com.kingdee.eas.fi.fa.manage.FaPayFrequencyEnum;
import com.kingdee.eas.fi.fa.manage.FaPaymentPlanNewCollection;
import com.kingdee.eas.fi.fa.manage.FaPaymentPlanNewFactory;
import com.kingdee.eas.fi.fa.manage.FaPaymentPlanNewInfo;
import com.kingdee.eas.fi.fa.manage.FaRentDirectionEnum;
import com.kingdee.eas.fi.fa.manage.FaRentSettlementBillCollection;
import com.kingdee.eas.fi.fa.manage.FaRentSettlementBillEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaRentSettlementBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaRentSettlementBillInfo;
import com.kingdee.eas.fi.fa.manage.IFaLeaseInBillNew;
import com.kingdee.eas.fi.fa.manage.RentSettlementTypeEnum;
import com.kingdee.eas.fi.fa.manage.app.AbstractFaRentSettlementBillControllerBean;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class FaRentSettlementBillControllerBean
extends AbstractFaRentSettlementBillControllerBean {
    private static final long serialVersionUID = 1758643530274126246L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.fa.manage.app.FaRentSettlementBillControllerBean");
    private static final String RES_PATH_RS = "com.kingdee.eas.fi.fa.manage.FaRentSettlementBillResource";
    private int recursiveNumber = 0;

    @Override
    protected IObjectPK[] _createByLeaseInBillId(Context ctx, IObjectPK billId) throws BOSException, EASBizException {
        FaLeaseTypeEnum leaseType;
        FaLeaseInBillNewInfo leaseBillInfo = this.getLeaseInBill(ctx, billId);
        if (leaseBillInfo == null) {
            String leaseInBillIsNull = FaLocalUtils.getResource(ctx, RES_PATH_RS, "leaseInBillIsNull");
            throw new EASBizException(new NumericExceptionSubItem("001", leaseInBillIsNull));
        }
        FaPaymentPlanNewCollection ppCol = leaseBillInfo.getPaymentEntry();
        FaLeaseTypeEnum faLeaseTypeEnum = leaseType = leaseBillInfo.getLeaseType() == null ? FaLeaseTypeEnum.OPERATING_LEASE : leaseBillInfo.getLeaseType();
        if (FaPayFrequencyEnum.PAY_IN_ADVANCE == leaseBillInfo.getPayFrequency() && FaLeaseTypeEnum.OPERATING_LEASE == leaseType) {
            return new IObjectPK[ppCol.size()];
        }
        if (ppCol.size() <= 0) {
            String payPlanIsNull = FaLocalUtils.getResource(ctx, RES_PATH_RS, "payPlanIsNull");
            throw new EASBizException(new NumericExceptionSubItem("002", payPlanIsNull));
        }
        PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.FINANCE_LEASE, (CompanyOrgUnitInfo)leaseBillInfo.getCompany());
        PeriodInfo curPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.FINANCE_LEASE, (CompanyOrgUnitInfo)leaseBillInfo.getCompany());
        boolean isInitBill = false;
        if (startPeriod.getId().toString().equals(curPeriod.getId().toString()) && leaseBillInfo.isIsHistory()) {
            isInitBill = true;
        }
        ppCol.sort("payDate");
        ppCol.removeObject(0);
        IObjectPK[] pks = new IObjectPK[ppCol.size()];
        if (leaseBillInfo.getSourceType() == FaLeaseSourceTypeEnum.RETROACTIVE_ADJUSTMENT_CREAT) {
            pks = new IObjectPK[ppCol.size() + 1];
            FaRentSettlementBillInfo rsBillInfo = new FaRentSettlementBillInfo();
            rsBillInfo.setRentDirection(FaRentDirectionEnum.RENT_IN);
            rsBillInfo.setLeaseBillId(leaseBillInfo.getId().toString());
            rsBillInfo.setLeaseInBill(leaseBillInfo);
            rsBillInfo.setIsDeductible(leaseBillInfo.isIsDeductible());
            rsBillInfo.setIsExpire(leaseBillInfo.isIsExpire());
            rsBillInfo.setIsExempt(leaseBillInfo.isIsExempt());
            rsBillInfo.setBeginDate(leaseBillInfo.getBeginDate());
            rsBillInfo.setEndDate(leaseBillInfo.getEndDate());
            rsBillInfo.setTimeCycle(leaseBillInfo.getTimeCycle());
            rsBillInfo.setPayFrequency(leaseBillInfo.getPayFrequency());
            rsBillInfo.setTotalPeriod(1);
            rsBillInfo.setHadPeriod(leaseBillInfo.getHasRented());
            rsBillInfo.setSubPeriod(leaseBillInfo.getTotalPayPeriod() - leaseBillInfo.getHasRented());
            rsBillInfo.setCurrency(leaseBillInfo.getCurrency());
            rsBillInfo.setRentWithTax(leaseBillInfo.getRentWithTax());
            rsBillInfo.setCompany(leaseBillInfo.getCompany());
            rsBillInfo.setBizDate(leaseBillInfo.getBizDate());
            this.setNewNumber(ctx, rsBillInfo);
            FaRentSettlementBillEntryCollection rsCol = new FaRentSettlementBillEntryCollection();
            FaRentSettlementBillEntryInfo entry = new FaRentSettlementBillEntryInfo();
            BigDecimal[] planValue = this.getPlanValueForType(ctx, leaseBillInfo);
            entry.setGenRpBill(false);
            entry.setPlanDate(leaseBillInfo.getFiAccountDate());
            entry.setPlanWithTaxAmt(planValue[0]);
            entry.setPlanWithoutTaxAmt(planValue[1]);
            entry.setTaxAmt(planValue[0].subtract(planValue[1]));
            if (entry.getPlanWithoutTaxAmt().compareTo(BigDecimal.ZERO) == 0) {
                entry.setTaxRate(BigDecimal.ZERO);
            } else {
                entry.setTaxRate(entry.getTaxAmt().divide(entry.getPlanWithoutTaxAmt(), 3, 4));
            }
            entry.setRentSettlementType(RentSettlementTypeEnum.RETROACTIVE_ADJUSTMENT);
            rsCol.add(entry);
            rsBillInfo.put("entries", (Object)rsCol);
            pks[0] = this.save(ctx, (CoreBaseInfo)rsBillInfo);
        }
        Calendar cld = Calendar.getInstance();
        cld.setTime(leaseBillInfo.getFiAccountDate());
        cld.set(5, 1);
        cld.set(12, 0);
        cld.set(13, 0);
        cld.set(14, 0);
        Date newFiAccountDate = cld.getTime();
        for (int i = 0; i < ppCol.size(); ++i) {
            if (ppCol.get(i).getPayDate().compareTo(newFiAccountDate) < 0) continue;
            FaRentSettlementBillInfo rsBillInfo = new FaRentSettlementBillInfo();
            rsBillInfo.setRentDirection(FaRentDirectionEnum.RENT_IN);
            rsBillInfo.setLeaseBillId(leaseBillInfo.getId().toString());
            rsBillInfo.setLeaseBillNumber(leaseBillInfo.getNumber());
            rsBillInfo.setLeaseInBill(leaseBillInfo);
            rsBillInfo.setIsDeductible(leaseBillInfo.isIsDeductible());
            rsBillInfo.setIsExpire(leaseBillInfo.isIsExpire());
            rsBillInfo.setIsExempt(leaseBillInfo.isIsExempt());
            rsBillInfo.setBeginDate(leaseBillInfo.getBeginDate());
            rsBillInfo.setEndDate(leaseBillInfo.getEndDate());
            rsBillInfo.setTimeCycle(leaseBillInfo.getTimeCycle());
            rsBillInfo.setPayFrequency(leaseBillInfo.getPayFrequency());
            rsBillInfo.setTotalPeriod(leaseBillInfo.getTotalPayPeriod());
            rsBillInfo.setHadPeriod(leaseBillInfo.getHasRented());
            rsBillInfo.setSubPeriod(leaseBillInfo.getTotalPayPeriod() - leaseBillInfo.getHasRented());
            rsBillInfo.setCurrency(leaseBillInfo.getCurrency());
            rsBillInfo.setRentWithTax(leaseBillInfo.getRentWithTax());
            rsBillInfo.setCompany(leaseBillInfo.getCompany());
            this.setNewNumber(ctx, rsBillInfo);
            FaRentSettlementBillEntryCollection rsCol = new FaRentSettlementBillEntryCollection();
            FaRentSettlementBillEntryInfo entry = new FaRentSettlementBillEntryInfo();
            FaPaymentPlanNewInfo ppInfo = ppCol.get(i);
            entry.setGenRpBill(false);
            entry.setPlanId(ppInfo.getId().toString());
            entry.setPaymentPlan(ppInfo);
            entry.setPlanDate(ppInfo.getPayDate());
            entry.setPlanWithTaxAmt(ppInfo.getPaymentWithTax());
            entry.setTaxRate(ppInfo.getTaxRate());
            entry.setTaxAmt(ppInfo.getTaxAmount());
            entry.setPlanWithoutTaxAmt(ppInfo.getPaymentWithoutTax());
            if (isInitBill && ppInfo.getPayDate().compareTo(startPeriod.getBeginDate()) < 0) {
                rsBillInfo.setFiVouchered(true);
                entry.setFiVouchered(true);
            }
            rsCol.add(entry);
            rsBillInfo.put("entries", (Object)rsCol);
            if (leaseBillInfo.getSourceType() == FaLeaseSourceTypeEnum.RETROACTIVE_ADJUSTMENT_CREAT) {
                pks[i + 1] = this.save(ctx, (CoreBaseInfo)rsBillInfo);
                continue;
            }
            pks[i] = this.save(ctx, (CoreBaseInfo)rsBillInfo);
        }
        return pks;
    }

    private FaLeaseInBillNewInfo getLeaseInBill(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("contractCat.id");
        sic.add("contractCat.name");
        sic.add("company.id");
        sic.add("company.name");
        sic.add("company.baseCurrency.id");
        sic.add("company.baseCurrency.name");
        sic.add("company.baseCurrency.precision");
        sic.add("paymentEntry.*");
        return this.getLIBNBizInterface(ctx).getFaLeaseInBillNewInfo(pk, sic);
    }

    public FaRentSettlementBillInfo getRSIdByBillId(Context ctx, IObjectPK billId) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("entries.*");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("leaseBillId", (Object)billId));
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(sic);
        view.setFilter(filter);
        FaRentSettlementBillCollection col = this.getFaRentSettlementBillCollection(ctx, view);
        if (col.size() <= 0) {
            return null;
        }
        return col.get(0);
    }

    @Override
    protected void _deleteByLeaseBillId(Context ctx, IObjectPK billId) throws BOSException, EASBizException {
        String checkVcSQL = "SELECT 1 FROM T_Fa_FaRentSettlementBill WHERE FFiVouchered = 1 AND FVoucherID IS NOT NULL AND FLeaseInBillID = ?";
        IRowSet vcRs = DbUtil.executeQuery((Context)ctx, (String)checkVcSQL, (Object[])new String[]{billId.toString()});
        try {
            if (vcRs != null && vcRs.next()) {
                String billVouchered = FaLocalUtils.getResource(ctx, RES_PATH_RS, "billVouchered");
                throw new EASBizException(new NumericExceptionSubItem("004", billVouchered));
            }
        }
        catch (SQLException e) {
            throw new EASBizException(new NumericExceptionSubItem("005", e.getMessage()));
        }
        String traceDownSQL = "SELECT 1 FROM T_BOT_Relation WHERE FSRCOBJECTID IN (SELECT FID FROM T_FA_FaRentSettlementBill WHERE FLeaseInBillId = ?)";
        IRowSet tdRs = DbUtil.executeQuery((Context)ctx, (String)traceDownSQL, (Object[])new String[]{billId.toString()});
        try {
            if (tdRs != null && tdRs.next()) {
                String existsDownStreamBill = FaLocalUtils.getResource(ctx, RES_PATH_RS, "existsDownStreamBill");
                throw new EASBizException(new NumericExceptionSubItem("006", existsDownStreamBill));
            }
        }
        catch (SQLException e) {
            throw new EASBizException(new NumericExceptionSubItem("007", e.getMessage()));
        }
        String oql = "select id, number, company.id, CU.id, CU.number, CU.name where leaseInBill.id = '" + billId.toString() + "'";
        FaRentSettlementBillCollection rsCol = this.getFaRentSettlementBillCollection(ctx, oql);
        if (rsCol != null && rsCol.size() > 0) {
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            String companyId = rsCol.get(0).getCompany().getId().toString();
            if (iCodingRuleManager.getCodingRule((IObjectValue)rsCol.get(0), companyId) != null && iCodingRuleManager.isUseIntermitNumber((IObjectValue)rsCol.get(0), companyId)) {
                for (int i = 0; i < rsCol.size(); ++i) {
                    iCodingRuleManager.recycleNumber((IObjectValue)rsCol.get(i), companyId, rsCol.get(i).getNumber());
                }
            }
        }
        String oql2 = "select id where leaseInBill.id = '" + billId.toString() + "'";
        this.delete(ctx, oql2);
    }

    private IFaLeaseInBillNew getLIBNBizInterface(Context ctx) throws BOSException {
        return FaLeaseInBillNewFactory.getLocalInstance(ctx);
    }

    @Override
    protected void _checkTerminated(Context ctx, String leaseInBillId, Date date) throws BOSException, EASBizException {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT 1 FROM T_Fa_FaTerminateBill bill, T_Fa_FaTerminateBillEntry entry ");
        sql.append("WHERE bill.FID = entry.FBillId AND entry.FLeaseInBillId = ? AND bill.FTerminateDate <= ?");
        Object[] params = new Object[]{leaseInBillId, date};
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
        try {
            if (rowSet != null && rowSet.next()) {
                throw new EASBizException(new NumericExceptionSubItem("008", FaLocalUtils.getResource(ctx, RES_PATH_RS, "hasTerminated")));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (!this.compareDateIfCurrentMonth(date, ctx)) {
            throw new EASBizException(new NumericExceptionSubItem("012", FaLocalUtils.getResource(ctx, RES_PATH_RS, "isCurrentPeriod")));
        }
    }

    protected void setNewNumber(Context ctx, FaRentSettlementBillInfo billInfo) throws EASBizException, BOSException {
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = billInfo.getCompany();
        if (aCompanyOrgUnitInfo == null) {
            aCompanyOrgUnitInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
        }
        String strCompanyId = aCompanyOrgUnitInfo.getId().toString();
        String number = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getNumber((IObjectValue)billInfo, strCompanyId);
        billInfo.setNumber(number);
        if (this.existNumber(ctx, (IObjectValue)billInfo)) {
            ++this.recursiveNumber;
            if (this.recursiveNumber >= 100) {
                this.recursiveNumber = 0;
                String numberRuleIsError = FaLocalUtils.getResource(ctx, RES_PATH_RS, "numberRuleIsError");
                throw new EASBizException(new NumericExceptionSubItem("003", numberRuleIsError));
            }
            this.setNewNumber(ctx, billInfo);
        } else {
            this.recursiveNumber = 0;
        }
    }

    protected boolean existNumber(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        FaRentSettlementBillInfo billInfo = (FaRentSettlementBillInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)billInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (billInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)billInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (billInfo.getCompany() != null) {
            filterItem = new FilterItemInfo("company", (Object)billInfo.getCompany().getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        } else {
            filterItem = new FilterItemInfo("company", null, CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        StringBuffer sb = new StringBuffer().append("#0");
        int size = filter.getFilterItems().size();
        for (int i = 1; i < size; ++i) {
            sb.append(" and #" + i);
        }
        filter.setMaskString(sb.toString());
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        return this._exists(ctx, filter);
    }

    public DAPTransformResult generateVoucher(Context ctx, CoreBillBaseCollection sourceBillCollection, IObjectPK botMappingPK) throws BOSException, EASBizException {
        return super.generateVoucher(ctx, sourceBillCollection, botMappingPK);
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        VoucherInfo voucher = FaLocalUtils.LookVoucherInfo(ctx, bOTRelationInfo);
        if (bOTBillOperStateEnum == BOTBillOperStateEnum.ADDNEW) {
            String updateBillSQL = "UPDATE T_Fa_FaRentSettlementBill SET FFiVouchered = 1, FVoucherID = ? WHERE FID = ?";
            String updateEntrySQL = "UPDATE T_Fa_FaRentSettlementBillEntry SET FFiVouchered = 1, FVoucherID = ? WHERE FBillId = ?";
            DbUtil.execute((Context)ctx, (String)updateBillSQL, (Object[])new String[]{voucher.getId().toString(), srcBillVO.get("id").toString()});
            DbUtil.execute((Context)ctx, (String)updateEntrySQL, (Object[])new String[]{voucher.getId().toString(), srcBillVO.get("id").toString()});
        } else if (bOTBillOperStateEnum == BOTBillOperStateEnum.DELETE) {
            String updateBillSQL = "UPDATE T_Fa_FaRentSettlementBill SET FFiVouchered = 0, FVoucherID = null WHERE FID = ?";
            String updateEntrySQL = "UPDATE T_Fa_FaRentSettlementBillEntry SET FFiVouchered = 0, FVoucherID = null WHERE FBillId = ?";
            DbUtil.execute((Context)ctx, (String)updateBillSQL, (Object[])new String[]{srcBillVO.get("id").toString()});
            DbUtil.execute((Context)ctx, (String)updateEntrySQL, (Object[])new String[]{srcBillVO.get("id").toString()});
        } else if (bOTBillOperStateEnum != BOTBillOperStateEnum.EDIT) {
            super._reverseSave(ctx, srcBillPK, srcBillVO, bOTBillOperStateEnum, bOTRelationInfo);
        }
    }

    private void rvSaveOnAddNew(Context ctx, BOTRelationEntryCollection botrEntryCol, FaRentSettlementBillInfo rsBill) throws BOSException {
        this.updatePeriodValue(ctx, botrEntryCol, rsBill);
    }

    public static IObjectValue lookRPBillInfo(Context ctx, IObjectValue bOTRelationInfo, boolean isPayment) throws BOSException {
        Iterator iter;
        EntityViewInfo entityView = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("id"));
        if (isPayment) {
            sic.add(new SelectorItemInfo("paydate"));
        } else {
            sic.add(new SelectorItemInfo("recdate"));
        }
        sic.add(new SelectorItemInfo("entries.actualamt"));
        entityView.getSelector().addObjectCollection((IObjectCollection)sic);
        FilterInfo filter = new FilterInfo();
        if (((BOTRelationInfo)bOTRelationInfo).getDestObjectID() == null) {
            return null;
        }
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)((BOTRelationInfo)bOTRelationInfo).getDestObjectID()));
        entityView.setFilter(filter);
        PaymentBillCollection col = null;
        if (isPayment) {
            IPaymentBill paymentBill = PaymentBillFactory.getLocalInstance((Context)ctx);
            col = paymentBill.getPaymentBillCollection(entityView);
        } else {
            IReceivingBill receiving = ReceivingBillFactory.getLocalInstance((Context)ctx);
            col = receiving.getReceivingBillCollection(entityView);
        }
        if (col != null && col.size() > 0 && (iter = col.iterator()).hasNext()) {
            IObjectValue ov = (IObjectValue)iter.next();
            return ov;
        }
        return null;
    }

    private void rvSaveOnEdit(Context ctx, BOTRelationInfo botrInfo, FaRentSettlementBillInfo rsBill, BOTRelationEntryCollection botrEntryCol) throws BOSException {
        ReceivingBillInfo receivingBill;
        PaymentBillInfo paymentBill;
        if (new PaymentBillInfo().getBOSType().toString().equals(botrInfo.get("destentityid")) && (paymentBill = (PaymentBillInfo)FaRentSettlementBillControllerBean.lookRPBillInfo(ctx, (IObjectValue)botrInfo, true)) != null && paymentBill.getId() != null) {
            this.rvSaveOnEdit(ctx, (IObjectValue)paymentBill, rsBill, botrEntryCol);
        }
        if (new ReceivingBillInfo().getBOSType().toString().equals(botrInfo.get("destentityid")) && (receivingBill = (ReceivingBillInfo)FaRentSettlementBillControllerBean.lookRPBillInfo(ctx, (IObjectValue)botrInfo, true)) != null && receivingBill.getId() != null) {
            this.rvSaveOnEdit(ctx, (IObjectValue)receivingBill, rsBill, botrEntryCol);
        }
    }

    private void rvSaveOnEdit(Context ctx, IObjectValue destBill, FaRentSettlementBillInfo rsBill, BOTRelationEntryCollection botrEntryCol) throws BOSException {
        for (int i = 0; i < botrEntryCol.size(); ++i) {
            BOTRelationEntryInfo botrEntry = botrEntryCol.get(i);
            IObjectValue destBillEntry = null;
            IObjectCollection destBillEntries = (IObjectCollection)destBill.get("entries");
            for (int j = 0; j < destBillEntries.size(); ++j) {
                if (!destBillEntries.getObject(j).get("id").toString().equals(botrEntry.getDestEntryID())) continue;
                destBillEntry = destBillEntries.getObject(j);
                break;
            }
            if (destBillEntry == null) continue;
            String paymentBillID = null;
            String rcvBillId = null;
            Date date = null;
            SelectorItemCollection sic = new SelectorItemCollection();
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)destBill.get("id").toString()));
            if (new PaymentBillInfo().getBOSType().toString().equals(destBill.getBOSType().toString())) {
                try {
                    paymentBillID = pk.toString();
                    sic.add("bizDate");
                    PaymentBillInfo payBillInfo = PaymentBillFactory.getLocalInstance((Context)ctx).getPaymentBillInfo((IObjectPK)pk, sic);
                    date = payBillInfo.getBizDate();
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            }
            if (new ReceivingBillInfo().getBOSType().toString().equals(destBill.getBOSType().toString())) {
                try {
                    rcvBillId = pk.toString();
                    sic.add("bizDate");
                    ReceivingBillInfo rcvBillInfo = ReceivingBillFactory.getLocalInstance((Context)ctx).getReceivingBillInfo((IObjectPK)pk, sic);
                    date = rcvBillInfo.getBizDate();
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            }
            String updateEntrySQL = " UPDATE T_FA_FaRentSettlementBillEntry SET FPaymentBillID = ?, FRpBillId = ?, FRpBillNumber = ?, FGenRpBill = 1, FDate = ?, FWithTaxAmt = ? WHERE FID = ? ";
            DbUtil.execute((Context)ctx, (String)updateEntrySQL, (Object[])new Object[]{paymentBillID, destBill.get("id").toString(), destBill.get("number"), date, destBillEntry.get("actualamt"), botrEntry.getSrcEntryID()});
        }
    }

    private void rvSaveOnDelete(Context ctx, BOTRelationInfo botrInfo, BOTRelationEntryCollection botrEntryCol, FaRentSettlementBillInfo rsBill) throws BOSException {
        if (new PaymentBillInfo().getBOSType().toString().equals(botrInfo.get("destentityid"))) {
            StringBuffer srcEntryIds = new StringBuffer();
            for (int i = 0; i < botrEntryCol.size(); ++i) {
                srcEntryIds.append("'");
                srcEntryIds.append(botrEntryCol.get(i).getSrcEntryID());
                srcEntryIds.append("'");
                if (i >= botrEntryCol.size() - 1) continue;
                srcEntryIds.append(",");
            }
            String updateEntrySQL = " UPDATE T_FA_FaRentSettlementBillEntry SET FPaymentBillID = null, FRpBillId = null, FRpBillNumber = null, FGenRpBill = 0, FDate = null, FWithTaxAmt = null WHERE FID IN (" + srcEntryIds + ") ";
            DbUtil.execute((Context)ctx, (String)updateEntrySQL);
            this.updatePeriodValue(ctx, botrEntryCol, rsBill);
        }
        if (new ReceivingBillInfo().getBOSType().toString().equals(botrInfo.get("destentityid"))) {
            // empty if block
        }
    }

    private void updatePeriodValue(Context ctx, BOTRelationEntryCollection botrEntryCol, FaRentSettlementBillInfo rsBill) throws BOSException {
        StringBuilder updateBillSQL = new StringBuilder();
        updateBillSQL.append("UPDATE T_FA_FaRentSettlementBill SET FHadPeriod = (\n");
        updateBillSQL.append("SELECT COUNT(1) FROM T_FA_FARENTSETTLEMENTBILL bill\n");
        updateBillSQL.append("LEFT JOIN T_FA_FARENTSETTLEMENTBILLENTRY entry ON bill.FId = entry.FBillID\n");
        updateBillSQL.append("WHERE entry.FGenRpBill = 1 AND bill.FID = ?), \n");
        updateBillSQL.append("FSubPeriod = FTotalPeriod - FHadPeriod WHERE FID = ?");
        DbUtil.execute((Context)ctx, (String)updateBillSQL.toString(), (Object[])new Object[]{rsBill.getId().toString(), rsBill.getId().toString()});
    }

    private boolean compareDateIfCurrentMonth(Date date1, Context ctx) throws EASBizException, BOSException {
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
        PeriodInfo currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.getEnum((int)2001), (CompanyOrgUnitInfo)aCompanyOrgUnitInfo);
        Calendar cld1 = Calendar.getInstance();
        cld1.setTime(date1);
        Calendar cld2 = Calendar.getInstance();
        cld2.set(currentPeriodInfo.getPeriodYear(), currentPeriodInfo.getPeriodNumber() - 1, 1);
        int subMonth = (cld2.get(1) - cld1.get(1)) * 12 + cld2.get(2) - cld1.get(2);
        return subMonth == 0;
    }

    private BigDecimal[] getPlanValueForType(Context ctx, FaLeaseInBillNewInfo newBillInfo) throws BOSException, EASBizException {
        FaLeaseInBillNewInfo originBillInfo = null;
        StringBuilder tmSql = new StringBuilder();
        tmSql.append("SELECT * \n");
        tmSql.append(" FROM T_FA_FaNLMChangeAssetItem \n");
        tmSql.append("WHERE FLEASEINBILLNEWID = ? \n");
        IRowSet tmRs = DbUtil.executeQuery((Context)ctx, (String)tmSql.toString(), (Object[])new String[]{newBillInfo.getId().toString()});
        try {
            if (tmRs.next()) {
                originBillInfo = FaLeaseInBillNewFactory.getLocalInstance(ctx).getFaLeaseInBillNewInfo((IObjectPK)new ObjectUuidPK(tmRs.getString("FLEASEINBILLOLDID")));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (originBillInfo != null && originBillInfo.getId() != null) {
            int i;
            FaPaymentPlanNewCollection originPaymentEntry = FaPaymentPlanNewFactory.getLocalInstance(ctx).getFaPaymentPlanNewCollection("where head.id = '" + originBillInfo.getId().toString() + "' order by payDate, id");
            originPaymentEntry.sort("payDate");
            originPaymentEntry.removeObject(0);
            FaPaymentPlanNewCollection newPaymentEntry = FaPaymentPlanNewFactory.getLocalInstance(ctx).getFaPaymentPlanNewCollection("where head.id = '" + newBillInfo.getId().toString() + "' order by payDate, id");
            newPaymentEntry.sort("payDate");
            newPaymentEntry.removeObject(0);
            BigDecimal originWithValue = new BigDecimal("0");
            BigDecimal originWithoutValue = new BigDecimal("0");
            BigDecimal newWithValue = new BigDecimal("0");
            BigDecimal newWithoutValue = new BigDecimal("0");
            Date newFiAccountDate = newBillInfo.getFiAccountDate();
            Calendar cld = Calendar.getInstance();
            cld.setTime(newFiAccountDate);
            cld.set(12, 0);
            cld.set(13, 0);
            cld.set(14, 0);
            newFiAccountDate = cld.getTime();
            int j = originPaymentEntry.size();
            for (i = 0; i < j; ++i) {
                if (originPaymentEntry.get(i).getPayDate().compareTo(newFiAccountDate) >= 0) continue;
                originWithValue = originWithValue.add(originPaymentEntry.get(i).getPaymentWithTax() == null ? new BigDecimal("0") : originPaymentEntry.get(i).getPaymentWithTax());
                originWithoutValue = originWithoutValue.add(originPaymentEntry.get(i).getPaymentWithoutTax() == null ? new BigDecimal("0") : originPaymentEntry.get(i).getPaymentWithoutTax());
            }
            j = newPaymentEntry.size();
            for (i = 0; i < j; ++i) {
                if (newPaymentEntry.get(i).getPayDate().compareTo(newFiAccountDate) >= 0) continue;
                newWithValue = newWithValue.add(newPaymentEntry.get(i).getPaymentWithTax() == null ? new BigDecimal("0") : newPaymentEntry.get(i).getPaymentWithTax());
                newWithoutValue = newWithoutValue.add(newPaymentEntry.get(i).getPaymentWithoutTax() == null ? new BigDecimal("0") : newPaymentEntry.get(i).getPaymentWithoutTax());
            }
            return new BigDecimal[]{newWithValue.subtract(originWithValue), newWithoutValue.subtract(originWithoutValue)};
        }
        return new BigDecimal[]{BigDecimal.ZERO, BigDecimal.ZERO};
    }
}

