/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.IServiceContext;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.common.AccountConstant;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.basedata.FaDepreciationModeInfo;
import com.kingdee.eas.fi.fa.basedata.FaDepreciationPeriodEnum;
import com.kingdee.eas.fi.fa.basedata.FaDepreciationRuleEnum;
import com.kingdee.eas.fi.fa.manage.FaCardInfo;
import com.kingdee.eas.fi.fa.manage.FaClearStatusEnum;
import com.kingdee.eas.fi.fa.manage.FaCurCardCollection;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaDepCalFacadeFactory;
import com.kingdee.eas.fi.fa.manage.FaDepreciationCollection;
import com.kingdee.eas.fi.fa.manage.FaDepreciationEntryFactory;
import com.kingdee.eas.fi.fa.manage.FaDepreciationFactory;
import com.kingdee.eas.fi.fa.manage.FaDepreciationInfo;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.FaMonCardFactory;
import com.kingdee.eas.fi.fa.manage.FaMonCardInfo;
import com.kingdee.eas.fi.fa.manage.FaPeriodCloseFacadeFactory;
import com.kingdee.eas.fi.fa.manage.FaPeriodException;
import com.kingdee.eas.fi.fa.manage.FaWorkLoadCollection;
import com.kingdee.eas.fi.fa.manage.FaWorkLoadInfo;
import com.kingdee.eas.fi.fa.manage.IFaCurCard;
import com.kingdee.eas.fi.fa.manage.IFaMonCard;
import com.kingdee.eas.fi.fa.manage.app.AbstractFaWorkLoadControllerBean;
import com.kingdee.eas.fi.fa.manage.app.FaDepLocalUtils;
import com.kingdee.eas.fi.fa.manage.app.FaDepStrategyFactory;
import com.kingdee.eas.fi.fa.manage.app.FaDepreCalculator;
import com.kingdee.eas.fi.fa.manage.app.FaLastPeriodChangeUtils;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.fa.manage.app.IFaDepCalStrategy;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.ContextUtil;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class FaWorkLoadControllerBean
extends AbstractFaWorkLoadControllerBean {
    protected boolean _checkLineExist(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return false;
    }

    protected SystemEnum _getOwnedSys(Context ctx) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected IObjectCollection _getCollection(Context ctx, IServiceContext svcCtx, EntityViewInfo view) throws BOSException {
        return super._getCollection(ctx, svcCtx, view);
    }

    @Override
    protected void _batchUpdate(Context ctx, IObjectCollection model) throws BOSException, EASBizException {
        boolean isInitEnd = SystemStatusCtrolUtils.isStart((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)ContextUtil.getCurrentFIUnit((Context)ctx));
        if (!isInitEnd) {
            throw new FaPeriodException(FaPeriodException.FANOTENDINIT);
        }
        if (model == null) {
            return;
        }
        IFaCurCard iCard = FaCurCardFactory.getLocalInstance(ctx);
        HashSet<String> cardSet = new HashSet<String>();
        for (int i = 0; i < model.size(); ++i) {
            FaWorkLoadInfo info = (FaWorkLoadInfo)model.getObject(i);
            if (info == null) continue;
            if (info.getId() == null) {
                info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
            }
            info.setPeriod(this.getCurrentPeriod(ctx));
            info.setCompany(FaLocalUtils.getSimpleCurrentCompany(ctx));
            this.submit(ctx, (CoreBaseInfo)info);
            FaCurCardInfo card = info.getCurCard();
            cardSet.add(card.getId().toString());
            FaCurCardInfo bakCard = iCard.getFaCurCardInfo((IObjectPK)new ObjectUuidPK(card.getId()), FaDepLocalUtils.getDepCardSelector());
            FaDepreciationInfo depreciationInfo = null;
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)FaLocalUtils.getCurrentCompanyId(ctx), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("period.id", (Object)FaLocalUtils.getFACurrentPeriod(FaLocalUtils.getCurrentCompanyId(ctx), ctx).getId().toString(), CompareType.EQUALS));
            viewInfo.setFilter(filterInfo);
            viewInfo.getSelector().add(new SelectorItemInfo("*"));
            FaDepreciationCollection depreciationCollection = FaDepreciationFactory.getLocalInstance(ctx).getFaDepreciationCollection(viewInfo);
            if (depreciationCollection != null && depreciationCollection.size() > 0) {
                depreciationInfo = depreciationCollection.get(0);
                FilterInfo filterInfo1 = new FilterInfo();
                filterInfo1.getFilterItems().add(new FilterItemInfo("faCurCard.id", (Object)card.getId().toString(), CompareType.EQUALS));
                filterInfo1.getFilterItems().add(new FilterItemInfo("LnkFaDepreEntry", (Object)depreciationInfo.getId().toString()));
                bakCard.setIsNeedReDepr(FaDepreciationEntryFactory.getLocalInstance(ctx).exists(filterInfo1));
            }
            FaCurCardCollection cards = new FaCurCardCollection();
            cards.add(bakCard);
            bakCard.setIsNeedReDepr(FaDepCalFacadeFactory.getLocalInstance(ctx).isNeedDep(cards) || bakCard.isIsNeedReDepr());
            if (!FaLocalUtils.isWorkLoadMethod((FaDepreciationModeInfo)bakCard.getDeprMethod()) && bakCard.getTempDeprMethod() != null && bakCard.getTempDeprMethod().length() != 0) {
                bakCard.setTempDeprTermCount(info.getSumWorkLoad());
            } else {
                bakCard.setDeprTermCount(info.getSumWorkLoad());
            }
            if (BigDecimal.ZERO.compareTo(info.getCurrentWorkLoad()) == 0) {
                bakCard.setIsNeedReDepr(false);
                FaDepCalFacadeFactory.getLocalInstance(ctx).undoDep(FaLocalUtils.getFACurrentPeriod(FaLocalUtils.getCurrentCompanyId(ctx), ctx), cards);
            }
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("isNeedReDepr"));
            selector.add(new SelectorItemInfo("tempDeprTermCount"));
            selector.add(new SelectorItemInfo("deprTermCount"));
            iCard.updatePartial((CoreBaseInfo)bakCard, selector);
        }
        if (cardSet.size() > 0) {
            String companyId = FaLocalUtils.getCurrentCompanyId(ctx);
            PeriodInfo[] p = FaPeriodCloseFacadeFactory.getLocalInstance(ctx).getLastestPeriod(companyId);
            if (!p[0].getId().toString().equals(p[1].getId().toString())) {
                HashSet periodSet = FaLocalUtils.getLaterPeriodIdSet(ctx, p[1].getId().toString());
                FaLocalUtils.hasLaterPeriodDep(ctx, companyId, periodSet, cardSet);
                FaLocalUtils.hasFANewBiz(ctx, periodSet, cardSet, companyId);
                String ids = FaLocalUtils.handleIdArray(cardSet);
                FaLastPeriodChangeUtils.updateCurCardLastPeriodChange(ctx, ids);
            }
        }
    }

    private boolean ifNeedReDep(Context ctx, FaCurCardInfo card) throws BOSException, EASBizException {
        Date accountDate;
        String newGovermentAccountingSystem;
        boolean redoDep = this.ifAlreadyDepCal(ctx);
        boolean yearLastPeriod = FaDepLocalUtils.ifYearLastPeriod(ctx, this.getCurrentPeriod(ctx));
        Date periodBegindDate = this.getCurrentPeriod(ctx).getBeginDate();
        Timestamp periodEndDate = this.getCurrentPeriod(ctx).getEndDate();
        Map paramMap = FaDepLocalUtils.getParamNewGovermentAccSystem(ctx);
        String string = newGovermentAccountingSystem = paramMap.get(AccountConstant.GovermentAccountingSystem) != null ? (String)paramMap.get(AccountConstant.GovermentAccountingSystem) : "false";
        if ("true".equalsIgnoreCase(newGovermentAccountingSystem) && card.getAssetCat().isNotCalDep()) {
            return false;
        }
        if (card.getDeprMethod().getPeriod().equals((Object)FaDepreciationPeriodEnum.getEnum((int)2)) && !yearLastPeriod) {
            return false;
        }
        if (card.getAssetCat().getDepreciationPolicy().getDeprRule() == FaDepreciationRuleEnum.NO_REGARDLESS_USESTATUS || card.getAssetCat().getDepreciationPolicy().getDeprRule() == FaDepreciationRuleEnum.DECIDE_BY_USESTATUS && !card.getUseStatus().isIsDepreciation()) {
            return false;
        }
        if (card.getAssetCat().getDepreciationPolicy().getStartDeprTime().getValue() != 0 ? (accountDate = card.getFiAccountDate()).compareTo(periodBegindDate) >= 0 && accountDate.compareTo(periodEndDate) <= 0 : card.getHasCleared().equals((Object)FaClearStatusEnum.HasAllCleared)) {
            return false;
        }
        if (redoDep && card.getDeprTTerm() != null && card.getDeprTTerm().compareTo(new BigDecimal("0")) != 0 && (card.getHasCleared().equals((Object)FaClearStatusEnum.HasPartCleared) || card.getHasCleared().equals((Object)FaClearStatusEnum.HasAllCleared))) {
            return false;
        }
        IFaDepCalStrategy strategy = FaDepStrategyFactory.getStrategyByMethod(card.getDeprMethod());
        IFaDepCalStrategy evalStrategy = FaDepStrategyFactory.getStrategyByMethod(card.getEvalDeprMode());
        FaDepreCalculator calculator = new FaDepreCalculator();
        calculator.setDefaultDpereStrategy(strategy, evalStrategy);
        return calculator.isHaveAmountAndLifeForDep(card, ctx);
    }

    @Override
    protected IObjectCollection _findWorkLoad(Context ctx, EntityViewInfo view, FilterInfo workFilter) throws BOSException, EASBizException {
        CoreBaseCollection cardCollection;
        String strCompanyId = FaLocalUtils.getCurrentCompanyId(ctx);
        view.getSelector().clear();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("useTermCount"));
        view.getSelector().add(new SelectorItemInfo("deprTermCount"));
        view.getSelector().add(new SelectorItemInfo("measureUnitWL.name"));
        view.getSelector().add(new SelectorItemInfo("assetCat.name"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("assetName"));
        view.getSelector().add(new SelectorItemInfo("deprMethod"));
        view.getSelector().add(new SelectorItemInfo("tempDeprMethod"));
        view.getSelector().add(new SelectorItemInfo("tempUseTermCount"));
        view.getSelector().add(new SelectorItemInfo("tempDeprTermCount"));
        view.getSelector().add(new SelectorItemInfo("facurcard.id"));
        FilterInfo filter = view.getFilter();
        int maskCount = filter.getFilterItems().size();
        StringBuffer sb = new StringBuffer(filter.getMaskString() == null ? "" : filter.getMaskString());
        filter.getFilterItems().add(new FilterItemInfo("company", (Object)strCompanyId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("checkedStatus", (Object)2, CompareType.EQUALS));
        for (int i = maskCount; i < filter.getFilterItems().size(); ++i) {
            if (i != 0) {
                sb.append(" and #" + i);
                continue;
            }
            sb.append("#" + i);
        }
        int periodYear = 0;
        int periodNumber = 0;
        PeriodInfo curPeriod = FaLocalUtils.getCurrentPeriod(ctx);
        for (int i = 0; i < workFilter.getFilterItems().size(); ++i) {
            if (workFilter.getFilterItems().get(i).getPropertyName().equalsIgnoreCase("period.periodYear")) {
                periodYear = (Integer)workFilter.getFilterItems().get(i).getCompareValue();
            }
            if (!workFilter.getFilterItems().get(i).getPropertyName().equalsIgnoreCase("period.periodNumber")) continue;
            periodNumber = (Integer)workFilter.getFilterItems().get(i).getCompareValue();
        }
        boolean isCurrentperiod = curPeriod.getPeriodNumber() == periodNumber && curPeriod.getPeriodYear() == periodYear;
        filter.getFilterItems().add(new FilterItemInfo("deprMethod.isWorkload", (Object)new Integer(1), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("deprMethod.isWorkload", (Object)new Integer(1), CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("tempDeprMethod", null, CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("tempDeprMethod", (Object)new String(" "), CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("tempDeprMethod", (Object)new String("null"), CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("tempDeprMethod", (Object)new String(""), CompareType.NOTEQUALS));
        sb.append(" and (#" + (filter.getFilterItems().size() - 6) + " or (#" + (filter.getFilterItems().size() - 5) + " and #" + (filter.getFilterItems().size() - 4) + " and #" + (filter.getFilterItems().size() - 3) + " and #" + (filter.getFilterItems().size() - 2) + " and #" + (filter.getFilterItems().size() - 1) + "))");
        if (isCurrentperiod) {
            filter.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)2, CompareType.NOTEQUALS));
            sb.append(" and #" + (filter.getFilterItems().size() - 1));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("faperiod.periodyear", (Object)new Integer(periodYear)));
            filter.getFilterItems().add(new FilterItemInfo("faperiod.periodnumber", (Object)new Integer(periodNumber)));
            sb.append(" and #" + (filter.getFilterItems().size() - 2) + " and #" + (filter.getFilterItems().size() - 1));
        }
        filter.setMaskString(sb.toString());
        IFaCurCard icard = FaCurCardFactory.getLocalInstance(ctx);
        IFaMonCard imoncard = FaMonCardFactory.getLocalInstance(ctx);
        CoreBaseCollection coreBaseCollection = cardCollection = isCurrentperiod ? icard.getCollection(view) : imoncard.getCollection(view);
        if (cardCollection.size() == 0) {
            return null;
        }
        HashSet<BOSUuid> cardId = new HashSet<BOSUuid>();
        for (FaCardInfo card : cardCollection) {
            cardId.add(isCurrentperiod ? card.getId() : ((FaMonCardInfo)card).getFaCurCard().getId());
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.getSelector().add(new SelectorItemInfo("id"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("currentWorkLoad"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("lastWorkLoad"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("totalWorkLoad"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("sumWorkLoad"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("curcard.id"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("period.periodYear"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("period.periodNumber"));
        workFilter.getFilterItems().add(new FilterItemInfo("company", (Object)strCompanyId, CompareType.EQUALS));
        workFilter.getFilterItems().add(new FilterItemInfo("curcard", cardId, CompareType.INCLUDE));
        entityViewInfo.setFilter(workFilter);
        FaWorkLoadCollection workLoadCollection = this.getFaWorkLoadCollection(ctx, entityViewInfo);
        HashMap<String, FaWorkLoadInfo> hm = new HashMap<String, FaWorkLoadInfo>();
        Iterator itWorkLoad = workLoadCollection.iterator();
        while (itWorkLoad.hasNext()) {
            FaWorkLoadInfo workLoadInfo = (FaWorkLoadInfo)itWorkLoad.next();
            hm.put(workLoadInfo.getCurCard().getId().toString(), workLoadInfo);
        }
        FaWorkLoadCollection returnValue = new FaWorkLoadCollection();
        for (Object o : cardCollection) {
            FaWorkLoadInfo workLoadInfo;
            FaCurCardInfo card;
            FaCurCardInfo faCurCardInfo = card = isCurrentperiod ? (FaCurCardInfo)o : ((FaMonCardInfo)o).getFaCurCard();
            if (!isCurrentperiod) {
                try {
                    FaManageUtils.copyValueBetweenCard((FaCardInfo)o, card, false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!FaLocalUtils.isWorkLoadMethod((FaDepreciationModeInfo)card.getDeprMethod())) {
                card.setUseTermCount(card.getTempUseTermCount());
                card.setDeprTermCount(card.getTempDeprTermCount());
            }
            if (hm.get(card.getId().toString()) != null) {
                workLoadInfo = (FaWorkLoadInfo)hm.get(card.getId().toString());
                workLoadInfo.setCurCard(card);
                workLoadInfo.setTotalWorkLoad(card.getUseTermCount() == null ? new BigDecimal("0") : card.getUseTermCount());
                workLoadInfo.setLastWorkLoad(workLoadInfo.getTotalWorkLoad().subtract(workLoadInfo.getSumWorkLoad()));
                returnValue.add(workLoadInfo);
                continue;
            }
            if (!isCurrentperiod) continue;
            workLoadInfo = new FaWorkLoadInfo();
            workLoadInfo.setCurCard(card);
            workLoadInfo.setCurrentWorkLoad(new BigDecimal("0"));
            workLoadInfo.setTotalWorkLoad(card.getUseTermCount() == null ? new BigDecimal("0") : card.getUseTermCount());
            workLoadInfo.setSumWorkLoad(card.getDeprTermCount() == null ? new BigDecimal("0") : card.getDeprTermCount());
            workLoadInfo.setLastWorkLoad(workLoadInfo.getTotalWorkLoad().subtract(workLoadInfo.getSumWorkLoad()));
            returnValue.add(workLoadInfo);
        }
        return returnValue;
    }

    @Override
    protected IObjectCollection _findWorkLoad(Context ctx, EntityViewInfo view, FilterInfo workFilter, String orgID) throws BOSException, EASBizException {
        CoreBaseCollection cardCollection;
        String strCompanyId = orgID;
        view.getSelector().clear();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("useTermCount"));
        view.getSelector().add(new SelectorItemInfo("deprTermCount"));
        view.getSelector().add(new SelectorItemInfo("measureUnitWL.name"));
        view.getSelector().add(new SelectorItemInfo("assetCat.name"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("assetName"));
        view.getSelector().add(new SelectorItemInfo("deprMethod"));
        view.getSelector().add(new SelectorItemInfo("tempDeprMethod"));
        view.getSelector().add(new SelectorItemInfo("tempUseTermCount"));
        view.getSelector().add(new SelectorItemInfo("tempDeprTermCount"));
        view.getSelector().add(new SelectorItemInfo("facurcard.id"));
        FilterInfo filter = view.getFilter();
        int maskCount = filter.getFilterItems().size();
        StringBuffer sb = new StringBuffer(filter.getMaskString() == null ? "" : filter.getMaskString());
        filter.getFilterItems().add(new FilterItemInfo("company", (Object)strCompanyId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("checkedStatus", (Object)2, CompareType.EQUALS));
        for (int i = maskCount; i < filter.getFilterItems().size(); ++i) {
            if (i != 0) {
                sb.append(" and #" + i);
                continue;
            }
            sb.append("#" + i);
        }
        int periodYear = 0;
        int periodNumber = 0;
        PeriodInfo curPeriod = FaLocalUtils.getCurrentPeriod(ctx);
        for (int i = 0; i < workFilter.getFilterItems().size(); ++i) {
            if (workFilter.getFilterItems().get(i).getPropertyName().equalsIgnoreCase("period.periodYear")) {
                periodYear = (Integer)workFilter.getFilterItems().get(i).getCompareValue();
            }
            if (!workFilter.getFilterItems().get(i).getPropertyName().equalsIgnoreCase("period.periodNumber")) continue;
            periodNumber = (Integer)workFilter.getFilterItems().get(i).getCompareValue();
        }
        boolean isCurrentperiod = curPeriod.getPeriodNumber() == periodNumber && curPeriod.getPeriodYear() == periodYear;
        filter.getFilterItems().add(new FilterItemInfo("deprMethod.isWorkload", (Object)new Integer(1), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("deprMethod.isWorkload", (Object)new Integer(1), CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("tempDeprMethod", null, CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("tempDeprMethod", (Object)new String(" "), CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("tempDeprMethod", (Object)new String("null"), CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("tempDeprMethod", (Object)new String(""), CompareType.NOTEQUALS));
        sb.append(" and (#" + (filter.getFilterItems().size() - 6) + " or (#" + (filter.getFilterItems().size() - 5) + " and #" + (filter.getFilterItems().size() - 4) + " and #" + (filter.getFilterItems().size() - 3) + " and #" + (filter.getFilterItems().size() - 2) + " and #" + (filter.getFilterItems().size() - 1) + "))");
        if (isCurrentperiod) {
            filter.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)2, CompareType.NOTEQUALS));
            sb.append(" and #" + (filter.getFilterItems().size() - 1));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("faperiod.periodyear", (Object)new Integer(periodYear)));
            filter.getFilterItems().add(new FilterItemInfo("faperiod.periodnumber", (Object)new Integer(periodNumber)));
            sb.append(" and #" + (filter.getFilterItems().size() - 2) + " and #" + (filter.getFilterItems().size() - 1));
        }
        filter.setMaskString(sb.toString());
        IFaCurCard icard = FaCurCardFactory.getLocalInstance(ctx);
        IFaMonCard imoncard = FaMonCardFactory.getLocalInstance(ctx);
        CoreBaseCollection coreBaseCollection = cardCollection = isCurrentperiod ? icard.getCollection(view) : imoncard.getCollection(view);
        if (cardCollection.size() == 0) {
            return null;
        }
        HashSet<BOSUuid> cardId = new HashSet<BOSUuid>();
        for (FaCardInfo card : cardCollection) {
            cardId.add(isCurrentperiod ? card.getId() : ((FaMonCardInfo)card).getFaCurCard().getId());
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.getSelector().add(new SelectorItemInfo("id"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("currentWorkLoad"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("lastWorkLoad"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("totalWorkLoad"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("sumWorkLoad"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("curcard.id"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("period.periodYear"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("period.periodNumber"));
        workFilter.getFilterItems().add(new FilterItemInfo("company", (Object)strCompanyId, CompareType.EQUALS));
        workFilter.getFilterItems().add(new FilterItemInfo("curcard", cardId, CompareType.INCLUDE));
        entityViewInfo.setFilter(workFilter);
        FaWorkLoadCollection workLoadCollection = this.getFaWorkLoadCollection(ctx, entityViewInfo);
        HashMap<String, FaWorkLoadInfo> hm = new HashMap<String, FaWorkLoadInfo>();
        Iterator itWorkLoad = workLoadCollection.iterator();
        while (itWorkLoad.hasNext()) {
            FaWorkLoadInfo workLoadInfo = (FaWorkLoadInfo)itWorkLoad.next();
            hm.put(workLoadInfo.getCurCard().getId().toString(), workLoadInfo);
        }
        FaWorkLoadCollection returnValue = new FaWorkLoadCollection();
        for (Object o : cardCollection) {
            FaWorkLoadInfo workLoadInfo;
            FaCurCardInfo card;
            FaCurCardInfo faCurCardInfo = card = isCurrentperiod ? (FaCurCardInfo)o : ((FaMonCardInfo)o).getFaCurCard();
            if (!isCurrentperiod) {
                try {
                    FaManageUtils.copyValueBetweenCard((FaCardInfo)o, card, false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!FaLocalUtils.isWorkLoadMethod((FaDepreciationModeInfo)card.getDeprMethod())) {
                card.setUseTermCount(card.getTempUseTermCount());
                card.setDeprTermCount(card.getTempDeprTermCount());
            }
            if (hm.get(card.getId().toString()) != null) {
                workLoadInfo = (FaWorkLoadInfo)hm.get(card.getId().toString());
                workLoadInfo.setCurCard(card);
                workLoadInfo.setTotalWorkLoad(card.getUseTermCount() == null ? new BigDecimal("0") : card.getUseTermCount());
                workLoadInfo.setLastWorkLoad(workLoadInfo.getTotalWorkLoad().subtract(workLoadInfo.getSumWorkLoad()));
                returnValue.add(workLoadInfo);
                continue;
            }
            if (!isCurrentperiod) continue;
            workLoadInfo = new FaWorkLoadInfo();
            workLoadInfo.setCurCard(card);
            workLoadInfo.setCurrentWorkLoad(new BigDecimal("0"));
            workLoadInfo.setTotalWorkLoad(card.getUseTermCount() == null ? new BigDecimal("0") : card.getUseTermCount());
            workLoadInfo.setSumWorkLoad(card.getDeprTermCount() == null ? new BigDecimal("0") : card.getDeprTermCount());
            workLoadInfo.setLastWorkLoad(workLoadInfo.getTotalWorkLoad().subtract(workLoadInfo.getSumWorkLoad()));
            returnValue.add(workLoadInfo);
        }
        return returnValue;
    }

    private boolean ifAlreadyDepCal(Context ctx) throws BOSException, EASBizException {
        return FaDepLocalUtils.ifAlreadyCal(ctx, this.getCurrentPeriod(ctx));
    }

    private PeriodInfo getCurrentPeriod(Context ctx) throws BOSException, EASBizException {
        return FaLocalUtils.getCurrentPeriod(ctx);
    }
}

