/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.AsstAccountChangeInfo;
import com.kingdee.eas.basedata.master.account.IAsstAccountChangeProcess;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.AssistActItemFactory;
import com.kingdee.eas.fi.fa.manage.AssistActItemInfo;
import com.kingdee.eas.fi.fa.manage.FaLeaseNewDepCostSharingEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaLeaseNewDepCostSharingEntryFactory;
import com.kingdee.eas.fi.fa.manage.FaLeaseNewDepCostSharingEntryInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class FlAsstAccountChangeProcess
implements IAsstAccountChangeProcess {
    private CompanyOrgUnitInfo aCompanyOrgUnitInfo;
    private PeriodInfo flCurrPeriod;

    public void init(Context ctx, AsstAccountChangeInfo change, Map defaultVal) throws BOSException, EASBizException {
        this.aCompanyOrgUnitInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
        this.flCurrPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.FINANCE_LEASE, (CompanyOrgUnitInfo)this.aCompanyOrgUnitInfo);
        if (this.flCurrPeriod == null) {
            return;
        }
        this.checkAccountView(ctx, change.getAccount());
        IRowSet result = this.getDepCollection(ctx, change.getAccount());
        this.updateFaLeaseNewDepCostSharing(ctx, result, change.getAccount(), defaultVal);
    }

    private void checkAccountView(Context ctx, AccountViewInfo accountViewInfo) throws BOSException, EASBizException {
        StringBuilder selectSQL = new StringBuilder();
        selectSQL.append(" select t1.FID id, t2.FNumber billNumber \n");
        selectSQL.append(" from T_FA_FaDepreAndAmort t1 \n");
        selectSQL.append(" inner join T_FA_FaLeaseInBillNew t2 ON t1.FLeaseInBillID = t2.FID \n");
        selectSQL.append(" left join T_FA_FaLeaseNewDepCostSharing dep ON t1.FID = dep.FHeadID \n");
        selectSQL.append(" left join T_FA_FaLeaseNewDepCostEntry entry ON dep.FID = entry.FHeadID \n");
        selectSQL.append(" left join T_BD_Period period ON dep.FPeriodID = period.FID \n");
        selectSQL.append(" left join T_BD_AccountView account ON entry.FAccountViewID = account.FID \n");
        selectSQL.append(" WHERE dep.FPeriodID = ? and entry.FAccountViewID = ? and FiVouchered = 1");
        IRowSet ckRs = DbUtil.executeQuery((Context)ctx, (String)selectSQL.toString(), (Object[])new Object[]{this.flCurrPeriod.getId().toString(), accountViewInfo.getId().toString()});
        try {
            if (ckRs.next()) {
                throw new EASBizException(new NumericExceptionSubItem("001", ""));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private IRowSet getDepCollection(Context ctx, AccountViewInfo accountViewInfo) throws BOSException {
        StringBuilder selectSQL = new StringBuilder();
        selectSQL.append(" select t1.FID id, t2.FID billID, dep.FID depID, entry.FID entryID \n");
        selectSQL.append(" from T_FA_FaDepreAndAmort t1 \n");
        selectSQL.append(" inner join T_FA_FaLeaseInBillNew t2 ON t1.FLeaseInBillID = t2.FID \n");
        selectSQL.append(" left join T_FA_FaLeaseNewDepCostSharing dep ON t1.FID = dep.FHeadID \n");
        selectSQL.append(" left join T_FA_FaLeaseNewDepCostEntry entry ON dep.FID = entry.FHeadID \n");
        selectSQL.append(" left join T_BD_Period period ON dep.FPeriodID = period.FID \n");
        selectSQL.append(" left join T_BD_AccountView account ON entry.FAccountViewID = account.FID \n");
        selectSQL.append(" WHERE dep.FPeriodID = ? and entry.FAccountViewID = ? ");
        return DbUtil.executeQuery((Context)ctx, (String)selectSQL.toString(), (Object[])new Object[]{this.flCurrPeriod.getId().toString(), accountViewInfo.getId().toString()});
    }

    private void updateFaLeaseNewDepCostSharing(Context ctx, IRowSet result, AccountViewInfo accountViewInfo, Map defaultVal) throws BOSException, EASBizException {
        try {
            Set set = defaultVal.keySet();
            Iterator iter = set.iterator();
            StringBuilder stringBuilder = new StringBuilder();
            int count = 0;
            while (iter.hasNext()) {
                AsstActTypeInfo asstActTypeInfo = (AsstActTypeInfo)iter.next();
                CoreBaseInfo asstActTypeObj = (CoreBaseInfo)defaultVal.get(asstActTypeInfo);
                if (asstActTypeObj == null) {
                    stringBuilder.append(count).append("#").append(asstActTypeInfo.getId()).append("#").append("").append("@");
                } else {
                    stringBuilder.append(count).append("#").append(asstActTypeInfo.getId()).append("#").append(asstActTypeObj.getId()).append("@");
                }
                ++count;
            }
            if (stringBuilder.length() != 0) {
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            }
            String updateBillDepSQL = " update T_FA_FaLeaseDepCostSharing set FaLeaseAsstActComposit = ? WHERE FAccountViewID = ? ";
            Object[] billDepParams = new Object[]{stringBuilder.toString(), accountViewInfo.getId().toString()};
            DbUtil.execute((Context)ctx, (String)updateBillDepSQL, (Object[])billDepParams);
            while (result.next()) {
                String depID = result.getString("depID");
                String entryID = result.getString("entryID");
                String updateSQL = " update T_FA_FaLeaseNewDepCostEntry set FaLeaseAsstActComposit = ? WHERE FID = ?";
                Object[] params = new Object[]{stringBuilder.toString(), entryID};
                DbUtil.execute((Context)ctx, (String)updateSQL, (Object[])params);
                FaLeaseNewDepCostSharingEntryCollection faLeaseNewDepCollection = FaLeaseNewDepCostSharingEntryFactory.getLocalInstance(ctx).getFaLeaseNewDepCostSharingEntryCollection("where head = '" + depID + "'");
                String faLeaseNewDepCostSharingStr = "";
                if (faLeaseNewDepCollection != null && faLeaseNewDepCollection.size() != 0) {
                    faLeaseNewDepCostSharingStr = this.getFaLeaseNewDepCostSharingStr(ctx, faLeaseNewDepCollection);
                }
                String updateDepSQL = " update T_FA_FaLeaseNewDepCostSharing set FaLeaseNewDepCostSharing = ? WHERE FID = ?";
                Object[] depParams = new Object[]{faLeaseNewDepCostSharingStr, depID};
                DbUtil.execute((Context)ctx, (String)updateDepSQL, (Object[])depParams);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private String getFaLeaseNewDepCostSharingStr(Context ctx, FaLeaseNewDepCostSharingEntryCollection faLeaseNewDepCostSharingEntryCollection) throws BOSException, EASBizException {
        StringBuilder stringBuilder = new StringBuilder();
        int j = faLeaseNewDepCostSharingEntryCollection.size();
        for (int i = 0; i < j; ++i) {
            FaLeaseNewDepCostSharingEntryInfo faLeaseNewDepCostSharingEntryInfo = faLeaseNewDepCostSharingEntryCollection.get(i);
            AccountViewInfo accountViewInfo = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(faLeaseNewDepCostSharingEntryInfo.getAccountView().getId().toString()));
            stringBuilder.append(accountViewInfo.getLongName());
            stringBuilder.append(" ").append(new BigDecimal("100").multiply(faLeaseNewDepCostSharingEntryInfo.getApportionScale())).append("%");
            String faLeaseAsstActComposit = faLeaseNewDepCostSharingEntryInfo.getFaLeaseAsstActComposit();
            if (faLeaseAsstActComposit != null) {
                String[] faLeaseAsstActList;
                stringBuilder.append(" ");
                for (String s : faLeaseAsstActList = faLeaseAsstActComposit.split("@")) {
                    if ("".equals(s)) continue;
                    String[] faLeaseAsstAct = s.split("#");
                    AsstActTypeInfo asstActTypeInfo = AsstActTypeFactory.getLocalInstance((Context)ctx).getAsstActTypeInfo((IObjectPK)new ObjectUuidPK(faLeaseAsstAct[1]));
                    stringBuilder.append("/").append(asstActTypeInfo.getName()).append("-");
                    if (faLeaseAsstAct.length <= 2 || faLeaseAsstAct[2] == null || "".equals(faLeaseAsstAct[2])) continue;
                    AssistActItemInfo assistActItemInfo = AssistActItemFactory.getLocalInstance(ctx).getAssistActItemInfo((IObjectPK)new ObjectUuidPK(faLeaseAsstAct[2]));
                    stringBuilder.append(assistActItemInfo.getName());
                }
            }
            stringBuilder.append("; ");
        }
        return stringBuilder.toString();
    }

    public void check() throws BOSException, EASBizException {
    }

    public void change() throws BOSException, EASBizException {
    }

    public String requestMutex() throws BOSException, EASBizException {
        return null;
    }

    public void releaseMutex() {
    }
}

