/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.LendingDirectionEnum;
import com.kingdee.eas.fi.fa.manage.NLMAccountBalanceDetailCollection;
import com.kingdee.eas.fi.fa.manage.NLMAccountBalanceDetailFactory;
import com.kingdee.eas.fi.fa.manage.NLMAccountBalanceDetailInfo;
import com.kingdee.eas.fi.fa.manage.NLMBillTypeEnum;
import com.kingdee.eas.fi.fa.manage.app.AbstractNLMReconciliationAnalysisFacadeControllerBean;
import com.kingdee.eas.fi.gl.WSVoucherFactory;
import com.kingdee.eas.fi.gl.ZipUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class NLMReconciliationAnalysisFacadeControllerBean
extends AbstractNLMReconciliationAnalysisFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.fa.manage.app.NLMReconciliationAnalysisFacadeControllerBean");
    private static final BigDecimal ZERO = BigDecimal.ZERO;

    @Override
    protected List _getReconciliationAnalysisData(Context ctx, Map queryCriteria, boolean isShowAll) throws BOSException, EASBizException {
        ArrayList<HashMap<String, String>> result;
        try {
            result = isShowAll ? this.getReconciliationAnalysisDataAll(ctx, queryCriteria) : this.getReconciliationAnalysisDataDifference(ctx, queryCriteria);
        }
        catch (IOException ioException) {
            throw new BOSException((Throwable)ioException);
        }
        catch (SQLException sqlException) {
            throw new BOSException((Throwable)sqlException);
        }
        return result;
    }

    @Override
    protected Map _doDifferenceAnalysis(Context ctx, Map differenceAnalysisConditions) throws BOSException, EASBizException {
        return null;
    }

    private ArrayList<HashMap<String, String>> getReconciliationAnalysisDataDifference(Context ctx, Map queryCriteria) throws BOSException, EASBizException, IOException, SQLException {
        ArrayList<HashMap<String, String>> result = this.getReconciliationAnalysisDataAll(ctx, queryCriteria);
        return result;
    }

    private ArrayList<HashMap<String, String>> getReconciliationAnalysisDataAll(Context ctx, Map queryCriteria) throws BOSException, EASBizException, IOException, SQLException {
        ArrayList result = new ArrayList();
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add("*");
        selectorItemCollection.add("baseCurrency.precision");
        CompanyOrgUnitInfo curCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(queryCriteria.get("orgId").toString()), selectorItemCollection);
        Map<String, Map<String, Map<String, String>>> glQueryData = this.getGlQueryData(ctx, queryCriteria, curCompany);
        Map<String, Map<String, List<NLMAccountBalanceDetailInfo>>> businessSystemQueryData = this.getBusinessSystemQueryData(ctx, queryCriteria, curCompany);
        Map<String, List<String>> glAndBusinessSystemBOTRelation = this.getGlAndBusinessSystemBOTRelation(ctx, glQueryData, curCompany);
        ArrayList<HashMap<String, String>> mergerData = this.getMergerData(ctx, glAndBusinessSystemBOTRelation, glQueryData, businessSystemQueryData, curCompany);
        return mergerData;
    }

    private Map<String, Map<String, List<NLMAccountBalanceDetailInfo>>> getBusinessSystemQueryData(Context ctx, Map queryCriteria, CompanyOrgUnitInfo curCompany) throws EASBizException, BOSException {
        String periodStrInfo = queryCriteria.get("periodYear") + "" + (Integer.parseInt(queryCriteria.get("periodNumber").toString()) <= 9 ? "0" + queryCriteria.get("periodNumber") : queryCriteria.get("periodNumber"));
        String accountNumberStr = this.getAccountNumberStrForNLM(ctx, (Map)queryCriteria.get("accounts"));
        NLMAccountBalanceDetailCollection nlmAccountBalanceDetailCollection = NLMAccountBalanceDetailFactory.getLocalInstance(ctx).getNLMAccountBalanceDetailCollection("select *, currency.name where company.id = '" + curCompany.getId().toString() + "' and period.number = " + periodStrInfo + " and (" + accountNumberStr + ") and accessType = 0");
        return this.parseBusinessSystemQueryData(nlmAccountBalanceDetailCollection, this.getAccountNumberStr(ctx, (Map)queryCriteria.get("accounts")));
    }

    private Map<String, Map<String, List<NLMAccountBalanceDetailInfo>>> parseBusinessSystemQueryData(NLMAccountBalanceDetailCollection nlmAccountBalanceDetailCollection, String accountNumberStr) {
        if (nlmAccountBalanceDetailCollection == null || nlmAccountBalanceDetailCollection.size() == 0 || accountNumberStr == null || accountNumberStr.length() == 0) {
            return new HashMap<String, Map<String, List<NLMAccountBalanceDetailInfo>>>();
        }
        String[] accountNumbers = accountNumberStr.split(";");
        HashMap<String, Map<String, List<NLMAccountBalanceDetailInfo>>> businessSystemData = new HashMap<String, Map<String, List<NLMAccountBalanceDetailInfo>>>(accountNumbers.length);
        for (String accountNumber : accountNumbers) {
            businessSystemData.put(accountNumber, new HashMap());
        }
        for (int i = 0; i < nlmAccountBalanceDetailCollection.size(); ++i) {
            NLMAccountBalanceDetailInfo detailInfo = nlmAccountBalanceDetailCollection.get(i);
            Map businessSystemDataRelation = (Map)businessSystemData.get(detailInfo.getContractCatFieldValue().getNumber());
            if (businessSystemDataRelation.get(detailInfo.getNlmBillID()) == null) {
                ArrayList<NLMAccountBalanceDetailInfo> detailInfoList = new ArrayList<NLMAccountBalanceDetailInfo>();
                detailInfoList.add(detailInfo);
                businessSystemDataRelation.put(detailInfo.getNlmBillID(), detailInfoList);
                continue;
            }
            ((List)businessSystemDataRelation.get(detailInfo.getNlmBillID())).add(detailInfo);
        }
        return businessSystemData;
    }

    private Map<String, Map<String, Map<String, String>>> getGlQueryData(Context ctx, Map queryCriteria, CompanyOrgUnitInfo curCompany) throws BOSException, EASBizException, IOException {
        String periodStrInfo = queryCriteria.get("periodYear") + "" + (Integer.parseInt(queryCriteria.get("periodNumber").toString()) <= 9 ? "0" + queryCriteria.get("periodNumber") : queryCriteria.get("periodNumber"));
        String accountNumberStr = this.getAccountNumberStr(ctx, (Map)queryCriteria.get("accounts"));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("rptType", "SubLedger");
        params.put("companyNumber", curCompany.getNumber());
        params.put("fromPeriodNumber", periodStrInfo);
        params.put("toPeriodNumber", periodStrInfo);
        params.put("accountNumber", accountNumberStr);
        params.put("isCompress", String.valueOf(true));
        params.put("showLocal", String.valueOf(true));
        params.put("showAccountDc", String.valueOf(true));
        params.put("showCurrencyName", String.valueOf(true));
        params.put("showAccountName", String.valueOf(true));
        params.put("showVoucherId", String.valueOf(true));
        params.put("balType", (Boolean)queryCriteria.get("isIncludeUnposted") != false ? String.valueOf(1) : String.valueOf(5));
        String jsonParams = JSON.toJSONString(params);
        String jsonResult = WSVoucherFactory.getLocalInstance((Context)ctx).nGetBalance(jsonParams);
        jsonResult = ZipUtils.gunzip((String)jsonResult);
        Map result = (Map)JSON.parseObject((String)jsonResult, Map.class);
        List rows = (List)result.get("rows");
        return this.parseGlQueryData(rows, accountNumberStr);
    }

    private Map<String, Map<String, Map<String, String>>> parseGlQueryData(List<List<String>> rows, String accountNumberStr) {
        if (rows == null || rows.size() == 0 || accountNumberStr == null || accountNumberStr.length() == 0) {
            return new HashMap<String, Map<String, Map<String, String>>>();
        }
        String[] accountNumbers = accountNumberStr.split(";");
        HashMap<String, Map<String, Map<String, String>>> glQueryData = new HashMap<String, Map<String, Map<String, String>>>(accountNumbers.length);
        for (String accountNumber : accountNumbers) {
            glQueryData.put(accountNumber, new HashMap());
        }
        List<String> columns = rows.get(0);
        for (int i = 2; i < rows.size(); ++i) {
            List<String> rowTmp = rows.get(i);
            if (rowTmp.get(6) == null || "".equals(rowTmp.get(6))) continue;
            Map voucherDateRelation = (Map)glQueryData.get(rowTmp.get(0));
            HashMap<String, String> voucherDate = new HashMap<String, String>();
            voucherDateRelation.put(rowTmp.get(6), voucherDate);
            for (int n = 0; n < rowTmp.size(); ++n) {
                voucherDate.put(columns.get(n), rowTmp.get(n));
            }
        }
        return glQueryData;
    }

    private Map<String, List<String>> getGlAndBusinessSystemBOTRelation(Context ctx, Map<String, Map<String, Map<String, String>>> glQueryData, CompanyOrgUnitInfo curCompany) throws BOSException, SQLException {
        if (glQueryData == null || glQueryData.size() == 0) {
            return new HashMap<String, List<String>>();
        }
        StringBuilder voucherQueryCondition = new StringBuilder();
        HashMap<String, List<String>> botRelation = new HashMap<String, List<String>>();
        for (String accountNumber : glQueryData.keySet()) {
            for (String voucher : glQueryData.get(accountNumber).keySet()) {
                voucherQueryCondition.append(" '").append(voucher).append("',");
            }
        }
        if ("".equals(voucherQueryCondition.toString())) {
            return new HashMap<String, List<String>>();
        }
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT FSrcObjectID, FDestObjectID \n");
        sql.append(" FROM t_bot_relation \n");
        sql.append(" WHERE FDestObjectID in ").append("(").append(voucherQueryCondition.substring(0, voucherQueryCondition.length() - 1)).append(")");
        IRowSet resultSql = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        while (resultSql.next()) {
            if (botRelation.containsKey(resultSql.getString("FDestObjectID"))) {
                botRelation.get(resultSql.getString("FDestObjectID")).add(resultSql.getString("FSrcObjectID"));
                continue;
            }
            ArrayList<String> srcObjectIDs = new ArrayList<String>();
            srcObjectIDs.add(resultSql.getString("FSrcObjectID"));
            botRelation.put(resultSql.getString("FDestObjectID"), srcObjectIDs);
        }
        return botRelation;
    }

    private ArrayList<HashMap<String, String>> getMergerData(Context ctx, Map<String, List<String>> botRelation, Map<String, Map<String, Map<String, String>>> glQueryData, Map<String, Map<String, List<NLMAccountBalanceDetailInfo>>> businessSystemQueryData, CompanyOrgUnitInfo curCompany) throws BOSException, EASBizException {
        ArrayList<HashMap<String, String>> mergerData = new ArrayList<HashMap<String, String>>();
        for (String accountNumber : glQueryData.keySet()) {
            Map<String, Map<String, String>> glData = glQueryData.get(accountNumber);
            Map<String, List<NLMAccountBalanceDetailInfo>> businessSystemData = businessSystemQueryData.get(accountNumber);
            AccountViewInfo accountInfo = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo("where number = '" + accountNumber + "' and companyID = '" + ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString() + "'");
            for (String voucherID : glData.keySet()) {
                List<String> bots = botRelation.get(voucherID);
                if (bots != null) {
                    for (String bot : bots) {
                        if (botRelation.containsKey(voucherID) && businessSystemData != null && businessSystemData.get(bot) != null) {
                            List<NLMAccountBalanceDetailInfo> detailInfoList = businessSystemData.get(bot);
                            for (NLMAccountBalanceDetailInfo detailInfo : detailInfoList) {
                                this.doGetMergerData(mergerData, accountInfo, botRelation, glData.get(voucherID), detailInfo, curCompany);
                            }
                            businessSystemData.put(bot, null);
                            continue;
                        }
                        this.doGetMergerData(mergerData, accountInfo, null, glData.get(voucherID), null, curCompany);
                    }
                    continue;
                }
                this.doGetMergerData(mergerData, accountInfo, null, glData.get(voucherID), null, curCompany);
            }
            if (businessSystemData == null) continue;
            for (String businessSystemID : businessSystemData.keySet()) {
                if (businessSystemData.get(businessSystemID) == null) continue;
                List<NLMAccountBalanceDetailInfo> detailInfoList = businessSystemData.get(businessSystemID);
                for (NLMAccountBalanceDetailInfo detailInfo : detailInfoList) {
                    this.doGetMergerData(mergerData, accountInfo, null, null, detailInfo, curCompany);
                }
            }
        }
        return mergerData;
    }

    private void doGetMergerData(ArrayList<HashMap<String, String>> mergerData, AccountViewInfo accountInfo, Map<String, List<String>> botRelation, Map<String, String> glData, NLMAccountBalanceDetailInfo businessSystemData, CompanyOrgUnitInfo curCompany) {
        HashMap<String, String> mergerDataSingle = new HashMap<String, String>();
        mergerDataSingle.put("ID", "");
        mergerDataSingle.put("accountID", accountInfo != null ? accountInfo.getId().toString() : "");
        mergerDataSingle.put("accountNumber", accountInfo != null ? accountInfo.getNumber() : "");
        mergerDataSingle.put("accountName", accountInfo != null ? accountInfo.getName() : "");
        mergerDataSingle.put("glVoucherID", glData != null ? glData.get("voucherId") : "");
        mergerDataSingle.put("glPostingDate", glData != null ? glData.get("bookedDate") : "");
        mergerDataSingle.put("glVoucherNumber", glData != null ? glData.get("voucherNumber") : "");
        mergerDataSingle.put("glCurrencyName", glData != null ? glData.get("currencyName") : "");
        mergerDataSingle.put("glDebitBaseCurrency", glData != null ? glData.get("debitLocal") : "");
        mergerDataSingle.put("glCreditBaseCurrency", glData != null ? glData.get("creditLocal") : "");
        mergerDataSingle.put("nlmID", businessSystemData != null ? businessSystemData.getNlmBillID() : "");
        mergerDataSingle.put("nlmAccountBalanceID", businessSystemData != null ? businessSystemData.getId().toString() : "");
        mergerDataSingle.put("nlmBillNumber", businessSystemData != null ? businessSystemData.getNlmBillNumber() : "");
        mergerDataSingle.put("nlmBillType", businessSystemData != null ? (businessSystemData.getNlmBillType() == NLMBillTypeEnum.LEASE_BILL || businessSystemData.getNlmBillType() == NLMBillTypeEnum.TERMINATE_BILL ? businessSystemData.getNlmBillSourceType().getAlias() : businessSystemData.getNlmBillType().getAlias()) : "");
        mergerDataSingle.put("nlmAccountBalancePeriod", businessSystemData != null ? String.valueOf(businessSystemData.getPeriod().getNumber()) : "");
        mergerDataSingle.put("nlmAccountBalanceSource", businessSystemData != null ? businessSystemData.getNlmBillGetFieldName().getAlias() : "");
        mergerDataSingle.put("nlmCurrencyName", businessSystemData != null ? businessSystemData.getCurrency().getName() : "");
        mergerDataSingle.put("nlmDebitBaseCurrency", businessSystemData != null ? (businessSystemData.getLendingDirection() == LendingDirectionEnum.LEND ? this.doZeroing(businessSystemData.getNlmBillGetFieldValue(), curCompany.getBaseCurrency().getPrecision()) : this.doZeroing(BigDecimal.ZERO, curCompany.getBaseCurrency().getPrecision())) : "");
        mergerDataSingle.put("nlmCreditBaseCurrency", businessSystemData != null ? (businessSystemData.getLendingDirection() == LendingDirectionEnum.LOAN ? this.doZeroing(businessSystemData.getNlmBillGetFieldValue(), curCompany.getBaseCurrency().getPrecision()) : this.doZeroing(BigDecimal.ZERO, curCompany.getBaseCurrency().getPrecision())) : "");
        mergerDataSingle.put("diffID", "");
        mergerDataSingle.put("diffDebitBaseCurrency", this.doZeroing(new BigDecimal("".equals(mergerDataSingle.get("glDebitBaseCurrency")) ? "0" : (String)mergerDataSingle.get("glDebitBaseCurrency")).subtract(new BigDecimal("".equals(mergerDataSingle.get("nlmDebitBaseCurrency")) ? "0" : (String)mergerDataSingle.get("nlmDebitBaseCurrency"))), curCompany.getBaseCurrency().getPrecision()));
        mergerDataSingle.put("diffCreditBaseCurrency", this.doZeroing(new BigDecimal("".equals(mergerDataSingle.get("glCreditBaseCurrency")) ? "0" : (String)mergerDataSingle.get("glCreditBaseCurrency")).subtract(new BigDecimal("".equals(mergerDataSingle.get("nlmCreditBaseCurrency")) ? "0" : (String)mergerDataSingle.get("nlmCreditBaseCurrency"))), curCompany.getBaseCurrency().getPrecision()));
        mergerDataSingle.put("diffType", "");
        if (ZERO.compareTo(new BigDecimal((String)mergerDataSingle.get("diffDebitBaseCurrency"))) != 0 || ZERO.compareTo(new BigDecimal((String)mergerDataSingle.get("diffCreditBaseCurrency"))) != 0) {
            if ("".equals(mergerDataSingle.get("glVoucherID"))) {
                // empty if block
            }
            if ("".equals(mergerDataSingle.get("nlmID"))) {
                // empty if block
            }
        }
        mergerData.add(mergerDataSingle);
    }

    private String doZeroing(BigDecimal value, int basePrecision) {
        if (value == null) {
            return BigDecimal.ZERO.setScale(basePrecision, 4).toString();
        }
        return BigDecimal.ZERO.compareTo(value) == 0 ? BigDecimal.ZERO.setScale(basePrecision, 4).toString() : value.setScale(basePrecision, 4).toString();
    }

    private String getAccountNumberStr(Context ctx, Map accounts) throws BOSException, EASBizException {
        StringBuilder str = new StringBuilder();
        for (String s : accounts.keySet()) {
            Map singleAccount = (Map)accounts.get(s);
            if (singleAccount == null || singleAccount.size() == 0) continue;
            for (String value : singleAccount.keySet()) {
                String accountID = (String)singleAccount.get(value);
                AccountViewInfo accountInfo = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(accountID));
                str.append(accountInfo.getNumber()).append(";");
            }
        }
        return str.substring(0, str.length() - 1);
    }

    private String getAccountNumberStrForNLM(Context ctx, Map accounts) throws BOSException, EASBizException {
        StringBuilder str = new StringBuilder();
        for (String s : accounts.keySet()) {
            Map singleAccount = (Map)accounts.get(s);
            if (singleAccount == null || singleAccount.size() == 0) continue;
            for (String value : singleAccount.keySet()) {
                String accountID = (String)singleAccount.get(value);
                AccountViewInfo accountInfo = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(accountID));
                str.append(" contractCatFieldValue.number = '").append(accountInfo.getNumber()).append("' or");
            }
        }
        return str.substring(0, str.length() - 2);
    }
}

