/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.dap.DAPVoucherTypeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.common.AccountConstant;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.basedata.FaAlterModeFactory;
import com.kingdee.eas.fi.fa.basedata.FaAlterModeInfo;
import com.kingdee.eas.fi.fa.basedata.FaDepreciationModeInfo;
import com.kingdee.eas.fi.fa.def.FaDefPropertyValueInfo;
import com.kingdee.eas.fi.fa.facade.app.AbstractFaDAPTransStrategy;
import com.kingdee.eas.fi.fa.facade.app.FaDAPClearBillStrategy;
import com.kingdee.eas.fi.fa.facade.app.FaDAPFacade;
import com.kingdee.eas.fi.fa.manage.FaAccountBalanceInfo;
import com.kingdee.eas.fi.fa.manage.FaBakCardCollection;
import com.kingdee.eas.fi.fa.manage.FaBakCardFactory;
import com.kingdee.eas.fi.fa.manage.FaBakCardInfo;
import com.kingdee.eas.fi.fa.manage.FaBizCardFactory;
import com.kingdee.eas.fi.fa.manage.FaBizCardInfo;
import com.kingdee.eas.fi.fa.manage.FaBizStatusEnum;
import com.kingdee.eas.fi.fa.manage.FaCardException;
import com.kingdee.eas.fi.fa.manage.FaCardInfo;
import com.kingdee.eas.fi.fa.manage.FaClearBillEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaClearBillEntryFactory;
import com.kingdee.eas.fi.fa.manage.FaClearBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaClearBillException;
import com.kingdee.eas.fi.fa.manage.FaClearBillFactory;
import com.kingdee.eas.fi.fa.manage.FaClearBillInfo;
import com.kingdee.eas.fi.fa.manage.FaClearStatusEnum;
import com.kingdee.eas.fi.fa.manage.FaCurCardCollection;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaDepCalFacadeFactory;
import com.kingdee.eas.fi.fa.manage.FaDepreciationEntryFactory;
import com.kingdee.eas.fi.fa.manage.FaEvalDepreciationEntryFactory;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.IFaClearBill;
import com.kingdee.eas.fi.fa.manage.app.AbstractPrcFaManageStrategy;
import com.kingdee.eas.fi.fa.manage.app.FaBalanceClrUpdStrategy;
import com.kingdee.eas.fi.fa.manage.app.FaBalanceFacade;
import com.kingdee.eas.fi.fa.manage.app.FaCardDefPropertyPersist;
import com.kingdee.eas.fi.fa.manage.app.FaDepLocalUtils;
import com.kingdee.eas.fi.fa.manage.app.FaDepORMapping;
import com.kingdee.eas.fi.fa.manage.app.FaLastPeriodChangeUtils;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.fa.manage.app.FaStocktakingReportBillControllerBean;
import com.kingdee.eas.fi.fa.manage.app.PrcFaCoreManager;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class PrcFaClearStrategy
extends AbstractPrcFaManageStrategy {
    private static Logger logger = Logger.getLogger(PrcFaClearStrategy.class);
    private Map paramMap = null;
    private CompanyOrgUnitInfo currCompany;

    protected CompanyOrgUnitInfo getCurrentCompany(Context ctx) throws BOSException, EASBizException {
        if (this.currCompany == null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            BOSUuid id = ContextUtil.getCurrentFIUnit((Context)ctx).getId();
            this.currCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(id), sic);
        }
        return this.currCompany;
    }

    @Override
    protected IObjectPK saveBill(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        FaClearBillInfo billInfo = (FaClearBillInfo)model;
        if (billInfo == null) {
            return null;
        }
        IFaClearBill iFactory = FaClearBillFactory.getLocalInstance(ctx);
        billInfo = this.getClearBillInfo(ctx, model);
        iFactory.checkNumberDup(null, (CoreBillBaseInfo)billInfo);
        IObjectPK pk = iFactory.saveSelf((CoreBaseInfo)billInfo);
        FaCurCardCollection curCardCollection = billInfo.get("curCardCollection") != null ? (FaCurCardCollection)((Object)billInfo.get("curCardCollection")) : new FaCurCardCollection();
        for (int i = 0; i < curCardCollection.size(); ++i) {
            FaCurCardInfo curCard = curCardCollection.get(i);
            this.updateCurCardBySQL(ctx, curCard.getBizStatus().getValue(), pk.toString(), curCard.getId().toString());
        }
        return pk;
    }

    @Override
    protected IObjectPK submitBill(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        String companyId = this.getCurrentCompany(ctx).getId().toString();
        boolean isUseCalDepNew = FaManageUtils.getFaParamValue(ctx, "FA_201", companyId);
        if (isUseCalDepNew) {
            if (model.get("tempTable") != null) {
                FaClearBillInfo billInfo = (FaClearBillInfo)model;
                if (billInfo == null) {
                    return null;
                }
                IFaClearBill iFactory = FaClearBillFactory.getLocalInstance(ctx);
                billInfo = this.getClearBillInfo4Submit(ctx, model);
                IObjectPK pk = iFactory.submitSelf((CoreBaseInfo)billInfo);
                String tempTable = model.get("tempTable").toString();
                String inSql = model.get("inTempTable").toString();
                StringBuffer updateSql = new StringBuffer();
                updateSql.append(" update T_FA_FACURCARD set (fbizStatus, flastBillID, flastupdatetime) = ( \n");
                updateSql.append(" select ( case when temp.FbillType = ").append(4).append(" then ").append(" '0301' ");
                updateSql.append(" else ").append(" '0201' ").append(" end ), \n");
                updateSql.append(" '").append(pk.toString()).append("', \n");
                updateSql.append(" GETDATE() \n");
                updateSql.append(" from ").append(tempTable).append(" temp  where T_FA_FACURCARD.fid = temp.fid ) \n");
                updateSql.append(" where T_FA_FACURCARD.fid in ").append(inSql);
                DbUtil.execute((Context)ctx, (String)updateSql.toString());
                logger.error((Object)("--------142--------" + new Date()));
                return pk;
            }
            FaClearBillInfo billInfo = (FaClearBillInfo)model;
            if (billInfo == null) {
                return null;
            }
            IFaClearBill iFactory = FaClearBillFactory.getLocalInstance(ctx);
            billInfo = this.getClearBillInfo(ctx, model);
            IObjectPK pk = iFactory.submitSelf((CoreBaseInfo)billInfo);
            FaCurCardCollection curCardCollection = billInfo.get("curCardCollection") != null ? (FaCurCardCollection)((Object)billInfo.get("curCardCollection")) : new FaCurCardCollection();
            for (int i = 0; i < curCardCollection.size(); ++i) {
                FaCurCardInfo curCard = curCardCollection.get(i);
                this.updateCurCardBySQL(ctx, curCard.getBizStatus().getValue(), pk.toString(), curCard.getId().toString());
            }
            return pk;
        }
        FaClearBillInfo billInfo = (FaClearBillInfo)model;
        if (billInfo == null) {
            return null;
        }
        IFaClearBill iFactory = FaClearBillFactory.getLocalInstance(ctx);
        billInfo = this.getClearBillInfo(ctx, model);
        IObjectPK pk = iFactory.submitSelf((CoreBaseInfo)billInfo);
        FaCurCardCollection curCardCollection = billInfo.get("curCardCollection") != null ? (FaCurCardCollection)((Object)billInfo.get("curCardCollection")) : new FaCurCardCollection();
        for (int i = 0; i < curCardCollection.size(); ++i) {
            FaCurCardInfo curCard = curCardCollection.get(i);
            this.updateCurCardBySQL(ctx, curCard.getBizStatus().getValue(), pk.toString(), curCard.getId().toString());
        }
        return pk;
    }

    protected IObjectPK submitBillNoWF(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        FaClearBillInfo billInfo = (FaClearBillInfo)model;
        if (billInfo == null) {
            return null;
        }
        IFaClearBill iFactory = FaClearBillFactory.getLocalInstance(ctx);
        billInfo = this.getClearBillInfo(ctx, model);
        ServiceStateManager.getInstance().enableNextCallServices();
        IObjectPK pk = null;
        if (billInfo.getId() != null && iFactory.exists((IObjectPK)new ObjectUuidPK(billInfo.getId()))) {
            pk = new ObjectUuidPK(billInfo.getId());
            iFactory.update((IObjectPK)new ObjectUuidPK(billInfo.getId()), (CoreBaseInfo)billInfo);
        } else {
            pk = iFactory.addnew((CoreBaseInfo)billInfo);
        }
        FaCurCardCollection curCardCollection = billInfo.get("curCardCollection") != null ? (FaCurCardCollection)((Object)billInfo.get("curCardCollection")) : new FaCurCardCollection();
        for (int i = 0; i < curCardCollection.size(); ++i) {
            FaCurCardInfo curCard = curCardCollection.get(i);
            this.updateCurCardBySQL(ctx, curCard.getBizStatus().getValue(), pk.toString(), curCard.getId().toString().toString());
        }
        return pk;
    }

    private void handleEntryInfo(Context ctx, FaClearBillEntryInfo entryInfo, PeriodInfo curPeriod, String billInfoId, String billInfoCompanyId) throws EASBizException, BOSException {
        String newGovermentAccountingSystem;
        if (entryInfo == null) {
            return;
        }
        SelectorItemCollection sic = PrcFaCoreManager.getCurCardSelectors();
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.StartDeprTime"));
        sic.add(new SelectorItemInfo("company.baseCurrency.*"));
        sic.add(new SelectorItemInfo("deprMethod.*"));
        sic.add(new SelectorItemInfo("currency.*"));
        sic.add(new SelectorItemInfo("evalDeprMode.*"));
        FaCurCardInfo curCardInfo = entryInfo.getCurCard();
        FaCurCardInfo curCardInfoForDep = FaCurCardFactory.getLocalInstance(ctx).getFaCurCardInfo((IObjectPK)new ObjectUuidPK(curCardInfo.getId()), sic);
        FaBizCardInfo bizCardInfo = PrcFaCoreManager.CurCard2BizCard(curCardInfoForDep);
        bizCardInfo.setId(entryInfo.getBizCard().getId());
        if (bizCardInfo == null) {
            return;
        }
        if (curCardInfo == null) {
            return;
        }
        boolean isDep = FaDepreciationEntryFactory.getLocalInstance(ctx).exists("select fid where LnkFaDepreEntry.period.id='" + curPeriod.getId().toString() + "' and LnkFaDepreEntry.company.id='" + billInfoCompanyId + "' and faCurCard.id='" + curCardInfo.getId().toString() + "'");
        if (!isDep) {
            isDep = FaEvalDepreciationEntryFactory.getLocalInstance(ctx).exists("select fid where LnkFaDepreEntry.period.id='" + curPeriod.getId().toString() + "' and LnkFaDepreEntry.company.id='" + billInfoCompanyId + "' and faCurCard.id='" + curCardInfo.getId().toString() + "'");
        }
        boolean isFullClear = entryInfo.getClrQty().compareTo(curCardInfo.getAssetAmt()) == 0;
        boolean isHasNew = curCardInfo.isHasNew();
        boolean isStartDeprTime = curCardInfoForDep.getAssetCat().getDepreciationPolicy().getStartDeprTime().getValue() != 0;
        boolean isNeedReDepr = curCardInfoForDep.isIsNeedReDepr();
        int pres = curCardInfoForDep.getCompany().getBaseCurrency().getPrecision();
        if (!FaLocalUtils.isWellOnlyMethod((FaDepreciationModeInfo)curCardInfoForDep.getDeprMethod())) {
            if (isDep && !isStartDeprTime) {
                BigDecimal clearAccuDepr = entryInfo.getClrAddupDep() == null ? ZERO : entryInfo.getClrAddupDep();
                BigDecimal accuDepr = curCardInfo.getAccuDepr() == null ? ZERO : curCardInfo.getAccuDepr();
                if (clearAccuDepr.compareTo(accuDepr = accuDepr.multiply(entryInfo.getClrQty()).divide(curCardInfo.getAssetAmt(), pres, 4)) != 0) {
                    isNeedReDepr = true;
                }
            }
            if (curCardInfoForDep.getDeprMethod() != null) {
                if (!isDep && isStartDeprTime) {
                    logger.info((Object)"doNothing");
                }
                if (isDep && !isStartDeprTime) {
                    if (!isFullClear && (curCardInfo.getDeprTTerm() != null && curCardInfo.getDeprTTerm().compareTo(ZERO) > 0 || curCardInfo.getEvalDeprTTerm() != null && curCardInfo.getEvalDeprTTerm().compareTo(ZERO) > 0)) {
                        isNeedReDepr = true;
                    }
                    isNeedReDepr = isFullClear ? false : isNeedReDepr;
                    FaCurCardCollection curCardCollection = new FaCurCardCollection();
                    curCardCollection.add(curCardInfoForDep);
                    FaDepCalFacadeFactory.getLocalInstance(ctx).undoDep(curPeriod, curCardCollection);
                    curCardInfoForDep = FaCurCardFactory.getLocalInstance(ctx).getFaCurCardInfo((IObjectPK)new ObjectUuidPK(curCardInfo.getId()), sic);
                    bizCardInfo.setDeprTermCount(curCardInfoForDep.getDeprTermCount());
                    bizCardInfo.setNeatAmt(curCardInfoForDep.getNeatAmt());
                    bizCardInfo.setNeatValue(curCardInfoForDep.getNeatValue());
                    bizCardInfo.setAccuDeprAll(curCardInfoForDep.getAccuDeprAll());
                    bizCardInfo.setAccuDeprTYear(curCardInfoForDep.getAccuDeprTYear());
                    bizCardInfo.setAccuDepr(curCardInfoForDep.getAccuDepr());
                    bizCardInfo.setDeprCount(curCardInfoForDep.getDeprCount());
                    bizCardInfo.setDeprTTerm(curCardInfoForDep.getDeprTTerm());
                    bizCardInfo.setNeatAmt(curCardInfoForDep.getNeatAmt());
                    bizCardInfo.setEvalDeprPeriodNum(curCardInfoForDep.getEvalDeprPeriodNum());
                    bizCardInfo.setEvalNeatAmt(curCardInfoForDep.getEvalNeatAmt());
                    bizCardInfo.setEvalNeatValue(curCardInfoForDep.getEvalNeatValue());
                    bizCardInfo.setEvalAddDepr(curCardInfoForDep.getEvalAddDepr());
                    bizCardInfo.setEvalYearDepr(curCardInfoForDep.getEvalYearDepr());
                    bizCardInfo.setEvalDeprTTerm(curCardInfoForDep.getEvalDeprTTerm());
                    bizCardInfo.setEvalTaxLeftPeriod(curCardInfoForDep.getEvalTaxLeftPeriod());
                }
            }
        }
        this.calculateBizCardValue(ctx, bizCardInfo, entryInfo, isFullClear);
        FaCurCardInfo curCardInfoNew = PrcFaCoreManager.BizCard2CurCard(bizCardInfo);
        curCardInfoNew.setId(curCardInfo.getId());
        curCardInfoNew.setCheckedStatus(CheckedStatusEnum.AUDITED);
        if (bizCardInfo.getPropertyValue() != null) {
            FaDefPropertyValueInfo pv = FaCardDefPropertyPersist.copy(bizCardInfo.getPropertyValue().getId(), ctx);
            curCardInfoNew.setPropertyValue(pv);
        }
        if (isFullClear) {
            curCardInfoNew.setDeletedStatus(DeletedStatusEnum.DELETED);
            curCardInfoNew.setHasDisabled(true);
        } else {
            curCardInfoNew.setDeletedStatus(DeletedStatusEnum.NORMAL);
        }
        curCardInfoNew.setIsNeedReDepr(FaLocalUtils.isWellOnlyMethod((FaDepreciationModeInfo)curCardInfoForDep.getDeprMethod()) ? false : isNeedReDepr);
        Map paramMap = this.getParamMap(ctx);
        String string = newGovermentAccountingSystem = paramMap.get(AccountConstant.GovermentAccountingSystem) != null ? (String)paramMap.get(AccountConstant.GovermentAccountingSystem) : "false";
        if ("true".equalsIgnoreCase(newGovermentAccountingSystem) && curCardInfoNew.getAssetCat().isNotCalDep()) {
            curCardInfoNew.setIsNeedReDepr(false);
        }
        curCardInfoNew.setHasCleared(isFullClear ? FaClearStatusEnum.HasAllCleared : FaClearStatusEnum.HasPartCleared);
        curCardInfoNew.setBizStatus(isFullClear ? FaBizStatusEnum.HAVE_FULL_CLEANED : FaBizStatusEnum.HAVE_PART_CLEANED);
        curCardInfoNew.setLastBillID(billInfoId);
        FaCurCardFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(curCardInfo.getId()), (CoreBaseInfo)curCardInfoNew);
        this.calculateBizCardValueForFullClear(bizCardInfo, entryInfo, isFullClear, isStartDeprTime);
        FaBizCardFactory.getLocalInstance(ctx).submit((CoreBaseInfo)bizCardInfo);
    }

    @Override
    protected void auditBill(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        String billType;
        FaClearBillInfo billInfo = (FaClearBillInfo)model;
        if (billInfo == null) {
            throw new IllegalArgumentException();
        }
        if (billInfo.getCheckedStatus() == CheckedStatusEnum.AUDITED) {
            throw new FaCardException(FaCardException.ALREADY_AUDIT);
        }
        billInfo.setCheckedStatus(CheckedStatusEnum.AUDITED);
        billInfo.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        billInfo.setBizDate(new Date());
        FaClearBillEntryCollection collection = billInfo.getClearBillEntry();
        if (collection == null) {
            return;
        }
        PeriodInfo curPeriod = this.getCurrentPeriod(ctx, billInfo);
        String isFromStock = model.getString(FaStocktakingReportBillControllerBean.IS_FROM_STOCK_TAKING_REPORT_BILL);
        String string = billType = billInfo.getBillType() == null ? "" : billInfo.getBillType().getValue();
        if ("true".equals(isFromStock) || "2000".equals(billType) || "1000".equals(billType)) {
            for (int i = 0; i < collection.size(); ++i) {
                String newGovermentAccountingSystem;
                FaCurCardInfo curCardInfo;
                FaClearBillEntryInfo entryInfo = collection.get(i);
                if (entryInfo == null) continue;
                SelectorItemCollection sic = PrcFaCoreManager.getCurCardSelectors();
                sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.StartDeprTime"));
                sic.add(new SelectorItemInfo("company.baseCurrency.*"));
                sic.add(new SelectorItemInfo("deprMethod.*"));
                sic.add(new SelectorItemInfo("currency.*"));
                sic.add(new SelectorItemInfo("evalDeprMode.*"));
                FaBizCardInfo bizCardInfo = PrcFaCoreManager.CurCard2BizCard(FaCurCardFactory.getLocalInstance(ctx).getFaCurCardInfo((IObjectPK)new ObjectUuidPK(entryInfo.getCurCard().getId()), sic));
                bizCardInfo.setId(entryInfo.getBizCard().getId());
                if (bizCardInfo == null || (curCardInfo = entryInfo.getCurCard()) == null) continue;
                boolean isDep = FaDepreciationEntryFactory.getLocalInstance(ctx).exists("select fid where LnkFaDepreEntry.period.id='" + curPeriod.getId().toString() + "' and LnkFaDepreEntry.company.id='" + billInfo.getCompany().getId().toString() + "' and faCurCard.id='" + curCardInfo.getId().toString() + "'");
                if (!isDep) {
                    isDep = FaEvalDepreciationEntryFactory.getLocalInstance(ctx).exists("select fid where LnkFaDepreEntry.period.id='" + curPeriod.getId().toString() + "' and LnkFaDepreEntry.company.id='" + billInfo.getCompany().getId().toString() + "' and faCurCard.id='" + curCardInfo.getId().toString() + "'");
                }
                boolean isFullClear = entryInfo.getClrQty().compareTo(curCardInfo.getAssetAmt()) == 0;
                boolean isHasNew = curCardInfo.isHasNew();
                FaCurCardInfo curCardInfoForDep = FaCurCardFactory.getLocalInstance(ctx).getFaCurCardInfo((IObjectPK)new ObjectUuidPK(curCardInfo.getId()), sic);
                boolean isStartDeprTime = curCardInfoForDep.getAssetCat().getDepreciationPolicy().getStartDeprTime().getValue() != 0;
                boolean isNeedReDepr = curCardInfoForDep.isIsNeedReDepr();
                int pres = curCardInfoForDep.getCompany().getBaseCurrency().getPrecision();
                if (!FaLocalUtils.isWellOnlyMethod((FaDepreciationModeInfo)curCardInfoForDep.getDeprMethod())) {
                    if (isDep && !isStartDeprTime) {
                        BigDecimal clearAccuDepr = entryInfo.getClrAddupDep() == null ? ZERO : entryInfo.getClrAddupDep();
                        BigDecimal accuDepr = curCardInfo.getAccuDepr() == null ? ZERO : curCardInfo.getAccuDepr();
                        if (clearAccuDepr.compareTo(accuDepr = accuDepr.multiply(entryInfo.getClrQty()).divide(curCardInfo.getAssetAmt(), pres, 4)) != 0) {
                            isNeedReDepr = true;
                        }
                    }
                    if (curCardInfoForDep.getDeprMethod() != null) {
                        if (!isDep && isStartDeprTime) {
                            logger.error((Object)"doNothing");
                        }
                        if (isDep && !isStartDeprTime) {
                            if (!isFullClear && (curCardInfo.getDeprTTerm() != null && curCardInfo.getDeprTTerm().compareTo(ZERO) > 0 || curCardInfo.getEvalDeprTTerm() != null && curCardInfo.getEvalDeprTTerm().compareTo(ZERO) > 0)) {
                                isNeedReDepr = true;
                            }
                            isNeedReDepr = isFullClear ? false : isNeedReDepr;
                            FaCurCardCollection curCardCollection = new FaCurCardCollection();
                            curCardCollection.add(curCardInfoForDep);
                            FaDepCalFacadeFactory.getLocalInstance(ctx).undoDep(curPeriod, curCardCollection);
                            curCardInfoForDep = FaCurCardFactory.getLocalInstance(ctx).getFaCurCardInfo((IObjectPK)new ObjectUuidPK(curCardInfo.getId()), sic);
                            bizCardInfo.setDeprTermCount(curCardInfoForDep.getDeprTermCount());
                            bizCardInfo.setNeatAmt(curCardInfoForDep.getNeatAmt());
                            bizCardInfo.setNeatValue(curCardInfoForDep.getNeatValue());
                            bizCardInfo.setAccuDeprAll(curCardInfoForDep.getAccuDeprAll());
                            bizCardInfo.setAccuDeprTYear(curCardInfoForDep.getAccuDeprTYear());
                            bizCardInfo.setAccuDepr(curCardInfoForDep.getAccuDepr());
                            bizCardInfo.setDeprCount(curCardInfoForDep.getDeprCount());
                            bizCardInfo.setDeprTTerm(curCardInfoForDep.getDeprTTerm());
                            bizCardInfo.setEvalDeprPeriodNum(curCardInfoForDep.getEvalDeprPeriodNum());
                            bizCardInfo.setEvalNeatAmt(curCardInfoForDep.getEvalNeatAmt());
                            bizCardInfo.setEvalNeatValue(curCardInfoForDep.getEvalNeatValue());
                            bizCardInfo.setEvalAddDepr(curCardInfoForDep.getEvalAddDepr());
                            bizCardInfo.setEvalYearDepr(curCardInfoForDep.getEvalYearDepr());
                            bizCardInfo.setEvalDeprTTerm(curCardInfoForDep.getEvalDeprTTerm());
                            bizCardInfo.setEvalTaxLeftPeriod(curCardInfoForDep.getEvalTaxLeftPeriod());
                        }
                    }
                }
                this.calculateBizCardValue(ctx, bizCardInfo, entryInfo, isFullClear);
                FaCurCardInfo curCardInfoNew = PrcFaCoreManager.BizCard2CurCard(bizCardInfo);
                curCardInfoNew.setId(curCardInfo.getId());
                curCardInfoNew.setCheckedStatus(CheckedStatusEnum.AUDITED);
                if (bizCardInfo.getPropertyValue() != null) {
                    FaDefPropertyValueInfo pv = FaCardDefPropertyPersist.copy(bizCardInfo.getPropertyValue().getId(), ctx);
                    curCardInfoNew.setPropertyValue(pv);
                }
                if (isFullClear) {
                    curCardInfoNew.setDeletedStatus(DeletedStatusEnum.DELETED);
                    curCardInfoNew.setHasDisabled(true);
                } else {
                    curCardInfoNew.setDeletedStatus(DeletedStatusEnum.NORMAL);
                }
                curCardInfoNew.setIsNeedReDepr(FaLocalUtils.isWellOnlyMethod((FaDepreciationModeInfo)curCardInfoForDep.getDeprMethod()) ? false : isNeedReDepr);
                Map paramMap = this.getParamMap(ctx);
                String string2 = newGovermentAccountingSystem = paramMap.get(AccountConstant.GovermentAccountingSystem) != null ? (String)paramMap.get(AccountConstant.GovermentAccountingSystem) : "false";
                if ("true".equalsIgnoreCase(newGovermentAccountingSystem) && curCardInfoNew.getAssetCat().isNotCalDep()) {
                    curCardInfoNew.setIsNeedReDepr(false);
                }
                curCardInfoNew.setHasCleared(isFullClear ? FaClearStatusEnum.HasAllCleared : FaClearStatusEnum.HasPartCleared);
                curCardInfoNew.setBizStatus(isFullClear ? FaBizStatusEnum.HAVE_FULL_CLEANED : FaBizStatusEnum.HAVE_PART_CLEANED);
                curCardInfoNew.setLastBillID(billInfo.getId().toString());
                FaCurCardFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(curCardInfo.getId()), (CoreBaseInfo)curCardInfoNew);
                this.calculateBizCardValueForFullClear(bizCardInfo, entryInfo, isFullClear, isStartDeprTime);
                FaBizCardFactory.getLocalInstance(ctx).submit((CoreBaseInfo)bizCardInfo);
            }
            FaBalanceFacade faBalanceFacade = new FaBalanceFacade();
            faBalanceFacade.setFaBalanceUpdStrategy(new FaBalanceClrUpdStrategy());
            faBalanceFacade.updateFaAccountBalance(ctx, billInfo, curPeriod);
            FaClearBillFactory.getLocalInstance(ctx).passAuditSelf((IObjectPK)new ObjectUuidPK(billInfo.getId()), billInfo);
        } else {
            String sql = "select threadCount threadCount from t_fa_faThreadSize";
            try {
                int i;
                IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql);
                int threadCount = 12;
                while (set.next()) {
                    threadCount = set.getInt("threadCount");
                }
                ExecutorService executor = Executors.newFixedThreadPool(threadCount);
                String billInfoId = billInfo.getId().toString();
                String billInfoCompanyId = billInfo.getCompany().getId().toString();
                ArrayList<Future<String>> futureList = new ArrayList<Future<String>>();
                Future<String> future = null;
                for (i = 0; i < collection.size(); ++i) {
                    FaClearBillEntryInfo entryInfo = collection.get(i);
                    InitCallable callable = new InitCallable(ctx, entryInfo, curPeriod, billInfoId, billInfoCompanyId);
                    future = executor.submit(callable);
                    futureList.add(future);
                }
                for (i = 0; i < futureList.size(); ++i) {
                    ((Future)futureList.get(i)).get();
                }
                executor.shutdown();
                FaBalanceFacade faBalanceFacade = new FaBalanceFacade();
                faBalanceFacade.setFaBalanceUpdStrategy(new FaBalanceClrUpdStrategy());
                faBalanceFacade.updateFaAccountBalance(ctx, billInfo, curPeriod);
                FaClearBillFactory.getLocalInstance(ctx).passAuditSelf((IObjectPK)new ObjectUuidPK(billInfo.getId()), billInfo);
            }
            catch (Exception e) {
                logger.error((Object)e);
                if (e.getCause() != null && e.getCause() instanceof EASBizException) {
                    EASBizException easBizException = (EASBizException)e.getCause();
                    throw easBizException;
                }
                throw new BOSException((Throwable)e);
            }
        }
    }

    @Override
    protected void unAuditBill(Context ctx, IObjectValue model) throws FaClearBillException, EASBizException, BOSException {
        FaClearBillInfo billInfo = (FaClearBillInfo)model;
        if (billInfo == null) {
            throw new IllegalArgumentException();
        }
        if (billInfo.getCheckedStatus() == CheckedStatusEnum.UNAUDITED) {
            throw new FaCardException(FaCardException.ALREADY_UNAUDIT);
        }
        billInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        billInfo.setAuditor(null);
        billInfo.setBizDate(null);
        FaClearBillEntryCollection collection = billInfo.getClearBillEntry();
        if (collection == null) {
            return;
        }
        FaBalanceClrUpdStrategy clrStrategy = new FaBalanceClrUpdStrategy();
        PeriodInfo curPeriod = this.getCurrentPeriod(ctx, billInfo);
        FaBakCardCollection bakCardCollection = new FaBakCardCollection();
        FaCurCardCollection coalDepcurCardCollection = new FaCurCardCollection();
        for (int i = 0; i < collection.size(); ++i) {
            FaBakCardInfo bakCardInfo;
            FaCurCardInfo curCardInfo;
            FaBizCardInfo bizCardInfo;
            FaClearBillEntryInfo entryInfo = collection.get(i);
            if (entryInfo == null || (bizCardInfo = entryInfo.getBizCard()) == null || (curCardInfo = entryInfo.getCurCard()) == null || (bakCardInfo = bizCardInfo.getFaBakCard()).getId() == null) continue;
            SelectorItemCollection sicOfBakCard = PrcFaCoreManager.getBakCardSelectors();
            sicOfBakCard.add(new SelectorItemInfo("company.baseCurrency.*"));
            sicOfBakCard.add(new SelectorItemInfo("assetCat.DepreciationPolicy.*"));
            sicOfBakCard.add(new SelectorItemInfo("deprMethod.*"));
            sicOfBakCard.add(new SelectorItemInfo("assetCat.*"));
            sicOfBakCard.add(new SelectorItemInfo("faCurCard.deprTTerm"));
            sicOfBakCard.add(new SelectorItemInfo("faCurCard.evalDeprTTerm"));
            bakCardInfo = FaBakCardFactory.getLocalInstance(ctx).getFaBakCardInfo((IObjectPK)new ObjectUuidPK(bakCardInfo.getId()), sicOfBakCard);
            FaLocalUtils.reGetBakCostCenterInfo(bakCardInfo, ctx);
            boolean isFullClear = entryInfo.getClrQty().compareTo(bakCardInfo.getAssetAmt()) == 0;
            FaCurCardInfo curCardInfoNew = PrcFaCoreManager.BakCard2CurCard(bakCardInfo);
            curCardInfoNew.setId(curCardInfo.getId());
            if (bakCardInfo.getPropertyValue() != null) {
                FaDefPropertyValueInfo pv = FaCardDefPropertyPersist.copy(bakCardInfo.getPropertyValue().getId(), ctx);
                curCardInfoNew.setPropertyValue(pv);
            }
            curCardInfoNew.setBizStatus(isFullClear ? FaBizStatusEnum.FULL_CLEANING : FaBizStatusEnum.PART_CLEANING);
            curCardInfoNew.setLastBillID(billInfo.getId().toString());
            FaCurCardFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(curCardInfo.getId()), (CoreBaseInfo)curCardInfoNew);
            FaAccountBalanceInfo accBalanceInfo = clrStrategy.getFaAcctBalanceByCurCard(ctx, curCardInfoNew.getId().toString(), billInfo.getCompany().getId().toString(), curPeriod);
            if (!FaLocalUtils.isWellOnlyMethod((FaDepreciationModeInfo)curCardInfoNew.getDeprMethod())) {
                bakCardCollection.add(bakCardInfo);
            }
            if (!FaLocalUtils.isWellOnlyMethod((FaDepreciationModeInfo)curCardInfoNew.getDeprMethod()) || accBalanceInfo.getDepreTerm().compareTo(curCardInfoNew.getDeprTTerm()) == 0) continue;
            coalDepcurCardCollection.add(curCardInfoNew);
        }
        FaBalanceFacade faBalanceFacade = new FaBalanceFacade();
        faBalanceFacade.setFaBalanceUpdStrategy(clrStrategy);
        faBalanceFacade.rollbackFaAccountBalance(ctx, billInfo, curPeriod);
        if (bakCardCollection != null && bakCardCollection.size() > 0) {
            FaDepCalFacadeFactory.getLocalInstance(ctx).calDepForUnAudit((IObjectValue)curPeriod, (IObjectCollection)bakCardCollection, billInfo.getCompany().getId().toString());
        }
        if (coalDepcurCardCollection != null && coalDepcurCardCollection.size() > 0) {
            FaDepORMapping.updateDepForCoal(ctx, curPeriod, billInfo.getCompany().getId().toString(), (IObjectCollection)coalDepcurCardCollection);
        }
        FaClearBillFactory.getLocalInstance(ctx).unpassAuditSelf((IObjectPK)new ObjectUuidPK(billInfo.getId()), billInfo);
    }

    @Override
    protected void generateVourcher(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        FaClearBillInfo clearBill = FaClearBillFactory.getLocalInstance(ctx).getFaClearBillInfo(pk);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("account.*"));
        clearBill.put("forDAP", new Boolean(true));
        FaAlterModeInfo alterModeInfo = FaAlterModeFactory.getLocalInstance((Context)ctx).getFaAlterModeInfo((IObjectPK)new ObjectUuidPK(clearBill.getClearMode().getId()), sic);
        clearBill.setClearMode(alterModeInfo);
        clearBill.put("clearMode.account", alterModeInfo.getAccount());
        FaDAPFacade faDAPFacade = new FaDAPFacade();
        faDAPFacade.setFaBillDAPTransStrategy((AbstractFaDAPTransStrategy)new FaDAPClearBillStrategy());
        faDAPFacade.setBill((BillBaseInfo)clearBill);
        faDAPFacade.generateVourcherViaDAP(ctx, DAPVoucherTypeEnum.FIVoucher);
    }

    @Override
    protected void deleteBill(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        if (pk == null) {
            return;
        }
        FaClearBillInfo billInfo = FaClearBillFactory.getLocalInstance(ctx).getFaClearBillInfo(pk, this.getClearBillSelectors());
        FaClearBillEntryCollection collection = billInfo.getClearBillEntry();
        IObjectPK[] arrayBakCardPK = new IObjectPK[collection.size()];
        IObjectPK[] arrayBizCardPK = new IObjectPK[collection.size()];
        for (int i = 0; i < collection.size(); ++i) {
            FaClearBillEntryInfo clearBillEntry = collection.get(i);
            FaBizCardInfo bizCardInfo = clearBillEntry.getBizCard();
            if (bizCardInfo == null) continue;
            FaBakCardInfo bakCardInfo = bizCardInfo.getFaBakCard();
            arrayBakCardPK[i] = new ObjectUuidPK(bakCardInfo.getId());
            arrayBizCardPK[i] = new ObjectUuidPK(bizCardInfo.getId());
            FaLastPeriodChangeUtils.updateCurCardBySQL(ctx, bakCardInfo.getBizStatus().getValue(), bakCardInfo.getLastBillID(), bakCardInfo.getFaCurCard().getId().toString(), bakCardInfo.isLastPeriodChange());
        }
        FaClearBillFactory.getLocalInstance(ctx).deleteSelf(pk);
        this.deleteBizBakCard(ctx, arrayBizCardPK, arrayBakCardPK, true);
        this.recycleNumber(ctx, billInfo);
    }

    private void processDelCard(Context ctx, FaClearBillInfo clearBillInfo) throws BOSException, EASBizException {
        FaClearBillEntryCollection collection = clearBillInfo.getClearBillEntry();
        FaClearBillInfo clearBillInfoSaved = FaClearBillFactory.getLocalInstance(ctx).getFaClearBillInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)clearBillInfo.getId().toString())), this.getClearBillSelectors());
        FaClearBillEntryCollection collectionSaved = clearBillInfoSaved.getClearBillEntry();
        ArrayList<ObjectUuidPK> listBakCardPK = new ArrayList<ObjectUuidPK>();
        ArrayList<ObjectUuidPK> listBizCardPK = new ArrayList<ObjectUuidPK>();
        ArrayList<ObjectUuidPK> listClearEntryPK = new ArrayList<ObjectUuidPK>();
        for (int i = 0; i < collectionSaved.size(); ++i) {
            FaBizCardInfo bizCardInfo;
            boolean delFlag = true;
            FaClearBillEntryInfo clearEntryInfoSaved = collectionSaved.get(i);
            for (int j = 0; j < collection.size(); ++j) {
                FaClearBillEntryInfo clearEntryInfo = collection.get(j);
                if (!clearEntryInfoSaved.getCurCard().getId().toString().equals((String)clearEntryInfo.get("faCurCard"))) continue;
                delFlag = false;
            }
            if (!delFlag || (bizCardInfo = clearEntryInfoSaved.getBizCard()) == null) continue;
            FaBakCardInfo bakCardInfo = bizCardInfo.getFaBakCard();
            listBakCardPK.add(new ObjectUuidPK(bakCardInfo.getId()));
            listBizCardPK.add(new ObjectUuidPK(bizCardInfo.getId()));
            listClearEntryPK.add(new ObjectUuidPK(clearEntryInfoSaved.getId()));
            FaLastPeriodChangeUtils.updateCurCardBySQL(ctx, bakCardInfo.getBizStatus().getValue(), bakCardInfo.getLastBillID(), bakCardInfo.getFaCurCard().getId().toString(), bakCardInfo.isLastPeriodChange());
        }
        IObjectPK[] arrayBakCardPK = new IObjectPK[listBakCardPK.size()];
        System.arraycopy(listBakCardPK.toArray(), 0, arrayBakCardPK, 0, listBakCardPK.size());
        IObjectPK[] arrayBizCardPK = new IObjectPK[listBizCardPK.size()];
        System.arraycopy(listBizCardPK.toArray(), 0, arrayBizCardPK, 0, listBizCardPK.size());
        IObjectPK[] arrayClearEntryPK = new IObjectPK[listClearEntryPK.size()];
        System.arraycopy(listClearEntryPK.toArray(), 0, arrayClearEntryPK, 0, listClearEntryPK.size());
        if (arrayClearEntryPK.length > 0) {
            FaClearBillEntryFactory.getLocalInstance(ctx).delete(arrayClearEntryPK);
        }
        this.deleteBizBakCard(ctx, arrayBizCardPK, arrayBakCardPK, true);
    }

    public SelectorItemCollection getClearBillSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("clearBillEntry.bizCard.faBakCard.bizStatus"));
        sic.add(new SelectorItemInfo("clearBillEntry.bizCard.faBakCard.lastBillID"));
        sic.add(new SelectorItemInfo("clearBillEntry.bizCard.faBakCard.lastPeriodChange"));
        sic.add(new SelectorItemInfo("clearBillEntry.bizCard.faBakCard.faCurCard.id"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("company.id"));
        return sic;
    }

    private FaClearBillInfo getClearBillInfo4Submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String idsTempTable = model.get("idsTempTable").toString();
        FaClearBillInfo clearBillInfo = (FaClearBillInfo)model;
        StringBuffer fabakfacilitySql = new StringBuffer();
        fabakfacilitySql.append(" INSERT INTO t_fa_fabakfacility (fid, fseq, ffacilityid, ffacilityname, ffacilitymodel, fregisterdate, fquantity, famount, fremark, fmeasureunitid, fstoreplaceid, fkeeperid, ffabakcardid) ");
        fabakfacilitySql.append(" SELECT DBO.NEWBOSID('A2E8CD4B') FID, ");
        fabakfacilitySql.append(" a.fseq, a.ffacilityid, a.ffacilityname, a.ffacilitymodel, a.fregisterdate, a.fquantity, a.famount, a.fremark, a.fmeasureunitid, a.fstoreplaceid, a.fkeeperid, ");
        fabakfacilitySql.append(" temp.fbakid FFABAKCARDID ");
        fabakfacilitySql.append(" from t_fa_facurfacility a inner join ").append(idsTempTable).append(" temp ");
        fabakfacilitySql.append(" on a.ffacurcardid = temp.fid ");
        DbUtil.execute((Context)ctx, (String)fabakfacilitySql.toString());
        StringBuffer fabakcostcenterSql = new StringBuffer();
        fabakcostcenterSql.append(" INSERT INTO t_fa_fabakcostcenter (fid, fseq, fapportionscale, fremark, faccountviewid, fasstacttypeid, fasstactitem, fasstactlname, ffabakcardid) ");
        fabakcostcenterSql.append(" SELECT DBO.NEWBOSID('4891EF2A') FID, ");
        fabakcostcenterSql.append(" a.fseq, a.fapportionscale, a.fremark, a.faccountviewid, a.fasstacttypeid, a.fasstactitem, a.fasstactlname, ");
        fabakcostcenterSql.append(" temp.fbakid FFABAKCARDID ");
        fabakcostcenterSql.append(" FROM t_fa_facurcostcenter a inner join ").append(idsTempTable).append(" temp ");
        fabakcostcenterSql.append(" on a.ffacurcardid = temp.fid ");
        DbUtil.execute((Context)ctx, (String)fabakcostcenterSql.toString());
        StringBuffer fabakdepartmentSql = new StringBuffer();
        fabakdepartmentSql.append(" INSERT INTO t_fa_fabakdepartment (fid, fseq, fusage, fremark, fusedepartmentid, fusepersonid, ffabakcardid) ");
        fabakdepartmentSql.append(" SELECT DBO.NEWBOSID('9E7B97FA') FID, ");
        fabakdepartmentSql.append(" a.fseq, a.fusage, a.fremark, a.fusedepartmentid, a.fusepersonid, ");
        fabakdepartmentSql.append(" temp.fbakid FFABAKCARDID ");
        fabakdepartmentSql.append(" FROM t_fa_facurdepartment a inner join ").append(idsTempTable).append(" temp ");
        fabakdepartmentSql.append(" on a.ffacurcardid = temp.fid ");
        DbUtil.execute((Context)ctx, (String)fabakdepartmentSql.toString());
        StringBuffer faBakAsstActCompositSql = new StringBuffer();
        faBakAsstActCompositSql.append(" insert into t_fa_faBakAsstActComposit (fid, fseq, fasstactitem, fasstacttype, ffabakcostcenterid) ");
        faBakAsstActCompositSql.append(" select newbosid('EFB09895') as fid, T.asstSeq as Feq, T.fAsstActItem, T.FasstActType, B.fid as fFaBakcostCenterId ");
        faBakAsstActCompositSql.append(" FROM (SELECT asst.fAsstActItem, asst.fAsstActType, ct.fseq FSEQ, asst.fseq ASSTSEQ, temp.fid as tempId ");
        faBakAsstActCompositSql.append(" FROM t_fa_facurAsstActComposit asst ");
        faBakAsstActCompositSql.append(" INNER JOIN T_Fa_faCurCostCenter ct ON asst.ffacurCostCenterId = ct.fid ");
        faBakAsstActCompositSql.append(" INNER JOIN ").append(idsTempTable).append(" temp ");
        faBakAsstActCompositSql.append(" on temp.fid = ct.ffacurcardid ");
        faBakAsstActCompositSql.append(" where asst.fAsstActItem is not null ");
        faBakAsstActCompositSql.append(" and asst.FasstActType is not null) T ");
        faBakAsstActCompositSql.append(" INNER JOIN ");
        faBakAsstActCompositSql.append(" (SELECT cost.fid, cost.fseq, temp.fid as tempId from T_fa_fabakCostCenter cost ");
        faBakAsstActCompositSql.append(" INNER JOIN ").append(idsTempTable).append(" temp ");
        faBakAsstActCompositSql.append(" on temp.fbakid = cost.ffabakcardid) B ");
        faBakAsstActCompositSql.append(" ON T.fseq = B.fseq and T.tempId = B.tempId ");
        DbUtil.execute((Context)ctx, (String)faBakAsstActCompositSql.toString());
        StringBuffer fabizfacilitySql = new StringBuffer();
        fabizfacilitySql.append(" INSERT INTO t_fa_fabizfacility (fid, fseq, ffacilityid, ffacilityname, ffacilitymodel, fregisterdate, fquantity, famount, fremark, fmeasureunitid, fstoreplaceid, fkeeperid, ffabizcardid) ");
        fabizfacilitySql.append(" SELECT DBO.NEWBOSID('F536D752') FID, ");
        fabizfacilitySql.append(" a.fseq, a.ffacilityid, a.ffacilityname, a.ffacilitymodel, a.fregisterdate, a.fquantity, a.famount, a.fremark, a.fmeasureunitid, a.fstoreplaceid, a.fkeeperid, ");
        fabizfacilitySql.append(" temp.fbizid FFABIZCARDID ");
        fabizfacilitySql.append(" FROM t_fa_facurfacility a inner join ").append(idsTempTable).append(" temp ");
        fabizfacilitySql.append(" on a.ffacurcardid = temp.fid ");
        DbUtil.execute((Context)ctx, (String)fabizfacilitySql.toString());
        StringBuffer fabizcostcenterSql = new StringBuffer();
        fabizcostcenterSql.append(" INSERT INTO t_fa_fabizcostcenter (fid, fseq, fapportionscale, fremark, faccountviewid, fasstacttypeid, fasstactitem, fasstactlname, ffabizcardid) ");
        fabizcostcenterSql.append(" SELECT DBO.NEWBOSID('3F859371') FID, ");
        fabizcostcenterSql.append(" a.fseq, a.fapportionscale, a.fremark, a.faccountviewid, a.fasstacttypeid, a.fasstactitem, a.fasstactlname, ");
        fabizcostcenterSql.append(" temp.fbizid FFABIZCARDID ");
        fabizcostcenterSql.append(" FROM t_fa_facurcostcenter a inner join ").append(idsTempTable).append(" temp ");
        fabizcostcenterSql.append(" on a.ffacurcardid = temp.fid ");
        DbUtil.execute((Context)ctx, (String)fabizcostcenterSql.toString());
        StringBuffer fabizdepartmentSql = new StringBuffer();
        fabizdepartmentSql.append(" INSERT INTO t_fa_fabizdepartment (fid, fseq, fusage, fremark, fusedepartmentid, fusepersonid, ffabizcardid) ");
        fabizdepartmentSql.append(" SELECT DBO.NEWBOSID('956F3C41') FID, ");
        fabizdepartmentSql.append(" a.fseq, a.fusage, a.fremark, a.fusedepartmentid, a.fusepersonid, ");
        fabizdepartmentSql.append(" temp.fbizid FFABIZCARDID ");
        fabizdepartmentSql.append(" FROM t_fa_facurdepartment a inner join ").append(idsTempTable).append(" temp ");
        fabizdepartmentSql.append(" on a.ffacurcardid = temp.fid ");
        DbUtil.execute((Context)ctx, (String)fabizdepartmentSql.toString());
        StringBuffer faBizAsstActCompositSql = new StringBuffer();
        faBizAsstActCompositSql.append(" INSERT INTO t_fa_faBizAsstActComposit (fid, fseq, fasstactitem, fasstacttype, ffabizcostcenterid) ");
        faBizAsstActCompositSql.append(" SELECT DBO.NEWBOSID('AC8B88AE') FID, T.asstSeq FEQ, T.fAsstActItem, T.FasstActType, B.fid FFABIZCOSTCENTERID ");
        faBizAsstActCompositSql.append(" FROM (SELECT asst.fAsstActItem, asst.fAsstActType, ct.fseq FSEQ, asst.fseq ASSTSEQ, temp.fid as tempId ");
        faBizAsstActCompositSql.append(" FROM t_fa_facurAsstActComposit asst  ");
        faBizAsstActCompositSql.append(" INNER JOIN T_Fa_faCurCostCenter ct ON asst.ffacurCostCenterId = ct.fid ");
        faBizAsstActCompositSql.append(" INNER JOIN ").append(idsTempTable).append(" temp ");
        faBizAsstActCompositSql.append(" on temp.fid = ct.ffacurcardid ");
        faBizAsstActCompositSql.append(" where asst.fAsstActItem is not null ");
        faBizAsstActCompositSql.append(" and asst.FasstActType is not null) T ");
        faBizAsstActCompositSql.append(" INNER JOIN ");
        faBizAsstActCompositSql.append(" (SELECT cost.fid, cost.fseq, temp.fid as tempId FROM T_fa_fabizCostCenter cost ");
        faBizAsstActCompositSql.append(" INNER JOIN ").append(idsTempTable).append(" temp ");
        faBizAsstActCompositSql.append(" on temp.fbizid = cost.ffabizCardid) B ");
        faBizAsstActCompositSql.append(" ON T.fseq = B.fseq and T.tempId = B.tempId ");
        DbUtil.execute((Context)ctx, (String)faBizAsstActCompositSql.toString());
        clearBillInfo.setClearDate(DateTimeUtils.truncateDate((Date)clearBillInfo.getClearDate()));
        clearBillInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        clearBillInfo.setFiVouchered(false);
        clearBillInfo.setPeriod(this.getCurrentPeriod(ctx, clearBillInfo));
        if (clearBillInfo.getId() != null) {
            PrcFaClearStrategy.setBillInfoNumber(ctx, clearBillInfo, FaClearBillFactory.getLocalInstance(ctx));
        }
        return clearBillInfo;
    }

    private FaClearBillInfo getClearBillInfo(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FaClearBillInfo clearBillInfo = (FaClearBillInfo)model;
        FaClearBillEntryCollection collection = clearBillInfo.getClearBillEntry();
        if (clearBillInfo.getId() != null) {
            ObjectUuidPK pk = new ObjectUuidPK(clearBillInfo.getId());
            try {
                FaClearBillFactory.getLocalInstance(ctx).getFaClearBillInfo((IObjectPK)pk);
            }
            catch (Exception e) {
                clearBillInfo.setId(null);
                e.printStackTrace();
            }
        }
        if (clearBillInfo.getId() != null) {
            this.processDelCard(ctx, clearBillInfo);
        }
        FaCurCardCollection curCardCollection = new FaCurCardCollection();
        for (int i = 0; i < collection.size(); ++i) {
            FaClearBillEntryInfo clearEntryInfo = collection.get(i);
            FaCurCardInfo curCard = FaCurCardFactory.getLocalInstance(ctx).getFaCurCardInfo("select id,lastUpdateTime,number,assetName,company.id,bizStatus,leaseStatus,assetAmt,propertyValue.id where id ='" + (String)clearEntryInfo.get("faCurCard") + "'");
            if (curCard == null || curCard.getId() == null) continue;
            boolean isFullClear = clearEntryInfo.getClrQty() == null ? false : clearEntryInfo.getClrQty().compareTo(curCard.getAssetAmt()) == 0;
            FaBizCardInfo bizCard = PrcFaCoreManager.CurCard2BizCard(curCard);
            if (clearEntryInfo.getId() == null || clearEntryInfo.getBizCard() == null) {
                FaCurCardInfo oldCard = new FaCurCardInfo();
                oldCard.put("lastUpdateTime", clearEntryInfo.get("cardUpdateTime"));
                this.checkFaCurCardValid(ctx, oldCard, curCard);
                String bakCardId = this.saveBakCard(ctx, curCard.getId().toString(), isFullClear ? 4 : 3);
                String bizCardId = this.saveBizCard(ctx, curCard.getId().toString(), bakCardId, isFullClear ? 4 : 3);
                bizCard.setId(BOSUuid.read((String)bizCardId));
                FaDefPropertyValueInfo curpv = curCard.getPropertyValue();
                if (curpv != null && curpv.getId() != null) {
                    FaDefPropertyValueInfo bizpv = FaCardDefPropertyPersist.copy(curpv.getId(), ctx);
                    FaCardDefPropertyPersist.updateBizCardPropertyId(ctx, bizCardId, bizpv.getId().toString());
                    bizCard.setPropertyValue(bizpv);
                    FaDefPropertyValueInfo bakpv = FaCardDefPropertyPersist.copy(curpv.getId(), ctx);
                    FaCardDefPropertyPersist.updateBakCardPropertyId(ctx, bakCardId, bakpv.getId().toString());
                }
            } else {
                bizCard.setId(clearEntryInfo.getBizCard().getId());
                FaDefPropertyValueInfo curpv = curCard.getPropertyValue();
                if (curpv != null && curpv.getId() != null) {
                    FaDefPropertyValueInfo bizpv = FaCardDefPropertyPersist.copy(curpv.getId(), ctx);
                    bizCard.setPropertyValue(bizpv);
                }
            }
            if (!isFullClear) {
                curCard.setBizStatus(FaBizStatusEnum.PART_CLEANING);
            } else {
                curCard.setBizStatus(FaBizStatusEnum.FULL_CLEANING);
            }
            curCardCollection.add(curCard);
            clearEntryInfo.setBizCard(bizCard);
            clearEntryInfo.setCurCard(curCard);
        }
        clearBillInfo.setClearDate(DateTimeUtils.truncateDate((Date)clearBillInfo.getClearDate()));
        clearBillInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        clearBillInfo.setFiVouchered(false);
        PeriodInfo currenPeriod = this.getCurrentPeriod(ctx, clearBillInfo);
        Date clearDate = clearBillInfo.getClearDate();
        if (currenPeriod != null && (DateTimeUtils.dayBefore((Date)clearDate, (Date)currenPeriod.getBeginDate()) || DateTimeUtils.dayAfter((Date)clearDate, (Date)currenPeriod.getEndDate()))) {
            clearBillInfo.setPeriod(this.getPeriodByDate(ctx, clearDate, clearBillInfo));
        } else {
            clearBillInfo.setPeriod(this.getCurrentPeriod(ctx, clearBillInfo));
        }
        clearBillInfo.put("curCardCollection", (Object)curCardCollection);
        if (clearBillInfo.getId() == null) {
            PrcFaClearStrategy.setBillInfoNumber(ctx, clearBillInfo, FaClearBillFactory.getLocalInstance(ctx));
        }
        return clearBillInfo;
    }

    private void calculateBizCardValue(Context ctx, FaCardInfo bizCard, FaClearBillEntryInfo clearBillEntry, boolean isFullClear) throws EASBizException, BOSException {
        int currencyScale;
        BigDecimal negativeOne = new BigDecimal("-1");
        int baseCurrencyScale = bizCard.getCompany().getBaseCurrency() != null ? bizCard.getCompany().getBaseCurrency().getPrecision() : 4;
        int n = currencyScale = bizCard.getCurrency() != null ? bizCard.getCurrency().getPrecision() : 4;
        if (!isFullClear) {
            BigDecimal allRate;
            BigDecimal orgClearRadio = clearBillEntry.getClrQty().divide(bizCard.getAssetAmt(), 12, 4);
            BigDecimal deprPrepare = clearBillEntry.getClrAddupDep().subtract(bizCard.getAccuDepr() == null ? ZERO : bizCard.getAccuDepr().multiply(clearBillEntry.getClrQty()).divide(bizCard.getAssetAmt(), baseCurrencyScale, 4));
            bizCard.setAssetAmt(bizCard.getAssetAmt().subtract(clearBillEntry.getClrQty()));
            bizCard.setAssetValue(bizCard.getAssetValue().subtract(clearBillEntry.getClrOriginal()));
            bizCard.setAddonFare(bizCard.getAddonFare() == null ? null : bizCard.getAddonFare().subtract(bizCard.getAddonFare().multiply(orgClearRadio).setScale(baseCurrencyScale, 4)));
            int convertMode = this.getConvertMode(ctx, bizCard);
            Boolean isDirectExchangeRate = convertMode == 0;
            if (bizCard.isIsDeduct()) {
                if (isDirectExchangeRate.booleanValue()) {
                    bizCard.setTaxOriginAmt(bizCard.getAssetValue().subtract(bizCard.getAddonFare() == null ? ZERO : bizCard.getAddonFare()).divide(bizCard.getExRate(), currencyScale, 4));
                    bizCard.setInputTax(bizCard.getTaxOriginAmt().multiply((bizCard.getInputTaxRate() == null ? ZERO : bizCard.getInputTaxRate()).divide(new BigDecimal(100))).setScale(baseCurrencyScale, 4));
                    bizCard.setOriginAmt(bizCard.getTaxOriginAmt().add(bizCard.getInputTax()));
                } else {
                    bizCard.setTaxOriginAmt(bizCard.getAssetValue().subtract(bizCard.getAddonFare() == null ? ZERO : bizCard.getAddonFare()).multiply(bizCard.getExRate()));
                    bizCard.setInputTax(bizCard.getTaxOriginAmt().multiply((bizCard.getInputTaxRate() == null ? ZERO : bizCard.getInputTaxRate()).divide(new BigDecimal(100))).setScale(baseCurrencyScale, 4));
                    bizCard.setOriginAmt(bizCard.getTaxOriginAmt().add(bizCard.getInputTax()));
                }
            } else if (isDirectExchangeRate.booleanValue()) {
                bizCard.setOriginAmt(bizCard.getAssetValue().subtract(bizCard.getAddonFare() == null ? ZERO : bizCard.getAddonFare()).divide(bizCard.getExRate(), currencyScale, 4));
                allRate = (bizCard.getInputTaxRate() == null ? ZERO : bizCard.getInputTaxRate()).divide(new BigDecimal(100)).add(new BigDecimal(1));
                bizCard.setInputTax(bizCard.getOriginAmt().multiply((bizCard.getInputTaxRate() == null ? ZERO : bizCard.getInputTaxRate()).divide(new BigDecimal(100))).divide(allRate, currencyScale, 4));
                bizCard.setTaxOriginAmt(bizCard.getOriginAmt().subtract(bizCard.getInputTax()));
            } else {
                bizCard.setOriginAmt(bizCard.getAssetValue().subtract(bizCard.getAddonFare() == null ? ZERO : bizCard.getAddonFare()).multiply(bizCard.getExRate()));
                allRate = (bizCard.getInputTaxRate() == null ? ZERO : bizCard.getInputTaxRate()).divide(new BigDecimal(100)).add(new BigDecimal(1));
                bizCard.setInputTax(bizCard.getOriginAmt().multiply((bizCard.getInputTaxRate() == null ? ZERO : bizCard.getInputTaxRate()).divide(new BigDecimal(100))).divide(allRate, currencyScale, 4));
                bizCard.setTaxOriginAmt(bizCard.getOriginAmt().subtract(bizCard.getInputTax()));
            }
            BigDecimal initEvalValue = bizCard.getInitEvalValue() == null ? ZERO : bizCard.getInitEvalValue();
            bizCard.setInitEvalValue(initEvalValue.subtract(clearBillEntry.getClrEvalValue() == null ? ZERO : clearBillEntry.getClrEvalValue()));
            bizCard.setAccuDepr(bizCard.getAccuDepr() == null ? ZERO : bizCard.getAccuDepr().subtract(clearBillEntry.getClrAddupDep()));
            bizCard.setAccuDeprTYear(bizCard.getAccuDeprTYear() == null ? ZERO : bizCard.getAccuDeprTYear().subtract(bizCard.getAccuDeprTYear().multiply(orgClearRadio)).subtract(deprPrepare).setScale(baseCurrencyScale, 4));
            bizCard.setDecValue(bizCard.getDecValue() == null ? ZERO : bizCard.getDecValue().subtract(clearBillEntry.getClrDecPrep()));
            bizCard.setNeatRemValue(bizCard.getNeatRemValue() == null ? ZERO : bizCard.getNeatRemValue().subtract(bizCard.getNeatRemValue().multiply(orgClearRadio).setScale(baseCurrencyScale, 4)));
            bizCard.setNeatValue(bizCard.getAssetValue().subtract(bizCard.getAccuDepr()));
            bizCard.setNeatAmt(bizCard.getNeatValue().subtract(bizCard.getDecValue()));
            bizCard.setWellDeprValue(bizCard.getWellDeprValue() == null ? null : bizCard.getWellDeprValue().subtract(bizCard.getWellDeprValue().multiply(orgClearRadio).setScale(baseCurrencyScale, 4)));
            BigDecimal lastEvalValue = bizCard.getLastEvalValue() == null ? ZERO : bizCard.getLastEvalValue();
            bizCard.setLastEvalValue(lastEvalValue.subtract(lastEvalValue.multiply(orgClearRadio).setScale(baseCurrencyScale, 4)));
            bizCard.setAccuDeprAll(bizCard.getAccuDeprAll().subtract(bizCard.getAccuDeprAll().multiply(orgClearRadio).setScale(baseCurrencyScale, 4)));
            if (bizCard.getEvalAssetValue() != null) {
                bizCard.setEvalAssetValue(bizCard.getEvalAssetValue().subtract(orgClearRadio.multiply(bizCard.getEvalAssetValue()).setScale(baseCurrencyScale, 4)));
                bizCard.setEvalAddDepr(bizCard.getEvalAddDepr().subtract(orgClearRadio.multiply(bizCard.getEvalAddDepr()).setScale(baseCurrencyScale, 4)));
                bizCard.setEvalYearDepr(bizCard.getEvalYearDepr().subtract(orgClearRadio.multiply(bizCard.getEvalYearDepr()).setScale(baseCurrencyScale, 4)));
                bizCard.setEvalDecValue(bizCard.getEvalDecValue().subtract(orgClearRadio.multiply(bizCard.getEvalDecValue()).setScale(baseCurrencyScale, 4)));
                bizCard.setEvalRemValue(bizCard.getEvalRemValue().subtract(orgClearRadio.multiply(bizCard.getEvalRemValue()).setScale(baseCurrencyScale, 4)));
                bizCard.setEvalNeatValue(bizCard.getEvalAssetValue().subtract(bizCard.getEvalAddDepr()));
                bizCard.setEvalNeatAmt(bizCard.getEvalNeatValue().subtract(bizCard.getEvalDecValue()));
            }
        }
        bizCard.setOriginDif((bizCard.getOriginDif() != null ? bizCard.getOriginDif() : ZERO).add((clearBillEntry.getClrOriginal() != null ? clearBillEntry.getClrOriginal() : ZERO).multiply(negativeOne).setScale(baseCurrencyScale, 4)));
        bizCard.setOriginAccuDif((bizCard.getOriginAccuDif() != null ? bizCard.getOriginAccuDif() : ZERO).add((clearBillEntry.getClrOriginal() != null ? clearBillEntry.getClrOriginal() : ZERO).multiply(negativeOne).setScale(baseCurrencyScale, 4)));
        bizCard.setAccuDeprChg((bizCard.getAccuDeprChg() != null ? bizCard.getAccuDeprChg() : ZERO).add((clearBillEntry.getClrAddupDep() != null ? clearBillEntry.getClrAddupDep() : ZERO).multiply(negativeOne).setScale(baseCurrencyScale, 4)));
        bizCard.setAccuDeprAccuChg((bizCard.getAccuDeprAccuChg() != null ? bizCard.getAccuDeprAccuChg() : ZERO).add((clearBillEntry.getClrAddupDep() != null ? clearBillEntry.getClrAddupDep() : ZERO).multiply(negativeOne).setScale(baseCurrencyScale, 4)));
        bizCard.setDecValueChg((bizCard.getDecValueChg() != null ? bizCard.getDecValueChg() : ZERO).add((clearBillEntry.getClrDecPrep() != null ? clearBillEntry.getClrDecPrep() : ZERO).multiply(negativeOne).setScale(baseCurrencyScale, 4)));
        bizCard.setDecValueAccuChg((bizCard.getDecValueAccuChg() != null ? bizCard.getDecValueAccuChg() : ZERO).add((clearBillEntry.getClrDecPrep() != null ? clearBillEntry.getClrDecPrep() : ZERO).multiply(negativeOne).setScale(baseCurrencyScale, 4)));
        bizCard.setAccuDeprAccuClean((bizCard.getAccuDeprAccuClean() != null ? bizCard.getAccuDeprAccuClean() : ZERO).add(clearBillEntry.getClrAddupDep() != null ? clearBillEntry.getClrAddupDep() : ZERO));
        bizCard.setAccuDeprAccuCleanTYear((bizCard.getAccuDeprAccuCleanTYear() != null ? bizCard.getAccuDeprAccuCleanTYear() : ZERO).add(clearBillEntry.getClrAddupDep() != null ? clearBillEntry.getClrAddupDep() : ZERO));
    }

    private int getConvertMode(Context ctx, FaCardInfo bizCard) throws BOSException, EASBizException {
        int convertMode = 0;
        CurrencyInfo currency = bizCard.getCurrency();
        CurrencyInfo baseCurrency = bizCard.getCompany().getBaseCurrency();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("baseExchangeTable.*"));
        ObjectUuidPK companyPK = new ObjectUuidPK(this.getCurrentCompany(ctx).getId());
        CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)companyPK, sic);
        ExchangeTableInfo exchangeTableInfo = companyInfo.getBaseExchangeTable();
        if (exchangeTableInfo != null) {
            PeriodInfo currenctPeriod = FaLocalUtils.getCurrentPeriod(ctx, this.getCurrentCompany(ctx).getId().toString());
            IExchangeRate iExchangeRate = ExchangeRateFactory.getLocalInstance((Context)ctx);
            ExchangeRateInfo exchangeRateInfo = iExchangeRate.getExchangeRate((IObjectPK)new ObjectUuidPK(exchangeTableInfo.getId()), (IObjectPK)new ObjectUuidPK(currency.getId()), (IObjectPK)new ObjectUuidPK(baseCurrency.getId()), (Date)currenctPeriod.getEndDate());
            if (exchangeRateInfo != null) {
                convertMode = exchangeRateInfo.getConvertMode() == null ? 0 : exchangeRateInfo.getConvertMode().getValue();
            }
        }
        return convertMode;
    }

    @Override
    protected void checkForUnAudit(Context ctx, BillBaseInfo billInfo, boolean isFromSource) throws EASBizException, BOSException {
        StringBuffer sbHasGenVoucher = new StringBuffer(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"Has_GenVoucher", (Locale)ctx.getOriginLocale()));
        FaClearBillInfo clearBill = (FaClearBillInfo)billInfo;
        if (clearBill.isFiVouchered()) {
            throw new FaCardException(FaCardException.CANNOT_BE_UNAUDITED, new String[]{"", sbHasGenVoucher.toString()});
        }
        if (clearBill.getBillType() != null && !isFromSource && clearBill.getBillType().getValue() != "7000" && clearBill.getBillType().getValue() != "11100" && clearBill.getBillType().getValue() != "12200") {
            throw new FaCardException(FaCardException.BILL_CANNOT_OPERATE, new String[]{clearBill.getNumber(), clearBill.getBillType().getAlias()});
        }
        FaClearBillEntryCollection clearBillEntryCol = clearBill.getClearBillEntry();
        Iterator iter = clearBillEntryCol.iterator();
        while (iter.hasNext()) {
            FaClearBillEntryInfo element = (FaClearBillEntryInfo)iter.next();
            FaCurCardInfo curCard = element.getCurCard();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("lastBillID"));
            sic.add(new SelectorItemInfo("assetName"));
            sic.add(new SelectorItemInfo("number"));
            curCard = FaCurCardFactory.getLocalInstance(ctx).getFaCurCardInfo((IObjectPK)new ObjectUuidPK(curCard.getId()), sic);
            if (curCard.getLastBillID().equals(clearBill.getId().toString()) || isFromSource && (clearBill.getBillType() == null || clearBill.getBillType().getValue() != "9000")) continue;
            throw new FaCardException(FaCardException.CURCARD_HASOTHEROPRATION, new String[]{curCard.getNumber() + "(" + curCard.getAssetName() + ")", "", FaLocalUtils.getEntityAlias(ctx, BOSUuid.getBOSObjectType((String)curCard.getLastBillID(), (boolean)false))});
        }
    }

    private void calculateBizCardValueForFullClear(FaBizCardInfo bizCard, FaClearBillEntryInfo clearBillEntry, boolean isFullClear, boolean isStartDeprTime) {
        if (isFullClear && isStartDeprTime && clearBillEntry.getClrAddupDep().compareTo(bizCard.getAccuDepr()) > 0) {
            BigDecimal preDeprTTerm = clearBillEntry.getClrAddupDep().subtract(bizCard.getAccuDepr());
            bizCard.setDeprTermCount(bizCard.getDeprTermCount().add(new BigDecimal("1")));
            bizCard.setAccuDepr(clearBillEntry.getClrAddupDep());
            bizCard.setAccuDeprTYear(bizCard.getAccuDeprTYear().add(preDeprTTerm));
            bizCard.setNeatValue(bizCard.getNeatValue().subtract(preDeprTTerm));
            bizCard.setNeatAmt(bizCard.getNeatAmt().subtract(preDeprTTerm));
            bizCard.setAccuDeprAll(bizCard.getAccuDeprAll().add(preDeprTTerm));
        }
    }

    private Map getParamMap(Context ctx) throws EASBizException, BOSException {
        if (this.paramMap == null) {
            this.paramMap = FaDepLocalUtils.getParamNewGovermentAccSystem(ctx);
        }
        return this.paramMap;
    }

    private PeriodInfo getPeriodByDate(Context ctx, Date clearDate, FaClearBillInfo clearBillInfo) {
        PeriodInfo periodInfo = new PeriodInfo();
        try {
            periodInfo = this.getCurrentPeriod(ctx, clearBillInfo);
            IPeriod iperiod = PeriodFactory.getLocalInstance((Context)ctx);
            periodInfo = iperiod.getPeriodInfo((IObjectPK)new ObjectUuidPK(periodInfo.getId()));
            String cuId = periodInfo.getCU().getId().toString();
            String periodTypeId = periodInfo.getPeriodType().getId().toString();
            String sql = "where CU.id='" + cuId + "' and PeriodType.id='" + periodTypeId + "' and beginDate<='" + clearDate + "' and endDate>='" + clearDate + "'";
            PeriodCollection periodCollection = PeriodFactory.getLocalInstance((Context)ctx).getPeriodCollection(sql);
            if (periodCollection != null && periodCollection.size() == 1) {
                periodInfo = periodCollection.get(0);
            }
        }
        catch (EASBizException e1) {
            e1.printStackTrace();
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        return periodInfo;
    }

    class InitCallable
    implements Callable<String> {
        private Context ctx;
        private FaClearBillEntryInfo entryInfo;
        private PeriodInfo curPeriod;
        private String billInfoId;
        private String billInfoCompanyId;

        public InitCallable(Context ctx, FaClearBillEntryInfo entryInfo, PeriodInfo curPeriod, String billInfoId, String billInfoCompanyId) {
            this.ctx = ctx;
            this.entryInfo = entryInfo;
            this.curPeriod = curPeriod;
            this.billInfoId = billInfoId;
            this.billInfoCompanyId = billInfoCompanyId;
        }

        @Override
        public String call() throws Exception {
            PrcFaClearStrategy.this.handleEntryInfo(this.ctx, this.entryInfo, this.curPeriod, this.billInfoId, this.billInfoCompanyId);
            return "success";
        }
    }
}

