/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.basedata.FaResUtil;
import com.kingdee.eas.fi.fa.manage.FaBillTypeEnum;
import com.kingdee.eas.fi.fa.manage.FaBizStatusEnum;
import com.kingdee.eas.fi.fa.manage.FaDispatchBillException;
import com.kingdee.eas.fi.fa.manage.FaDispatchBillFactory;
import com.kingdee.eas.fi.fa.manage.FaDispatchBillInfo;
import com.kingdee.eas.fi.fa.manage.FaDispatchDirectionEnum;
import com.kingdee.eas.fi.fa.manage.IFaDispatchBill;
import com.kingdee.eas.fi.fa.manage.app.AbstractPrcFaManageStrategy;
import com.kingdee.eas.fi.fa.manage.app.FaLastPeriodChangeUtils;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.BlockedStatusEnum;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.DateTimeUtils;
import java.util.Date;
import java.util.Locale;
import java.util.Map;

public class PrcFaDispatchStrategy
extends AbstractPrcFaManageStrategy {
    @Override
    protected void deleteBill(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        IFaDispatchBill iFaDispatch = FaDispatchBillFactory.getLocalInstance(ctx);
        FaDispatchBillInfo billInfo = iFaDispatch.getFaDispatchBillInfo("select id,number,company where id ='" + pk + "'");
        FaLastPeriodChangeUtils.restoreBakAndCleanUp(ctx, (CoreBaseInfo)billInfo, new String[]{"fbizstatus", "flastbillid"}, null);
        this.recycleNumber(ctx, billInfo);
        iFaDispatch.deleteSelf(pk);
    }

    @Override
    protected IObjectPK saveBill(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        return this.innerSave(ctx, model, false);
    }

    @Override
    protected IObjectPK submitBill(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        return this.innerSave(ctx, model, true);
    }

    private IObjectPK innerSave(Context ctx, IObjectValue model, boolean isSubmit) throws EASBizException, BOSException {
        IFaDispatchBill iDispatch = FaDispatchBillFactory.getLocalInstance(ctx);
        FaDispatchBillInfo info = (FaDispatchBillInfo)model;
        if (isSubmit) {
            this.chkPermittedUser(ctx, info.getOutCompany().getId(), info.getOutPrincipal(), true);
            this.chkPermittedUser(ctx, info.getInCompany().getId(), info.getInPrincipal(), false);
        }
        info.setHasAffirmed(false);
        info.setDispatchDate(DateTimeUtils.truncateDate((Date)info.getDispatchDate()));
        info.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        info.setDeletedStatus(DeletedStatusEnum.NORMAL);
        info.setBlockedStatus(BlockedStatusEnum.UNBLOCKED);
        info.setDispatchDirection(FaDispatchDirectionEnum.OUT);
        info.setPeriod(FaLocalUtils.getFACurrentPeriod(info.getCompany().getId().toString(), ctx));
        info.setEffectedStatus(isSubmit ? EffectedStatusEnum.EFFECTED : EffectedStatusEnum.TEMPSTORE);
        info.setBizDate(DateTimeUtils.truncateDate((Date)this.getCurrentPeriod(ctx, info).getEndDate()));
        if (info.getId() == null) {
            this.setBillInfoNumber(ctx, info);
        }
        this.checkFaCurCardValid(ctx, this.getCardColFromEntry((IObjectCollection)info.getFaDispatchBillEntry()));
        FaLastPeriodChangeUtils.restoreBakAndCleanUp(ctx, (CoreBaseInfo)info, new String[]{"fbizstatus", "flastbillid"}, null);
        IObjectPK billId = isSubmit ? iDispatch.submitSelf(info) : iDispatch.saveSelf(info);
        String selectCardId = "select fcurcardid from t_fa_fadispatchbillentry where ffadispatchbillid = '" + billId + "'";
        this.saveBizBakCard(ctx, new String[]{selectCardId, "t_fa_fadispatchbillentry", billId.toString(), "FFaDispatchBillID"}, FaBillTypeEnum.DISPATCH, FaBizStatusEnum.DISPATCHING, (Map)model.get("tempTableNames"));
        return billId;
    }

    private void setBillInfoNumber(Context ctx, BillBaseInfo caller) throws EASBizException, BOSException {
        String strCompanyID = caller.getCompany() != null && caller.getCompany().getId() != null ? caller.getCompany().getId().toString() : ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String number = (String)caller.get("number");
        caller.setCU(CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("select id,CU.id,CU.number,CU.name where id='" + caller.getCompany().getId() + "'").getCU());
        int maxCycleNum = 100;
        IFaDispatchBill iDisp = FaDispatchBillFactory.getLocalInstance(ctx);
        String filterString = "where dispatchDirection = 1 and number = '" + number + "' and company.id = '" + strCompanyID + "' " + (caller.get("id") != null ? "and id !='" + caller.get("id") + "'" : "");
        while (number == null || number.equals("") || iDisp.exists(filterString)) {
            if (--maxCycleNum == 0) {
                throw new CodingRuleException(CodingRuleException.ERROR_REFERENCE_INVALID);
            }
            number = iCodingRuleManager.getNumber((IObjectValue)caller, strCompanyID);
            filterString = "where dispatchDirection = 1 and number = '" + number + "' and company.id = '" + strCompanyID + "' " + (caller.get("id") != null ? "and id !='" + caller.get("id") + "'" : "");
        }
        caller.setNumber(number);
    }

    @Override
    protected void auditBill(Context ctx, IObjectValue model) throws EASBizException, BOSException {
    }

    @Override
    protected void unAuditBill(Context ctx, IObjectValue model) throws EASBizException, BOSException {
    }

    @Override
    protected void generateVourcher(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
    }

    public UserInfo chkPermittedUser(Context ctx, BOSUuid companyId, PersonInfo principal, boolean checkClearPermit) throws BOSException, EASBizException {
        IPermission iPermission = PermissionFactory.getLocalInstance((Context)ctx);
        UserCollection userCollection = UserFactory.getLocalInstance((Context)ctx).getUserCollection(" where person = '" + principal.getId() + "'");
        if (userCollection.size() == 0) {
            String releatedUser = checkClearPermit ? FaResUtil.getRes((String)"allocateOut", (Locale)ctx.getOriginLocale()) : FaResUtil.getRes((String)"allocateIn", (Locale)ctx.getOriginLocale());
            throw new FaDispatchBillException(FaDispatchBillException.NOUSRRELEATETOPERSON, new Object[]{releatedUser});
        }
        UserInfo userInfo = null;
        int size = userCollection.size();
        for (int i = 0; i < size; ++i) {
            try {
                if (checkClearPermit) {
                    iPermission.checkFunctionPermission((IObjectPK)new ObjectUuidPK(userCollection.get(i).getId()), (IObjectPK)new ObjectUuidPK(companyId), "fa_cardclean_addnew");
                } else {
                    iPermission.checkFunctionPermission((IObjectPK)new ObjectUuidPK(userCollection.get(i).getId()), (IObjectPK)new ObjectUuidPK(companyId), "fa_card_addNew");
                    iPermission.checkFunctionPermission((IObjectPK)new ObjectUuidPK(userCollection.get(i).getId()), (IObjectPK)new ObjectUuidPK(companyId), "fa_carddispatch_update");
                }
                userInfo = userCollection.get(i);
                break;
            }
            catch (PermissionException e) {
                continue;
            }
        }
        if (userInfo == null) {
            String userName = principal.getName();
            if (checkClearPermit) {
                throw new FaDispatchBillException(FaDispatchBillException.NOPERMADDCLEARBILL, new Object[]{userName});
            }
            throw new FaDispatchBillException(FaDispatchBillException.NOPERMADDCARDMODIDISPATCHBILL, new Object[]{userName});
        }
        return userInfo;
    }
}

