/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.basedata.EvaluateRuleEnum;
import com.kingdee.eas.fi.fa.basedata.FaDepreciationModeFactory;
import com.kingdee.eas.fi.fa.basedata.FaDepreciationModeInfo;
import com.kingdee.eas.fi.fa.basedata.FaEvaItemAssetInfo;
import com.kingdee.eas.fi.fa.basedata.FaEvaItemOddUseLifeInfo;
import com.kingdee.eas.fi.fa.basedata.FaEvaSchemeInfo;
import com.kingdee.eas.fi.fa.basedata.FaResUtil;
import com.kingdee.eas.fi.fa.manage.FaAccountBalanceInfo;
import com.kingdee.eas.fi.fa.manage.FaBakCardCollection;
import com.kingdee.eas.fi.fa.manage.FaBakCardFactory;
import com.kingdee.eas.fi.fa.manage.FaBakCardInfo;
import com.kingdee.eas.fi.fa.manage.FaBillBaseInfo;
import com.kingdee.eas.fi.fa.manage.FaBillOriginEnum;
import com.kingdee.eas.fi.fa.manage.FaBillTypeEnum;
import com.kingdee.eas.fi.fa.manage.FaBizCardFactory;
import com.kingdee.eas.fi.fa.manage.FaBizCardInfo;
import com.kingdee.eas.fi.fa.manage.FaBizStatusEnum;
import com.kingdee.eas.fi.fa.manage.FaChangeBillEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaChangeBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaChangeBillFactory;
import com.kingdee.eas.fi.fa.manage.FaChangeBillInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCardCollection;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaDepCalFacadeFactory;
import com.kingdee.eas.fi.fa.manage.FaEvaValueCollection;
import com.kingdee.eas.fi.fa.manage.FaEvaValueInfo;
import com.kingdee.eas.fi.fa.manage.FaEvaluateBillEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaEvaluateBillEntryFactory;
import com.kingdee.eas.fi.fa.manage.FaEvaluateBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaEvaluateBillException;
import com.kingdee.eas.fi.fa.manage.FaEvaluateBillFactory;
import com.kingdee.eas.fi.fa.manage.FaEvaluateBillInfo;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.FaPublishedStatusEnum;
import com.kingdee.eas.fi.fa.manage.IFaBakCard;
import com.kingdee.eas.fi.fa.manage.IFaBizCard;
import com.kingdee.eas.fi.fa.manage.IFaChangeBill;
import com.kingdee.eas.fi.fa.manage.IFaCurCard;
import com.kingdee.eas.fi.fa.manage.IFaDepCalFacade;
import com.kingdee.eas.fi.fa.manage.IFaEvaluateBill;
import com.kingdee.eas.fi.fa.manage.IFaEvaluateBillEntry;
import com.kingdee.eas.fi.fa.manage.app.AbstractPrcFaManageStrategy;
import com.kingdee.eas.fi.fa.manage.app.FaBalanceEvaUpdStrategy;
import com.kingdee.eas.fi.fa.manage.app.FaBalanceFacade;
import com.kingdee.eas.fi.fa.manage.app.FaCardDefPropertyPersist;
import com.kingdee.eas.fi.fa.manage.app.FaLastPeriodChangeUtils;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.fa.manage.app.PrcFaChangeStrategy;
import com.kingdee.eas.fi.fa.manage.app.PrcFaCoreManager;
import com.kingdee.eas.framework.BlockedStatusEnum;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PrcFaEvaStrategy
extends AbstractPrcFaManageStrategy {
    private static final Logger logger = Logger.getLogger(PrcFaEvaStrategy.class);

    @Override
    protected IObjectPK saveBill(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        return this.innerSaveBill(ctx, (FaEvaluateBillInfo)model, false);
    }

    @Override
    protected IObjectPK submitBill(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        return this.innerSaveBill(ctx, (FaEvaluateBillInfo)model, true);
    }

    @Override
    protected void auditBill(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        IFaEvaluateBill iEvaluate = FaEvaluateBillFactory.getLocalInstance(ctx);
        IFaEvaluateBillEntry iEvaluateEntry = FaEvaluateBillEntryFactory.getLocalInstance(ctx);
        IFaCurCard iCurCard = FaCurCardFactory.getLocalInstance(ctx);
        IFaBizCard iBizCard = FaBizCardFactory.getLocalInstance(ctx);
        IFaBakCard iBakCard = FaBakCardFactory.getLocalInstance(ctx);
        IFaChangeBill iChangeBill = FaChangeBillFactory.getLocalInstance(ctx);
        IExchangeRate iExchangeRate = ExchangeRateFactory.getLocalInstance((Context)ctx);
        String updateCardSql = "update t_fa_facurcard set fbizstatus = ? , flastbillid = ?,FHasEvaled = ? where fid in (" + this.getEntryCol("entry.fcurcardid") + ")";
        DbUtil.execute((Context)ctx, (String)updateCardSql, (Object[])new Object[]{"0899", model.get("id").toString(), new Integer(1), model.get("id").toString()});
        String updateEvaledSql = "update t_fa_facurcard set fisevaledbefore = 1 where fid in (select entry.fcurcardid from t_fa_faevaluatebill bill inner join t_fa_faevaluatebillentry entry on bill.fid = entry.FFaEvaluateBillID where bill.fid = ?)";
        DbUtil.execute((Context)ctx, (String)updateEvaledSql, (Object[])new Object[]{model.get("id").toString()});
        String getEvaInfoSql = "select *,evaluateScheme.*,faEvaluateBillEntry.faCurCard.id where id ='" + model.get("id") + "'";
        FaEvaluateBillInfo evaInfo = iEvaluate.getFaEvaluateBillInfo(getEvaInfoSql);
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(evaInfo.getCompany().getId()));
        FaEvaSchemeInfo scheme = evaInfo.getEvaluateScheme();
        FaEvaluateBillEntryCollection entries = evaInfo.getFaEvaluateBillEntry();
        PrcFaChangeStrategy changeStrategy = new PrcFaChangeStrategy();
        if (scheme.getAllRule() == EvaluateRuleEnum.ACCOUNT_ADJUST) {
            List list = FaManageUtils.getItemInfo((String)scheme.getFaEvaItem());
            Map evaValues = this.getEvaValues(ctx, evaInfo.getId().toString());
            boolean isAssetValueEva = list.contains(new FaEvaItemAssetInfo());
            boolean isOddUseLifeEva = list.contains(new FaEvaItemOddUseLifeInfo());
            boolean isChangeCard = scheme.isChangeCard();
            boolean isClearDepreciation = scheme.isClearDepreciation();
            CurrencyInfo baseCurrency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(company.getBaseCurrency().getId()));
            SelectorItemCollection updateCardSic = this.getUpdateCardSelector();
            SelectorItemCollection updateStatusSic = this.getUpdateStatusSelector();
            SelectorItemCollection evaEntrySic = this.getUpdateEvaEntrySelector();
            FaChangeBillInfo templateChangeInfo = this.getChangeBillInfoTemplate(ctx, scheme, evaInfo);
            SelectorItemCollection fullCurCardSic = this.getFullCurCardSelector();
            fullCurCardSic.add(new SelectorItemInfo("assetCat.calcuByEvaluate"));
            int size = entries.size();
            for (int i = 0; i < size; ++i) {
                BigDecimal originChg = ZERO;
                BigDecimal accuDeprChg = ZERO;
                FaEvaluateBillEntryInfo entry = entries.get(i);
                FaCurCardInfo curCardInfo = iCurCard.getFaCurCardInfo((IObjectPK)new ObjectUuidPK(entry.getFaCurCard().getId()), fullCurCardSic);
                FaCurCardInfo bakCardInfo = (FaCurCardInfo)curCardInfo.clone();
                StringBuffer changeDesc = new StringBuffer(FaResUtil.getRes((String)"mechanismBill", (Locale)ctx.getOriginLocale()));
                if (isAssetValueEva) {
                    curCardInfo.setLastEvalValue(curCardInfo.getInitEvalValue());
                    curCardInfo.setInitEvalValue((BigDecimal)evaValues.get("" + entry.getId() + 1));
                    if (curCardInfo.getAssetCat().isCalcuByEvaluate()) {
                        curCardInfo.setNeatValue(curCardInfo.getInitEvalValue().subtract(curCardInfo.getAccuDepr()));
                        curCardInfo.setNeatAmt(curCardInfo.getNeatValue().subtract(curCardInfo.getDecValue()));
                    }
                }
                if (isOddUseLifeEva) {
                    BigDecimal evaPeriod = (BigDecimal)evaValues.get("" + entry.getId() + 2);
                    curCardInfo.setEvalLeftPeriod(evaPeriod);
                }
                if (isChangeCard || isClearDepreciation) {
                    if (isChangeCard) {
                        if (isAssetValueEva) {
                            BigDecimal assetValueEva = (BigDecimal)evaValues.get("" + entry.getId() + 1);
                            originChg = assetValueEva.subtract(curCardInfo.getAssetValue());
                            curCardInfo.setAssetValue(assetValueEva);
                            BigDecimal rateScale = new BigDecimal("1.0");
                            CurrencyInfo oriCurrency = curCardInfo.getCurrency();
                            if (!oriCurrency.getId().toString().equals(baseCurrency.getId().toString())) {
                                if (company.getBaseExchangeTable() == null) {
                                    throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{FaResUtil.getRes((String)"baseRate", (Locale)ctx.getOriginLocale())});
                                }
                                ExchangeRateInfo exchangeRateInfo = iExchangeRate.getExchangeRate((IObjectPK)new ObjectUuidPK(company.getBaseExchangeTable().getId()), (IObjectPK)new ObjectUuidPK(oriCurrency.getId()), (IObjectPK)new ObjectUuidPK(baseCurrency.getId()), null);
                                if (exchangeRateInfo != null) {
                                    rateScale = exchangeRateInfo.getConvertRate();
                                }
                            }
                            BigDecimal addons = curCardInfo.getAddons() == null ? new BigDecimal("0") : curCardInfo.getAddons();
                            BigDecimal originAmt = assetValueEva.subtract(addons).divide(rateScale, oriCurrency.getPrecision(), 4);
                            curCardInfo.setOriginAmt(originAmt);
                        }
                        if (isOddUseLifeEva) {
                            curCardInfo.setUseTermCount((BigDecimal)evaValues.get("" + entry.getId() + 2));
                        }
                        changeDesc.append(FaResUtil.getRes((String)"evaluateChg", (Locale)ctx.getOriginLocale()));
                    }
                    if (isClearDepreciation) {
                        accuDeprChg = curCardInfo.getAccuDepr().multiply(new BigDecimal("-1.0"));
                        curCardInfo.setAccuDepr(ZERO);
                        curCardInfo.setAccuDeprTYear(ZERO);
                        curCardInfo.setDeprTermCount(ZERO);
                        curCardInfo.setAccuDeprAll(ZERO);
                        curCardInfo.setDeprTTerm(ZERO);
                        changeDesc.append(isChangeCard ? "" : FaResUtil.getRes((String)"totaoDprCleamByEvaluate", (Locale)ctx.getOriginLocale()));
                    }
                    if (!curCardInfo.getAssetCat().isCalcuByEvaluate()) {
                        curCardInfo.setNeatValue(curCardInfo.getAssetValue().subtract(curCardInfo.getAccuDepr()));
                    } else {
                        curCardInfo.setNeatValue(curCardInfo.getInitEvalValue().subtract(curCardInfo.getAccuDepr()));
                    }
                    curCardInfo.setNeatAmt(curCardInfo.getNeatValue().subtract(curCardInfo.getDecValue()));
                    String selecter = "select *,faEvaluateBillEntry.faCurCard.id,faEvaluateBillEntry.faCurCard.initEvalValue,faEvaluateBillEntry.faCurCard.lastEvalValue,faEvaluateBillEntry.faCurCard.assetValue ,faEvaluateBillEntry.evaValue.*,faEvaluateBillEntry.faCurCard.accuDeprTYear,faEvaluateBillEntry.faCurCard.accuDepr where id ='" + model.get("id") + "'";
                    FaEvaluateBillInfo evaBillInfo = iEvaluate.getFaEvaluateBillInfo(selecter);
                    FaEvaluateBillEntryCollection evaBillEnties = evaBillInfo.getFaEvaluateBillEntry();
                    IFaCurCard curCard = FaCurCardFactory.getLocalInstance(ctx);
                    FaCurCardInfo faCurCardInfo = null;
                    Iterator iter = evaBillEnties.iterator();
                    while (iter.hasNext()) {
                        FaEvaluateBillEntryInfo evaBillEntryInfo = (FaEvaluateBillEntryInfo)iter.next();
                        FaEvaValueCollection evaValueCol = evaBillEntryInfo.getEvaValue();
                        BigDecimal evaAmt = null;
                        for (int j = 0; j < evaValueCol.size(); ++j) {
                            FaEvaValueInfo evaValue = evaValueCol.get(j);
                            if (evaValue.getMainType().getValue() != 1 || evaValue.getSubType().getValue() != "00") continue;
                            evaAmt = evaValue.getEvaValue();
                        }
                        if (ZERO.compareTo(evaAmt) != 0 || (faCurCardInfo = (FaCurCardInfo)curCard.getValue((IObjectPK)new ObjectUuidPK(evaBillEntryInfo.getFaCurCard().getId()))) == null) continue;
                        faCurCardInfo.setAccuDepr(ZERO);
                        faCurCardInfo.setAccuDeprTYear(ZERO);
                    }
                    FaChangeBillInfo changeInfo = (FaChangeBillInfo)templateChangeInfo.clone();
                    PrcFaEvaStrategy.setBillInfoNumber(ctx, changeInfo, FaChangeBillFactory.getLocalInstance(ctx));
                    changeInfo.setDescription(changeDesc.toString());
                    FaBakCardInfo bakCard = FaManageUtils.CurCard2BakCard(bakCardInfo);
                    bakCard.setFaCurCard(curCardInfo);
                    if (bakCard.getPropertyValue() != null) {
                        bakCard.setPropertyValue(FaCardDefPropertyPersist.copy(bakCard.getPropertyValue().getId(), ctx));
                    }
                    bakCard.setBillType(FaBillTypeEnum.CHANGE);
                    iBakCard.addnew((CoreBaseInfo)bakCard);
                    FaBizCardInfo bizCard = FaManageUtils.CurCard2BizCard(curCardInfo);
                    if (bizCard.getPropertyValue() != null) {
                        bizCard.setPropertyValue(FaCardDefPropertyPersist.copy(bizCard.getPropertyValue().getId(), ctx));
                    }
                    bizCard.setBillType(FaBillTypeEnum.CHANGE);
                    bizCard.setFaBakCard(bakCard);
                    FaChangeBillEntryInfo changeEntryInfo = changeInfo.getChangeBillEntry().get(0);
                    changeEntryInfo.setBizCard(bizCard);
                    changeEntryInfo.setCurCard(curCardInfo);
                    changeEntryInfo.setOriginChg(originChg);
                    changeEntryInfo.setAccuDeprChg(accuDeprChg);
                    iChangeBill.addnew((CoreBaseInfo)changeInfo);
                    changeStrategy.auditBill(ctx, (IObjectValue)changeInfo);
                    entry.setFaChangeBill(changeInfo);
                    iEvaluateEntry.updatePartial((CoreBaseInfo)entry, evaEntrySic);
                }
                curCardInfo.setLastBillID(evaInfo.getId().toString());
                curCardInfo.setBizStatus(FaBizStatusEnum.HAVE_EVALUATED);
                if (isChangeCard || isClearDepreciation) {
                    iCurCard.updatePartial((CoreBaseInfo)curCardInfo, updateCardSic);
                    continue;
                }
                iCurCard.updatePartial((CoreBaseInfo)curCardInfo, updateStatusSic);
            }
        }
        FaBalanceFacade faBalanceFacade = new FaBalanceFacade();
        faBalanceFacade.setFaBalanceUpdStrategy(new FaBalanceEvaUpdStrategy());
        getEvaInfoSql = "select *,faEvaluateBillEntry.faCurCard.id,faEvaluateBillEntry.faCurCard.initEvalValue,faEvaluateBillEntry.faCurCard.lastEvalValue,faEvaluateBillEntry.faCurCard.assetValue where id ='" + model.get("id") + "'";
        evaInfo = iEvaluate.getFaEvaluateBillInfo(getEvaInfoSql);
        faBalanceFacade.updateFaAccountBalance(ctx, evaInfo, evaInfo.getPeriod());
        iEvaluate.passAuditSelf((IObjectPK)new ObjectUuidPK(evaInfo.getId()), (FaBillBaseInfo)model);
    }

    @Override
    protected void unAuditBill(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        IFaEvaluateBill iEvaluate = FaEvaluateBillFactory.getLocalInstance(ctx);
        IFaCurCard iCurCard = FaCurCardFactory.getLocalInstance(ctx);
        IFaBakCard iBakCard = FaBakCardFactory.getLocalInstance(ctx);
        IFaEvaluateBillEntry iEvaluateEntry = FaEvaluateBillEntryFactory.getLocalInstance(ctx);
        IFaChangeBill iChangeBill = FaChangeBillFactory.getLocalInstance(ctx);
        IFaDepCalFacade iFaDepCal = FaDepCalFacadeFactory.getLocalInstance(ctx);
        PrcFaChangeStrategy changeStrategy = new PrcFaChangeStrategy();
        FaBalanceEvaUpdStrategy evaUpdStrategy = new FaBalanceEvaUpdStrategy();
        SelectorItemCollection updateEvaEntrySic = this.getUpdateEvaEntrySelector();
        SelectorItemCollection changeBillSic = this.getChangeBillSelector();
        FaEvaluateBillInfo info = iEvaluate.getFaEvaluateBillInfo("select *,period.*,faEvaluateBillEntry.*,faEvaluateBillEntry.faCurCard.fiVouchered,faEvaluateBillEntry.faCurCard.deprMethod.number,faEvaluateBillEntry.faCurCard.deprMethod.id,faEvaluateBillEntry.faCurCard.initEvalValue,faEvaluateBillEntry.faCurCard.lastEvalValue,faEvaluateBillEntry.faCurCard.assetValue,faEvaluateBillEntry.faBizCard.faBakCard.id where id ='" + model.get("id") + "'");
        FaBalanceFacade faBalanceFacade = new FaBalanceFacade();
        faBalanceFacade.setFaBalanceUpdStrategy(new FaBalanceEvaUpdStrategy());
        faBalanceFacade.rollbackFaAccountBalance(ctx, info, info.getPeriod());
        FaEvaluateBillEntryCollection entries = info.getFaEvaluateBillEntry();
        FaCurCardCollection undoDepCards = new FaCurCardCollection();
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            FaAccountBalanceInfo accBalanceInfo;
            FaEvaluateBillEntryInfo entry = entries.get(i);
            FaCurCardInfo oldCurCardInfo = entry.getFaCurCard();
            boolean isNeedUnDepre = false;
            if (entry.getFaChangeBill() != null && entry.getFaChangeBill().getId() != null) {
                BOSUuid changeBillId = entry.getFaChangeBill().getId();
                entry.setFaChangeBill(null);
                iEvaluateEntry.updatePartial((CoreBaseInfo)entry, updateEvaEntrySic);
                CoreBaseInfo changeBillInfo = iChangeBill.getValue((IObjectPK)new ObjectUuidPK(changeBillId), changeBillSic);
                changeStrategy.unAuditBill(ctx, (IObjectValue)changeBillInfo);
                changeStrategy.deleteBill(ctx, (IObjectPK)new ObjectUuidPK(changeBillId));
                isNeedUnDepre = true;
            }
            SelectorItemCollection sicOfBak = PrcFaCoreManager.getBakCardSelectors();
            sicOfBak.add(new SelectorItemInfo("faCurCard.id"));
            sicOfBak.add(new SelectorItemInfo("faCurCard.deprTTerm"));
            sicOfBak.add(new SelectorItemInfo("faCurCard.evalDeprTTerm"));
            FaBakCardInfo bakCardInfo = iBakCard.getFaBakCardInfo((IObjectPK)new ObjectUuidPK(entry.getFaBizCard().getFaBakCard().getId()), sicOfBak);
            if (bakCardInfo.getDeprMethod() != null) {
                bakCardInfo.setDeprMethod(FaDepreciationModeFactory.getLocalInstance((Context)ctx).getFaDepreciationModeInfo((IObjectPK)new ObjectUuidPK(bakCardInfo.getDeprMethod().getId().toString())));
            }
            FaLocalUtils.reGetBakCostCenterInfo(bakCardInfo, ctx);
            FaCurCardInfo curCardInfo = FaManageUtils.BakCard2CurCard(bakCardInfo);
            curCardInfo.setId(oldCurCardInfo.getId());
            curCardInfo.setBizStatus(FaBizStatusEnum.EVALUATING);
            curCardInfo.setHasEvaled(false);
            iCurCard.update((IObjectPK)new ObjectUuidPK(curCardInfo.getId()), (CoreBaseInfo)curCardInfo);
            boolean isWellOnly = FaLocalUtils.isWellOnlyMethod((FaDepreciationModeInfo)curCardInfo.getDeprMethod());
            FaBakCardCollection bakcards = new FaBakCardCollection();
            if (!FaLocalUtils.isWellOnlyMethod((FaDepreciationModeInfo)bakCardInfo.getDeprMethod())) {
                bakcards.add(bakCardInfo);
            }
            FaDepCalFacadeFactory.getLocalInstance(ctx).calDepForUnAudit((IObjectValue)info.getPeriod(), (IObjectCollection)bakcards);
            if (!isNeedUnDepre || (accBalanceInfo = evaUpdStrategy.getFaAcctBalanceByCurCard(ctx, oldCurCardInfo.getId().toString(), info.getCompany().getId().toString(), info.getPeriod())).getDepreTerm().compareTo(ZERO) == 0 || isWellOnly) continue;
            undoDepCards.add(oldCurCardInfo);
        }
        if (undoDepCards.size() > 0) {
            iFaDepCal.undoDep(info.getPeriod(), undoDepCards);
            StringBuffer sql = new StringBuffer("update t_fa_facurcard set fisNeedReDepr = 1 where FID in (");
            for (int i = 0; i < undoDepCards.size(); ++i) {
                sql.append("'" + undoDepCards.get(i).getId() + "',");
            }
            DbUtil.execute((Context)ctx, (String)(sql.substring(0, sql.length() - 1) + ")"));
        }
        DbUtil.execute((Context)ctx, (String)"delete from t_fa_faevasum where FEvaBillID = ?", (Object[])new Object[]{info.getId().toString()});
        DbUtil.execute((Context)ctx, (String)"update t_fa_facurcard set flastbillid = ?,flastupdatetime=getdate() where fid in (select fcurcardid from t_fa_faevaluatebillentry where FFaEvaluateBillID = ?)", (Object[])new Object[]{info.getId().toString(), info.getId().toString()});
        iEvaluate.unpassAuditSelf((IObjectPK)new ObjectUuidPK(info.getId()), (FaBillBaseInfo)model);
    }

    @Override
    protected void generateVourcher(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
    }

    @Override
    protected void deleteBill(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        IFaEvaluateBill iFaEvaluate = FaEvaluateBillFactory.getLocalInstance(ctx);
        FaEvaluateBillInfo billInfo = iFaEvaluate.getFaEvaluateBillInfo("select id,number,company where id ='" + pk + "'");
        FaLastPeriodChangeUtils.restoreBakAndCleanUp(ctx, (CoreBaseInfo)billInfo, new String[]{"fbizstatus", "flastbillid"}, null);
        this.recycleNumber(ctx, billInfo);
        iFaEvaluate.deleteSelf(pk);
    }

    @Override
    protected void checkForUnAudit(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        super.checkForUnAudit(ctx, pk);
        IFaEvaluateBill iEvaluate = FaEvaluateBillFactory.getLocalInstance(ctx);
        FaEvaluateBillInfo info = iEvaluate.getFaEvaluateBillInfo("select publishedStatus where id ='" + pk + "'");
        if (info.getPublishedStatus() == FaPublishedStatusEnum.PUBLISHED) {
            throw new FaEvaluateBillException(FaEvaluateBillException.BILL_PUBLISHED_UNAUDIT);
        }
    }

    private IObjectPK innerSaveBill(Context ctx, FaEvaluateBillInfo info, boolean isSubmit) throws BOSException, EASBizException {
        int i;
        PeriodInfo periodInfo = this.getCurrentPeriod(ctx, info);
        info.setBenchmarkDate(DateTimeUtils.truncateDate((Date)info.getBenchmarkDate()));
        info.setBeginDate(DateTimeUtils.truncateDate((Date)info.getBeginDate()));
        info.setEndDate(DateTimeUtils.truncateDate((Date)info.getEndDate()));
        info.setPeriod(this.getCurrentPeriod(ctx, info));
        info.setBizDate(DateTimeUtils.truncateDate((Date)new Date()));
        info.setAdjustDate(DateTimeUtils.truncateDate((Date)info.getAdjustDate()));
        info.setPublishedStatus(FaPublishedStatusEnum.UNPUBLISHED);
        info.setDeletedStatus(DeletedStatusEnum.NORMAL);
        info.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        info.setBlockedStatus(BlockedStatusEnum.UNBLOCKED);
        info.setFiVouchered(false);
        info.setHasEffected(true);
        info.setEffectedStatus(isSubmit ? EffectedStatusEnum.EFFECTED : EffectedStatusEnum.TEMPSTORE);
        IFaEvaluateBill iEvaluate = FaEvaluateBillFactory.getLocalInstance(ctx);
        PrcFaEvaStrategy.setBillInfoNumber(ctx, info, iEvaluate);
        this.checkFaCurCardValid(ctx, this.getCardColFromEntry((IObjectCollection)info.getFaEvaluateBillEntry()));
        FaLastPeriodChangeUtils.restoreBakAndCleanUp(ctx, (CoreBaseInfo)info, new String[]{"fbizstatus", "flastbillid"}, null);
        FaEvaluateBillEntryCollection entries = info.getFaEvaluateBillEntry();
        ArrayList<String> ids = new ArrayList<String>();
        if (entries.size() > 0) {
            List list;
            int size = entries.size();
            for (i = 0; i < size; ++i) {
                FaEvaluateBillEntryInfo entry = entries.get(i);
                ids.add(entry.getFaCurCard().getId().toString());
            }
            if (ids.size() > 0 && (list = iEvaluate.hasChanged(ids, info.getEvaluateScheme(), periodInfo)).size() > 0) {
                StringBuffer cardNums = new StringBuffer();
                int size2 = list.size();
                for (int i2 = 0; i2 < size2; ++i2) {
                    cardNums.append("[" + list.get(i2) + "] ");
                }
                throw new FaEvaluateBillException(FaEvaluateBillException.CARD_HAD_EVALUATED, new Object[]{cardNums.toString()});
            }
        }
        if (isSubmit) {
            try {
                for (i = 0; i < info.getFaEvaluateBillEntry().size(); ++i) {
                    FaCurCardInfo card = info.getFaEvaluateBillEntry().get(i).getFaCurCard();
                    FaEvaValueCollection evaValues = info.getFaEvaluateBillEntry().get(i).getEvaValue();
                    BigDecimal evaAmt = null;
                    BigDecimal evaLeftYear = null;
                    boolean isEvaLeftYear = false;
                    for (int j = 0; j < evaValues.size(); ++j) {
                        FaEvaValueInfo evaValue = evaValues.get(j);
                        if (evaValue.getMainType().getValue() == 1 && evaValue.getSubType().getValue() == "00") {
                            evaAmt = evaValue.getEvaValue();
                            continue;
                        }
                        if (evaValue.getMainType().getValue() != 2 || evaValue.getSubType().getValue() != "00") continue;
                        evaLeftYear = evaValue.getEvaValue();
                        isEvaLeftYear = true;
                    }
                    if (evaAmt == null) continue;
                    String checkSql = "select card.fnumber,card.FAccuDepr,card.FDecValue,card.FInitEvalValue,cat.FCalcuByEvaluate from t_fa_facurcard card inner join t_fa_cat cat on cat.fid=card.FAssetCatID where card.fid=?";
                    IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)checkSql, (Object[])new Object[]{card.getId().toString()});
                    rs.next();
                    if ((info.getEvaluateScheme().isChangeCard() || info.getEvaluateScheme().isClearDepreciation()) && isEvaLeftYear && (evaLeftYear == null || evaLeftYear.compareTo(new BigDecimal(0)) <= 0)) {
                        throw new FaEvaluateBillException(FaEvaluateBillException.BILL_CHANGE_EVALUENOTZERO, new Object[]{rs.getString(1)});
                    }
                    if (rs.getInt(5) == 1 && !info.getEvaluateScheme().isClearDepreciation() && evaAmt.subtract(rs.getBigDecimal(2)).subtract(rs.getBigDecimal(3)).compareTo(new BigDecimal("0")) < 0) {
                        throw new FaEvaluateBillException(FaEvaluateBillException.NEAT_AMT_LIMITED, new Object[]{rs.getString(1)});
                    }
                    if (rs.getInt(5) != 0 || info.getEvaluateScheme().isClearDepreciation() || !info.getEvaluateScheme().isChangeCard() || evaAmt.subtract(rs.getBigDecimal(2)).subtract(rs.getBigDecimal(3)).compareTo(new BigDecimal("0")) >= 0) continue;
                    throw new FaEvaluateBillException(FaEvaluateBillException.ORI_NEAT_AMT_LIMITED, new Object[]{rs.getString(1)});
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        Map tempTableNames = PrcFaEvaStrategy.createBizBakTempTable(ctx);
        IObjectPK billId = isSubmit ? iEvaluate.submitSelf(info) : iEvaluate.saveSelf(info);
        String selectCardId = "select fcurcardid from t_fa_faevaluatebillentry entry where ffaevaluatebillid = '" + billId + "'";
        this.saveBizBakCard(ctx, new String[]{selectCardId, "t_fa_faevaluatebillentry", billId.toString(), "FFaEvaluateBillID"}, FaBillTypeEnum.EVALUATE, FaBizStatusEnum.EVALUATING, tempTableNames);
        return billId;
    }

    private FaChangeBillInfo getChangeBillInfoTemplate(Context ctx, FaEvaSchemeInfo scheme, FaEvaluateBillInfo evaInfo) throws EASBizException, BOSException {
        Date today = DateTimeUtils.truncateDate((Date)new Date());
        PeriodInfo periodInfo = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(evaInfo.getPeriod().getId()));
        FaChangeBillInfo changeInfo = new FaChangeBillInfo();
        changeInfo.setEffectedStatus(EffectedStatusEnum.EFFECTED);
        changeInfo.setDeletedStatus(DeletedStatusEnum.NORMAL);
        changeInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        changeInfo.setBlockedStatus(BlockedStatusEnum.UNBLOCKED);
        changeInfo.setChangeMode(scheme.getFaAlterMode());
        changeInfo.setFiVouchered(false);
        if (today.after(periodInfo.getEndDate())) {
            changeInfo.setChangeDate(periodInfo.getEndDate());
        } else if (today.before(periodInfo.getBeginDate())) {
            changeInfo.setChangeDate(periodInfo.getBeginDate());
        } else {
            changeInfo.setChangeDate(today);
        }
        changeInfo.setPeriod(periodInfo);
        changeInfo.setBillType(FaBillOriginEnum.FROM_EVALUATE);
        changeInfo.setCompany(evaInfo.getCompany());
        changeInfo.setBizDate(today);
        changeInfo.setHasEffected(true);
        changeInfo.setSourceBillId(evaInfo.getId().toString());
        changeInfo.setHandler(ContextUtil.getCurrentUserInfo((Context)ctx));
        changeInfo.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        changeInfo.setLastUpdateTime(null);
        FaChangeBillEntryCollection changeEntries = new FaChangeBillEntryCollection();
        FaChangeBillEntryInfo changeEntryInfo = new FaChangeBillEntryInfo();
        changeEntries.add(changeEntryInfo);
        changeInfo.put("changeBillEntry", (Object)changeEntries);
        changeEntryInfo.setChangeBill(changeInfo);
        changeEntryInfo.setDecValueChg(ZERO);
        return changeInfo;
    }

    private Map getEvaValues(Context ctx, String billId) throws BOSException {
        try {
            String getEvaValueSql = "select FEvaEntryID,FMainType,FEvaValue from t_fa_faevavalue where FEvaEntryID in (" + this.getEntryCol("entry.fid") + ") and FSubType = ? ";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)getEvaValueSql, (Object[])new Object[]{billId, "00"});
            HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
            while (rs.next()) {
                map.put(rs.getString("FEvaEntryID") + rs.getInt("FMainType"), rs.getBigDecimal("FEvaValue"));
            }
            return map;
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private String getEntryCol(String columnName) {
        return "select " + columnName + " from t_fa_faevaluatebill bill inner join t_fa_faevaluatebillentry entry on bill.fid = entry.FFaEvaluateBillID where bill.fid = ?";
    }

    private SelectorItemCollection getUpdateCardSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("lastEvalValue"));
        sic.add(new SelectorItemInfo("initEvalValue"));
        sic.add(new SelectorItemInfo("evalLeftPeriod"));
        sic.add(new SelectorItemInfo("neatValue"));
        sic.add(new SelectorItemInfo("neatAmt"));
        sic.add(new SelectorItemInfo("assetValue"));
        sic.add(new SelectorItemInfo("originAmt"));
        sic.add(new SelectorItemInfo("useTermCount"));
        sic.add(new SelectorItemInfo("deprTermCount"));
        sic.add(new SelectorItemInfo("accuDepr"));
        sic.add(new SelectorItemInfo("accuDeprTYear"));
        sic.add(new SelectorItemInfo("lastBillID"));
        sic.add(new SelectorItemInfo("bizStatus"));
        return sic;
    }

    private SelectorItemCollection getFullCurCardSelector() {
        SelectorItemCollection sic = PrcFaCoreManager.getCurCardSelectors();
        sic.add(new SelectorItemInfo("currency.precision"));
        return sic;
    }

    private SelectorItemCollection getUpdateEvaEntrySelector() {
        SelectorItemCollection evaEntrySic = new SelectorItemCollection();
        evaEntrySic.add(new SelectorItemInfo("faChangeBill"));
        return evaEntrySic;
    }

    private SelectorItemCollection getUpdateStatusSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("lastEvalValue"));
        sic.add(new SelectorItemInfo("initEvalValue"));
        sic.add(new SelectorItemInfo("evalLeftPeriod"));
        sic.add(new SelectorItemInfo("neatValue"));
        sic.add(new SelectorItemInfo("neatAmt"));
        sic.add(new SelectorItemInfo("lastBillID"));
        sic.add(new SelectorItemInfo("bizStatus"));
        return sic;
    }

    private SelectorItemCollection getChangeBillSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("changeBillEntry.*"));
        sic.add(new SelectorItemInfo("changeBillEntry.curCard.*"));
        sic.add(new SelectorItemInfo("changeBillEntry.bizCard.faBakCard.id"));
        return sic;
    }

    @Override
    protected void checkFaCurCardValid(Context ctx, Map cardCollection) throws EASBizException, BOSException {
        super.checkFaCurCardValid(ctx, cardCollection);
        if (cardCollection == null || cardCollection.size() < 1) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select fnumber as fnumber from t_fa_facurcard where fhasevaled = 1 and fid ");
        Set cardIdSet = cardCollection.keySet();
        if (cardIdSet.size() == 0) {
            return;
        }
        StringBuffer inClause = new StringBuffer("in (");
        Iterator iter = cardIdSet.iterator();
        while (iter.hasNext()) {
            inClause.append("'");
            inClause.append(iter.next().toString());
            inClause.append("'");
            inClause.append(",");
        }
        String cardIds = inClause.substring(0, inClause.length() - 1);
        cardIds = cardIds + ")";
        sql.append(cardIds);
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rowSet.next()) {
                throw new FaEvaluateBillException(FaEvaluateBillException.CARD_HAD_EVALUATED, new Object[]{rowSet.getString("fnumber")});
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }
}

