/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaBakCardInfo;
import com.kingdee.eas.fi.fa.manage.FaBizCardInfo;
import com.kingdee.eas.fi.fa.manage.FaCardException;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaMortagBillEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaMortagBillEntryFactory;
import com.kingdee.eas.fi.fa.manage.FaMortagBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaMortagBillFactory;
import com.kingdee.eas.fi.fa.manage.FaMortagBillInfo;
import com.kingdee.eas.fi.fa.manage.IFaMortagBill;
import com.kingdee.eas.fi.fa.manage.IFaMortagBillEntry;
import com.kingdee.eas.fi.fa.manage.app.AbstractPrcFaManageStrategy;
import com.kingdee.eas.fi.fa.manage.app.FaLastPeriodChangeUtils;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.BlockedStatusEnum;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.util.DateTimeUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;

public class PrcFaMortagStrategy
extends AbstractPrcFaManageStrategy {
    @Override
    protected void deleteBill(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        if (pk == null) {
            return;
        }
        FaMortagBillInfo toDelBillInfo = this.getToDelBillInfo(ctx, pk.toString());
        if (toDelBillInfo == null) {
            return;
        }
        this.checkForDelete(ctx, toDelBillInfo);
        for (int i = 0; i < toDelBillInfo.getFaMortagBillEntry().size(); ++i) {
            FaMortagBillEntryInfo entry = toDelBillInfo.getFaMortagBillEntry().get(i);
            if (entry.getFaBizCard() == null || entry.getFaBizCard().getFaBakCard() == null) continue;
            FaBakCardInfo bakCardInfo = entry.getFaBizCard().getFaBakCard();
            FaLastPeriodChangeUtils.updateCurCardBySQL(ctx, bakCardInfo.getBizStatus().getValue(), bakCardInfo.getLastBillID(), entry.getFaCurCard().getId().toString(), bakCardInfo.isLastPeriodChange());
        }
        FaMortagBillEntryCollection faMortagBillEntryCollection = toDelBillInfo.getFaMortagBillEntry();
        int size = faMortagBillEntryCollection.size();
        IObjectPK[] bizCard = new IObjectPK[size];
        IObjectPK[] bakCard = new IObjectPK[size];
        for (int i = 0; i < size; ++i) {
            bizCard[i] = new ObjectUuidPK(faMortagBillEntryCollection.get(i).getFaBizCard().getId());
            bakCard[i] = new ObjectUuidPK(faMortagBillEntryCollection.get(i).getFaBizCard().getFaBakCard().getId());
        }
        this.recycleNumber(ctx, toDelBillInfo);
        FaMortagBillFactory.getLocalInstance(ctx).deleteSelf(pk);
        this.deleteBizBakCard(ctx, bizCard, bakCard, false);
    }

    @Override
    protected IObjectPK saveBill(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        return this.createDisBefore(ctx, model, 1);
    }

    @Override
    protected IObjectPK submitBill(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        return this.createDisBefore(ctx, model, 2);
    }

    @Override
    protected void auditBill(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        IFaMortagBill faMortagBill = FaMortagBillFactory.getLocalInstance(ctx);
        FaMortagBillInfo info = (FaMortagBillInfo)model;
        info = faMortagBill.getFaMortagBillInfo((IObjectPK)new ObjectUuidPK(info.getId()));
        info.setCheckedStatus(CheckedStatusEnum.AUDITED);
        info.setAuditTime(new Date());
        info.setAuditor((UserInfo)ctx.get((Object)"UserInfo"));
        faMortagBill.update((IObjectPK)new ObjectUuidPK(info.getId()), (CoreBaseInfo)info);
        faMortagBill.passAuditSelf((IObjectPK)new ObjectUuidPK(info.getId()), info);
    }

    @Override
    protected void unAuditBill(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        IFaMortagBill faMortagBill = FaMortagBillFactory.getLocalInstance(ctx);
        FaMortagBillInfo info = (FaMortagBillInfo)model;
        info = faMortagBill.getFaMortagBillInfo((IObjectPK)new ObjectUuidPK(info.getId()));
        info.setCheckedStatus(CheckedStatusEnum.AUDITED);
        info.setAuditTime(null);
        info.setAuditor(null);
        faMortagBill.update((IObjectPK)new ObjectUuidPK(info.getId()), (CoreBaseInfo)info);
        faMortagBill.unpassAuditSelf((IObjectPK)new ObjectUuidPK(info.getId()), info);
    }

    @Override
    protected void generateVourcher(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
    }

    private ObjectUuidPK createDisBefore(Context ctx, IObjectValue model, int operType) throws EASBizException, BOSException {
        int i;
        IFaMortagBill mortagFactory = FaMortagBillFactory.getLocalInstance(ctx);
        IFaMortagBillEntry iMortagBillEntry = FaMortagBillEntryFactory.getLocalInstance(ctx);
        ArrayList<String> toUpdateCardIds = new ArrayList<String>();
        FaMortagBillInfo newBillInfo = (FaMortagBillInfo)model;
        if (newBillInfo.getPeriod() == null) {
            newBillInfo.setPeriod(this.getCurrentPeriod(ctx, newBillInfo));
        }
        FaMortagBillEntryCollection newBillEnties = newBillInfo.getFaMortagBillEntry();
        int billEntryCnt = newBillEnties.size();
        newBillInfo.setBeginDate(DateTimeUtils.truncateDate((Date)newBillInfo.getBeginDate()));
        newBillInfo.setEndDate(DateTimeUtils.truncateDate((Date)newBillInfo.getEndDate()));
        newBillInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        newBillInfo.setDeletedStatus(DeletedStatusEnum.NORMAL);
        newBillInfo.setBlockedStatus(BlockedStatusEnum.UNBLOCKED);
        ArrayList<String> newCards = new ArrayList<String>();
        for (i = 0; i < billEntryCnt; ++i) {
            if (newBillEnties.get(i).getId() != null) {
                newCards.add(newBillEnties.get(i).getId().toString());
            }
            if (newBillEnties.get(i) == null || newBillEnties.get(i).getFaCurCard() == null) continue;
            toUpdateCardIds.add(newBillEnties.get(i).getFaCurCard().getId().toString());
        }
        if (newBillInfo.getId() != null) {
            FaMortagBillInfo billInfoSaved = this.getToDelBillInfo(ctx, newBillInfo.getId().toString());
            FaMortagBillEntryCollection billEntiesSaved = billInfoSaved.getFaMortagBillEntry();
            int size = billEntiesSaved.size();
            for (int i2 = 0; i2 < size; ++i2) {
                String billEntryIdSaved = billEntiesSaved.get(i2).getId().toString();
                if (!newCards.contains(billEntryIdSaved)) {
                    FaMortagBillEntryInfo billEntrySaved = billEntiesSaved.get(i2);
                    FaBakCardInfo bakCardInfo = billEntrySaved.getFaBizCard().getFaBakCard();
                    FaLastPeriodChangeUtils.updateCurCardBySQL(ctx, bakCardInfo.getBizStatus().getValue(), bakCardInfo.getLastBillID(), billEntrySaved.getFaCurCard().getId().toString(), bakCardInfo.isLastPeriodChange());
                    iMortagBillEntry.delete((IObjectPK)new ObjectUuidPK(billEntrySaved.getId()));
                    this.deleteBizBakCard(ctx, new IObjectPK[]{new ObjectUuidPK(billEntrySaved.getFaBizCard().getId())}, new IObjectPK[]{new ObjectUuidPK(bakCardInfo.getId())}, false);
                    continue;
                }
                if (!newCards.contains(billEntryIdSaved)) continue;
                newCards.remove(billEntryIdSaved);
            }
        }
        this.checkFaCurCardValid(ctx, this.getCardColFromEntry((IObjectCollection)newBillEnties));
        for (i = 0; i < billEntryCnt; ++i) {
            FaMortagBillEntryInfo newBillEntry = newBillEnties.get(i);
            if (newBillEnties.get(i).getId() != null && !newCards.contains(newBillEntry.getId().toString())) continue;
            FaCurCardInfo faCurCardInfo = newBillEntry.getFaCurCard();
            String bakCardId = this.saveBakCard(ctx, faCurCardInfo.getId().toString(), 11);
            String bizCardId = this.saveBizCard(ctx, faCurCardInfo.getId().toString(), bakCardId, 11);
            FaBizCardInfo faBizCardInfo = new FaBizCardInfo();
            faBizCardInfo.setId(BOSUuid.read((String)bizCardId));
            newBillEntry.setFaBizCard(faBizCardInfo);
        }
        if (newBillInfo.getId() == null) {
            PrcFaMortagStrategy.setBillInfoNumber(ctx, newBillInfo, mortagFactory);
        }
        if (operType == 1) {
            mortagFactory.saveSelf(newBillInfo);
        } else {
            mortagFactory.submitSelf(newBillInfo);
        }
        if (operType == 1) {
            for (i = 0; i < toUpdateCardIds.toArray().length; ++i) {
                this.updateCurCardBySQL(ctx, "1701", newBillInfo.getId().toString(), (String)toUpdateCardIds.get(i));
            }
        }
        if (operType == 2) {
            for (i = 0; i < toUpdateCardIds.toArray().length; ++i) {
                this.updateCurCardBySQL(ctx, "1799", newBillInfo.getId().toString(), (String)toUpdateCardIds.get(i));
            }
        }
        return new ObjectUuidPK(newBillInfo.getId());
    }

    private FaMortagBillInfo getToDelBillInfo(Context ctx, String pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("faMortagBillEntry.id"));
        sic.add(new SelectorItemInfo("faMortagBillEntry.faCurCard.fiVouchered"));
        sic.add(new SelectorItemInfo("faMortagBillEntry.faCurCard.id"));
        sic.add(new SelectorItemInfo("faMortagBillEntry.faCurCard.lastBillID"));
        sic.add(new SelectorItemInfo("faMortagBillEntry.faBizCard.id"));
        sic.add(new SelectorItemInfo("faMortagBillEntry.faBizCard.faBakCard.id"));
        sic.add(new SelectorItemInfo("faMortagBillEntry.faBizCard.faBakCard.bizStatus"));
        sic.add(new SelectorItemInfo("faMortagBillEntry.faBizCard.faBakCard.lastBillID"));
        sic.add(new SelectorItemInfo("faMortagBillEntry.faBizCard.faBakCard.lastPeriodChange"));
        FaMortagBillInfo faMortagBillInfo = FaMortagBillFactory.getLocalInstance(ctx).getFaMortagBillInfo((IObjectPK)new ObjectUuidPK(pk), sic);
        return faMortagBillInfo;
    }

    protected void checkForDelete(Context ctx, BillBaseInfo billInfo) throws EASBizException, BOSException {
        FaMortagBillInfo mortagBill = (FaMortagBillInfo)billInfo;
        FaMortagBillEntryCollection mortagBillEntryCol = mortagBill.getFaMortagBillEntry();
        Iterator iMortagBillEntry = mortagBillEntryCol.iterator();
        while (iMortagBillEntry.hasNext()) {
            FaMortagBillEntryInfo element = (FaMortagBillEntryInfo)iMortagBillEntry.next();
            FaCurCardInfo curCard = element.getFaCurCard();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("lastBillID"));
            sic.add(new SelectorItemInfo("assetName"));
            sic.add(new SelectorItemInfo("number"));
            curCard = FaCurCardFactory.getLocalInstance(ctx).getFaCurCardInfo((IObjectPK)new ObjectUuidPK(curCard.getId()), sic);
            if (curCard.getLastBillID() == null || curCard.getLastBillID().equals(mortagBill.getId().toString())) continue;
            throw new FaCardException(FaCardException.CURCARD_HASOTHEROPRATION, new String[]{curCard.getNumber() + "(" + curCard.getAssetName() + ")", "", FaLocalUtils.getEntityAlias(ctx, BOSUuid.getBOSObjectType((String)curCard.getLastBillID(), (boolean)false))});
        }
    }
}

