/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.basedata.FaResUtil;
import com.kingdee.eas.fi.fa.basedata.FaUseStatusFactory;
import com.kingdee.eas.fi.fa.basedata.FaUseStatusInfo;
import com.kingdee.eas.fi.fa.def.FaDefPropertyValueInfo;
import com.kingdee.eas.fi.fa.manage.AbstractFaCardException;
import com.kingdee.eas.fi.fa.manage.FaBakCardInfo;
import com.kingdee.eas.fi.fa.manage.FaBillOriginEnum;
import com.kingdee.eas.fi.fa.manage.FaBizCardFactory;
import com.kingdee.eas.fi.fa.manage.FaBizCardInfo;
import com.kingdee.eas.fi.fa.manage.FaBizStatusEnum;
import com.kingdee.eas.fi.fa.manage.FaCardException;
import com.kingdee.eas.fi.fa.manage.FaClearBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaClearBillFactory;
import com.kingdee.eas.fi.fa.manage.FaClearBillInfo;
import com.kingdee.eas.fi.fa.manage.FaClearStatusEnum;
import com.kingdee.eas.fi.fa.manage.FaCurCardCollection;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.FaMonCardFactory;
import com.kingdee.eas.fi.fa.manage.FaMonCardInfo;
import com.kingdee.eas.fi.fa.manage.FaSplitBillEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaSplitBillEntryFactory;
import com.kingdee.eas.fi.fa.manage.FaSplitBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaSplitBillFactory;
import com.kingdee.eas.fi.fa.manage.FaSplitBillInfo;
import com.kingdee.eas.fi.fa.manage.GroupNumberStatusEnum;
import com.kingdee.eas.fi.fa.manage.IFaSplitBill;
import com.kingdee.eas.fi.fa.manage.app.AbstractPrcFaManageStrategy;
import com.kingdee.eas.fi.fa.manage.app.FaCardDefPropertyPersist;
import com.kingdee.eas.fi.fa.manage.app.FaLastPeriodChangeUtils;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.fa.manage.app.PrcFaAddStrategy;
import com.kingdee.eas.fi.fa.manage.app.PrcFaClearStrategy;
import com.kingdee.eas.fi.fa.manage.app.PrcFaCoreManager;
import com.kingdee.eas.framework.BlockedStatusEnum;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;

public class PrcFaSplitStrategy
extends AbstractPrcFaManageStrategy {
    public static String IS_FROM_Split_BILL = "isFromSplitBill";

    @Override
    protected IObjectPK saveBill(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        FaSplitBillInfo billInfo = this.getSplitBillInfo(ctx, model);
        billInfo.setEffectedStatus(EffectedStatusEnum.TEMPSTORE);
        IFaSplitBill splitFactory = FaSplitBillFactory.getLocalInstance(ctx);
        IObjectPK pk = splitFactory.saveSelf(billInfo);
        if (billInfo.getFaCurCard() == null || billInfo.getFaBizCard() == null) {
            if (billInfo.get("DELETE_FABIZCARD_ID") != null) {
                this.deleteBizBakCard(ctx, new IObjectPK[]{new ObjectUuidPK((BOSUuid)billInfo.get("DELETE_FABIZCARD_ID"))}, null, true);
            }
            if (billInfo.get("DELETE_FABAKCARD_ID") != null) {
                this.deleteBizBakCard(ctx, null, new IObjectPK[]{new ObjectUuidPK((BOSUuid)billInfo.get("DELETE_FABAKCARD_ID"))}, true);
            }
        }
        if (billInfo.getFaCurCard() != null && billInfo.getFaCurCard().getId() != null) {
            this.updateCurCardBySQL(ctx, FaBizStatusEnum.SPLITING.getValue(), pk.toString(), billInfo.getFaCurCard().getId().toString());
        }
        return pk;
    }

    @Override
    protected IObjectPK submitBill(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        FaSplitBillInfo billInfo = this.getSplitBillInfo(ctx, model);
        billInfo.setEffectedStatus(EffectedStatusEnum.EFFECTED);
        IFaSplitBill splitFactory = FaSplitBillFactory.getLocalInstance(ctx);
        IObjectPK pk = splitFactory.submitSelf(billInfo);
        if (billInfo.getFaCurCard() != null && billInfo.getFaCurCard().getId() != null) {
            this.updateCurCardBySQL(ctx, FaBizStatusEnum.SPLITING.getValue(), pk.toString(), billInfo.getFaCurCard().getId().toString());
        }
        return pk;
    }

    @Override
    protected void auditBill(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        FaSplitBillInfo billInfo = (FaSplitBillInfo)model;
        if (billInfo == null) {
            throw new IllegalArgumentException();
        }
        FaSplitBillEntryCollection collection = billInfo.getFaSplitBillEntry();
        if (collection == null) {
            return;
        }
        PrcFaCoreManager prcFaCoreManager = new PrcFaCoreManager(new PrcFaAddStrategy());
        for (int i = 0; i < collection.size(); ++i) {
            FaSplitBillEntryInfo splitBillEntry = collection.get(i);
            FaBizCardInfo bizCardInfo = splitBillEntry.getFaBizCard();
            if (bizCardInfo == null) continue;
            bizCardInfo = FaBizCardFactory.getLocalInstance(ctx).getFaBizCardInfo((IObjectPK)new ObjectUuidPK(bizCardInfo.getId().toString()), PrcFaCoreManager.getBizCardSelectors());
            FaCurCardInfo curCardInfoNew = PrcFaCoreManager.BizCard2CurCard(bizCardInfo);
            if (FaLocalUtils.existCardNumber(ctx, (IObjectValue)curCardInfoNew)) {
                throw new AbstractFaCardException(AbstractFaCardException.DUPLICATECARDNUMBER);
            }
            curCardInfoNew.setSourceBillId(billInfo.getId().toString());
            curCardInfoNew.setVoucher(null);
            curCardInfoNew.setVoucherNumber(null);
            curCardInfoNew.setVoucherAbstract(null);
            if (bizCardInfo.getPropertyValue() != null) {
                FaDefPropertyValueInfo pv = FaCardDefPropertyPersist.copy(bizCardInfo.getPropertyValue().getId(), ctx);
                curCardInfoNew.setPropertyValue(pv);
            }
            if (curCardInfoNew.getUseStatus() != null) {
                FaUseStatusInfo useStatusInfo = FaUseStatusFactory.getLocalInstance((Context)ctx).getFaUseStatusInfo((IObjectPK)new ObjectUuidPK(curCardInfoNew.getUseStatus().getId()));
                curCardInfoNew.setUseStatus(useStatusInfo);
            }
            prcFaCoreManager.getFaManageStrategy().submitBill(ctx, (IObjectValue)curCardInfoNew);
            prcFaCoreManager.getFaManageStrategy().auditBill(ctx, (IObjectValue)curCardInfoNew);
            splitBillEntry.setFaCurCard(curCardInfoNew);
        }
        FaClearBillInfo clearBill = this.buildClearBill(ctx, billInfo.getFaCurCard(), billInfo.getFaBizCard(), 0);
        clearBill.setId(billInfo.getId());
        clearBill.setCompany(billInfo.getCompany());
        clearBill.setClearMode(billInfo.getClearMode());
        clearBill.setClearDate(billInfo.getSplitDate());
        clearBill.setDescription(FaResUtil.getRes((String)"byDisBill", (Locale)ctx.getOriginLocale()));
        clearBill.setSourceBillId(billInfo.getId().toString());
        clearBill.setHandler(billInfo.getHandler());
        clearBill.setAuditor(billInfo.getAuditor());
        clearBill.setPeriod(billInfo.getPeriod());
        clearBill.setBizDate(DateTimeUtils.truncateDate((Date)this.getCurrentPeriod(ctx, clearBill).getEndDate()));
        clearBill.put(IS_FROM_Split_BILL, "true");
        PrcFaSplitStrategy.setBillInfoNumber(ctx, clearBill, FaClearBillFactory.getLocalInstance(ctx));
        PrcFaCoreManager prcFaClearManager = new PrcFaCoreManager(new PrcFaClearStrategy());
        prcFaClearManager.getFaManageStrategy().auditBill(ctx, (IObjectValue)clearBill);
        clearBill.setId(null);
        FaClearBillFactory.getLocalInstance(ctx).submitNoWorkFlow((IObjectValue)clearBill);
        billInfo.setFaClearBill(clearBill);
        FaCurCardInfo curCardInfoNew = billInfo.getFaCurCard();
        curCardInfoNew.setId(billInfo.getFaCurCard().getId());
        curCardInfoNew.setBizStatus(FaBizStatusEnum.HAVE_SPLITED);
        curCardInfoNew.setHasCleared(FaClearStatusEnum.HasAllCleared);
        curCardInfoNew.setHasSplited(true);
        curCardInfoNew.setLastBillID(billInfo.getId().toString());
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("bizStatus"));
        selector.add(new SelectorItemInfo("hasCleared"));
        selector.add(new SelectorItemInfo("hasSplited"));
        selector.add(new SelectorItemInfo("lastBillID"));
        FaCurCardFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)curCardInfoNew, selector);
        FaSplitBillFactory.getLocalInstance(ctx).passAuditSelf((IObjectPK)new ObjectUuidPK(billInfo.getId()), billInfo);
    }

    private FaClearBillInfo buildClearBill(Context ctx, FaCurCardInfo curCard, FaBizCardInfo bizCard, int type) throws EASBizException, BOSException {
        FaClearBillInfo clearBill = new FaClearBillInfo();
        clearBill.setCompany(curCard.getCompany());
        clearBill.setCheckedStatus(type == 0 ? CheckedStatusEnum.UNAUDITED : CheckedStatusEnum.AUDITED);
        clearBill.setDeletedStatus(DeletedStatusEnum.NORMAL);
        clearBill.setBlockedStatus(BlockedStatusEnum.UNBLOCKED);
        clearBill.setBillType(FaBillOriginEnum.FROM_SPLIT);
        clearBill.setCompany(curCard.getCompany());
        FaClearBillEntryInfo clearEntryInfo = new FaClearBillEntryInfo();
        clearEntryInfo.setClrQty(curCard.getAssetAmt());
        if (this.needSubstractDepr(ctx, curCard.getId().toString())) {
            BigDecimal zero = new BigDecimal("0");
            BigDecimal termDepr = curCard.getDeprTTerm() == null ? zero : curCard.getDeprTTerm();
            curCard.setNeatValue(curCard.getNeatValue().add(termDepr));
            curCard.setNeatAmt(curCard.getNeatValue().add(termDepr));
            curCard.setAccuDepr(curCard.getAccuDepr().subtract(termDepr));
            curCard.setAccuDeprAll(curCard.getAccuDeprAll().add(termDepr));
            curCard.setAccuDeprTYear(curCard.getAccuDeprTYear().subtract(termDepr));
            curCard.setDeprTermCount(curCard.getDeprTermCount().subtract(new BigDecimal("1")));
        }
        clearEntryInfo.setClrAddupDep(curCard.getAccuDepr() == null ? ZERO : curCard.getAccuDepr());
        clearEntryInfo.setClrDecPrep(curCard.getDecValue() == null ? ZERO : curCard.getDecValue());
        clearEntryInfo.setClrOriginal(curCard.getAssetValue() == null ? ZERO : curCard.getAssetValue());
        clearEntryInfo.setClrEvalValue(curCard.getInitEvalValue() == null ? ZERO : curCard.getInitEvalValue());
        clearEntryInfo.setBizCard(bizCard);
        clearEntryInfo.setCurCard(curCard);
        clearBill.getClearBillEntry().add(clearEntryInfo);
        return clearBill;
    }

    @Override
    protected void unAuditBill(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        FaSplitBillInfo billInfo = (FaSplitBillInfo)model;
        if (billInfo == null) {
            throw new IllegalArgumentException();
        }
        SelectorItemCollection clearSic = new SelectorItemCollection();
        clearSic.add(new SelectorItemInfo("*"));
        clearSic.add(new SelectorItemInfo("clearBillEntry.*"));
        clearSic.add(new SelectorItemInfo("clearBillEntry.curCard.*"));
        FaClearBillInfo clearBill = FaClearBillFactory.getLocalInstance(ctx).getFaClearBillInfo((IObjectPK)new ObjectUuidPK(billInfo.getFaClearBill().getId()), clearSic);
        String clearHasGenVoucherMsg = ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"clearHasGenVoucher", (Locale)ctx.getOriginLocale());
        clearHasGenVoucherMsg = "\n" + MessageFormat.format(clearHasGenVoucherMsg, billInfo.getFaClearBill().getNumber());
        if (billInfo.getFaClearBill().isFiVouchered()) {
            throw new FaCardException(FaCardException.CANNOT_BE_UNAUDITED, new String[]{clearHasGenVoucherMsg, "\n"});
        }
        FaSplitBillEntryCollection collection = billInfo.getFaSplitBillEntry();
        if (collection == null) {
            return;
        }
        FaCurCardCollection curCol = new FaCurCardCollection();
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            FaSplitBillEntryInfo splitBillEntry = collection.get(i);
            if (splitBillEntry.getFaCurCard() == null) continue;
            curCol.add(splitBillEntry.getFaCurCard());
            splitBillEntry.setFaCurCard(null);
        }
        billInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        billInfo.setAuditor(null);
        billInfo.setAuditTime(null);
        billInfo.setFaClearBill(null);
        FaSplitBillFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(billInfo.getId()), (CoreBaseInfo)billInfo);
        PrcFaCoreManager prcFaCoreManager = new PrcFaCoreManager(new PrcFaAddStrategy());
        HashMap faParameter = FaManageUtils.getFAParameter(billInfo.getCompany().getId(), ctx);
        boolean isAutoCode = faParameter.get("FA_001") != null ? "true".equalsIgnoreCase(faParameter.get("FA_001").toString()) : true;
        boolean isUseInitCardRule = faParameter.get("FA_055") != null ? "true".equalsIgnoreCase(faParameter.get("FA_055").toString()) : true;
        prcFaCoreManager.getFaManageStrategy().getTempParam().put("FROM_SOURCE", Boolean.TRUE);
        int size2 = curCol.size();
        for (int i = 0; i < size2; ++i) {
            prcFaCoreManager.getFaManageStrategy().checkForUnAudit(ctx, (IObjectPK)new ObjectUuidPK(curCol.get(i).getId()));
            prcFaCoreManager.getFaManageStrategy().unAuditBill(ctx, (IObjectValue)curCol.get(i));
            StringBuffer sql = new StringBuffer();
            sql.append("delete from T_FA_UserDefineEntry where FAssetCardID = '" + curCol.get(i).getId() + "'");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            prcFaCoreManager.getFaManageStrategy().deleteBill(ctx, (IObjectPK)new ObjectUuidPK(curCol.get(i).getId()));
            if (!isAutoCode) continue;
            if (isUseInitCardRule) {
                this.setNumber(ctx, PrcFaCoreManager.CurCard2MonCard(curCol.get(i)), "effectedStatus", "");
                continue;
            }
            this.setNumber(ctx, curCol.get(i), "effectedStatus", "");
        }
        PrcFaCoreManager prcFaClearManager = new PrcFaCoreManager(new PrcFaClearStrategy());
        prcFaClearManager.getFaManageStrategy().getTempParam().put("FROM_SOURCE", Boolean.TRUE);
        prcFaClearManager.getFaManageStrategy().checkForUnAudit(ctx, (IObjectPK)new ObjectUuidPK(clearBill.getId()));
        prcFaClearManager.getFaManageStrategy().unAuditBill(ctx, (IObjectValue)clearBill);
        this.recycleNumber(ctx, clearBill);
        FaClearBillFactory.getLocalInstance(ctx).deleteSelf((IObjectPK)new ObjectUuidPK(clearBill.getId()));
        FaCurCardInfo curCardInfoNew = billInfo.getFaCurCard();
        curCardInfoNew.setId(billInfo.getFaCurCard().getId());
        curCardInfoNew.setBizStatus(FaBizStatusEnum.SPLITING);
        curCardInfoNew.setLastBillID(billInfo.getId().toString());
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("bizStatus"));
        selector.add(new SelectorItemInfo("lastBillID"));
        FaCurCardFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)curCardInfoNew, selector);
        FaSplitBillFactory.getLocalInstance(ctx).unpassAuditSelf((IObjectPK)new ObjectUuidPK(billInfo.getId()), billInfo);
    }

    @Override
    protected void generateVourcher(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
    }

    @Override
    protected void deleteBill(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        if (pk == null) {
            return;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("faSplitBillEntry.id"));
        sic.add(new SelectorItemInfo("faSplitBillEntry.faBizCard.faBakCard.id"));
        sic.add(new SelectorItemInfo("faSplitBillEntry.faBizCard.id"));
        sic.add(new SelectorItemInfo("faSplitBillEntry.faBizCard.effectedStatus"));
        sic.add(new SelectorItemInfo("faSplitBillEntry.faBizCard.company.id"));
        sic.add(new SelectorItemInfo("faSplitBillEntry.faBizCard.assetCat.numberRule"));
        sic.add(new SelectorItemInfo("faSplitBillEntry.faBizCard.number"));
        sic.add(new SelectorItemInfo("faBizCard.faBakCard.id"));
        sic.add(new SelectorItemInfo("faBizCard.faBakCard.bizStatus"));
        sic.add(new SelectorItemInfo("faBizCard.faBakCard.lastBillID"));
        sic.add(new SelectorItemInfo("faBizCard.faBakCard.lastPeriodChange"));
        sic.add(new SelectorItemInfo("faBizCard.id"));
        sic.add(new SelectorItemInfo("faCurCard.id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("company.id"));
        FaSplitBillInfo billInfo = FaSplitBillFactory.getLocalInstance(ctx).getFaSplitBillInfo(pk, sic);
        FaSplitBillEntryCollection collection = billInfo.getFaSplitBillEntry();
        HashMap faParameter = FaManageUtils.getFAParameter(billInfo.getCompany().getId(), ctx);
        boolean isAutoCode = faParameter.get("FA_001") != null ? "true".equalsIgnoreCase(faParameter.get("FA_001").toString()) : true;
        boolean isUseInitCardRule = faParameter.get("FA_055") != null ? "true".equalsIgnoreCase(faParameter.get("FA_055").toString()) : true;
        boolean useGroupNumber = faParameter.get("FA_030") != null ? "true".equalsIgnoreCase(faParameter.get("FA_030").toString()) : true;
        boolean autoGroupNumber = faParameter.get("FA_189") != null ? "true".equalsIgnoreCase(faParameter.get("FA_189").toString()) : true;
        IObjectPK[] arrayBakCardPK = new IObjectPK[billInfo.getFaBizCard() != null ? 1 : 0];
        IObjectPK[] arrayBizCardPK = new IObjectPK[billInfo.getFaBizCard() != null ? collection.size() + 1 : collection.size()];
        if (billInfo.getFaBizCard() != null) {
            arrayBakCardPK[0] = new ObjectUuidPK(billInfo.getFaBizCard().getFaBakCard().getId());
            arrayBizCardPK[0] = new ObjectUuidPK(billInfo.getFaBizCard().getId());
        }
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            FaSplitBillEntryInfo splitBillEntry = collection.get(i);
            FaBizCardInfo bizCardInfo = splitBillEntry.getFaBizCard();
            if (bizCardInfo == null) continue;
            if (bizCardInfo.getId() != null) {
                bizCardInfo = FaBizCardFactory.getLocalInstance(ctx).getFaBizCardInfo((IObjectPK)new ObjectUuidPK(bizCardInfo.getId()));
            }
            bizCardInfo.setGroupNumberStatus(GroupNumberStatusEnum.EFFECTED);
            arrayBizCardPK[i + (arrayBizCardPK.length - size)] = new ObjectUuidPK(bizCardInfo.getId());
            if (isAutoCode) {
                if (isUseInitCardRule) {
                    this.recycleNumber(ctx, FaManageUtils.CurCard2MonCard(FaManageUtils.BizCard2CurCard(bizCardInfo)), "effectedStatus", "");
                } else {
                    this.recycleNumber(ctx, PrcFaCoreManager.BizCard2CurCard(bizCardInfo), "effectedStatus", "");
                }
            }
            if (!useGroupNumber || !autoGroupNumber) continue;
            this.recycleGroupNumber(ctx, PrcFaCoreManager.BizCard2CurCard(bizCardInfo), "groupNumberStatus", "");
        }
        if (billInfo.getFaCurCard() != null && billInfo.getFaCurCard().getId() != null) {
            FaLastPeriodChangeUtils.updateCurCardBySQL(ctx, billInfo.getFaBizCard().getFaBakCard().getBizStatus().getValue(), billInfo.getFaBizCard().getFaBakCard().getLastBillID(), billInfo.getFaCurCard().getId().toString(), billInfo.getFaBizCard().getFaBakCard().isLastPeriodChange());
        }
        this.recycleNumber(ctx, billInfo);
        FaSplitBillFactory.getLocalInstance(ctx).deleteSelf(pk);
        this.deleteBizBakCard(ctx, arrayBizCardPK, arrayBakCardPK, true);
    }

    private FaSplitBillInfo getSplitBillInfo(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        boolean isAutoBarCode;
        FaSplitBillInfo billInfo = (FaSplitBillInfo)model;
        if (billInfo == null) {
            throw new IllegalArgumentException();
        }
        FaSplitBillEntryCollection entryCollection = billInfo.getFaSplitBillEntry();
        HashMap faParameter = FaManageUtils.getFAParameter(billInfo.getCompany().getId(), ctx);
        boolean isAutoCode = faParameter.get("FA_001") != null ? "true".equalsIgnoreCase(faParameter.get("FA_001").toString()) : true;
        boolean isUseInitCardRule = faParameter.get("FA_055") != null ? "true".equalsIgnoreCase(faParameter.get("FA_055").toString()) : true;
        boolean isUseGroupCode = faParameter.get("FA_030") != null ? "true".equalsIgnoreCase(faParameter.get("FA_030").toString()) : false;
        boolean isAutoGroupCode = faParameter.get("FA_189") != null ? "true".equalsIgnoreCase(faParameter.get("FA_189").toString()) : true;
        boolean isUseBarCode = faParameter.get("FA_043") != null ? "true".equalsIgnoreCase(faParameter.get("FA_043").toString()) : false;
        boolean bl = isAutoBarCode = faParameter.get("FA_101") != null ? "true".equalsIgnoreCase(faParameter.get("FA_101").toString()) : true;
        if (billInfo.getId() != null) {
            ArrayList<ObjectUuidPK> listBakCardPK = new ArrayList<ObjectUuidPK>();
            ArrayList<ObjectUuidPK> listBizCardPK = new ArrayList<ObjectUuidPK>();
            ArrayList<ObjectUuidPK> listSplitEntryPK = new ArrayList<ObjectUuidPK>();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("faSplitBillEntry.id"));
            sic.add(new SelectorItemInfo("faSplitBillEntry.faBizCard.faBakCard.id"));
            sic.add(new SelectorItemInfo("faSplitBillEntry.faBizCard.id"));
            sic.add(new SelectorItemInfo("faSplitBillEntry.faBizCard.company.id"));
            sic.add(new SelectorItemInfo("faSplitBillEntry.faBizCard.effectedStatus"));
            sic.add(new SelectorItemInfo("faSplitBillEntry.faBizCard.number"));
            sic.add(new SelectorItemInfo("faSplitBillEntry.faBizCard.assetCat.numberRule"));
            sic.add(new SelectorItemInfo("faBizCard.faBakCard.id"));
            sic.add(new SelectorItemInfo("faBizCard.faBakCard.bizStatus"));
            sic.add(new SelectorItemInfo("faBizCard.faBakCard.lastBillID"));
            sic.add(new SelectorItemInfo("faBizCard.faBakCard.lastPeriodChange"));
            sic.add(new SelectorItemInfo("faBizCard.id"));
            sic.add(new SelectorItemInfo("faCurCard.id"));
            FaSplitBillInfo savedBillInfo = FaSplitBillFactory.getLocalInstance(ctx).getFaSplitBillInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)billInfo.getId().toString())), sic);
            FaSplitBillEntryCollection collectionSaved = savedBillInfo.getFaSplitBillEntry();
            boolean delFlag = true;
            boolean recycleFlag = true;
            for (int i = 0; i < collectionSaved.size(); ++i) {
                FaBizCardInfo bizCardInfo;
                delFlag = true;
                FaSplitBillEntryInfo entryInfoSaved = collectionSaved.get(i);
                for (int j = 0; j < entryCollection.size(); ++j) {
                    FaSplitBillEntryInfo splitEntryInfo = entryCollection.get(j);
                    if (splitEntryInfo.getFaBizCard().getId() != null && entryInfoSaved.getFaBizCard().getId().toString().equals(splitEntryInfo.getFaBizCard().getId().toString())) {
                        delFlag = false;
                    }
                    if (splitEntryInfo.getFaBizCard().getId() == null || splitEntryInfo.getFaBizCard().getNumber() == null || entryInfoSaved.getFaBizCard().getNumber() == null || !splitEntryInfo.getFaBizCard().getId().equals((Object)entryInfoSaved.getFaBizCard().getId()) || !splitEntryInfo.getFaBizCard().getNumber().equals(entryInfoSaved.getFaBizCard().getNumber())) continue;
                    recycleFlag = false;
                }
                if (delFlag) {
                    FaBizCardInfo bizCardInfo2 = entryInfoSaved.getFaBizCard();
                    if (bizCardInfo2 == null) continue;
                    FaBakCardInfo bakCardInfo = bizCardInfo2.getFaBakCard();
                    if (bakCardInfo != null && bakCardInfo.getId() != null) {
                        listBakCardPK.add(new ObjectUuidPK(bakCardInfo.getId()));
                    }
                    listBizCardPK.add(new ObjectUuidPK(bizCardInfo2.getId()));
                    listSplitEntryPK.add(new ObjectUuidPK(entryInfoSaved.getId()));
                }
                if ((!isAutoCode || !recycleFlag) && !delFlag || (bizCardInfo = entryInfoSaved.getFaBizCard()) == null) continue;
                FaMonCardInfo monCardInfo = PrcFaCoreManager.CurCard2MonCard(PrcFaCoreManager.BizCard2CurCard(bizCardInfo));
                if (isUseInitCardRule) {
                    this.recycleNumber(ctx, monCardInfo, "effectedStatus", "");
                    continue;
                }
                this.recycleNumber(ctx, PrcFaCoreManager.BizCard2CurCard(bizCardInfo), "effectedStatus", "");
            }
            if (billInfo.getFaCurCard() == null || savedBillInfo.getFaCurCard() != null && !savedBillInfo.getFaCurCard().getId().toString().equals(billInfo.getFaCurCard().getId().toString())) {
                FaBizCardInfo bizCardInfo = savedBillInfo.getFaBizCard();
                if (bizCardInfo != null) {
                    FaLastPeriodChangeUtils.updateCurCardBySQL(ctx, bizCardInfo.getFaBakCard().getBizStatus().getValue(), bizCardInfo.getFaBakCard().getLastBillID(), savedBillInfo.getFaCurCard().getId().toString(), bizCardInfo.getFaBakCard().isLastPeriodChange());
                }
                if (billInfo.getFaCurCard() == null && bizCardInfo != null) {
                    billInfo.put("DELETE_FABIZCARD_ID", bizCardInfo.getId());
                    billInfo.put("DELETE_FABAKCARD_ID", bizCardInfo.getFaBakCard().getId());
                }
            }
            IObjectPK[] arraySplitEntryPK = new IObjectPK[listSplitEntryPK.size()];
            System.arraycopy(listSplitEntryPK.toArray(), 0, arraySplitEntryPK, 0, listSplitEntryPK.size());
            IObjectPK[] arrayBakCardPK = new IObjectPK[listBakCardPK.size()];
            System.arraycopy(listBakCardPK.toArray(), 0, arrayBakCardPK, 0, listBakCardPK.size());
            IObjectPK[] arrayBizCardPK = new IObjectPK[listBizCardPK.size()];
            System.arraycopy(listBizCardPK.toArray(), 0, arrayBizCardPK, 0, listBizCardPK.size());
            if (arraySplitEntryPK.length > 0) {
                FaSplitBillEntryFactory.getLocalInstance(ctx).delete(arraySplitEntryPK);
            }
            this.deleteBizBakCard(ctx, arrayBizCardPK, arrayBakCardPK, true);
        }
        FaCurCardInfo curCard = billInfo.getFaCurCard();
        if (!(billInfo.getFaCurCard() == null || billInfo.getFaCurCard().getId() == null || billInfo.getFaBizCard() != null && billInfo.getFaCurCard().getId().toString().equals(billInfo.getFaBizCard().getFaBakCard().getFaCurCard().getId().toString()))) {
            FaDefPropertyValueInfo curpv;
            HashMap<String, FaCurCardInfo> result = new HashMap<String, FaCurCardInfo>();
            result.put(curCard.getId().toString(), curCard);
            this.checkFaCurCardValid(ctx, result);
            String bakCardId = this.saveBakCard(ctx, curCard.getId().toString(), 5);
            String bizCardId = this.saveBizCard(ctx, curCard.getId().toString(), bakCardId, 5);
            if (this.needSubstractDepr(ctx, curCard.getId().toString())) {
                String updateBiz = this.getSubBizCardDepSql(bizCardId);
                DbUtil.execute((Context)ctx, (String)updateBiz);
            }
            if ((curpv = billInfo.getFaCurCard().getPropertyValue()) != null && curpv.getId() != null) {
                FaDefPropertyValueInfo bizpv = FaCardDefPropertyPersist.copy(curpv.getId(), ctx);
                FaCardDefPropertyPersist.updateBizCardPropertyId(ctx, bizCardId, bizpv.getId().toString());
                FaDefPropertyValueInfo bakpv = FaCardDefPropertyPersist.copy(curpv.getId(), ctx);
                FaCardDefPropertyPersist.updateBakCardPropertyId(ctx, bakCardId, bakpv.getId().toString());
            }
            FaBizCardInfo bizBeforeSplit = new FaBizCardInfo();
            bizBeforeSplit.setId(BOSUuid.read((String)bizCardId));
            billInfo.setFaBizCard(bizBeforeSplit);
        }
        ArrayList<String> groupNumber = new ArrayList<String>();
        int size = entryCollection.size();
        for (int i = 0; i < size; ++i) {
            if (entryCollection.get(i) == null || entryCollection.get(i).getFaBizCard() == null) continue;
            FaCurCardInfo entryCurCard = PrcFaCoreManager.BizCard2CurCard(entryCollection.get(i).getFaBizCard());
            entryCurCard.setEffectedStatus(EffectedStatusEnum.EFFECTED);
            entryCurCard.setBizDate(DateTimeUtils.truncateDate((Date)this.getCurrentPeriod(ctx, entryCurCard).getEndDate()));
            FaMonCardInfo entryMonCard = null;
            if (isUseInitCardRule) {
                entryMonCard = PrcFaCoreManager.CurCard2MonCard(entryCurCard);
            }
            String bizGroupNumber = null;
            if (entryCollection.get(i).getFaBizCard().getId() == null) {
                if (isAutoCode) {
                    if (isUseInitCardRule) {
                        FaLocalUtils.setNewCardNumber(ctx, entryMonCard);
                        entryCurCard.setNumber(entryMonCard.getNumber());
                    } else {
                        FaLocalUtils.setNewCardNumber(ctx, entryCurCard);
                    }
                }
                if (isUseGroupCode && isAutoGroupCode) {
                    FaLocalUtils.setNewGroupNumber(ctx, entryCurCard);
                }
                if (isUseBarCode && isAutoBarCode) {
                    FaLocalUtils.setNewBarCode(ctx, entryCurCard);
                }
            } else if (isUseGroupCode && isAutoGroupCode) {
                StringBuffer bizGroupNumberSql = new StringBuffer();
                bizGroupNumberSql.append("select fgroupnumber as groupnumber from t_fa_fabizcard where fid = '");
                bizGroupNumberSql.append(entryCollection.get(i).getFaBizCard().getId().toString());
                bizGroupNumberSql.append("'");
                try {
                    IRowSet bizGroupNumberRowSet = DbUtil.executeQuery((Context)ctx, (String)bizGroupNumberSql.toString());
                    while (bizGroupNumberRowSet.next()) {
                        bizGroupNumber = bizGroupNumberRowSet.getString("groupnumber");
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
            }
            entryCurCard.put("ID_KEY", entryCollection.get(i).getId());
            if (isUseInitCardRule) {
                FaMonCardFactory.getLocalInstance(ctx).checkNumberDup(null, (CoreBillBaseInfo)entryMonCard);
            } else {
                FaCurCardFactory.getLocalInstance(ctx).checkNumberDup(null, (CoreBillBaseInfo)entryCurCard);
            }
            entryCollection.get(i).getFaBizCard().setNumber(entryCurCard.getNumber());
            if (entryCurCard.getGroupNumber() != null) {
                entryCollection.get(i).getFaBizCard().setGroupNumber(entryCurCard.getGroupNumber());
            } else {
                entryCollection.get(i).getFaBizCard().setGroupNumber(bizGroupNumber);
            }
            entryCollection.get(i).getFaBizCard().setBarCode(entryCurCard.getBarCode());
            FaCardDefPropertyPersist.save(entryCollection.get(i).getFaBizCard(), ctx);
            FaBizCardFactory.getLocalInstance(ctx).submit((CoreBaseInfo)entryCollection.get(i).getFaBizCard());
            if (entryCurCard.getGroupNumber() == null || entryCurCard.getGroupNumber().toString() == null) continue;
            if (groupNumber.contains(entryCurCard.getGroupNumber().toString())) {
                String groupNumberDup = FaLocalUtils.getResource(ctx, "com.kingdee.eas.fi.fa.manage.FaCardResource", "groupNumberDup");
                throw new EASBizException(new NumericExceptionSubItem("1", groupNumberDup), (Object[])new String[]{entryCurCard.getGroupNumber().toString()});
            }
            groupNumber.add(entryCurCard.getGroupNumber().toString());
        }
        billInfo.setSplitDate(DateTimeUtils.truncateDate((Date)billInfo.getSplitDate()));
        billInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        billInfo.setFiVouchered(false);
        billInfo.setPeriod(this.getCurrentPeriod(ctx, billInfo));
        billInfo.setBizDate(DateTimeUtils.truncateDate((Date)this.getCurrentPeriod(ctx, billInfo).getEndDate()));
        if (billInfo.getId() == null) {
            PrcFaSplitStrategy.setBillInfoNumber(ctx, billInfo, FaSplitBillFactory.getLocalInstance(ctx));
        }
        return billInfo;
    }

    protected static FaCurCardCollection splitCard(FaCurCardInfo curCardInfo, int splitType) {
        return null;
    }
}

