/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.app.SystemStatusCtrolUtils;
import com.kingdee.eas.fi.fa.manage.FaCardException;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaTerminateBillFactory;
import com.kingdee.eas.fi.fa.manage.FaTerminateBillInfo;
import com.kingdee.eas.fi.fa.manage.FaTerminateException;
import com.kingdee.eas.fi.fa.manage.IFaTerminateBill;
import com.kingdee.eas.fi.fa.manage.app.AbstractPrcFaManageStrategy;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.BlockedStatusEnum;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.framework.IBillBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.sql.SQLException;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Logger;

public class PrcFaTerminateBillStrategy
extends AbstractPrcFaManageStrategy {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.fa.manage.app.PrcFaLeaseInNewStrategy");
    private static final String RES_PATH = "com.kingdee.eas.fi.fa.manage.FaCardResource";

    @Override
    protected void deleteBill(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        IFaTerminateBill iFaLeaseInNew = FaTerminateBillFactory.getLocalInstance(ctx);
        FaTerminateBillInfo billNewInfo = iFaLeaseInNew.getFaTerminateBillInfo("select id,number,company where id ='" + pk + "'");
        this.recycleNumber(ctx, billNewInfo);
        iFaLeaseInNew.deleteSelf(pk);
    }

    @Override
    protected IObjectPK saveBill(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        return this.innerSaveBill(ctx, (FaTerminateBillInfo)model, false);
    }

    private IObjectPK innerSaveBill(Context ctx, FaTerminateBillInfo info, boolean isSubmit) throws BOSException, EASBizException {
        info.setPeriod(FaLocalUtils.getFLCurrentPeriod(info.getCompany().getId().toString(), ctx));
        info.setBizDate(DateTimeUtils.truncateDate((Date)info.getTerminateDate()));
        info.setDeletedStatus(DeletedStatusEnum.NORMAL);
        info.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        info.setBlockedStatus(BlockedStatusEnum.UNBLOCKED);
        info.setFiVouchered(false);
        info.setHasEffected(true);
        info.setEffectedStatus(isSubmit ? EffectedStatusEnum.EFFECTED : EffectedStatusEnum.TEMPSTORE);
        IFaTerminateBill iLeaseInBillNew = FaTerminateBillFactory.getLocalInstance(ctx);
        PrcFaTerminateBillStrategy.setBillInfoNumber(ctx, info, iLeaseInBillNew);
        return isSubmit ? iLeaseInBillNew.submitSelf(info) : iLeaseInBillNew.saveSelf(info);
    }

    @Override
    protected IObjectPK submitBill(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        return this.innerSaveBill(ctx, (FaTerminateBillInfo)model, true);
    }

    @Override
    protected void auditBill(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        FaTerminateBillInfo billInfo = (FaTerminateBillInfo)model;
        ObjectUuidPK pk = new ObjectUuidPK(billInfo.getId());
        FaTerminateBillFactory.getLocalInstance(ctx).passAuditSelf((IObjectPK)pk, billInfo);
    }

    @Override
    protected void unAuditBill(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        FaTerminateBillInfo leaseInNewInfo = (FaTerminateBillInfo)model;
        ObjectUuidPK pk = new ObjectUuidPK(leaseInNewInfo.getId());
        FaTerminateBillFactory.getLocalInstance(ctx).unpassAuditSelf((IObjectPK)pk, leaseInNewInfo);
    }

    @Override
    protected void generateVourcher(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
    }

    @Override
    protected void checkForSave(Context ctx, IObjectValue val) throws EASBizException, BOSException {
        ObjectUuidPK pk;
        ObjectUuidPK objectUuidPK = pk = val.get("id") == null ? null : new ObjectUuidPK(val.get("id").toString());
        if (pk == null || pk.toString().length() == 0) {
            return;
        }
        IBillBase iBillBase = (IBillBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)BOSUuid.read((String)pk.toString()).getType());
        if (!iBillBase.exists("where id='" + pk + "'")) {
            return;
        }
        BillBaseInfo billInfo = this.perpareBillInfo(ctx, (IObjectPK)pk);
        StringBuffer sbMsg = new StringBuffer("");
        if (billInfo.get("effectedStatus").equals(new Integer(2))) {
            sbMsg.append(" ");
            sbMsg.append(this.getEffectedStatus(billInfo, ctx));
        }
        if (billInfo.get("DeletedStatus").equals(new Integer(2))) {
            sbMsg.append(" ");
            sbMsg.append(this.getDeletedStatus(billInfo, ctx));
        }
        if (billInfo.get("blockedStatus").equals(new Integer(2))) {
            sbMsg.append(" ");
            sbMsg.append(this.getBlockedStatus(billInfo, ctx));
        }
        if (FaLocalUtils.isCurrencyDisable(ctx, billInfo)) {
            sbMsg.append(" ");
            sbMsg.append(ResourceBase.getString((String)RES_PATH, (String)"CurrencyDisable", (Locale)ctx.getOriginLocale()));
        }
        if (sbMsg.toString().length() > 0) {
            StringBuffer sbAll = new StringBuffer(ResourceBase.getString((String)RES_PATH, (String)"THISBILL", (Locale)ctx.getOriginLocale()));
            sbAll.append(sbMsg);
            throw new FaCardException(FaCardException.UN_SUCCESS, new String[]{sbAll.toString()});
        }
    }

    @Override
    protected void checkForEdit(Context ctx, IObjectValue val) throws EASBizException, BOSException {
        ObjectUuidPK pk;
        ObjectUuidPK objectUuidPK = pk = val.get("id") == null ? null : new ObjectUuidPK(val.get("id").toString());
        if (pk == null || pk.toString().length() == 0) {
            return;
        }
        BillBaseInfo billInfo = this.perpareBillInfo(ctx, (IObjectPK)pk);
        StringBuffer sbMsg = new StringBuffer("");
        if (billInfo.get("DeletedStatus").equals(new Integer(2))) {
            sbMsg.append(" ");
            sbMsg.append(this.getDeletedStatus(billInfo, ctx));
        }
        if (billInfo.get("checkedStatus").equals(new Integer(2))) {
            sbMsg.append(" ");
            sbMsg.append(this.getCheckedStatus(billInfo, ctx));
        }
        if (billInfo.get("blockedStatus").equals(new Integer(2))) {
            sbMsg.append(" ");
            sbMsg.append(this.getBlockedStatus(billInfo, ctx));
        }
        if (billInfo.getBoolean("fiVouchered")) {
            sbMsg.append(" ");
            sbMsg.append(this.getIsVouchered(billInfo, ctx));
        }
        if (FaLocalUtils.isCurrencyDisable(ctx, billInfo)) {
            sbMsg.append(" ");
            sbMsg.append(ResourceBase.getString((String)RES_PATH, (String)"CurrencyDisable", (Locale)ctx.getOriginLocale()));
        }
        if (sbMsg.toString().length() > 0) {
            StringBuffer sbAll = new StringBuffer(ResourceBase.getString((String)RES_PATH, (String)"THISBILL", (Locale)ctx.getOriginLocale()));
            sbAll.append(sbMsg);
            throw new FaCardException(FaCardException.UN_SUCCESS, new String[]{sbAll.toString()});
        }
    }

    @Override
    protected void checkForDelete(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        if (pk == null || pk.toString().length() == 0) {
            return;
        }
        BillBaseInfo billInfo = this.perpareBillInfo(ctx, pk);
        this.checkStateForDel(ctx, billInfo);
    }

    @Override
    protected void checkForUnAudit(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        if (pk == null || pk.toString().length() == 0) {
            return;
        }
        BillBaseInfo billInfo = this.perpareBillInfo(ctx, pk);
        boolean isFromSource = this.getTempParam().get("FROM_SOURCE") == null ? false : (Boolean)this.getTempParam().get("FROM_SOURCE");
        StringBuffer sbMsg = new StringBuffer("");
        PeriodInfo curPeriod = FaLocalUtils.getFLCurrentPeriod(billInfo.getCompany().getId().toString(), ctx);
        Date bizDate = billInfo.getBizDate();
        if (bizDate != null && ((bizDate = DateTimeUtils.truncateDate((Date)bizDate)).compareTo(curPeriod.getBeginDate()) < 0 || bizDate.compareTo(curPeriod.getEndDate()) > 0)) {
            sbMsg.append(" ");
            sbMsg.append(ResourceBase.getString((String)RES_PATH, (String)"NOT_IN_CURPERIOD", (Locale)ctx.getOriginLocale()));
        }
        if (billInfo.get("DeletedStatus").equals(new Integer(2))) {
            sbMsg.append(" ");
            sbMsg.append(this.getDeletedStatus(billInfo, ctx));
        }
        if (billInfo.get("EffectedStatus").equals(new Integer(1))) {
            sbMsg.append(" ");
            sbMsg.append(this.getEffectedStatus(billInfo, ctx));
        }
        if (billInfo.get("checkedStatus").equals(new Integer(1))) {
            sbMsg.append(" ");
            sbMsg.append(this.getCheckedStatus(billInfo, ctx));
        }
        if (billInfo.get("blockedStatus").equals(new Integer(2))) {
            sbMsg.append(" ");
            sbMsg.append(this.getBlockedStatus(billInfo, ctx));
        }
        if (billInfo.getBoolean("fiVouchered")) {
            sbMsg.append(" ");
            sbMsg.append(this.getIsVouchered(billInfo, ctx));
        }
        if (sbMsg.toString().trim().length() > 0) {
            StringBuffer sbAll = new StringBuffer(ResourceBase.getString((String)RES_PATH, (String)"THISBILL", (Locale)ctx.getOriginLocale()));
            String tips = billInfo instanceof FaCurCardInfo ? " " + billInfo.getNumber() + "(" + billInfo.getString("assetName") + ")" : " " + billInfo.getNumber();
            sbAll.append(tips + sbMsg);
            sbAll.append("\n");
            throw new FaCardException(FaCardException.CANNOT_BE_UNAUDITED, new String[]{"", sbAll.toString()});
        }
        this.checkForUnAudit(ctx, billInfo, isFromSource);
    }

    @Override
    protected void checkForUnAudit(Context ctx, BillBaseInfo billInfo, boolean isFromSource) throws EASBizException, BOSException {
        FaTerminateBillInfo bill = this.getBillInfo(ctx, (IObjectPK)new ObjectUuidPK(billInfo.getId()), this.getAuditSic());
        this.checkTmDate(ctx, bill, false);
        if (bill.isFiVouchered()) {
            StringBuffer sbHasGenVoucher = new StringBuffer(ResourceBase.getString((String)RES_PATH, (String)"Has_GenVoucher", (Locale)ctx.getOriginLocale()));
            throw new FaCardException(FaCardException.CANNOT_BE_UNAUDITED, new String[]{"", sbHasGenVoucher.toString()});
        }
        this.checkDeprAmortVouchered(ctx, bill, false);
    }

    @Override
    protected void checkForAudit(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        if (pk == null || pk.toString().length() == 0) {
            return;
        }
        FaTerminateBillInfo billInfo = this.getBillInfo(ctx, pk, this.getAuditSic());
        StringBuffer sbMsg = new StringBuffer("");
        if (billInfo.get("DeletedStatus").equals(new Integer(2))) {
            sbMsg.append(" ");
            sbMsg.append(this.getDeletedStatus(billInfo, ctx));
        }
        if (billInfo.get("EffectedStatus").equals(new Integer(1))) {
            sbMsg.append(" ");
            sbMsg.append(this.getEffectedStatus(billInfo, ctx));
        }
        if (billInfo.get("checkedStatus").equals(new Integer(2))) {
            sbMsg.append(" ");
            sbMsg.append(this.getCheckedStatus(billInfo, ctx));
        }
        if (billInfo.get("blockedStatus").equals(new Integer(2))) {
            sbMsg.append(" ");
            sbMsg.append(this.getBlockedStatus(billInfo, ctx));
        }
        if (billInfo.getBoolean("fiVouchered")) {
            sbMsg.append(" ");
            sbMsg.append(this.getIsVouchered(billInfo, ctx));
        }
        if (FaLocalUtils.isCurrencyDisable(ctx, billInfo)) {
            sbMsg.append(" ");
            sbMsg.append(ResourceBase.getString((String)RES_PATH, (String)"CurrencyDisable", (Locale)ctx.getOriginLocale()));
        }
        if (sbMsg.toString().length() > 0) {
            StringBuffer sbAll = new StringBuffer(ResourceBase.getString((String)RES_PATH, (String)"THISBILL", (Locale)ctx.getOriginLocale()));
            sbAll.append(sbMsg);
            throw new FaCardException(FaCardException.UN_SUCCESS, new String[]{sbAll.toString()});
        }
        this.checkTmDate(ctx, billInfo, true);
        this.checkDeprAmortVouchered(ctx, billInfo, true);
    }

    private void checkTmDate(Context ctx, FaTerminateBillInfo bill, boolean isAudit) throws EASBizException, BOSException {
        PeriodInfo currentPeriod;
        Date date = bill.getTerminateDate();
        if (date.compareTo((currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.FINANCE_LEASE, (CompanyOrgUnitInfo)bill.getCompany())).getEndDate()) > 0 || date.compareTo(currentPeriod.getBeginDate()) < 0) {
            String msg = EASResource.getString((String)RES_PATH, (String)"terminateDateInPeriod", (Object[])new Object[]{currentPeriod.toString()});
            if (isAudit) {
                throw new FaCardException(FaCardException.CANNOT_BE_AUDITED, new String[]{msg});
            }
            throw new FaCardException(FaCardException.CANNOT_BE_UNAUDITED, new String[]{"", msg});
        }
    }

    private void checkDeprAmortVouchered(Context ctx, FaTerminateBillInfo bill, boolean isAudit) throws EASBizException, BOSException {
        StringBuffer msg = new StringBuffer();
        try {
            for (int i = 0; i < bill.getEntry().size(); ++i) {
                String sql = "SELECT 1 FROM T_Fa_FaDepreAndAmort WHERE FLeaseInBillId = ? AND FPeriodId = ? AND FIVouchered = 1";
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{bill.getEntry().get(i).getLeaseInBill().getId().toString(), bill.getPeriod().getId().toString()});
                if (rs == null || !rs.next()) continue;
                if (msg.length() > 0) {
                    msg.append(",");
                }
                msg.append(bill.getEntry().get(i).getLeaseInBill().getNumber());
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (msg.length() > 0) {
            throw new FaTerminateException(isAudit ? FaTerminateException.DEPREANDAMORT_VOUCHERED_AUDIT_FAIL : FaTerminateException.DEPREANDAMORT_VOUCHERED_UNAUDIT_FAIL, new String[]{msg.toString()});
        }
    }

    private SelectorItemCollection getAuditSic() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("period.id");
        sic.add("entry.id");
        sic.add("entry.leaseInBill.id");
        sic.add("entry.leaseInBill.number");
        sic.add("company.id");
        sic.add("company.number");
        return sic;
    }

    public FaTerminateBillInfo getBillInfo(Context ctx, IObjectPK pk, SelectorItemCollection sic) throws EASBizException, BOSException {
        return FaTerminateBillFactory.getLocalInstance(ctx).getFaTerminateBillInfo(pk, sic);
    }

    @Override
    protected BillBaseInfo perpareBillInfo(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        SelectorItemCollection sic;
        if (pk == null) {
            throw new IllegalArgumentException();
        }
        BOSUuid uuid = (BOSUuid)pk.getKeyValue("id");
        IBillBase iBillBase = (IBillBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)uuid.getType());
        BillBaseInfo billInfo = iBillBase.getBillBaseInfo(pk, sic = this.getStatusSelectors());
        if (billInfo == null) {
            throw new EASBizException(EASBizException.CHECKPARENTDELETED);
        }
        if (billInfo == null) {
            billInfo = iBillBase.getBillBaseInfo(pk, sic);
        }
        if (billInfo == null) {
            throw new EASBizException(EASBizException.CHECKPARENTDELETED);
        }
        return billInfo;
    }

    public static int getCurrencyScale(CompanyOrgUnitInfo company, Context ctx) throws EASBizException, BOSException {
        CurrencyInfo currency;
        if (company == null) {
            company = ContextUtil.getCurrentFIUnit((Context)ctx);
        }
        if ((currency = company.getBaseCurrency()) != null && currency.get("precision") != null) {
            return currency.getPrecision();
        }
        if (currency == null || currency.getId() == null) {
            CompanyOrgUnitInfo _comp = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("select baseCurrency.precision where id='" + company.getId() + "'");
            return _comp.getBaseCurrency().getPrecision();
        }
        return CurrencyFactory.getLocalInstance((Context)ctx).getValue("select precision where id='" + company.getBaseCurrency().getId() + "'").getInt("precision");
    }
}

