/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app.dataimp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAsstActType;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.fa.basedata.FaResUtil;
import com.kingdee.eas.fi.fa.def.FaDefCommonFacadeFactory;
import com.kingdee.eas.fi.fa.def.FaDefPropertyCollection;
import com.kingdee.eas.fi.fa.def.FaDefPropertyEnumInfoCollection;
import com.kingdee.eas.fi.fa.def.FaDefPropertyEnumInfoFactory;
import com.kingdee.eas.fi.fa.def.FaDefPropertyInfo;
import com.kingdee.eas.fi.fa.def.FaDefPropertyValueInfo;
import com.kingdee.eas.fi.fa.def.app.DefDBUtil;
import com.kingdee.eas.fi.fa.manage.FaCardInfo;
import com.kingdee.eas.fi.fa.manage.FaMonCardFactory;
import com.kingdee.eas.fi.fa.manage.app.FaCardDefPropertyPersist;
import com.kingdee.eas.fi.fa.manage.app.dataimp.AbstractFaDataImport;
import com.kingdee.eas.fi.fa.manage.app.dataimp.FaDataImportUtils;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.report.util.DBUtilx;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class FaMonDefPropertyDataImport
extends AbstractFaDataImport {
    private static final Logger logger = Logger.getLogger(FaMonDefPropertyDataImport.class);
    protected DefCache cache = new DefCache();
    private Map<String, DefCache> cacheMap = new HashMap<String, DefCache>();

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return FaMonCardFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        FaCardInfo card = (FaCardInfo)coreBaseInfo;
        try {
            FaCardDefPropertyPersist.deleteByMonCardPK(ctx, (IObjectPK)new ObjectUuidPK(card.getId()));
            FaDefPropertyValueInfo pv = FaCardDefPropertyPersist.save(card.getPropertyValue(), ctx);
            card.setPropertyValue(pv);
            if (this.isInitCard()) {
                DBUtilx.executeUpdate((String)"update T_Fa_FaMonCard set FPropertyValueId=? where FID=?", (SqlParams)new SqlParams().addString(pv.getId().toString()).addString(card.getId().toString()), (Context)ctx);
                RptRowSet rs = DBUtilx.executeQuery((String)"select FFaCurCardId from T_Fa_FaMonCard where FID=?", (SqlParams)new SqlParams().addString(card.getId().toString()), (Context)ctx);
                rs.next();
                String curCardId = rs.getString("FFaCurCardId");
                if (curCardId != null) {
                    FaCardDefPropertyPersist.deleteByCurCardPK(ctx, curCardId);
                    pv.setId(null);
                    pv = FaCardDefPropertyPersist.save(pv, ctx);
                    DBUtilx.executeUpdate((String)"update T_Fa_FaCurCard set FPropertyValueId=? where FID=?", (SqlParams)new SqlParams().addString(pv.getId().toString()).addString(curCardId), (Context)ctx);
                }
            } else {
                super.submit(coreBaseInfo, ctx);
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    protected FaCardInfo getCardInfo(Context ctx, String cardNumber, boolean isExp) throws TaskExternalException {
        String companyId = isExp ? ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString() : this.cache.company.getId().toString();
        try {
            CoreBaseCollection result = this.getController(ctx).getCollection("select id,number,propertyValue.*,checkedStatus,assetCat.id where number='" + cardNumber + "' and company.id='" + companyId + "'");
            if (result.size() == 0) {
                throw new TaskExternalException(MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"62_FaMonDefPropertyDataImport", (Locale)ctx.getOriginLocale()), cardNumber, this.isInitCard() ? ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"64_FaMonDefPropertyDataImport", (Locale)ctx.getOriginLocale()) : ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"65_FaMonDefPropertyDataImport", (Locale)ctx.getOriginLocale())));
            }
            FaCardInfo card = (FaCardInfo)result.get(0);
            if (!this.isSltImportUpdate() && card.getPropertyValue() != null) {
                throw new TaskExternalException(FaResUtil.getRes((String)"evalInfo23", (Locale)ctx.getOriginLocale()));
            }
            return card;
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable data, Context ctx) throws TaskExternalException {
        FaDefPropertyValueInfo pv;
        String companyNumber = (String)FaDataImportUtils.getValue(data, "FOrgUnitID");
        if (companyNumber != null && !"".equals(companyNumber)) {
            if (this.cacheMap.containsKey(companyNumber)) {
                this.cache = this.cacheMap.get(companyNumber);
            } else {
                this.cache = new DefCache();
                this.cacheMap.put(companyNumber, this.cache);
            }
        } else {
            if (!this.isInitCard()) {
                throw new TaskExternalException(FaResUtil.getRes((String)"fOrgUnitIDIsNull", (Locale)ctx.getOriginLocale()));
            }
            companyNumber = ContextUtil.getCurrentFIUnit((Context)ctx).getNumber();
            this.cache = new DefCache();
            this.cacheMap.put(companyNumber, this.cache);
        }
        String companyId = null;
        if (this.cache.company != null) {
            companyId = this.cache.company.getId().toString();
        } else {
            try {
                this.cache.company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("SELECT * , baseCurrency.* WHERE NUMBER ='" + companyNumber + "'");
            }
            catch (Exception e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
            companyId = this.cache.company.getId().toString();
        }
        String number = (String)FaDataImportUtils.getValue(data, "FFaCardId");
        FaCardInfo info = this.getCardInfo(ctx, number, false);
        this.cache.initCacheByCompanyAndCardCat(companyId, info.getAssetCat().getId().toString(), ctx);
        HashMap params = this.cache.PARAMS;
        if (params == null) {
            ObjectUuidPK pk = new ObjectUuidPK(companyId);
            HashMap<String, ObjectUuidPK> paramKeyMap = new HashMap<String, ObjectUuidPK>();
            paramKeyMap.put("FA_037", pk);
            try {
                params = ParamManager.getParamHashMap((Context)ctx, paramKeyMap);
            }
            catch (Exception e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
            this.cache.PARAMS = params;
        }
        if (!this.isInitCard()) {
            FaDataImportUtils.checkCardAudit(ctx, info, this.cache.PARAMS);
        }
        if ((pv = info.getPropertyValue()) == null) {
            pv = new FaDefPropertyValueInfo();
            info.setPropertyValue(pv);
        }
        Set fieldSet = data.keySet();
        for (String key : fieldSet) {
            FaDefPropertyInfo p;
            if (key.toLowerCase(Locale.ENGLISH).startsWith("def_")) {
                String defNumber = key.substring(4);
                FaDefPropertyInfo p2 = this.cache.getByNumber(defNumber);
                if (p2 == null) continue;
                Object value = FaDataImportUtils.getValue(data, key);
                pv.put(defNumber, this.cache.trans2Object(value, p2, key));
                continue;
            }
            if (!key.toLowerCase(Locale.ENGLISH).startsWith("f")) continue;
            RptRowSet rrs = null;
            String defNumber = key;
            String sql = "select e.FQueryprop from T_DIE_TemplateFieldEntry e inner join T_DIE_TEMPLATE t on e.fparentid=t.fid where t.fnumber=? and e.Fnumber = ? order by FSeq";
            try {
                rrs = DefDBUtil.executeQuery((String)sql, (SqlParams)new SqlParams().addString(this.getTemplateName()).addString(key), (Context)ctx);
                while (rrs.next()) {
                    String queryprop = rrs.getString("FQueryprop");
                    if (queryprop == null || !queryprop.toLowerCase(Locale.ENGLISH).startsWith("pv.")) continue;
                    defNumber = queryprop.substring(3);
                    break;
                }
            }
            catch (SQLDataException e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
            if ((p = this.cache.getByNumber(defNumber)) == null) continue;
            Object value = FaDataImportUtils.getValue(data, key);
            pv.put(defNumber, this.cache.trans2Object(value, p, key));
        }
        pv.value2pros();
        return info;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        try {
            RptRowSet rrs = null;
            String sql = "select e.FNumber, e.FQueryprop from T_DIE_TemplateFieldEntry e inner join T_DIE_TEMPLATE t on e.fparentid=t.fid where t.fnumber=? order by FSeq";
            rrs = DefDBUtil.executeQuery((String)sql, (SqlParams)new SqlParams().addString(this.getTemplateName()), (Context)ctx);
            String[] exp_field_in_file = new String[rrs.getRowCount()];
            String[] exp_key = new String[rrs.getRowCount()];
            while (rrs.next()) {
                String key = rrs.getString("FNumber");
                String queryprop = rrs.getString("FQueryprop");
                exp_field_in_file[rrs.getRow()] = key;
                if ("FFaCardId".equalsIgnoreCase(key)) {
                    key = "number";
                } else if ("FOrgUnitID".equalsIgnoreCase(key)) {
                    key = "company.number";
                } else if (key.toLowerCase(Locale.ENGLISH).startsWith("def_")) {
                    key = "PV." + key.substring(4);
                } else if (key.toLowerCase(Locale.ENGLISH).startsWith("f") && queryprop.toLowerCase(Locale.ENGLISH).startsWith("pv.")) {
                    key = queryprop;
                }
                exp_key[rrs.getRow()] = key;
            }
            String companyId = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
            FaCardInfo info = this.getCardInfo(ctx, rs.getString("number"), true);
            this.cache.initCacheByCompanyAndCardCat(companyId, info.getAssetCat().getId().toString(), ctx);
            Hashtable result = FaDataImportUtils.setDataForExport2(exp_field_in_file, exp_key, rs, null, this.cache.pc, ctx);
            return result;
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        return FaDataImportUtils.getFilterForExp(ctx, super.getExportFilterForQuery(ctx), true);
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.fi.fa.def.app.FaMonDefPropertyQuery";
    }

    protected boolean isInitCard() {
        return true;
    }

    protected String getTemplateName() {
        return "famondefproperty";
    }

    class DefCache {
        CompanyOrgUnitInfo company = null;
        BigDecimal zero = new BigDecimal("0");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String companyId;
        String catId;
        FaDefPropertyCollection pc;
        Map valueCache = new HashMap();
        Context ctx;
        public HashMap PARAMS = null;

        DefCache() {
        }

        void initCache(String companyId, Context ctx) throws TaskExternalException {
            this.ctx = ctx;
            if (this.companyId == null || !this.companyId.equals(companyId)) {
                this.companyId = companyId;
                this.valueCache.clear();
                try {
                    this.pc = FaDefCommonFacadeFactory.getLocalInstance((Context)ctx).getProperties(companyId, false);
                }
                catch (BOSException e) {
                    throw new TaskExternalException(e.getMessage(), (Throwable)e);
                }
            }
        }

        void initCacheByCompanyAndCardCat(String companyId, String catId, Context ctx) throws TaskExternalException {
            this.ctx = ctx;
            if (this.companyId == null || !this.companyId.equals(companyId) || this.catId == null || !this.catId.equals(catId)) {
                this.companyId = companyId;
                this.catId = catId;
                this.valueCache.clear();
                try {
                    this.pc = FaDefCommonFacadeFactory.getLocalInstance((Context)ctx).getProperties(companyId, catId, true);
                }
                catch (BOSException e) {
                    throw new TaskExternalException(e.getMessage(), (Throwable)e);
                }
            }
        }

        public FaDefPropertyInfo getByNumber(String number) {
            for (int i = 0; i < this.pc.size(); ++i) {
                FaDefPropertyInfo p = this.pc.get(i);
                if (!p.getNumber().equalsIgnoreCase(number)) continue;
                return p;
            }
            return null;
        }

        public Object getEnumValue(String name, FaDefPropertyInfo p) {
            String key = "xl_" + name;
            if (this.valueCache.containsKey(key)) {
                return this.valueCache.get(key);
            }
            this.valueCache.put(key, null);
            try {
                FaDefPropertyEnumInfoCollection ec = FaDefPropertyEnumInfoFactory.getLocalInstance((Context)this.ctx).getFaDefPropertyEnumInfoCollection("select * where parent.id='" + p.getId().toString() + "'");
                for (int i = 0; i < ec.size(); ++i) {
                    if (!name.equals(ec.get(i).getName())) continue;
                    String id = ec.get(i).getId().toString();
                    this.valueCache.put(key, id);
                    return id;
                }
            }
            catch (BOSException e) {
                logger.error((Object)e);
                return null;
            }
            return null;
        }

        public Object getActValue(String name, FaDefPropertyInfo p, String key2) throws TaskExternalException {
            String key = "act_" + name;
            if (this.valueCache.containsKey(key)) {
                return this.valueCache.get(key);
            }
            this.valueCache.put(key, null);
            try {
                IAsstActType it = AsstActTypeFactory.getLocalInstance((Context)this.ctx);
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add("realtionDataObject");
                sic.add("glAsstActTypeGrp.id");
                AsstActTypeInfo actType = it.getAsstActTypeInfo((IObjectPK)new ObjectUuidPK(p.getAsstActType().getId()), sic);
                String table = actType.getRealtionDataObject();
                if (key2.toLowerCase(Locale.ENGLISH).contains("_longnumber")) {
                    RptRowSet rs;
                    if (actType.getGlAsstActTypeGrp() != null && actType.getGlAsstActTypeGrp().getId() != null) {
                        String grpId = actType.getGlAsstActTypeGrp().getId().toString();
                        String sql = "select fid from " + table + " where flongnumber = ? and fgroupid = ?";
                        rs = DBUtilx.executeQuery((String)sql, (SqlParams)new SqlParams().addString(name).addString(grpId), (Context)this.ctx);
                    } else {
                        String sql = "select fid from " + table + " where flongnumber = ?";
                        rs = DBUtilx.executeQuery((String)sql, (SqlParams)new SqlParams().addString(name), (Context)this.ctx);
                    }
                    if (rs.getRowCount() == 1) {
                        rs.next();
                        String id = rs.getString("fid");
                        this.valueCache.put(key, id);
                        return id;
                    }
                } else if (key2.toLowerCase(Locale.ENGLISH).contains("_name")) {
                    String loc = LocaleUtils.getLocaleString((Locale)this.ctx.getLocale());
                    String sql = "select fid from " + table + " where fname_" + loc + " = ?";
                    RptRowSet rs = DBUtilx.executeQuery((String)sql, (SqlParams)new SqlParams().addString(name), (Context)this.ctx);
                    if (rs.getRowCount() == 1) {
                        rs.next();
                        String id = rs.getString("fid");
                        this.valueCache.put(key, id);
                        return id;
                    }
                    if (rs.getRowCount() > 1) {
                        throw new TaskExternalException(MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"FaMonDefPropertyDataImportDuplicateName", (Locale)this.ctx.getOriginLocale()), key2, name, key2));
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
            return null;
        }

        public Object trans2Object(Object value, FaDefPropertyInfo p, String key) throws TaskExternalException {
            int type = p.getType().getValue();
            if (value == null || value.equals("")) {
                return type == 2 ? this.zero : null;
            }
            switch (type) {
                case 2: {
                    return new BigDecimal((String)value);
                }
                case 3: {
                    return this.getEnumValue((String)value, p);
                }
                case 4: {
                    try {
                        return this.sdf.parse((String)value);
                    }
                    catch (ParseException e) {
                        logger.error((Object)e);
                        return null;
                    }
                }
                case 5: {
                    return this.getActValue((String)value, p, key);
                }
                case 1: {
                    return (String)value;
                }
            }
            return value;
        }
    }
}

