/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app.dataimp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.fi.fa.basedata.FaResUtil;
import com.kingdee.eas.fi.fa.manage.FaCardCache;
import com.kingdee.eas.fi.fa.manage.FaCurCardCollection;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaCurDepartmentCollection;
import com.kingdee.eas.fi.fa.manage.FaCurDepartmentFactory;
import com.kingdee.eas.fi.fa.manage.FaCurDepartmentInfo;
import com.kingdee.eas.fi.fa.manage.FaDepartmentInfo;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.FaMonCardFactory;
import com.kingdee.eas.fi.fa.manage.FaMonCardInfo;
import com.kingdee.eas.fi.fa.manage.FaMonDepartmentCollection;
import com.kingdee.eas.fi.fa.manage.FaMonDepartmentFactory;
import com.kingdee.eas.fi.fa.manage.FaMonDepartmentInfo;
import com.kingdee.eas.fi.fa.manage.IFaMonDepartment;
import com.kingdee.eas.fi.fa.manage.app.FaLastPeriodChangeUtils;
import com.kingdee.eas.fi.fa.manage.app.dataimp.AbstractFaDataImport;
import com.kingdee.eas.fi.fa.manage.app.dataimp.FaDataImportUtils;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;

public class FaMonDeptDataImport
extends AbstractFaDataImport {
    private FaCurCardInfo card;
    private String cardNumber;
    protected CompanyOrgUnitInfo company;
    private String[] EXP_FIELD_IN_FILE = new String[]{"FOrgUnitID", "FFaCardID", "FDepartmentID", "FAccountID", "FUsage", "Fremark", "FCreatorNumber", "FCreateTime"};
    private String[] EXP_FIELD_IN_QUERY = new String[]{"company.number", "number", "useDepartment.number", "usePerson.number", "department.usage", "department.remark", "creator.number", "createTime"};
    private QueryObjCacheInfo cache = new QueryObjCacheInfo();
    private Map<String, QueryObjCacheInfo> cacheMap = new HashMap<String, QueryObjCacheInfo>();
    private HashSet<String> isAlreadyDeletedCurCardSet = new HashSet();
    private HashSet<String> isAlreadyDeletedMonCardSet = new HashSet();

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        return null;
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            FaCurDepartmentInfo curDepartment = new FaCurDepartmentInfo();
            FaDataImportUtils.cloneObjectInfo(coreBaseInfo, (CoreBaseInfo)curDepartment);
            curDepartment.setFaCurCard(this.card);
            if (coreBaseInfo.getId() != null) {
                curDepartment.setId(coreBaseInfo.getId());
                FaCurDepartmentFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(curDepartment.getId()), (CoreBaseInfo)curDepartment);
            } else {
                FaCurDepartmentFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)curDepartment);
            }
            FaMonDepartmentInfo monDepartment = new FaMonDepartmentInfo();
            FaDataImportUtils.cloneObjectInfo(coreBaseInfo, (CoreBaseInfo)monDepartment);
            String monCardId = FaDataImportUtils.getFaMonCardID(ctx, this.cardNumber, this.company.getId().toString());
            FaMonCardInfo monCard = new FaMonCardInfo();
            monCard.setId(BOSUuid.read((String)monCardId));
            monDepartment.setFaMonCard(monCard);
            IFaMonDepartment idepartment = FaMonDepartmentFactory.getLocalInstance(ctx);
            if (coreBaseInfo.getId() != null) {
                idepartment.delete("where faMonCard.id='" + monCard.getId() + "' and useDepartment.id='" + monDepartment.getUseDepartment().getId() + "'");
            }
            idepartment.submit((CoreBaseInfo)monDepartment);
            boolean isLastestPeriod = (Boolean)this.getContextParameter("card_islastestperiod");
            if (!isLastestPeriod) {
                String[] cardIds = new String[]{this.card.getId().toString(), monCard.getId().toString()};
                FaLastPeriodChangeUtils.updateMonCardLastPeriodChangeForImoport(ctx, cardIds);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
        }
    }

    public CoreBaseInfo transmit(Hashtable data, Context ctx) throws TaskExternalException {
        FaDepartmentInfo info;
        Locale locale;
        block50: {
            boolean useDepartmentCovered;
            boolean isNewCard;
            FaCardCache ccache;
            block49: {
                locale = ctx.getOriginLocale();
                String companyNumber = (String)FaDataImportUtils.getValue(data, "FOrgUnitID");
                if (companyNumber != null && !"".equals(companyNumber)) {
                    if (this.cacheMap.containsKey(companyNumber)) {
                        this.cache = this.cacheMap.get(companyNumber);
                    } else {
                        this.cache = new QueryObjCacheInfo();
                        this.cacheMap.put(companyNumber, this.cache);
                    }
                } else {
                    if (!this.isInitCard()) {
                        throw new TaskExternalException(FaResUtil.getRes((String)"fOrgUnitIDIsNull", (Locale)ctx.getOriginLocale()));
                    }
                    companyNumber = ContextUtil.getCurrentFIUnit((Context)ctx).getNumber();
                    this.cache = new QueryObjCacheInfo();
                    this.cacheMap.put(companyNumber, this.cache);
                }
                if (this.cache.COMPANY != null) {
                    this.company = this.cache.COMPANY;
                } else {
                    try {
                        this.company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("SELECT * , baseCurrency.* WHERE NUMBER ='" + companyNumber + "'");
                    }
                    catch (Exception e) {
                        throw new TaskExternalException(e.getMessage(), (Throwable)e);
                    }
                    this.cache.COMPANY = this.company;
                }
                this.verifyBeforeTran(ctx, true);
                this.cardNumber = this.getValue(ctx, data, "FFaCardID", FaResUtil.getRes((String)"cardNumber1", (Locale)locale), false);
                ccache = FaCardCache.getCache();
                FaCurCardInfo ccard = null;
                if (ccache != null) {
                    ccard = ccache.getCurCard(this.cardNumber);
                }
                String cardId = null;
                if (ccard != null) {
                    cardId = ccard.getId().toString();
                }
                if (cardId == null) {
                    cardId = FaDataImportUtils.getFaCurCardId(ctx, this.cardNumber, this.company.getId().toString());
                    if (cardId == null) {
                        cardId = FaDataImportUtils.getFaMonCardID(ctx, this.cardNumber, this.company.getId().toString());
                    }
                    if (cardId == null) {
                        throw new TaskExternalException(MessageFormat.format(FaResUtil.getRes((String)"moncard_null", (Locale)ctx.getOriginLocale()), this.cardNumber));
                    }
                }
                FaMonCardInfo faMonCardInfo = null;
                isNewCard = false;
                if (ccard != null) {
                    this.card = ccard;
                    isNewCard = ccard.get("isNewCard") != null;
                } else {
                    try {
                        if (this.isInitCard()) {
                            String monCardId = null;
                            StringBuffer sql = new StringBuffer();
                            sql.append("SELECT FID FROM T_FA_FAMONCARD WHERE FNUMBER = ? AND FCOMPANYID = ? ");
                            try {
                                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{this.cardNumber, this.company.getId().toString()});
                                if (rs.next()) {
                                    monCardId = rs.getString("FID");
                                }
                                if (monCardId == null) {
                                    throw new TaskExternalException(MessageFormat.format(FaResUtil.getRes((String)"moncard_null", (Locale)ctx.getOriginLocale()), this.cardNumber));
                                }
                                faMonCardInfo = FaMonCardFactory.getLocalInstance(ctx).getFaMonCardInfo((IObjectPK)new ObjectUuidPK(monCardId));
                                this.card = FaManageUtils.MonCard2CurCard(faMonCardInfo);
                                this.card.setId(faMonCardInfo.getId());
                                break block49;
                            }
                            catch (Exception e) {
                                throw new TaskExternalException(e.getMessage(), (Throwable)e);
                            }
                        }
                        EntityViewInfo view = new EntityViewInfo();
                        SelectorItemCollection selector = view.getSelector();
                        selector.add(new SelectorItemInfo("id"));
                        selector.add(new SelectorItemInfo("effectedStatus"));
                        selector.add(new SelectorItemInfo("company.*"));
                        view.setBaseOnSelector(true);
                        FilterInfo filter = new FilterInfo();
                        filter.getFilterItems().add(new FilterItemInfo("id", (Object)cardId, CompareType.EQUALS));
                        view.setFilter(filter);
                        FaCurCardCollection coll = FaCurCardFactory.getLocalInstance(ctx).getFaCurCardCollection(view);
                        if (coll != null && coll.size() > 0) {
                            this.card = coll.get(0);
                        }
                    }
                    catch (BOSException e) {
                        throw new TaskExternalException(e.getMessage(), (Throwable)e);
                    }
                }
            }
            if (!isNewCard && this.isInitCard() && ccache != null) {
                isNewCard = ccache.hasMonCardNum(this.cardNumber);
            }
            this.verifyCardForOverride(ctx, this.card);
            this.card.setCompany(this.company);
            if (this.cache.ISCHECKBUSSINESSDATA != null) {
                boolean isCheckBussinessData = this.cache.ISCHECKBUSSINESSDATA;
                if (isCheckBussinessData && !isNewCard) {
                    FaDataImportUtils.verifyForLastestPeriod(ctx, this.card, this.getContextParameter(), this.isInitCard());
                }
            } else {
                boolean verifyResult = FaDataImportUtils.verifyBusiDataForLastestPeriod(ctx, this.card, this.getContextParameter(), this.isInitCard());
                if (verifyResult && !isNewCard) {
                    FaDataImportUtils.verifyForLastestPeriod(ctx, this.card, this.getContextParameter(), this.isInitCard());
                }
                this.cache.ISCHECKBUSSINESSDATA = verifyResult;
            }
            try {
                useDepartmentCovered = FaManageUtils.getFaParamValue(ctx, "FA_203", this.company.getId().toString());
            }
            catch (Exception e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
            boolean isOverride = this.isSltImportUpdate();
            if (isOverride && useDepartmentCovered) {
                String needDeleteCardId = this.card.getId().toString();
                String needDeleteMonCardId = FaDataImportUtils.getFaMonCardID(ctx, this.cardNumber, this.company.getId().toString());
                try {
                    if (!this.isAlreadyDeletedCurCardSet.contains(needDeleteCardId)) {
                        FaCurDepartmentFactory.getLocalInstance(ctx).delete(" where faCurCard.id ='" + needDeleteCardId + "'");
                        this.isAlreadyDeletedCurCardSet.add(needDeleteCardId);
                    }
                    if (needDeleteMonCardId != null && !this.isAlreadyDeletedMonCardSet.contains(needDeleteMonCardId)) {
                        FaMonDepartmentFactory.getLocalInstance(ctx).delete("where faMonCard.id='" + needDeleteMonCardId + "'");
                        this.isAlreadyDeletedMonCardSet.add(needDeleteMonCardId);
                    }
                }
                catch (Exception ex) {
                    throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
                }
                FaDepartmentInfo info2 = new FaDepartmentInfo();
                String useDeptNumber = this.getValue(ctx, data, "FDepartmentID", FaResUtil.getRes((String)"usedDepartment", (Locale)locale), false);
                if (this.cache.USEDEPT.containsKey(useDeptNumber)) {
                    info2.setUseDepartment((AdminOrgUnitInfo)this.cache.USEDEPT.get(useDeptNumber));
                } else {
                    AdminOrgUnitInfo _usedept = FaDataImportUtils.getAdminOrgUnitInfo(ctx, this.company.getCU().getId().toString(), useDeptNumber, FaResUtil.getRes((String)"noMatchDepartment", (Locale)locale));
                    info2.setUseDepartment(_usedept);
                    this.cache.USEDEPT.put(useDeptNumber, _usedept);
                }
                String personNum = this.getValue(ctx, data, "FAccountID", FaResUtil.getRes((String)"usedPerson", (Locale)locale), true);
                if (this.cache.PERSON.containsKey(personNum)) {
                    info2.setUsePerson((PersonInfo)this.cache.PERSON.get(personNum));
                } else {
                    PersonInfo _person = FaDataImportUtils.getPersonInfo(ctx, this.company.getCU().getId().toString(), personNum);
                    info2.setUsePerson(_person);
                    this.cache.PERSON.put(personNum, _person);
                }
                info2.setRemark(this.getValue(ctx, data, "Fremark", FaResUtil.getRes((String)"remark", (Locale)locale), true));
                info2.setUsage(this.getValue(ctx, data, "FUsage", FaResUtil.getRes((String)"usage", (Locale)locale), true));
                info2.setSeq(FaDataImportUtils.getSeq(ctx, this.card.getId().toString(), "t_fa_facurdepartment"));
                return info2;
            }
            info = new FaDepartmentInfo();
            String useDeptNumber = this.getValue(ctx, data, "FDepartmentID", FaResUtil.getRes((String)"usedDepartment", (Locale)locale), false);
            if (this.cache.USEDEPT.containsKey(useDeptNumber)) {
                info.setUseDepartment((AdminOrgUnitInfo)this.cache.USEDEPT.get(useDeptNumber));
            } else {
                AdminOrgUnitInfo _usedept = FaDataImportUtils.getAdminOrgUnitInfo(ctx, this.company.getCU().getId().toString(), useDeptNumber, FaResUtil.getRes((String)"noMatchDepartment", (Locale)locale));
                info.setUseDepartment(_usedept);
                this.cache.USEDEPT.put(useDeptNumber, _usedept);
            }
            try {
                if (this.isInitCard()) {
                    FaMonDepartmentCollection monDepts = FaMonDepartmentFactory.getLocalInstance(ctx).getFaMonDepartmentCollection("where faMonCard.id ='" + this.card.getId() + "' and useDepartment.id = '" + info.getUseDepartment().getId() + "'");
                    if (monDepts.size() <= 0) break block50;
                    if (isOverride) {
                        info.setId(monDepts.get(0).getId());
                        break block50;
                    }
                    throw new TaskExternalException(FaResUtil.getRes((String)"evalInfo23", (Locale)ctx.getOriginLocale()));
                }
                FaCurDepartmentCollection curDepts = FaCurDepartmentFactory.getLocalInstance(ctx).getFaCurDepartmentCollection("where faCurCard.id ='" + this.card.getId() + "' and useDepartment.id = '" + info.getUseDepartment().getId() + "'");
                if (curDepts.size() <= 0) break block50;
                if (isOverride) {
                    info.setId(curDepts.get(0).getId());
                    break block50;
                }
                throw new TaskExternalException(FaResUtil.getRes((String)"evalInfo23", (Locale)ctx.getOriginLocale()));
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
        }
        String personNum = this.getValue(ctx, data, "FAccountID", FaResUtil.getRes((String)"usedPerson", (Locale)locale), true);
        if (this.cache.PERSON.containsKey(personNum)) {
            info.setUsePerson((PersonInfo)this.cache.PERSON.get(personNum));
        } else {
            PersonInfo _person = FaDataImportUtils.getPersonInfo(ctx, this.company.getCU().getId().toString(), personNum);
            info.setUsePerson(_person);
            this.cache.PERSON.put(personNum, _person);
        }
        info.setRemark(this.getValue(ctx, data, "Fremark", FaResUtil.getRes((String)"remark", (Locale)locale), true));
        info.setUsage(this.getValue(ctx, data, "FUsage", FaResUtil.getRes((String)"usage", (Locale)locale), true));
        info.setSeq(FaDataImportUtils.getSeq(ctx, this.card.getId().toString(), "t_fa_facurdepartment"));
        return info;
    }

    private void verifyCardForOverride(Context ctx, FaCurCardInfo card) throws TaskExternalException {
        if (!this.isInitCard() && card.getEffectedStatus().getValue() != 1) {
            throw new TaskExternalException(FaResUtil.getRes((String)"tempCardCanOverride2", (Locale)ctx.getOriginLocale()));
        }
    }

    private String getValue(Context ctx, Map data, String fieldName, String fieldCHN, boolean supportNull) throws TaskExternalException {
        String result;
        Object obj = null;
        obj = data.get(fieldName) == null ? null : ((DataToken)data.get((Object)fieldName)).data;
        String string = result = obj == null ? null : obj.toString();
        if (StringUtils.isEmpty((String)result) && !supportNull) {
            this.abort(ctx, MessageFormat.format(FaResUtil.getRes((String)"columnCanNotNull", (Locale)ctx.getOriginLocale()), fieldCHN));
        }
        return result;
    }

    private void abort(Context ctx, String message) throws TaskExternalException {
        throw new TaskExternalException(message + "\t" + FaResUtil.getRes((String)"cardNumber2", (Locale)ctx.getOriginLocale()) + this.cardNumber);
    }

    protected FaCurCardInfo getCard() {
        return this.card;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        String companyNumber = ContextUtil.getCurrentFIUnit((Context)ctx).getNumber();
        if (this.cacheMap.containsKey(companyNumber)) {
            this.cache = this.cacheMap.get(companyNumber);
        } else {
            this.cache = new QueryObjCacheInfo();
            this.cacheMap.put(companyNumber, this.cache);
        }
        if (this.cache.COMPANY != null) {
            this.company = this.cache.COMPANY;
        } else {
            this.cache.COMPANY = this.company = ContextUtil.getCurrentFIUnit((Context)ctx);
        }
        this.verifyBeforeTran(ctx, false);
        Hashtable result = null;
        try {
            result = this.isInitCard() ? FaDataImportUtils.setDataForExport(Arrays.copyOfRange(this.EXP_FIELD_IN_FILE, 1, this.EXP_FIELD_IN_FILE.length), Arrays.copyOfRange(this.EXP_FIELD_IN_QUERY, 1, this.EXP_FIELD_IN_QUERY.length), rs, null) : FaDataImportUtils.setDataForExport(this.EXP_FIELD_IN_FILE, this.EXP_FIELD_IN_QUERY, rs, null);
            if (rs.getString("department.id") == null || rs.getString("department.id").trim().length() == 0) {
                return result;
            }
            return result;
        }
        catch (SQLException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        return FaDataImportUtils.getFilterForExp(ctx, super.getExportFilterForQuery(ctx), true);
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.fi.fa.manage.FaMonCardDeptExpQuery";
    }

    protected void verifyBeforeTran(Context ctx, boolean isImp) throws TaskExternalException {
        CompanyOrgUnitInfo _comp = this.company;
        if (_comp == null) {
            String strMsg = ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.Company_Null", (Locale)ctx.getOriginLocale());
            throw new TaskExternalException(strMsg);
        }
        if (!_comp.isIsBizUnit()) {
            String strMsg = ResourceBase.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource.vitualComNotAllowUseThisFun", (Locale)ctx.getOriginLocale());
            throw new TaskExternalException(strMsg);
        }
        if (this.isInitCard()) {
            boolean isstart = false;
            if (this.cache.ISSTART != null) {
                isstart = this.cache.ISSTART;
            } else {
                try {
                    isstart = SystemStatusCtrolUtils.isStart((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)this.company);
                }
                catch (Exception e) {
                    throw new TaskExternalException(e.getMessage(), (Throwable)e);
                }
                this.cache.ISSTART = isstart;
            }
            if (isstart && isImp) {
                String errMsg = FaResUtil.getRes((String)"assetInitialization", (Locale)ctx.getOriginLocale());
                throw new TaskExternalException(errMsg);
            }
        }
    }

    protected boolean isInitCard() {
        return true;
    }

    class QueryObjCacheInfo {
        public CompanyOrgUnitInfo COMPANY = null;
        public HashMap USEDEPT = new HashMap();
        public HashMap PERSON = new HashMap();
        public Boolean ISSTART = null;
        public Boolean ISCHECKBUSSINESSDATA = null;

        QueryObjCacheInfo() {
        }
    }
}

