/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app.dataimp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.fa.basedata.FaDepreciationModeInfo;
import com.kingdee.eas.fi.fa.basedata.FaResUtil;
import com.kingdee.eas.fi.fa.basedata.FaUtils;
import com.kingdee.eas.fi.fa.manage.FaBakCardFactory;
import com.kingdee.eas.fi.fa.manage.FaBakCardInfo;
import com.kingdee.eas.fi.fa.manage.FaCardInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.FaMonCardFactory;
import com.kingdee.eas.fi.fa.manage.FaMonCardInfo;
import com.kingdee.eas.fi.fa.manage.IFaBakCard;
import com.kingdee.eas.fi.fa.manage.IFaCurCard;
import com.kingdee.eas.fi.fa.manage.app.FaLastPeriodChangeUtils;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.fa.manage.app.dataimp.AbstractFaDataImport;
import com.kingdee.eas.fi.fa.manage.app.dataimp.FaDataImportUtils;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;

public class FaMonEvalTaxDataImport
extends AbstractFaDataImport {
    protected QueryObjCacheInfo cache = new QueryObjCacheInfo();
    private Map<String, QueryObjCacheInfo> cacheMap = new HashMap<String, QueryObjCacheInfo>();
    protected CompanyOrgUnitInfo company;
    private HashMap workloadSchemes = null;
    private String[] EXP_FIELD_IN_FILE = new String[]{"FOrgUnitID", "FNumber", "FEvalReInAccountDate", "FInitEvalValue", "FEvalUseTermCount", "FEvalDeprPeriodNum", "FEvalPeriodLeft", "FEvalDeprModeID", "FEvalMonthRate", "FEvalNeatLeftRate", "FEvalRemValue", "FEvalDecValue", "FEvalAddDepr", "FEvalYearDepr", "FEvalMeasureWL"};
    private String[] EXP_FIELD_IN_QUERY = new String[]{"company.number", "number", "evalReInAccountDate", "evalAssetValue", "evalUseTermCount", "evalDeprPeriodNum", "evalTaxLeftPeriod", "evalDeprMode.number", "evalMonthRate", "evalNeatLeftRate", "evalRemValue", "evalDecValue", "evalAddDepr", "evalYearDepr", "evalMeasureWL.number"};
    protected SelectorItemCollection updateSic = new SelectorItemCollection();

    public FaMonEvalTaxDataImport() {
        this.updateSic.add(new String("evalReInAccountDate"));
        this.updateSic.add(new String("evalDeprPeriodNum"));
        this.updateSic.add(new String("evalDeprMode"));
        this.updateSic.add(new String("evalMonthRate"));
        this.updateSic.add(new String("evalAddDepr"));
        this.updateSic.add(new String("evalRemValue"));
        this.updateSic.add(new String("evalYearDepr"));
        this.updateSic.add(new String("evalDecValue"));
        this.updateSic.add(new String("evalNeatValue"));
        this.updateSic.add(new String("evalNeatAmt"));
        this.updateSic.add(new String("evalAssetValue"));
        this.updateSic.add(new String("evalTaxLeftPeriod"));
        this.updateSic.add(new String("evalMeasureUnitWL"));
        this.updateSic.add(new String("evalUseTermCount"));
        this.updateSic.add(new String("evalDeprTTerm"));
        this.updateSic.add(new String("evalNeatLeftRate"));
    }

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return FaMonCardFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            boolean isLastestPeriod = (Boolean)(this.getContextParameter("card_islastestperiod") == null ? Boolean.TRUE : this.getContextParameter("card_islastestperiod"));
            this.getController(ctx).updatePartial(coreBaseInfo, this.updateSic);
            if (this.isInitCard()) {
                if (coreBaseInfo.get("faCurCard") != null) {
                    IFaCurCard icard = FaCurCardFactory.getLocalInstance(ctx);
                    FaCurCardInfo _card = icard.getFaCurCardInfo("select id where number='" + coreBaseInfo.getString("number") + "' and company.id='" + this.cache.CURRENTCOMP.getId() + "'");
                    FaCurCardInfo newCard = FaManageUtils.MonCard2CurCard((FaMonCardInfo)coreBaseInfo);
                    newCard.setId(_card.getId());
                    icard.updatePartial((CoreBaseInfo)newCard, this.updateSic);
                    if (!isLastestPeriod) {
                        String[] cardIds = new String[]{_card.getId().toString(), coreBaseInfo.getId().toString()};
                        FaLastPeriodChangeUtils.updateMonCardLastPeriodChangeForImoport(ctx, cardIds);
                    }
                }
            } else {
                if (coreBaseInfo.getBoolean("hasNew") && 2 == coreBaseInfo.getInt("checkedStatus")) {
                    IFaBakCard icard = FaBakCardFactory.getLocalInstance(ctx);
                    FaBakCardInfo _card = icard.getFaBakCardInfo("select id where number='" + coreBaseInfo.getString("number") + "' and company.id='" + this.cache.CURRENTCOMP.getId() + "' and billType=1");
                    FaBakCardInfo newCard = FaManageUtils.CurCard2BakCard((FaCurCardInfo)coreBaseInfo);
                    newCard.setId(_card.getId());
                    icard.updatePartial((CoreBaseInfo)newCard, this.updateSic);
                }
                if (!isLastestPeriod) {
                    String cardId = coreBaseInfo.getId().toString();
                    FaLastPeriodChangeUtils.updateCurCardLastPeriodChangeForImport(ctx, cardId);
                }
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
        }
    }

    public CoreBaseInfo transmit(Hashtable data, Context ctx) throws TaskExternalException {
        String companyNumber;
        if (this.workloadSchemes == null) {
            try {
                this.workloadSchemes = FaUtils.getUserDepreciationMode((Context)ctx, (boolean)true);
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
        }
        if ((companyNumber = (String)FaDataImportUtils.getValue(data, "FOrgUnitID")) != null && !"".equals(companyNumber)) {
            if (this.cacheMap.containsKey(companyNumber)) {
                this.cache = this.cacheMap.get(companyNumber);
            } else {
                this.cache = new QueryObjCacheInfo();
                this.cacheMap.put(companyNumber, this.cache);
            }
        } else {
            if (!this.isInitCard()) {
                throw new TaskExternalException(FaResUtil.getRes((String)"fOrgUnitIDIsNull", (Locale)ctx.getOriginLocale()));
            }
            companyNumber = ContextUtil.getCurrentFIUnit((Context)ctx).getNumber();
            this.cache = new QueryObjCacheInfo();
            this.cacheMap.put(companyNumber, this.cache);
        }
        if (this.cache.CURRENTCOMP != null) {
            this.company = this.cache.CURRENTCOMP;
        } else {
            try {
                this.company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("SELECT * , baseCurrency.* WHERE NUMBER ='" + companyNumber + "'");
            }
            catch (Exception e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
            this.cache.CURRENTCOMP = this.company;
        }
        this.verifyBeforeTran(ctx, true);
        String compId = this.company.getId().toString();
        PeriodInfo currenctPeriod = null;
        if (this.cache.CURRENTPERIOD != null) {
            currenctPeriod = this.cache.CURRENTPERIOD;
        } else {
            try {
                this.cache.CURRENTPERIOD = currenctPeriod = FaLocalUtils.getCurrentPeriod(ctx, compId);
                this.cache.LASTPERIOD = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)currenctPeriod);
                this.cache.STARTPERIOD = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)this.company);
            }
            catch (Exception e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
        }
        int baseScale = this.company.getBaseCurrency().getPrecision();
        HashMap params = this.cache.PARAMS;
        if (params == null) {
            ObjectUuidPK pk = new ObjectUuidPK(this.company.getBOSUuid(this.company.getPKField()));
            HashMap<String, ObjectUuidPK> paramKeyMap = new HashMap<String, ObjectUuidPK>();
            paramKeyMap.put("FA_007", pk);
            paramKeyMap.put("FA_037", pk);
            try {
                params = ParamManager.getParamHashMap((Context)ctx, paramKeyMap);
            }
            catch (Exception e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
            this.cache.PARAMS = params;
        }
        int depreScale = params.get("FA_007") == null ? 4 : Integer.parseInt(params.get("FA_007").toString());
        Locale locale = ctx.getOriginLocale();
        String cardNumber = this.getValue(ctx, data, "FNumber", FaResUtil.getRes((String)"cardNumber1", (Locale)locale), false);
        FaCardInfo card = this.getCardInfo(ctx, cardNumber);
        card.setCompany(this.company);
        if (!this.isInitCard()) {
            FaDataImportUtils.checkCardAudit(ctx, card, this.cache.PARAMS);
        }
        FaDataImportUtils.verifyAuditCardForImport(ctx, card, this.getContextParameter(), this.isInitCard());
        FaDataImportUtils.setBigDecimalData(ctx, data, new String[]{"FInitEvalValue", "FEvalRemValue", "FEvalDecValue", "FEvalAddDepr", "FEvalYearDepr"}, new String[]{"evalAssetValue", "evalRemValue", "evalDecValue", "evalAddDepr", "evalYearDepr"}, new String[]{FaResUtil.getRes((String)"evalInfo1", (Locale)locale), FaResUtil.getRes((String)"evalInfo2", (Locale)locale), FaResUtil.getRes((String)"evalInfo3", (Locale)locale), FaResUtil.getRes((String)"evalInfo4", (Locale)locale), FaResUtil.getRes((String)"evalInfo5", (Locale)locale)}, (CoreBaseInfo)card, false, baseScale);
        String deprModeNumber = this.getValue(ctx, data, "FEvalDeprModeID", FaResUtil.getRes((String)"evalInfo12", (Locale)locale), false);
        try {
            if (deprModeNumber.compareTo("008") != 0 && deprModeNumber.compareTo("009") != 0 && !this.isUseTaxCalcDepreciationMode(ctx, deprModeNumber)) {
                throw new TaskExternalException(FaResUtil.getRes((String)"evalInfo6", (Locale)locale));
            }
        }
        catch (SQLException e) {
            throw new TaskExternalException(FaResUtil.getRes((String)"evalInfo6", (Locale)locale), (Throwable)e);
        }
        if (this.cache.DEPRECIATIONMODE.containsKey(deprModeNumber)) {
            card.setEvalDeprMode((FaDepreciationModeInfo)this.cache.DEPRECIATIONMODE.get(deprModeNumber));
        } else {
            FaDepreciationModeInfo _deprMode = FaDataImportUtils.getDeprModeInfo(ctx, "where number = '" + deprModeNumber + "'");
            card.setEvalDeprMode(_deprMode);
            this.cache.DEPRECIATIONMODE.put(deprModeNumber, _deprMode);
        }
        int periodScale = !deprModeNumber.equals("002") && !this.workloadSchemes.containsKey(deprModeNumber) ? 0 : 2;
        FaDataImportUtils.setBigDecimalData(ctx, data, new String[]{"FEvalUseTermCount", "FEvalDeprPeriodNum", "FEvalPeriodLeft"}, new String[]{"evalUseTermCount", "evalDeprPeriodNum", "evalTaxLeftPeriod"}, new String[]{FaResUtil.getRes((String)"evalInfo7", (Locale)locale), FaResUtil.getRes((String)"evalInfo8", (Locale)locale), FaResUtil.getRes((String)"evalInfo9", (Locale)locale)}, (CoreBaseInfo)card, false, periodScale);
        FaDataImportUtils.setBigDecimalData(ctx, data, new String[]{"FEvalNeatLeftRate"}, new String[]{"evalNeatLeftRate"}, new String[]{FaResUtil.getRes((String)"evalInfo10", (Locale)locale)}, (CoreBaseInfo)card, false, 2);
        FaDataImportUtils.setDateTimeData(ctx, data, new String[]{"FEvalReInAccountDate"}, new String[]{"evalReInAccountDate"}, new String[]{FaResUtil.getRes((String)"evalInfo11", (Locale)locale)}, (CoreBaseInfo)card);
        String measureWLNum = this.getValue(ctx, data, "FEvalMeasureWL", FaResUtil.getRes((String)"evalInfo13", (Locale)locale), true);
        if (measureWLNum != null && measureWLNum.trim().length() > 0) {
            if (this.cache.MEASUREUNIT.containsKey(measureWLNum)) {
                card.setEvalMeasureUnitWL((MeasureUnitInfo)this.cache.MEASUREUNIT.get(measureWLNum));
            } else {
                MeasureUnitInfo _measureunit = FaDataImportUtils.getMeasureUnitInfo(ctx, "select id where number='" + measureWLNum + "'");
                card.setEvalMeasureUnitWL(_measureunit);
                this.cache.MEASUREUNIT.put(measureWLNum, _measureunit);
            }
        }
        if (deprModeNumber.compareTo("008") == 0) {
            FaDataImportUtils.setBigDecimalData(ctx, data, new String[]{"FEvalMonthRate"}, new String[]{"evalMonthRate"}, new String[]{FaResUtil.getRes((String)"evalInfo14", (Locale)locale)}, (CoreBaseInfo)card, false, depreScale);
        } else {
            card.setEvalMonthRate(null);
        }
        if (card.getEvalReInAccountDate() == null) {
            throw new TaskExternalException(FaResUtil.getRes((String)"evalInfo15", (Locale)locale));
        }
        if (card.getEvalReInAccountDate().after(currenctPeriod.getEndDate())) {
            throw new TaskExternalException(FaResUtil.getRes((String)"evalInfo16", (Locale)locale));
        }
        if (card.getEvalAddDepr().compareTo(card.getEvalAssetValue()) > 0) {
            throw new TaskExternalException(FaResUtil.getRes((String)"evalInfo17", (Locale)locale));
        }
        if (card.getEvalAddDepr().add(card.getEvalDecValue()).compareTo(card.getEvalAssetValue()) > 0) {
            throw new TaskExternalException(FaResUtil.getRes((String)"evalInfo18", (Locale)locale));
        }
        if (card.getEvalAddDepr().compareTo(card.getEvalYearDepr()) < 0) {
            throw new TaskExternalException(FaResUtil.getRes((String)"evalInfo19", (Locale)locale));
        }
        if (card.getEvalNeatLeftRate().compareTo(new BigDecimal("100")) > 0) {
            throw new TaskExternalException(FaResUtil.getRes((String)"evalInfo20", (Locale)locale));
        }
        if (card.getEvalMonthRate() != null && card.getEvalMonthRate().compareTo(new BigDecimal("100")) > 0) {
            throw new TaskExternalException(FaResUtil.getRes((String)"evalInfo21", (Locale)locale));
        }
        if (card.getEvalDeprMode().isIsWorkload() && card.getEvalMeasureUnitWL() == null) {
            throw new TaskExternalException(FaResUtil.getRes((String)"evalInfo22", (Locale)locale));
        }
        if (card.getEvalDeprMode() != null && card.getDeprMethod() != null) {
            FaDepreciationModeInfo deprMode = card.getDeprMethod();
            FaDepreciationModeInfo evalDeprMode = card.getEvalDeprMode();
            if (FaManageUtils.isWorkLoadMethod((FaDepreciationModeInfo)deprMode) && !FaManageUtils.isWorkLoadMethod((FaDepreciationModeInfo)evalDeprMode) || FaManageUtils.isWorkLoadMethod((FaDepreciationModeInfo)evalDeprMode) && !FaManageUtils.isWorkLoadMethod((FaDepreciationModeInfo)deprMode)) {
                throw new TaskExternalException(FaResUtil.getRes((String)"evalInfo28", (Locale)locale));
            }
        }
        if (card.getEvalDeprMode() != null && card.getDeprMethod() == null || card.getEvalDeprMode() == null && card.getDeprMethod() != null) {
            throw new TaskExternalException(FaResUtil.getRes((String)"evalInfo29", (Locale)locale));
        }
        if (!card.getEvalDeprMode().isIsWorkload()) {
            card.setEvalMeasureUnitWL(null);
        }
        card.setEvalDeprTTerm(new BigDecimal("0"));
        card.setEvalNeatValue(card.getEvalAssetValue().subtract(card.getEvalAddDepr()));
        card.setEvalNeatAmt(card.getEvalNeatValue().subtract(card.getEvalDecValue()));
        return card;
    }

    protected FaCardInfo getCardInfo(Context ctx, String cardNumber) throws TaskExternalException {
        String companyId = this.company.getId().toString();
        try {
            CoreBaseCollection result = this.getController(ctx).getCollection("select id,faCurCard.id,number,evalAssetValue,hasNew,lastBillID,bizStatus,checkedStatus,deprMethod.* where number='" + cardNumber + "' and company.id='" + companyId + "'");
            if (result.size() == 0) {
                throw new TaskExternalException(MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"62_FaMonDefPropertyDataImport", (Locale)ctx.getOriginLocale()), cardNumber, this.isInitCard() ? ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"64_FaMonDefPropertyDataImport", (Locale)ctx.getOriginLocale()) : ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"65_FaMonDefPropertyDataImport", (Locale)ctx.getOriginLocale())));
            }
            FaCardInfo card = (FaCardInfo)result.get(0);
            if (!this.isSltImportUpdate() && card.getEvalAssetValue() != null) {
                throw new TaskExternalException(FaResUtil.getRes((String)"evalInfo23", (Locale)ctx.getOriginLocale()));
            }
            return card;
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    protected boolean isUseTaxCalcDepreciationMode(Context ctx, String fModeNumber) throws TaskExternalException, SQLException {
        String companyId = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        try {
            String sql = "select fnumber from T_FA_DepreciationMode where FIsUseTaxCalc=1";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rowSet.next()) {
                for (int i = 0; i < rowSet.size(); ++i) {
                    String fNumber = rowSet.getString(1);
                    if (fModeNumber.equals(fNumber)) {
                        return true;
                    }
                    rowSet.next();
                }
            }
            return false;
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    protected String getValue(Context ctx, Map data, String fieldName, String fieldCHN, boolean supportNull) throws TaskExternalException {
        String result;
        if (data.get(fieldName) == null && !supportNull) {
            throw new TaskExternalException(MessageFormat.format(FaResUtil.getRes((String)"columnCanNotNull", (Locale)ctx.getOriginLocale()), fieldCHN));
        }
        String string = result = data.get(fieldName) == null ? null : data.get(fieldName).toString();
        if (StringUtils.isEmpty((String)result) && !supportNull) {
            throw new TaskExternalException(MessageFormat.format(FaResUtil.getRes((String)"columnCanNotNull", (Locale)ctx.getOriginLocale()), fieldCHN));
        }
        return result;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = null;
        try {
            int depreScale;
            HashMap params;
            String deprModeNumber;
            if (this.workloadSchemes == null) {
                this.workloadSchemes = FaUtils.getUserDepreciationMode((Context)ctx, (boolean)true);
            }
            String compId = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
            String number = ContextUtil.getCurrentFIUnit((Context)ctx).getNumber();
            if (this.cacheMap.containsKey(number)) {
                this.cache = this.cacheMap.get(number);
            } else {
                this.cache = new QueryObjCacheInfo();
                this.cacheMap.put(number, this.cache);
            }
            if (this.cache.CURRENTCOMP != null) {
                this.company = this.cache.CURRENTCOMP;
            } else {
                try {
                    this.company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("SELECT * , baseCurrency.* WHERE id ='" + compId + "'");
                }
                catch (Exception e) {
                    throw new TaskExternalException(e.getMessage(), (Throwable)e);
                }
                this.cache.CURRENTCOMP = this.company;
            }
            this.verifyBeforeTran(ctx, false);
            CurrencyInfo baseCurrency = this.company.getBaseCurrency();
            HashMap<String, Integer> precisions = new HashMap<String, Integer>();
            precisions.put("baseScale", new Integer(baseCurrency.getPrecision()));
            try {
                result = this.isInitCard() ? FaDataImportUtils.setDataForExport(Arrays.copyOfRange(this.EXP_FIELD_IN_FILE, 1, this.EXP_FIELD_IN_FILE.length), Arrays.copyOfRange(this.EXP_FIELD_IN_QUERY, 1, this.EXP_FIELD_IN_QUERY.length), rs, precisions) : FaDataImportUtils.setDataForExport(this.EXP_FIELD_IN_FILE, this.EXP_FIELD_IN_QUERY, rs, precisions);
            }
            catch (Exception e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
            String string = deprModeNumber = result.get("FEvalDeprModeID") == null ? null : result.get("FEvalDeprModeID").toString();
            if (deprModeNumber != null && !deprModeNumber.equals("002") && !this.workloadSchemes.containsKey(deprModeNumber)) {
                if (result.get("FEvalDeprPeriodNum") != null) {
                    result.put("FEvalDeprPeriodNum", rs.getBigDecimal("evalDeprPeriodNum").setScale(0, 4).toString());
                }
                if (result.get("FEvalUseTermCount") != null) {
                    result.put("FEvalUseTermCount", rs.getBigDecimal("evalUseTermCount").setScale(0, 4).toString());
                }
                if (result.get("FEvalPeriodLeft") != null) {
                    result.put("FEvalPeriodLeft", rs.getBigDecimal("evalTaxLeftPeriod").setScale(0, 4).toString());
                }
            }
            if (result.get("FEvalNeatLeftRate") != null) {
                result.put("FEvalNeatLeftRate", rs.getBigDecimal("evalNeatLeftRate").setScale(2, 4).toString());
            }
            if ((params = this.cache.PARAMS) == null) {
                ObjectUuidPK pk = new ObjectUuidPK(this.company.getBOSUuid(this.company.getPKField()));
                HashMap<String, ObjectUuidPK> paramKeyMap = new HashMap<String, ObjectUuidPK>();
                paramKeyMap.put("FA_007", pk);
                this.cache.PARAMS = params = ParamManager.getParamHashMap((Context)ctx, paramKeyMap);
            }
            int n = depreScale = params.get("FA_007") == null ? 4 : Integer.parseInt(params.get("FA_007").toString());
            if (result.get("FEvalMonthRate") != null) {
                result.put("FEvalMonthRate", rs.getBigDecimal("evalMonthRate").setScale(depreScale, 4).toString());
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    protected void verifyBeforeTran(Context ctx, boolean isImp) throws TaskExternalException {
        CompanyOrgUnitInfo _comp = this.company;
        if (_comp == null) {
            String strMsg = ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.Company_Null", (Locale)ctx.getOriginLocale());
            throw new TaskExternalException(strMsg);
        }
        if (!_comp.isIsBizUnit()) {
            String strMsg = ResourceBase.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource.vitualComNotAllowUseThisFun", (Locale)ctx.getOriginLocale());
            throw new TaskExternalException(strMsg);
        }
        if (this.isInitCard()) {
            boolean isstart = false;
            if (this.cache.ISSTART != null) {
                isstart = this.cache.ISSTART;
            } else {
                try {
                    isstart = SystemStatusCtrolUtils.isStart((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)_comp);
                }
                catch (Exception e) {
                    throw new TaskExternalException(e.getMessage(), (Throwable)e);
                }
                this.cache.ISSTART = isstart;
            }
            if (isstart && isImp) {
                String errMsg = FaResUtil.getRes((String)"assetInitialization", (Locale)ctx.getOriginLocale());
                throw new TaskExternalException(errMsg);
            }
        }
    }

    protected boolean isInitCard() {
        return true;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        return FaDataImportUtils.getFilterForExp(ctx, super.getExportFilterForQuery(ctx), true);
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.fi.fa.manage.FaMonCardExpQuery";
    }

    class QueryObjCacheInfo {
        public HashMap DEPRECIATIONMODE = new HashMap();
        public HashMap MEASUREUNIT = new HashMap();
        public HashMap PARAMS = null;
        public PeriodInfo CURRENTPERIOD = null;
        public PeriodInfo LASTPERIOD = null;
        public PeriodInfo STARTPERIOD = null;
        public Boolean ISSTART = null;
        public CompanyOrgUnitInfo CURRENTCOMP = null;

        QueryObjCacheInfo() {
        }
    }
}

