/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app.dataimp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.assistant.AddressInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.fi.fa.basedata.FaResUtil;
import com.kingdee.eas.fi.fa.manage.FaCardInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaCurFacilityFactory;
import com.kingdee.eas.fi.fa.manage.FaCurFacilityInfo;
import com.kingdee.eas.fi.fa.manage.FaFacilityInfo;
import com.kingdee.eas.fi.fa.manage.FaMonCardInfo;
import com.kingdee.eas.fi.fa.manage.FaMonFacilityFactory;
import com.kingdee.eas.fi.fa.manage.FaMonFacilityInfo;
import com.kingdee.eas.fi.fa.manage.IFaMonFacility;
import com.kingdee.eas.fi.fa.manage.app.dataimp.AbstractFaDataImport;
import com.kingdee.eas.fi.fa.manage.app.dataimp.FaDataImportUtils;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;

public class FaMonFacilityDataImport
extends AbstractFaDataImport {
    protected FaCardInfo card;
    private String cu;
    protected CompanyOrgUnitInfo company;
    protected String cardNumber;
    private String[] EXP_FIELD_IN_FILE = new String[]{"FOrgUnitID", "FFaCardID", "FFacilityId", "FFacilityName", "FfacilityModel", "FRegisterDate", "FStorePlaceID", "FMeasureUnitID", "FQuantity", "FAmount", "FKeeperID", "Fremark", "FCreatorNumber", "FCreateTime"};
    private String[] EXP_FIELD_IN_QUERY = new String[]{"company.number", "number", "facility.facilityNumber", "facility.facilityName", "facility.facilityModel", "facility.registerDate", "storePlace.number", "measureUnit1.number", "facility.quantity", "facility.amount", "keeper1.number", "facility.remark", "creator.number", "createTime"};
    private QueryObjCacheInfo cache = new QueryObjCacheInfo();
    private Map<String, QueryObjCacheInfo> cacheMap = new HashMap<String, QueryObjCacheInfo>();

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return FaMonFacilityFactory.getLocalInstance(ctx);
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        block5: {
            try {
                if (this.card instanceof FaMonCardInfo) {
                    FaMonFacilityInfo monFacilityInfo = new FaMonFacilityInfo();
                    FaDataImportUtils.cloneObjectInfo(coreBaseInfo, (CoreBaseInfo)monFacilityInfo);
                    FaMonCardInfo monCard = (FaMonCardInfo)this.card;
                    monFacilityInfo.setFaMonCard(monCard);
                    monFacilityInfo.setFaMonCard(monCard);
                    IFaMonFacility ifacility = FaMonFacilityFactory.getLocalInstance(ctx);
                    if (this.isSltImportUpdate()) {
                        ifacility.delete("where faMonCard.id='" + monCard.getId() + "' and facilityNumber='" + coreBaseInfo.getString("facilityNumber") + "'");
                    }
                    ifacility.submit((CoreBaseInfo)monFacilityInfo);
                    if (monCard.getFaCurCard() != null) {
                        this.submitCurFacilityInfo(coreBaseInfo, ctx, monCard.getFaCurCard());
                    }
                    break block5;
                }
                throw new TaskExternalException("card type not matched");
            }
            catch (Exception ex) {
                throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    protected void submitCurFacilityInfo(CoreBaseInfo coreBaseInfo, Context ctx, FaCurCardInfo curCardInfo) throws Exception {
        FaCurFacilityInfo curFacilityInfo = new FaCurFacilityInfo();
        FaDataImportUtils.cloneObjectInfo(coreBaseInfo, (CoreBaseInfo)curFacilityInfo);
        curFacilityInfo.setFaCurCard(curCardInfo);
        if (this.isSltImportUpdate()) {
            FaCurFacilityFactory.getLocalInstance(ctx).delete("where faCurCard.id='" + curCardInfo.getId() + "' and facilityNumber = '" + coreBaseInfo.getString("facilityNumber") + "'");
        }
        FaCurFacilityFactory.getLocalInstance(ctx).submit((CoreBaseInfo)curFacilityInfo);
    }

    public CoreBaseInfo transmit(Hashtable data, Context ctx) throws TaskExternalException {
        Locale locale = ctx.getOriginLocale();
        String companyNumber = (String)FaDataImportUtils.getValue(data, "FOrgUnitID");
        if (companyNumber != null && !"".equals(companyNumber)) {
            if (this.cacheMap.containsKey(companyNumber)) {
                this.cache = this.cacheMap.get(companyNumber);
            } else {
                this.cache = new QueryObjCacheInfo();
                this.cacheMap.put(companyNumber, this.cache);
            }
        } else {
            if (!this.isInitCard()) {
                throw new TaskExternalException(FaResUtil.getRes((String)"fOrgUnitIDIsNull", (Locale)ctx.getOriginLocale()));
            }
            companyNumber = ContextUtil.getCurrentFIUnit((Context)ctx).getNumber();
            this.cache = new QueryObjCacheInfo();
            this.cacheMap.put(companyNumber, this.cache);
        }
        if (this.cache.CURRENTCOMP != null) {
            this.company = this.cache.CURRENTCOMP;
        } else {
            try {
                this.company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("SELECT * , baseCurrency.* WHERE NUMBER ='" + companyNumber + "'");
            }
            catch (Exception e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
            this.cache.CURRENTCOMP = this.company;
        }
        this.verifyBeforeTran(ctx, true);
        this.cu = this.company.getCU().getId().toString();
        String compId = this.company.getId().toString();
        this.cardNumber = this.getValue(ctx, data, "FFaCardID", FaResUtil.getRes((String)"cardNumber1", (Locale)locale), false);
        this.card = this.getCard(ctx);
        this.card.setCompany(this.company);
        HashMap params = this.cache.PARAMS;
        if (params == null) {
            ObjectUuidPK pk = new ObjectUuidPK(compId);
            HashMap<String, ObjectUuidPK> paramKeyMap = new HashMap<String, ObjectUuidPK>();
            paramKeyMap.put("FA_037", pk);
            try {
                params = ParamManager.getParamHashMap((Context)ctx, paramKeyMap);
            }
            catch (Exception e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
            this.cache.PARAMS = params;
        }
        if (!this.isInitCard()) {
            FaDataImportUtils.checkCardAudit(ctx, this.card, this.cache.PARAMS);
        }
        FaDataImportUtils.verifyForLastestPeriod(ctx, this.card, this.getContextParameter(), this.isInitCard());
        FaFacilityInfo info = new FaFacilityInfo();
        FaDataImportUtils.setStringData(ctx, data, new String[]{"FFacilityName", "FFacilityId"}, new String[]{"facilityName", "facilityNumber"}, new String[]{FaResUtil.getRes((String)"facilityName1", (Locale)locale), FaResUtil.getRes((String)"facilityNumber", (Locale)locale)}, (CoreBaseInfo)info, false, null);
        FaDataImportUtils.setStringData(ctx, data, new String[]{"FfacilityModel", "Fremark"}, new String[]{"facilityModel", "remark"}, new String[]{FaResUtil.getRes((String)"type", (Locale)locale), FaResUtil.getRes((String)"remark", (Locale)locale)}, (CoreBaseInfo)info);
        FaDataImportUtils.setDateTimeData(ctx, data, new String[]{"FRegisterDate"}, new String[]{"registerDate"}, new String[]{FaResUtil.getRes((String)"registerDate", (Locale)locale)}, (CoreBaseInfo)info);
        FaDataImportUtils.setBigDecimalData(ctx, data, new String[]{"FQuantity"}, new String[]{"quantity"}, new String[]{FaResUtil.getRes((String)"quantity", (Locale)locale)}, (CoreBaseInfo)info, false, 2);
        FaDataImportUtils.setBigDecimalData(ctx, data, new String[]{"FAmount"}, new String[]{"amount"}, new String[]{FaResUtil.getRes((String)"amount", (Locale)locale)}, (CoreBaseInfo)info, false, this.company.getBaseCurrency().getPrecision());
        String addressNum = this.getValue(ctx, data, "FStorePlaceID", FaResUtil.getRes((String)"storePlace", (Locale)locale), true);
        if (this.cache.ADDRESS.containsKey(addressNum)) {
            info.setStorePlace((AddressInfo)this.cache.ADDRESS.get(addressNum));
        } else {
            AddressInfo _address = FaDataImportUtils.getAddressInfo(ctx, this.company.getCU().getId().toString(), addressNum);
            info.setStorePlace(_address);
            this.cache.ADDRESS.put(addressNum, _address);
        }
        String measureNum = this.getValue(ctx, data, "FMeasureUnitID", FaResUtil.getRes((String)"measureUnitNumber", (Locale)locale), true);
        if (this.cache.MEASUREUNIT.containsKey(measureNum)) {
            info.setMeasureUnit((MeasureUnitInfo)this.cache.MEASUREUNIT.get(measureNum));
        } else {
            MeasureUnitInfo _measure = FaDataImportUtils.getMeasureUnitInfo(ctx, this.getBaseDataOql(measureNum, false, false));
            info.setMeasureUnit(_measure);
            this.cache.MEASUREUNIT.put(measureNum, _measure);
        }
        String personNum = this.getValue(ctx, data, "FKeeperID", FaResUtil.getRes((String)"storePersonNumber", (Locale)locale), true);
        if (this.cache.PERSON.containsKey(personNum)) {
            info.setKeeper((PersonInfo)this.cache.PERSON.get(personNum));
        } else {
            PersonInfo _person = FaDataImportUtils.getPersonInfo(ctx, this.cu, personNum);
            info.setKeeper(_person);
            this.cache.PERSON.put(personNum, _person);
        }
        this.verfyNumber(ctx, info);
        info.setSeq(this.getSeq(ctx));
        return info;
    }

    private void verifyCardForOverride(Context ctx, FaCurCardInfo card) throws TaskExternalException {
        if (!this.isInitCard() && card.getEffectedStatus().getValue() != 1) {
            throw new TaskExternalException(FaResUtil.getRes((String)"tempCardCanOverride2", (Locale)ctx.getOriginLocale()));
        }
    }

    private void verfyNumber(Context ctx, FaFacilityInfo info) throws TaskExternalException {
        block5: {
            boolean isOverride = this.isSltImportUpdate();
            FilterInfo filter = new FilterInfo();
            FilterItemCollection filterItems = filter.getFilterItems();
            filterItems.add(new FilterItemInfo("facilityNumber", (Object)info.getFacilityNumber()));
            if (this.isInitCard()) {
                filter.getFilterItems().add(new FilterItemInfo("faMonCard.id", (Object)this.card.getId().toString()));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("faCurCard.id", (Object)this.card.getId().toString()));
            }
            EntityViewInfo v = new EntityViewInfo();
            v.setFilter(filter);
            try {
                CoreBaseCollection facilities = this.getController(ctx).getCollection(v);
                if (facilities.size() <= 0) break block5;
                if (isOverride) {
                    info.setId(facilities.get(0).getId());
                    break block5;
                }
                throw new TaskExternalException(FaResUtil.getRes((String)"evalInfo23", (Locale)ctx.getOriginLocale()));
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
        }
    }

    private String getValue(Context ctx, Map data, String fieldName, String fieldCHN, boolean supportNull) throws TaskExternalException {
        String result;
        Object obj = null;
        obj = data.get(fieldName) == null ? null : ((DataToken)data.get((Object)fieldName)).data;
        String string = result = obj == null ? null : obj.toString();
        if (StringUtils.isEmpty((String)result) && !supportNull) {
            throw new TaskExternalException(MessageFormat.format(FaResUtil.getRes((String)"columnCanNotNull", (Locale)ctx.getOriginLocale()), fieldCHN));
        }
        return result;
    }

    private String getBaseDataOql(String number, boolean getAll, boolean isCuIsoluate) {
        if (StringUtils.isEmpty((String)number)) {
            return null;
        }
        if (getAll) {
            if (isCuIsoluate) {
                return "WHERE NUMBER = '" + number + "' AND CU.id = '" + this.cu + "'";
            }
            return "WHERE NUMBER = '" + number + "'";
        }
        if (isCuIsoluate) {
            return "SELECT ID WHERE NUMBER = '" + number + "' AND CU.id = '" + this.cu + "'";
        }
        return "SELECT ID WHERE NUMBER = '" + number + "'";
    }

    protected FaCardInfo getCard(Context ctx) throws TaskExternalException {
        return FaDataImportUtils.getFaMonCardInfo(ctx, "SELECT id,effectedStatus,checkedStatus,company.*, faCurCard.id WHERE  originFlag = 0 and ISINITIAL = 1 and  NUMBER = '" + this.cardNumber + "' AND company.id ='" + this.company.getId() + "'");
    }

    protected int getSeq(Context ctx) throws TaskExternalException {
        return FaDataImportUtils.getSeq(ctx, this.card.getId().toString(), "t_fa_faMonfacility", true);
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        try {
            String compId = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
            String number = ContextUtil.getCurrentFIUnit((Context)ctx).getNumber();
            if (this.cacheMap.containsKey(number)) {
                this.cache = this.cacheMap.get(number);
            } else {
                this.cache = new QueryObjCacheInfo();
                this.cacheMap.put(number, this.cache);
            }
            if (this.cache.CURRENTCOMP != null) {
                this.company = this.cache.CURRENTCOMP;
            } else {
                try {
                    this.company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("SELECT * , baseCurrency.* WHERE id ='" + compId + "'");
                }
                catch (Exception e) {
                    throw new TaskExternalException(e.getMessage(), (Throwable)e);
                }
                this.cache.CURRENTCOMP = this.company;
            }
            this.verifyBeforeTran(ctx, false);
            int baseScale = this.company.getBaseCurrency().getPrecision();
            int quantityScale = 2;
            HashMap<String, Integer> precisions = new HashMap<String, Integer>();
            precisions.put("baseScale", new Integer(baseScale));
            precisions.put("quantityScale", new Integer(quantityScale));
            Hashtable result = null;
            result = this.isInitCard() ? FaDataImportUtils.setDataForExport(Arrays.copyOfRange(this.EXP_FIELD_IN_FILE, 1, this.EXP_FIELD_IN_FILE.length), Arrays.copyOfRange(this.EXP_FIELD_IN_QUERY, 1, this.EXP_FIELD_IN_QUERY.length), rs, precisions) : FaDataImportUtils.setDataForExport(this.EXP_FIELD_IN_FILE, this.EXP_FIELD_IN_QUERY, rs, precisions);
            if (rs.getString("facility.id") == null || rs.getString("facility.id").trim().length() == 0) {
                return result;
            }
            return result;
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        return FaDataImportUtils.getFilterForExp(ctx, super.getExportFilterForQuery(ctx), true);
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.fi.fa.manage.FaMonCardFacilityExpQuery";
    }

    protected void verifyBeforeTran(Context ctx, boolean isImp) throws TaskExternalException {
        CompanyOrgUnitInfo _comp = this.company;
        if (_comp == null) {
            String strMsg = ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.Company_Null", (Locale)ctx.getOriginLocale());
            throw new TaskExternalException(strMsg);
        }
        if (!_comp.isIsBizUnit()) {
            String strMsg = ResourceBase.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource.vitualComNotAllowUseThisFun", (Locale)ctx.getOriginLocale());
            throw new TaskExternalException(strMsg);
        }
        if (this.isInitCard()) {
            boolean isstart = false;
            if (this.cache.ISSTART != null) {
                isstart = this.cache.ISSTART;
            } else {
                try {
                    isstart = SystemStatusCtrolUtils.isStart((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)this.company);
                }
                catch (Exception e) {
                    throw new TaskExternalException(e.getMessage(), (Throwable)e);
                }
                this.cache.ISSTART = isstart;
            }
            if (isstart && isImp) {
                String errMsg = FaResUtil.getRes((String)"assetInitialization", (Locale)ctx.getOriginLocale());
                throw new TaskExternalException(errMsg);
            }
        }
    }

    protected boolean isInitCard() {
        return true;
    }

    class QueryObjCacheInfo {
        public CompanyOrgUnitInfo CURRENTCOMP = null;
        public HashMap ADDRESS = new HashMap();
        public HashMap MEASUREUNIT = new HashMap();
        public HashMap PERSON = new HashMap();
        public Integer QUANTITYSCALE = null;
        public Boolean ISSTART = null;
        public HashMap PARAMS = null;

        QueryObjCacheInfo() {
        }
    }
}

