/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app.dataimp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.basedata.FaResUtil;
import com.kingdee.eas.fi.fa.manage.FaAccountBalanceFactory;
import com.kingdee.eas.fi.fa.manage.FaAccountBalanceInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaCurInitDataCollection;
import com.kingdee.eas.fi.fa.manage.FaCurInitDataFactory;
import com.kingdee.eas.fi.fa.manage.FaCurInitDataInfo;
import com.kingdee.eas.fi.fa.manage.FaInitDataInfo;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.FaMonCardInfo;
import com.kingdee.eas.fi.fa.manage.FaMonInitDataFactory;
import com.kingdee.eas.fi.fa.manage.FaMonInitDataInfo;
import com.kingdee.eas.fi.fa.manage.IFaAccountBalance;
import com.kingdee.eas.fi.fa.manage.IFaCurInitData;
import com.kingdee.eas.fi.fa.manage.IFaMonInitData;
import com.kingdee.eas.fi.fa.manage.app.FaLastPeriodChangeUtils;
import com.kingdee.eas.fi.fa.manage.app.dataimp.AbstractFaDataImport;
import com.kingdee.eas.fi.fa.manage.app.dataimp.FaDataImportUtils;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;

public class FaMonInitDataImport
extends AbstractFaDataImport {
    private FaCurCardInfo card;
    private FaMonCardInfo monCard;
    private String cardNumber;
    private int baseScale = 10;
    private int quantityScale = 0;
    private String[] EXP_FIELD_IN_FILE = new String[]{"FFaCardID", "FOriginBeginQty", "FOriginIncQty", "FOriginDecQty", "FDeprBeginQty", "FDeprIncQty", "FDeprDecQty", "FDecValueBeginQty", "FDecValueIncQty", "FDecValueDecQty", "FAssetAmtBeginQty", "FAssetAmtIncQty", "FAssetAmtDecQty", "FCreatorNumber", "FCreateTime"};
    private String[] EXP_FIELD_IN_QUERY = new String[]{"number", "initdata.originBeginQty", "initdata.originIncQty", "initdata.originDecQty", "initdata.deprBeginQty", "initdata.deprIncQty", "initdata.deprDecQty", "initdata.decValueBeginQty", "initdata.decValueIncQty", "initdata.decValueDecQty", "initdata.assetAmtBeginQty", "initdata.assetAmtIncQty", "initdata.assetAmtDecQty", "creator.number", "createTime"};
    private QueryObjCacheInfo cache = new QueryObjCacheInfo();

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        return null;
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            FaCurInitDataInfo curInitDataInfo = new FaCurInitDataInfo();
            FaDataImportUtils.cloneObjectInfo(coreBaseInfo, curInitDataInfo);
            curInitDataInfo.setFaCurCard(this.card);
            FaInitDataInfo curInitData = this.getCurInitDataInfo(ctx);
            if (curInitData.getId() != null) {
                curInitDataInfo.setId(curInitData.getId());
                FaCurInitDataFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(curInitDataInfo.getId()), curInitDataInfo);
            } else {
                FaCurInitDataFactory.getLocalInstance(ctx).addnew(curInitDataInfo);
            }
            FaMonInitDataInfo monInitDataInfo = new FaMonInitDataInfo();
            FaDataImportUtils.cloneObjectInfo(coreBaseInfo, monInitDataInfo);
            monInitDataInfo.setFaMonCard(this.monCard);
            FaMonInitDataFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(monInitDataInfo.getId()), monInitDataInfo);
            this.submitBalance(ctx);
            boolean isLastestPeriod = (Boolean)this.getContextParameter("card_islastestperiod");
            if (!isLastestPeriod) {
                String[] cardIds = new String[]{this.card.getId().toString(), this.monCard.getId().toString()};
                FaLastPeriodChangeUtils.updateMonCardLastPeriodChangeForImoport(ctx, cardIds);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
        }
    }

    public CoreBaseInfo transmit(Hashtable data, Context ctx) throws TaskExternalException {
        this.verifyBeforeTran(ctx);
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        boolean isstart = false;
        if (this.cache.ISSTART != null) {
            isstart = this.cache.ISSTART;
        } else {
            try {
                isstart = SystemStatusCtrolUtils.isStart((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)company);
            }
            catch (Exception e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
            this.cache.ISSTART = isstart;
        }
        if (isstart) {
            String errMsg = FaResUtil.getRes((String)"assetInitialization", (Locale)ctx.getOriginLocale());
            throw new TaskExternalException(errMsg);
        }
        boolean isfirstperiod = false;
        if (this.cache.ISFIRSTPERIOD != null) {
            isfirstperiod = this.cache.ISFIRSTPERIOD;
        } else {
            try {
                isfirstperiod = this.isFirstPeriod(ctx, company);
            }
            catch (Exception e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
            this.cache.ISFIRSTPERIOD = isfirstperiod;
        }
        if (isfirstperiod) {
            String errMsg = FaResUtil.getRes((String)"cannotInput", (Locale)ctx.getOriginLocale());
            throw new TaskExternalException(errMsg);
        }
        Locale locale = ctx.getOriginLocale();
        if (this.cache.CURRENTCOMP != null) {
            company = this.cache.CURRENTCOMP;
        } else {
            try {
                company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("SELECT * , baseCurrency.* WHERE id ='" + company.getId() + "'");
            }
            catch (Exception e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
            this.cache.CURRENTCOMP = company;
        }
        this.cardNumber = this.getValue(ctx, data, "FFaCardID", FaResUtil.getRes((String)"cardNumber1", (Locale)locale), false);
        this.card = FaDataImportUtils.getFaCurCardInfo(ctx, "SELECT id,assetValue,accuDepr,accuDeprTYear,decValue,assetAmt,company.baseCurrency.precision,company.id,creator.id,lastUpdateUser.id,faCurInitData.*,isEvaledBefore WHERE NUMBER = '" + this.cardNumber + "' AND company.id ='" + company.getId() + "'");
        this.monCard = FaDataImportUtils.getFaMonCardInfo(ctx, "SELECT ID WHERE NUMBER = '" + this.cardNumber + "' AND company.id ='" + company.getId() + "'");
        FaDataImportUtils.verifyForLastestPeriod(ctx, this.card, this.getContextParameter(), true);
        this.initScale(ctx, company);
        FaInitDataInfo info = this.getMonInitDataInfo(ctx);
        FaDataImportUtils.setBigDecimalData(ctx, data, new String[]{"FOriginBeginQty", "FOriginIncQty", "FOriginDecQty"}, new String[]{"originBeginQty", "originIncQty", "originDecQty"}, new String[]{FaResUtil.getRes((String)"OriginBeginQty", (Locale)locale), FaResUtil.getRes((String)"OriginIncQty", (Locale)locale), FaResUtil.getRes((String)"OriginDecQty", (Locale)locale)}, info, false, true, this.baseScale);
        BigDecimal assetValue = this.card.getAssetValue().setScale(this.baseScale, 4);
        BigDecimal initYearData = assetValue.subtract(info.getOriginIncQty()).add(info.getOriginDecQty()).setScale(this.baseScale, 4);
        if (initYearData.compareTo(info.getOriginBeginQty()) != 0) {
            throw new TaskExternalException(FaResUtil.getRes((String)"startYearoriginValue", (Locale)locale) + "= " + FaResUtil.getRes((String)"passEntriesCardOrigin", (Locale)locale) + "+" + FaResUtil.getRes((String)"yearAllocateDeAmount", (Locale)locale) + info.getOriginBeginQty() + " != " + assetValue + "-" + info.getOriginIncQty() + "+" + info.getOriginDecQty());
        }
        FaDataImportUtils.setBigDecimalData(ctx, data, new String[]{"FDeprBeginQty", "FDeprIncQty", "FDeprDecQty"}, new String[]{"deprBeginQty", "deprIncQty", "deprDecQty"}, new String[]{FaResUtil.getRes((String)"DeprBeginQty", (Locale)locale), FaResUtil.getRes((String)"DeprIncQty", (Locale)locale), FaResUtil.getRes((String)"DeprDecQty", (Locale)locale)}, info, false, true, this.baseScale);
        BigDecimal accuDepr = this.card.getAccuDepr().setScale(this.baseScale, 4);
        BigDecimal accuDeprTYear = this.card.getAccuDeprTYear().setScale(this.baseScale, 4);
        initYearData = accuDepr.subtract(accuDeprTYear).subtract(info.getDeprIncQty()).add(info.getDeprDecQty()).setScale(this.baseScale, 4);
        if (initYearData.compareTo(info.getDeprBeginQty()) != 0) {
            throw new TaskExternalException(FaResUtil.getRes((String)"startYearDpr", (Locale)locale) + "= " + FaResUtil.getRes((String)"passEntriesCardTotalDpr", (Locale)locale) + "+" + FaResUtil.getRes((String)"yearAllocateDeAmount", (Locale)locale) + info.getDeprBeginQty() + " != " + accuDepr + "-" + accuDeprTYear + "-" + info.getDeprIncQty() + "+" + info.getDeprDecQty());
        }
        FaDataImportUtils.setBigDecimalData(ctx, data, new String[]{"FDecValueBeginQty", "FDecValueIncQty", "FDecValueDecQty"}, new String[]{"decValueBeginQty", "decValueIncQty", "decValueDecQty"}, new String[]{FaResUtil.getRes((String)"DecValueBeginQty", (Locale)locale), FaResUtil.getRes((String)"DecValueIncQty", (Locale)locale), FaResUtil.getRes((String)"DecValueDecQty", (Locale)locale)}, info, false, true, this.baseScale);
        BigDecimal decValue = this.card.getDecValue().setScale(this.baseScale, 4);
        initYearData = decValue.subtract(info.getDecValueIncQty()).add(info.getDecValueDecQty()).setScale(this.baseScale, 4);
        if (initYearData.compareTo(info.getDecValueBeginQty()) != 0) {
            throw new TaskExternalException(FaResUtil.getRes((String)"startYearDprPre", (Locale)locale) + "= " + FaResUtil.getRes((String)"startYearDeallocateAdd", (Locale)locale) + "+" + FaResUtil.getRes((String)"yearAllocateDeAmount", (Locale)locale) + info.getDecValueBeginQty() + " != " + decValue + "-" + info.getDecValueIncQty() + "+" + info.getDecValueDecQty());
        }
        FaDataImportUtils.setBigDecimalData(ctx, data, new String[]{"FAssetAmtBeginQty", "FAssetAmtIncQty", "FAssetAmtDecQty"}, new String[]{"assetAmtBeginQty", "assetAmtIncQty", "assetAmtDecQty"}, new String[]{FaResUtil.getRes((String)"AssetAmtBeginQty", (Locale)locale), FaResUtil.getRes((String)"AssetAmtIncQty", (Locale)locale), FaResUtil.getRes((String)"AssetAmtDecQty", (Locale)locale)}, info, false, false, this.quantityScale);
        BigDecimal assetAmt = this.card.getAssetAmt().setScale(this.quantityScale, 4);
        initYearData = assetAmt.subtract(info.getAssetAmtIncQty()).add(info.getAssetAmtDecQty()).setScale(this.quantityScale, 4);
        if (initYearData.compareTo(info.getAssetAmtBeginQty()) != 0) {
            throw new TaskExternalException(FaResUtil.getRes((String)"startYearAmount", (Locale)locale) + "= " + FaResUtil.getRes((String)"cardPassEntriesAmountde", (Locale)locale) + "+" + FaResUtil.getRes((String)"yearAllocateDeAmount", (Locale)locale) + info.getAssetAmtBeginQty() + " != " + assetAmt + "-" + info.getAssetAmtIncQty() + "+" + info.getAssetAmtDecQty());
        }
        return info;
    }

    private void initScale(Context ctx, CompanyOrgUnitInfo company) throws TaskExternalException {
        if (this.cache.QUANTITYSCALE != null) {
            this.quantityScale = this.cache.QUANTITYSCALE;
        } else {
            HashMap hmParam;
            try {
                hmParam = FaManageUtils.getFAParameter(company.getBOSUuid("id"), ctx);
            }
            catch (Exception e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
            if (hmParam != null && hmParam.size() > 0 && (String)hmParam.get("FA_008") != null) {
                this.quantityScale = Integer.parseInt((String)hmParam.get("FA_008"));
            }
            this.cache.QUANTITYSCALE = new Integer(this.quantityScale);
        }
        this.baseScale = company.getBaseCurrency().getPrecision();
    }

    private FaInitDataInfo getCurInitDataInfo(Context ctx) throws TaskExternalException {
        try {
            IFaCurInitData iInitData = FaCurInitDataFactory.getLocalInstance(ctx);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("faCurCard", (Object)this.card.getId().toString()));
            if (iInitData.exists(filter)) {
                return iInitData.getFaCurInitDataInfo("SELECT ID WHERE faCurCard.id ='" + this.card.getId() + "'");
            }
            return new FaInitDataInfo();
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    private FaInitDataInfo getMonInitDataInfo(Context ctx) throws TaskExternalException {
        try {
            IFaMonInitData iInitData = FaMonInitDataFactory.getLocalInstance(ctx);
            return iInitData.getFaMonInitDataInfo("WHERE faMonCard.id ='" + this.monCard.getId() + "'");
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    private String getValue(Context ctx, Map data, String fieldName, String fieldCHN, boolean supportNull) throws TaskExternalException {
        String result;
        Object obj = null;
        obj = data.get(fieldName) == null ? null : ((DataToken)data.get((Object)fieldName)).data;
        String string = result = obj == null ? null : obj.toString();
        if (StringUtils.isEmpty((String)result) && !supportNull) {
            this.abort(ctx, MessageFormat.format(FaResUtil.getRes((String)"columnCanNotNull", (Locale)ctx.getOriginLocale()), fieldCHN));
        }
        return result;
    }

    private void abort(Context ctx, String message) throws TaskExternalException {
        throw new TaskExternalException(message + "\t" + FaResUtil.getRes((String)"cardNumber2", (Locale)ctx.getOriginLocale()) + this.cardNumber);
    }

    private void submitBalance(Context ctx) throws BOSException, EASBizException {
        FaCurInitDataCollection initDataColl;
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        String strCompanyID = company.getId().toString();
        boolean isFristPeriod = false;
        PeriodInfo aStartPeriodInfo = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (IObjectPK)new ObjectUuidPK(BOSUuid.read((String)strCompanyID)));
        IPeriod iPeriod = PeriodFactory.getLocalInstance((Context)ctx);
        FilterInfo aFilterInfo = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("accountPeriodType.id"));
        sic.add(new SelectorItemInfo("baseCurrency.id"));
        sic.add(new SelectorItemInfo("baseCurrency.number"));
        sic.add(new SelectorItemInfo("baseCurrency.name"));
        company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)strCompanyID)), sic);
        String typeId = company.getAccountPeriodType().getId().toString();
        aFilterInfo.getFilterItems().add(new FilterItemInfo("periodType", (Object)typeId, CompareType.EQUALS));
        aFilterInfo.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(aStartPeriodInfo.getPeriodYear()), CompareType.EQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(aFilterInfo);
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("periodYear"));
        evi.getSelector().add(new SelectorItemInfo("periodQuarter"));
        evi.getSelector().add(new SelectorItemInfo("periodNumber"));
        evi.getSelector().add(new SelectorItemInfo("beginDate"));
        evi.getSelector().add(new SelectorItemInfo("endDate"));
        evi.getSelector().add(new SelectorItemInfo("isAdjustPeriod"));
        SorterItemInfo aSorterItemInfo = new SorterItemInfo("periodNumber");
        aSorterItemInfo.setSortType(SortType.ASCEND);
        evi.getSorter().add(aSorterItemInfo);
        PeriodCollection c = iPeriod.getPeriodCollection(evi);
        PeriodInfo prePeriodInfo = null;
        if (c != null && c.size() > 0) {
            PeriodInfo info = c.get(0);
            isFristPeriod = aStartPeriodInfo.getId().toString().equals(info.getId().toString());
            for (int i = 0; i < c.size(); ++i) {
                info = c.get(i);
                if (aStartPeriodInfo.getPeriodNumber() - 1 != info.getPeriodNumber()) continue;
                prePeriodInfo = info;
                break;
            }
        }
        IFaAccountBalance iFaAccountBalance = FaAccountBalanceFactory.getLocalInstance(ctx);
        BigDecimal tempBegin = null;
        BigDecimal tempDebit = null;
        BigDecimal tempCredit = null;
        BigDecimal tempEnd = null;
        FaAccountBalanceInfo aBalanceInfo = this.getAcctInfo(aStartPeriodInfo, iFaAccountBalance);
        aBalanceInfo.setPeriod(aStartPeriodInfo);
        aBalanceInfo.setCompanyOrgUnit(this.card.getCompany());
        aBalanceInfo.setCurrency(company.getBaseCurrency());
        aBalanceInfo.setFaCurCard(this.card);
        aBalanceInfo.setCreator(this.card.getCreator());
        aBalanceInfo.setLastUpdateUser(this.card.getLastUpdateUser());
        Timestamp time = new Timestamp(System.currentTimeMillis());
        aBalanceInfo.setCreateTime(time);
        aBalanceInfo.setLastUpdateTime(time);
        aBalanceInfo.setRealBeginBalanceFor(this.card.getAssetValue());
        aBalanceInfo.setRealEndBalanceFor(this.card.getAssetValue());
        aBalanceInfo.setDepreBeginBalanceFor(this.card.getAccuDepr());
        aBalanceInfo.setDepreEndBalanceFor(this.card.getAccuDepr());
        aBalanceInfo.setAddUpYearDepre(this.card.getAccuDeprTYear());
        aBalanceInfo.setDecValueBeginBalanceFor(this.card.getDecValue());
        aBalanceInfo.setDecValueEndBalanceFor(this.card.getDecValue());
        aBalanceInfo.setEvalueBeginBalanceFor(this.card.getInitEvalValue() != null ? this.card.getInitEvalValue() : this.card.getAssetValue());
        aBalanceInfo.setEvalueEndBalanceFor(this.card.getInitEvalValue() != null ? this.card.getInitEvalValue() : this.card.getAssetValue());
        iFaAccountBalance.submit((CoreBaseInfo)aBalanceInfo);
        if (!isFristPeriod && (initDataColl = this.card.getFaCurInitData()) != null && initDataColl.size() > 0) {
            FaCurInitDataInfo aFaCurInitDataInfo = initDataColl.get(0);
            aBalanceInfo = this.getAcctInfo(prePeriodInfo, iFaAccountBalance);
            aBalanceInfo.setPeriod(prePeriodInfo);
            aBalanceInfo.setCompanyOrgUnit(this.card.getCompany());
            aBalanceInfo.setCurrency(company.getBaseCurrency());
            aBalanceInfo.setFaCurCard(this.card);
            aBalanceInfo.setCreator(this.card.getCreator());
            aBalanceInfo.setLastUpdateUser(this.card.getLastUpdateUser());
            aBalanceInfo.setCreateTime(time);
            aBalanceInfo.setLastUpdateTime(time);
            aBalanceInfo.setRealBeginBalanceFor(aFaCurInitDataInfo.getOriginBeginQty());
            tempBegin = aFaCurInitDataInfo.getOriginBeginQty() == null ? new BigDecimal("0") : aFaCurInitDataInfo.getOriginBeginQty();
            aBalanceInfo.setRealDebitFor(aFaCurInitDataInfo.getOriginIncQty());
            tempDebit = aFaCurInitDataInfo.getOriginIncQty() == null ? new BigDecimal("0") : aFaCurInitDataInfo.getOriginIncQty();
            aBalanceInfo.setRealCreditFor(aFaCurInitDataInfo.getOriginDecQty());
            tempCredit = aFaCurInitDataInfo.getOriginDecQty() == null ? new BigDecimal("0") : aFaCurInitDataInfo.getOriginDecQty();
            tempEnd = tempBegin.add(tempDebit).subtract(tempCredit);
            aBalanceInfo.setRealEndBalanceFor(tempEnd);
            aBalanceInfo.setDepreBeginBalanceFor(aFaCurInitDataInfo.getDeprBeginQty());
            tempBegin = aFaCurInitDataInfo.getDeprBeginQty() == null ? new BigDecimal("0") : aFaCurInitDataInfo.getDeprBeginQty();
            aBalanceInfo.setDepreDebitFor(aFaCurInitDataInfo.getDeprDecQty());
            tempDebit = aFaCurInitDataInfo.getDeprDecQty() == null ? new BigDecimal("0") : aFaCurInitDataInfo.getDeprDecQty();
            aBalanceInfo.setDepreCreditFor(aFaCurInitDataInfo.getDeprIncQty());
            tempCredit = aFaCurInitDataInfo.getDeprIncQty() == null ? new BigDecimal("0") : aFaCurInitDataInfo.getDeprIncQty();
            tempEnd = tempBegin.add(tempCredit).subtract(tempDebit);
            aBalanceInfo.setDepreEndBalanceFor(tempEnd);
            aBalanceInfo.setAddUpYearDepre(this.card.getAccuDeprTYear());
            aBalanceInfo.setDecValueBeginBalanceFor(aFaCurInitDataInfo.getDecValueBeginQty());
            tempBegin = aFaCurInitDataInfo.getDecValueBeginQty() == null ? new BigDecimal("0") : aFaCurInitDataInfo.getDecValueBeginQty();
            aBalanceInfo.setDecValueDebitFor(aFaCurInitDataInfo.getDecValueDecQty());
            tempDebit = aFaCurInitDataInfo.getDecValueDecQty() == null ? new BigDecimal("0") : aFaCurInitDataInfo.getDecValueDecQty();
            aBalanceInfo.setDecValueCreditFor(aFaCurInitDataInfo.getDecValueIncQty());
            tempCredit = aFaCurInitDataInfo.getDecValueIncQty() == null ? new BigDecimal("0") : aFaCurInitDataInfo.getDecValueIncQty();
            tempEnd = tempBegin.add(tempCredit).subtract(tempDebit);
            aBalanceInfo.setDecValueEndBalanceFor(tempEnd);
            aBalanceInfo.setEvalueBeginBalanceFor(this.card.isIsEvaledBefore() ? this.card.getInitEvalValue() : aBalanceInfo.getRealBeginBalanceFor());
            aBalanceInfo.setEvalueDebitFor(this.card.isIsEvaledBefore() ? new BigDecimal("0") : aBalanceInfo.getRealDebitFor());
            aBalanceInfo.setEvalueCreditFor(this.card.isIsEvaledBefore() ? new BigDecimal("0") : aBalanceInfo.getRealCreditFor());
            aBalanceInfo.setEvalueEndBalanceFor(this.card.isIsEvaledBefore() ? this.card.getInitEvalValue() : aBalanceInfo.getRealEndBalanceFor());
            iFaAccountBalance.submit((CoreBaseInfo)aBalanceInfo);
        }
    }

    private FaAccountBalanceInfo getAcctInfo(PeriodInfo aStartPeriodInfo, IFaAccountBalance iFaAccountBalance) throws BOSException, EASBizException {
        FaAccountBalanceInfo aBalanceInfo = new FaAccountBalanceInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("period.id", (Object)aStartPeriodInfo.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("faCurCard.id", (Object)this.card.getId().toString()));
        if (iFaAccountBalance.exists(filter)) {
            aBalanceInfo = iFaAccountBalance.getFaAccountBalanceInfo("SELECT ID WHERE period.id ='" + aStartPeriodInfo.getId() + "' and faCurCard.id ='" + this.card.getId() + "'");
        }
        return aBalanceInfo;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        this.verifyBeforeTran(ctx);
        try {
            CompanyOrgUnitInfo company = null;
            String compId = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
            if (this.cache.CURRENTCOMP != null) {
                company = this.cache.CURRENTCOMP;
            } else {
                try {
                    company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("SELECT * , baseCurrency.* WHERE id ='" + compId + "'");
                }
                catch (Exception e) {
                    throw new TaskExternalException(e.getMessage(), (Throwable)e);
                }
                this.cache.CURRENTCOMP = company;
            }
            int baseScale = company.getBaseCurrency().getPrecision();
            int quantityScale = 0;
            if (this.cache.QUANTITYSCALE != null) {
                quantityScale = this.cache.QUANTITYSCALE;
            } else {
                HashMap hmParam;
                try {
                    hmParam = FaManageUtils.getFAParameter(company.getBOSUuid("id"), ctx);
                }
                catch (Exception e) {
                    throw new TaskExternalException(e.getMessage(), (Throwable)e);
                }
                if (hmParam != null && hmParam.size() > 0 && (String)hmParam.get("FA_008") != null) {
                    quantityScale = Integer.parseInt((String)hmParam.get("FA_008"));
                }
                this.cache.QUANTITYSCALE = new Integer(quantityScale);
            }
            HashMap<String, Integer> precisions = new HashMap<String, Integer>();
            precisions.put("baseScale", new Integer(baseScale));
            precisions.put("quantityScale", new Integer(quantityScale));
            Hashtable result = FaDataImportUtils.setDataForExport(this.EXP_FIELD_IN_FILE, this.EXP_FIELD_IN_QUERY, rs, precisions);
            if (rs.getString("initdata.id") == null || rs.getString("initdata.id").trim().length() == 0) {
                return new Hashtable();
            }
            return result;
        }
        catch (SQLException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        return FaDataImportUtils.getFilterForExp(ctx, super.getExportFilterForQuery(ctx), true);
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.fi.fa.manage.FaMonCardExpQuery";
    }

    protected void verifyBeforeTran(Context ctx) throws TaskExternalException {
        CompanyOrgUnitInfo _comp = ContextUtil.getCurrentFIUnit((Context)ctx);
        if (_comp == null) {
            String strMsg = ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.Company_Null", (Locale)ctx.getOriginLocale());
            throw new TaskExternalException(strMsg);
        }
        if (!_comp.isIsBizUnit()) {
            String strMsg = ResourceBase.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource.vitualComNotAllowUseThisFun", (Locale)ctx.getOriginLocale());
            throw new TaskExternalException(strMsg);
        }
    }

    private boolean isFirstPeriod(Context ctx, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        IPeriod iPeriod = PeriodFactory.getLocalInstance((Context)ctx);
        FilterInfo i = new FilterInfo();
        String typeId = company.getAccountPeriodType().getId().toString();
        i.getFilterItems().add(new FilterItemInfo("periodType", (Object)typeId, CompareType.EQUALS));
        PeriodInfo aPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)company);
        i.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(aPeriodInfo.getPeriodYear()), CompareType.EQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(i);
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSorter().add(new SorterItemInfo("periodNumber"));
        PeriodCollection c = iPeriod.getPeriodCollection(evi);
        if (c != null && c.size() > 0) {
            PeriodInfo info = c.get(0);
            if (aPeriodInfo.getId().toString().equals(info.getId().toString())) {
                return true;
            }
        }
        return false;
    }

    class QueryObjCacheInfo {
        public CompanyOrgUnitInfo CURRENTCOMP = null;
        public Integer QUANTITYSCALE = null;
        public Boolean ISSTART = null;
        public Boolean ISFIRSTPERIOD = null;

        QueryObjCacheInfo() {
        }
    }
}

