/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app.depreciationbatch.validate.abs;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaLeaseBalanceEntryFactory;
import com.kingdee.eas.fi.fa.manage.IFaBillBase;
import com.kingdee.eas.fi.fa.manage.IFaLeaseBalanceEntry;
import com.kingdee.eas.fi.fa.manage.IFaLeaseBill;
import com.kingdee.eas.fi.fa.manage.app.depreciationbatch.validate.abs.AbstractDepreciationBatchValidateBase;
import com.kingdee.eas.fi.fa.manage.app.depreciationbatch.validate.vo.DepreciationBatchValidateCheckParam;
import com.kingdee.util.NumericExceptionSubItem;

public abstract class AbstractDepreciationBatchImplBase
extends AbstractDepreciationBatchValidateBase {
    @Override
    protected void validateHandle(Context ctx, DepreciationBatchValidateCheckParam depreciationBatchValidateCheckParam) throws BOSException, EASBizException {
        if (depreciationBatchValidateCheckParam.getPeriod() == null || depreciationBatchValidateCheckParam.getPeriod().getId() == null || depreciationBatchValidateCheckParam.getCompany().getId() == null) {
            return;
        }
        String billName = "";
        boolean hasNotAudit = false;
        boolean hasVoucher = false;
        IFaBillBase faBizInterface = this.getFABizInterface(ctx);
        billName = AbstractDepreciationBatchImplBase.getEntityAlias(ctx, faBizInterface.getType());
        hasNotAudit = faBizInterface.hasNotAuditValue(depreciationBatchValidateCheckParam.getPeriod().getId().toString(), depreciationBatchValidateCheckParam.getCompany().getId().toString());
        if (depreciationBatchValidateCheckParam.isNotGenVoucher()) {
            hasVoucher = faBizInterface.hasNotGenVoucherValue(depreciationBatchValidateCheckParam.getPeriod().getId().toString(), depreciationBatchValidateCheckParam.getCompany().getId().toString());
            if (hasNotAudit && hasVoucher) {
                throw new EASBizException(new NumericExceptionSubItem("1", AbstractDepreciationBatchImplBase.getResource(ctx, "com.kingdee.eas.fi.fa.manage.FaPeriodClose", "forward_NoAuditNoVoucher")), (Object[])new String[]{billName});
            }
            if (!hasNotAudit && hasVoucher) {
                throw new EASBizException(new NumericExceptionSubItem("1", AbstractDepreciationBatchImplBase.getResource(ctx, "com.kingdee.eas.fi.fa.manage.FaPeriodClose", "forward_HasNewBiz_NoVoucher")), (Object[])new String[]{billName});
            }
        }
        if (hasNotAudit) {
            throw new EASBizException(new NumericExceptionSubItem("1", AbstractDepreciationBatchImplBase.getResource(ctx, "com.kingdee.eas.fi.fa.manage.FaPeriodClose", "forward_HasNewBiz_NoAudit")), (Object[])new String[]{billName});
        }
        if (faBizInterface instanceof IFaLeaseBill) {
            AbstractDepreciationBatchImplBase.verifyLeaseBalance(ctx, depreciationBatchValidateCheckParam.isNotGenVoucher(), depreciationBatchValidateCheckParam.getPeriod().getId().toString(), depreciationBatchValidateCheckParam.getCompany().getId().toString());
        }
        faBizInterface.checkBeforePeriodClose(depreciationBatchValidateCheckParam.getPeriod().getId().toString(), depreciationBatchValidateCheckParam.getCompany().getId().toString());
    }

    public static void verifyLeaseBalance(Context ctx, boolean notGenVoucher, String periodID, String companyID) throws EASBizException, BOSException {
        IFaLeaseBalanceEntry iLeaseBal = FaLeaseBalanceEntryFactory.getLocalInstance(ctx);
        String billName = AbstractDepreciationBatchImplBase.getEntityAlias(ctx, iLeaseBal.getType());
        FilterInfo auditFilter = new FilterInfo();
        auditFilter.getFilterItems().add(new FilterItemInfo("period.id", (Object)periodID, CompareType.EQUALS));
        auditFilter.getFilterItems().add(new FilterItemInfo("bill.company.id", (Object)companyID, CompareType.EQUALS));
        auditFilter.getFilterItems().add(new FilterItemInfo("checkedStatus", (Object)new Integer(2), CompareType.NOTEQUALS));
        boolean hasNotAudit = FaLeaseBalanceEntryFactory.getLocalInstance(ctx).exists(auditFilter);
        if (notGenVoucher) {
            FilterInfo voucherFilter = new FilterInfo();
            voucherFilter.getFilterItems().add(new FilterItemInfo("period.id", (Object)periodID, CompareType.EQUALS));
            voucherFilter.getFilterItems().add(new FilterItemInfo("bill.company.id", (Object)companyID, CompareType.EQUALS));
            voucherFilter.getFilterItems().add(new FilterItemInfo("checkedStatus", (Object)new Integer(2), CompareType.NOTEQUALS));
            voucherFilter.getFilterItems().add(new FilterItemInfo("fiVouchered", (Object)"1", CompareType.NOTEQUALS));
            voucherFilter.setMaskString("#0 and #1 and (#2 or #3)");
            boolean hasVoucher = FaLeaseBalanceEntryFactory.getLocalInstance(ctx).exists(voucherFilter);
            if (hasNotAudit && hasVoucher) {
                throw new EASBizException(new NumericExceptionSubItem("1", AbstractDepreciationBatchImplBase.getResource(ctx, "com.kingdee.eas.fi.fa.manage.FaPeriodClose", "forward_NoAuditNoVoucher")), (Object[])new String[]{billName});
            }
            if (!hasNotAudit && hasVoucher) {
                throw new EASBizException(new NumericExceptionSubItem("1", AbstractDepreciationBatchImplBase.getResource(ctx, "com.kingdee.eas.fi.fa.manage.FaPeriodClose", "forward_HasNewBiz_NoVoucher")), (Object[])new String[]{billName});
            }
        }
        if (hasNotAudit) {
            throw new EASBizException(new NumericExceptionSubItem("1", AbstractDepreciationBatchImplBase.getResource(ctx, "com.kingdee.eas.fi.fa.manage.FaPeriodClose", "forward_HasNewBiz_NoAudit")), (Object[])new String[]{billName});
        }
    }

    protected abstract IFaBillBase getFABizInterface(Context var1) throws BOSException;
}

