/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app.depreciationbatch.validate.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.manage.app.depreciationbatch.validate.abs.AbstractDepreciationBatchValidateBase;
import com.kingdee.eas.fi.fa.manage.app.depreciationbatch.validate.vo.DepreciationBatchValidateCheckParam;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.Date;

public class CheckComp
extends AbstractDepreciationBatchValidateBase {
    @Override
    protected void validateHandle(Context ctx, DepreciationBatchValidateCheckParam depreciationBatchValidateCheckParam) throws BOSException, EASBizException {
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = depreciationBatchValidateCheckParam.getCompany();
        String strMsg = "";
        if (aCompanyOrgUnitInfo != null) {
            if (aCompanyOrgUnitInfo.getInvalidDate() != null && DateTimeUtils.dayBefore((Date)aCompanyOrgUnitInfo.getInvalidDate(), (Date)new Date())) {
                strMsg = EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.Company_Disabled");
                throw new EASBizException(new NumericExceptionSubItem("1", strMsg));
            }
            if (!aCompanyOrgUnitInfo.isIsBizUnit()) {
                strMsg = EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource.vitualComNotAllowUseThisFun");
                throw new EASBizException(new NumericExceptionSubItem("1", strMsg));
            }
        } else {
            strMsg = EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.Company_Null");
            throw new EASBizException(new NumericExceptionSubItem("1", strMsg));
        }
        this.checkPeriod(aCompanyOrgUnitInfo);
    }

    @Override
    protected String setNoteUrl() {
        return null;
    }

    private void checkPeriod(CompanyOrgUnitInfo company) throws EASBizException {
        PeriodInfo aPeriodInfo = null;
        try {
            aPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)(company == null ? SysContext.getSysContext().getCurrentFIUnit() : company));
        }
        catch (Exception e) {
            throw new EASBizException(new NumericExceptionSubItem("1", e.toString()));
        }
        if (aPeriodInfo == null) {
            String strMsg = EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource.notConfigStartPeriod");
            throw new EASBizException(new NumericExceptionSubItem("1", strMsg));
        }
    }
}

