/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app.depreciationbatch.validate.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.IFaCurCard;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.fa.manage.app.depreciationbatch.validate.abs.AbstractDepreciationBatchValidateBase;
import com.kingdee.eas.fi.fa.manage.app.depreciationbatch.validate.vo.DepreciationBatchValidateCheckParam;
import com.kingdee.util.NumericExceptionSubItem;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.HashSet;

public class HasCardNotAudit
extends AbstractDepreciationBatchValidateBase {
    private StringBuffer url = new StringBuffer();

    @Override
    protected void validateHandle(Context ctx, DepreciationBatchValidateCheckParam depreciationBatchValidateCheckParam) throws BOSException, EASBizException {
        HashSet laterPeriods;
        String companyId = depreciationBatchValidateCheckParam.getCompany().getId().toString();
        HashMap hm = FaManageUtils.getFAParameter(ctx, new String[]{"FA_022"}, companyId);
        boolean allowPassPeriodAudit = hm.get("FA_022") == null ? false : Boolean.valueOf(hm.get("FA_022").toString());
        IFaCurCard icard = FaCurCardFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company", (Object)depreciationBatchValidateCheckParam.getCompany().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("checkedStatus", (Object)new Integer(2), CompareType.NOTEQUALS));
        if (allowPassPeriodAudit) {
            filter.getFilterItems().add(new FilterItemInfo("fiAccountDate", null, CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("fiAccountDate", (Object)depreciationBatchValidateCheckParam.getPeriod().getBeginDate(), CompareType.GREATER_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("fiAccountDate", (Object)depreciationBatchValidateCheckParam.getPeriod().getEndDate(), CompareType.LESS_EQUALS));
        }
        if ((laterPeriods = FaLocalUtils.getLaterPeriodIdSet(ctx, depreciationBatchValidateCheckParam.getPeriod().getId().toString())).size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("period.id", (Object)laterPeriods, CompareType.NOTINCLUDE));
        }
        if (icard.exists(filter)) {
            this.setWebLinkUrl(companyId, depreciationBatchValidateCheckParam.getPeriod().getId().toString());
            throw new EASBizException(new NumericExceptionSubItem("1", HasCardNotAudit.getResource(ctx, "com.kingdee.eas.fi.fa.manage.FaDepreciationResource", "FaDepCal_HasNewCardNotAudit")));
        }
    }

    @Override
    protected String setNoteUrl() {
        return this.url.toString();
    }

    private String getUIPK() {
        return "com.kingdee.eas.fi.fa.FaCurCardListUI";
    }

    private void setWebLinkUrl(String companyId, String periodId) {
        this.url = new StringBuffer();
        this.url.append("&uipk=").append(this.getUIPK());
        try {
            this.url.append("&companyId=").append(URLEncoder.encode(companyId, "UTF-8")).append("&periodId=").append(URLEncoder.encode(periodId, "UTF-8")).append("&checkedStatus=1");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }
}

