/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app.falog.listener.strategy;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaAppLogFactory;
import com.kingdee.eas.fi.fa.manage.FaDataChangeLogForDataChangeRecordTypeEnum;
import com.kingdee.eas.fi.fa.manage.FaDataChangeLogForDataChangeTypeEnum;
import com.kingdee.eas.fi.fa.manage.FaDataChangeLogInfo;
import com.kingdee.eas.fi.fa.manage.app.falog.event.FaEventTypeEnum;
import com.kingdee.eas.fi.fa.manage.app.falog.event.FaRPCMethodEvent;
import com.kingdee.eas.fi.fa.manage.app.falog.listener.AbstractFaRPCMethodListener;
import com.kingdee.eas.fi.fa.manage.app.falog.listener.annotation.FaListenerEventType;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.HashMap;
import org.apache.log4j.Logger;

@FaListenerEventType(value=FaEventTypeEnum.FA_DEP_JUMP_PERIOD)
public class FaLogForDepJumpPeriodRPCMethodListener
extends AbstractFaRPCMethodListener<FaDataChangeLogInfo> {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.fa.manage.app.falog.listener.strategy.FaLogForDepJumpPeriodRPCMethodListener");
    private static final ThreadLocal<HashMap<String, String>> FaDepJumpPeriodTempTableNameThreadLocal = new ThreadLocal();
    private static final ThreadLocal<HashMap<String, FaRPCMethodEvent<FaDataChangeLogInfo>>> faRPCMethodEventThreadLocal = new ThreadLocal();

    @Override
    public void invokeMethodCalcBefore(FaRPCMethodEvent<FaDataChangeLogInfo> faRPCMethodEvent) throws BOSException, EASBizException {
        block8: {
            try {
                PeriodInfo faCurPeriodInfo = faRPCMethodEvent.getFaCurPeriodInfo();
                CompanyOrgUnitInfo faCurCompany = faRPCMethodEvent.getFaCurCompany();
                String tempTableName = this.createTempTable(faRPCMethodEvent.getContext());
                StringBuilder calcSQL = new StringBuilder();
                calcSQL.append(" INSERT INTO " + tempTableName + " \n");
                calcSQL.append(" SELECT card.FID, card.FDEPRTERMCOUNT FROM t_fa_facurcard card \n");
                calcSQL.append(" left join t_fa_famoncard moncard on card.fid = moncard.FFACURCARDID \n");
                calcSQL.append(" left join t_bd_period period on moncard.FFAPERIODID = period.FID \n");
                calcSQL.append(" left join t_fa_fadepreciationentry depentry on depentry.FFACURCARDID = card.FID \n");
                calcSQL.append(" left join t_fa_fadepreciation dep on dep.fid = depentry.FLNKFADEPREENTRY \n");
                calcSQL.append(" where (period.FNUMBER = ? or (period.FNUMBER is null and card.FPERIODID = ?)) and card.FCOMPANYID = ? and (dep.FPERIOD = ? or dep.FPERIOD is null) and card.FDEPRTERMCOUNT = ((case moncard.FDEPRTERMCOUNT when null then 0 else moncard.FDEPRTERMCOUNT end) + (case depentry.fid when null then 0 else 1 end) - (case depentry.FSTATE when 3 then 0 else 1 end)) \n");
                int perPeriodNumber = faCurPeriodInfo.getNumber() - 1;
                if (faCurPeriodInfo.getPeriodNumber() == 1) {
                    perPeriodNumber += 12;
                    perPeriodNumber -= 100;
                }
                Object[] calcParams = new Object[]{perPeriodNumber, faCurPeriodInfo.getId().toString(), faCurCompany.getId().toString(), faCurPeriodInfo.getId().toString()};
                DbUtil.execute((Context)faRPCMethodEvent.getContext(), (String)calcSQL.toString(), (Object[])calcParams);
                if (FaDepJumpPeriodTempTableNameThreadLocal.get() != null) {
                    HashMap<String, String> hashMap = FaDepJumpPeriodTempTableNameThreadLocal.get();
                    hashMap.put(faRPCMethodEvent.getSvcCtx().getOperationPK().toString(), tempTableName);
                } else {
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put(faRPCMethodEvent.getSvcCtx().getOperationPK().toString(), tempTableName);
                    FaDepJumpPeriodTempTableNameThreadLocal.set(hashMap);
                }
                if (faRPCMethodEventThreadLocal.get() != null) {
                    HashMap<String, FaRPCMethodEvent<FaDataChangeLogInfo>> hashMapID = faRPCMethodEventThreadLocal.get();
                    hashMapID.put(faRPCMethodEvent.getSvcCtx().getOperationPK().toString(), faRPCMethodEvent);
                } else {
                    HashMap<String, FaRPCMethodEvent<FaDataChangeLogInfo>> hashMapID = new HashMap<String, FaRPCMethodEvent<FaDataChangeLogInfo>>();
                    hashMapID.put(faRPCMethodEvent.getSvcCtx().getOperationPK().toString(), faRPCMethodEvent);
                    faRPCMethodEventThreadLocal.set(hashMapID);
                }
            }
            catch (Exception e) {
                logger.error((Object)("FaLogForDepJumpPeriodRPCMethodListener Before Exception:" + e));
                StackTraceElement[] stackTraceElements = e.getStackTrace();
                if (stackTraceElements == null) break block8;
                for (StackTraceElement stackTraceElement : stackTraceElements) {
                    logger.error((Object)("FaLogForDepJumpPeriodRPCMethodListener Before Exception stackTraceElements:" + stackTraceElement));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void invokeMethodCalcAfter(FaRPCMethodEvent<FaDataChangeLogInfo> faRPCMethodEvent) throws BOSException, EASBizException {
        String tempTableName = null;
        try {
            HashMap<String, String> hashMap = FaDepJumpPeriodTempTableNameThreadLocal.get();
            tempTableName = hashMap.get(faRPCMethodEvent.getSvcCtx().getOperationPK().toString());
            FaRPCMethodEvent<FaDataChangeLogInfo> faRPCMethodEventOld = faRPCMethodEventThreadLocal.get().get(faRPCMethodEvent.getSvcCtx().getOperationPK().toString());
            PeriodInfo faCurPeriodInfo = faRPCMethodEventOld.getFaCurPeriodInfo();
            CompanyOrgUnitInfo faCurCompany = faRPCMethodEventOld.getFaCurCompany();
            StringBuilder selectSql = new StringBuilder();
            selectSql.append(" SELECT card.FID fid, card.FdeprTermCount afterValue, tmp.deprTermCount beforeValue FROM t_fa_facurcard card \n");
            selectSql.append(" inner join " + tempTableName + " tmp on tmp.faCardId = card.fid \n");
            selectSql.append(" left join t_fa_famoncard moncard on card.fid = moncard.FFACURCARDID \n");
            selectSql.append(" left join t_bd_period period on moncard.FFAPERIODID = period.FID \n");
            selectSql.append(" left join t_fa_fadepreciationentry depentry on depentry.FFACURCARDID = card.FID \n");
            selectSql.append(" left join t_fa_fadepreciation dep on dep.fid = depentry.FLNKFADEPREENTRY \n");
            selectSql.append(" where (period.FNUMBER = ? or (period.FNUMBER is null and card.FPERIODID = ?)) and card.FCOMPANYID = ? and (dep.FPERIOD = ? or dep.FPERIOD is null) and card.FDEPRTERMCOUNT != ((case moncard.FDEPRTERMCOUNT when null then 0 else moncard.FDEPRTERMCOUNT end) + (case depentry.fid when null then 0 else 1 end) - (case depentry.FSTATE when 3 then 0 else 1 end)) \n");
            int perPeriodNumber = faCurPeriodInfo.getNumber() - 1;
            if (faCurPeriodInfo.getPeriodNumber() == 1) {
                perPeriodNumber += 12;
                perPeriodNumber -= 100;
            }
            IRowSet rs = DbUtil.executeQuery((Context)faRPCMethodEvent.getContext(), (String)selectSql.toString(), (Object[])new Object[]{perPeriodNumber, faCurPeriodInfo.getId().toString(), faCurCompany.getId().toString(), faCurPeriodInfo.getId().toString()});
            while (rs.next()) {
                FaDataChangeLogInfo faDataChangeLogInfo = new FaDataChangeLogInfo();
                faDataChangeLogInfo.setId(BOSUuid.create((BOSObjectType)faDataChangeLogInfo.getBOSType()));
                faDataChangeLogInfo.setAppLogID(faRPCMethodEventOld.getDetailMessage().getAppLogID());
                faDataChangeLogInfo.setDataChangeType(FaDataChangeLogForDataChangeTypeEnum.FA_DEP_JUMP_PERIOD);
                faDataChangeLogInfo.setDataChangeRecordType(FaDataChangeLogForDataChangeRecordTypeEnum.FA_DATA_FIELD_CHANGE);
                faDataChangeLogInfo.setDataChangeTable("t_fa_facurcard");
                faDataChangeLogInfo.setBusinessID(rs.getString("fid"));
                faDataChangeLogInfo.setDataChangeFields("FdeprTermCount");
                faDataChangeLogInfo.setDataChangeFieldsValue("beforeValue:" + rs.getBigDecimal("beforeValue") + ";afterValue:" + rs.getBigDecimal("afterValue"));
                faDataChangeLogInfo.setDataChangeRecords(0);
                HashMap<String, FaDataChangeLogInfo> params = new HashMap<String, FaDataChangeLogInfo>();
                params.put("faDataChangeLogInfo", faDataChangeLogInfo);
                FaAppLogFactory.getLocalInstance(faRPCMethodEvent.getContext()).requiresNewMethod("FaDataChangeLogFactory.addnew", params);
            }
            if (tempTableName == null) return;
        }
        catch (Exception e) {
            try {
                logger.error((Object)("FaLogForDepJumpPeriodRPCMethodListener After Exception:" + e));
                StackTraceElement[] stackTraceElements = e.getStackTrace();
                if (stackTraceElements != null) {
                    for (StackTraceElement stackTraceElement : stackTraceElements) {
                        logger.error((Object)("FaLogForDepJumpPeriodRPCMethodListener After Exception stackTraceElements:" + stackTraceElement));
                    }
                }
                if (tempTableName == null) return;
            }
            catch (Throwable throwable) {
                if (tempTableName == null) throw throwable;
                TempTablePool.getInstance((Context)faRPCMethodEvent.getContext()).releaseTable(tempTableName);
                throw throwable;
            }
            TempTablePool.getInstance((Context)faRPCMethodEvent.getContext()).releaseTable(tempTableName);
            return;
        }
        TempTablePool.getInstance((Context)faRPCMethodEvent.getContext()).releaseTable(tempTableName);
        return;
    }

    private String createTempTable(Context ctx) throws BOSException {
        String tempTableName;
        StringBuilder tempTableSQL = new StringBuilder();
        tempTableSQL.append("CREATE TABLE T_Temp_FaLogForDepJumpPeriod( faCardId VARCHAR(44), deprTermCount NUMERIC(19,8) DEFAULT 0 )");
        try {
            tempTableName = TempTablePool.getInstance((Context)ctx).createTempTable(tempTableSQL.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempTableName;
    }
}

