/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app.falog.utils;

import com.kingdee.bos.Context;
import com.kingdee.bos.framework.session.LoginType;
import com.kingdee.bos.service.ServiceContext;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.fi.fa.manage.FaAppLogForBusinessTypeEnum;
import com.kingdee.eas.fi.fa.manage.FaAppLogForLoginTypeEnum;
import com.kingdee.eas.fi.fa.manage.FaAppLogInfo;
import com.kingdee.eas.fi.fa.manage.FaDataChangeLogInfo;
import com.kingdee.eas.fi.fa.manage.app.falog.event.AbstractFaRPCMethodEvent;
import com.kingdee.eas.fi.fa.manage.app.falog.event.FaEventTypeEnum;
import com.kingdee.eas.fi.fa.manage.app.falog.event.FaMethodCalcOrderEnum;
import com.kingdee.eas.fi.fa.manage.app.falog.event.FaRPCMethodEvent;
import com.kingdee.eas.fi.fa.manage.app.falog.utils.entity.FaRPCMethodMappingEntity;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.sql.Timestamp;
import java.util.Date;
import javax.naming.InitialContext;
import javax.transaction.TransactionSynchronizationRegistry;
import org.apache.log4j.Logger;

public class FaRPCMethodEventFactory {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.fa.manage.app.falog.utils.FaRPCMethodEventFactory");
    private static InitialContext initialContext = null;
    private static TransactionSynchronizationRegistry tsr = null;

    private FaRPCMethodEventFactory() {
    }

    public static <T> FaRPCMethodEvent<T> getRPCMethodEvents(ServiceContext serviceContext, Context context, FaEventTypeEnum eventType, final FaAppLogForBusinessTypeEnum faAppLogForBusinessTypeEnum, FaMethodCalcOrderEnum methodCalcOrder, T detailMessage, final FaRPCMethodMappingEntity faRPCMethodMappingEntity) {
        return new AbstractFaRPCMethodEvent<T>(serviceContext, context, eventType, methodCalcOrder, faRPCMethodMappingEntity.getFaCurPeriodInfo(), faRPCMethodMappingEntity.getCompanyOrgUnitInfo(), detailMessage){

            @Override
            public void onEvent() {
                FaRPCMethodEventFactory.updateDetailMessage(this.serviceContext, this.context, this.detailMessage, faRPCMethodMappingEntity, faAppLogForBusinessTypeEnum);
            }
        };
    }

    private static <T> void updateDetailMessage(ServiceContext serviceContext, Context context, T detailMessage, FaRPCMethodMappingEntity faRPCMethodMappingEntity, FaAppLogForBusinessTypeEnum faAppLogForBusinessTypeEnum) {
        if (detailMessage instanceof FaAppLogInfo) {
            FaAppLogInfo faAppLogInfo = (FaAppLogInfo)detailMessage;
            faAppLogInfo.setId(faRPCMethodMappingEntity.getFaAppLogInfoID());
            faAppLogInfo.setOccurTime(new Timestamp(new Date().getTime()));
            faAppLogInfo.setUserID(context.getCaller() == null ? "" : context.getCaller().toString());
            if (faRPCMethodMappingEntity.getCompanyOrgUnitInfo() != null && faRPCMethodMappingEntity.getCompanyOrgUnitInfo().getCU() != null && faRPCMethodMappingEntity.getCompanyOrgUnitInfo().getCU().getId() != null) {
                faAppLogInfo.setCuID(faRPCMethodMappingEntity.getCompanyOrgUnitInfo().getCU().getId().toString());
            }
            if (faRPCMethodMappingEntity.getCompanyOrgUnitInfo() != null && faRPCMethodMappingEntity.getCompanyOrgUnitInfo().getId() != null) {
                faAppLogInfo.setCompanyID(faRPCMethodMappingEntity.getCompanyOrgUnitInfo().getId().toString());
            }
            if (faRPCMethodMappingEntity.getFaCurPeriodInfo() != null && faRPCMethodMappingEntity.getFaCurPeriodInfo().getId() != null) {
                faAppLogInfo.setFaCurPeriodID(faRPCMethodMappingEntity.getFaCurPeriodInfo().getId().toString());
            }
            faAppLogInfo.setClientIP(context.getClientHostIP());
            faAppLogInfo.setClientName(context.getClientHostIP());
            faAppLogInfo.setBusinessType(faAppLogForBusinessTypeEnum);
            faAppLogInfo.setOperationType(faRPCMethodMappingEntity.getFaRpcMethodMappingInfo().getOperationType());
            faAppLogInfo.setEntityID(serviceContext.getBoType() == null ? "" : serviceContext.getBoType().toString());
            faAppLogInfo.setClassName(faRPCMethodMappingEntity.getFaRpcMethodMappingInfo().getRpcClass());
            faAppLogInfo.setOperationPK(faRPCMethodMappingEntity.getFaRpcMethodMappingInfo().getInnerID());
            faAppLogInfo.setMethodName(faRPCMethodMappingEntity.getFaRpcMethodMappingInfo().getRpcMethodName());
            faAppLogInfo.setMethodParams(faRPCMethodMappingEntity.getFaRpcMethodMappingInfo().getRpcFiledName());
            if (faRPCMethodMappingEntity.getFaRpcMethodMappingInfo().getInstanceIdPosition() != -1) {
                int instanceIdPosition = faRPCMethodMappingEntity.getFaRpcMethodMappingInfo().getInstanceIdPosition();
                if (CoreBaseInfo.class.isAssignableFrom(serviceContext.getOperationParameters()[instanceIdPosition].getClass())) {
                    CoreBaseInfo coreBaseInfo = (CoreBaseInfo)serviceContext.getOperationParameters()[instanceIdPosition];
                    if (coreBaseInfo != null && coreBaseInfo.getId() != null) {
                        faAppLogInfo.setInstanceID(coreBaseInfo.getId().toString());
                    }
                } else {
                    Object str = serviceContext.getOperationParameters()[instanceIdPosition];
                    faAppLogInfo.setInstanceID(str == null ? "" : str.toString());
                }
            }
            faAppLogInfo.setThreadName(Thread.currentThread().toString());
            faAppLogInfo.setThreadActiveCountBefore(Thread.activeCount());
            faAppLogInfo.setThreadActiveCountAfter(Thread.activeCount());
            if (initialContext != null && tsr != null && tsr.getTransactionKey() != null) {
                faAppLogInfo.setCurTransactionID(tsr.getTransactionKey().toString());
            }
            faAppLogInfo.setMethodTimeBefore(new Timestamp(new Date().getTime()));
            faAppLogInfo.setMethodTimeAfter(new Timestamp(new Date().getTime()));
            faAppLogInfo.setIsSuccessed(false);
            faAppLogInfo.setIsRpcMethod(true);
            faAppLogInfo.setContextID(context.getContextID());
            faAppLogInfo.setDbTypeCode(context.get((Object)"dbTypeCode") == null ? "" : String.valueOf(context.get((Object)"dbTypeCode")));
            faAppLogInfo.setDbTypeName(context.get((Object)"dbType") == null ? "" : String.valueOf(context.get((Object)"dbType")));
            faAppLogInfo.setDbTypeVersion(context.getAIS());
            faAppLogInfo.setLoginType(LoginType.GUI == context.get((Object)"LOGIN_TYPE") ? FaAppLogForLoginTypeEnum.GUI : FaAppLogForLoginTypeEnum.WEB);
            faAppLogInfo.setAccountScheme(context.get((Object)"AccountScheme") == null ? "" : String.valueOf(context.get((Object)"AccountScheme")));
        }
        if (detailMessage instanceof FaDataChangeLogInfo) {
            FaDataChangeLogInfo faDataChangeLogInfo = (FaDataChangeLogInfo)detailMessage;
            faDataChangeLogInfo.setId(BOSUuid.create((BOSObjectType)faDataChangeLogInfo.getBOSType()));
            faDataChangeLogInfo.setAppLogID(faRPCMethodMappingEntity.getFaAppLogInfoID().toString());
            faDataChangeLogInfo.setDataChangeType(null);
            faDataChangeLogInfo.setDataChangeRecordType(null);
            faDataChangeLogInfo.setDataChangeTable(null);
            faDataChangeLogInfo.setBusinessID(null);
            faDataChangeLogInfo.setDataChangeFields(null);
            faDataChangeLogInfo.setDataChangeFieldsValue(null);
            faDataChangeLogInfo.setDataChangeRecords(0);
        }
    }

    static {
        try {
            initialContext = new InitialContext();
            tsr = (TransactionSynchronizationRegistry)initialContext.lookup("java:comp/TransactionSynchronizationRegistry");
        }
        catch (Exception e) {
            logger.error((Object)("FaRPCMethodEventFactory NamingException initialValue" + e));
        }
    }
}

