/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app.falog.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.app.falog.event.FaRPCMethodEvent;
import com.kingdee.eas.fi.fa.manage.app.falog.listener.FaRPCMethodListener;
import com.kingdee.eas.fi.fa.manage.app.falog.listener.annotation.FaListenerEventType;
import com.kingdee.eas.fi.fa.manage.app.falog.listener.strategy.FaAppLogRPCMethodListener;
import com.kingdee.eas.fi.fa.manage.app.falog.listener.strategy.FaLogForBalanceLossRPCMethodListener;
import com.kingdee.eas.fi.fa.manage.app.falog.listener.strategy.FaLogForCleanUpMoreRPCMethodListener;
import com.kingdee.eas.fi.fa.manage.app.falog.listener.strategy.FaLogForDepJumpPeriodRPCMethodListener;
import com.kingdee.eas.fi.fa.manage.app.falog.listener.strategy.FaLogForMonthlySettlementLoss;
import com.kingdee.eas.fi.fa.manage.app.falog.listener.strategy.FaLogForThisYearAccDepErrorRPCMethodListener;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.log4j.Logger;

public class FaRPCMethodEventPublish {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.fa.manage.app.falog.utils.FaRPCMethodEventPublish");
    private static final CopyOnWriteArrayList<Class<?>> annotatedClasses = new CopyOnWriteArrayList();

    private FaRPCMethodEventPublish() {
    }

    public static void rpcMethodEventPublish(List<FaRPCMethodEvent<?>> rpcMethodEvents) throws BOSException, EASBizException {
        for (FaRPCMethodEvent<?> rpcMethodEvent : rpcMethodEvents) {
            FaRPCMethodEventPublish.forwardListener(rpcMethodEvent);
        }
    }

    private static <T> void forwardListener(FaRPCMethodEvent<T> rpcMethodEvent) throws BOSException, EASBizException {
        for (Class<?> clazz : annotatedClasses) {
            FaListenerEventType annotation = clazz.getAnnotation(FaListenerEventType.class);
            if (rpcMethodEvent.getEventType() != annotation.value()) continue;
            try {
                ((FaRPCMethodListener)clazz.newInstance()).onListener(rpcMethodEvent);
            }
            catch (InstantiationException e) {
                throw new BOSException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    public static synchronized CopyOnWriteArrayList<Class<?>> getClassesWithAnnotation(Class<? extends Annotation> annotationClass, String packageName) throws BOSException {
        CopyOnWriteArrayList annotatedClasses = new CopyOnWriteArrayList();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String path = packageName.replace('.', '/');
        try {
            Enumeration<URL> resources = classLoader.getResources(path);
            while (resources.hasMoreElements()) {
                File dir;
                URL resource = resources.nextElement();
                if (!"file".equals(resource.getProtocol()) || !(dir = new File(resource.toURI())).exists() || !dir.isDirectory()) continue;
                for (File file : Objects.requireNonNull(dir.listFiles())) {
                    if (!file.isFile()) continue;
                    String className = file.getName().substring(0, file.getName().lastIndexOf(46));
                    try {
                        Class<?> clazz = Class.forName(packageName + '.' + className);
                        if (!clazz.isAnnotationPresent(annotationClass)) continue;
                        annotatedClasses.add(clazz);
                    }
                    catch (ClassNotFoundException e) {
                        throw new BOSException((Throwable)e);
                    }
                }
            }
        }
        catch (IOException e) {
            throw new BOSException((Throwable)e);
        }
        catch (URISyntaxException e) {
            throw new BOSException((Throwable)e);
        }
        return annotatedClasses;
    }

    static {
        annotatedClasses.add(FaAppLogRPCMethodListener.class);
        annotatedClasses.add(FaLogForBalanceLossRPCMethodListener.class);
        annotatedClasses.add(FaLogForCleanUpMoreRPCMethodListener.class);
        annotatedClasses.add(FaLogForDepJumpPeriodRPCMethodListener.class);
        annotatedClasses.add(FaLogForMonthlySettlementLoss.class);
        annotatedClasses.add(FaLogForThisYearAccDepErrorRPCMethodListener.class);
    }
}

