/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app.fleventlistener.listener.strategy;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.basedata.FaContractCatFactory;
import com.kingdee.eas.fi.fa.basedata.FaContractCatInfo;
import com.kingdee.eas.fi.fa.manage.AccessTypeEnum;
import com.kingdee.eas.fi.fa.manage.FaLeaseInBillNewInfo;
import com.kingdee.eas.fi.fa.manage.LendingDirectionEnum;
import com.kingdee.eas.fi.fa.manage.NLMAccountBalanceDetailCollection;
import com.kingdee.eas.fi.fa.manage.NLMAccountBalanceDetailInfo;
import com.kingdee.eas.fi.fa.manage.NLMBillContractCatFieldNameEnum;
import com.kingdee.eas.fi.fa.manage.NLMBillFieldNameEnum;
import com.kingdee.eas.fi.fa.manage.NLMBillSourceTypeEnum;
import com.kingdee.eas.fi.fa.manage.NLMBillTypeEnum;
import com.kingdee.eas.fi.fa.manage.app.fleventlistener.event.RPCMethodEvent;
import com.kingdee.eas.framework.SystemEnum;
import java.math.BigDecimal;

public enum UpdateBalanceTableForLeaseBillEnum {
    ASSET_CHANGE_CREAT(NLMBillSourceTypeEnum.LEASE_BILL_ADJUST, new NLMBillFieldNameEnum[]{NLMBillFieldNameEnum.LEASE_BILL_ASSET_ADJUST, NLMBillFieldNameEnum.LEASE_BILL_ACC_DEP_ADJUST, NLMBillFieldNameEnum.LEASE_BILL_DEC_ADJUST}, new NLMBillContractCatFieldNameEnum[]{NLMBillContractCatFieldNameEnum.USUFRUCT_ASSET_ACT, NLMBillContractCatFieldNameEnum.USUFRUCT_ASSET_ACC_DEP, NLMBillContractCatFieldNameEnum.USUFRUCT_ASSET_DEC_VALUE}),
    RETROACTIVE_ADJUSTMENT_CREAT(NLMBillSourceTypeEnum.LEASE_BILL_RETR_ADJUST, new NLMBillFieldNameEnum[]{NLMBillFieldNameEnum.LEASE_BILL_ASSET_ADJUST, NLMBillFieldNameEnum.LEASE_BILL_ACC_DEP_ADJUST_RETR}, new NLMBillContractCatFieldNameEnum[]{NLMBillContractCatFieldNameEnum.USUFRUCT_ASSET_ACT, NLMBillContractCatFieldNameEnum.USUFRUCT_ASSET_ACC_DEP}),
    TERMINATION_CREAT(NLMBillSourceTypeEnum.LEASE_BILL_TERMINATE, new NLMBillFieldNameEnum[]{NLMBillFieldNameEnum.LEASE_BILL_ASSET_ADJUST}, new NLMBillContractCatFieldNameEnum[]{NLMBillContractCatFieldNameEnum.USUFRUCT_ASSET_ACT}),
    FINANCE_LEASE(NLMBillSourceTypeEnum.LEASE_BILL_FINANCE_LEASE, new NLMBillFieldNameEnum[]{NLMBillFieldNameEnum.LEASE_BILL_ASSET, NLMBillFieldNameEnum.LEASE_BILL_ACC_DEP, NLMBillFieldNameEnum.LEASE_BILL_DEC}, new NLMBillContractCatFieldNameEnum[]{NLMBillContractCatFieldNameEnum.USUFRUCT_ASSET_ACT, NLMBillContractCatFieldNameEnum.USUFRUCT_ASSET_ACC_DEP, NLMBillContractCatFieldNameEnum.USUFRUCT_ASSET_DEC_VALUE}),
    GL_BALANCE_ENTRY(NLMBillSourceTypeEnum.LEASE_BILL_GL_BALANCE_ENTRY, new NLMBillFieldNameEnum[]{NLMBillFieldNameEnum.LEASE_BILL_ASSET, NLMBillFieldNameEnum.LEASE_BILL_ACC_DEP, NLMBillFieldNameEnum.LEASE_BILL_DEC}, new NLMBillContractCatFieldNameEnum[]{NLMBillContractCatFieldNameEnum.USUFRUCT_ASSET_ACT, NLMBillContractCatFieldNameEnum.USUFRUCT_ASSET_ACC_DEP, NLMBillContractCatFieldNameEnum.USUFRUCT_ASSET_DEC_VALUE}),
    OPERATING_LEASE(NLMBillSourceTypeEnum.LEASE_BILL_OPERATING_LEASE, new NLMBillFieldNameEnum[]{NLMBillFieldNameEnum.LEASE_BILL_INIT_ASSET, NLMBillFieldNameEnum.LEASE_BILL_INIT_ACC_DEP, NLMBillFieldNameEnum.LEASE_BILL_ACC_DEP_RECORD, NLMBillFieldNameEnum.LEASE_BILL_DEC}, new NLMBillContractCatFieldNameEnum[]{NLMBillContractCatFieldNameEnum.USUFRUCT_ASSET_ACT, NLMBillContractCatFieldNameEnum.USUFRUCT_ASSET_ACC_DEP, NLMBillContractCatFieldNameEnum.USUFRUCT_ASSET_ACC_DEP, NLMBillContractCatFieldNameEnum.USUFRUCT_ASSET_DEC_VALUE});

    private final NLMBillSourceTypeEnum nlmBillSourceTypeEnum;
    private final NLMBillFieldNameEnum[] nlmBillFieldNameEnums;
    private final NLMBillContractCatFieldNameEnum[] nlmBillContractCatFieldNameEnums;

    private UpdateBalanceTableForLeaseBillEnum(NLMBillSourceTypeEnum nlmBillSourceTypeEnum, NLMBillFieldNameEnum[] nlmBillFieldNameEnums, NLMBillContractCatFieldNameEnum[] nlmBillContractCatFieldNameEnums) {
        this.nlmBillSourceTypeEnum = nlmBillSourceTypeEnum;
        this.nlmBillFieldNameEnums = nlmBillFieldNameEnums;
        this.nlmBillContractCatFieldNameEnums = nlmBillContractCatFieldNameEnums;
    }

    public NLMAccountBalanceDetailCollection getNLMAccountBalanceDetailCollection(RPCMethodEvent<FaLeaseInBillNewInfo> rpcMethodEvent) throws EASBizException, BOSException {
        return this.getDetailInfo(rpcMethodEvent.getContext(), rpcMethodEvent.getDetailMessage(), SystemStatusCtrolUtils.getCurrentPeriod((Context)rpcMethodEvent.getContext(), (SystemEnum)SystemEnum.FINANCE_LEASE, (CompanyOrgUnitInfo)rpcMethodEvent.getDetailMessage().getCompany()));
    }

    public static UpdateBalanceTableForLeaseBillEnum getEnumAccordingToBillType(String billType) {
        UpdateBalanceTableForLeaseBillEnum[] enums;
        for (UpdateBalanceTableForLeaseBillEnum value : enums = UpdateBalanceTableForLeaseBillEnum.values()) {
            if (!billType.equals(value.name())) continue;
            return value;
        }
        return null;
    }

    public NLMAccountBalanceDetailCollection getDetailInfo(Context ctx, FaLeaseInBillNewInfo billInfo, PeriodInfo curPeriod) throws EASBizException, BOSException {
        NLMAccountBalanceDetailCollection nlmAccountBalanceDetailCollection = new NLMAccountBalanceDetailCollection();
        int j = this.nlmBillFieldNameEnums.length;
        for (int i = 0; i < j; ++i) {
            NLMAccountBalanceDetailInfo detailInfo = new NLMAccountBalanceDetailInfo();
            detailInfo.setId(BOSUuid.create((BOSObjectType)detailInfo.getBOSType()));
            detailInfo.setCompany(billInfo.getCompany());
            detailInfo.setCurrency(billInfo.getCurrency());
            detailInfo.setPeriod(curPeriod);
            detailInfo.setNlmLeaseBillID(billInfo.getId().toString());
            detailInfo.setNlmBillNumber(billInfo.getNumber());
            detailInfo.setNlmBillContractCat(billInfo.getContractCat());
            detailInfo.setNlmBillID(billInfo.getId().toString());
            detailInfo.setNlmBillType(NLMBillTypeEnum.LEASE_BILL);
            detailInfo.setNlmBillSourceType(this.nlmBillSourceTypeEnum);
            detailInfo.setContractCatFieldName(this.nlmBillContractCatFieldNameEnums[i]);
            FaContractCatInfo faContractCatInfo = FaContractCatFactory.getLocalInstance((Context)ctx).getFaContractCatInfo((IObjectPK)new ObjectUuidPK(billInfo.getContractCat().getId().toString()));
            detailInfo.setContractCatFieldValue((AccountViewInfo)faContractCatInfo.get(this.getContractCatFieldName(this.nlmBillContractCatFieldNameEnums[i])));
            detailInfo.setNlmBillGetFieldName(this.nlmBillFieldNameEnums[i]);
            detailInfo.setNlmBillGetFieldValue((BigDecimal)billInfo.get(this.getNlmBillGetFieldName(this.nlmBillFieldNameEnums[i])));
            detailInfo.setLendingDirection(detailInfo.getContractCatFieldName() == NLMBillContractCatFieldNameEnum.USUFRUCT_ASSET_ACT ? LendingDirectionEnum.LEND : LendingDirectionEnum.LOAN);
            detailInfo.setAccessType(this.nlmBillSourceTypeEnum == NLMBillSourceTypeEnum.LEASE_BILL_GL_BALANCE_ENTRY ? AccessTypeEnum.OPENING_BALANCE : AccessTypeEnum.AMOUNT_INCURRED);
            nlmAccountBalanceDetailCollection.add(detailInfo);
        }
        return nlmAccountBalanceDetailCollection;
    }

    protected String getContractCatFieldName(NLMBillContractCatFieldNameEnum nlmBillContractCatFieldNameEnum) {
        String result = "";
        if (nlmBillContractCatFieldNameEnum == NLMBillContractCatFieldNameEnum.USUFRUCT_ASSET_ACT) {
            result = "usufructAssetAcct";
        }
        if (nlmBillContractCatFieldNameEnum == NLMBillContractCatFieldNameEnum.USUFRUCT_ASSET_ACC_DEP) {
            result = "usufructAssetAcctACM";
        }
        if (nlmBillContractCatFieldNameEnum == NLMBillContractCatFieldNameEnum.USUFRUCT_ASSET_DEC_VALUE) {
            result = "usufructAssetAcctDEC";
        }
        return result;
    }

    protected String getNlmBillGetFieldName(NLMBillFieldNameEnum nlmBillFieldNameEnum) {
        String result = "";
        if (nlmBillFieldNameEnum == NLMBillFieldNameEnum.LEASE_BILL_ASSET) {
            result = "financeInitialAsset";
        }
        if (nlmBillFieldNameEnum == NLMBillFieldNameEnum.LEASE_BILL_ACC_DEP) {
            result = "financeInitAccDepreciation";
        }
        if (nlmBillFieldNameEnum == NLMBillFieldNameEnum.LEASE_BILL_DEC) {
            result = "initialAssetDecValue";
        }
        if (nlmBillFieldNameEnum == NLMBillFieldNameEnum.LEASE_BILL_INIT_ASSET) {
            result = "initialAsset";
        }
        if (nlmBillFieldNameEnum == NLMBillFieldNameEnum.LEASE_BILL_INIT_ACC_DEP) {
            result = "initAccDepreciation";
        }
        if (nlmBillFieldNameEnum == NLMBillFieldNameEnum.LEASE_BILL_ACC_DEP_RECORD) {
            result = "accDepOfAsset";
        }
        if (nlmBillFieldNameEnum == NLMBillFieldNameEnum.LEASE_BILL_ASSET_ADJUST) {
            result = "adjustmentAsset";
        }
        if (nlmBillFieldNameEnum == NLMBillFieldNameEnum.LEASE_BILL_ACC_DEP_ADJUST) {
            result = "adjustAccDepAsset";
        }
        if (nlmBillFieldNameEnum == NLMBillFieldNameEnum.LEASE_BILL_DEC_ADJUST) {
            result = "adjustDecAsset";
        }
        if (nlmBillFieldNameEnum == NLMBillFieldNameEnum.LEASE_BILL_ACC_DEP_ADJUST_RETR) {
            result = "accDeprAdjustment";
        }
        return result;
    }

    public NLMBillSourceTypeEnum getNlmBillSourceTypeEnum() {
        return this.nlmBillSourceTypeEnum;
    }
}

