/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app.periodclose;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaBakCardInfo;
import com.kingdee.eas.fi.fa.manage.FaBizCardInfo;
import com.kingdee.eas.fi.fa.manage.FaChangeBillCollection;
import com.kingdee.eas.fi.fa.manage.FaChangeBillEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaChangeBillEntryFactory;
import com.kingdee.eas.fi.fa.manage.FaChangeBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaChangeBillFactory;
import com.kingdee.eas.fi.fa.manage.FaChangeBillInfo;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.IFaChangeBill;
import com.kingdee.eas.fi.fa.manage.IFaChangeBillEntry;
import com.kingdee.eas.fi.fa.manage.app.periodclose.AbstractFaCheckBeforePeriodClose;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;

public class FaChangeBillCheckBeforePeriodClose
extends AbstractFaCheckBeforePeriodClose {
    @Override
    protected void checkBeforeCarrayForward(Context ctx, PeriodInfo period, CompanyOrgUnitInfo company, HashMap<String, Boolean> hmPara) throws BOSException, EASBizException {
        boolean isCheckVoucher = hmPara.get("isCheckVoucher");
        if (this.hasChangeCard(ctx, company, period, isCheckVoucher)) {
            throw new EASBizException(new NumericExceptionSubItem("1", this.getResource(ctx, "com.kingdee.eas.fi.fa.manage.FaPeriodClose", "forward_HasChange")));
        }
    }

    @Override
    protected void checkBeforeCarrayBack(Context ctx, PeriodInfo period, CompanyOrgUnitInfo company, HashMap<String, Boolean> hmPara) throws BOSException, EASBizException {
    }

    private boolean hasChangeCard(Context ctx, CompanyOrgUnitInfo company, PeriodInfo period, boolean notGenVoucher) throws BOSException, EASBizException {
        IFaChangeBill ichange = FaChangeBillFactory.getLocalInstance(ctx);
        Date beginDate = DateTimeUtils.truncateDate((Date)period.getBeginDate());
        Date endDate = DateTimeUtils.truncateDate((Date)period.getEndDate());
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(endDate);
        calendar.add(5, 1);
        endDate = calendar.getTime();
        PeriodInfo adjPeriod = PeriodUtils.getAdjPeriodInfo((Context)ctx, (PeriodInfo)period);
        boolean hasNotAudit = FaChangeBillCheckBeforePeriodClose.hasFaChangeBillNotAudit(ctx, company, period, adjPeriod, beginDate, endDate);
        if (!notGenVoucher) {
            if (hasNotAudit) {
                throw new EASBizException(new NumericExceptionSubItem("1", this.getResource(ctx, "com.kingdee.eas.fi.fa.manage.FaPeriodClose", "forward_HasChange_NoAudit")));
            }
            return hasNotAudit;
        }
        FilterInfo needVoucherfilter = FaChangeBillCheckBeforePeriodClose.getNeedVoucherFilter(company, period, adjPeriod, beginDate, endDate);
        boolean hasNeedVoucher = ichange.exists(needVoucherfilter);
        if (hasNeedVoucher) {
            FilterInfo filter = FaChangeBillCheckBeforePeriodClose.getHasVoucherFilter(company, period, adjPeriod, beginDate, endDate);
            IFaChangeBillEntry ichangeEntry = FaChangeBillEntryFactory.getLocalInstance(ctx);
            boolean hasChgNeedVoucher = ichangeEntry.exists(filter);
            if (hasNotAudit && hasChgNeedVoucher) {
                throw new EASBizException(new NumericExceptionSubItem("1", this.getResource(ctx, "com.kingdee.eas.fi.fa.manage.FaPeriodClose", "forward_NoAuditNoVoucher")), (Object[])new String[]{this.getResource(ctx, "com.kingdee.eas.fi.fa.manage.FaPeriodClose", "forward_ChangeBill")});
            }
            if (!hasNotAudit && hasChgNeedVoucher) {
                throw new EASBizException(new NumericExceptionSubItem("1", this.getResource(ctx, "com.kingdee.eas.fi.fa.manage.FaPeriodClose", "forward_HasChange_NoVoucher")));
            }
            FilterInfo hasDeptChgNeedVoucherfilter = FaChangeBillCheckBeforePeriodClose.getHasDeptChgNeedVoucherFilter(company, period, adjPeriod, beginDate, endDate);
            FaChangeBillCheckBeforePeriodClose.hasDepartChangeNeedVoucher(ctx, company, hasDeptChgNeedVoucherfilter);
            FaChangeBillCheckBeforePeriodClose.hasAccountChangeNeedVoucher(ctx, company, needVoucherfilter);
        }
        if (hasNotAudit) {
            throw new EASBizException(new NumericExceptionSubItem("1", this.getResource(ctx, "com.kingdee.eas.fi.fa.manage.FaPeriodClose", "forward_HasChange_NoAudit")));
        }
        return false;
    }

    public static void hasAccountChangeNeedVoucher(Context ctx, CompanyOrgUnitInfo company, FilterInfo filter) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("changeBillEntry.bizCard.*"));
        IFaChangeBill ichange = FaChangeBillFactory.getLocalInstance(ctx);
        view.setFilter(filter);
        FaChangeBillCollection changeBillCollection = ichange.getFaChangeBillCollection(view);
        int size = changeBillCollection.size();
        for (int i = 0; i < size; ++i) {
            FaChangeBillInfo changeBill = (FaChangeBillInfo)changeBillCollection.getObject(i);
            FaChangeBillEntryCollection entryCol = changeBill.getChangeBillEntry();
            FaChangeBillEntryInfo entryInfo = entryCol.get(0);
            FaBizCardInfo bizcard = entryInfo.getBizCard();
            FaBakCardInfo oldCard = entryInfo.getBizCard().getFaBakCard();
            if (!FaChangeBillCheckBeforePeriodClose.isAccountEqual(bizcard.getAccountAsset(), oldCard.getAccountAsset())) {
                throw new EASBizException(new NumericExceptionSubItem("1", ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"155_FaChangeBillCheckBeforePeriodClose", (Locale)ctx.getOriginLocale())));
            }
            if (!FaChangeBillCheckBeforePeriodClose.isAccountEqual(bizcard.getAccountAccuDepr(), oldCard.getAccountAccuDepr())) {
                throw new EASBizException(new NumericExceptionSubItem("1", ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"156_FaChangeBillCheckBeforePeriodClose", (Locale)ctx.getOriginLocale())));
            }
            if (FaChangeBillCheckBeforePeriodClose.isAccountEqual(bizcard.getAccountDecValue(), oldCard.getAccountDecValue()) || BigDecimal.ZERO.compareTo(bizcard.getDecValue()) == 0) continue;
            throw new EASBizException(new NumericExceptionSubItem("1", ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"157_FaChangeBillCheckBeforePeriodClose", (Locale)ctx.getOriginLocale())));
        }
    }

    public static void hasDepartChangeNeedVoucher(Context ctx, CompanyOrgUnitInfo company, FilterInfo filter) throws BOSException, EASBizException {
        IFaChangeBill ichange = FaChangeBillFactory.getLocalInstance(ctx);
        boolean hasDepartChangeNeedVoucher = ichange.exists(filter);
        HashMap map = FaManageUtils.getFAParameter(company.getId(), ctx);
        boolean departChangeNeedVoucher = false;
        if (map != null && map.get("FA_039") != null && map.get("FA_039").toString().equals("true")) {
            departChangeNeedVoucher = true;
        }
        if (hasDepartChangeNeedVoucher && departChangeNeedVoucher) {
            throw new EASBizException(new NumericExceptionSubItem("1", ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"96_FaPeriodCloseFacadeControllerBean", (Locale)ctx.getOriginLocale())));
        }
    }

    public static boolean hasFaChangeBillNotAudit(Context ctx, CompanyOrgUnitInfo company, PeriodInfo period, PeriodInfo adjPeriod, Date beginDate, Date endDate) throws EASBizException, BOSException {
        IFaChangeBill ichange = FaChangeBillFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        if (adjPeriod != null) {
            filter.getFilterItems().add(new FilterItemInfo("changeDate", (Object)beginDate, CompareType.GREATER_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("changeDate", (Object)endDate, CompareType.LESS));
            filter.getFilterItems().add(new FilterItemInfo("period.id", (Object)adjPeriod.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("period.id", (Object)period.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("company", (Object)company.getId()));
            filter.getFilterItems().add(new FilterItemInfo("checkedStatus", (Object)new Integer(2), CompareType.NOTEQUALS));
            filter.setMaskString("(#0 and #1 and #2 or #3) and #4 and #5");
        } else {
            filter.getFilterItems().add(new FilterItemInfo("period.id", (Object)period.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("company", (Object)company.getId()));
            filter.getFilterItems().add(new FilterItemInfo("checkedStatus", (Object)new Integer(2), CompareType.NOTEQUALS));
            filter.setMaskString("#0 and #1 and #2");
        }
        return ichange.exists(filter);
    }

    public static EntityViewInfo getNeedVoucherView(Context ctx, CompanyOrgUnitInfo company, PeriodInfo period, PeriodInfo adjPeriod, Date beginDate, Date endDate) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        FilterInfo filter = new FilterInfo();
        if (adjPeriod != null) {
            filter.getFilterItems().add(new FilterItemInfo("changeDate", (Object)beginDate, CompareType.GREATER_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("changeDate", (Object)endDate, CompareType.LESS));
            filter.getFilterItems().add(new FilterItemInfo("period.id", (Object)adjPeriod.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("period.id", (Object)period.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("company", (Object)company.getId()));
            filter.getFilterItems().add(new FilterItemInfo("checkedStatus", (Object)new Integer(2), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("fiVouchered", (Object)"1", CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("billtype", null, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("billtype", (Object)"9000", CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("billtype", (Object)"14000", CompareType.EQUALS));
            filter.setMaskString("(#0 and #1 and #2 or #3) and #4 and #5 and #6 and (#7 or #8 or #9)");
        } else {
            filter.getFilterItems().add(new FilterItemInfo("period.id", (Object)period.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("company", (Object)company.getId()));
            filter.getFilterItems().add(new FilterItemInfo("checkedStatus", (Object)new Integer(2), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("fiVouchered", (Object)"1", CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("billtype", null, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("billtype", (Object)"9000", CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("billtype", (Object)"14000", CompareType.EQUALS));
            filter.setMaskString("#0 and #1 and #2 and #3 and (#4 or #5 or #6)");
        }
        view.setFilter(filter);
        return view;
    }

    private static FilterInfo getNeedVoucherFilter(CompanyOrgUnitInfo company, PeriodInfo period, PeriodInfo adjPeriod, Date beginDate, Date endDate) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        if (adjPeriod != null) {
            filter.getFilterItems().add(new FilterItemInfo("changeDate", (Object)beginDate, CompareType.GREATER_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("changeDate", (Object)endDate, CompareType.LESS));
            filter.getFilterItems().add(new FilterItemInfo("period.id", (Object)adjPeriod.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("period.id", (Object)period.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("company", (Object)company.getId()));
            filter.getFilterItems().add(new FilterItemInfo("checkedStatus", (Object)new Integer(2), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("fiVouchered", (Object)"1", CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("billtype", null, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("billtype", (Object)"9000", CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("billtype", (Object)"14000", CompareType.EQUALS));
            filter.setMaskString("(#0 and #1 and #2 or #3) and #4 and #5 and #6 and (#7 or #8 or #9)");
        } else {
            filter.getFilterItems().add(new FilterItemInfo("period.id", (Object)period.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("company", (Object)company.getId()));
            filter.getFilterItems().add(new FilterItemInfo("checkedStatus", (Object)new Integer(2), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("fiVouchered", (Object)"1", CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("billtype", null, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("billtype", (Object)"9000", CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("billtype", (Object)"14000", CompareType.EQUALS));
            filter.setMaskString("#0 and #1 and #2 and #3 and (#4 or #5 or #6)");
        }
        return filter;
    }

    private static FilterInfo getHasVoucherFilter(CompanyOrgUnitInfo company, PeriodInfo period, PeriodInfo adjPeriod, Date beginDate, Date endDate) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        if (adjPeriod != null) {
            filter.getFilterItems().add(new FilterItemInfo("changeBill.changeDate", (Object)beginDate, CompareType.GREATER_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("changeBill.changeDate", (Object)endDate, CompareType.LESS));
            filter.getFilterItems().add(new FilterItemInfo("changeBill.period.id", (Object)adjPeriod.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("changeBill.period.id", (Object)period.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("changeBill.company", (Object)company.getId()));
            filter.getFilterItems().add(new FilterItemInfo("changeBill.checkedStatus", (Object)new Integer(2), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("changeBill.fiVouchered", (Object)"1", CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("changeBill.billtype", null, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("changeBill.billtype", (Object)"9000", CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("changeBill.billtype", (Object)"14000", CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("originChg", (Object)new BigDecimal("0"), CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("accuDeprChg", (Object)new BigDecimal("0"), CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("decValueChg", (Object)new BigDecimal("0"), CompareType.NOTEQUALS));
            filter.setMaskString("(#0 and #1 and #2 or #3) and #4 and #5 and #6 and (#7 or #8 or #9) and (#10 or #11 or #12)");
        } else {
            filter.getFilterItems().add(new FilterItemInfo("changeBill.period.id", (Object)period.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("changeBill.company", (Object)company.getId()));
            filter.getFilterItems().add(new FilterItemInfo("changeBill.checkedStatus", (Object)new Integer(2), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("changeBill.fiVouchered", (Object)"1", CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("changeBill.billtype", null, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("changeBill.billtype", (Object)"9000", CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("changeBill.billtype", (Object)"14000", CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("originChg", (Object)new BigDecimal("0"), CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("accuDeprChg", (Object)new BigDecimal("0"), CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("decValueChg", (Object)new BigDecimal("0"), CompareType.NOTEQUALS));
            filter.setMaskString("#0 and #1 and #2 and #3 and (#4 or #5 or #6) and (#7 or #8 or #9)");
        }
        return filter;
    }

    private static FilterInfo getHasDeptChgNeedVoucherFilter(CompanyOrgUnitInfo company, PeriodInfo period, PeriodInfo adjPeriod, Date beginDate, Date endDate) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        if (adjPeriod != null) {
            filter.getFilterItems().add(new FilterItemInfo("changeDate", (Object)beginDate, CompareType.GREATER_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("changeDate", (Object)endDate, CompareType.LESS));
            filter.getFilterItems().add(new FilterItemInfo("period.id", (Object)adjPeriod.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("period.id", (Object)period.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("company", (Object)company.getId()));
            filter.getFilterItems().add(new FilterItemInfo("checkedStatus", (Object)new Integer(2), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("fiVouchered", (Object)"1", CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("billtype", null, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("billtype", (Object)"9000", CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("billtype", (Object)"14000", CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("hasDepartmentChanged", (Object)new Integer(1)));
            filter.setMaskString("(#0 and #1 and #2 or #3) and #4 and #5 and #6 and (#7 or #8 or #9) and #10");
        } else {
            filter.getFilterItems().add(new FilterItemInfo("period.id", (Object)period.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("company", (Object)company.getId()));
            filter.getFilterItems().add(new FilterItemInfo("checkedStatus", (Object)new Integer(2), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("fiVouchered", (Object)"1", CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("billtype", null, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("billtype", (Object)"9000", CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("billtype", (Object)"14000", CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("hasDepartmentChanged", (Object)new Integer(1)));
            filter.setMaskString("#0 and #1 and #2 and #3 and (#4 or #5 or #6) and #7");
        }
        return filter;
    }

    private static boolean isAccountEqual(AccountViewInfo src, AccountViewInfo target) {
        if (src == null && target != null || src != null && target == null) {
            return false;
        }
        if (src == null && target == null) {
            return true;
        }
        return src.getId().toString().equals(target.getId().toString());
    }
}

