/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app.periodclose;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaCurCardCollection;
import com.kingdee.eas.fi.fa.manage.FaDepCalFacadeFactory;
import com.kingdee.eas.fi.fa.manage.FaDepCalcForCoalFacadeFactory;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.IFaDepCalFacade;
import com.kingdee.eas.fi.fa.manage.IFaDepCalcForCoalFacade;
import com.kingdee.eas.fi.fa.manage.app.FaDepLocalUtils;
import com.kingdee.eas.fi.fa.manage.app.FaDepORMapping;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.fa.manage.app.periodclose.AbstractFaCheckBeforePeriodClose;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.sql.SQLException;
import java.util.HashMap;

public class FaDepreciationCheckBeforePeriodClose
extends AbstractFaCheckBeforePeriodClose {
    @Override
    protected void checkBeforeCarrayForward(Context ctx, PeriodInfo period, CompanyOrgUnitInfo company, HashMap<String, Boolean> hmPara) throws BOSException, EASBizException {
        boolean isCheckDep = hmPara.get("isCheckDep");
        boolean isCheckVoucher = hmPara.get("isCheckVoucher");
        if (FaDepreciationCheckBeforePeriodClose.hasCleanNDepre(ctx, company, period)) {
            throw new EASBizException(new NumericExceptionSubItem("1", this.getResource(ctx, "com.kingdee.eas.fi.fa.manage.FaPeriodClose", "forward_HasCleanNDepre")));
        }
        boolean hasNoAudit = FaDepORMapping.hasNoAudit(ctx, period.getPeriodYear(), period.getPeriodNumber(), company.getId().toString());
        if (hasNoAudit) {
            throw new EASBizException(new NumericExceptionSubItem("1", this.getResource(ctx, "com.kingdee.eas.fi.fa.manage.FaDepreciationResource", "FaDepCal_NoAudit") + "," + this.getResource(ctx, "com.kingdee.eas.fi.fa.manage.FaDepreciationResource", "FaDepCal_DoAction")));
        }
        if (isCheckDep || isCheckVoucher) {
            boolean depGenFv;
            boolean needReDep;
            IFaDepCalFacade depCal;
            FaCurCardCollection card;
            IFaDepCalcForCoalFacade depForCoalFacade = FaDepCalcForCoalFacadeFactory.getLocalInstance(ctx);
            boolean hasDep = FaDepLocalUtils.ifAlreadyCal(ctx, period, company.getId().toString());
            boolean isUseCalDepNew = FaManageUtils.getFaParamValue(ctx, "FA_201", company.getId().toString());
            if ((isCheckDep && !hasDep || isUseCalDepNew) && (card = (depCal = FaDepCalFacadeFactory.getLocalInstance(ctx)).getDepCardCollection(company)).size() > 0) {
                throw new EASBizException(new NumericExceptionSubItem("1", this.getResource(ctx, "com.kingdee.eas.fi.fa.manage.FaPeriodClose", "forward_NoDep")));
            }
            if (isCheckDep && hasDep && (needReDep = FaDepreciationCheckBeforePeriodClose.hasNeedRedoDep(ctx, company, period))) {
                throw new EASBizException(new NumericExceptionSubItem("1", this.getResource(ctx, "com.kingdee.eas.fi.fa.manage.FaPeriodClose", "forward_NeedReDep")));
            }
            boolean hasDep_Coal = depForCoalFacade.checkBeforePeriodForward(company.getId().toString());
            if (isCheckVoucher && (hasDep || hasDep_Coal) && !(depGenFv = FaDepLocalUtils.ifDepGenFV(ctx, period, company.getId().toString()))) {
                throw new EASBizException(new NumericExceptionSubItem("1", this.getResource(ctx, "com.kingdee.eas.fi.fa.manage.FaPeriodClose", "forward_DepNotGenFV")));
            }
        }
    }

    @Override
    protected void checkBeforeCarrayBack(Context ctx, PeriodInfo period, CompanyOrgUnitInfo company, HashMap<String, Boolean> hmPara) throws BOSException, EASBizException {
    }

    public static boolean hasCleanNDepre(Context ctx, CompanyOrgUnitInfo companyInfo, PeriodInfo period) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("select baseCurrency.precision where id = '" + companyInfo.getId().toString() + "'");
        int baseCurPrecision = company.getBaseCurrency() == null ? 2 : company.getBaseCurrency().getPrecision();
        StringBuffer result = new StringBuffer();
        result.append(" SELECT top 1 a.fid \n");
        result.append("   FROM t_fa_clearbillentry a INNER JOIN t_fa_fabizcard b ON a.fbizcardid = b.fid\n");
        result.append("        INNER JOIN t_fa_fabakcard c ON c.fid = b.ffabakcardid\n");
        result.append("        INNER JOIN t_fa_clearbill d ON a.fentryid = d.fid\n");
        result.append("        INNER JOIN t_fa_facurcard e ON a.fcurcardid = e.fid\n");
        result.append("        INNER JOIN t_fa_cat g ON g.fid = e.fassetcatid\n");
        result.append("        INNER JOIN t_fa_depreciationpolicy h ON g.fdepreciationpolicyid = h.fid\n");
        result.append("        INNER JOIN t_fa_depreciationmode f ON f.fid = e.fdeprmethodid\n");
        result.append("  WHERE   ROUND (a.fclraddupdep," + baseCurPrecision + ") != ROUND (a.fclrqty * c.faccudepr/c.fassetamt," + baseCurPrecision + ")\n");
        result.append("    AND d.fcompanyid = ?\n");
        result.append("    AND d.fperiodid = ?\n");
        result.append("    AND e.fhasnew != 1\n");
        result.append("    AND e.fhascleared != 0\n");
        result.append("    AND f.fnumber != '006'\n");
        result.append("    AND h.fstartdeprtime = 1\n");
        result.append("    AND e.fdeprtterm = 0\n");
        result.append("    AND e.FDeprTermCount!=e.FUseTermCount\n");
        StringBuffer result1 = new StringBuffer();
        result1.append(" SELECT top 1 a.fid \n");
        result1.append("   FROM t_fa_clearbillentry a INNER JOIN t_fa_fabizcard b ON a.fbizcardid = b.fid\n");
        result1.append("        INNER JOIN t_fa_fabakcard c ON c.fid = b.ffabakcardid\n");
        result1.append("        INNER JOIN t_fa_clearbill d ON a.fentryid = d.fid\n");
        result1.append("        INNER JOIN t_fa_facurcard e ON a.fcurcardid = e.fid\n");
        result1.append("        INNER JOIN t_fa_cat g ON g.fid = e.fassetcatid\n");
        result1.append("        INNER JOIN t_fa_depreciationpolicy h ON g.fdepreciationpolicyid = h.fid\n");
        result1.append("        INNER JOIN t_fa_depreciationmode f ON f.fid = e.fdeprmethodid\n");
        result1.append("  WHERE ROUND (a.fclraddupdep," + baseCurPrecision + ") != ROUND ((c.FAssetValue-c.FDecValue-c.FNeatRemValue)*a.fclrqty/c.fassetamt," + baseCurPrecision + ")\n");
        result1.append("    AND d.fcompanyid = ?\n");
        result1.append("    AND d.fperiodid = ?\n");
        result1.append("    AND e.fhasnew != 1\n");
        result1.append("    AND e.fhascleared != 0\n");
        result1.append("    AND f.fnumber != '006'\n");
        result1.append("    AND h.fstartdeprtime = 1\n");
        result1.append("    AND e.fdeprtterm = 0\n");
        result1.append("    AND e.FDeprTermCount=e.FUseTermCount\n");
        result1.append("    AND h.FTailDispose=1\n");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)result.toString(), (Object[])new Object[]{companyInfo.getId().toString(), period.getId().toString()});
            if (rowSet.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    public static boolean hasNeedRedoDep(Context ctx, CompanyOrgUnitInfo company, PeriodInfo period) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select c.FID from t_fa_facurcard c ");
        sql.append(" where c.fcompanyid = '").append(company.getId()).append("' ");
        sql.append("   and c.fperiodid not in (").append(FaLocalUtils.getLaterPeriodIds(ctx, period.getId().toString())).append(") ");
        sql.append("   and c.fisNeedReDepr = 1 ");
        sql.append("   and ((c.fdeprMethodid not in (select fid from t_fa_depreciationmode where fnumber = '006' or FIsWorkLoad = 1)) ");
        sql.append("    or (c.fdeprMethodid in (select fid from T_FA_DepreciationMode where FIsWorkLoad = 1) ");
        sql.append("   and exists (");
        sql.append("select w.fid from t_fa_faworkload w ");
        sql.append(" where w.fcompanyid = '").append(company.getId()).append("' ");
        sql.append("   and w.fperiodid = '").append(period.getId()).append("' ");
        sql.append("   and w.fcorrentworkload > 0 ");
        sql.append("   and w.fcurcardid = c.fid)))");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rowSet.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }
}

