/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app.periodclose;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaCombinBillFactory;
import com.kingdee.eas.fi.fa.manage.FaDispatchBillFactory;
import com.kingdee.eas.fi.fa.manage.FaEvaluateBillFactory;
import com.kingdee.eas.fi.fa.manage.FaLeaseBillFactory;
import com.kingdee.eas.fi.fa.manage.FaLeaseInBillFactory;
import com.kingdee.eas.fi.fa.manage.FaMaintainFactory;
import com.kingdee.eas.fi.fa.manage.FaMortagBillFactory;
import com.kingdee.eas.fi.fa.manage.FaSplitBillFactory;
import com.kingdee.eas.fi.fa.manage.FaStocktakingBillFactory;
import com.kingdee.eas.fi.fa.manage.FaStocktakingTaskBillFactory;
import com.kingdee.eas.fi.fa.manage.IFaBillBase;
import com.kingdee.eas.fi.fa.manage.IFaLeaseBill;
import com.kingdee.eas.fi.fa.manage.IFaLeaseInBill;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.fa.manage.app.periodclose.AbstractFaCheckBeforePeriodClose;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.HashMap;

public class FaNewBizCheckBeforePeriodClose
extends AbstractFaCheckBeforePeriodClose {
    @Override
    protected void checkBeforeCarrayForward(Context ctx, PeriodInfo period, CompanyOrgUnitInfo company, HashMap<String, Boolean> hmPara) throws BOSException, EASBizException {
        boolean isCheckVoucher = hmPara.get("isCheckVoucher");
        this.hasFANewBiz(ctx, company, period, isCheckVoucher, company.getId().toString(), this.getFABizInterface(ctx));
    }

    @Override
    protected void checkBeforeCarrayBack(Context ctx, PeriodInfo period, CompanyOrgUnitInfo company, HashMap<String, Boolean> hmPara) throws BOSException, EASBizException {
    }

    private void hasFANewBiz(Context ctx, CompanyOrgUnitInfo company, PeriodInfo period, boolean notGenVoucher, String companyID, IFaBillBase[] faBizInterface) throws BOSException, EASBizException {
        if (period == null || period.getId() == null || companyID == null) {
            return;
        }
        String billName = "";
        boolean hasNotAudit = false;
        boolean hasVoucher = false;
        int size = faBizInterface.length;
        for (int i = 0; i < size; ++i) {
            if (faBizInterface[i] == null) continue;
            if (faBizInterface[i] instanceof IFaLeaseInBill) {
                FaLocalUtils.hasUnAuditLeaseContract(ctx, period, company.getId().toString());
            }
            billName = FaLocalUtils.getEntityAlias(ctx, faBizInterface[i].getType());
            hasNotAudit = faBizInterface[i].hasNotAuditValue(period.getId().toString(), companyID);
            if (notGenVoucher) {
                hasVoucher = faBizInterface[i].hasNotGenVoucherValue(period.getId().toString(), companyID);
                if (hasNotAudit && hasVoucher) {
                    throw new EASBizException(new NumericExceptionSubItem("1", FaLocalUtils.getResource(ctx, "com.kingdee.eas.fi.fa.manage.FaPeriodClose", "forward_NoAuditNoVoucher")), (Object[])new String[]{billName});
                }
                if (!hasNotAudit && hasVoucher) {
                    throw new EASBizException(new NumericExceptionSubItem("1", FaLocalUtils.getResource(ctx, "com.kingdee.eas.fi.fa.manage.FaPeriodClose", "forward_HasNewBiz_NoVoucher")), (Object[])new String[]{billName});
                }
            }
            if (hasNotAudit) {
                throw new EASBizException(new NumericExceptionSubItem("1", FaLocalUtils.getResource(ctx, "com.kingdee.eas.fi.fa.manage.FaPeriodClose", "forward_HasNewBiz_NoAudit")), (Object[])new String[]{billName});
            }
            if (faBizInterface[i] instanceof IFaLeaseBill) {
                FaLocalUtils.verifyLeaseBalance(ctx, notGenVoucher, period.getId().toString(), companyID);
            }
            faBizInterface[i].checkBeforePeriodClose(period.getId().toString(), companyID);
        }
    }

    private IFaBillBase[] getFABizInterface(Context ctx) throws BOSException, EASBizException {
        IFaBillBase[] faBizInterface = new IFaBillBase[]{FaSplitBillFactory.getLocalInstance(ctx), FaCombinBillFactory.getLocalInstance(ctx), FaDispatchBillFactory.getLocalInstance(ctx), FaEvaluateBillFactory.getLocalInstance(ctx), FaMortagBillFactory.getLocalInstance(ctx), FaMaintainFactory.getLocalInstance(ctx), FaLeaseInBillFactory.getLocalInstance(ctx), FaLeaseBillFactory.getLocalInstance(ctx), FaStocktakingTaskBillFactory.getLocalInstance(ctx), FaStocktakingBillFactory.getLocalInstance(ctx)};
        return faBizInterface;
    }
}

