/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app.provider;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.cdo.utils.CDOUtils;
import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SelectorInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.wssc.BillImageMapCollection;
import com.kingdee.eas.base.wssc.BillImageMapFactory;
import com.kingdee.eas.base.wssc.BillImageMapInfo;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.basedata.FaAlterModeFactory;
import com.kingdee.eas.fi.fa.basedata.FaAlterModeInfo;
import com.kingdee.eas.fi.fa.basedata.FaDepreciationModeFactory;
import com.kingdee.eas.fi.fa.basedata.FaDepreciationModeInfo;
import com.kingdee.eas.fi.fa.manage.AssistActItemInfo;
import com.kingdee.eas.fi.fa.manage.FaBizCardFactory;
import com.kingdee.eas.fi.fa.manage.FaBizCardInfo;
import com.kingdee.eas.fi.fa.manage.FaCardInfo;
import com.kingdee.eas.fi.fa.manage.FaChangeBillEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaChangeBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaChangeBillFactory;
import com.kingdee.eas.fi.fa.manage.FaChangeBillInfo;
import com.kingdee.eas.fi.fa.manage.FaCostCenterInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCostCenterCollection;
import com.kingdee.eas.fi.fa.manage.FaCurCostCenterInfo;
import com.kingdee.eas.fi.fa.manage.FaCurDepartmentCollection;
import com.kingdee.eas.fi.fa.manage.FaCurDepartmentInfo;
import com.kingdee.eas.fi.fa.manage.FaCurFacilityInfo;
import com.kingdee.eas.fi.fa.manage.FaFromUnitCatEnum;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.IFaChangeBill;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.Enum;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class FaChangeBillCardDataProvider
implements BOSQueryDelegate {
    private Context ctx = null;
    private Set ids = null;
    private IMetaDataPK qpk = null;
    private static final BigDecimal ZERO = new BigDecimal("0.00");
    private int currencyScale = 2;
    IObjectCollection dataCollection;
    private String[] numbers = new String[]{"FA_025", "FA_008", "FA_030"};
    static final String[] columsForCard = new String[]{"facilityNumber", "facilityName", "facilityName", "facilityModel", "registerDate", "quantity", "amount", "remark", "measureUnit.name", "storePlace.name", "keeper.name"};
    Logger logger = Logger.getLogger(FaChangeBillCardDataProvider.class);

    public FaChangeBillCardDataProvider(Context ctx, List id, IMetaDataPK qpk) {
        this.ctx = ctx;
        this.ids = new HashSet(id);
        this.qpk = qpk;
    }

    public IRowSet execute(BOSQueryDataSource ds) {
        IRowSet iRowSet = null;
        try {
            FaCurCardInfo info;
            this.dataCollection = new CoreBaseCollection();
            Iterator it = this.ids.iterator();
            IFaChangeBill faChangeBill = FaChangeBillFactory.getLocalInstance(this.ctx);
            while (it.hasNext()) {
                String id = (String)it.next();
                FaChangeBillInfo faChangeBillInfo = (FaChangeBillInfo)faChangeBill.getValue((IObjectPK)new ObjectUuidPK(id));
                info = this.setCardInfo(iRowSet, faChangeBillInfo);
                info.put("faChangeBillInfo", faChangeBillInfo);
                this.dataCollection.appendObject((IObjectValue)info);
            }
            if (this.dataCollection != null && this.dataCollection.size() == 1) {
                IObjectValue obj = this.dataCollection.getObject(0);
                List column = this.getAllKey(obj, "");
                column = this.beforeBuildColumn(column);
                iRowSet = this.buildRowSet(column);
            } else if (this.dataCollection != null && this.dataCollection.size() > 1) {
                List column = this.putAllFieldsInColumn();
                column = this.beforeBuildColumn(column);
                iRowSet = this.buildRowSet(column);
            } else {
                return iRowSet;
            }
            iRowSet.beforeFirst();
            for (int i = 0; i < this.dataCollection.size(); ++i) {
                IObjectValue obj = this.dataCollection.getObject(i);
                iRowSet.moveToInsertRow();
                FaChangeBillCardDataProvider.clearRow(iRowSet);
                info = (FaCurCardInfo)obj;
                FaChangeBillInfo faChangeBillInfo = (FaChangeBillInfo)info.get("faChangeBillInfo");
                this.insertRowFromInfo(this.ctx, (IObjectValue)info, iRowSet, "");
                this.afterHeadFill(this.ctx, iRowSet, faChangeBillInfo, info);
                this.insertRowFromInfo(this.ctx, iRowSet, columsForCard, faChangeBillInfo, info, "faCurFacility");
            }
            iRowSet.beforeFirst();
        }
        catch (Exception ex) {
            this.logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return iRowSet;
    }

    protected List beforeBuildColumn(List columns) throws Exception {
        if (!columns.contains("changebill.changedate")) {
            columns.add("changebill.changedate");
        }
        if (!columns.contains("changebill.changemode.name")) {
            columns.add("changebill.changemode.name");
        }
        if (!columns.contains("changebill.number")) {
            columns.add("changebill.number");
        }
        if (!columns.contains("measureUnitWL")) {
            columns.add("measureUnitWL");
        }
        if (!columns.contains("facurcostcenter.asstacttype.number")) {
            columns.add("facurcostcenter.asstacttype.number");
        }
        if (!columns.contains("originchg")) {
            columns.add("originchg");
        }
        if (!columns.contains("printdate")) {
            columns.add("printdate");
        }
        if (!columns.contains("operator")) {
            columns.add("operator");
        }
        if (!columns.contains("imageNumber")) {
            columns.add("imageNumber");
        }
        HashSet set = new HashSet();
        for (int i = 0; i < columns.size(); ++i) {
            set.add(columns.get(i));
        }
        ArrayList<String> result = new ArrayList<String>();
        if (set != null && set.size() != 0) {
            Iterator iter = set.iterator();
            while (iter.hasNext()) {
                result.add((String)iter.next());
            }
        }
        return result;
    }

    private ArrayList putAllFieldsInColumn() {
        HashSet<String> set = new HashSet<String>();
        for (IObjectValue obj : this.dataCollection) {
            ArrayList column = this.getAllKey(obj, "");
            Iterator iterB = column.iterator();
            while (iterB.hasNext()) {
                set.add((String)iterB.next());
            }
        }
        ArrayList<String> result = new ArrayList<String>();
        if (set != null && set.size() != 0) {
            Iterator iter = set.iterator();
            while (iter.hasNext()) {
                result.add((String)iter.next());
            }
        }
        return result;
    }

    protected ArrayList getAllKey(IObjectValue sourceInfo, String upper) {
        ArrayList<String> result = new ArrayList<String>();
        Enumeration enumKeys = sourceInfo.keys();
        while (enumKeys.hasMoreElements()) {
            String key = enumKeys.nextElement().toString();
            Object info = sourceInfo.get(key);
            if (info instanceof IObjectCollection) {
                IObjectCollection collection = (IObjectCollection)info;
                if (collection.size() <= 0) continue;
                AbstractObjectValue baseInfo = (AbstractObjectValue)collection.getObject(0);
                if (this.hasSameKey(upper, key)) continue;
                result.addAll(this.getAllKey((IObjectValue)baseInfo, upper + key + "."));
                continue;
            }
            if (info instanceof IObjectValue) {
                if (this.hasSameKey(upper, key)) continue;
                IObjectValue baseInfo = (IObjectValue)info;
                result.addAll(this.getAllKey(baseInfo, upper + key + "."));
                continue;
            }
            result.add(upper + key);
        }
        return result;
    }

    protected void afterHeadFill(Context ctx, IRowSet iRowSet, FaChangeBillInfo faChangeBillInfo, FaCurCardInfo info) throws Exception {
        FaChangeBillEntryCollection cc;
        String isDisDeptLName;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String currDate = dateFormat.format(new Date());
        iRowSet.updateString("printdate", currDate);
        UserInfo personInfo = UserFactory.getLocalInstance((Context)ctx).getUserInfo(ctx.getCaller());
        iRowSet.updateString("operator", personInfo.getName());
        String companyId = info.getCompany().getId().toString();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("baseCurrency.*"));
        sic.add(new SelectorItemInfo("baseCurrency.precision"));
        CompanyOrgUnitInfo curCompanyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId), sic);
        HashMap faParameter = FaManageUtils.getFAParameter(curCompanyInfo.getId());
        HashMap hmParam = FaManageUtils.getFAParameter(ctx, this.numbers, companyId);
        String string = isDisDeptLName = faParameter.get("FA_025") == null ? "false" : (String)faParameter.get("FA_025");
        if (info == null) {
            return;
        }
        FaCurCostCenterCollection collection = info.getFaCurCostCenter();
        StringBuffer costCenterName = new StringBuffer();
        for (int i = 0; i < collection.size(); ++i) {
            FaCurCostCenterInfo costCenter = collection.get(i);
            String account = costCenter.getAccountView() == null ? "" : costCenter.getAccountView().getNumber() + "-" + costCenter.getAccountView().getLongName();
            String scale = costCenter.getApportionScale() == null ? "" : costCenter.getApportionScale().toString() + "%";
            costCenterName.append(i == 0 ? "" : "; ").append("".equals(account) ? "" : account).append(" ").append(scale).append(" ").append(this.getAsstActLName(collection.get(i)));
        }
        if (!"".equals(costCenterName.toString().trim())) {
            iRowSet.updateObject("facurcostcenter.asstacttype.number", (Object)costCenterName.toString());
        }
        FaCurDepartmentCollection departmentColl = info.getFaCurDepartment();
        StringBuffer departmentsName = new StringBuffer();
        int size = departmentColl.size();
        for (int i = 0; i < size; ++i) {
            FaCurDepartmentInfo departmentInfo = departmentColl.get(i);
            if (departmentInfo == null || departmentInfo.getUseDepartment() == null) continue;
            AdminOrgUnitInfo adminOrgUnitInfo = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(departmentInfo.getUseDepartment().getId()));
            if ("true".equalsIgnoreCase(isDisDeptLName)) {
                departmentsName.append(adminOrgUnitInfo.getDisplayName());
            } else {
                departmentsName.append(adminOrgUnitInfo.getName());
            }
            departmentsName.append("; ");
        }
        if (departmentsName.length() > 0) {
            String departments = departmentsName.substring(0, departmentsName.length() - 1).toString();
            iRowSet.updateObject("facurdepartment.usedepartment.name", (Object)departments);
        }
        if (info.getEconomicPurp() != null) {
            iRowSet.updateObject("economicPurp.name", (Object)info.getEconomicPurp().getName());
        }
        if (info.getOriginType() != null) {
            iRowSet.updateObject("originType", (Object)info.getOriginType().toString());
        }
        if (info.getAccountAsset() != null) {
            AccountViewInfo acctInfo = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(info.getAccountAsset().getId()));
            iRowSet.updateObject("accountasset.name", (Object)(acctInfo.getNumber() + "-" + acctInfo.getLongName()));
        }
        if (info.getAccountAccuDepr() != null) {
            AccountViewInfo acctInfo = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(info.getAccountAccuDepr().getId()));
            iRowSet.updateObject("accountaccudepr.name", (Object)(acctInfo.getNumber() + "-" + acctInfo.getLongName()));
        }
        if (info.getAccountDecValue() != null) {
            AccountViewInfo acctInfo = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(info.getAccountDecValue().getId()));
            iRowSet.updateObject("accountdecvalue.name", (Object)(acctInfo.getNumber() + "-" + acctInfo.getLongName()));
        }
        Date changeDate = faChangeBillInfo.getChangeDate();
        String changeNumber = faChangeBillInfo.getNumber();
        String alterModeInfoName = "";
        if (faChangeBillInfo.getChangeMode().getId() != null) {
            SelectorItemCollection sic1 = new SelectorItemCollection();
            sic1.add(new SelectorItemInfo("*"));
            sic1.add(new SelectorItemInfo("originMethod.*"));
            FaAlterModeInfo alterModeInfo = FaAlterModeFactory.getLocalInstance((Context)ctx).getFaAlterModeInfo((IObjectPK)new ObjectUuidPK(faChangeBillInfo.getChangeMode().getId()), sic1);
            alterModeInfoName = alterModeInfo == null ? "" : alterModeInfo.getName();
        }
        iRowSet.updateObject("changebill.changedate", (Object)this.convertObject(changeDate));
        iRowSet.updateObject("changebill.changemode.name", (Object)alterModeInfoName);
        iRowSet.updateObject("changebill.number", (Object)changeNumber);
        iRowSet.updateObject("changebill.id", (Object)faChangeBillInfo.getId().toString());
        iRowSet.updateObject("id", (Object)faChangeBillInfo.getId().toString());
        iRowSet.updateObject("originunit", (Object)FaChangeBillCardDataProvider.transferFromUnit(ctx, info));
        if (info.getDeprMethod() != null) {
            FaDepreciationModeInfo faDepreciationModeInfo = (FaDepreciationModeInfo)FaDepreciationModeFactory.getLocalInstance((Context)ctx).getDataBaseInfo((IObjectPK)new ObjectUuidPK(info.getDeprMethod().getId()));
            if (FaManageUtils.isWorkLoadMethod((FaDepreciationModeInfo)faDepreciationModeInfo)) {
                iRowSet.updateObject("useYears", (Object)"");
            } else {
                iRowSet.updateObject("measureUnitWL", (Object)"");
            }
        }
        if (!info.isIsEvaledBefore()) {
            iRowSet.updateObject("initEvalValue", (Object)"");
            iRowSet.updateObject("evalLeftPeriod", (Object)"");
        }
        int currencyScale = 2;
        currencyScale = info.getCurrency().getPrecision();
        FaChangeBillInfo bill = faChangeBillInfo;
        if (bill != null && bill.getChangeBillEntry() != null && (cc = bill.getChangeBillEntry()).size() > 0) {
            FaChangeBillEntryInfo ef = cc.get(0);
            iRowSet.updateObject("originchg", (Object)FaChangeBillCardDataProvider.transBigDecimalToStr(ef.getOriginChg(), currencyScale));
        }
        int quantityScale = Integer.valueOf(hmParam.get("FA_008") == null ? "0" : (String)hmParam.get("FA_008"));
        iRowSet.updateObject("assetAmt", (Object)FaChangeBillCardDataProvider.transBigDecimalToStr(info.getAssetAmt(), quantityScale));
        iRowSet.updateObject("originAmt", (Object)FaChangeBillCardDataProvider.transBigDecimalToStr(info.getOriginAmt(), currencyScale));
        int baseCurrencyScale = curCompanyInfo.getBaseCurrency().getPrecision();
        iRowSet.updateObject("assetValue", (Object)FaChangeBillCardDataProvider.transBigDecimalToStr(info.getAssetValue(), baseCurrencyScale));
        iRowSet.updateObject("buyValue", (Object)FaChangeBillCardDataProvider.transBigDecimalToStr(info.getBuyValue(), baseCurrencyScale));
        iRowSet.updateObject("buyAccuDepr", (Object)FaChangeBillCardDataProvider.transBigDecimalToStr(info.getBuyAccuDepr(), baseCurrencyScale));
        iRowSet.updateObject("initEvalValue", (Object)FaChangeBillCardDataProvider.transBigDecimalToStr(info.getInitEvalValue(), baseCurrencyScale));
        iRowSet.updateObject("accuDepr", (Object)FaChangeBillCardDataProvider.transBigDecimalToStr(info.getAccuDepr(), baseCurrencyScale));
        iRowSet.updateObject("accuDeprTYear", (Object)FaChangeBillCardDataProvider.transBigDecimalToStr(info.getAccuDeprTYear(), baseCurrencyScale));
        iRowSet.updateObject("neatRemValue", (Object)FaChangeBillCardDataProvider.transBigDecimalToStr(info.getNeatRemValue(), baseCurrencyScale));
        iRowSet.updateObject("decValue", (Object)FaChangeBillCardDataProvider.transBigDecimalToStr(info.getDecValue(), baseCurrencyScale));
        iRowSet.updateObject("neatValue", (Object)FaChangeBillCardDataProvider.transBigDecimalToStr(info.getNeatValue(), baseCurrencyScale));
        iRowSet.updateObject("neatAmt", (Object)FaChangeBillCardDataProvider.transBigDecimalToStr(info.getNeatAmt(), baseCurrencyScale));
        iRowSet.updateObject("accuDeprAll", (Object)FaChangeBillCardDataProvider.transBigDecimalToStr(info.getAccuDeprAll(), baseCurrencyScale));
        iRowSet.updateObject("addons", (Object)FaChangeBillCardDataProvider.transBigDecimalToStr(info.getAddons(), baseCurrencyScale));
        iRowSet.updateObject("treatmentIncome", (Object)FaChangeBillCardDataProvider.transBigDecimalToStr(info.getTreatmentIncome(), baseCurrencyScale));
        iRowSet.updateObject("fairValue", (Object)FaChangeBillCardDataProvider.transBigDecimalToStr(info.getFairValue(), baseCurrencyScale));
        iRowSet.updateObject("evalLeftPeriod", (Object)FaChangeBillCardDataProvider.transBigDecimalToStr(info.getEvalLeftPeriod(), 0));
        iRowSet.updateObject("useTermCount", (Object)FaChangeBillCardDataProvider.transBigDecimalToStr(info.getUseTermCount(), 0));
        iRowSet.updateObject("deprTermCount", (Object)FaChangeBillCardDataProvider.transBigDecimalToStr(info.getDeprTermCount(), 0));
        iRowSet.updateObject("deprTermCount", (Object)FaChangeBillCardDataProvider.transBigDecimalToStr(info.getDeprTermCount(), 0));
        iRowSet.updateObject("exRate", (Object)FaChangeBillCardDataProvider.transBigDecimalToStr(info.getFairValue(), baseCurrencyScale));
        iRowSet.updateObject("accountdate", (Object)FaChangeBillCardDataProvider.transDateToStr(info.getAccountDate()));
        iRowSet.updateObject("fiAccountDate", (Object)FaChangeBillCardDataProvider.transDateToStr(info.getFiAccountDate()));
        iRowSet.updateObject("levfrdate", (Object)FaChangeBillCardDataProvider.transDateToStr(info.getLevFrDate()));
        iRowSet.updateObject("deliverdate", (Object)FaChangeBillCardDataProvider.transDateToStr(info.getDeliverDate()));
        iRowSet.updateObject("startusedate", (Object)FaChangeBillCardDataProvider.transDateToStr(info.getStartUseDate()));
        String imageNumber = this.getImageNumber(new FaChangeBillInfo().getBOSType().toString(), faChangeBillInfo.getId().toString());
        iRowSet.updateString("imageNumber", imageNumber);
    }

    private String getImageNumber(String bosType, String billID) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("bosType", (Object)bosType));
        filter.getFilterItems().add(new FilterItemInfo("billID", (Object)billID));
        BillImageMapCollection billImageMapCollection = BillImageMapFactory.getLocalInstance((Context)this.ctx).getBillImageMapCollection(view);
        if (billImageMapCollection != null && billImageMapCollection.size() > 0) {
            BillImageMapInfo billImageMapInfo = billImageMapCollection.get(0);
            return billImageMapInfo.getImageNumber();
        }
        return "";
    }

    protected void insertRowFromInfo(Context ctx, IRowSet iRowSet, String[] columns, FaChangeBillInfo faChangeBillInfo, FaCurCardInfo info, String key) throws Exception {
        IObjectCollection collection = (IObjectCollection)info.get(key);
        if (collection == null) {
            return;
        }
        if (collection.size() == 0) {
            iRowSet.insertRow();
        }
        for (int count = 0; count < collection.size(); ++count) {
            IObjectValue obj = collection.getObject(count);
            if (count != 0) {
                iRowSet.moveToInsertRow();
                FaChangeBillCardDataProvider.clearRow(iRowSet);
                this.insertRowFromInfo(ctx, (IObjectValue)info, iRowSet, "");
                this.afterHeadFill(ctx, iRowSet, faChangeBillInfo, info);
            }
            this.updateRowFromInfo(iRowSet, columns, obj, key, info);
            iRowSet.insertRow();
            iRowSet.beforeFirst();
        }
    }

    protected boolean hasSameKey(String srcString, String key) {
        if (srcString == null || key == null) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(srcString, ".");
        while (st.hasMoreTokens()) {
            if (!st.nextToken().equalsIgnoreCase(key)) continue;
            return true;
        }
        return false;
    }

    protected void insertRowFromInfo(Context ctx, IObjectValue sourceInfo, IRowSet rs, String upper) throws Exception {
        Enumeration enumKeys = sourceInfo.keys();
        while (enumKeys.hasMoreElements()) {
            String key = enumKeys.nextElement().toString();
            Object info = sourceInfo.get(key);
            if (info == null || info instanceof IObjectCollection) continue;
            if (info instanceof IObjectValue) {
                if (this.hasSameKey(upper, key)) continue;
                IObjectValue baseInfo = (IObjectValue)info;
                ICoreBase iCoreBase = (ICoreBase)CDOUtils.getBizInterface((Context)ctx, (BOSObjectType)BOSUuid.read((String)baseInfo.get("id").toString()).getType());
                try {
                    this.insertRowFromInfo(ctx, baseInfo, rs, upper + key + ".");
                }
                catch (Exception e) {
                    this.logger.error((Object)e);
                }
                continue;
            }
            try {
                rs.updateString(upper + key, this.convertObject(info));
            }
            catch (Exception ex) {
                this.logger.error((Object)ex);
            }
        }
    }

    protected void updateRowFromInfo(IRowSet rs, String[] columns, IObjectValue sourceInfo, String key, FaCurCardInfo info) throws Exception {
        int n = columns.length;
        for (int i = 0; i < n; ++i) {
            if (columns[i] == null || "".equals(columns[i])) continue;
            String[] subItems = StringUtils.split((String)columns[i], (String)".");
            IObjectValue subObj = sourceInfo;
            int l = subItems.length - 1;
            for (int k = 0; k < l && (subObj = (IObjectValue)subObj.get(subItems[k].toLowerCase())) != null; ++k) {
            }
            if (subObj == null) continue;
            try {
                rs.updateString(key.equals("") ? columns[i] : key + "." + columns[i].toLowerCase(), this.convertObject(subObj.get(subItems[subItems.length - 1])));
                continue;
            }
            catch (Exception ex) {
                this.logger.error((Object)ex);
            }
        }
        this.afterDetailFill(rs, sourceInfo, info);
    }

    protected void afterDetailFill(IRowSet rs, IObjectValue sourceInfo, FaCurCardInfo info) throws Exception {
        FaCurFacilityInfo facilityInfo = (FaCurFacilityInfo)sourceInfo;
        String companyId = info.getCompany().getId().toString();
        HashMap hmParam = FaManageUtils.getFAParameter(this.ctx, this.numbers, companyId);
        int quantityScale = Integer.valueOf(hmParam.get("FA_008") == null ? "0" : (String)hmParam.get("FA_008"));
        int currencyScale = 2;
        currencyScale = info.getCurrency().getPrecision();
        rs.updateString("faCurFacility.amount", FaChangeBillCardDataProvider.transBigDecimalToStr(facilityInfo.getAmount(), quantityScale));
        rs.updateString("faCurFacility.quantity", FaChangeBillCardDataProvider.transBigDecimalToStr(facilityInfo.getQuantity(), currencyScale));
        rs.updateString("facurfacility.registerdate", FaChangeBillCardDataProvider.transDateToStr(facilityInfo.getRegisterDate()));
    }

    protected static void clearRow(IRowSet rs) throws Exception {
        int n = rs.getRowSetMetaData().getColumnCount();
        for (int i = 1; i <= n; ++i) {
            rs.updateObject(i, (Object)"");
        }
    }

    protected IRowSet buildRowSet(List columns) throws Exception {
        DynamicRowSet rs = new DynamicRowSet(columns.size());
        for (int i = 0; i < columns.size(); ++i) {
            String values = (String)columns.get(i);
            ColInfo ci = new ColInfo();
            ci.colType = 12;
            ci.columnName = values;
            rs.setColInfo(i + 1, ci);
        }
        return rs;
    }

    protected List buildcolumns() throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        FaCurCardInfo info = new FaCurCardInfo();
        Enumeration keysEumeration = info.keys();
        int i = 0;
        while (keysEumeration.hasMoreElements()) {
            Object propertyObj = keysEumeration.nextElement();
            String keyStr = propertyObj.toString();
            list.add(keyStr);
            ++i;
        }
        list.add("originchg");
        list.add("fiAccountDate");
        list.add("operator");
        list.add("printdate");
        list.add("assetamt");
        list.add("number");
        list.add("assetname");
        list.add("accountdate");
        list.add("specs");
        list.add("mfr");
        list.add("levfrdate");
        list.add("paperno");
        list.add("origintype");
        list.add("originunit");
        list.add("originamt");
        list.add("treatmentIncome");
        list.add("fairValue");
        list.add("addons");
        list.add("assetvalue");
        list.add("buyvalue");
        list.add("buyaccudepr");
        list.add("initEvalValue");
        list.add("evalLeftPeriod");
        list.add("accuDeprAll");
        list.add("useyears");
        list.add("deliverdate");
        list.add("startusedate");
        list.add("usetermcount");
        list.add("deprtermcount");
        list.add("accudepr");
        list.add("neatremvalue");
        list.add("accudeprtyear");
        list.add("decvalue");
        list.add("neatvalue");
        list.add("neatamt");
        list.add("remark");
        list.add("neatLeftRate");
        list.add("id");
        list.add("parea");
        list.add("exrate");
        list.add("company.name");
        list.add("useStatus.name");
        list.add("dept.name");
        list.add("keeper.name");
        list.add("originmethod.name");
        list.add("currency.name");
        list.add("deprmethod.number");
        list.add("deprmethod.name");
        list.add("measureunitwl.name");
        list.add("measureunit.name");
        list.add("storecity.name");
        list.add("economicpurp.name");
        list.add("changebill.id");
        list.add("changebill.number");
        list.add("changebill.changeDate");
        list.add("changebill.changeMode.name");
        list.add("assetcat.displayName");
        list.add("facurdepartment.usedepartment.name");
        list.add("accountasset.name");
        list.add("accountaccudepr.name");
        list.add("accountdecvalue.name");
        list.add("facurfacility.facilitynumber");
        list.add("facurfacility.id");
        list.add("facurfacility.facilityname");
        list.add("facurfacility.facilitymodel");
        list.add("facurfacility.registerdate");
        list.add("facurfacility.quantity");
        list.add("facurfacility.amount");
        list.add("facurfacility.remark");
        list.add("facurfacility.measureunit.name");
        list.add("facurfacility.storeplace.name");
        list.add("facurfacility.keeper.name");
        list.add("facurcostcenter.asstacttype.number");
        list.add("facurcostcenter.apportionscale");
        list.add("facurcostcenter.id");
        list.add("facurcostcenter.accountview.name");
        list.add("facurcostcenter.costcenter.name");
        list.add("facurcostcenter.remark");
        list.add("facurcostcenter.asstActType.name");
        list.add("company");
        list.add("useStatus");
        list.add("dept");
        list.add("keeper");
        list.add("originmethod");
        list.add("currency");
        list.add("deprmethod");
        list.add("measureunitwl");
        list.add("measureunit");
        list.add("storecity");
        list.add("economicpurp");
        list.add("changebill");
        list.add("changeMode");
        list.add("assetcat");
        list.add("facurdepartment");
        list.add("usedepartment");
        list.add("accountasset");
        list.add("accountaccudepr");
        list.add("accountdecvalue");
        list.add("facurfacility");
        list.add("facurfacility");
        list.add("measureunit");
        list.add("storeplace");
        list.add("keeper");
        list.add("facurcostcenter");
        list.add("asstacttype");
        list.add("apportionscale");
        list.add("facurcostcenter");
        list.add("accountview");
        list.add("accountview");
        list.add("costcenter");
        list.add("sstActType");
        return list;
    }

    private FaCurCardInfo setCardInfo(IRowSet iRowSet, FaChangeBillInfo dataObject) throws SQLException {
        FaChangeBillInfo changeBillInfo = dataObject;
        FaBizCardInfo bizCardInfo = changeBillInfo.getChangeBillEntry().get(0).getBizCard();
        try {
            bizCardInfo = (FaBizCardInfo)FaBizCardFactory.getLocalInstance(this.ctx).getValue((IObjectPK)new ObjectUuidPK(bizCardInfo.getId().toString()), this.getBizCardSelectors(this.getSelectors()));
        }
        catch (EASBizException e1) {
            this.logger.error((Object)e1);
        }
        catch (BOSException e1) {
            this.logger.error((Object)e1);
        }
        bizCardInfo.put("changeBill", changeBillInfo);
        FaCurCardInfo cardInfo = FaManageUtils.BizCard2CurCardKeepId(bizCardInfo);
        return cardInfo;
    }

    private SelectorItemCollection getBizCardSelectors(SelectorItemCollection curCardSelectors) {
        SelectorItemCollection bizCardSelectors = new SelectorItemCollection();
        for (int i = 0; i < curCardSelectors.size(); ++i) {
            String tmpStr = curCardSelectors.get(i).getPropertyName();
            if (tmpStr.startsWith("faCurFacility")) {
                bizCardSelectors.add(new SelectorItemInfo("faBizFacility" + tmpStr.substring("faCurFacility".length())));
                continue;
            }
            if (tmpStr.startsWith("faCurCostCenter")) {
                bizCardSelectors.add(new SelectorItemInfo("faBizCostCenter" + tmpStr.substring("faCurCostCenter".length())));
                continue;
            }
            if (tmpStr.startsWith("faCurCostCenter.faCurAsstActComposit")) {
                bizCardSelectors.add(new SelectorItemInfo("faBizCostCenter.faBizAsstActComposit" + tmpStr.substring("faCurCostCenter.faCurAsstActComposit".length())));
                continue;
            }
            if (tmpStr.startsWith("faCurDepartment")) {
                bizCardSelectors.add(new SelectorItemInfo("faBizDepartment" + tmpStr.substring("faCurDepartment".length())));
                continue;
            }
            bizCardSelectors.add(curCardSelectors.get(i));
        }
        bizCardSelectors.add(new SelectorItemInfo("faBizCostCenter.accountView.*"));
        bizCardSelectors.add(new SelectorItemInfo("faBizCostCenter.faBizAsstActComposit.*"));
        bizCardSelectors.add(new SelectorItemInfo("faBizCostCenter.faBizAsstActComposit.asstActType.*"));
        bizCardSelectors.add(new SelectorItemInfo("faBizCostCenter.faBizAsstActComposit.asstActItem.*"));
        return bizCardSelectors;
    }

    public SelectorItemCollection getSelectorsAll2() {
        SelectorItemCollection sic = new SelectorItemCollection();
        String selectorAll = "true";
        if (com.kingdee.bos.ctrl.swing.StringUtils.isEmpty((String)selectorAll)) {
            selectorAll = "true";
        }
        sic.add(new SelectorItemInfo("assetAmt"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("measureUnit.*"));
        } else {
            sic.add(new SelectorItemInfo("measureUnit.id"));
            sic.add(new SelectorItemInfo("measureUnit.number"));
            sic.add(new SelectorItemInfo("measureUnit.name"));
        }
        sic.add(new SelectorItemInfo("accountDate"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("storeCity.*"));
        } else {
            sic.add(new SelectorItemInfo("storeCity.id"));
            sic.add(new SelectorItemInfo("storeCity.number"));
            sic.add(new SelectorItemInfo("storeCity.name"));
        }
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("economicPurp.*"));
        } else {
            sic.add(new SelectorItemInfo("economicPurp.id"));
            sic.add(new SelectorItemInfo("economicPurp.number"));
            sic.add(new SelectorItemInfo("economicPurp.name"));
        }
        sic.add(new SelectorItemInfo("specs"));
        sic.add(new SelectorItemInfo("pArea"));
        sic.add(new SelectorItemInfo("mfr"));
        sic.add(new SelectorItemInfo("levFrDate"));
        sic.add(new SelectorItemInfo("paperNo"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("company.*"));
        } else {
            sic.add(new SelectorItemInfo("company.id"));
            sic.add(new SelectorItemInfo("company.number"));
            sic.add(new SelectorItemInfo("company.name"));
        }
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("dept.*"));
        } else {
            sic.add(new SelectorItemInfo("dept.id"));
            sic.add(new SelectorItemInfo("dept.number"));
            sic.add(new SelectorItemInfo("dept.name"));
        }
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("keeper.*"));
        } else {
            sic.add(new SelectorItemInfo("keeper.id"));
            sic.add(new SelectorItemInfo("keeper.number"));
            sic.add(new SelectorItemInfo("keeper.name"));
        }
        sic.add(new SelectorItemInfo("originType"));
        sic.add(new SelectorItemInfo("originUnit"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("originMethod.*"));
        } else {
            sic.add(new SelectorItemInfo("originMethod.id"));
            sic.add(new SelectorItemInfo("originMethod.number"));
            sic.add(new SelectorItemInfo("originMethod.name"));
        }
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("useStatus.*"));
        } else {
            sic.add(new SelectorItemInfo("useStatus.id"));
            sic.add(new SelectorItemInfo("useStatus.number"));
            sic.add(new SelectorItemInfo("useStatus.name"));
        }
        sic.add(new SelectorItemInfo("fiAccountDate"));
        sic.add(new SelectorItemInfo("wrtyPeriod"));
        sic.add(new SelectorItemInfo("wrtyNumber"));
        sic.add(new SelectorItemInfo("tempUseTermCount"));
        sic.add(new SelectorItemInfo("tempDeprTermCount"));
        sic.add(new SelectorItemInfo("tempDeprMethod"));
        sic.add(new SelectorItemInfo("isOveraged"));
        sic.add(new SelectorItemInfo("currency"));
        sic.add(new SelectorItemInfo("originAmt"));
        sic.add(new SelectorItemInfo("addons"));
        sic.add(new SelectorItemInfo("exRate"));
        sic.add(new SelectorItemInfo("assetValue"));
        sic.add(new SelectorItemInfo("initEvalValue"));
        sic.add(new SelectorItemInfo("buyValue"));
        sic.add(new SelectorItemInfo("buyAccuDepr"));
        sic.add(new SelectorItemInfo("evalLeftPeriod"));
        sic.add(new SelectorItemInfo("useYears"));
        sic.add(new SelectorItemInfo("deliverDate"));
        sic.add(new SelectorItemInfo("startUseDate"));
        sic.add(new SelectorItemInfo("useTermCount"));
        sic.add(new SelectorItemInfo("deprTermCount"));
        sic.add(new SelectorItemInfo("accuDepr"));
        sic.add(new SelectorItemInfo("neatRemValue"));
        sic.add(new SelectorItemInfo("accuDeprTYear"));
        sic.add(new SelectorItemInfo("decValue"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("deprMethod.*"));
        } else {
            sic.add(new SelectorItemInfo("deprMethod.id"));
            sic.add(new SelectorItemInfo("deprMethod.number"));
            sic.add(new SelectorItemInfo("deprMethod.name"));
        }
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("measureUnitWL.*"));
        } else {
            sic.add(new SelectorItemInfo("measureUnitWL.id"));
            sic.add(new SelectorItemInfo("measureUnitWL.number"));
            sic.add(new SelectorItemInfo("measureUnitWL.name"));
        }
        sic.add(new SelectorItemInfo("neatValue"));
        sic.add(new SelectorItemInfo("neatAmt"));
        sic.add(new SelectorItemInfo("accuDeprAll"));
        sic.add(new SelectorItemInfo("monthDepreRate"));
        sic.add(new SelectorItemInfo("treatmentIncome"));
        sic.add(new SelectorItemInfo("fairValue"));
        sic.add(new SelectorItemInfo("neatLeftRate"));
        sic.add(new SelectorItemInfo("addonFare"));
        sic.add(new SelectorItemInfo("inputTax"));
        sic.add(new SelectorItemInfo("evalAssetValue"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("evalDeprMode.*"));
        } else {
            sic.add(new SelectorItemInfo("evalDeprMode.id"));
            sic.add(new SelectorItemInfo("evalDeprMode.number"));
            sic.add(new SelectorItemInfo("evalDeprMode.name"));
        }
        sic.add(new SelectorItemInfo("evalMonthRate"));
        sic.add(new SelectorItemInfo("evalNeatLeftRate"));
        sic.add(new SelectorItemInfo("evalRemValue"));
        sic.add(new SelectorItemInfo("evalDecValue"));
        sic.add(new SelectorItemInfo("evalNeatValue"));
        sic.add(new SelectorItemInfo("evalNeatAmt"));
        sic.add(new SelectorItemInfo("evalDeprTTerm"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("evalMeasureUnitWL.*"));
        } else {
            sic.add(new SelectorItemInfo("evalMeasureUnitWL.id"));
            sic.add(new SelectorItemInfo("evalMeasureUnitWL.number"));
            sic.add(new SelectorItemInfo("evalMeasureUnitWL.name"));
        }
        sic.add(new SelectorItemInfo("evalYearDepr"));
        sic.add(new SelectorItemInfo("evalAddDepr"));
        sic.add(new SelectorItemInfo("evalTaxLeftPeriod"));
        sic.add(new SelectorItemInfo("evalDeprPeriodNum"));
        sic.add(new SelectorItemInfo("evalUseTermCount"));
        sic.add(new SelectorItemInfo("evalReInAccountDate"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("accountAsset.*"));
        } else {
            sic.add(new SelectorItemInfo("accountAsset.id"));
            sic.add(new SelectorItemInfo("accountAsset.number"));
            sic.add(new SelectorItemInfo("accountAsset.name"));
            sic.add(new SelectorItemInfo("accountAsset.longName"));
        }
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("accountAccuDepr.*"));
        } else {
            sic.add(new SelectorItemInfo("accountAccuDepr.id"));
            sic.add(new SelectorItemInfo("accountAccuDepr.number"));
            sic.add(new SelectorItemInfo("accountAccuDepr.name"));
            sic.add(new SelectorItemInfo("accountAccuDepr.longName"));
        }
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("accountDecValue.*"));
        } else {
            sic.add(new SelectorItemInfo("accountDecValue.id"));
            sic.add(new SelectorItemInfo("accountDecValue.number"));
            sic.add(new SelectorItemInfo("accountDecValue.name"));
            sic.add(new SelectorItemInfo("accountDecValue.longName"));
        }
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("faCurCostCenter.accountView.*"));
        } else {
            sic.add(new SelectorItemInfo("faCurCostCenter.accountView.id"));
            sic.add(new SelectorItemInfo("faCurCostCenter.accountView.name"));
            sic.add(new SelectorItemInfo("faCurCostCenter.accountView.number"));
        }
        sic.add(new SelectorItemInfo("faCurCostCenter.remark"));
        sic.add(new SelectorItemInfo("faCurCostCenter.apportionScale"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.asstActType.*"));
        } else {
            sic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.asstActType.id"));
            sic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.asstActType.name"));
            sic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.asstActType.number"));
        }
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.asstActItem.*"));
        } else {
            sic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.asstActItem.id"));
            sic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.asstActItem.name"));
            sic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.asstActItem.number"));
        }
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("faCurCostCenter.accountView.*"));
        } else {
            sic.add(new SelectorItemInfo("faCurCostCenter.accountView.id"));
        }
        sic.add(new SelectorItemInfo("faCurFacility.facilityNumber"));
        sic.add(new SelectorItemInfo("faCurFacility.facilityName"));
        sic.add(new SelectorItemInfo("faCurFacility.facilityModel"));
        sic.add(new SelectorItemInfo("faCurFacility.registerDate"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("faCurFacility.storePlace.*"));
        } else {
            sic.add(new SelectorItemInfo("faCurFacility.storePlace.id"));
            sic.add(new SelectorItemInfo("faCurFacility.storePlace.name"));
            sic.add(new SelectorItemInfo("faCurFacility.storePlace.number"));
        }
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("faCurFacility.measureUnit.*"));
        } else {
            sic.add(new SelectorItemInfo("faCurFacility.measureUnit.id"));
            sic.add(new SelectorItemInfo("faCurFacility.measureUnit.name"));
            sic.add(new SelectorItemInfo("faCurFacility.measureUnit.number"));
        }
        sic.add(new SelectorItemInfo("faCurFacility.quantity"));
        sic.add(new SelectorItemInfo("faCurFacility.amount"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("faCurFacility.keeper.*"));
        } else {
            sic.add(new SelectorItemInfo("faCurFacility.keeper.id"));
            sic.add(new SelectorItemInfo("faCurFacility.keeper.name"));
            sic.add(new SelectorItemInfo("faCurFacility.keeper.number"));
        }
        sic.add(new SelectorItemInfo("faCurFacility.remark"));
        sic.add(new SelectorItemInfo("faCurFacility.id"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("faCurDepartment.useDepartment.*"));
        } else {
            sic.add(new SelectorItemInfo("faCurDepartment.useDepartment.id"));
            sic.add(new SelectorItemInfo("faCurDepartment.useDepartment.name"));
            sic.add(new SelectorItemInfo("faCurDepartment.useDepartment.number"));
        }
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("faCurDepartment.usePerson.*"));
        } else {
            sic.add(new SelectorItemInfo("faCurDepartment.usePerson.id"));
            sic.add(new SelectorItemInfo("faCurDepartment.usePerson.name"));
            sic.add(new SelectorItemInfo("faCurDepartment.usePerson.number"));
        }
        sic.add(new SelectorItemInfo("faCurDepartment.usage"));
        sic.add(new SelectorItemInfo("faCurDepartment.remark"));
        sic.add(new SelectorItemInfo("faCurDepartment.id"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("assetCat.*"));
        } else {
            sic.add(new SelectorItemInfo("assetCat.id"));
            sic.add(new SelectorItemInfo("assetCat.number"));
            sic.add(new SelectorItemInfo("assetCat.name"));
            sic.add(new SelectorItemInfo("assetCat.displayName"));
        }
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("assetName"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("creator.*"));
        } else {
            sic.add(new SelectorItemInfo("creator.id"));
            sic.add(new SelectorItemInfo("creator.number"));
            sic.add(new SelectorItemInfo("creator.name"));
        }
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("remark"));
        sic.add(new SelectorItemInfo("oldNumber"));
        sic.add(new SelectorItemInfo("groupNumber"));
        sic.add(new SelectorItemInfo("barCode"));
        return sic;
    }

    protected SelectorItemCollection getSelectorsaAll() {
        SelectorItemCollection sic = this.getSelectorsAll2();
        SelectorItemCollection newSic = new SelectorItemCollection();
        for (int i = 0; i < sic.size(); ++i) {
            SelectorItemInfo selector = sic.get(i);
            if (selector.getPropertyName().endsWith(".*") && !selector.getPropertyName().equalsIgnoreCase("originUnit.*")) {
                String propName = selector.get("propertyName").toString();
                String prefix = propName.substring(0, propName.length() - 1);
                newSic.add(new SelectorItemInfo(prefix + "id"));
                newSic.add(new SelectorItemInfo(prefix + "name"));
                newSic.add(new SelectorItemInfo(prefix + "number"));
                continue;
            }
            newSic.add(selector);
        }
        newSic.add(new SelectorItemInfo("*"));
        newSic.add(new SelectorItemInfo("currency.id"));
        newSic.add(new SelectorItemInfo("currency.number"));
        newSic.add(new SelectorItemInfo("currency.name"));
        newSic.add(new SelectorItemInfo("currency.isoCode"));
        newSic.add(new SelectorItemInfo("currency.sign"));
        newSic.add(new SelectorItemInfo("currency.baseUnit"));
        newSic.add(new SelectorItemInfo("currency.precision"));
        newSic.add(new SelectorItemInfo("assetCat.isDeductInputTax"));
        newSic.add(new SelectorItemInfo("assetCat.isLeaf"));
        newSic.add(new SelectorItemInfo("assetCat.displayName"));
        newSic.add(new SelectorItemInfo("assetCat.calcuByEvaluate"));
        newSic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.*"));
        newSic.add(new SelectorItemInfo("assetCat.measureUnit.name"));
        newSic.add(new SelectorItemInfo("assetCat.measureUnit.number"));
        newSic.add(new SelectorItemInfo("assetCat.depreMode.number"));
        newSic.add(new SelectorItemInfo("assetCat.depreMode.name"));
        newSic.add(new SelectorItemInfo("assetCat.depreMode.isCustom"));
        newSic.add(new SelectorItemInfo("assetCat.depreMode.isWorkload"));
        newSic.add(new SelectorItemInfo("assetCat.classfication.*"));
        newSic.add(new SelectorItemInfo("assetCat.classfication.detailCollection.*"));
        newSic.add(new SelectorItemInfo("assetCat.classfication.number"));
        newSic.add(new SelectorItemInfo("assetCat.company.name"));
        newSic.add(new SelectorItemInfo("assetCat.creator.name"));
        newSic.add(new SelectorItemInfo("assetCat.creator.name"));
        newSic.add(new SelectorItemInfo("assetCat.creator.name"));
        newSic.add(new SelectorItemInfo("assetCat.creator.name"));
        newSic.add(new SelectorItemInfo("assetCat.id"));
        newSic.add(new SelectorItemInfo("assetCat.numberRule"));
        newSic.add(new SelectorItemInfo("assetCat.number"));
        newSic.add(new SelectorItemInfo("assetCat.gcUseLimitAndPureRate"));
        newSic.add(new SelectorItemInfo("dept.id"));
        newSic.add(new SelectorItemInfo("dept.name"));
        newSic.add(new SelectorItemInfo("dept.number"));
        newSic.add(new SelectorItemInfo("CU.id"));
        newSic.add(new SelectorItemInfo("CU.name"));
        newSic.add(new SelectorItemInfo("CU.number"));
        newSic.add(new SelectorItemInfo("number"));
        newSic.add(new SelectorItemInfo("effectedStatus"));
        newSic.add(new SelectorItemInfo("checkedStatus"));
        newSic.add(new SelectorItemInfo("originMethod.isLeaf"));
        newSic.add(new SelectorItemInfo("useStatus.isLeaf"));
        newSic.add(new SelectorItemInfo("useStatus.isDepreciation"));
        newSic.add(new SelectorItemInfo("economicPurp.isLeaf"));
        newSic.add(new SelectorItemInfo("dept.isLeaf"));
        newSic.add(new SelectorItemInfo("accountAsset.isLeaf"));
        newSic.add(new SelectorItemInfo("accountAccuDepr.isLeaf"));
        newSic.add(new SelectorItemInfo("accountDecValue.isLeaf"));
        newSic.add(new SelectorItemInfo("faCurFacility.seq"));
        newSic.add(new SelectorItemInfo("faCurDepartment.seq"));
        newSic.add(new SelectorItemInfo("faCurCostCenter.seq"));
        newSic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.*"));
        newSic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.asstActType.*"));
        newSic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.asstActItem.*"));
        newSic.add(new SelectorItemInfo("faCurCostCenter.accountView.isLeaf"));
        newSic.add(new SelectorItemInfo("faCurCostCenter.accountView.longName"));
        newSic.add(new SelectorItemInfo("faCurCostCenter.accountView.name"));
        newSic.add(new SelectorItemInfo("accountAsset.longName"));
        newSic.add(new SelectorItemInfo("accountAccuDepr.longName"));
        newSic.add(new SelectorItemInfo("accountDecValue.longName"));
        newSic.add(new SelectorItemInfo("company.*"));
        newSic.add(new SelectorItemInfo("company.id"));
        newSic.add(new SelectorItemInfo("company.number"));
        newSic.add(new SelectorItemInfo("company.name"));
        newSic.add(new SelectorItemInfo("deprMethod.isCustom"));
        newSic.add(new SelectorItemInfo("deprMethod.isWorkload"));
        newSic.add(new SelectorItemInfo("period.beginDate"));
        newSic.add(new SelectorItemInfo("period.endDate"));
        newSic.add(new SelectorItemInfo("period.periodYear"));
        newSic.add(new SelectorItemInfo("period.periodNumber"));
        newSic.add(new SelectorItemInfo("faCurDepartment.useDepartment.displayName"));
        newSic.add(new SelectorItemInfo("evalDeprMode.isCustom"));
        newSic.add(new SelectorItemInfo("evalDeprMode.isWorkload"));
        return newSic;
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = this.getSelectorsaAll();
        SelectorItemCollection depSic = FaManageUtils.getDepCardSelector();
        sic.add(new SelectorItemInfo("*"));
        for (int i = 0; i < depSic.size(); ++i) {
            if (sic.contains(depSic.get(i))) continue;
            sic.add(depSic.get(i));
        }
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.*"));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("deprMethod.isCustom"));
        sic.add(new SelectorItemInfo("deprMethod.isWorkload"));
        return sic;
    }

    protected String convertObject(Object o) {
        if (o == null) {
            return "";
        }
        if (o instanceof Date) {
            return DateTimeUtils.format((Date)((Date)o), (String)"yyyy-MM-dd");
        }
        if (o instanceof Enum) {
            return ((Enum)o).getAlias();
        }
        return o.toString();
    }

    private static String transBigDecimalToStr(BigDecimal val, int scale) {
        String pattern = null;
        if (val == null) {
            return null;
        }
        val.setScale(scale, 4);
        switch (scale) {
            case 0: {
                pattern = "#,##0";
                break;
            }
            case 1: {
                pattern = "#,##0.0";
                break;
            }
            case 2: {
                pattern = "#,##0.00";
                break;
            }
            case 3: {
                pattern = "#,##0.000";
                break;
            }
            case 4: {
                pattern = "#,##0.0000";
                break;
            }
            default: {
                StringBuffer buf = new StringBuffer("#,##0.00000");
                for (int i = 5; i < scale; ++i) {
                    buf.append("0");
                }
                pattern = buf.toString();
            }
        }
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.applyPattern(pattern);
        return decimalFormat.format(val);
    }

    private static String transDateToStr(Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        return dateFormat.format(date);
    }

    private SelectorItemCollection getPrintQuerySelectors(QueryInfo queryInfo) {
        SelectorItemCollection sic = new SelectorItemCollection();
        SelectorInfo selector = queryInfo.getSelector();
        ArrayList queryFieldInfoList = selector.getFields();
        for (int i = 0; i < queryFieldInfoList.size(); ++i) {
            QueryFieldInfo queryFieldInfo = (QueryFieldInfo)queryFieldInfoList.get(i);
            sic.add(new SelectorItemInfo(queryFieldInfo.getName()));
        }
        return sic;
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("faCurCostCenter.seq"));
        sic.add(new SelectorItemInfo("faCurCostCenter.apportionScale"));
        sic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.*"));
        sic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.asstActType.id"));
        sic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.asstActType.number"));
        sic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.asstActType.name"));
        sic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.asstActItem.id"));
        sic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.asstActItem.number"));
        sic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.asstActItem.name"));
        sic.add(new SelectorItemInfo("faCurCostCenter.accountView.isLeaf"));
        sic.add(new SelectorItemInfo("faCurCostCenter.accountView.longName"));
        sic.add(new SelectorItemInfo("faCurCostCenter.accountView.id"));
        sic.add(new SelectorItemInfo("faCurCostCenter.accountView.number"));
        sic.add(new SelectorItemInfo("faCurCostCenter.accountView.name"));
        sic.add(new SelectorItemInfo("faCurDepartment.useDepartment.id"));
        sic.add(new SelectorItemInfo("faCurDepartment.useDepartment.name"));
        sic.add(new SelectorItemInfo("faCurDepartment.useDepartment.number"));
        sic.add(new SelectorItemInfo("faCurDepartment.usePerson.id"));
        sic.add(new SelectorItemInfo("faCurDepartment.usePerson.name"));
        sic.add(new SelectorItemInfo("faCurDepartment.usePerson.number"));
        sic.add(new SelectorItemInfo("faCurDepartment.usage"));
        sic.add(new SelectorItemInfo("faCurDepartment.remark"));
        sic.add(new SelectorItemInfo("faCurDepartment.id"));
        sic.add(new SelectorItemInfo("originType"));
        sic.add(new SelectorItemInfo("originUnit"));
        return sic;
    }

    private String getAsstActLName(FaCostCenterInfo costCenterInfo) {
        FaCurCostCenterInfo curCostCenter = (FaCurCostCenterInfo)costCenterInfo;
        int size = curCostCenter.getFaCurAsstActComposit().size();
        StringBuffer asstActLName = new StringBuffer("");
        for (int i = 0; i < size; ++i) {
            String asstTypeName = "";
            AsstActTypeInfo asstType = curCostCenter.getFaCurAsstActComposit().get(i).getAsstActType();
            if (asstType != null && asstType.getName() != null) {
                asstTypeName = curCostCenter.getFaCurAsstActComposit().get(i).getAsstActType().getName();
            }
            String asstItemName = "";
            AssistActItemInfo asstItem = curCostCenter.getFaCurAsstActComposit().get(i).getAsstActItem();
            if (asstItem != null && asstItem.getName() != null) {
                asstItemName = curCostCenter.getFaCurAsstActComposit().get(i).getAsstActItem().getName();
            }
            asstActLName.append(asstTypeName);
            asstActLName.append("-");
            asstActLName.append(asstItemName);
            if (i == size - 1) continue;
            asstActLName.append("/");
        }
        return asstActLName.toString();
    }

    private static String transferFromUnit(Context ctx, FaCardInfo cardInfo) {
        FaFromUnitCatEnum item = cardInfo.getOriginType();
        String id = cardInfo.getOriginUnit();
        if (id == null || id.equals("")) {
            return "";
        }
        if ((id = id.trim()).equals("")) {
            return "";
        }
        BOSUuid uuid = null;
        try {
            uuid = BOSUuid.read((String)id);
            if (uuid == null) {
                return "";
            }
            ObjectUuidPK pk = new ObjectUuidPK(uuid);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("number"));
            if (item.getValue() == 2) {
                ICompanyOrgUnit iOrgInner = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
                CompanyOrgUnitInfo org = iOrgInner.getCompanyOrgUnitInfo((IObjectPK)pk, sic);
                return org != null ? org.getName() : "";
            }
            if (item.getValue() == 1) {
                ICustomer iCustomer = CustomerFactory.getLocalInstance((Context)ctx);
                CustomerInfo info = iCustomer.getCustomerInfo((IObjectPK)pk, sic);
                return info != null ? info.getName() : "";
            }
            if (item.getValue() == 0) {
                ISupplier iSupplier = SupplierFactory.getLocalInstance((Context)ctx);
                SupplierInfo info = iSupplier.getSupplierInfo((IObjectPK)pk, sic);
                return info != null ? info.getName() : "";
            }
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }
}

