/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app.provider;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.wssc.BillImageMapCollection;
import com.kingdee.eas.base.wssc.BillImageMapFactory;
import com.kingdee.eas.base.wssc.BillImageMapInfo;
import com.kingdee.eas.basedata.assistant.AddressInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.basedata.FaDepreciationModeInfo;
import com.kingdee.eas.fi.fa.def.FaDefCommonFacadeFactory;
import com.kingdee.eas.fi.fa.def.FaDefPropertyCollection;
import com.kingdee.eas.fi.fa.def.FaDefPropertyFactory;
import com.kingdee.eas.fi.fa.def.FaDefPropertyInfo;
import com.kingdee.eas.fi.fa.def.FaDefPropertyValueInfo;
import com.kingdee.eas.fi.fa.def.IFaDefCommonFacade;
import com.kingdee.eas.fi.fa.manage.AssistActItemInfo;
import com.kingdee.eas.fi.fa.manage.FaCardInfo;
import com.kingdee.eas.fi.fa.manage.FaCostCenterInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCostCenterCollection;
import com.kingdee.eas.fi.fa.manage.FaCurCostCenterInfo;
import com.kingdee.eas.fi.fa.manage.FaCurDepartmentCollection;
import com.kingdee.eas.fi.fa.manage.FaCurDepartmentInfo;
import com.kingdee.eas.fi.fa.manage.FaCurFacilityCollection;
import com.kingdee.eas.fi.fa.manage.FaCurFacilityInfo;
import com.kingdee.eas.fi.fa.manage.FaFromUnitCatEnum;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.IFaCurCard;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.Enum;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class FaCurCardPrintCardDataProvider
implements BOSQueryDelegate {
    private Context ctx = null;
    private Set ids = null;
    private IMetaDataPK qpk = null;
    private static final BigDecimal ZERO = new BigDecimal("0.00");
    private String companyId = null;
    private CompanyOrgUnitInfo companyInfo = null;
    private int currencyScale = 2;
    private IObjectCollection dataCollection;
    protected HashMap faParameter;
    List allColumns;
    private String[] numbers = new String[]{"FA_025", "FA_008", "FA_030"};
    String[] fieldKey = new String[]{"inputTax", "assetValue", "buyValue", "buyAccuDepr", "initEvalValue", "accuDepr", "accuDeprTYear", "neatRemValue", "decValue", "neatValue", "neatAmt", "accuDeprAll", "addonFare", "fairValue", "treatmentIncome", "addons"};
    Logger logger = Logger.getLogger(FaCurCardPrintCardDataProvider.class);
    static final String[] columsForCard = new String[]{"facilityNumber", "facilityName", "facilityName", "facilityModel", "registerDate", "quantity", "amount", "remark", "measureUnit.name", "storePlace.name", "keeper.name"};

    public FaCurCardPrintCardDataProvider(Context ctx, List id, IMetaDataPK qpk) {
        this.ctx = ctx;
        this.ids = new HashSet(id);
        this.qpk = qpk;
    }

    public IRowSet execute(BOSQueryDataSource ds) {
        IRowSet iRowSet = null;
        try {
            this.dataCollection = new CoreBaseCollection();
            Iterator itor = this.ids.iterator();
            IFaCurCard iFaCurCard = FaCurCardFactory.getLocalInstance(this.ctx);
            IFaDefCommonFacade iFaDefCommonFacade = FaDefCommonFacadeFactory.getLocalInstance((Context)this.ctx);
            SelectorItemCollection selectors = FaCurCardPrintCardDataProvider.getCurCardSelectors();
            while (itor.hasNext()) {
                String id = (String)itor.next();
                FaCurCardInfo curCard = (FaCurCardInfo)iFaCurCard.getValue((IObjectPK)new ObjectUuidPK(id), selectors);
                if (curCard == null) continue;
                if (this.companyId == null) {
                    this.companyId = curCard.getCompany().getId().toString();
                }
                if (this.companyInfo == null) {
                    this.companyInfo = curCard.getCompany();
                }
                if (!curCard.isIsEvaledBefore()) {
                    curCard.setInitEvalValue(null);
                    curCard.setEvalLeftPeriod(null);
                }
                if (curCard.getPropertyValue() != null) {
                    FaDefPropertyValueInfo pv = iFaDefCommonFacade.getPropertyValueById(curCard.getPropertyValue().getId().toString());
                    curCard.put("def", pv);
                }
                FaCurCardPrintCardDataProvider.insertNullCardInfo(curCard);
                this.setProperPrecision(curCard, curCard.getCurrency().getPrecision());
                this.dataCollection.appendObject((IObjectValue)curCard);
            }
            if (this.dataCollection != null && this.dataCollection.size() == 1) {
                IObjectValue obj = this.dataCollection.getObject(0);
                List column = this.getAllKey(obj, "");
                column = this.beforeBuildColumn(column);
                iRowSet = this.buildRowSet(column);
            } else if (this.dataCollection != null && this.dataCollection.size() > 1) {
                List column = this.putAllFieldsInColumn();
                column = this.beforeBuildColumn(column);
                iRowSet = this.buildRowSet(column);
            } else {
                return iRowSet;
            }
            iRowSet.beforeFirst();
            for (int i = 0; i < this.dataCollection.size(); ++i) {
                IObjectValue obj = this.dataCollection.getObject(i);
                iRowSet.moveToInsertRow();
                this.clearRow(iRowSet);
                FaCurCardInfo info = (FaCurCardInfo)obj;
                this.insertRowFromInfo(obj, iRowSet, "");
                this.afterHeadFill(iRowSet, obj);
                this.insertRowFromInfo(iRowSet, columsForCard, obj, "faCurFacility", info);
            }
            iRowSet.beforeFirst();
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return iRowSet;
    }

    private String getImageNumber(String bosType, String billID) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("bosType", (Object)bosType));
        filter.getFilterItems().add(new FilterItemInfo("billID", (Object)billID));
        BillImageMapCollection billImageMapCollection = BillImageMapFactory.getLocalInstance((Context)this.ctx).getBillImageMapCollection(view);
        if (billImageMapCollection != null && billImageMapCollection.size() > 0) {
            BillImageMapInfo billImageMapInfo = billImageMapCollection.get(0);
            return billImageMapInfo.getImageNumber();
        }
        return "";
    }

    private String getAsstActLName(FaCostCenterInfo costCenterInfo) {
        FaCurCostCenterInfo curCostCenter = (FaCurCostCenterInfo)costCenterInfo;
        int size = curCostCenter.getFaCurAsstActComposit().size();
        StringBuffer asstActLName = new StringBuffer("");
        for (int i = 0; i < size; ++i) {
            String asstTypeName = "";
            AsstActTypeInfo asstType = curCostCenter.getFaCurAsstActComposit().get(i).getAsstActType();
            if (asstType != null && asstType.getName() != null) {
                asstTypeName = curCostCenter.getFaCurAsstActComposit().get(i).getAsstActType().getName();
            }
            String asstItemName = "";
            AssistActItemInfo asstItem = curCostCenter.getFaCurAsstActComposit().get(i).getAsstActItem();
            if (asstItem != null && asstItem.getName() != null) {
                asstItemName = curCostCenter.getFaCurAsstActComposit().get(i).getAsstActItem().getName();
            }
            asstActLName.append(asstTypeName);
            asstActLName.append("-");
            asstActLName.append(asstItemName);
            if (i == size - 1) continue;
            asstActLName.append("/");
        }
        return asstActLName.toString();
    }

    private static String transferFromUnit(Context ctx, FaCardInfo cardInfo) {
        FaFromUnitCatEnum item = cardInfo.getOriginType();
        String id = cardInfo.getOriginUnit();
        if (id == null || id.equals("")) {
            return "";
        }
        if ((id = id.trim()).equals("")) {
            return "";
        }
        BOSUuid uuid = null;
        try {
            uuid = BOSUuid.read((String)id);
            if (uuid == null) {
                return "";
            }
            ObjectUuidPK pk = new ObjectUuidPK(uuid);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("number"));
            if (item.getValue() == 2) {
                ICompanyOrgUnit iOrgInner = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
                CompanyOrgUnitInfo org = iOrgInner.getCompanyOrgUnitInfo((IObjectPK)pk, sic);
                return org != null ? org.getName() : "";
            }
            if (item.getValue() == 1) {
                ICustomer iCustomer = CustomerFactory.getLocalInstance((Context)ctx);
                CustomerInfo info = iCustomer.getCustomerInfo((IObjectPK)pk, sic);
                return info != null ? info.getName() : "";
            }
            if (item.getValue() == 0) {
                ISupplier iSupplier = SupplierFactory.getLocalInstance((Context)ctx);
                SupplierInfo info = iSupplier.getSupplierInfo((IObjectPK)pk, sic);
                return info != null ? info.getName() : "";
            }
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }

    protected IRowSet buildRowSet(List columns) throws Exception {
        this.allColumns = columns;
        DynamicRowSet rs = new DynamicRowSet(columns.size());
        for (int i = 0; i < columns.size(); ++i) {
            String values = (String)columns.get(i);
            ColInfo ci = new ColInfo();
            ci.colType = 12;
            ci.columnName = values;
            rs.setColInfo(i + 1, ci);
        }
        return rs;
    }

    protected void clearRow(IRowSet rs) throws Exception {
        int n = rs.getRowSetMetaData().getColumnCount();
        for (int i = 1; i <= n; ++i) {
            rs.updateObject(i, (Object)"");
        }
    }

    protected void afterDetailFill(IRowSet rs, IObjectValue sourceInfo, FaCurCardInfo info) throws Exception {
        FaCurFacilityInfo facilityInfo = (FaCurFacilityInfo)sourceInfo;
        String companyId = info.getCompany().getId().toString();
        HashMap hmParam = FaManageUtils.getFAParameter(this.ctx, this.numbers, companyId);
        int quantityScale = Integer.valueOf(hmParam.get("FA_008") == null ? "0" : (String)hmParam.get("FA_008"));
        int currencyScale = 2;
        currencyScale = info.getCurrency().getPrecision();
        rs.updateString("faCurFacility.amount", FaCurCardPrintCardDataProvider.transBigDecimalToStr(facilityInfo.getAmount(), quantityScale));
        rs.updateString("faCurFacility.quantity", FaCurCardPrintCardDataProvider.transBigDecimalToStr(facilityInfo.getQuantity(), currencyScale));
        rs.updateString("facurfacility.registerdate", FaCurCardPrintCardDataProvider.transDateToStr(facilityInfo.getRegisterDate()));
    }

    private static String transBigDecimalToStr(BigDecimal val, int scale) {
        String pattern = null;
        if (val == null) {
            return null;
        }
        val.setScale(scale, 4);
        switch (scale) {
            case 0: {
                pattern = "#,##0";
                break;
            }
            case 1: {
                pattern = "#,##0.0";
                break;
            }
            case 2: {
                pattern = "#,##0.00";
                break;
            }
            case 3: {
                pattern = "#,##0.000";
                break;
            }
            case 4: {
                pattern = "#,##0.0000";
                break;
            }
            default: {
                StringBuffer buf = new StringBuffer("#,##0.00000");
                for (int i = 5; i < scale; ++i) {
                    buf.append("0");
                }
                pattern = buf.toString();
            }
        }
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.applyPattern(pattern);
        return decimalFormat.format(val);
    }

    private static String transDateToStr(Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        return dateFormat.format(date);
    }

    protected String convertObject(Object o) {
        if (o == null) {
            return "";
        }
        if (o instanceof Date) {
            return DateTimeUtils.format((Date)((Date)o), (String)"yyyy-MM-dd");
        }
        if (o instanceof Enum) {
            return ((Enum)o).getAlias();
        }
        return o.toString();
    }

    public static SelectorItemCollection getCurCardSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("assetAmt"));
        sic.add(new SelectorItemInfo("measureunit.name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("assetName"));
        sic.add(new SelectorItemInfo("wrtyPeriod"));
        sic.add(new SelectorItemInfo("wrtyNumber"));
        sic.add(new SelectorItemInfo("accountDate"));
        sic.add(new SelectorItemInfo("storecity.name"));
        sic.add(new SelectorItemInfo("specs"));
        sic.add(new SelectorItemInfo("pArea"));
        sic.add(new SelectorItemInfo("mfr"));
        sic.add(new SelectorItemInfo("levFrDate"));
        sic.add(new SelectorItemInfo("paperNo"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("dept.name"));
        sic.add(new SelectorItemInfo("keeper.name"));
        sic.add(new SelectorItemInfo("originType"));
        sic.add(new SelectorItemInfo("originUnit"));
        sic.add(new SelectorItemInfo("remark"));
        sic.add(new SelectorItemInfo("originMethod.name"));
        sic.add(new SelectorItemInfo("useStatus.name"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("originAmt"));
        sic.add(new SelectorItemInfo("addons"));
        sic.add(new SelectorItemInfo("exRate"));
        sic.add(new SelectorItemInfo("assetValue"));
        sic.add(new SelectorItemInfo("initEvalValue"));
        sic.add(new SelectorItemInfo("buyValue"));
        sic.add(new SelectorItemInfo("buyAccuDepr"));
        sic.add(new SelectorItemInfo("evalLeftPeriod"));
        sic.add(new SelectorItemInfo("useYears"));
        sic.add(new SelectorItemInfo("deliverDate"));
        sic.add(new SelectorItemInfo("startUseDate"));
        sic.add(new SelectorItemInfo("useTermCount"));
        sic.add(new SelectorItemInfo("deprTermCount"));
        sic.add(new SelectorItemInfo("accuDepr"));
        sic.add(new SelectorItemInfo("neatRemValue"));
        sic.add(new SelectorItemInfo("accuDeprTYear"));
        sic.add(new SelectorItemInfo("decValue"));
        sic.add(new SelectorItemInfo("deprMethod.number"));
        sic.add(new SelectorItemInfo("measureUnitWL.name"));
        sic.add(new SelectorItemInfo("neatValue"));
        sic.add(new SelectorItemInfo("neatAmt"));
        sic.add(new SelectorItemInfo("tempUseTermCount"));
        sic.add(new SelectorItemInfo("tempDeprTermCount"));
        sic.add(new SelectorItemInfo("tempDeprMethod"));
        sic.add(new SelectorItemInfo("accountasset.name"));
        sic.add(new SelectorItemInfo("accountasset.number"));
        sic.add(new SelectorItemInfo("accountaccudepr.name"));
        sic.add(new SelectorItemInfo("accountaccudepr.number"));
        sic.add(new SelectorItemInfo("accountDecValue.name"));
        sic.add(new SelectorItemInfo("accountDecValue.number"));
        sic.add(new SelectorItemInfo("accountasset.longname"));
        sic.add(new SelectorItemInfo("accountaccudepr.longname"));
        sic.add(new SelectorItemInfo("accountDecValue.longname"));
        sic.add(new SelectorItemInfo("faCurFacility.facilityNumber"));
        sic.add(new SelectorItemInfo("faCurFacility.facilityName"));
        sic.add(new SelectorItemInfo("faCurFacility.facilityModel"));
        sic.add(new SelectorItemInfo("faCurFacility.registerDate"));
        sic.add(new SelectorItemInfo("faCurFacility.storeplace.name"));
        sic.add(new SelectorItemInfo("faCurFacility.measureunit.name"));
        sic.add(new SelectorItemInfo("faCurFacility.quantity"));
        sic.add(new SelectorItemInfo("faCurFacility.amount"));
        sic.add(new SelectorItemInfo("faCurFacility.keeper.name"));
        sic.add(new SelectorItemInfo("faCurFacility.remark"));
        sic.add(new SelectorItemInfo("faCurFacility.id"));
        sic.add(new SelectorItemInfo("faCurCostCenter.accountView.name"));
        sic.add(new SelectorItemInfo("faCurCostCenter.accountView.number"));
        sic.add(new SelectorItemInfo("faCurCostCenter.accountView.longname"));
        sic.add(new SelectorItemInfo("faCurCostCenter.apportionScale"));
        sic.add(new SelectorItemInfo("faCurCostCenter.remark"));
        sic.add(new SelectorItemInfo("faCurCostCenter.id"));
        sic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.*"));
        sic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.asstActType.*"));
        sic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.asstActItem.*"));
        sic.add(new SelectorItemInfo("faCurCostCenter.asstActType.name"));
        sic.add(new SelectorItemInfo("faCurDepartment.useDepartment.*"));
        sic.add(new SelectorItemInfo("faCurDepartment.usePerson.name"));
        sic.add(new SelectorItemInfo("faCurDepartment.usage"));
        sic.add(new SelectorItemInfo("faCurDepartment.remark"));
        sic.add(new SelectorItemInfo("faCurDepartment.id"));
        sic.add(new SelectorItemInfo("accuDeprAll"));
        sic.add(new SelectorItemInfo("isOveraged"));
        sic.add(new SelectorItemInfo("economicPurp.name"));
        sic.add(new SelectorItemInfo("fairValue"));
        sic.add(new SelectorItemInfo("treatmentIncome"));
        sic.add(new SelectorItemInfo("neatLeftRate"));
        sic.add(new SelectorItemInfo("addonFare"));
        sic.add(new SelectorItemInfo("isEvaledBefore"));
        sic.add(new SelectorItemInfo("fiAccountDate"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("assetCat.isLeaf"));
        sic.add(new SelectorItemInfo("assetCat.name"));
        sic.add(new SelectorItemInfo("assetCat.displayName"));
        sic.add(new SelectorItemInfo("assetCat.calcuByEvaluate"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.DeprRule"));
        sic.add(new SelectorItemInfo("faCurFacility.seq"));
        sic.add(new SelectorItemInfo("faCurDepartment.seq"));
        sic.add(new SelectorItemInfo("faCurCostCenter.seq"));
        sic.add(new SelectorItemInfo("faCurCostCenter.asstActItem.name"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.baseCurrency.id"));
        sic.add(new SelectorItemInfo("company.baseCurrency.precision"));
        sic.add(new SelectorItemInfo("deprMethod.name"));
        sic.add(new SelectorItemInfo("deprMethod.isWorkload"));
        sic.add(new SelectorItemInfo("barCode"));
        sic.add(new SelectorItemInfo("propertyValue.id"));
        sic.add(new SelectorItemInfo("oldNumber"));
        sic.add(new SelectorItemInfo("groupNumber"));
        sic.add(new SelectorItemInfo("inputTax"));
        sic.add(new SelectorItemInfo("isDeduct"));
        sic.add(new SelectorItemInfo("taxOriginAmt"));
        sic.add(new SelectorItemInfo("inputTaxRate"));
        return sic;
    }

    public static FaCurCardInfo insertNullCardInfo(FaCurCardInfo curCard) {
        if (curCard.getKeeper() == null) {
            PersonInfo keeper = new PersonInfo();
            keeper.setName(null);
            keeper.setId(null);
            keeper.setString("name_l3", null);
            curCard.setKeeper(keeper);
        }
        if (curCard.getMeasureUnitWL() == null || !FaManageUtils.isWorkLoadMethod((FaDepreciationModeInfo)curCard.getDeprMethod())) {
            MeasureUnitInfo unitInfo = new MeasureUnitInfo();
            unitInfo.setName(null);
            unitInfo.setId(null);
            unitInfo.setString("name_l3", null);
            curCard.setMeasureUnitWL(unitInfo);
        }
        if (curCard.getFaCurFacility() != null && curCard.getFaCurFacility().size() != 0) {
            return curCard;
        }
        FaCurFacilityInfo facilityInfo = new FaCurFacilityInfo();
        facilityInfo.setFacilityNumber(null);
        facilityInfo.setFacilityModel(null);
        facilityInfo.setFacilityName(null);
        facilityInfo.setRegisterDate(null);
        facilityInfo.setQuantity(null);
        facilityInfo.setAmount(null);
        facilityInfo.setRemark(null);
        MeasureUnitInfo measureUnit = new MeasureUnitInfo();
        measureUnit.setName(null);
        facilityInfo.setMeasureUnit(measureUnit);
        AddressInfo address = new AddressInfo();
        address.setName(null);
        facilityInfo.setStorePlace(address);
        PersonInfo person = new PersonInfo();
        person.setName(null);
        facilityInfo.setKeeper(person);
        curCard.getFaCurFacility().add(facilityInfo);
        return curCard;
    }

    private void setProperPrecision(FaCurCardInfo curCard, int originScale) {
        int quantityScale = this.getQuantityScale();
        curCard.setAssetAmt(this.formatBigDecmal(curCard.getAssetAmt(), quantityScale));
        curCard.setOriginAmt(this.formatBigDecmal(curCard.getOriginAmt(), originScale));
        curCard.setAddons(this.formatBigDecmal(curCard.getAddons(), this.currencyScale));
        curCard.setAddonFare(this.formatBigDecmal(curCard.getAddonFare(), this.currencyScale));
        curCard.setAssetValue(this.formatBigDecmal(curCard.getAssetValue(), this.currencyScale));
        curCard.setBuyValue(this.formatBigDecmal(curCard.getBuyValue(), this.currencyScale));
        curCard.setBuyAccuDepr(this.formatBigDecmal(curCard.getBuyAccuDepr(), this.currencyScale));
        curCard.setUseTermCount(this.formatBigDecmal(curCard.getUseTermCount(), 0));
        curCard.setDeprTermCount(this.formatBigDecmal(curCard.getDeprTermCount(), 0));
        curCard.setAccuDepr(this.formatBigDecmal(curCard.getAccuDepr(), this.currencyScale));
        curCard.setNeatRemValue(this.formatBigDecmal(curCard.getNeatRemValue(), this.currencyScale));
        curCard.setAccuDeprTYear(this.formatBigDecmal(curCard.getAccuDeprTYear(), this.currencyScale));
        curCard.setDecValue(this.formatBigDecmal(curCard.getDecValue(), this.currencyScale));
        curCard.setNeatValue(this.formatBigDecmal(curCard.getNeatValue(), this.currencyScale));
        curCard.setNeatAmt(this.formatBigDecmal(curCard.getNeatAmt(), this.currencyScale));
        curCard.setFairValue(this.formatBigDecmal(curCard.getFairValue(), this.currencyScale));
        curCard.setTreatmentIncome(this.formatBigDecmal(curCard.getTreatmentIncome(), this.currencyScale));
        curCard.setNeatLeftRate(this.formatBigDecmal(curCard.getNeatLeftRate(), 2));
        curCard.setTaxOriginAmt(this.formatBigDecmal(curCard.getTaxOriginAmt(), this.currencyScale));
        curCard.setInputTaxRate(this.formatBigDecmal(curCard.getInputTaxRate(), this.currencyScale));
        if (curCard.getUseYears() != null) {
            curCard.setUseYears(this.formatBigDecmal(curCard.getUseYears(), 1));
        }
        if (curCard.isIsEvaledBefore()) {
            curCard.setInitEvalValue(this.formatBigDecmal(curCard.getInitEvalValue(), this.currencyScale));
            curCard.setEvalLeftPeriod(this.formatBigDecmal(curCard.getEvalLeftPeriod(), 0));
        } else {
            curCard.setInitEvalValue(null);
            curCard.setEvalLeftPeriod(null);
        }
        curCard.setAccuDeprAll(this.formatBigDecmal(curCard.getAccuDeprAll(), this.currencyScale));
        curCard.setExRate(this.formatBigDecmal(curCard.getExRate(), this.getExRateScale(curCard)));
        FaCurFacilityCollection faFacilities = curCard.getFaCurFacility();
        Iterator iter = faFacilities.iterator();
        while (iter.hasNext()) {
            FaCurFacilityInfo info = (FaCurFacilityInfo)iter.next();
            if (info.getQuantity() != null) {
                info.setQuantity(this.formatBigDecmal(info.getQuantity(), quantityScale));
            }
            if (info.getAmount() == null) continue;
            info.setAmount(this.formatBigDecmal(info.getAmount(), this.currencyScale));
        }
        FaCurCostCenterCollection costCenterCol = curCard.getFaCurCostCenter();
        if (costCenterCol != null) {
            Iterator iter2 = costCenterCol.iterator();
            while (iter2.hasNext()) {
                FaCurCostCenterInfo costCenter = (FaCurCostCenterInfo)iter2.next();
                if (costCenter.getApportionScale() == null) continue;
                costCenter.setApportionScale(this.formatBigDecmal(costCenter.getApportionScale(), 2));
            }
        }
    }

    private BigDecimal formatBigDecmal(BigDecimal data, int scale) {
        if (data == null || data.compareTo(ZERO) == 0) {
            data = ZERO;
        }
        return data.setScale(scale, 4);
    }

    private int getQuantityScale() {
        int quantityScale = 0;
        if (this.faParameter == null || this.faParameter.size() == 0) {
            try {
                this.faParameter = this.getFaParameter();
            }
            catch (EASBizException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (BOSException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (this.faParameter.get("FA_008") != null) {
            String quantiey = (String)this.faParameter.get("FA_008");
            quantityScale = Integer.valueOf(quantiey);
        }
        return quantityScale;
    }

    protected HashMap getFaParameter() throws EASBizException, BOSException {
        if (this.faParameter == null) {
            ObjectUuidPK pk = new ObjectUuidPK(this.companyId);
            HashMap<String, ObjectUuidPK> paramKeyMap = new HashMap<String, ObjectUuidPK>();
            paramKeyMap.put("FA_007", pk);
            paramKeyMap.put("FA_030", pk);
            paramKeyMap.put("FA_043", pk);
            paramKeyMap.put("FA_040", pk);
            paramKeyMap.put("FA_008", pk);
            paramKeyMap.put("FA_048", pk);
            paramKeyMap.put("FA_029", pk);
            paramKeyMap.put("FA_998", pk);
            paramKeyMap.put("FA_018", pk);
            paramKeyMap.put("FA_102", pk);
            paramKeyMap.put("FA_025", pk);
            paramKeyMap.put("G012", pk);
            this.faParameter = ParamManager.getParamHashMap(null, paramKeyMap);
        }
        return this.faParameter;
    }

    private int getExRateScale(FaCurCardInfo curCard) {
        int rateScale = 2;
        try {
            CurrencyInfo srcCyInfo = curCard.getCurrency();
            CurrencyInfo desCyInfo = this.companyInfo.getBaseCurrency();
            if (srcCyInfo != null && desCyInfo != null) {
                IExchangeRate iExchangeRate;
                ExchangeRateInfo exchangeRateInfo;
                if (srcCyInfo.getId().equals((Object)desCyInfo.getId())) {
                    rateScale = srcCyInfo.getPrecision();
                    return rateScale;
                }
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("name"));
                sic.add(new SelectorItemInfo("baseExchangeTable.*"));
                ObjectUuidPK companyPK = new ObjectUuidPK(this.companyInfo.getId());
                CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx).getCompanyOrgUnitInfo((IObjectPK)companyPK, sic);
                ExchangeTableInfo exchangeTableInfo = companyInfo.getBaseExchangeTable();
                if (exchangeTableInfo != null && (exchangeRateInfo = (iExchangeRate = ExchangeRateFactory.getLocalInstance((Context)this.ctx)).getExchangeRate((IObjectPK)new ObjectUuidPK(exchangeTableInfo.getId()), (IObjectPK)new ObjectUuidPK(srcCyInfo.getId()), (IObjectPK)new ObjectUuidPK(desCyInfo.getId()), null)) != null) {
                    rateScale = exchangeRateInfo.getPrecision();
                    return rateScale;
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return rateScale;
    }

    protected ArrayList getAllKey(IObjectValue sourceInfo, String upper) {
        ArrayList<String> result = new ArrayList<String>();
        Enumeration enumKeys = sourceInfo.keys();
        while (enumKeys.hasMoreElements()) {
            String key = enumKeys.nextElement().toString();
            Object info = sourceInfo.get(key);
            if (info instanceof IObjectCollection) {
                IObjectCollection collection = (IObjectCollection)info;
                if (collection.size() <= 0) continue;
                AbstractObjectValue baseInfo = (AbstractObjectValue)collection.getObject(0);
                if (this.hasSameKey(upper, key)) continue;
                result.addAll(this.getAllKey((IObjectValue)baseInfo, upper + key + "."));
                continue;
            }
            if (info instanceof IObjectValue) {
                if (this.hasSameKey(upper, key)) continue;
                IObjectValue baseInfo = (IObjectValue)info;
                result.addAll(this.getAllKey(baseInfo, upper + key + "."));
                continue;
            }
            result.add(upper + key);
        }
        return result;
    }

    protected List beforeBuildColumn(List columns) {
        if (!columns.contains("facurcostcenter.asstacttype.name")) {
            columns.add("facurcostcenter.asstacttype.name");
        }
        if (!columns.contains("keeper.number")) {
            columns.add("keeper.number");
        }
        if (!columns.contains("facurdepartment.usedepartment.name")) {
            columns.add("facurdepartment.usedepartment.name");
        }
        if (!columns.contains("facurdepartment.useperson.name")) {
            columns.add("facurdepartment.useperson.name");
        }
        if (!columns.contains("attachmentImage")) {
            columns.add("attachmentImage");
        }
        if (!columns.contains("operator")) {
            columns.add("operator");
        }
        if (!columns.contains("printdate")) {
            columns.add("printdate");
        }
        if (!columns.contains("imageNumber")) {
            columns.add("imageNumber");
        }
        try {
            FaDefPropertyCollection ps = FaDefPropertyFactory.getLocalInstance((Context)this.ctx).getFaDefPropertyCollection();
            for (int i = 0; i < ps.size(); ++i) {
                String key = "def." + ps.get(i).getNumber();
                if (columns.contains(key)) continue;
                columns.add(key);
            }
        }
        catch (BOSException e) {
            throw new RuntimeException(e);
        }
        return columns;
    }

    private ArrayList putAllFieldsInColumn() {
        HashSet<String> set = new HashSet<String>();
        for (IObjectValue obj : this.dataCollection) {
            ArrayList column = this.getAllKey(obj, "");
            Iterator iterB = column.iterator();
            while (iterB.hasNext()) {
                set.add((String)iterB.next());
            }
        }
        ArrayList<String> result = new ArrayList<String>();
        if (set != null && set.size() != 0) {
            Iterator iter = set.iterator();
            while (iter.hasNext()) {
                result.add((String)iter.next());
            }
        }
        return result;
    }

    protected void insertRowFromInfo(IObjectValue sourceInfo, IRowSet rs, String upper) throws Exception {
        Enumeration enumKeys = sourceInfo.keys();
        while (enumKeys.hasMoreElements()) {
            String key = enumKeys.nextElement().toString();
            Object info = sourceInfo.get(key);
            if (info == null) continue;
            if (info instanceof IObjectCollection) {
                this.logger.info((Object)"do nothing");
                continue;
            }
            if (info instanceof IObjectValue) {
                if (this.hasSameKey(upper, key)) continue;
                IObjectValue baseInfo = (IObjectValue)info;
                this.insertRowFromInfo(baseInfo, rs, upper + key + ".");
                continue;
            }
            try {
                rs.updateString(upper + key, this.convertObject(info));
            }
            catch (Exception ex) {
                this.logger.error((Object)("insertRowFromInfo(IObjectValue sourceInfo, IRowSet rs, String upper)--" + upper + key));
                this.logger.error((Object)ex);
            }
        }
    }

    protected void insertRowFromInfo(IRowSet rs, String[] columns, IObjectValue sourceInfo, String key, FaCurCardInfo cardInfo) throws Exception {
        IObjectCollection collection = (IObjectCollection)sourceInfo.get(key);
        if (collection == null) {
            return;
        }
        if (collection.size() == 0) {
            rs.insertRow();
        }
        for (int count = 0; count < collection.size(); ++count) {
            IObjectValue obj = collection.getObject(count);
            if (count != 0) {
                rs.moveToInsertRow();
                this.clearRow(rs);
                this.insertRowFromInfo(sourceInfo, rs, "");
                this.afterHeadFill(rs, sourceInfo);
            }
            this.updateRowFromInfo(rs, columns, obj, key, cardInfo);
            rs.insertRow();
        }
    }

    protected boolean hasSameKey(String srcString, String key) {
        if (srcString == null || key == null) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(srcString, ".");
        while (st.hasMoreTokens()) {
            if (!st.nextToken().equalsIgnoreCase(key)) continue;
            return true;
        }
        return false;
    }

    protected void afterHeadFill(IRowSet rs, IObjectValue sourceInfo) throws Exception {
        Object isUseGroupNumber;
        FaCurCardInfo info = (FaCurCardInfo)sourceInfo;
        if (info == null) {
            return;
        }
        UserInfo personInfo = UserFactory.getLocalInstance((Context)this.ctx).getUserInfo(this.ctx.getCaller());
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String currDate = dateFormat.format(new Date());
        rs.updateString("printdate", currDate);
        rs.updateString("operator", personInfo.getName());
        if (info.getCompany() != null && info.getCompany().getId() != null) {
            this.faParameter = FaManageUtils.getFAParameter(info.getCompany().getId(), this.ctx);
        }
        String isDisDeptLName = this.faParameter.get("FA_025") == null ? "false" : (String)this.faParameter.get("FA_025");
        FaCurCostCenterCollection collection = info.getFaCurCostCenter();
        StringBuffer costCenterName = new StringBuffer();
        for (int i = 0; i < collection.size(); ++i) {
            FaCurCostCenterInfo costCenter = collection.get(i);
            String typeName = "";
            if (costCenter.getAsstActType() != null) {
                typeName = costCenter.getAsstActType().getName() == null ? "" : costCenter.getAsstActType().getName();
            }
            String itemName = "";
            if (costCenter.getAsstActItem() != null) {
                itemName = costCenter.getAsstActItem().getName() == null ? "" : costCenter.getAsstActItem().getName();
            }
            String account = costCenter.getAccountView() == null ? "" : costCenter.getAccountView().getNumber() + "-" + costCenter.getAccountView().getLongName();
            String scale = costCenter.getApportionScale() == null ? "" : costCenter.getApportionScale().toString() + "%";
            costCenterName.append(i == 0 ? "" : "; ").append("".equals(account) ? "" : account).append(" ").append(scale).append(" ").append(this.getAsstActLName(collection.get(i)));
        }
        if (!"".equals(costCenterName.toString().trim())) {
            rs.updateString("facurcostcenter.asstActType.name", costCenterName.toString());
        } else if (this.allColumns.indexOf("facurcostcenter.asstacttype.name") >= 0) {
            rs.updateString("facurcostcenter.asstActType.name", "");
        }
        FaCurDepartmentCollection departmentColl = info.getFaCurDepartment();
        StringBuffer departmentsName = new StringBuffer();
        StringBuffer departmentsUsePerson = new StringBuffer();
        int size = departmentColl.size();
        for (int i = 0; i < size; ++i) {
            FaCurDepartmentInfo departmentInfo = departmentColl.get(i);
            if (departmentInfo != null && departmentInfo.getUseDepartment() != null) {
                if ("true".equalsIgnoreCase(isDisDeptLName)) {
                    departmentsName.append(departmentInfo.getUseDepartment().getDisplayName());
                } else {
                    departmentsName.append(departmentInfo.getUseDepartment().getName());
                }
                departmentsName.append("/");
            }
            if (departmentInfo == null || departmentInfo.getUsePerson() == null) continue;
            departmentsUsePerson.append(departmentInfo.getUsePerson().getName());
            departmentsUsePerson.append("/");
        }
        if (departmentsName.length() > 0) {
            String departments = departmentsName.substring(0, departmentsName.length() - 1);
            rs.updateString("facurdepartment.usedepartment.name", departments);
        } else if (this.allColumns.indexOf("facurdepartment.usedepartment.name") >= 0) {
            rs.updateString("facurdepartment.usedepartment.name", "");
        }
        if (departmentsUsePerson.length() > 0) {
            String personName = departmentsUsePerson.substring(0, departmentsUsePerson.length() - 1);
            rs.updateString("facurdepartment.useperson.name", personName);
        } else if (this.allColumns.indexOf("facurdepartment.useperson.name") >= 0) {
            rs.updateString("facurdepartment.useperson.name", "");
        }
        if (info.getEconomicPurp() != null) {
            rs.updateString("economicPurp.name", info.getEconomicPurp().getName());
        } else if (this.allColumns.indexOf("economicPurp.name") >= 0) {
            rs.updateString("economicPurp.name", "");
        }
        if (info.getOriginType() != null) {
            rs.updateString("originType", info.getOriginType().toString());
        } else if (this.allColumns.indexOf("originType") >= 0) {
            rs.updateString("originType", "");
        }
        rs.updateString("originunit", FaCurCardPrintCardDataProvider.transferFromUnit(this.ctx, (FaCardInfo)sourceInfo));
        if (!info.isIsEvaledBefore()) {
            rs.updateString("initEvalValue", "");
            rs.updateString("evalLeftPeriod", "");
        }
        if (info.getAccountAsset() != null) {
            rs.updateString("accountasset.name", info.getAccountAsset().getNumber() + "-" + info.getAccountAsset().getLongName());
        } else if (this.allColumns.indexOf("accountasset.name") >= 0) {
            rs.updateString("accountasset.name", "");
        }
        if (info.getAccountAccuDepr() != null) {
            rs.updateString("accountaccudepr.name", info.getAccountAccuDepr().getNumber() + "-" + info.getAccountAccuDepr().getLongName());
        } else if (this.allColumns.indexOf("accountaccudepr.name") >= 0) {
            rs.updateString("accountaccudepr.name", "");
        }
        if (info.getAccountDecValue() != null) {
            rs.updateString("accountdecvalue.name", info.getAccountDecValue().getNumber() + "-" + info.getAccountDecValue().getLongName());
        } else if (this.allColumns.indexOf("accountdecvalue.name") >= 0) {
            rs.updateString("accountdecvalue.name", "");
        }
        rs.updateString("assetAmt", FaCurCardPrintCardDataProvider.transBigDecimalToStr(info.getAssetAmt()));
        rs.updateString("originAmt", FaCurCardPrintCardDataProvider.transBigDecimalToStr(info.getOriginAmt()));
        if (info.getAssetValue() != null && info.getInputTax() != null) {
            info.setInputTax(info.getInputTax().setScale(info.getAssetValue().scale(), 4));
            rs.updateString("inputTax", FaCurCardPrintCardDataProvider.transBigDecimalToStr(info.getInputTax()));
        }
        rs.updateString("assetValue", FaCurCardPrintCardDataProvider.transBigDecimalToStr(info.getAssetValue()));
        rs.updateString("buyValue", FaCurCardPrintCardDataProvider.transBigDecimalToStr(info.getBuyValue()));
        rs.updateString("buyAccuDepr", FaCurCardPrintCardDataProvider.transBigDecimalToStr(info.getBuyAccuDepr()));
        rs.updateString("initEvalValue", FaCurCardPrintCardDataProvider.transBigDecimalToStr(info.getInitEvalValue()));
        boolean isWorkLoadMethod = FaManageUtils.isWorkLoadMethod((FaDepreciationModeInfo)info.getDeprMethod());
        if (isWorkLoadMethod) {
            if (info.getEvalLeftPeriod() != null) {
                info.setEvalLeftPeriod(info.getEvalLeftPeriod().setScale(2));
            }
            rs.updateString("evalLeftPeriod", FaCurCardPrintCardDataProvider.transBigDecimalToStr(info.getEvalLeftPeriod()));
        } else {
            if (info.getEvalLeftPeriod() != null) {
                info.setEvalLeftPeriod(info.getEvalLeftPeriod().setScale(0));
            }
            rs.updateString("evalLeftPeriod", FaCurCardPrintCardDataProvider.transBigDecimalToStr(info.getEvalLeftPeriod()));
        }
        rs.updateString("useTermCount", FaCurCardPrintCardDataProvider.transBigDecimalToStr(info.getUseTermCount()));
        rs.updateString("deprTermCount", FaCurCardPrintCardDataProvider.transBigDecimalToStr(info.getDeprTermCount()));
        rs.updateString("accuDepr", FaCurCardPrintCardDataProvider.transBigDecimalToStr(info.getAccuDepr()));
        rs.updateString("accuDeprTYear", FaCurCardPrintCardDataProvider.transBigDecimalToStr(info.getAccuDeprTYear()));
        rs.updateString("neatRemValue", FaCurCardPrintCardDataProvider.transBigDecimalToStr(info.getNeatRemValue()));
        rs.updateString("decValue", FaCurCardPrintCardDataProvider.transBigDecimalToStr(info.getDecValue()));
        rs.updateString("neatValue", FaCurCardPrintCardDataProvider.transBigDecimalToStr(info.getNeatValue()));
        rs.updateString("neatAmt", FaCurCardPrintCardDataProvider.transBigDecimalToStr(info.getNeatAmt()));
        rs.updateString("accuDeprAll", FaCurCardPrintCardDataProvider.transBigDecimalToStr(info.getAccuDeprAll()));
        rs.updateString("addonFare", FaCurCardPrintCardDataProvider.transBigDecimalToStr(info.getAddonFare()));
        rs.updateString("fairValue", FaCurCardPrintCardDataProvider.transBigDecimalToStr(info.getFairValue()));
        rs.updateString("treatmentIncome", FaCurCardPrintCardDataProvider.transBigDecimalToStr(info.getTreatmentIncome()));
        rs.updateString("addons", FaCurCardPrintCardDataProvider.transBigDecimalToStr(info.getAddons()));
        if (info.getNeatLeftRate() != null) {
            info.setNeatLeftRate(info.getNeatLeftRate().setScale(2));
            rs.updateString("neatLeftRate", FaCurCardPrintCardDataProvider.transBigDecimalToStr(info.getNeatLeftRate()));
        }
        if (info.getTaxOriginAmt() != null) {
            info.setTaxOriginAmt(info.getTaxOriginAmt().setScale(2));
            rs.updateString("taxOriginAmt", FaCurCardPrintCardDataProvider.transBigDecimalToStr(info.getTaxOriginAmt()));
        }
        if (info.getInputTaxRate() != null) {
            info.setInputTaxRate(info.getInputTaxRate().setScale(2));
            rs.updateString("inputTaxRate", FaCurCardPrintCardDataProvider.transBigDecimalToStr(info.getInputTaxRate()));
        }
        if (info.isIsDeduct()) {
            rs.updateString("isDeduct", "\u662f");
        } else {
            rs.updateString("isDeduct", "\u5426");
        }
        rs.updateString("accountdate", FaCurCardPrintCardDataProvider.transDateToStr(info.getAccountDate()));
        rs.updateString("fiAccountDate", FaCurCardPrintCardDataProvider.transDateToStr(info.getFiAccountDate()));
        rs.updateString("levfrdate", FaCurCardPrintCardDataProvider.transDateToStr(info.getLevFrDate()));
        rs.updateString("deliverdate", FaCurCardPrintCardDataProvider.transDateToStr(info.getDeliverDate()));
        rs.updateString("startusedate", FaCurCardPrintCardDataProvider.transDateToStr(info.getStartUseDate()));
        if (!(this.faParameter == null || (isUseGroupNumber = this.faParameter.get("FA_030")) != null && Boolean.valueOf(isUseGroupNumber.toString()).booleanValue())) {
            rs.updateString("groupNumber", "");
        }
        String imageNumber = this.getImageNumber(new FaCurCardInfo().getBOSType().toString(), info.getId().toString());
        rs.updateString("imageNumber", imageNumber);
        FaDefPropertyValueInfo value = (FaDefPropertyValueInfo)info.get("def");
        if (value != null) {
            int i;
            FaDefPropertyCollection pc = FaDefPropertyFactory.getLocalInstance((Context)this.ctx).getFaDefPropertyCollection();
            HashMap<String, FaDefPropertyInfo> numberMap = new HashMap<String, FaDefPropertyInfo>();
            for (i = 0; i < pc.size(); ++i) {
                numberMap.put(pc.get(i).getNumber().toLowerCase(), pc.get(i));
            }
            int n = this.allColumns.size();
            for (i = 0; i < n; ++i) {
                String key = (String)this.allColumns.get(i);
                if (!key.startsWith("def.")) continue;
                String number = key.substring(4);
                Object v = value.get(number);
                String str = null;
                if (v == null) {
                    str = "";
                } else {
                    FaDefPropertyInfo p = (FaDefPropertyInfo)numberMap.get(number.toLowerCase());
                    if (p != null) {
                        if (p.getType().getValue() == 2) {
                            Number num = (Number)v;
                            BigDecimal bg = new BigDecimal(num.doubleValue());
                            bg = bg.setScale(p.getDecimalQty(), 4);
                            str = FaCurCardPrintCardDataProvider.transBigDecimalToStr(bg);
                        } else if (p.getType().getValue() == 4) {
                            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                            str = sdf.format((Date)v);
                        } else {
                            str = String.valueOf(v);
                        }
                    } else {
                        str = String.valueOf(v);
                    }
                }
                rs.updateString(key, str);
            }
        }
    }

    protected void updateRowFromInfo(IRowSet rs, String[] columns, IObjectValue sourceInfo, String key, FaCurCardInfo cardInfo) throws Exception {
        int n = columns.length;
        for (int i = 0; i < n; ++i) {
            if (columns[i] == null || "".equals(columns[i])) continue;
            String[] subItems = StringUtils.split((String)columns[i], (String)".");
            IObjectValue subObj = sourceInfo;
            int l = subItems.length - 1;
            for (int k = 0; k < l && (subObj = (IObjectValue)subObj.get(subItems[k].toLowerCase())) != null; ++k) {
            }
            if (subObj == null) continue;
            try {
                rs.updateString(key.equals("") ? columns[i] : key + "." + columns[i].toLowerCase(), this.convertObject(subObj.get(subItems[subItems.length - 1])));
                continue;
            }
            catch (Exception ex) {
                this.logger.error((Object)("updateRowFromInfo(IRowSet rs, String[] columns, IObjectValue sourceInfo, String key)--" + new String(key.equals("") ? columns[i] : key + "." + columns[i].toLowerCase())));
                this.logger.error((Object)ex);
            }
        }
        this.afterDetailFill(rs, sourceInfo, cardInfo);
    }

    private static String transBigDecimalToStr(BigDecimal val) {
        String pattern = null;
        if (val == null) {
            return null;
        }
        int scale = val.scale();
        switch (scale) {
            case 0: {
                pattern = "#,##0";
                break;
            }
            case 1: {
                pattern = "#,##0.0";
                break;
            }
            case 2: {
                pattern = "#,##0.00";
                break;
            }
            case 3: {
                pattern = "#,##0.000";
                break;
            }
            case 4: {
                pattern = "#,##0.0000";
                break;
            }
            default: {
                StringBuffer buf = new StringBuffer("#,##0.00000");
                for (int i = 5; i < scale; ++i) {
                    buf.append("0");
                }
                pattern = buf.toString();
            }
        }
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.applyPattern(pattern);
        return decimalFormat.format(val);
    }
}

