/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app.provider;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.basedata.FaCatInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaDepEntryStatusEnum;
import com.kingdee.eas.fi.fa.manage.FaDepreciationEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaDepreciationEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaDepreciationFactory;
import com.kingdee.eas.fi.fa.manage.FaDepreciationInfo;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.IFaDepreciation;
import com.kingdee.eas.fi.fa.manage.app.provider.AbstractFaPrintManager;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class FaDepreciationDataProvider
extends AbstractFaPrintManager
implements BOSQueryDelegate {
    private Context ctx = null;
    Logger logger = Logger.getLogger(FaDepreciationDataProvider.class);
    private Set ids = null;
    private IMetaDataPK qpk = null;
    private int basePrecision = 2;
    BigDecimal ZERO;
    private BigDecimal sumDepreciationLast = this.ZERO = new BigDecimal("0.00");
    private BigDecimal sumShouldDepLast = this.ZERO;
    private BigDecimal sumNotDepLast = this.ZERO;
    private String RES_PATH = "com.kingdee.eas.fi.fa.manage.FaDepreciationResource";
    static final String[] columsForDepr = new String[]{"faCurCard.assetCat.name", "faCurCard.assetName", "faCurCard.number", "faCurCard.specs", "depreciation", "shouldDepre", "notDepre", "state"};

    public FaDepreciationDataProvider(Context ctx, List id, IMetaDataPK qpk) {
        this.ctx = ctx;
        this.ids = new HashSet(id);
        this.qpk = qpk;
    }

    @Override
    protected List beforeBuildColumn(List columns) {
        return columns;
    }

    @Override
    public IRowSet execute(BOSQueryDataSource ds) {
        try {
            this.dataCollection = new CoreBaseCollection();
            Iterator it = this.ids.iterator();
            IFaDepreciation iFaDepreciation = FaDepreciationFactory.getLocalInstance(this.ctx);
            SelectorItemCollection selectors = FaDepreciationDataProvider.getDepreciationSelectors();
            while (it.hasNext()) {
                String id = (String)it.next();
                FaDepreciationInfo faDepreciationInfo = new FaDepreciationInfo();
                faDepreciationInfo = (FaDepreciationInfo)iFaDepreciation.getValue((IObjectPK)new ObjectUuidPK(id), selectors);
                this.basePrecision = FaManageUtils.getCurrencyScale(faDepreciationInfo.getCompany(), this.ctx);
                this.setSumDepreciationData(faDepreciationInfo);
                FaDepreciationInfo faDepreciationInfoNew = new FaDepreciationInfo();
                if (faDepreciationInfo != null) {
                    faDepreciationInfoNew = this.getFaDepreciation(faDepreciationInfo);
                }
                this.dataCollection.appendObject((IObjectValue)faDepreciationInfoNew);
            }
        }
        catch (BOSException ex) {
            this.logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        catch (EASBizException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SQLException se) {
            this.logger.error((Object)se.getMessage(), (Throwable)se);
        }
        return this.getDefaltRowSet(ds, columsForDepr, "lnkfadepreentry");
    }

    public static SelectorItemCollection getDepreciationSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("period.*"));
        sic.add(new SelectorItemInfo("period.periodYear"));
        sic.add(new SelectorItemInfo("period.periodNumber"));
        sic.add(new SelectorItemInfo("lnkfadepreentry.*"));
        sic.add(new SelectorItemInfo("lnkfadepreentry.id"));
        sic.add(new SelectorItemInfo("lnkfadepreentry.depreciation"));
        sic.add(new SelectorItemInfo("lnkfadepreentry.shouldDepre"));
        sic.add(new SelectorItemInfo("lnkfadepreentry.notDepre"));
        return sic;
    }

    public FaDepreciationInfo getFaDepreciation(FaDepreciationInfo faDepreciationInfo) throws SQLException {
        FaDepreciationInfo infoNew = new FaDepreciationInfo();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT DISTINCT LNKFADEPREENTRY.FID AS LNKFADEPREENTRYID,");
        sql.append("ASSETCAT.FName_l2 AS ASSETCATNAME,");
        sql.append("FACURCARD.FNumber AS FACURCARDNUMBER,");
        sql.append("FACURCARD.FAssetName AS FACURCARDASSETNAME,");
        sql.append("FACURCARD.FSpecs AS FACURCARDSPECS,");
        sql.append("LNKFADEPREENTRY.FDepreciation AS DEPRECIATION,");
        sql.append("LNKFADEPREENTRY.FShouldDepre AS SHOULDDEPRE,");
        sql.append("LNKFADEPREENTRY.FNotDepre AS NOTDEPRE,");
        sql.append("FADEPRECIATION.FID AS ID,");
        sql.append("LNKFADEPREENTRY.FState AS STATE,");
        sql.append("COMPANY.FID AS COMPANYID");
        sql.append(" FROM T_FA_FaDepreciation AS FADEPRECIATION");
        sql.append(" INNER JOIN T_FA_FaDepreciationEntry AS LNKFADEPREENTRY ON FADEPRECIATION.FID = LNKFADEPREENTRY.FLnkFaDepreEntry");
        sql.append(" INNER JOIN T_BD_Period AS PERIOD ON FADEPRECIATION.Fperiod = PERIOD.FID");
        sql.append(" INNER JOIN T_ORG_Company AS COMPANY ON FADEPRECIATION.FCompanyID = COMPANY.FID");
        sql.append(" INNER JOIN T_FA_FaCurCard AS FACURCARD ON LNKFADEPREENTRY.FFaCurCardID = FACURCARD.FID");
        sql.append(" INNER JOIN T_FA_Cat AS ASSETCAT ON FACURCARD.FAssetCatID = ASSETCAT.FID");
        sql.append(" LEFT OUTER JOIN T_BD_Address AS STORECITY ON FACURCARD.FStoreCityID = STORECITY.FID");
        sql.append(" where FADEPRECIATION.FID='" + faDepreciationInfo.getId().toString() + "' ");
        sql.append(" AND FADEPRECIATION.FDepType=0 AND ((LNKFADEPREENTRY.FDepreciation >0) or (LNKFADEPREENTRY.FShouldDepre>0))");
        ISQLExecutor isql = SQLExecutorFactory.getLocalInstance((Context)this.ctx, (String)sql.toString());
        IRowSet rowSet = null;
        try {
            rowSet = isql.executeSQL();
            rowSet.beforeFirst();
            while (rowSet.next()) {
                FaDepreciationEntryInfo entryInfo = new FaDepreciationEntryInfo();
                FaCurCardInfo facurcard = new FaCurCardInfo();
                FaCatInfo catInfo = new FaCatInfo();
                catInfo.setName(rowSet.getString("ASSETCATNAME"));
                facurcard.setAssetCat(catInfo);
                facurcard.setNumber(rowSet.getString("FACURCARDNUMBER"));
                facurcard.setAssetName(rowSet.getString("FACURCARDASSETNAME"));
                facurcard.setSpecs(rowSet.getString("FACURCARDSPECS"));
                entryInfo.setFaCurCard(facurcard);
                entryInfo.setDepreciation(rowSet.getBigDecimal("DEPRECIATION"));
                entryInfo.setShouldDepre(rowSet.getBigDecimal("SHOULDDEPRE"));
                entryInfo.setNotDepre(rowSet.getBigDecimal("NOTDEPRE"));
                FaDepEntryStatusEnum status = FaDepEntryStatusEnum.getEnum(rowSet.getInt("STATE"));
                entryInfo.setState(status);
                infoNew.getLnkFaDepreEntry().add(entryInfo);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        infoNew.setId(faDepreciationInfo.getId());
        String periodYN = MessageFormat.format(EASResource.getString((String)this.RES_PATH, (String)"FaDepMnt_DepPeriodNumber"), faDepreciationInfo.getPeriod().getPeriodYear(), faDepreciationInfo.getPeriod().getPeriodNumber());
        infoNew.put("periodYN", periodYN);
        infoNew.setCompany(faDepreciationInfo.getCompany());
        this.sumDepreciationLast = this.sumDepreciationLast == null ? this.ZERO : this.sumDepreciationLast;
        this.sumShouldDepLast = this.sumShouldDepLast == null ? this.ZERO : this.sumShouldDepLast;
        this.sumNotDepLast = this.sumNotDepLast == null ? this.ZERO : this.sumNotDepLast;
        infoNew.put("sumDepreciationLast", this.sumDepreciationLast.setScale(this.basePrecision, 4));
        infoNew.put("sumShouldDepLast", this.sumShouldDepLast.setScale(this.basePrecision, 4));
        infoNew.put("sumNotDepLast", this.sumNotDepLast.setScale(this.basePrecision, 4));
        infoNew.put("sumAdjustLast", this.sumDepreciationLast.subtract(this.sumShouldDepLast).setScale(this.basePrecision, 4));
        return infoNew;
    }

    public void setSumDepreciationData(FaDepreciationInfo info) {
        if (info != null) {
            FaDepreciationEntryCollection entryCollection = info.getLnkFaDepreEntry();
            for (int i = 0; i < entryCollection.size(); ++i) {
                this.sumDepreciationLast = this.sumDepreciationLast.add(entryCollection.get(i).getDepreciation());
                this.sumShouldDepLast = this.sumShouldDepLast.add(entryCollection.get(i).getShouldDepre());
                this.sumNotDepLast = this.sumNotDepLast.add(entryCollection.get(i).getNotDepre());
            }
        }
    }

    @Override
    protected void afterHeadFill(IRowSet rs, IObjectValue sourceInfo) throws Exception {
    }

    @Override
    protected void afterDetailFill(IRowSet rs, IObjectValue sourceInfo) throws Exception {
        FaDepreciationEntryInfo entryInfo = (FaDepreciationEntryInfo)sourceInfo;
        BigDecimal ZERO = new BigDecimal("0.00");
        BigDecimal depreciation = entryInfo.getDepreciation() == null ? ZERO : entryInfo.getDepreciation();
        BigDecimal shouldDepre = entryInfo.getShouldDepre() == null ? ZERO : entryInfo.getShouldDepre();
        BigDecimal notDepre = entryInfo.getNotDepre() == null ? ZERO : entryInfo.getNotDepre();
        rs.updateString("lnkfadepreentry.state", entryInfo.getState().getAlias());
        rs.updateString("lnkfadepreentry.depreciation", FaDepreciationDataProvider.transBigDecimalToStr(depreciation.setScale(this.basePrecision, 4)));
        rs.updateString("lnkfadepreentry.shouldDepre", FaDepreciationDataProvider.transBigDecimalToStr(shouldDepre.setScale(this.basePrecision, 4)));
        rs.updateString("lnkfadepreentry.notDepre", FaDepreciationDataProvider.transBigDecimalToStr(notDepre.setScale(this.basePrecision, 4)));
    }

    protected IRowSet getDefaltRowSet(BOSQueryDataSource ds, String[] columns, String key) {
        IRowSet rs = null;
        try {
            if (this.dataCollection != null && this.dataCollection.size() == 1) {
                IObjectValue obj = this.dataCollection.getObject(0);
                List column = this.getAllKey(obj, "");
                column = this.beforeBuildColumn(column);
                rs = this.buildRowSet(column);
            } else if (this.dataCollection != null && this.dataCollection.size() > 1) {
                List column = this.putAllFieldsInColumn();
                column = this.beforeBuildColumn(column);
                rs = this.buildRowSet(column);
            } else {
                return rs;
            }
            rs.beforeFirst();
            for (int i = 0; i < this.dataCollection.size(); ++i) {
                IObjectValue obj = this.dataCollection.getObject(i);
                rs.moveToInsertRow();
                if (i > 0) {
                    this.clearRowSetOnContinuativePrint(rs);
                }
                this.insertRowFromInfo(obj, rs, "");
                this.afterHeadFill(rs, obj);
                this.insertRowFromInfo(rs, columns, obj, key);
            }
            rs.beforeFirst();
        }
        catch (Exception ex) {
            this.logger.error((Object)ex);
        }
        return rs;
    }

    private ArrayList putAllFieldsInColumn() {
        HashSet<String> set = new HashSet<String>();
        for (IObjectValue obj : this.dataCollection) {
            ArrayList column = this.getAllKey(obj, "");
            Iterator iterB = column.iterator();
            while (iterB.hasNext()) {
                set.add((String)iterB.next());
            }
        }
        ArrayList<String> result = new ArrayList<String>();
        if (set != null && set.size() != 0) {
            Iterator iter = set.iterator();
            while (iter.hasNext()) {
                result.add((String)iter.next());
            }
        }
        return result;
    }

    private void clearRowSetOnContinuativePrint(IRowSet rs) throws SQLException {
        Iterator iter = this.allColumns.iterator();
        while (iter.hasNext()) {
            rs.updateString((String)iter.next(), "");
        }
    }

    private static String transBigDecimalToStr(BigDecimal val) {
        String pattern = null;
        if (val == null) {
            return null;
        }
        int scale = val.scale();
        switch (scale) {
            case 0: {
                pattern = "#,##0";
                break;
            }
            case 1: {
                pattern = "#,##0.0";
                break;
            }
            case 2: {
                pattern = "#,##0.00";
                break;
            }
            case 3: {
                pattern = "#,##0.000";
                break;
            }
            case 4: {
                pattern = "#,##0.0000";
                break;
            }
            default: {
                StringBuffer buf = new StringBuffer("#,##0.00000");
                for (int i = 5; i < scale; ++i) {
                    buf.append("0");
                }
                pattern = buf.toString();
            }
        }
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.applyPattern(pattern);
        return decimalFormat.format(val);
    }
}

