/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.calctree;

import com.kingdee.bos.Context;
import com.kingdee.eas.fi.fa.manage.FaLeaseInBillNewInfo;
import com.kingdee.eas.fi.fa.manage.calctree.CalcTreeNode;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public class CalcTree {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.fa.manage.calctree.CalcTree");
    private static CalcTreeNode calcTree;

    private CalcTree() {
    }

    public static void calc(Context ctx, Object conditionValue, Map<String, Object> params, Map<String, Object> result) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InstantiationException, InvocationTargetException, ParserConfigurationException, SAXException, XPathExpressionException, IOException {
        if (calcTree == null) {
            CalcTree.initCalcTree(ctx);
        }
        ArrayList<String> queryPathList = new ArrayList<String>();
        CalcTreeNode calcTreeNode = CalcTree.queryCalcNode(conditionValue, calcTree, 0, queryPathList);
        queryPathList.add(calcTreeNode.getCalcMethod());
        String calcClass = calcTreeNode.getCalcClass();
        String calcMethod = calcTreeNode.getCalcMethod();
        Class<?> implClass = Class.forName(calcClass);
        Method implMethod = implClass.getMethod(calcMethod, Context.class, Map.class, Map.class);
        params.put("queryPathList", queryPathList);
        implMethod.invoke(implClass.newInstance(), ctx, params, result);
    }

    public static void getCalcMessage(Context ctx, Object conditionValue, Map<String, Object> params, Map<String, Object> result) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException, ParserConfigurationException, SAXException, XPathExpressionException, IOException {
        if (calcTree == null) {
            CalcTree.initCalcTree(ctx);
        }
        ArrayList<String> queryPathList = new ArrayList<String>();
        CalcTreeNode calcTreeNode = CalcTree.queryCalcNode(conditionValue, calcTree, 0, queryPathList);
        result.put("calcType", ((FaLeaseInBillNewInfo)conditionValue).get("calcType"));
        result.put("queryPathList", queryPathList);
        result.put("queryMethod", calcTreeNode.getCalcMethod());
    }

    public static List<List<String>> levelOrder() {
        ArrayList<List<String>> res = new ArrayList<List<String>>();
        if (calcTree == null) {
            return res;
        }
        LinkedList<CalcTreeNode> queue = new LinkedList<CalcTreeNode>();
        queue.addLast(calcTree);
        while (!queue.isEmpty()) {
            int size = queue.size();
            ArrayList<String> list = new ArrayList<String>();
            while (size-- > 0) {
                CalcTreeNode node = (CalcTreeNode)queue.pollFirst();
                list.add(node.getNumber() + ":" + node.getName() + ":" + node.getSonConditionType());
                if (node.getSonList() == null) continue;
                for (CalcTreeNode children : node.getSonList()) {
                    queue.addLast(children);
                }
            }
            res.add(list);
        }
        return res;
    }

    private static CalcTreeNode queryCalcNode(Object conditionObject, CalcTreeNode treeNode, int depth, ArrayList<String> queryPathList) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (treeNode == null || treeNode.isLeaf()) {
            return treeNode;
        }
        if ("calculation".equals(treeNode.getSonConditionType())) {
            queryPathList.add(treeNode.getSonList().get(0).getName());
            return CalcTree.queryCalcNode(conditionObject, treeNode.getSonList().get(0), depth + 1, queryPathList);
        }
        String conditionClass = treeNode.getConditionalJudgmentClass();
        String conditionMethod = treeNode.getConditionalJudgmentMethod();
        String conditionField = treeNode.getConditionalJudgmentField();
        Class<?> implClass = Class.forName(conditionClass);
        Class<?> fieldClass = Class.forName(conditionField);
        Method implMethod = implClass.getMethod(conditionMethod, fieldClass);
        String conditionValue = (String)implMethod.invoke(implClass.newInstance(), conditionObject);
        queryPathList.add(treeNode.getSonConditionName());
        List<CalcTreeNode> calcTreeNodes = treeNode.getSonList();
        for (CalcTreeNode tmpNode : calcTreeNodes) {
            if (!tmpNode.getConditionValue().equals(conditionValue)) continue;
            queryPathList.add(tmpNode.getName());
            return CalcTree.queryCalcNode(conditionObject, tmpNode, depth + 1, queryPathList);
        }
        return null;
    }

    private static synchronized void initCalcTree(Context ctx) throws ParserConfigurationException, IOException, SAXException, XPathExpressionException {
    }
}

