/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.calctree.calculation;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.eas.fi.fa.manage.FaLeaseInBillNewInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class TerminateBillCalc {
    public static void getPaidRentAmtForOne(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        Date initCfmDate = (Date)params.get("initCfmDate");
        Date terminateDate = (Date)params.get("terminateDate");
        boolean isDeductible = (Boolean)params.get("isDeductible");
        StringBuilder sql = new StringBuilder();
        sql.append(" select FHeadID billId, sum(" + (isDeductible ? "FPaymentWithoutTax" : "FPaymentWithTax") + ") resultNumber FROM T_FA_FaPaymentPlanNew");
        sql.append(" where FHeadID = ?");
        sql.append(" and FPayDate >= ? and FPayDate <= ?");
        sql.append(" group by FHeadID");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{leaseInBillId, new Timestamp(initCfmDate.getTime()), new Timestamp(terminateDate.getTime())});
        try {
            while (rs.next()) {
                String id = rs.getString("billId");
                BigDecimal paidRentAmt = rs.getBigDecimal("resultNumber") == null ? BigDecimal.ZERO : rs.getBigDecimal("resultNumber");
                result.put(id, paidRentAmt);
                result.put("queryPathList:" + id, params.get("queryPathList"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getPaidRentAmtForTwo(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        Date initCfmDate = (Date)params.get("initCfmDate");
        Date terminateDate = (Date)params.get("terminateDate");
        Date adjustDate = (Date)params.get("adjustDate");
        Date billBeginDate = (Date)params.get("billBeginDate");
        boolean isDeductible = (Boolean)params.get("isDeductible");
        StringBuilder sql = new StringBuilder();
        sql.append(" select FHeadID billId, sum(" + (isDeductible ? "FPaymentWithoutTax" : "FPaymentWithTax") + ") resultNumber FROM T_FA_FaPaymentPlanNew");
        sql.append(" where FHeadID = ?");
        sql.append(" and FPayDate >= ? and FPayDate <= ?");
        sql.append(" group by FHeadID");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{leaseInBillId, new Timestamp(initCfmDate.getTime()), new Timestamp(adjustDate.getTime())});
        try {
            while (rs.next()) {
                String id = rs.getString("billId");
                BigDecimal paidRentAmt = rs.getBigDecimal("resultNumber") == null ? BigDecimal.ZERO : rs.getBigDecimal("resultNumber");
                result.put(id, paidRentAmt);
                result.put("queryPathList:" + id, params.get("queryPathList"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getPaidRentAmtForThree(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        Date initCfmDate = (Date)params.get("initCfmDate");
        Date terminateDate = (Date)params.get("terminateDate");
        Date adjustDate = (Date)params.get("adjustDate");
        Date billBeginDate = (Date)params.get("billBeginDate");
        boolean isDeductible = (Boolean)params.get("isDeductible");
        StringBuilder sql = new StringBuilder();
        sql.append(" select FHeadID billId, sum(" + (isDeductible ? "FPaymentWithoutTax" : "FPaymentWithTax") + ") resultNumber FROM T_FA_FaPaymentPlanNew");
        sql.append(" where FHeadID = ?");
        sql.append(" and FPayDate >= ? and FPayDate <= ?");
        sql.append(" group by FHeadID");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{leaseInBillId, new Timestamp(billBeginDate.getTime()), new Timestamp(terminateDate.getTime())});
        try {
            while (rs.next()) {
                String id = rs.getString("billId");
                BigDecimal paidRentAmt = rs.getBigDecimal("resultNumber") == null ? BigDecimal.ZERO : rs.getBigDecimal("resultNumber");
                result.put(id, paidRentAmt);
                result.put("queryPathList:" + id, params.get("queryPathList"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getPaidRentAmtForFour(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        Date initCfmDate = (Date)params.get("initCfmDate");
        Date terminateDate = (Date)params.get("terminateDate");
        Date adjustDate = (Date)params.get("adjustDate");
        Date billBeginDate = (Date)params.get("billBeginDate");
        boolean isDeductible = (Boolean)params.get("isDeductible");
        StringBuilder sql = new StringBuilder();
        sql.append(" select FHeadID billId, sum(" + (isDeductible ? "FPaymentWithoutTax" : "FPaymentWithTax") + ") resultNumber FROM T_FA_FaPaymentPlanNew");
        sql.append(" where FHeadID = ?");
        sql.append(" and FPayDate >= ? and FPayDate <= ?");
        sql.append(" group by FHeadID");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{leaseInBillId, new Timestamp(billBeginDate.getTime()), new Timestamp(adjustDate.getTime())});
        try {
            while (rs.next()) {
                String id = rs.getString("billId");
                BigDecimal paidRentAmt = rs.getBigDecimal("resultNumber") == null ? BigDecimal.ZERO : rs.getBigDecimal("resultNumber");
                result.put(id, paidRentAmt);
                result.put("queryPathList:" + id, params.get("queryPathList"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getPaidRentAmtForFive(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        Date initCfmDate = (Date)params.get("initCfmDate");
        Date terminateDate = (Date)params.get("terminateDate");
        Date adjustDate = (Date)params.get("adjustDate");
        Date billBeginDate = (Date)params.get("billBeginDate");
        boolean isDeductible = (Boolean)params.get("isDeductible");
        StringBuilder sql = new StringBuilder();
        sql.append(" select FHeadID billId, sum(" + (isDeductible ? "FPaymentWithoutTax" : "FPaymentWithTax") + ") resultNumber FROM T_FA_FaPaymentPlanNew");
        sql.append(" where FHeadID = ?");
        sql.append(" and FPayDate <= ?");
        sql.append(" group by FHeadID");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{leaseInBillId, new Timestamp(terminateDate.getTime())});
        try {
            while (rs.next()) {
                String id = rs.getString("billId");
                BigDecimal paidRentAmt = rs.getBigDecimal("resultNumber") == null ? BigDecimal.ZERO : rs.getBigDecimal("resultNumber");
                result.put(id, paidRentAmt);
                result.put("queryPathList:" + id, params.get("queryPathList"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getPaidRentAmtForSix(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        Date initCfmDate = (Date)params.get("initCfmDate");
        Date terminateDate = (Date)params.get("terminateDate");
        Date adjustDate = (Date)params.get("adjustDate");
        Date billBeginDate = (Date)params.get("billBeginDate");
        boolean isDeductible = (Boolean)params.get("isDeductible");
        StringBuilder sql = new StringBuilder();
        sql.append(" select FHeadID billId, sum(" + (isDeductible ? "FPaymentWithoutTax" : "FPaymentWithTax") + ") resultNumber FROM T_FA_FaPaymentPlanNew");
        sql.append(" where FHeadID = ?");
        sql.append(" and FPayDate <= ?");
        sql.append(" group by FHeadID");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{leaseInBillId, new Timestamp(adjustDate.getTime())});
        try {
            while (rs.next()) {
                String id = rs.getString("billId");
                BigDecimal paidRentAmt = rs.getBigDecimal("resultNumber") == null ? BigDecimal.ZERO : rs.getBigDecimal("resultNumber");
                result.put(id, paidRentAmt);
                result.put("queryPathList:" + id, params.get("queryPathList"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getCalcAcumDepreAmtForOne(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        FaLeaseInBillNewInfo leaseInBill = (FaLeaseInBillNewInfo)params.get("leaseInBill");
        Date billEndDate = (Date)params.get("billEndDate");
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(entry.FCURDEPRECIATION) monthDep, SUM(entry.FCURINTERESTPAYMENT) monthIP");
        sql.append(" FROM T_Fa_FaAmortizedCostRpt rpt");
        sql.append(" LEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON rpt.FId = entry.FAmortizedCostRptId");
        sql.append(" WHERE rpt.FLeaseInBillId = ?");
        sql.append(" AND entry.FDate <= ?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{leaseInBillId, new Timestamp(billEndDate.getTime())});
        try {
            while (rs.next()) {
                BigDecimal monthDep = rs.getBigDecimal("monthDep") == null ? BigDecimal.ZERO : rs.getBigDecimal("monthDep");
                ((BigDecimal[])result.get((Object)leaseInBillId))[0] = monthDep.add(leaseInBill.getInitAccDepreciation());
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getCalcAcumDepreAmtForTwo(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        FaLeaseInBillNewInfo leaseInBill = (FaLeaseInBillNewInfo)params.get("leaseInBill");
        Date billEndDate = TerminateBillCalc.getMaxMonthDate((Date)params.get("billEndDate"));
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(entry.FCURDEPRECIATION) monthDep, SUM(entry.FCURINTERESTPAYMENT) monthIP");
        sql.append(" FROM T_Fa_FaAmortizedCostRpt rpt");
        sql.append(" LEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON rpt.FId = entry.FAmortizedCostRptId");
        sql.append(" WHERE rpt.FLeaseInBillId = ?");
        sql.append(" AND entry.FDate <= ?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{leaseInBillId, new Timestamp(billEndDate.getTime())});
        try {
            while (rs.next()) {
                BigDecimal monthDep = rs.getBigDecimal("monthDep") == null ? BigDecimal.ZERO : rs.getBigDecimal("monthDep");
                ((BigDecimal[])result.get((Object)leaseInBillId))[0] = monthDep.add(leaseInBill.getFinanceInitAccDepreciation());
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getCalcAcumDepreAmtForThree(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        FaLeaseInBillNewInfo leaseInBill = (FaLeaseInBillNewInfo)params.get("leaseInBill");
        Date billEndDate = TerminateBillCalc.getMaxMonthDate((Date)params.get("billEndDate"));
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(entry.FCURDEPRECIATION) monthDep, SUM(entry.FCURINTERESTPAYMENT) monthIP");
        sql.append(" FROM T_Fa_FaAmortizedCostRpt rpt");
        sql.append(" LEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON rpt.FId = entry.FAmortizedCostRptId");
        sql.append(" WHERE rpt.FLeaseInBillId = ?");
        sql.append(" AND entry.FDate <= ?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{leaseInBillId, new Timestamp(billEndDate.getTime())});
        try {
            while (rs.next()) {
                BigDecimal monthDep = rs.getBigDecimal("monthDep") == null ? BigDecimal.ZERO : rs.getBigDecimal("monthDep");
                ((BigDecimal[])result.get((Object)leaseInBillId))[0] = monthDep.add(leaseInBill.getInitAccDepreciation());
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getCalcAcumDepreAmtForFour(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        FaLeaseInBillNewInfo leaseInBill = (FaLeaseInBillNewInfo)params.get("leaseInBill");
        Date terminateDate = (Date)params.get("terminateDate");
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(entry.FCURDEPRECIATION) monthDep, SUM(entry.FCURINTERESTPAYMENT) monthIP");
        sql.append(" FROM T_Fa_FaAmortizedCostRpt rpt");
        sql.append(" LEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON rpt.FId = entry.FAmortizedCostRptId");
        sql.append(" WHERE rpt.FLeaseInBillId = ?");
        sql.append(" AND entry.FDate < ?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{leaseInBillId, new Timestamp(terminateDate.getTime())});
        try {
            while (rs.next()) {
                BigDecimal monthDep = rs.getBigDecimal("monthDep") == null ? BigDecimal.ZERO : rs.getBigDecimal("monthDep");
                ((BigDecimal[])result.get((Object)leaseInBillId))[0] = monthDep.add(leaseInBill.getInitAccDepreciation());
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getCalcAcumDepreAmtForFive(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        FaLeaseInBillNewInfo leaseInBill = (FaLeaseInBillNewInfo)params.get("leaseInBill");
        Date terminateDate = TerminateBillCalc.getMinMonthDate((Date)params.get("terminateDate"));
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(entry.FCURDEPRECIATION) monthDep, SUM(entry.FCURINTERESTPAYMENT) monthIP");
        sql.append(" FROM T_Fa_FaAmortizedCostRpt rpt");
        sql.append(" LEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON rpt.FId = entry.FAmortizedCostRptId");
        sql.append(" WHERE rpt.FLeaseInBillId = ?");
        sql.append(" AND entry.FDate < ?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{leaseInBillId, new Timestamp(terminateDate.getTime())});
        try {
            while (rs.next()) {
                BigDecimal monthDep = rs.getBigDecimal("monthDep") == null ? BigDecimal.ZERO : rs.getBigDecimal("monthDep");
                ((BigDecimal[])result.get((Object)leaseInBillId))[0] = monthDep.add(leaseInBill.getFinanceInitAccDepreciation());
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getCalcAcumDepreAmtForSix(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        FaLeaseInBillNewInfo leaseInBill = (FaLeaseInBillNewInfo)params.get("leaseInBill");
        Date terminateDate = TerminateBillCalc.getMinMonthDate((Date)params.get("terminateDate"));
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(entry.FCURDEPRECIATION) monthDep, SUM(entry.FCURINTERESTPAYMENT) monthIP");
        sql.append(" FROM T_Fa_FaAmortizedCostRpt rpt");
        sql.append(" LEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON rpt.FId = entry.FAmortizedCostRptId");
        sql.append(" WHERE rpt.FLeaseInBillId = ?");
        sql.append(" AND entry.FDate < ?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{leaseInBillId, new Timestamp(terminateDate.getTime())});
        try {
            while (rs.next()) {
                BigDecimal monthDep = rs.getBigDecimal("monthDep") == null ? BigDecimal.ZERO : rs.getBigDecimal("monthDep");
                ((BigDecimal[])result.get((Object)leaseInBillId))[0] = monthDep.add(leaseInBill.getInitAccDepreciation());
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getCalcAcumDepreAmtForSeven(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        FaLeaseInBillNewInfo leaseInBill = (FaLeaseInBillNewInfo)params.get("leaseInBill");
        Date terminateDate = TerminateBillCalc.getMaxMonthDate((Date)params.get("terminateDate"));
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(entry.FCURDEPRECIATION) monthDep, SUM(entry.FCURINTERESTPAYMENT) monthIP");
        sql.append(" FROM T_Fa_FaAmortizedCostRpt rpt");
        sql.append(" LEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON rpt.FId = entry.FAmortizedCostRptId");
        sql.append(" WHERE rpt.FLeaseInBillId = ?");
        sql.append(" AND entry.FDate <= ?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{leaseInBillId, new Timestamp(terminateDate.getTime())});
        try {
            while (rs.next()) {
                BigDecimal monthDep = rs.getBigDecimal("monthDep") == null ? BigDecimal.ZERO : rs.getBigDecimal("monthDep");
                ((BigDecimal[])result.get((Object)leaseInBillId))[0] = monthDep.add(leaseInBill.getInitAccDepreciation());
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getCalcAcumDepreAmtForEight(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        FaLeaseInBillNewInfo leaseInBill = (FaLeaseInBillNewInfo)params.get("leaseInBill");
        Date adjustDate = TerminateBillCalc.getMinMonthDate((Date)params.get("adjustDate"));
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(entry.FCURDEPRECIATION) monthDep, SUM(entry.FCURINTERESTPAYMENT) monthIP");
        sql.append(" FROM T_Fa_FaAmortizedCostRpt rpt");
        sql.append(" LEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON rpt.FId = entry.FAmortizedCostRptId");
        sql.append(" WHERE rpt.FLeaseInBillId = ?");
        sql.append(" AND entry.FDate < ?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{leaseInBillId, new Timestamp(adjustDate.getTime())});
        try {
            while (rs.next()) {
                BigDecimal monthDep = rs.getBigDecimal("monthDep") == null ? BigDecimal.ZERO : rs.getBigDecimal("monthDep");
                ((BigDecimal[])result.get((Object)leaseInBillId))[0] = monthDep.add(leaseInBill.getFinanceInitAccDepreciation());
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getCalcAcumDepreAmtForNine(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        FaLeaseInBillNewInfo leaseInBill = (FaLeaseInBillNewInfo)params.get("leaseInBill");
        Date adjustDate = TerminateBillCalc.getMinMonthDate((Date)params.get("adjustDate"));
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(entry.FCURDEPRECIATION) monthDep, SUM(entry.FCURINTERESTPAYMENT) monthIP");
        sql.append(" FROM T_Fa_FaAmortizedCostRpt rpt");
        sql.append(" LEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON rpt.FId = entry.FAmortizedCostRptId");
        sql.append(" WHERE rpt.FLeaseInBillId = ?");
        sql.append(" AND entry.FDate < ?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{leaseInBillId, new Timestamp(adjustDate.getTime())});
        try {
            while (rs.next()) {
                BigDecimal monthDep = rs.getBigDecimal("monthDep") == null ? BigDecimal.ZERO : rs.getBigDecimal("monthDep");
                ((BigDecimal[])result.get((Object)leaseInBillId))[0] = monthDep.add(leaseInBill.getInitAccDepreciation());
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getCalcAcumDepreAmtForTen(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        FaLeaseInBillNewInfo leaseInBill = (FaLeaseInBillNewInfo)params.get("leaseInBill");
        Date adjustDate = TerminateBillCalc.getMaxMonthDate((Date)params.get("adjustDate"));
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(entry.FCURDEPRECIATION) monthDep, SUM(entry.FCURINTERESTPAYMENT) monthIP");
        sql.append(" FROM T_Fa_FaAmortizedCostRpt rpt");
        sql.append(" LEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON rpt.FId = entry.FAmortizedCostRptId");
        sql.append(" WHERE rpt.FLeaseInBillId = ?");
        sql.append(" AND entry.FDate <= ?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{leaseInBillId, new Timestamp(adjustDate.getTime())});
        try {
            while (rs.next()) {
                BigDecimal monthDep = rs.getBigDecimal("monthDep") == null ? BigDecimal.ZERO : rs.getBigDecimal("monthDep");
                ((BigDecimal[])result.get((Object)leaseInBillId))[0] = monthDep.add(leaseInBill.getInitAccDepreciation());
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getCalcAcumDepreAmtForEleven(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        FaLeaseInBillNewInfo leaseInBill = (FaLeaseInBillNewInfo)params.get("leaseInBill");
        Date adjustDate = (Date)params.get("adjustDate");
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(entry.FCURDEPRECIATION) monthDep, SUM(entry.FCURINTERESTPAYMENT) monthIP");
        sql.append(" FROM T_Fa_FaAmortizedCostRpt rpt");
        sql.append(" LEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON rpt.FId = entry.FAmortizedCostRptId");
        sql.append(" WHERE rpt.FLeaseInBillId = ?");
        sql.append(" AND entry.FDate < ?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{leaseInBillId, new Timestamp(adjustDate.getTime())});
        try {
            while (rs.next()) {
                BigDecimal monthDep = rs.getBigDecimal("monthDep") == null ? BigDecimal.ZERO : rs.getBigDecimal("monthDep");
                ((BigDecimal[])result.get((Object)leaseInBillId))[0] = monthDep.add(leaseInBill.getInitAccDepreciation());
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getCalcAcumInterestExpeForOne(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        Date billEndDate = (Date)params.get("billEndDate");
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(entry.FCURDEPRECIATION) monthDep, SUM(entry.FCURINTERESTPAYMENT) monthIP");
        sql.append(" FROM T_Fa_FaAmortizedCostRpt rpt");
        sql.append(" LEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON rpt.FId = entry.FAmortizedCostRptId");
        sql.append(" WHERE rpt.FLeaseInBillId = ?");
        sql.append(" AND entry.FDate <= ?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{leaseInBillId, new Timestamp(billEndDate.getTime())});
        try {
            while (rs.next()) {
                BigDecimal monthIP;
                ((BigDecimal[])result.get((Object)leaseInBillId))[1] = monthIP = rs.getBigDecimal("monthIP") == null ? BigDecimal.ZERO : rs.getBigDecimal("monthIP");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getCalcAcumInterestExpeForTwo(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        Date terminateDate = (Date)params.get("terminateDate");
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(entry.FCURDEPRECIATION) monthDep, SUM(entry.FCURINTERESTPAYMENT) monthIP");
        sql.append(" FROM T_Fa_FaAmortizedCostRpt rpt");
        sql.append(" LEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON rpt.FId = entry.FAmortizedCostRptId");
        sql.append(" WHERE rpt.FLeaseInBillId = ?");
        sql.append(" AND entry.FDate < ?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{leaseInBillId, new Timestamp(terminateDate.getTime())});
        try {
            while (rs.next()) {
                BigDecimal monthIP;
                ((BigDecimal[])result.get((Object)leaseInBillId))[1] = monthIP = rs.getBigDecimal("monthIP") == null ? BigDecimal.ZERO : rs.getBigDecimal("monthIP");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getCalcAcumInterestExpeForThree(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        Date adjustDate = (Date)params.get("adjustDate");
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(entry.FCURDEPRECIATION) monthDep, SUM(entry.FCURINTERESTPAYMENT) monthIP");
        sql.append(" FROM T_Fa_FaAmortizedCostRpt rpt");
        sql.append(" LEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON rpt.FId = entry.FAmortizedCostRptId");
        sql.append(" WHERE rpt.FLeaseInBillId = ?");
        sql.append(" AND entry.FDate < ?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{leaseInBillId, new Timestamp(adjustDate.getTime())});
        try {
            while (rs.next()) {
                BigDecimal monthIP;
                ((BigDecimal[])result.get((Object)leaseInBillId))[1] = monthIP = rs.getBigDecimal("monthIP") == null ? BigDecimal.ZERO : rs.getBigDecimal("monthIP");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getRetrPaidRentAmtForOne(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        Date terminateDate = (Date)params.get("terminateDate");
        Date adjustDate = (Date)params.get("adjustDate");
        boolean isDeductible = (Boolean)params.get("isDeductible");
        StringBuilder sql = new StringBuilder();
        sql.append(" select FHeadID billId, sum(" + (isDeductible ? "FPaymentWithoutTax" : "FPaymentWithTax") + ") resultNumber FROM T_FA_FaPaymentPlanNew");
        sql.append(" where FHeadID = ?");
        sql.append(" and FPayDate > ? and FPayDate <= ?");
        sql.append(" group by FHeadID");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{leaseInBillId, new Timestamp(adjustDate.getTime()), new Timestamp(terminateDate.getTime())});
        try {
            while (rs.next()) {
                String id = rs.getString("billId");
                BigDecimal retrPaidRentAmt = rs.getBigDecimal("resultNumber") == null ? BigDecimal.ZERO : rs.getBigDecimal("resultNumber");
                result.put(id + "adjust", retrPaidRentAmt);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getRetrCalcAcumDepreAmtForOne(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        Date adjustDate = TerminateBillCalc.getMinMonthDate((Date)params.get("adjustDate"));
        Date terminateDate = TerminateBillCalc.getMinMonthDate((Date)params.get("terminateDate"));
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(entry.FCURDEPRECIATION) monthDep, SUM(entry.FCURINTERESTPAYMENT) monthIP");
        sql.append(" FROM T_Fa_FaAmortizedCostRpt rpt");
        sql.append(" LEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON rpt.FId = entry.FAmortizedCostRptId");
        sql.append(" WHERE rpt.FLeaseInBillId = ?");
        sql.append(" AND entry.FDate >= ?");
        sql.append(" AND entry.FDate < ?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{leaseInBillId, new Timestamp(adjustDate.getTime()), new Timestamp(terminateDate.getTime())});
        try {
            while (rs.next()) {
                BigDecimal monthDep;
                ((BigDecimal[])result.get((Object)leaseInBillId))[2] = monthDep = rs.getBigDecimal("monthDep") == null ? BigDecimal.ZERO : rs.getBigDecimal("monthDep");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getRetrCalcAcumDepreAmtForTwo(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        Date adjustDate = (Date)params.get("adjustDate");
        Date terminateDate = TerminateBillCalc.getMinMonthDate((Date)params.get("terminateDate"));
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(entry.FCURDEPRECIATION) monthDep, SUM(entry.FCURINTERESTPAYMENT) monthIP");
        sql.append(" FROM T_Fa_FaAmortizedCostRpt rpt");
        sql.append(" LEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON rpt.FId = entry.FAmortizedCostRptId");
        sql.append(" WHERE rpt.FLeaseInBillId = ?");
        sql.append(" AND entry.FDate >= ?");
        sql.append(" AND entry.FDate < ?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{leaseInBillId, new Timestamp(adjustDate.getTime()), new Timestamp(terminateDate.getTime())});
        try {
            while (rs.next()) {
                BigDecimal monthDep;
                ((BigDecimal[])result.get((Object)leaseInBillId))[2] = monthDep = rs.getBigDecimal("monthDep") == null ? BigDecimal.ZERO : rs.getBigDecimal("monthDep");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getRetrCalcAcumDepreAmtForThree(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        Date adjustDate = TerminateBillCalc.getMaxMonthDate((Date)params.get("adjustDate"));
        Date terminateDate = TerminateBillCalc.getMinMonthDate((Date)params.get("terminateDate"));
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(entry.FCURDEPRECIATION) monthDep, SUM(entry.FCURINTERESTPAYMENT) monthIP");
        sql.append(" FROM T_Fa_FaAmortizedCostRpt rpt");
        sql.append(" LEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON rpt.FId = entry.FAmortizedCostRptId");
        sql.append(" WHERE rpt.FLeaseInBillId = ?");
        sql.append(" AND entry.FDate > ?");
        sql.append(" AND entry.FDate < ?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{leaseInBillId, new Timestamp(adjustDate.getTime()), new Timestamp(terminateDate.getTime())});
        try {
            while (rs.next()) {
                BigDecimal monthDep;
                ((BigDecimal[])result.get((Object)leaseInBillId))[2] = monthDep = rs.getBigDecimal("monthDep") == null ? BigDecimal.ZERO : rs.getBigDecimal("monthDep");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getRetrCalcAcumDepreAmtForFour(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        Date adjustDate = TerminateBillCalc.getMinMonthDate((Date)params.get("adjustDate"));
        Date terminateDate = TerminateBillCalc.getMinMonthDate((Date)params.get("terminateDate"));
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(entry.FCURDEPRECIATION) monthDep, SUM(entry.FCURINTERESTPAYMENT) monthIP");
        sql.append(" FROM T_Fa_FaAmortizedCostRpt rpt");
        sql.append(" LEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON rpt.FId = entry.FAmortizedCostRptId");
        sql.append(" WHERE rpt.FLeaseInBillId = ?");
        sql.append(" AND entry.FDate >= ?");
        sql.append(" AND entry.FDate < ?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{leaseInBillId, new Timestamp(adjustDate.getTime()), new Timestamp(terminateDate.getTime())});
        try {
            while (rs.next()) {
                BigDecimal monthDep;
                ((BigDecimal[])result.get((Object)leaseInBillId))[2] = monthDep = rs.getBigDecimal("monthDep") == null ? BigDecimal.ZERO : rs.getBigDecimal("monthDep");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getRetrCalcAcumInterestExpeForOne(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        Date adjustDate = (Date)params.get("adjustDate");
        Date terminateDate = TerminateBillCalc.getMinMonthDate((Date)params.get("terminateDate"));
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(entry.FCURDEPRECIATION) monthDep, SUM(entry.FCURINTERESTPAYMENT) monthIP");
        sql.append(" FROM T_Fa_FaAmortizedCostRpt rpt");
        sql.append(" LEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON rpt.FId = entry.FAmortizedCostRptId");
        sql.append(" WHERE rpt.FLeaseInBillId = ?");
        sql.append(" AND entry.FDate >= ?");
        sql.append(" AND entry.FDate < ?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{leaseInBillId, new Timestamp(adjustDate.getTime()), new Timestamp(terminateDate.getTime())});
        try {
            while (rs.next()) {
                BigDecimal monthIP;
                ((BigDecimal[])result.get((Object)leaseInBillId))[3] = monthIP = rs.getBigDecimal("monthIP") == null ? BigDecimal.ZERO : rs.getBigDecimal("monthIP");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getCalcInitAmountForOne(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        FaLeaseInBillNewInfo leaseInBill = (FaLeaseInBillNewInfo)params.get("leaseInBill");
        result.put("initialAsset", leaseInBill.getInitialAsset());
        result.put("initialLiability", leaseInBill.getInitialLiability());
        result.put("unrecognizedFinanceFee", leaseInBill.getUnrecognizedFinanceFee());
    }

    public static void getCalcInitAmountForTwo(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        FaLeaseInBillNewInfo leaseInBill = (FaLeaseInBillNewInfo)params.get("leaseInBill");
        boolean isDeductible = leaseInBill.isIsDeductible();
        result.put("initialAsset", leaseInBill.getFinanceInitialAsset());
        result.put("initialLiability", isDeductible ? leaseInBill.getFinanceReLiabilityWithoutTax() : leaseInBill.getFinanceReLiabilityWithTax());
        result.put("unrecognizedFinanceFee", leaseInBill.getFinanceReUnrFinExpenses());
    }

    public static void getCalcDecValueForOne(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        Date terminateDate = TerminateBillCalc.getMaxMonthDate((Date)params.get("terminateDate"));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(entry.FInitialAssetDecValue) decValue");
        sql.append(" FROM T_Fa_FaAmortizedCostRpt rpt");
        sql.append(" LEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON rpt.FId = entry.FAmortizedCostRptId");
        sql.append(" WHERE rpt.FLeaseInBillId = '" + leaseInBillId + "'");
        sql.append(" AND entry.FDate <= {d '" + sdf.format(terminateDate) + "'}");
        IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)sql.toString()).executeSQL();
        try {
            while (rs.next()) {
                BigDecimal decValue = rs.getBigDecimal("decValue") == null ? BigDecimal.ZERO : rs.getBigDecimal("decValue");
                result.put("initialAssetDecValue", decValue);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getRetrCalcDecValueForOne(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
        String leaseInBillId = (String)params.get("leaseInBillId");
        Date adjustDate = (Date)params.get("adjustDate");
        Date terminateDate = TerminateBillCalc.getMinMonthDate((Date)params.get("terminateDate"));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(entry.FInitialAssetDecValue) decValue");
        sql.append(" FROM T_Fa_FaAmortizedCostRpt rpt");
        sql.append(" LEFT JOIN T_Fa_FaAmortizedCostRptEntry entry ON rpt.FId = entry.FAmortizedCostRptId");
        sql.append(" WHERE rpt.FLeaseInBillId = '" + leaseInBillId + "'");
        sql.append(" AND entry.FDate >= {d '" + sdf.format(adjustDate) + "'}");
        sql.append(" AND entry.FDate < {d '" + sdf.format(terminateDate) + "'}");
        IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)sql.toString()).executeSQL();
        try {
            while (rs.next()) {
                BigDecimal decValue = rs.getBigDecimal("decValue") == null ? BigDecimal.ZERO : rs.getBigDecimal("decValue");
                result.put("retrospectDecValue", decValue);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void getCalcAssetDisposalGainForOne(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
    }

    public static void getCalcAssetDisposalGainForTwo(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
    }

    public static void getCalcAssetDisposalGainForThree(Context ctx, Map<String, Object> params, Map<String, Object> result) throws BOSException {
    }

    private static String idSet2Str(Set<String> idSet) {
        StringBuffer ids = new StringBuffer();
        Iterator<String> it = idSet.iterator();
        while (it.hasNext()) {
            ids.append("'");
            ids.append(it.next());
            ids.append("'");
            if (!it.hasNext()) continue;
            ids.append(",");
        }
        return ids.toString();
    }

    public static Date getMinMonthDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, calendar.getActualMinimum(5));
        return calendar.getTime();
    }

    public static Date getMaxMonthDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, calendar.getActualMaximum(5));
        return calendar.getTime();
    }
}

