/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rt.common.util.common;

import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.log4j.Logger;

public abstract class IOUtils {
    private static final Logger logger = Logger.getLogger(IOUtils.class);

    public static URL resourceURL(String relativePath) {
        URL url = null;
        if (!StringUtils.isEmpty((String)relativePath)) {
            url = IOUtils.class.getClassLoader().getResource(relativePath);
        }
        return url;
    }

    public static String resourcePath(String relativePath) {
        URL url = IOUtils.resourceURL(relativePath);
        return IOUtils.isExistsPath(url) ? url.getPath() : null;
    }

    public static boolean isExistsPath(String relativePath) {
        return IOUtils.isExistsPath(IOUtils.resourceURL(relativePath));
    }

    public static boolean isExistsPath(URL url) {
        String path = null;
        if (url != null) {
            path = url.getPath();
        }
        return !StringUtils.isEmpty(path);
    }

    public static InputStream inputStreamInstance(String relativePath) {
        InputStream ips = null;
        if (IOUtils.isExistsPath(relativePath)) {
            ips = IOUtils.class.getClassLoader().getResourceAsStream(relativePath);
        }
        return ips;
    }

    public static InputStream inputStreamInstance(File file) throws MalformedURLException, IOException {
        return IOUtils.isExistsFile(file) && IOUtils.isExistsPath(file.toURL()) ? file.toURL().openStream() : null;
    }

    public static boolean isExistsFile(File file) {
        return file != null && file.isFile() && file.exists();
    }

    public static File fileForSpecifyDir(String dir, String fileName) throws IOException {
        File tempFile;
        boolean isRealFile = true;
        File file = null;
        if (!StringUtils.isEmpty((String)dir) && (tempFile = new File(dir)) != null && tempFile.isFile()) {
            if (tempFile.isDirectory() && IOUtils.isExistsFile(tempFile)) {
                if (!StringUtils.isEmpty((String)fileName)) {
                    StringBuffer f = new StringBuffer();
                    f.append(dir).append(File.separator).append(fileName);
                    if (!StringUtils.isEmpty((String)f.toString()) && !IOUtils.isExistsFile(file = new File(f.toString()))) {
                        isRealFile = file.createNewFile();
                    }
                }
            } else if (tempFile.isFile()) {
                file = tempFile;
                if (!IOUtils.isExistsFile(tempFile)) {
                    isRealFile = tempFile.createNewFile();
                }
            }
        }
        return isRealFile ? file : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(String oldPath, String newPath) throws Exception {
        FileOutputStream fs = null;
        FileInputStream inStream = null;
        try {
            int bytesum = 0;
            int byteread = 0;
            File oldfile = new File(oldPath);
            if (oldfile.exists()) {
                inStream = new FileInputStream(oldPath);
                fs = new FileOutputStream(newPath);
                byte[] buffer = new byte[1444];
                while ((byteread = inStream.read(buffer)) != -1) {
                    bytesum += byteread;
                    fs.write(buffer, 0, byteread);
                }
            }
        }
        finally {
            IOUtils.safeClose(fs);
            IOUtils.safeClose(inStream);
        }
    }

    public static void safeClose(FileInputStream fis) {
        if (fis != null) {
            try {
                fis.close();
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
        }
    }

    public static void safeClose(FileOutputStream fis) {
        if (fis != null) {
            try {
                fis.close();
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
        }
    }
}

