
// The following ifdef block is the standard way of creating macros which make exporting 
// from a DLL simpler. All files within this DLL are compiled with the PT20SDK_EXPORTS
// symbol defined on the command line. this symbol should not be defined on any project
// that uses this DLL. This way any other project whose source files include this file see 
// PT20SDK_API functions as being imported from a DLL, wheras this DLL sees symbols
// defined with this macro as being exported.

#ifdef PT20SDK_EXPORTS
#define PT20SDK_API __declspec(dllexport)
#else
#define PT20SDK_API __declspec(dllimport)
#endif

#define _WINDOWS_TYPE
#include "..\Source\Define.h"

// This class is exported from the PT20SDK.dll
/*class PT20SDK_API CPT20SDK {
public:
	CPT20SDK(void);
	// TODO: add your methods here.
};
*/

typedef struct SMENU_COLOR MENU_COLOR;

typedef struct __DBMS
{
	_TFILE* filehd_C;
	char *filehd_D;          // D device file point.
	unsigned int filesize_D; // D device file size.
	unsigned char ausFielddlt[50];       // Character that is used for field delimiter
	int record_type;         // 0 = static length  ,1 = variable length.
	int record_length;       // If record_type=0, it need a value.If record_type=1,it's value
	                         // can be any value.This value is not include CR_LF byte.
	int total_field_no;      // Total number of fields in a record.
	int total_record_no;     // Total number of records in a file.
						     // If total_record_no=-1,it will count total record auto.
	int pos_pre_record;	     // Position of precently filepoint.

}_DBMS;

typedef struct __BT_INFO
{
	char assLocalAddress[16];		
	char assLocalName[20];			

	BOOL bLocalSecurity;			
	BOOL bLocalEncryption;		

	int stInquiryTimeout;	
	int stInquirytMaxResponse;	

	char assLinkAddress[16];
	char assPinCode[20];

}_BT_INFO;

typedef struct __BT_DEVINFO_STORE
{
	char assDevAddress[16];
	char assDevName[20];

}_BT_DEVINFO_STORE;

typedef struct __BT_DEVINFO
{
	_BT_DEVINFO_STORE stDevInfo[10];
	int slDevNum;
}_BT_DEVINFO;

/***********************           Reader           ****************************/
PT20SDK_API int SDK_TriggerStatus(void);

PT20SDK_API void SDK_InitScanner1(void);
PT20SDK_API int SDK_Decode(void);
PT20SDK_API void SDK_HaltScanner1(void);
PT20SDK_API BOOL SDK_Scanner_Reset(void);
PT20SDK_API void SDK_Scanner_Config_Start(void);
PT20SDK_API void SDK_Scanner_Config_End(void);
PT20SDK_API BOOL SDK_SCAN_SendCommand(int Command1, int Command2, char *pValue);
PT20SDK_API BOOL SDK_SCAN_QueryStatus(int Command1, int Command2, char *pReturn);
PT20SDK_API BOOL SDK_ScannerSetFromFile(char *pssFilePath);
PT20SDK_API BOOL SDK_Scanner_Version(char* Returnbuf);

/***************************      Buzzer      *********************************/
PT20SDK_API int SDK_beeper_status(void);
PT20SDK_API void SDK_off_beeper(void);
PT20SDK_API void SDK_on_beeper(int *sequence);
PT20SDK_API void SDK_SetBuzzerVol(int slVol);

/**************************      Calendar      ********************************/
PT20SDK_API int SDK_DayOfWeek(void);
PT20SDK_API int SDK_get_time(char* time_buf);
PT20SDK_API int SDK_set_time(char* time_buf);

/**********************     File Manipulation:       **************************/
PT20SDK_API int SDK__access(const char *Filename);
PT20SDK_API int SDK_append(int fd, char* buffer, int count);
PT20SDK_API int SDK_appendln(int fd, char* buffer);
PT20SDK_API int SDK_chsize(int fd, long size);
PT20SDK_API int SDK_close(int fd);
PT20SDK_API int SDK_delete_top(int fd, int count);
PT20SDK_API int SDK_delete_topln(int fd);
PT20SDK_API int SDK_eof(int fd);
PT20SDK_API long SDK_filelength(int fd);
PT20SDK_API int SDK_filelist(char* file_list);
PT20SDK_API long SDK_lseek(int fd, long offset, int origin);
PT20SDK_API int SDK_open(const char* file_name);
PT20SDK_API int SDK_read(int fd, char* buffer, int count);
PT20SDK_API int SDK_read_error_code(void);
PT20SDK_API int SDK_readln(int fd, char* buffer, unsigned int max_count);
PT20SDK_API int SDK__remove(const char* file_name);
PT20SDK_API int SDK__rename(char* old_name,char* new_name);
PT20SDK_API long SDK_tell(int fd);
PT20SDK_API int SDK_write(int fd, char* buffer, int count);
PT20SDK_API int SDK_writeln(int fd, char* buffer);
PT20SDK_API int SDK_DiskC_format(void);
PT20SDK_API int SDK_DiskD_format(void);
PT20SDK_API unsigned int SDK_DiskC_totalsize(void);
PT20SDK_API unsigned int SDK_DiskD_totalsize(void);
PT20SDK_API unsigned int SDK_DiskC_usedsize(void);
PT20SDK_API unsigned int SDK_DiskD_usedsize(void);
PT20SDK_API unsigned int SDK_DiskC_freesize(void);
PT20SDK_API unsigned int SDK_DiskD_freesize(void);
PT20SDK_API int SDK_getDirNum(char *pssPath);
PT20SDK_API int SDK_getFileNum(char *pssPath);
PT20SDK_API int SDK_getDirList(char *pssPath, char *pssBuffer);
PT20SDK_API int SDK_getFileList(char *pssPath, char *pssBuffer);
PT20SDK_API _TFILE* SDK__fopen(const char*filename, const char *access_mode);
PT20SDK_API char* SDK__fopenLookup(char* pssFName, unsigned int* pulSize);
PT20SDK_API int SDK__fclose(_TFILE* file_pointer);
PT20SDK_API void SDK__fcloseAll(void);
PT20SDK_API int SDK__fseek(_TFILE *file_pointer, long offset, int origin);
PT20SDK_API unsigned int SDK__filelength(_TFILE* file_pointer);
PT20SDK_API unsigned int SDK__fread(const void *buffer, U32 size, U32 count, _TFILE *file_pointer);
PT20SDK_API unsigned int SDK__fwrite(const void *buffer, U32 size, U32 count, _TFILE *file_pointer);

/***************************       DBMS         *******************************/
PT20SDK_API int SDK_Ini_Search(_TFILE* filehd,_DBMS* F_Search, unsigned char *pusFielddlt, int record_type,
			   int record_length, int total_field_no, int total_record_no);
PT20SDK_API int SDK_Close_Search(_DBMS* F_Search);
PT20SDK_API int SDK_SearchField(_DBMS* F_Search, char* field, int search_fieldno, int recordno, int flag);
PT20SDK_API int SDK_SearchField_GR(_DBMS* F_Search, char* field, int search_fieldno, int recordno,
				  char* R_Buffer, int flag);
PT20SDK_API int SDK_SearchField_GF(_DBMS* F_Search, char* field, int search_fieldno, int recordno, 
				  int get_field_no, char* F_Buffer, int flag);
PT20SDK_API int SDK_SearchMultiField_GF(_DBMS* F_Search, char* multi_field, int recordno, int get_field_no, 
					   char* F_Buffer, int flag);
PT20SDK_API long SDK_SeekRecord(_DBMS* F_Search,int recordno);
PT20SDK_API int SDK_GetRecordNum(_DBMS* F_Search);
PT20SDK_API int SDK_DeleteRecord(_DBMS* F_Search,int recordnum);
PT20SDK_API int SDK_DeleteLastRecord(_DBMS* F_Search);
PT20SDK_API int SDK_AppendRecord(_DBMS* F_Search,char* record);
PT20SDK_API int SDK_WriteField(_DBMS* F_Search, int recordno, int fieldno, char* field);
PT20SDK_API int SDK_WriteRecord(_DBMS* F_Search, int recordno, char* record);
PT20SDK_API int SDK_ReadField(_DBMS* F_Search, int recordno, int fieldno, char* buffer);
PT20SDK_API int SDK_ReadRecord(_DBMS* F_Search, int recordno, char* buffer);

/*****************************      LED      **********************************/
PT20SDK_API void SDK_set_led(int led, int mode, int duration);

/****************************     Keypad     **********************************/
PT20SDK_API void SDK_clr_kb(void);
PT20SDK_API void SDK_dis_alpha(void);
PT20SDK_API void SDK_en_alpha(void);
PT20SDK_API int SDK_get_alpha_enable_state(void);
PT20SDK_API int SDK__getchar(void);
PT20SDK_API int SDK_GetKeyClick(void);
PT20SDK_API void SDK_SetKeyClick(int status);
PT20SDK_API void SDK__scanf_ctrl_ScannerStatus(BOOL bStatus);
//PT20SDK_API void SDK__scanf_ctrl_ScannerReadConfirm(int nConfirm);
PT20SDK_API void SDK__scanf_ctrl_ScanWithENT(BOOL bScanEnt);
PT20SDK_API void SDK__scanf_ctrl_AlphaKey(BOOL bAlpha);
PT20SDK_API void SDK__scanf_ctrl_password(char ssPassWord);
PT20SDK_API void SDK__scanf_ctrl_KeypadLock(BOOL bLock);
PT20SDK_API int SDK__scanf_color(int color, const char *format, char *pssPoint);
PT20SDK_API int SDK__scanf_color_DefaultStr(int color, char* assDefaultStr, const char *format, char *pssPoint);

PT20SDK_API void SDK_set_alpha_mode_state(int status);
PT20SDK_API int SDK_get_alpha_mode_state(void);
PT20SDK_API void SDK_set_keypad_BL(BOOL bStatus);
PT20SDK_API BOOL SDK_get_keypad_BL(void);
PT20SDK_API void SDK_set_keypad_BL_Timer(int slTimer);
PT20SDK_API int SDK_get_keypad_BL_Timer(void);
PT20SDK_API void SDK__scanf_ctrl_Vibrate(BOOL bEnable);
PT20SDK_API void SDK__scanf_ctrl_AlphaKey_Mode(int slAlphaMode);
PT20SDK_API void SDK_FNKey_Reset(void);
PT20SDK_API char SDK_FNKey_GetState(short smKeyNum);
PT20SDK_API char SDK_FNKey_SetUserDef(short smKeyNum, void (*pslFunction)(void));

/**************************        LCD       **********************************/
PT20SDK_API void SDK_clr_eol(void);
PT20SDK_API void SDK_clr_rect(int left, int top, int width, int height);
PT20SDK_API void SDK_clr_scr(void);
PT20SDK_API void SDK_fill_rect(int left, int top, int width, int height);
PT20SDK_API void SDK_fill_rect_color(int color, int left, int top, int width, int height);
PT20SDK_API int SDK_Get_Cursor(void);
PT20SDK_API void SDK_Set_Cursor(int status);
PT20SDK_API int SDK_gotoxy(int x_position, int y_position);
PT20SDK_API int SDK_wherex(void);
PT20SDK_API int SDK_wherexy(int* column, int* row);
PT20SDK_API int SDK_wherey(void);
PT20SDK_API void SDK_lcd_backlit_Setlv(int level);
PT20SDK_API void SDK_lcd_backlit_SetTimer(int timer);
PT20SDK_API int SDK_lcd_backlit_Getlv(void);
PT20SDK_API int SDK_lcd_backlit_GetTimer(void);
PT20SDK_API int SDK__printf_color(int color, char *format, ...);
PT20SDK_API int SDK__putchar(char c);
PT20SDK_API char SDK__puts (char* string);
PT20SDK_API char SDK__puts_color(int colorindex, char* string);
PT20SDK_API void SDK_show_image_bmp(int left, int top, int width, int height, const void *pat);

PT20SDK_API int SDK__putchar_color(int color, char c);

/****************************     TextBlock    ********************************/
PT20SDK_API BOOL SDK_DefineTextBlock(S32 slBlockNo,S32 slSelFont,S32 slBGType,U32* ulBGData,S32 slColumn,S32 slRow,S32 slXPos,S32 slYPos);
PT20SDK_API BOOL SDK_SetTextBlock(S32 slBlockNo,BOOL bSF);
PT20SDK_API void SDK_ResetTextBlock(S32 slBlockNo);
PT20SDK_API POINT SDK_PrintTextBlock(S32 slBlockNo, S32 slColumn, S32 slRow, char* string, U32 ulFontColor);
PT20SDK_API POINT SDK_GetTextBlockCur(S32 slBlockNo);
PT20SDK_API void SDK_SetTextBlockCur(S32 slBlockNo,S32 slColumn,S32 slRow);
PT20SDK_API void SDK_ShowTextBlockCursor(S32 slBlockNo, BOOL bShow, S32 slType);

/*******************************     Font    **********************************/
PT20SDK_API BOOL SDK_DispFont_SetFont(S32 slSelFont, const char *filename);
PT20SDK_API BOOL SDK_DispFont_GetFontInfo(S32 slSelFont, S32* slType, S32* slWidth, S32* slHeight);

PT20SDK_API BOOL SDK_DispFont_SetPFont(S32 slSelFont, char* pfile);

/**********************     Communication Ports     ***************************/
PT20SDK_API void SDK_clear_com(int port);
PT20SDK_API int SDK_close_com(int port);
PT20SDK_API int SDK_com_cts(int port);
PT20SDK_API int SDK_com_eot(int port);
PT20SDK_API int SDK_com_overrun(int port);
PT20SDK_API void SDK_com_rts(int port, int val);
PT20SDK_API int SDK_nwrite_com(int port, char *s, int count);
PT20SDK_API int SDK_open_com(int com_port, int setting);
PT20SDK_API int SDK_read_com(int port, char *c);
PT20SDK_API int SDK_write_com(int port, char *s);

PT20SDK_API void SDK_USB_Open(void);
PT20SDK_API void SDK_USB_Close(void);
PT20SDK_API int SDK_USB_Read(unsigned char *rbuf, unsigned int rLength);
PT20SDK_API void SDK_USB_Write(unsigned char *wbuf, unsigned int wLength);

/**********************         Remote Link          ***************************/
PT20SDK_API void SDK_RemoteLink(void);

PT20SDK_API void SDK_SetRemoteBaud(int slBaud);
PT20SDK_API int SDK_GetRemoteBaud(void);
PT20SDK_API void SDK_SetRemoteInterface(int slInterface);
PT20SDK_API int SDK_GetRemoteInterface(void);
PT20SDK_API void SDK_RemoteLink_RealTime(BOOL bStatus);

/***********************           System           ****************************/
PT20SDK_API void SDK_SysDelay(unsigned int ulTime);

PT20SDK_API void SDK_SysSuspend(void);
PT20SDK_API void SDK_SetPowerOnState(int slStatus);
PT20SDK_API int SDK_GetPowerOnState(void);
PT20SDK_API void SDK_SetAutoPWOff(int slTimer);
PT20SDK_API int SDK_GetAutoPWOff(void);
PT20SDK_API void SDK_SetStatausBAR(int slStatus);
PT20SDK_API int SDK_GetStatusBAR(void);
PT20SDK_API void SDK_SN_Get(char *pssSNBuffer);
PT20SDK_API void SDK_BIOS_SetDefault(void);
PT20SDK_API BOOL SDK_Check_AID(char* pssUser, char* pssPassword);

/***********************           Memory           ****************************/
PT20SDK_API int SDK_TotalHeapSize(void);
PT20SDK_API int SDK_UsedHeapSize(void);
PT20SDK_API int SDK_FreeHeapSize(void);

PT20SDK_API void SDK_Tfree(void *mem_address);
PT20SDK_API void* SDK_Tmalloc(U32 num_bytes);

/***********************           Vibrate          ****************************/
PT20SDK_API void SDK_off_vibrator(void);
PT20SDK_API void SDK_on_vibrator(void);
PT20SDK_API void SDK_set_vibrator_timer(unsigned char usTimer);
PT20SDK_API unsigned char SDK_get_vibrator_timer(void);

/***************************       Others        *******************************/
PT20SDK_API void SDK_prc_menu_color(MENU_COLOR *menu);

/***************************    For Simulator    *******************************/
PT20SDK_API void SDK_CopyFileToTerminal(char *pssPCFileName, char *pssPDTFileName);
PT20SDK_API void SDK_BackupDataFiletoPC(char *pTerminalFile, char *pPCFileName);

/***************************   Data Conversion   *******************************/
PT20SDK_API char * SDK__itoa(int value, char *string, int radix);
PT20SDK_API char * SDK__ltoa(long value, char *string, int radix);
PT20SDK_API char * SDK__ultoa(unsigned long value, char *string, int radix);

/***********************          BlueTooth         ****************************/
PT20SDK_API int SDK_BT_Start(void);
PT20SDK_API int SDK_BT_Stop(void);
PT20SDK_API void SDK_BT_SetPWStatus(int slStatus);
PT20SDK_API int SDK_BT_GetPWStatus(void);
PT20SDK_API int SDK_BT_Open(void);
PT20SDK_API int SDK_BT_Close(void);
PT20SDK_API int SDK_BT_Read(char* pssBuf, int slReadSize, int* pslGetSize);
PT20SDK_API int SDK_BT_Write(char* pssBuf, int slWriteSize, int* pslPutSize);
PT20SDK_API int SDK_BT_GetLocalInfo(_BT_INFO* stInfo);
PT20SDK_API int SDK_BT_SetLocalSet(_BT_INFO* stSet);
PT20SDK_API int SDK_BT_Inquiry(_BT_DEVINFO* stBT_DevInfo, BOOL bGetDevName);

PT20SDK_API int SDK_fErrorCode;
PT20SDK_API int SDK_CodeLen;
PT20SDK_API char *SDK_CodeBuf;
PT20SDK_API char *SDK_FullCodeBuf;
PT20SDK_API char *SDK_CodeID;
PT20SDK_API char *SDK_CodeName;
PT20SDK_API char *SDK_Preamble;
PT20SDK_API char *SDK_Postamble;
PT20SDK_API char *SDK_Terminator;

