/****************************************************************************/
/* FILE                 : UserDef.h                                         */
/****************************************************************************/
/*                                                                          */
/* PROGRAM              : User Data Definition                              */
/* SYSTEM               : PT-10/12                                          */
/* VERSION              : 1.26                                              */
/* AUTHOR               : ARGOX Information CO.,LTD.                        */
/* DATA OF GET          : 2004/07/23                                        */
/* DATA OF UPDATE       : 2005/01/04                                        */
/*                                                                          */
/****************************************************************************/
/* Copyright(C) 2004 ARGOX Information CO.,LTD. All rights reserved.        */
/****************************************************************************/

/****************************************************************************/
/*  Data Types Definition Part (ƫAwq)                    #000       */
/*  File Manipulation Part (ɮ׳Bz)                            #005       */
/*  Buzzer Part (ﾹ)                                         #007       */
/*  Keypad Management Part (޲z)                            #008       */
/*  Barcode Management Part (X޲z)                           #009       */
/*  Font Setting Part (r]w)                                 #010       */
/*  System Calls for BIOS Setting Part (򥻿JX]w)        #022       */
/****************************************************************************/


#ifndef __DEFINE_H__
#define __DEFINE_H__

#ifdef __cplusplus
extern "C" {
#endif

/****************************************************************************/
/*  Data Types Definition Part (ƫAwq)                    #000       */
/****************************************************************************/

#ifdef PT20SDK_EXPORTS
#define PT20SDK_API __declspec(dllexport)
#else
#define PT20SDK_API __declspec(dllimport)
#endif

	typedef char			S8;		/* ss	*/
	typedef short			S16;	/* sm	*/
	typedef int				S32;	/* sl	*/
	typedef unsigned char	U8;		/* us	*/
	typedef unsigned short	U16;	/* um	*/
	typedef unsigned int	U32;	/* ul	*/

	typedef unsigned int	size_t;

	typedef int			   OS_EVENT;
	typedef unsigned char  BOOLEAN;
	typedef unsigned char  INT8U;                    /* Unsigned  8 bit quantity                           */
	typedef signed   char  INT8S;                    /* Signed    8 bit quantity                           */
	typedef unsigned int   INT16U;                   /* Unsigned 16 bit quantity                           */
	typedef signed   int   INT16S;                   /* Signed   16 bit quantity                           */
	typedef unsigned long  INT32U;                   /* Unsigned 32 bit quantity                           */
	typedef signed   long  INT32S;                   /* Signed   32 bit quantity                           */
	typedef float          FP32;                     /* Single precision floating point                    */
	typedef double         FP64;                     /* Double precision floating point                    */


#ifndef _WINDOWS_TYPE
	typedef unsigned int	BOOL;	/* ul	*/

	typedef unsigned char   BYTE;
	typedef unsigned short  WORD;
	typedef unsigned int    DWORD;
	typedef int				LONG;	

#ifdef NULL
	#undef NULL
#endif
	#define NULL 0
	#define TRUE 1
	#define FALSE 0

	#define MB_OK                 0
	#define MB_OKCANCEL           1
	#define MB_ABORTRETRYIGNORE   2
	#define MB_YESNOCANCEL        3
	#define MB_YESNO              4
	#define MB_RETRYCANCEL        5

	#define MB_ICONHAND           16
	#define MB_ICONQUESTION       32
	#define MB_ICONEXCLAMATION    48
	#define MB_ICONASTERISK       64

	#define MB_ICONINFORMATION    64
	#define MB_ICONSTOP           16

	#define MB_DEFBUTTON1         0
	#define MB_DEFBUTTON2         256
	#define MB_DEFBUTTON3         512

	#define MB_APPLMODAL          0
	#define MB_SYSTEMMODAL        4096
	#define MB_TASKMODAL          8192 

typedef struct _POINT
{
	S32 slX;
	S32 slY;
}POINT;

#endif

#ifdef _PCHOST	
#define __irq
#endif
	


/***********************************
** The special parameter defining **
***********************************/
typedef union __U16
{
	U8 usChar[2];
	U16 umWord;
}_U16;

typedef union __S32
{
	S8 ssChar[4];
	S32 slLong;
}_S32;

typedef union __U32
{
	U8 usChar[4];
	U16 umWord[2];
	U32 ulLong;
}_U32;

/****************************************************************************/
/*  File Manipulation Part (ɮ׳Bz)                            #005       */
/****************************************************************************/
/***************************
** File Discription Block **
***************************/

typedef struct __FAT16_FDB // File Discription Block
{
S8 assName[8];			// 0  8 bytes    Name  
S8 assExtension[3];		// 8  3 bytes    Extension  
U8 usAttribute;			// 11  byte    Attribute (00ARSHDV) 
							// 0: unused bit 
							// A: archive bit, 
							// R: read-only bit 
							// S: system bit 
							// D: directory bit 
							// V: volume bit  

U8 usNT;				// 12 	byte 	  NT (Reserved for WindowsNT; always 0) 
U8 usCT_millisecond;	// 13 	byte 	  Created time; millisecond portion 
U16 umCT_HaM;			// 14 	word 	  Created time; hour and minute 
U16 umCT_Date;			// 16 	word 	  Created date 
U16 umLastAccDate;		// 18 	word 	  Last accessed date 
U16 umExtAttribute;		// 20 	word 	  Extended Attribute  (reserved for OS/2; always 0) 

U16 umTime;				// 22  word    Time  
U16 umDate;				// 24  word    Date  
U16 umCluster;			// 26  word    Cluster (desc. below)  
U32 ulFileSize;			// 28  dword    File Size  
}_FAT16_FDB;

/********************
** File attributes **
*********************/
#define ATTR_NONE			0x00
#define ATTR_READ_ONLY		0x01
#define ATTR_HIDDEN			0x02
#define ATTR_SYSTEM			0x04
#define ATTR_VOLUME_ID		0x08
#define ATTR_DIRECTORY		0x10
#define ATTR_ARCHIVE		0x20
#define ATTR_LONG_NAME		(ATTR_READ_ONLY |ATTR_HIDDEN |ATTR_SYSTEM |ATTR_VOLUME_ID)

/***************************************************
** Stores information about current state of file **
***************************************************/
#define MAX_PATHLEN 80
typedef struct __FS_FILE
{
	S8			assPath[MAX_PATHLEN];	// ɮ׸|
	_FAT16_FDB	*pFDB;		// ɮ DIR Table}
	S8			*pssFileHead;

	S32			slDiskNum;
	S32			slMemcpyType;
	U32			ulFileSize;			// ɮץثe Size
	U32			Currentposition;	
	U16			umAccessMode;

}_FS_FILE;
typedef	_FS_FILE	_TFILE;
typedef	_FS_FILE	FFILE;

/****************************************************************
** Stores information about current state of file or directory **
****************************************************************/
typedef struct __DIRINFO
{
	S8		assFName[8];
	S8		assExtend[3];
	S8		usAttrib;
	S8		usTime[2];
	S8		usDate[2];
	U16		umStart;
	U32		ulSize;
	S8		assCR[2];
}_DIRINFO;
#define ATT_FOLDER	 16
#define ATT_FILE	 32

/**********************************************************
** The origin argument specifies the initial position    **
** and can be one of the manifest constants shown below: **
**********************************************************/
#define FS_SEEK_CUR 1 // Current position of file pointer
#define FS_SEEK_END 2 // End of file
#define FS_SEEK_SET 0 // Beginning of file

/*************************
** file control options **
*************************/
#define FS_O_NOTHING	  0x0000
#define FS_O_RDONLY       0x0004  /* open for reading only */
#define FS_O_WRONLY       0x0001  /* open for writing only */
#define FS_O_RDWR         0x0002  /* open for reading and writing */
#define FS_O_APPEND       0x0008  /* writes done at eof */
#define FS_O_EDIT         0x0010  /* open for reading , writing and change size */

#define FS_O_CREAT        0x0100  /* create and open file */
#define FS_O_TRUNC        0x0200  /* open and truncate */
#define FS_O_EXCL         0x0400  /* open only if file doesn't already exist */

/* O_TEXT files have <cr><lf> sequences translated to <lf> on read()'s,
** and <lf> sequences translated to <cr><lf> on write()'s
*/

#define FS_O_TEXT         0x4000  /* file mode is text (translated) */
#define FS_O_BINARY       0x8000  /* file mode is binary (untranslated) */



//==========================================================================//
// KeyPad Code Map
#define TM_NONE		255
#define TM_0		0
#define TM_1		1
#define TM_2		2
#define TM_3		3
#define TM_4		4
#define TM_5		5
#define TM_6		6
#define TM_7		7
#define TM_8		8
#define TM_9		9
#define TM_DOT		10
#define TM_ESC		11	//14
#define TM_ENT		12	//16
#define TM_UP		13	//18
#define TM_DOWN	14	//19
#define TM_LEFT	15	//20
#define TM_RIGHT	16	//21


#define TM_F1		20	//40
#define TM_F2		21	//41
#define TM_F3		22	//42
#define TM_F4		23	//43
#define TM_F5		24	//44
#define TM_F6		25	//45
#define TM_P1		26	//50
#define TM_P2		27	//51
#define TM_BS		28	//81
#define TM_SFT		30	//80

//#define TM_ASCII	60

typedef struct __set_scanner_mode
{
	S16		_en_scanner;		// 0: disable scanner  1: enable scanner
	S16		_en_keypad;			// 0: diasble keybad   1: enable keybad
}_set_scanner;


//////////////////////////////////////////////////////////////////////////////////////////////////
//==========================================================================//
// Display Spec.

#define DISPLAYBUFFERSIZE		1024	// Byte //
#define DISPLAY_WIDTH_PIXEL		128		// Pixel //
#define DISPLAY_HEIGHT_PIXEL	64		// Pixel //
#define DISPLAY_HEIGHT_BYTES	8		// Byte //
#define DISPLAYPOSITION			0, 0, 127, 63		// pixel //
#define DISPLAYPOS_LEFT			0	// pixel //
#define DISPLAYPOS_RIGHT		127	// pixel //
#define DISPLAYPOS_TOP			0	// pixel //
#define DISPLAYPOS_BOTTOM		63	// pixel //

#define WINDOW_LEFT				0	// pixel //
#define WINDOW_RIGHT			119	// pixel //
#define WINDOW_TOP				0	// pixel //
#define WINDOW_BOTTOM			63	// pixel //
#define WINDOW_HEIGHT			64	// pixel //
#define WINDOW_WIDTH			120	// pixel //


typedef struct __RTC_DATA 
{
        int     year;
        int     month;
        int     day;
        int     weekday;
        int     hour;
        int     min;
        int     sec;    
}_RTC_DATA;



//==========================================================================//
// Other Setting
#define TIME_ALPHAKEY		100	/* Time of Alpha Key Down : 1 Second */

#define FONT_MAINMENU		1		/* Default Font of Main menu */


#define STX_CODE 0x02
#define ESC_CODE 0x1b
#define ACK_CODE 0x06
#define NAK_CODE 0x15



extern U8  DECODE_OK_DATA[348];


#define SET1_B(x, y)	x=(x&0xfffffffe)|(y&0x1)
#define GET1_B(x)		(x&0x1)
#define SET2_B(x, y)	x=(x&0xfffffffd)|((y&0x1)<<1)
#define GET2_B(x)		((x>>1)&0x1)
#define SET3_B(x, y)	x=(x&0xfffffffb)|((y&0x1)<<2)
#define GET3_B(x)		((x>>2)&0x1)
#define SET4_B(x, y)	x=(x&0xfffffff7)|((y&0x1)<<3)
#define GET4_B(x)		((x>>3)&0x1)
#define SET5_B(x, y)	x=(x&0xffffffef)|((y&0x1)<<4)
#define GET5_B(x)		((x>>4)&0x1)
#define SET6_B(x, y)	x=(x&0xffffffdf)|((y&0x1)<<5)
#define GET6_B(x)		((x>>5)&0x1)
#define SET7_B(x, y)	x=(x&0xffffffbf)|((y&0x1)<<6)
#define GET7_B(x)		((x>>6)&0x1)
#define SET8_B(x, y)	x=(x&0xffffff7f)|((y&0x1)<<7)
#define GET8_B(x)		((x>>7)&0x1)

/****************************************************************************/
/*  Transmite Percentage Part (ʤ)                           #012       */
/****************************************************************************/
//void RT_Percentage_GetItem(int nOperation, int nMode, int nTotalSize, int nRunSize, char *pssItemName);
// List of nOperation
#define RT_FILE_TMtoPC			0
#define RT_FILE_PCtoTM			1
#define RT_STANDBY				2
#define RT_FWUPGRADE			3
#define RT_RESET				4
#define RT_ROMPROGRAM_BREAK     5
#define RT_STANDBY_NEW			6

// List of nMode
#define PERCENT_BEGIN					0
#define PERCENT_RUN						1
#define PERCENT_END						2
#define PERCENT_BREAK					3
#define PERCENT_BREAK_FW_NOROMWRITER	4
#define PERCENT_BREAK_UNFORMAT			5
#define PERCENT_BREAK_OPENFILEERROR		6
#define PERCENT_BREAK_DISKFULL			7
#define PERCENT_BREAK_WRITEERROR		8
#define PERCENT_BREAK_FW_DATAERROR		9


//==========================================================================//

#ifdef __cplusplus
}
#endif

#endif ///*__DEFINE_H__*/

