/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.rpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.permission.OrgRangeFactory;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.fi.books.AcountSchemeFactory;
import com.kingdee.eas.fi.books.AcountSchemeInfo;
import com.kingdee.eas.fi.fa.def.app.common.FaDaoDefPart;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.fa.rpt.FaDaoSqlObject;
import com.kingdee.eas.fi.fa.rpt.FaSumItemEnum;
import com.kingdee.eas.fi.fa.rpt.TreeIDNode;
import com.kingdee.eas.fi.fa.rpt.app.AbstractFaListControllerBean;
import com.kingdee.eas.fi.fa.rpt.app.dao.FaAmountStatRptDao;
import com.kingdee.eas.fi.fa.rpt.app.dao.FaChgListRptDao;
import com.kingdee.eas.fi.fa.rpt.app.dao.FaDaoBase;
import com.kingdee.eas.fi.fa.rpt.app.dao.FaDaoFactory;
import com.kingdee.eas.fi.fa.rpt.app.dao.FaEvaluateRptDao;
import com.kingdee.eas.fi.fa.rpt.app.dao.FaFacilityListRptDao;
import com.kingdee.eas.fi.fa.rpt.app.dao.FaListDao;
import com.kingdee.eas.fi.fa.rpt.app.dao.FaMatureHintRptDao;
import com.kingdee.eas.fi.fa.rpt.app.dao.FaSubLedgerNewDao;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class FaListControllerBean
extends AbstractFaListControllerBean {
    private static final Logger logger = Logger.getLogger(FaListControllerBean.class);
    private static final long serialVersionUID = -5764322395750895359L;

    @Override
    protected IRowSet _findChgCardIdList(Context ctx, EntityViewInfo evi) throws BOSException, EASBizException {
        FaChgListRptDao dao = FaChgListRptDao.getFaChgListRptDao(ctx);
        IRowSet result = dao.findChgCardIdList(evi);
        return result;
    }

    @Override
    protected Map _findChgRecordList(Context ctx, EntityViewInfo evi) throws BOSException, EASBizException {
        FaChgListRptDao dao = FaChgListRptDao.getFaChgListRptDao(ctx);
        Map result = dao.findChgRecordList(evi);
        return result;
    }

    @Override
    protected IRowSet _findCardInfoForChgList(Context ctx, EntityViewInfo evi) throws BOSException, EASBizException {
        FaChgListRptDao dao = FaChgListRptDao.getFaChgListRptDao(ctx);
        IRowSet result = dao.getCardInfo(evi);
        return result;
    }

    protected Map _findFaSubLedger(Context ctx, EntityViewInfo evi) throws BOSException, EASBizException {
        FaSubLedgerNewDao dao = new FaSubLedgerNewDao();
        dao.init(ctx, evi);
        return dao.getResult();
    }

    @Override
    protected Map _findInitData(Context ctx) throws BOSException, EASBizException {
        HashMap<String, Object> initDataMap = new HashMap<String, Object>();
        IPeriod initIPeriod = PeriodFactory.getLocalInstance((Context)ctx);
        EntityViewInfo viewPeriod = new EntityViewInfo();
        FilterInfo filterPeriod = new FilterInfo();
        viewPeriod.setFilter(filterPeriod);
        FilterItemCollection ficPeriod = filterPeriod.getFilterItems();
        CompanyOrgUnitInfo currCompanyInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
        ICompanyOrgUnit iCompanyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo companyInfo = iCompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)currCompanyInfo.getId().toString())));
        PeriodTypeInfo periodTypeInfo = companyInfo.getAccountPeriodType();
        ficPeriod.add(new FilterItemInfo("periodType.id", (Object)periodTypeInfo.getId().toString()));
        SorterItemCollection sorter = viewPeriod.getSorter();
        SorterItemInfo year = new SorterItemInfo("periodYear");
        year.setSortType(SortType.ASCEND);
        sorter.add(year);
        sorter.add(new SorterItemInfo("periodNumber"));
        PeriodCollection periodCollection = initIPeriod.getPeriodCollection(viewPeriod);
        if (!currCompanyInfo.isIsBizUnit()) {
            PeriodInfo defaultQueryPeriod = PeriodUtils.getPeriodInfo((Context)ctx, (Date)new Date(System.currentTimeMillis()), (CompanyOrgUnitInfo)companyInfo);
            initDataMap.put("defaultQueryPeriod", defaultQueryPeriod);
        }
        initDataMap.put("period", periodCollection);
        return initDataMap;
    }

    public String getCurrentCompanyId(Context ctx) {
        CompanyOrgUnitInfo currCompanyInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
        if (currCompanyInfo == null || currCompanyInfo.getId() == null) {
            return null;
        }
        String currCompanyID = currCompanyInfo.getId().toString();
        return currCompanyID;
    }

    protected Map _findFacilityList(Context ctx, EntityViewInfo evi) throws EASBizException, BOSException {
        FaFacilityListRptDao dao = new FaFacilityListRptDao();
        dao.init(ctx, evi);
        return dao.getResult();
    }

    protected Map _findMatureHintList(Context ctx, EntityViewInfo evi) throws EASBizException, BOSException {
        FaMatureHintRptDao dao = new FaMatureHintRptDao();
        dao.init(ctx, evi);
        return dao.getResult();
    }

    protected Map _findAmountStatList(Context ctx, EntityViewInfo evi) throws BOSException, EASBizException {
        FaAmountStatRptDao dao = new FaAmountStatRptDao();
        dao.init(ctx, evi);
        return dao.getResult();
    }

    @Override
    protected boolean _dropTempTable(Context ctx, String tempTable) throws BOSException {
        try {
            TempTablePool.getInstance((Context)ctx).releaseTable(tempTable);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    protected IRowSet _getIdList(Context ctx, FaDaoSqlObject sqlDao) throws BOSException {
        sqlDao.setSelect("FId");
        if (TableManagerFacadeFactory.getLocalInstance((Context)ctx).existTable(sqlDao.getFrom())) {
            return DbUtil.executeQuery((Context)ctx, (String)sqlDao.getSql());
        }
        return null;
    }

    @Override
    protected IRowSet _getDataForIdList(Context ctx, FaDaoSqlObject sqlDao, List idList) throws BOSException {
        StringBuffer fid = new StringBuffer("FId IN ( ? ");
        int n = idList.size();
        for (int i = 1; i < n; ++i) {
            fid.append(", ? ");
        }
        fid.append(" ) ");
        if (sqlDao.getWhere().trim().length() != 0) {
            sqlDao.setWhere(sqlDao.getWhere() + " AND " + fid.toString());
        } else {
            sqlDao.setWhere(fid.toString());
        }
        return DbUtil.executeQuery((Context)ctx, (String)sqlDao.getSql(), (Object[])idList.toArray());
    }

    @Override
    protected IRowSet _getDataForIdListFromWeb(Context ctx, FaDaoSqlObject sqlDao, List idList) throws BOSException {
        if (idList == null || idList.size() == 0) {
            String select = sqlDao.getSelect() + ", FID";
            sqlDao.setSelect(select);
            return DbUtil.executeQuery((Context)ctx, (String)sqlDao.getSql());
        }
        StringBuffer fid = new StringBuffer("FId IN ( ? ");
        int n = idList.size();
        for (int i = 1; i < n; ++i) {
            fid.append(", ? ");
        }
        fid.append(" ) ");
        String select = sqlDao.getSelect() + ", FID";
        sqlDao.setSelect(select);
        if (sqlDao.getWhere().trim().length() != 0) {
            sqlDao.setWhere(sqlDao.getWhere() + " AND " + fid.toString());
        } else {
            sqlDao.setWhere(fid.toString());
        }
        return DbUtil.executeQuery((Context)ctx, (String)sqlDao.getSql(), (Object[])idList.toArray());
    }

    @Override
    protected IRowSet _getDataForFirst(Context ctx, FaDaoSqlObject sqlDao, int length) throws BOSException {
        if (length == -1) {
            if (sqlDao == null) {
                return null;
            }
            sqlDao.setSelect(" " + sqlDao.getSelect());
        } else {
            sqlDao.setSelect(" TOP " + length + " " + sqlDao.getSelect());
        }
        return DbUtil.executeQuery((Context)ctx, (String)sqlDao.getSql());
    }

    @Override
    protected Map _findFaEvaluateList(Context ctx, EntityViewInfo evi) throws BOSException, EASBizException {
        FaEvaluateRptDao dao = new FaEvaluateRptDao();
        dao.init(ctx, evi);
        return dao.getResult();
    }

    @Override
    protected Map _findFaList(Context ctx, EntityViewInfo evi) throws EASBizException, BOSException {
        FaListDao faList = new FaListDao();
        faList.init(ctx, evi);
        return faList.getResult();
    }

    @Override
    protected List _getTreeIdList(Context ctx, FaDaoSqlObject sqlDao) throws BOSException {
        sqlDao.setSelect("FId, IsSum, SumLevel");
        Connection conn = null;
        Statement statement = null;
        ResultSet rs = null;
        ArrayList<TreeIDNode> nodeList = new ArrayList<TreeIDNode>();
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            statement = conn.createStatement();
            rs = statement.executeQuery(sqlDao.getSql());
            while (rs.next()) {
                int isSum = rs.getInt("IsSum");
                if (isSum == 2) {
                    nodeList.add(new TreeIDNode(rs.getString("FID"), rs.getInt("SumLevel"), true));
                    continue;
                }
                nodeList.add(new TreeIDNode(rs.getString("FID"), rs.getInt("SumLevel"), rs.getBoolean("IsSum")));
            }
        }
        catch (SQLException exc) {
            try {
                throw new BOSException("Sql execute exception : " + sqlDao.getSql(), (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
        return nodeList;
    }

    @Override
    protected IRowSet _getTreeDataForFirst(Context ctx, FaDaoSqlObject sqlDao, int length, int topLevel) throws BOSException {
        sqlDao.setSelect(" TOP " + length + " " + sqlDao.getSelect());
        int level = topLevel + 1;
        String where = "SumLevel < " + level;
        if (sqlDao.getWhere().trim().length() == 0) {
            sqlDao.setWhere(where);
        } else {
            sqlDao.setWhere("( " + sqlDao.getWhere() + ") AND " + where);
        }
        return DbUtil.executeQuery((Context)ctx, (String)sqlDao.getSql());
    }

    @Override
    protected Map _buildData(Context ctx, EntityViewInfo ev, String daoClassName) throws BOSException, EASBizException {
        FaDaoBase dao = FaDaoFactory.createDao(daoClassName);
        dao.init(ctx, ev);
        return dao.getResult();
    }

    @Override
    protected IRowSet _findChangeInfo(Context ctx, FaDaoSqlObject sql) throws BOSException {
        return DbUtil.executeQuery((Context)ctx, (String)sql.getSql());
    }

    @Override
    protected Map _findPeriodYears(Context ctx, List companyIDList) throws BOSException {
        int minPeriodYear = 0;
        int maxPeriodYear = 0;
        int minPeriodNumber = 0;
        int maxPeriodNumber = 0;
        if (companyIDList != null && companyIDList.size() > 0) {
            String operator;
            StringBuffer companyIds = new StringBuffer();
            companyIds.append("'").append(companyIDList.get(0)).append("'");
            int size = companyIDList.size();
            for (int i = 1; i < size; ++i) {
                companyIds.append(",'").append(companyIDList.get(i).toString()).append("'");
            }
            String companys = companyIds.toString();
            if (companyIDList.size() == 1) {
                operator = " = ";
            } else {
                companys = "(" + companys + ")";
                operator = " IN ";
            }
            try {
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT min(period.FPeriodYear) AS minPeriodYear");
                sql.append(" FROM T_BD_SystemStatusCtrol ssc");
                sql.append(" INNER JOIN T_BD_Period period ON ssc.FStartPeriodID = period.FID");
                sql.append(" INNER JOIN T_BD_SystemStatus ss ON ssc.FsystemStatusID = ss.FID");
                sql.append(" Where ssc.FCompanyID ").append(operator).append(companys);
                sql.append(" AND ss.FName = ").append(14);
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                if (rowSet.next()) {
                    minPeriodYear = rowSet.getInt("minPeriodYear");
                }
                sql = new StringBuffer();
                sql.append("SELECT min(period.FPeriodNumber) AS minPeriodNumber");
                sql.append(" FROM T_BD_SystemStatusCtrol ssc");
                sql.append(" INNER JOIN T_BD_Period period ON ssc.FStartPeriodID = period.FID");
                sql.append(" INNER JOIN T_BD_SystemStatus ss ON ssc.FsystemStatusID = ss.FID");
                sql.append(" Where period.FPeriodYear = ").append(minPeriodYear);
                sql.append(" AND ssc.FCompanyID ").append(operator).append(companys);
                sql.append(" AND ss.FName = ").append(14);
                rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                if (rowSet.next()) {
                    minPeriodNumber = rowSet.getInt("minPeriodNumber");
                }
                sql = new StringBuffer();
                sql.append("SELECT max(period.FPeriodYear) AS maxPeriodYear");
                sql.append(" FROM T_BD_SystemStatusCtrol ssc");
                sql.append(" INNER JOIN T_BD_Period period ON ssc.FCurrentPeriodID = period.FID");
                sql.append(" INNER JOIN T_BD_SystemStatus ss ON ssc.FsystemStatusID = ss.FID");
                sql.append(" Where ssc.FCompanyID ").append(operator).append(companys);
                sql.append(" AND ss.FName = ").append(14);
                rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                if (rowSet.next()) {
                    maxPeriodYear = rowSet.getInt("maxPeriodYear");
                }
                sql = new StringBuffer();
                sql.append("SELECT max(period.FPeriodNumber) AS maxPeriodNumber");
                sql.append(" FROM T_BD_SystemStatusCtrol ssc");
                sql.append(" INNER JOIN T_BD_Period period ON ssc.FCurrentPeriodID = period.FID");
                sql.append(" INNER JOIN T_BD_SystemStatus ss ON ssc.FsystemStatusID = ss.FID");
                sql.append(" Where period.FPeriodYear = ").append(maxPeriodYear);
                sql.append(" AND ssc.FCompanyID ").append(operator).append(companys);
                sql.append(" AND ss.FName = ").append(14);
                rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                if (rowSet.next()) {
                    maxPeriodNumber = rowSet.getInt("maxPeriodNumber");
                }
            }
            catch (SQLException ex) {
                throw new BOSException((Throwable)ex);
            }
        }
        HashMap<String, Integer> periodYears = new HashMap<String, Integer>(4);
        periodYears.put("MinPeriodYear", new Integer(minPeriodYear));
        periodYears.put("MaxPeriodYear", new Integer(maxPeriodYear));
        periodYears.put("MinPeriodNumber", new Integer(minPeriodNumber));
        periodYears.put("MaxPeriodNumber", new Integer(maxPeriodNumber));
        return periodYears;
    }

    @Override
    protected int _findPeriodNum(Context ctx, int periodYear, String periodTypeID) throws BOSException {
        int periodNum = 0;
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT COUNT(*) AS periodNum");
            sql.append(" FROM T_BD_Period period");
            sql.append(" Where period.FPeriodYear = ").append(periodYear);
            sql.append(" AND period.FTypeID = '").append(periodTypeID).append("'");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rowSet.next()) {
                periodNum = rowSet.getInt("periodNum");
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        return periodNum;
    }

    @Override
    protected CompanyOrgUnitCollection _findCompanyCollection(Context ctx, String accountTableID, String periodTypeID, String bookScheme) throws BOSException, EASBizException {
        CompanyOrgUnitInfo currCompany = ContextUtil.getCurrentFIUnit((Context)ctx);
        AcountSchemeInfo schemeInfo = null;
        if (bookScheme != null) {
            schemeInfo = AcountSchemeFactory.getLocalInstance((Context)ctx).getAcountSchemeInfo((IObjectPK)new ObjectUuidPK(bookScheme));
        }
        StringBuffer sql = new StringBuffer();
        if (schemeInfo != null && !schemeInfo.isIsMaster()) {
            sql.append("SELECT bookCompany.FID AS COMPANYID ,bookCompany.FName_l2 AS COMPANYNAME, bookCompany.FParentID AS ParentID");
        } else {
            sql.append("SELECT company.FID AS COMPANYID ,company.FName_l2 AS COMPANYNAME, company.FParentID AS ParentID");
        }
        sql.append(" FROM T_BD_SystemStatusCtrol ssc");
        sql.append(" INNER JOIN T_BD_Period currPeriod ON ssc.FCurrentPeriodID = currPeriod.FID");
        sql.append(" INNER JOIN T_BD_Period startPeriod ON ssc.FStartPeriodID = startPeriod.FID");
        sql.append(" INNER JOIN T_ORG_Company company ON ssc.FCompanyID = company.FID");
        if (schemeInfo != null && !schemeInfo.isIsMaster()) {
            sql.append(" INNER JOIN T_ORG_Company bookCompany ON bookCompany.FMainOrgID = company.FID");
        }
        sql.append(" INNER JOIN T_BD_SystemStatus ss ON ss.FID = ssc.FSystemStatusID");
        sql.append(" LEFT JOIN T_BKS_AcountScheme sche on sche.fid=company.faccountschemeid ");
        sql.append(" WHERE ss.FName = ").append(14);
        sql.append(" AND (company.FLongNumber = '").append(currCompany.getLongNumber()).append("'");
        sql.append(" OR company.FLongNumber LIKE '").append(currCompany.getLongNumber()).append("!%')");
        sql.append(" AND company.FAccountTableID = '").append(accountTableID).append("'");
        sql.append(" AND currPeriod.FTypeID = '").append(periodTypeID).append("'");
        sql.append(" AND  (sche.FIsMaster = 1 ");
        sql.append(" OR  company.faccountschemeid is null) ");
        if (bookScheme != null && schemeInfo != null && !schemeInfo.isIsMaster()) {
            sql.append(" AND  bookCompany.faccountschemeid = '" + bookScheme + "' ");
        }
        sql.append(" AND company.fid in (").append(this.getOrgRange(ctx)).append(") ");
        sql.append(" ORDER BY company.FLongNumber");
        CompanyOrgUnitCollection coll = new CompanyOrgUnitCollection();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)FaLocalUtils.transformLocal((Context)ctx, (String)sql.toString()));
            while (rs.next()) {
                CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
                company.setId(BOSUuid.read((String)rs.getString("COMPANYID")));
                company.setName(rs.getString("COMPANYNAME"));
                String parentID = rs.getString("ParentID");
                if (parentID != null) {
                    CompanyOrgUnitInfo parent = new CompanyOrgUnitInfo();
                    parent.setId(BOSUuid.read((String)parentID));
                    company.setParent(parent);
                }
                coll.add(company);
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        return coll;
    }

    @Override
    protected int _findMaxLevel(Context ctx, FaSumItemEnum sumItem) throws BOSException {
        int maxLevel = 0;
        String tableName = null;
        if (FaSumItemEnum.assetCat.equals((Object)sumItem)) {
            tableName = "T_Fa_Cat";
        } else if (FaSumItemEnum.useDepartment.equals((Object)sumItem)) {
            tableName = "T_ORG_Admin";
        } else if (FaSumItemEnum.originMethod.equals((Object)sumItem)) {
            tableName = "T_Fa_AlterMode";
        } else if (FaSumItemEnum.useStatus.equals((Object)sumItem)) {
            tableName = "T_Fa_UseStatus";
        }
        if (tableName != null) {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)("SELECT Max(FLevel) AS MasLevel FROM " + tableName));
            try {
                if (rs != null && rs.next()) {
                    maxLevel = rs.getInt("MasLevel");
                }
            }
            catch (SQLException ex) {
                throw new BOSException((Throwable)ex);
            }
        }
        return maxLevel;
    }

    @Override
    protected Map _findMinMaxPeriodsOfYear(Context ctx, int periodYear, String periodTypeID) throws BOSException {
        int minPeriodNum = 1;
        int maxPeriodNum = 12;
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT max(FPeriodNumber) AS MaxPeriodNum,min(FPeriodNumber) AS MinPeriodNum");
            sql.append(" FROM T_BD_Period period");
            sql.append(" Where period.FPeriodYear = ").append(periodYear);
            sql.append(" AND period.FTypeID = '").append(periodTypeID).append("'");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rowSet.next()) {
                minPeriodNum = rowSet.getInt("MinPeriodNum");
                maxPeriodNum = rowSet.getInt("MaxPeriodNum");
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        HashMap<String, Integer> periodYears = new HashMap<String, Integer>(2);
        periodYears.put("MinPeriodNumber", new Integer(minPeriodNum));
        periodYears.put("MaxPeriodNumber", new Integer(maxPeriodNum));
        return periodYears;
    }

    @Override
    protected HashMap _getQueryInfo(Context ctx, IObjectValue companyInfo, List idList, String periodTypeID) throws BOSException, EASBizException {
        HashMap<String, Object> initInfo = new HashMap<String, Object>();
        CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
        if (companyInfo != null) {
            company = (CompanyOrgUnitInfo)companyInfo;
            PeriodInfo currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)company);
            initInfo.put("currentPeriod", currentPeriod);
            PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)company);
            initInfo.put("startPeriod", startPeriod);
            if (idList == null) {
                idList = new ArrayList<String>();
            }
            idList.add(company.getId().toString());
            if (currentPeriod != null) {
                Integer periodNum = new Integer(this._findPeriodNum(ctx, currentPeriod.getPeriodYear(), company.getAccountPeriodType().getId().toString()));
                initInfo.put("periodNum", periodNum);
            }
        }
        Map periodYears = this._findPeriodYears(ctx, idList);
        initInfo.put("findPeriodYears", periodYears);
        Integer maxPeriodYear = (Integer)periodYears.get("MaxPeriodYear");
        Map minMaxPeriodYear = null;
        minMaxPeriodYear = periodTypeID != null ? this._findMinMaxPeriodsOfYear(ctx, maxPeriodYear, periodTypeID) : this._findMinMaxPeriodsOfYear(ctx, maxPeriodYear, company.getAccountPeriodType().getId().toString());
        initInfo.put("minMaxPeriodYear", minMaxPeriodYear);
        return initInfo;
    }

    @Override
    protected HashMap _getDefaultSolution(Context ctx, String className, String queryName, String currCompanyID, String currUserID) throws BOSException, EASBizException {
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getLocalInstance((Context)ctx);
        Boolean hasDefaultSolution = iQuery.hasDefaultSolution(className, queryName, currCompanyID, currUserID);
        EntityViewInfo ev = (EntityViewInfo)iQuery.getDefaultFilterInfo(className, queryName, currCompanyID, currUserID);
        QuerySolutionInfo solutionInfo = iQuery.getDefaultSolution(className, queryName, currCompanyID, currUserID);
        HashMap<String, Boolean> initInfo = new HashMap<String, Boolean>();
        initInfo.put("hasDefaultSolution", hasDefaultSolution);
        initInfo.put("ev", (Boolean)ev);
        initInfo.put("solutionInfo", (Boolean)solutionInfo);
        return initInfo;
    }

    @Override
    protected Map _getCatAdminNum(Context ctx, EntityViewInfo ev, String daoClassName) throws BOSException, EASBizException {
        FaDaoBase dao = FaDaoFactory.createDao(daoClassName);
        dao.init(ctx, ev);
        return dao.getResult();
    }

    @Override
    protected IRowSet _getTreeDataForFirstSpec(Context ctx, FaDaoSqlObject sqlDao, int length, int topLevel, int specLevel) throws BOSException {
        sqlDao.setSelect(" TOP " + length + " " + sqlDao.getSelect());
        int level = topLevel + specLevel + 1;
        String where = "(SumLevel < " + level + " and isSum >= 1) or (SumLevel+1 < " + level + " and isSum = 0)";
        if (sqlDao.getWhere().trim().length() == 0) {
            sqlDao.setWhere(where);
        } else {
            sqlDao.setWhere("( " + sqlDao.getWhere() + ") AND " + where);
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlDao.getSql());
        return rowSet;
    }

    @Override
    protected Map _findPeriodYearsForLcm(Context ctx, List companyIDList) throws BOSException {
        int minPeriodYear = 0;
        int maxPeriodYear = 0;
        int minPeriodNumber = 0;
        int maxPeriodNumber = 0;
        if (companyIDList != null && companyIDList.size() > 0) {
            String operator;
            StringBuffer companyIds = new StringBuffer();
            companyIds.append("'").append(companyIDList.get(0)).append("'");
            int size = companyIDList.size();
            for (int i = 1; i < size; ++i) {
                companyIds.append(",'").append(companyIDList.get(i).toString()).append("'");
            }
            String companys = companyIds.toString();
            if (companyIDList.size() == 1) {
                operator = " = ";
            } else {
                companys = "(" + companys + ")";
                operator = " IN ";
            }
            try {
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT min(period.FPeriodYear) AS minPeriodYear");
                sql.append(" FROM T_BD_SystemStatusCtrol ssc");
                sql.append(" INNER JOIN T_BD_Period period ON ssc.FStartPeriodID = period.FID");
                sql.append(" INNER JOIN T_BD_SystemStatus ss ON ssc.FsystemStatusID = ss.FID");
                sql.append(" Where ssc.FCompanyID ").append(operator).append(companys);
                sql.append(" AND ss.FName = ").append(32);
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                if (rowSet.next()) {
                    minPeriodYear = rowSet.getInt("minPeriodYear");
                }
                sql = new StringBuffer();
                sql.append("SELECT min(period.FPeriodNumber) AS minPeriodNumber");
                sql.append(" FROM T_BD_SystemStatusCtrol ssc");
                sql.append(" INNER JOIN T_BD_Period period ON ssc.FStartPeriodID = period.FID");
                sql.append(" INNER JOIN T_BD_SystemStatus ss ON ssc.FsystemStatusID = ss.FID");
                sql.append(" Where period.FPeriodYear = ").append(minPeriodYear);
                sql.append(" AND ssc.FCompanyID ").append(operator).append(companys);
                sql.append(" AND ss.FName = ").append(32);
                rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                if (rowSet.next()) {
                    minPeriodNumber = rowSet.getInt("minPeriodNumber");
                }
                sql = new StringBuffer();
                sql.append("SELECT max(period.FPeriodYear) AS maxPeriodYear");
                sql.append(" FROM T_BD_SystemStatusCtrol ssc");
                sql.append(" INNER JOIN T_BD_Period period ON ssc.FCurrentPeriodID = period.FID");
                sql.append(" INNER JOIN T_BD_SystemStatus ss ON ssc.FsystemStatusID = ss.FID");
                sql.append(" Where ssc.FCompanyID ").append(operator).append(companys);
                sql.append(" AND ss.FName = ").append(32);
                rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                if (rowSet.next()) {
                    maxPeriodYear = rowSet.getInt("maxPeriodYear");
                }
                sql = new StringBuffer();
                sql.append("SELECT max(period.FPeriodNumber) AS maxPeriodNumber");
                sql.append(" FROM T_BD_SystemStatusCtrol ssc");
                sql.append(" INNER JOIN T_BD_Period period ON ssc.FCurrentPeriodID = period.FID");
                sql.append(" INNER JOIN T_BD_SystemStatus ss ON ssc.FsystemStatusID = ss.FID");
                sql.append(" Where period.FPeriodYear = ").append(maxPeriodYear);
                sql.append(" AND ssc.FCompanyID ").append(operator).append(companys);
                sql.append(" AND ss.FName = ").append(32);
                rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                if (rowSet.next()) {
                    maxPeriodNumber = rowSet.getInt("maxPeriodNumber");
                }
            }
            catch (SQLException ex) {
                throw new BOSException((Throwable)ex);
            }
        }
        HashMap<String, Integer> periodYears = new HashMap<String, Integer>(4);
        periodYears.put("MinPeriodYear", new Integer(minPeriodYear));
        periodYears.put("MaxPeriodYear", new Integer(maxPeriodYear));
        periodYears.put("MinPeriodNumber", new Integer(minPeriodNumber));
        periodYears.put("MaxPeriodNumber", new Integer(maxPeriodNumber));
        return periodYears;
    }

    private String getOrgRange(Context ctx) throws EASBizException, BOSException {
        StringBuffer orgIds = new StringBuffer();
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        List orgIdList = OrgRangeFactory.getLocalInstance((Context)ctx).getOrgIdByUserAndType((IObjectPK)new ObjectUuidPK(user.getId()), OrgRangeType.BIZ_ORG_TYPE);
        for (String orgId : orgIdList) {
            orgIds.append("'").append(orgId).append("'");
            orgIds.append(",");
        }
        if (orgIds.length() > 1) {
            orgIds.deleteCharAt(orgIds.length() - 1);
        }
        return orgIds.toString();
    }

    @Override
    protected IRowSet _getDataForPropertyValue(Context ctx, FaDaoSqlObject sqlDao, List idList) throws BOSException {
        if (idList.size() == 0) {
            return null;
        }
        IRowSet rowSet = null;
        if (sqlDao.getSecondTable() != null) {
            StringBuffer sql = new StringBuffer();
            FaDaoDefPart def = new FaDaoDefPart(null, ctx);
            sql.append("SELECT B.FID, B.CARDID ");
            sql.append(def.getSelectPart("B"));
            sql.append(def.getSelectPart("B", "b"));
            sql.append(" FROM " + sqlDao.getSecondTable() + " AS B ");
            sql.append(" WHERE B.FID IN ");
            StringBuffer fid = new StringBuffer("( ? ");
            int n = idList.size();
            for (int i = 1; i < n; ++i) {
                fid.append(", ? ");
            }
            fid.append(" ) ");
            sql.append(fid.toString());
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])idList.toArray());
        }
        return rowSet;
    }

    @Override
    protected IRowSet _queryData4excel(Context ctx, String querySql, Map map) throws BOSException, EASBizException {
        if ("excute".equals(map.get("excute"))) {
            DbUtil.execute((Context)ctx, (String)querySql);
            return null;
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)querySql);
        return rowSet;
    }
}

