/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.rpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.rpt.FaRptComposingException;
import com.kingdee.eas.fi.fa.rpt.FaSumItemEnum;
import com.kingdee.eas.fi.fa.rpt.app.AbstractFabiRptComposingFacadeControllerBean;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMQuerySqlBuilder;
import com.kingdee.eas.framework.bireport.util.SchemaSource;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.Set;
import org.apache.log4j.Logger;

public class FabiRptComposingFacadeControllerBean
extends AbstractFabiRptComposingFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.fa.rpt.app.FabiRptComposingFacadeControllerBean");
    public static final String DEFAULT_COMPOSING_MODE = "defaultcomposingmode";
    public static final String BIRPT_FA_COMPOSING_CFG_FILE = "FabiRptComposing.xml";
    public static final String FACT = "Fact";
    public static final String DIM_COMPANY = "Company";
    public static final String DIM_COMPOSINGMODE = "ComposingMode";
    public static final String FA_COMPOSING_TEMP_TABLE_DESCRIPTION = "FAComposing";

    protected SchemaSource readySchemaSource(RptParams params, Context ctx) throws BOSException, EASBizException {
        SchemaSource ss = new SchemaSource();
        ss.setCaller(this.getClass());
        this.prepareSchemaSource(params, ctx, ss);
        return ss;
    }

    private void prepareSchemaSource(RptParams params, Context ctx, SchemaSource ss) throws BOSException, EASBizException {
        Set companyIdSet = (Set)params.getObject("companyIdSet");
        int periodYear = params.getInt("acctPeriodYear");
        int periodNumber = params.getInt("acctPeriodNumber");
        PeriodCollection periodInfos = this.queryPeriod(periodYear, periodNumber, ctx);
        FaSumItemEnum composingMode = (FaSumItemEnum)((Object)params.getObject("composingMode"));
        ss.setDataItem(DIM_COMPANY, this.getCompanyRowSet(ctx, companyIdSet), null);
        ss.setDataItem(DIM_COMPOSINGMODE, this.getComposingModeRowSet(composingMode, ctx, companyIdSet), null);
        String tempTableName = this.generateResult(composingMode, params, ctx, companyIdSet, periodInfos);
        StringBuffer sbSql = new StringBuffer();
        sbSql.append("select fcompanyid,fassetvalue,fcomposingmode from ");
        sbSql.append(tempTableName);
        ss.setDataItem(FACT, sbSql.toString(), null);
        ss.setMdx(this.getMDX(composingMode));
        ss.setFilename(BIRPT_FA_COMPOSING_CFG_FILE);
        this.configMacroValues(ss, composingMode);
    }

    private void configMacroValues(SchemaSource ss, FaSumItemEnum composingMode) throws FaRptComposingException {
        ss.setMacroValue("companyCaption", EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"company"));
        ss.setMacroValue("cubeCaption", EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"faComposingAnalysis"));
        ss.setMacroValue("fAssetValue", EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"percentage"));
        if (FaSumItemEnum.assetCat == composingMode) {
            ss.setMacroValue("composingModeCaption", EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"assetCat"));
        } else if (FaSumItemEnum.useStatus == composingMode) {
            ss.setMacroValue("composingModeCaption", EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"useStatus"));
        } else if (FaSumItemEnum.economicPurp == composingMode) {
            ss.setMacroValue("composingModeCaption", EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"economicPurp"));
        } else if (FaSumItemEnum.originMethod == composingMode) {
            ss.setMacroValue("composingModeCaption", EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"originMethod"));
        } else if (FaSumItemEnum.storeCity == composingMode) {
            ss.setMacroValue("composingModeCaption", EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"storeCity"));
        } else if (FaSumItemEnum.useDepartment == composingMode) {
            ss.setMacroValue("composingModeCaption", EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"useDepartment"));
        } else if (FaSumItemEnum.asstActItem == composingMode) {
            ss.setMacroValue("composingModeCaption", EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"costCenter"));
        } else {
            throw new FaRptComposingException(FaRptComposingException.UNKNOWNCOMPOSINGMODE, new Object[]{composingMode});
        }
    }

    private String getCompanyRowSet(Context ctx, Set companyIdSet) throws BOSException {
        String loc = FabiRptComposingFacadeControllerBean.getLoc((Context)ctx);
        FMQuerySqlBuilder sb = new FMQuerySqlBuilder();
        sb.appendSql(" select a.fid, a.fname_").appendSql(loc);
        sb.appendSql(" fname, a.fparentid from t_org_company  a");
        if (companyIdSet != null && !companyIdSet.isEmpty()) {
            sb.appendSql(" where");
            sb.appendParam(" a.fid", companyIdSet.toArray());
        }
        return sb.getTestSql();
    }

    private String getComposingModeRowSet(FaSumItemEnum composingMode, Context ctx, Set companyIdSet) throws BOSException, EASBizException {
        String loc = FabiRptComposingFacadeControllerBean.getLoc((Context)ctx);
        FMQuerySqlBuilder sql = new FMQuerySqlBuilder();
        if (FaSumItemEnum.assetCat == composingMode) {
            sql.appendSql("select distinct c.flongnumber fid,c.fname_");
            sql.appendSql(loc).appendSql(" fname,");
            sql.appendSql(" '' fparentid from t_fa_cat c");
            sql.appendSql(" union ");
            sql.appendSql(" select distinct N'").appendSql(DEFAULT_COMPOSING_MODE).appendSql("' fid,");
            sql.appendSql(" N'").appendSql(EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"noAssetCategory")).appendSql("' fname,");
            sql.appendSql(" '' fparentid from t_fa_cat");
        } else if (FaSumItemEnum.useStatus == composingMode) {
            sql.appendSql("select distinct c.flongnumber fid,c.fname_");
            sql.appendSql(loc).appendSql(" fname,");
            sql.appendSql(" '' fparentid from t_fa_usestatus c");
            sql.appendSql(" union ");
            sql.appendSql(" select distinct N'").appendSql(DEFAULT_COMPOSING_MODE).appendSql("' fid,");
            sql.appendSql(" N'").appendSql(EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"noUseStatus")).appendSql("' fname,");
            sql.appendSql(" '' fparentid from t_fa_usestatus");
        } else if (FaSumItemEnum.economicPurp == composingMode) {
            sql.appendSql("select distinct c.flongnumber fid,c.fname_");
            sql.appendSql(loc).appendSql(" fname,");
            sql.appendSql(" '' fparentid from t_fa_faeconomicpurp c");
            sql.appendSql(" union ");
            sql.appendSql(" select distinct N'").appendSql(DEFAULT_COMPOSING_MODE).appendSql("' fid,");
            sql.appendSql(" N'").appendSql(EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"noEconomicPurp")).appendSql("' fname,");
            sql.appendSql(" '' fparentid from t_fa_faeconomicpurp");
        } else if (FaSumItemEnum.originMethod == composingMode) {
            sql.appendSql("select distinct c.flongnumber fid,c.fname_");
            sql.appendSql(loc).appendSql(" fname,");
            sql.appendSql(" '' fparentid from t_fa_altermode c");
            sql.appendSql(" union ");
            sql.appendSql(" select distinct N'").appendSql(DEFAULT_COMPOSING_MODE).appendSql("' fid,");
            sql.appendSql(" N'").appendSql(EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"noOriginMethod")).appendSql("' fname,");
            sql.appendSql(" '' fparentid from t_fa_altermode");
        } else if (FaSumItemEnum.storeCity == composingMode) {
            sql.appendSql(" select ac.fid,ac.fname_");
            sql.appendSql(loc).appendSql(" fname,");
            sql.appendSql(" ac.fparentid from t_bd_addressclass ac");
            sql.appendSql(" union");
            sql.appendSql(" select a.fid,a.fname_");
            sql.appendSql(loc).appendSql(" fname,");
            sql.appendSql(" a.fclassid fparentid from t_bd_address a");
            sql.appendSql(" union ");
            sql.appendSql(" select distinct '").appendSql(DEFAULT_COMPOSING_MODE).appendSql("' fid,");
            sql.appendSql(" N'").appendSql(EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"noStoreCity")).appendSql("' fname,");
            sql.appendSql(" '' fparentid from t_bd_addressclass");
        } else if (FaSumItemEnum.useDepartment == composingMode) {
            sql.appendSql(" select a.fid, a.fname_");
            sql.appendSql(loc).appendSql(" fname,");
            sql.appendSql(" a.fparentid from t_org_admin a");
            sql.appendSql(" union ");
            sql.appendSql(" select distinct '").appendSql(DEFAULT_COMPOSING_MODE).appendSql("' fid,");
            sql.appendSql(" N'").appendSql(EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"noDepartment")).appendSql("' fname,");
            sql.appendSql(" '' fparentid from t_org_admin");
        } else if (FaSumItemEnum.asstActItem == composingMode) {
            sql.appendSql(" select a.fid, a.fname_");
            sql.appendSql(loc).appendSql(" fname,");
            sql.appendSql(" '' fparentid from t_bd_asstacttype a");
            sql.appendSql(" union ");
            sql.appendSql(" select distinct '").appendSql(DEFAULT_COMPOSING_MODE).appendSql("' fid,");
            sql.appendSql(" N'").appendSql(EASResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"noAssist")).appendSql("' fname,");
            sql.appendSql(" '' fparentid from t_bd_asstacttype");
        } else {
            throw new FaRptComposingException(FaRptComposingException.UNKNOWNCOMPOSINGMODE, new Object[]{composingMode});
        }
        return sql.getTestSql();
    }

    private String getMDX(FaSumItemEnum composingMode) {
        StringBuffer mdx = new StringBuffer();
        mdx.append(" select [Measures].members on columns,");
        mdx.append(" [ComposingMode].levels(0).members on rows");
        mdx.append(" from faComposing");
        return mdx.toString();
    }

    private String generateResult(FaSumItemEnum composingMode, RptParams params, Context ctx, Set companyIdSet, PeriodCollection periodInfos) throws BOSException, EASBizException {
        this.releaseTempTable(ctx);
        String tempTableName = FabiRptComposingFacadeControllerBean.getTempTableName((String)FA_COMPOSING_TEMP_TABLE_DESCRIPTION, (Context)ctx);
        String sqlCurPeriod = this.getSelectIntoDataSql(tempTableName, composingMode, params, companyIdSet, periodInfos.get(0), true);
        String sqlPrePeriod = this.getInertIntoDataSql(tempTableName, composingMode, params, companyIdSet, periodInfos.get(0), false);
        FabiRptComposingFacadeControllerBean.executeSelectInto((String)sqlCurPeriod, null, (Context)ctx);
        DbUtil.execute((Context)ctx, (String)sqlPrePeriod);
        for (int i = 1; i < periodInfos.size(); ++i) {
            String curInsertSql = this.getInertIntoDataSql(tempTableName, composingMode, params, companyIdSet, periodInfos.get(i), true);
            String preInsertSql = this.getInertIntoDataSql(tempTableName, composingMode, params, companyIdSet, periodInfos.get(i), false);
            DbUtil.execute((Context)ctx, (String)curInsertSql);
            DbUtil.execute((Context)ctx, (String)preInsertSql);
        }
        StringBuffer sqlUpdate = new StringBuffer();
        sqlUpdate.append(" update ").append(tempTableName);
        sqlUpdate.append(" set  fcomposingmode='");
        sqlUpdate.append(DEFAULT_COMPOSING_MODE).append("'");
        sqlUpdate.append(" where fcomposingmode is null");
        DbUtil.execute((Context)ctx, (String)sqlUpdate.toString());
        return tempTableName;
    }

    private void releaseTempTable(Context ctx) throws BOSException {
        String tempTableName = FabiRptComposingFacadeControllerBean.getTempTableName((String)FA_COMPOSING_TEMP_TABLE_DESCRIPTION, (Context)ctx);
        if (tempTableName != null && tempTableName.trim().length() != 0) {
            FabiRptComposingFacadeControllerBean.dropTempTable((String)tempTableName, (Context)ctx);
        }
    }

    private String getSelectIntoDataSql(String tabName, FaSumItemEnum composingMode, RptParams params, Set companyIdSet, PeriodInfo periodInfo, boolean isCurrentPeriod) throws EASBizException {
        FMQuerySqlBuilder sql = new FMQuerySqlBuilder();
        sql.appendSql("select fcompanyid,fassetvalue,fcomposingmode");
        sql.appendSql(" into ").appendSql(tabName).appendSql(" from");
        sql.appendSql("(");
        sql.appendSql(this.getSubQuerySql(isCurrentPeriod, composingMode, params, companyIdSet, periodInfo));
        sql.appendSql(")");
        return sql.getTestSql();
    }

    private String getInertIntoDataSql(String tabName, FaSumItemEnum composingMode, RptParams params, Set companyIdSet, PeriodInfo periodInfo, boolean isCurrentPeriod) throws EASBizException {
        FMQuerySqlBuilder sql = new FMQuerySqlBuilder();
        sql.appendSql("insert into ").appendSql(tabName);
        sql.appendSql(" select fcompanyid,fassetvalue,fcomposingmode");
        sql.appendSql(" from");
        sql.appendSql(" (");
        sql.appendSql(this.getSubQuerySql(isCurrentPeriod, composingMode, params, companyIdSet, periodInfo));
        sql.appendSql(" )");
        return sql.getTestSql();
    }

    private String getSubQuerySql(boolean isCurrentPeriod, FaSumItemEnum composingMode, RptParams params, Set companyIdSet, PeriodInfo periodInfo) throws EASBizException {
        String queryCriteria = this.getQueryCriteria(isCurrentPeriod, params, companyIdSet, periodInfo);
        if (FaSumItemEnum.useDepartment == composingMode) {
            if (isCurrentPeriod) {
                return this.getJoinTableQuerySql(queryCriteria, "t_fa_facurcard", "t_fa_facurdepartment", "fusedepartmentid", "ffacurcardid");
            }
            return this.getJoinTableQuerySql(queryCriteria, "t_fa_famoncard", "t_fa_famondepartment", "fusedepartmentid", "ffamoncardid");
        }
        if (FaSumItemEnum.asstActItem == composingMode) {
            if (isCurrentPeriod) {
                return this.getJoinTableQuerySql(queryCriteria, "t_fa_facurcard", "t_fa_facurcostcenter", "fasstacttypeid", "ffacurcardid");
            }
            return this.getJoinTableQuerySql(queryCriteria, "t_fa_famoncard", "t_fa_famoncostcenter", "fasstacttypeid", "ffamoncardid");
        }
        return this.getSingleTableQuerySql(isCurrentPeriod, composingMode, queryCriteria);
    }

    private String getSingleTableQuerySql(boolean isCurrentPeriod, FaSumItemEnum composingMode, String queryCriteria) throws EASBizException {
        String cardTable = null;
        cardTable = isCurrentPeriod ? "t_fa_facurcard" : "t_fa_famoncard";
        StringBuffer sql = new StringBuffer();
        if (FaSumItemEnum.assetCat == composingMode) {
            sql.append(" select c.fid,c.fassetvalue,t.flongnumber");
            sql.append(" fcomposingmode,c.fcompanyid from");
            sql.append(" ").append(cardTable).append(" c");
            sql.append(" left join t_fa_cat t on c.fassetcatid=t.fid");
        } else if (FaSumItemEnum.useStatus == composingMode) {
            sql.append(" select c.fid,c.fassetvalue,t.flongnumber");
            sql.append(" fcomposingmode,c.fcompanyid from");
            sql.append(" ").append(cardTable).append(" c");
            sql.append(" left join t_fa_usestatus t on c.fusestatusid=t.fid");
        } else if (FaSumItemEnum.economicPurp == composingMode) {
            sql.append(" select c.fid,c.fassetvalue,t.flongnumber");
            sql.append(" fcomposingmode,c.fcompanyid from");
            sql.append(" ").append(cardTable).append(" c");
            sql.append(" left join t_fa_faeconomicpurp t");
            sql.append(" on c.feconomicpurpid=t.fid");
        } else if (FaSumItemEnum.originMethod == composingMode) {
            sql.append(" select c.fid,c.fassetvalue,t.flongnumber");
            sql.append(" fcomposingmode,c.fcompanyid from");
            sql.append(" ").append(cardTable).append(" c");
            sql.append(" left join t_fa_altermode t");
            sql.append(" on c.foriginmethodid=t.fid");
        } else if (FaSumItemEnum.storeCity == composingMode) {
            sql.append("select c.fid,c.fcompanyid,c.fassetvalue");
            sql.append(" ,c.fstorecityid fcomposingmode from");
            sql.append(" ").append(cardTable).append(" c");
        } else {
            throw new FaRptComposingException(FaRptComposingException.UNKNOWNCOMPOSINGMODE, new Object[]{composingMode});
        }
        sql.append(queryCriteria);
        return sql.toString();
    }

    private String getQueryCriteria(boolean isCurrentPeriod, RptParams params, Set companyIdSet, PeriodInfo periodInfo) {
        StringBuffer sql = new StringBuffer();
        String periodColumnName = null;
        periodColumnName = isCurrentPeriod ? "fperiodid" : "ffaperiodid";
        sql.append(" where ").append(periodColumnName);
        sql.append(" ='").append(periodInfo.getId().toString());
        sql.append("'");
        sql.append(" and ");
        sql.append(" fdeletedstatus=").append(1);
        sql.append(" and ");
        sql.append(" feffectedstatus=").append(2);
        sql.append(" and ");
        sql.append(" fblockedstatus=").append(1);
        sql.append(" and ");
        sql.append(" fcheckedstatus=").append(2);
        sql.append(" and ");
        sql.append(" fhasdisabled=0");
        if (companyIdSet != null && !companyIdSet.isEmpty()) {
            sql.append(" and ");
            sql.append(FMHelper.buildIn((String)"c.fcompanyid", (Object[])companyIdSet.toArray()));
        }
        return sql.toString();
    }

    private String getJoinTableQuerySql(String queryCriteria, String cardTableName, String joinTableName, String fkValueColName, String joinColName) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select c.cardid fid,c.fcompanyid,c.").append(fkValueColName);
        sql.append(" fcomposingmode,");
        sql.append(" d.favgvalue fassetvalue from");
        sql.append(" (");
        sql.append(" select c.fid cardid,c.fcompanyid,d.");
        sql.append(fkValueColName).append(" from ");
        sql.append(cardTableName).append(" c");
        sql.append(" left join ").append(joinTableName);
        sql.append(" d on c.fid=d.").append(joinColName);
        sql.append(queryCriteria);
        sql.append(" ) c");
        sql.append(" left join");
        sql.append(" (");
        sql.append(" select c.fid cardid,c.fassetvalue/count(*) favgvalue from ");
        sql.append(cardTableName).append(" c");
        sql.append(" left join ").append(joinTableName);
        sql.append(" d on c.fid=d.").append(joinColName);
        sql.append(queryCriteria);
        sql.append(" group by c.fid,c.fassetvalue");
        sql.append(" ) d ");
        sql.append(" on c.cardid=d.cardid");
        return sql.toString();
    }

    private PeriodCollection queryPeriod(int periodYear, int periodNumber, Context ctx) throws BOSException {
        IPeriod iPeriod = PeriodFactory.getLocalInstance((Context)ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(periodYear), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodNumber", (Object)new Integer(periodNumber), CompareType.EQUALS));
        filter.setMaskString("#0 and #1");
        evi.setFilter(filter);
        return iPeriod.getPeriodCollection(evi);
    }

    @Override
    protected IObjectCollection _queryIntersectionAcctPeriod(Context ctx, Set companyIdSet) throws BOSException, EASBizException {
        String sqlSubQuery = this.queryCompanyPeriodSql(companyIdSet);
        FMQuerySqlBuilder sqlJudge = new FMQuerySqlBuilder();
        sqlJudge.appendSql(" select count(*) cnt\u3000from");
        sqlJudge.appendSql(" (").appendSql(sqlSubQuery).appendSql(" )");
        sqlJudge.appendSql(" where maxstartperiod is  null or mincurrperiod is null");
        IRowSet judgeRowSet = DbUtil.executeQueryNoTx((Context)ctx, (String)sqlJudge.getTestSql());
        try {
            judgeRowSet.next();
            if (judgeRowSet.getInt(1) > 0) {
                return new PeriodCollection();
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        FMQuerySqlBuilder sqlInfo = new FMQuerySqlBuilder();
        sqlInfo.appendSql(" select max(maxstartperiod),min(mincurrperiod) from");
        sqlInfo.appendSql(" (").appendSql(sqlSubQuery).appendSql(" )");
        IRowSet infoRowSet = DbUtil.executeQueryNoTx((Context)ctx, (String)sqlInfo.getTestSql());
        int maxStartPeriod = 0;
        int mixCurrPeriod = 0;
        try {
            infoRowSet.next();
            maxStartPeriod = infoRowSet.getInt(1);
            mixCurrPeriod = infoRowSet.getInt(2);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        FMQuerySqlBuilder periodSql = new FMQuerySqlBuilder();
        periodSql.appendSql(" select fid,fperiodyear,fperiodnumber,fnumber");
        periodSql.appendSql(" from t_bd_period p where p.fnumber <= ");
        periodSql.appendSql(String.valueOf(mixCurrPeriod));
        periodSql.appendSql(" and p.fnumber >= ");
        periodSql.appendSql(String.valueOf(maxStartPeriod));
        IRowSet periodRowSet = DbUtil.executeQueryNoTx((Context)ctx, (String)periodSql.getTestSql());
        PeriodCollection periodCollection = new PeriodCollection();
        try {
            while (periodRowSet.next()) {
                String periodId = periodRowSet.getString(1);
                int periodYear = periodRowSet.getInt(2);
                int periodNumber = periodRowSet.getInt(3);
                int number = periodRowSet.getInt(4);
                PeriodInfo periodInfo = new PeriodInfo();
                periodInfo.setPeriodYear(periodYear);
                periodInfo.setPeriodNumber(periodNumber);
                periodInfo.setNumber(number);
                periodInfo.setId(BOSUuid.create((String)periodId));
                periodCollection.add(periodInfo);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return periodCollection;
    }

    private String queryCompanyPeriodSql(Set companyIdSet) {
        FMQuerySqlBuilder sqlSubQuery = new FMQuerySqlBuilder();
        sqlSubQuery.appendSql(" select startperiod.fnumber maxstartperiod");
        sqlSubQuery.appendSql(" ,currperiod.fnumber mincurrperiod");
        sqlSubQuery.appendSql(" from t_org_company company");
        sqlSubQuery.appendSql(" left join t_bd_systemstatusctrol ssc");
        sqlSubQuery.appendSql(" on ssc.fcompanyid = company.fid");
        sqlSubQuery.appendSql(" left join t_bd_systemstatus ss");
        sqlSubQuery.appendSql(" on ss.fid = ssc.fsystemstatusid");
        sqlSubQuery.appendSql(" left join t_bd_period currperiod");
        sqlSubQuery.appendSql(" on ssc.fcurrentperiodid = currperiod.fid");
        sqlSubQuery.appendSql(" left join t_bd_period startperiod ");
        sqlSubQuery.appendSql(" on ssc.fstartperiodid = startperiod.fid");
        sqlSubQuery.appendSql(" where company.fisleaf=1 and ss.fname =");
        sqlSubQuery.appendSql(String.valueOf(14));
        if (companyIdSet != null && !companyIdSet.isEmpty()) {
            sqlSubQuery.appendSql(" and ");
            sqlSubQuery.appendParam("ssc.fcompanyid", companyIdSet.toArray());
        }
        return sqlSubQuery.getTestSql();
    }

    @Override
    protected void _dropTempTable(Context ctx) throws BOSException {
        this.releaseTempTable(ctx);
    }
}

