/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.fa.rpt.app.dao.FaDaoBase;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;

public class FaAccountEvalDeprDifDao
extends FaDaoBase {
    private boolean allCleanCard = false;
    private boolean isListStyle;
    private int startPeriod;
    private int endPeriod;
    private boolean deprZeroCard = false;
    private boolean cleanCard = false;

    @Override
    protected void buildSql() throws BOSException {
        this.buildResultSql();
    }

    @Override
    protected void buildData() throws BOSException {
        this.addDataTempTable(FaLocalUtils.transformLocal((Context)this.ctx, (String)this.getDeprDetailSql()));
        String sumSql = this.sumOption.getSumSql(this.tempTable, this.getSumSelectSql(), this.getSumSqlDistinctSelect(), null, null, this.isListStyle, false);
        if (sumSql != null && sumSql.trim().length() > 0) {
            DbUtil.execute((Context)this.ctx, (String)sumSql);
            if (!this.isVirCompany) {
                this.setAddUpYearDepre(this.ctx);
            }
        }
        if (!this.isListStyle && this.sumOption.isHasSum()) {
            this.deleteUnnecessaryData();
        }
    }

    private void setAddUpYearDepre(Context ctx) throws BOSException {
        StringBuffer sql = new StringBuffer();
        String total = ResourceBase.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"total2", (Locale)ctx.getOriginLocale());
        String subTotal = ResourceBase.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"subTotal", (Locale)ctx.getOriginLocale());
        sql.append("UPDATE ").append(this.tempTable).append(" SET (ACCUDEPR,ACCUDEPRTYEAR,TAXACCUDEPR,TAXACCUDEPRTYEAR,ACCUDEPRDif,ACCUDEPRTYEARDif) = ");
        sql.append(" (select ACCUDEPR,ACCUDEPRTYEAR,TAXACCUDEPR,TAXACCUDEPRTYEAR,ACCUDEPRDif,ACCUDEPRTYEARDif from  \n");
        sql.append("(select sum(ACCUDEPR) ACCUDEPR ,sum(ACCUDEPRTYEAR) ACCUDEPRTYEAR ,sum(TAXACCUDEPR) TAXACCUDEPR, sum(TAXACCUDEPRTYEAR) TAXACCUDEPRTYEAR ,  sum(ACCUDEPRDif) ACCUDEPRDif ,sum(ACCUDEPRTYEARDif) ACCUDEPRTYEARDif  from ").append(this.tempTable);
        sql.append(" where periodlongnumber in (");
        sql.append(" SELECT max(PeriodLongNumber) from ").append(this.tempTable);
        sql.append(" WHERE PeriodLongNumber like '2%' ) and issum=1 ");
        if (this.isLevelSum("assetCat")) {
            sql.append(" and ASSETCAT1NAME = '" + subTotal + "'");
        } else if (this.isDetailSum("assetCat")) {
            sql.append(" and ASSETCATNAME = '" + subTotal + "'");
        } else {
            sql.append(" and ASSETCAT_NAME = '" + subTotal + "'");
        }
        sql.append(" tmp )) where periodname = '" + total + "'");
        DbUtil.execute((Context)ctx, (String)FaLocalUtils.transformLocal((Context)ctx, (String)sql.toString()));
    }

    @Override
    protected void initEvVar(EntityViewInfo ev) throws EASBizException, BOSException {
        super.initEvVar(ev);
        Map cond = (Map)ev.get("customcond");
        this.allCleanCard = (Boolean)cond.get("hasClearedCard");
        this.isListStyle = (Boolean)cond.get("isSumMode") == false;
        this.deprZeroCard = (Boolean)cond.get("deprZeroCard");
        this.cleanCard = (Boolean)cond.get("cleanCard");
        this.startPeriod = this.startYear * 100 + this.startNumber;
        this.endPeriod = this.endYear * 100 + this.endNumber;
    }

    private String getSelectResultSql() {
        StringBuffer sql = new StringBuffer();
        if (this.isListStyle) {
            if (!this.sumOption.isHasFaCatSum()) {
                sql.append(" ASSETCAT_NAME, ");
            }
            sql.append(" ASSETNUMBER, ");
            sql.append(" olderNumber, ");
            sql.append(" ASSETNAME, ");
            sql.append(" SPECS, ");
        }
        if (this.isListStyle) {
            sql.append(" DEPRMETHOD_NAME, ");
            sql.append(" MonthDepreRate, ");
        }
        sql.append("Depreciation, ");
        sql.append("ShouldDepre, ");
        sql.append("ACCUDEPR, ");
        sql.append("ACCUDEPRTYEAR, ");
        if (this.isListStyle) {
            sql.append(" TAXDEPRMETHOD_NAME, ");
            sql.append(" TAXMonthDepreRate, ");
        }
        sql.append(" TAXDepreciation, ");
        sql.append(" TAXShouldDepre, ");
        sql.append(" TAXACCUDEPR, ");
        sql.append(" TAXACCUDEPRTYEAR, ");
        sql.append(" DepreciationDif, ");
        sql.append(" ShouldDepreDif, ");
        sql.append(" ACCUDEPRDif, ");
        sql.append(" ACCUDEPRTYEARDif, ");
        sql.append(" CardID, ");
        sql.append(" IsSum ");
        return sql.toString();
    }

    private String getSumSelectSql() {
        StringBuffer sql = new StringBuffer();
        if (this.isListStyle) {
            if (!this.sumOption.isHasFaCatSum()) {
                sql.append("TO_CHAR(null) AS ASSETCAT_NAME, ");
            }
            sql.append("TO_CHAR(null) AS ASSETNUMBER, ");
            sql.append("TO_CHAR(null) AS olderNumber, ");
            sql.append("TO_CHAR(null) AS ASSETNAME, ");
            sql.append("TO_CHAR(null) AS SPECS, ");
        }
        if (this.isListStyle) {
            sql.append("TO_CHAR(null) AS DEPRMETHOD_NAME, ");
            sql.append("TO_DECIMAL(null) AS MonthDepreRate, ");
        }
        sql.append("SUM(Depreciation) AS Depreciation, ");
        sql.append("SUM(ShouldDepre) AS ShouldDepre, ");
        sql.append("SUM(ACCUDEPR) AS ACCUDEPR, ");
        sql.append("SUM(ACCUDEPRTYEAR) AS ACCUDEPRTYEAR, ");
        if (this.isListStyle) {
            sql.append("TO_CHAR(null) AS TAXDEPRMETHOD_NAME, ");
            sql.append("TO_DECIMAL(null) AS TAXMonthDepreRate, ");
        }
        sql.append("SUM(TAXDepreciation) AS TAXDepreciation, ");
        sql.append("SUM(TAXShouldDepre) AS TAXShouldDepre, ");
        sql.append("SUM(TAXACCUDEPR) AS TAXACCUDEPR, ");
        sql.append("SUM(TAXACCUDEPRTYEAR) AS TAXACCUDEPRTYEAR, ");
        sql.append("SUM(DepreciationDif) AS DepreciationDif, ");
        sql.append("SUM(ShouldDepreDif) AS ShouldDepreDif, ");
        sql.append("SUM(ACCUDEPRDif) AS ACCUDEPRDif, ");
        sql.append("SUM(ACCUDEPRTYEARDif) AS ACCUDEPRTYEARDif, ");
        sql.append("TO_CHAR(null) AS CardID, ");
        sql.append("1 AS isSum ");
        return sql.toString();
    }

    protected String getSumSqlDistinctSelect() {
        StringBuffer sql = new StringBuffer();
        sql.append("Depreciation, ");
        sql.append("ShouldDepre, ");
        sql.append("ACCUDEPR, ");
        sql.append("ACCUDEPRTYEAR, ");
        sql.append("TAXDepreciation, ");
        sql.append("TAXShouldDepre, ");
        sql.append("TAXACCUDEPR, ");
        sql.append("TAXACCUDEPRTYEAR, ");
        sql.append(" DepreciationDif, ");
        sql.append(" ShouldDepreDif, ");
        sql.append(" ACCUDEPRDif, ");
        sql.append(" ACCUDEPRTYEARDif, ");
        sql.append(" CardID ");
        return sql.toString();
    }

    @Override
    protected String buildSorterSql(EntityViewInfo ev) {
        StringBuffer sorterSql = new StringBuffer();
        if (this.sumOption.isHasSum()) {
            sorterSql.append(this.sumOption.getOrderFields().toString());
            sorterSql.append(",");
        }
        sorterSql.append("isSum");
        if (!this.isListStyle) {
            return sorterSql.toString();
        }
        String sorter = ev.getSorter().toString().trim();
        if (sorter.length() > 0) {
            sorterSql.append(",").append(sorter);
        }
        return sorterSql.toString();
    }

    private String getDeprDetailSql() throws BOSException {
        int start;
        StringBuffer sql = new StringBuffer();
        if (this.isQueryMonPeriod()) {
            sql.append(this.getMonDeprDetailSql());
        }
        if (this.isQueryCurrPeriod()) {
            if (this.isQueryMonPeriod()) {
                sql.append(" UNION ALL ");
            }
            sql.append(this.getCurDeprDetailSql());
        }
        while (sql.indexOf("Period.FNumber") != -1) {
            start = sql.indexOf("Period.FNumber");
            sql.replace(start, start + "Period.FNumber".length(), "(TO_CHAR(Period.FPeriodYear) ||'-'|| TO_CHAR(Period.FPeriodNumber+10))");
        }
        while (sql.indexOf("Period.FName_" + this.ctx.getLocale().toString()) != -1) {
            start = sql.indexOf("Period.FName_" + this.ctx.getLocale().toString());
            sql.replace(start, start + ("Period.FName_" + this.ctx.getLocale().toString()).length(), "(TO_CHAR(Period.FPeriodYear) ||'-'|| TO_CHAR(Period.FPeriodNumber))");
        }
        return sql.toString();
    }

    private ArrayList getPeriodIDList() throws BOSException {
        String queryPeriod = "select p.fid from t_bd_period p where p.FNumber >= " + this.startPeriod + " and p.FNumber <= " + this.endPeriod + " and p.ftypeid = '" + this.currPeriod.getPeriodType().getId().toString() + "'";
        IRowSet rows = DbUtil.executeQuery((Context)this.ctx, (String)queryPeriod);
        ArrayList<String> periods = new ArrayList<String>();
        try {
            while (rows.next()) {
                periods.add(rows.getString("fid"));
            }
        }
        catch (SQLException e) {
            throw new BOSException(queryPeriod, (Throwable)e);
        }
        return periods;
    }

    private String getMonDeprDetailSql() throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT DISTINCT ");
        if (this.sumOption.isHasSum()) {
            sql.append(this.sumOption.getStrNameFields() + ", ");
        }
        if (this.isListStyle) {
            if (!this.sumOption.isHasFaCatSum()) {
                sql.append("ASSETCAT.FName_L2 AS ASSETCAT_NAME, ");
            }
            sql.append("a.ASSETNUMBER,a.olderNumber, a.assetname, a.SPECS, ");
        }
        if (this.isListStyle) {
            sql.append("DEPRMETHOD.FName_L2 AS DEPRMETHOD_NAME, ");
            sql.append("a.FMonthDepreRate AS MonthDepreRate, ");
        }
        sql.append("a.FDepreciation AS Depreciation, ");
        sql.append("a.FShouldDepre AS ShouldDepre, ");
        sql.append("a.ACCUDEPR AS ACCUDEPR, ");
        sql.append("a.ACCUDEPRTYEAR AS ACCUDEPRTYEAR, ");
        if (this.isListStyle) {
            sql.append("TAXDEPRMETHOD.FName_L2 AS TAXDEPRMETHOD_NAME, ");
            sql.append("a.TAXMonthDepreRate AS TAXMonthDepreRate, ");
        }
        sql.append("a.TAXDepreciation AS TAXDepreciation, ");
        sql.append("a.TAXShouldDepre AS TAXShouldDepre, ");
        sql.append("a.TAXACCUDEPR AS TAXACCUDEPR, ");
        sql.append("a.TAXACCUDEPRTYEAR AS TAXACCUDEPRTYEAR, ");
        sql.append("a.FDepreciation-a.TAXDepreciation AS DepreciationDif, ");
        sql.append("a.FShouldDepre-a.TAXShouldDepre AS ShouldDepreDif, ");
        sql.append("a.ACCUDEPR-a.TAXACCUDEPR AS ACCUDEPRDif, ");
        sql.append("a.ACCUDEPRTYEAR-a.TAXACCUDEPRTYEAR AS ACCUDEPRTYEARDif, ");
        sql.append("a.fcardid AS CardID,");
        sql.append("0 AS ISSUM");
        if (this.sumOption.isHasSum()) {
            sql.append(", ").append(this.sumOption.getStrLongNumberFields());
        }
        sql.append(" FROM (");
        sql.append(this.getAllMonDeprSql());
        sql.append(") a");
        sql.append(this.getJoinSql());
        if (this.filter != null) {
            sql.append(" WHERE " + this.filter);
        }
        String tmpSql = "select newbosid('00000000') as fid,t.* from (" + sql.toString() + ") as t";
        return tmpSql;
    }

    private String getAllMonDeprSql() throws BOSException {
        StringBuffer sql = new StringBuffer();
        ArrayList periods = this.getPeriodIDList();
        int i = 0;
        Iterator iter = periods.iterator();
        while (iter.hasNext()) {
            if (i > 0) {
                sql.append(" UNION ALL ");
            }
            String period = iter.next().toString();
            sql.append(this.getMonDeprSql(period));
            ++i;
        }
        return sql.toString();
    }

    private String getMonDeprSql(String period) {
        StringBuffer deprSql = new StringBuffer();
        deprSql.append("SELECT distinct ");
        deprSql.append("c.FNumber AS ASSETNUMBER, ");
        deprSql.append("c.FoldNumber AS olderNumber, ");
        deprSql.append("c.FAssetName AS ASSETNAME, ");
        deprSql.append("tt1.FMonthDepreRate, ");
        deprSql.append("ISNULL(tt1.FShouldDepre,0) - ISNULL(tt1.FWellCost,0) as FShouldDepre, ");
        deprSql.append("ISNULL(tt1.FDepreciation,0) - ISNULL(tt1.FWellCost,0) as FDepreciation, ");
        deprSql.append(" case when (c.fperiodid = e.fid and (c.foriginFlag = ").append(2).append("or c.foriginFlag = ").append(3).append(")) or (cb.fcleardate < e.fbeginDate and (c.fbizStatus = '0499' or c.fbizStatus = '0599')) then 0 else ISNULL(c.FAccuDepr,0) end AS ACCUDEPR, ");
        deprSql.append(" case when (c.fperiodid = e.fid and (c.foriginFlag = ").append(2).append("or c.foriginFlag = ").append(3).append(")) or (cb.fcleardate < e.fbeginDate and (c.fbizStatus = '0499' or c.fbizStatus = '0599')) then 0 else ISNULL(c.FAccuDeprTYear,0) end AS ACCUDEPRTYEAR, ");
        deprSql.append("c.FDeprMethodID, ");
        deprSql.append("tt2.FMonthDepreRate as TAXMonthDepreRate, ");
        deprSql.append("ISNULL(tt2.FShouldDepre,0) as TAXShouldDepre, ");
        deprSql.append("ISNULL(tt2.FDepreciation,0) as TAXDepreciation, ");
        deprSql.append(" case when (c.fperiodid = e.fid and (c.foriginFlag = ").append(2).append("or c.foriginFlag = ").append(3).append(")) or (cb.fcleardate < e.fbeginDate and (c.fbizStatus = '0499' or c.fbizStatus = '0599')) then 0 else ISNULL(c.FEvalAddDepr,0) end AS TAXACCUDEPR, ");
        deprSql.append(" case when (c.fperiodid = e.fid and (c.foriginFlag = ").append(2).append("or c.foriginFlag = ").append(3).append(")) or (cb.fcleardate < e.fbeginDate and (c.fbizStatus = '0499' or c.fbizStatus = '0599')) then 0 else ISNULL(c.FEvalYearDepr,0) end AS TAXACCUDEPRTYEAR, ");
        deprSql.append("c.FEvalDeprModeID, ");
        deprSql.append("c.FAssetCatID,");
        deprSql.append("c.FAssetAmt AS ASSETAMT, ");
        deprSql.append("c.FMeasureUnitID, ");
        deprSql.append("c.FPaperNo AS PAPERNO, ");
        deprSql.append("e.fid AS PeriodID,");
        deprSql.append("c.FCheckedStatus AS CHECKEDSTATUS, ");
        deprSql.append("c.FHasChanged AS HASCHANGED, ");
        deprSql.append("c.FHasCleared AS HASCLEARED, ");
        deprSql.append("c.fid as fcardid, c.FCompanyID, ");
        deprSql.append("c.FDeletedStatus as DeletedStatus, ");
        deprSql.append("c.FSpecs AS SPECS ");
        deprSql.append("from t_fa_famoncard AS c");
        deprSql.append(" left outer join t_fa_clearbillentry ce on ce.fcurcardid = c.ffacurcardid ");
        deprSql.append(" left outer join t_fa_clearbill cb on cb.fid = ce.fentryid ");
        deprSql.append(" LEFT OUTER JOIN (SELECT b.FMonthDepreRate,b.FShouldDepre,b.FWellCost,b.FDepreciation,b.ffacurcardid FROM t_fa_fadepreciationentry b ");
        deprSql.append(" INNER JOIN t_fa_fadepreciation a ON a.fid = b.flnkfadepreentry");
        deprSql.append(" LEFT OUTER JOIN t_bd_period p ON (a.fperiod = p.fid)");
        deprSql.append(" WHERE (a.fcompanyid = '" + this.currCompanyInfo.getId().toString() + "'");
        deprSql.append(" and p.fid = '" + period + "'");
        deprSql.append(" AND (a.fdeptype != 2))");
        deprSql.append(" ) tt1 ON tt1.ffacurcardid = c.ffacurcardid");
        deprSql.append(" LEFT OUTER JOIN (SELECT b.FMonthDepreRate,b.FShouldDepre,b.FDepreciation,b.ffacurcardid FROM t_fa_faevaldepreciationentry  b ");
        deprSql.append(" INNER JOIN t_fa_faevaldepreciation a ON a.fid = b.flnkfadepreentry");
        deprSql.append(" LEFT OUTER JOIN t_bd_period p ON (a.fperiod = p.fid)");
        deprSql.append(" WHERE (a.fcompanyid = '" + this.currCompanyInfo.getId().toString() + "'");
        deprSql.append(" and p.fid = '" + period + "'");
        deprSql.append(" )");
        deprSql.append(" ) tt2 ON tt2.ffacurcardid = c.ffacurcardid");
        deprSql.append(" INNER JOIN T_FA_CAT t on c.fassetcatid = t.fid");
        deprSql.append(" LEFT OUTER JOIN T_BD_Period AS e on (e.fid = '" + period + "' and e.ftypeid = '" + this.currCompanyInfo.getAccountPeriodType().getId().toString() + "')");
        deprSql.append(" where c.fcompanyid = '" + this.currCompanyInfo.getId().toString() + "'");
        deprSql.append(" and e.fid = c.FFaPeriodID");
        deprSql.append(" and c.FLaterPeriodData = 0");
        if (!this.deprZeroCard) {
            deprSql.append(" and (c.fdeprtterm>0 or c.fevaldeprtterm>0)");
        }
        deprSql.append(this.getCondSql());
        return deprSql.toString();
    }

    private String getCurDeprDetailSql() throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT DISTINCT ");
        if (this.sumOption.isHasSum()) {
            sql.append(this.sumOption.getStrNameFields() + ", ");
        }
        if (this.isListStyle) {
            if (!this.sumOption.isHasFaCatSum()) {
                sql.append("ASSETCAT.FName_L2 AS ASSETCAT_NAME, ");
            }
            sql.append("a.ASSETNUMBER,a.olderNumber, a.assetname, a.SPECS, ");
        }
        if (this.isListStyle) {
            sql.append("DEPRMETHOD.FName_L2 AS DEPRMETHOD_NAME, ");
            sql.append("a.FMonthDepreRate AS MonthDepreRate, ");
        }
        sql.append("a.FDepreciation AS Depreciation, ");
        sql.append("a.FShouldDepre AS ShouldDepre, ");
        sql.append("a.ACCUDEPR AS ACCUDEPR, ");
        sql.append("a.ACCUDEPRTYEAR AS ACCUDEPRTYEAR, ");
        if (this.isListStyle) {
            sql.append("TAXDEPRMETHOD.FName_L2 AS TAXDEPRMETHOD_NAME, ");
            sql.append("a.TAXMonthDepreRate AS TAXMonthDepreRate, ");
        }
        sql.append("a.TAXDepreciation AS TAXDepreciation, ");
        sql.append("a.TAXShouldDepre AS TAXShouldDepre, ");
        sql.append("a.TAXACCUDEPR AS TAXACCUDEPR, ");
        sql.append("a.TAXACCUDEPRTYEAR AS TAXACCUDEPRTYEAR, ");
        sql.append("a.FDepreciation-a.TAXDepreciation AS DepreciationDif, ");
        sql.append("a.FShouldDepre-a.TAXShouldDepre AS ShouldDepreDif, ");
        sql.append("a.ACCUDEPR-a.TAXACCUDEPR AS ACCUDEPRDif, ");
        sql.append("a.ACCUDEPRTYEAR-a.TAXACCUDEPRTYEAR AS ACCUDEPRTYEARDif, ");
        sql.append("a.fcardid AS CardID,");
        sql.append("0 AS ISSUM");
        if (this.sumOption.isHasSum()) {
            sql.append(", ").append(this.sumOption.getStrLongNumberFields());
        }
        sql.append(" FROM (");
        sql.append(this.getCurDeprSql(true));
        sql.append(") a");
        sql.append(this.getJoinSql());
        if (this.filter != null) {
            sql.append(" WHERE " + this.filter);
        }
        String tmpSql = "select newbosid('00000000') as fid,t.* from (" + sql.toString() + ") as t";
        return tmpSql;
    }

    private String getCurDeprSql(boolean flag) {
        StringBuffer deprSql = new StringBuffer();
        deprSql.append("SELECT ");
        deprSql.append("c.FNumber AS ASSETNUMBER, ");
        deprSql.append("c.FoldNumber AS olderNumber, ");
        deprSql.append("c.FAssetName AS ASSETNAME, ");
        deprSql.append("tt1.FMonthDepreRate, ");
        deprSql.append("ISNULL(tt1.FShouldDepre,0) - ISNULL(tt1.FWellCost,0) as FShouldDepre, ");
        deprSql.append("ISNULL(tt1.FDepreciation,0) - ISNULL(tt1.FWellCost,0) as FDepreciation, ");
        deprSql.append(" case when (c.fperiodid = e.fid and (c.foriginFlag = ").append(2).append("or c.foriginFlag = ").append(3).append(")) or (cb.fcleardate < e.fbeginDate and (c.fbizStatus = '0499' or c.fbizStatus = '0599')) then 0 else ISNULL(c.FAccuDepr,0) end AS ACCUDEPR, ");
        deprSql.append(" case when (c.fperiodid = e.fid and (c.foriginFlag = ").append(2).append("or c.foriginFlag = ").append(3).append(")) or (cb.fcleardate < e.fbeginDate and (c.fbizStatus = '0499' or c.fbizStatus = '0599')) then 0 else ISNULL(c.FAccuDeprTYear,0) end AS ACCUDEPRTYEAR, ");
        deprSql.append("c.FDeprMethodID, ");
        deprSql.append("tt2.FMonthDepreRate as TAXMonthDepreRate, ");
        deprSql.append("ISNULL(tt2.FShouldDepre,0) as TAXShouldDepre, ");
        deprSql.append("ISNULL(tt2.FDepreciation,0) as TAXDepreciation, ");
        deprSql.append(" case when (c.fperiodid = e.fid and (c.foriginFlag = ").append(2).append("or c.foriginFlag = ").append(3).append(")) or (cb.fcleardate < e.fbeginDate and (c.fbizStatus = '0499' or c.fbizStatus = '0599')) then 0 else ISNULL(c.FEvalAddDepr,0) end AS TAXACCUDEPR, ");
        deprSql.append(" case when (c.fperiodid = e.fid and (c.foriginFlag = ").append(2).append("or c.foriginFlag = ").append(3).append(")) or (cb.fcleardate < e.fbeginDate and (c.fbizStatus = '0499' or c.fbizStatus = '0599')) then 0 else ISNULL(c.FEvalYearDepr,0) end AS TAXACCUDEPRTYEAR, ");
        deprSql.append("c.FEvalDeprModeID, ");
        deprSql.append("c.FAssetCatID,");
        deprSql.append("c.FAssetAmt AS ASSETAMT, ");
        deprSql.append("c.FMeasureUnitID, ");
        deprSql.append("c.FPaperNo AS PAPERNO, ");
        deprSql.append("e.fid AS PeriodID,");
        deprSql.append("c.FCheckedStatus AS CHECKEDSTATUS, ");
        deprSql.append("c.FHasChanged AS HASCHANGED, ");
        deprSql.append("c.FHasCleared AS HASCLEARED, ");
        deprSql.append("c.fid as fcardid, c.FCompanyID, ");
        deprSql.append("c.FDeletedStatus as DeletedStatus, ");
        deprSql.append("c.FSpecs AS SPECS ");
        deprSql.append("from t_fa_facurcard AS c");
        deprSql.append(" left outer join t_fa_clearbillentry ce on ce.fcurcardid = c.fid ");
        deprSql.append(" left outer join t_fa_clearbill cb on cb.fid = ce.fentryid ");
        deprSql.append(" LEFT OUTER JOIN (SELECT b.FMonthDepreRate,b.FShouldDepre,b.FWellCost,b.FDepreciation,b.ffacurcardid FROM t_fa_fadepreciationentry b ");
        deprSql.append(" INNER JOIN t_fa_fadepreciation a ON a.fid = b.flnkfadepreentry");
        deprSql.append(" LEFT OUTER JOIN t_bd_period p ON (a.fperiod = p.fid )");
        deprSql.append(" WHERE (a.fcompanyid = '" + this.currCompanyInfo.getId().toString() + "'");
        deprSql.append(" and p.fperiodyear = " + this.endYear + " and p.fperiodnumber = " + this.endNumber);
        deprSql.append(" AND (a.fdeptype != 2))");
        deprSql.append(" ) tt1 ON tt1.ffacurcardid = c.fid");
        deprSql.append(" LEFT OUTER JOIN (SELECT b.FMonthDepreRate,b.FShouldDepre,b.FDepreciation,b.ffacurcardid FROM t_fa_faevaldepreciationentry  b ");
        deprSql.append(" INNER JOIN t_fa_faevaldepreciation a ON a.fid = b.flnkfadepreentry");
        deprSql.append(" LEFT OUTER JOIN t_bd_period p ON (a.fperiod = p.fid)");
        deprSql.append(" WHERE (a.fcompanyid = '" + this.currCompanyInfo.getId().toString() + "'");
        deprSql.append(" and p.fperiodyear = " + this.endYear + " and p.fperiodnumber = " + this.endNumber);
        deprSql.append(" )");
        deprSql.append(" ) tt2 ON tt2.ffacurcardid = c.fid");
        deprSql.append(" INNER JOIN T_FA_CAT t on c.fassetcatid = t.fid");
        deprSql.append(" LEFT OUTER JOIN T_BD_Period AS e on (e.fperiodyear = " + this.endYear + " and e.fperiodnumber = " + this.endNumber + " and e.ftypeid = '" + this.currCompanyInfo.getAccountPeriodType().getId().toString() + "')");
        deprSql.append(" where c.fcompanyid = '" + this.currCompanyInfo.getId().toString() + "'");
        deprSql.append(" and c.FLaterPeriodData = 0");
        if (!this.deprZeroCard) {
            deprSql.append(" and (c.fdeprtterm>0 or c.fevaldeprtterm>0)");
        }
        deprSql.append(this.getCondSql());
        return deprSql.toString();
    }

    private String getJoinSql() {
        StringBuffer sql = new StringBuffer();
        sql.append(" LEFT OUTER JOIN T_FA_DepreciationMode AS DEPRMETHOD ON a.FDeprMethodID = DEPRMETHOD.FID ");
        sql.append(" LEFT OUTER JOIN T_FA_DepreciationMode AS TAXDEPRMETHOD ON a.FEvalDeprModeID = TAXDEPRMETHOD.FID ");
        sql.append(" LEFT OUTER JOIN T_BD_Period AS PERIOD ON a.PeriodID = PERIOD.FID ");
        sql.append(" LEFT OUTER JOIN T_BD_MeasureUnit AS MEASUREUNIT ON a.FMeasureUnitID = MEASUREUNIT.FID ");
        String tableName = this.isLevelSum("assetCat") ? this.getSumItemJoinSql("assetCat") : this.getSumItemTableName("assetCat");
        sql.append(" INNER JOIN ").append(tableName).append(" AS ").append("assetCat");
        sql.append(" ON a.FAssetCatID = ").append("assetCat").append(".FID");
        return sql.toString();
    }

    private String getCondSql() {
        String sql = "";
        if (!this.allCleanCard && !this.cleanCard) {
            sql = " and c.FCheckedStatus = 2 and c.FHasCleared != 2 and c.FDeletedStatus != 2";
        } else if (this.allCleanCard && !this.cleanCard) {
            sql = " and c.FCheckedStatus = 2";
        } else if (this.allCleanCard && this.cleanCard) {
            sql = " and c.FCheckedStatus = 2";
        } else if (!this.allCleanCard && this.cleanCard) {
            sql = " and ((c.FCheckedStatus = 2 and c.FDeletedStatus != 2) or (c.FHasCleared = 2 and c.FDeletedStatus = 2))";
        }
        return sql;
    }

    protected void deleteUnnecessaryData() throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("DELETE FROM ");
        sql.append(this.tempTable);
        sql.append(" WHERE ISSUM=0 ");
        DbUtil.execute((Context)this.ctx, (String)sql.toString());
    }

    private void buildResultSql() {
        StringBuffer sql = new StringBuffer();
        if (this.sumOption.isHasSum()) {
            sql.append(this.sumOption.getStrSelectResult() + ", ");
        }
        sql.append(this.getSelectResultSql());
        this.resultSql.setSelect(sql.toString());
        this.resultSql.setFrom(this.tempTable);
        this.resultSql.setOrder(this.sorter);
    }

    @Override
    protected String getFirstDisplayField() {
        return this.isListStyle ? "ASSETNUMBER" : null;
    }
}

