/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.fa.rpt.FaDaoSqlObject;
import com.kingdee.eas.fi.fa.rpt.LevelSumCompany;
import com.kingdee.eas.fi.fa.rpt.LevelSumOption;
import com.kingdee.eas.fi.fa.rpt.LevelSumSqlInfo;
import com.kingdee.eas.fi.fa.rpt.app.dao.FaShowNotAuditDao;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class FaAddDecrDao
extends FaShowNotAuditDao {
    private String sumSql;
    private boolean isShowDetail;
    private boolean isShowNoCardCompany;
    private boolean isShowByPeriod;
    private boolean isShowCat;
    private int defcatlevel;
    private String currPeriodCompIds;
    private String insertCompanySql;
    private List companyListByVir;
    private final int realBeginBalanceFor = 1;
    private final int realADD = 2;
    private final int realDEC = 3;
    private final int realEndBalanceFor = 4;
    private final int depreBeginBalanceFor = 5;
    private final int deprePeriodAccu = 6;
    private final int deprADD = 7;
    private final int deprDEC = 8;
    private final int depreEndBalanceFor = 9;
    private final int netValueBegin = 10;
    private final int netValueADD = 11;
    private final int netValueDEC = 12;
    private final int netValueEnd = 13;
    private final int decValueBeginBalanceFor = 14;
    private final int decValueADD = 15;
    private final int decValueDEC = 16;
    private final int decValueEndBalanceFor = 17;
    private final int netAmtBegin = 18;
    private final int netAmtADD = 19;
    private final int netAmtDEC = 20;
    private final int netAmtEnd = 21;
    public static final int CURRENT_PERIOD = 2;
    public static final int HISTORY_PERIOD = 1;
    int[] changeField = new int[]{2, 3, 6, 7, 8, 11, 12, 15, 16, 19, 20};
    int[] beginEndField = new int[]{1, 4, 5, 9, 10, 13, 14, 17, 18, 21};

    @Override
    public void init(Context ctx, EntityViewInfo ev) throws EASBizException, BOSException {
        Map cond = (Map)ev.get("customcond");
        this.isShowDetail = cond.get("isShowDetail") == null ? false : (Boolean)cond.get("isShowDetail");
        this.isShowByPeriod = cond.get("isShowByPeriod") == null ? false : (Boolean)cond.get("isShowByPeriod");
        this.isShowCat = cond.get("isShowCat") == null ? false : (Boolean)cond.get("isShowCat");
        super.init(ctx, ev);
    }

    @Override
    protected void initEvVar(EntityViewInfo ev) throws EASBizException, BOSException {
        Map cond = (Map)ev.get("customcond");
        if (this.isVirCompany) {
            this.isShowNoCardCompany = cond.get("isShowNoCardCompany") == null ? false : (Boolean)cond.get("isShowNoCardCompany");
            this.companyListByVir = cond.get("companyListByVir") == null ? null : (List)cond.get("companyListByVir");
        }
        this.defcatlevel = cond.get("defCatLevel") == null ? Integer.valueOf(1) : cond.get("defCatLevel");
        super.initEvVar(ev);
        this.currPeriodCompIds = this.getCurrPeriodCompIds();
    }

    @Override
    public Map getResult() throws BOSException {
        this.buildSql();
        this.buildData();
        this.result.put("sumOption", this.sumOption);
        this.result.put("resultSql", this.resultSql);
        this.result.put("tempTableName", this.tempTable);
        this.result.put("result", this.getData(this.resultSql.getSql()));
        return this.result;
    }

    @Override
    protected void buildSql() throws BOSException {
    }

    @Override
    protected void buildData() throws BOSException {
        if (this.isVirCompany || this.isShowCat) {
            this.addDataTempTable(FaLocalUtils.transformLocal((Context)this.ctx, (String)this.buildQueryDetailSQL(1)));
            String sql = "insert into " + this.tempTable + " SELECT * FROM (" + this.buildQueryDetailSQL(2) + ") tempTable ";
            DbUtil.execute((Context)this.ctx, (String)FaLocalUtils.transformLocal((Context)this.ctx, (String)sql));
            if (this.isVirCompany && this.isShowNoCardCompany) {
                this.insertCompanySql = this.insertVacantCompany(this.tempTable, this.getNoCardCompanySelectSql(), this.strCompanyInclude);
            }
            if (this.isVirCompany && this.isShowNoCardCompany) {
                DbUtil.execute((Context)this.ctx, (String)FaLocalUtils.transformLocal((Context)this.ctx, (String)this.insertCompanySql));
            }
            if (this.isVirCompany) {
                this.buildCompanySumData();
                DbUtil.execute((Context)this.ctx, (String)FaLocalUtils.transformLocal((Context)this.ctx, (String)this.sumSql));
                this.buildResultSql(1);
            } else if (this.isShowCat) {
                this.buildCatSumData();
                DbUtil.execute((Context)this.ctx, (String)FaLocalUtils.transformLocal((Context)this.ctx, (String)this.sumSql));
                this.buildResultSql(1);
            }
            this.deleteUnnecessaryData();
            for (int i = 1; i <= 21; ++i) {
                this.insertSeqData(i);
            }
        } else {
            this.addDataTempTable(FaLocalUtils.transformLocal((Context)this.ctx, (String)this.buildQueryDetailSQL(3)));
            if (this.isShowDetail) {
                String sql = "insert into " + this.tempTable + " SELECT * FROM (" + this.buildQueryDetailSQL(4) + ") tempTable ";
                DbUtil.execute((Context)this.ctx, (String)FaLocalUtils.transformLocal((Context)this.ctx, (String)sql));
            }
            this.buildResultSql(2);
        }
    }

    private void upDateDeprePeriodAccu() throws BOSException {
        String sql = "";
        if (this.isShowCat && this.isShowDetail) {
            sql = "update " + this.tempTable + " set titleDetail = N' ' where seq = " + 6;
            DbUtil.execute((Context)this.ctx, (String)sql.toString());
            sql = "update " + this.tempTable + " set issum = 1 ,titleDetail = N'" + this.subTotal + "' where seq = " + 6 + " and sumlevel = -1";
            DbUtil.execute((Context)this.ctx, (String)sql.toString());
        } else if (this.isShowCat && !this.isShowDetail) {
            sql = "update " + this.tempTable + " set issum = 1 ,titleDetail = N'" + this.subTotal + "' where seq = " + 6 + " and sumlevel = -1";
            DbUtil.execute((Context)this.ctx, (String)sql.toString());
        }
    }

    private void buildResultSql(int flag) {
        StringBuffer sql = new StringBuffer();
        if (flag == 1) {
            if (this.isShowCat && this.isVirCompany) {
                sql.append(" FID, SEQ, ISSUM, ASSETNAME,ASSETLongNumber,");
            } else {
                sql.append(" FID, SEQ, ISSUM,");
            }
            if (this.isShowByPeriod) {
                sql.append(" PERIODINFO,");
            }
            if (this.isShowDetail) {
                sql.append(" titleDetail, ");
            }
            sql.append(this.sumOption == null ? " " : this.sumOption.getStrSelectResult() + ",");
            sql.append(" SumLevel");
            sql.append(", amount");
            this.resultSql.setSelect(sql.toString());
            this.resultSql.setFrom(this.tempTable);
            sql = new StringBuffer();
            if (this.isShowByPeriod) {
                sql.append("PERIODINFO,");
            }
            sql.append("SEQ");
            if (this.isShowDetail) {
                sql.append(", titleNumber");
            }
            if (this.isShowCat && this.isVirCompany) {
                sql.append(",ASSETLongNumber");
            }
            sql.append(",").append(this.sorter);
            this.resultSql.setOrder(sql.toString());
        } else {
            sql.append("FID, SEQ, ISSUM, ");
            if (this.isShowByPeriod) {
                sql.append("PERIODINFO,");
            }
            if (this.isShowDetail) {
                sql.append("titleDetail, ");
            }
            sql.append(" amount");
            this.resultSql.setSelect(sql.toString());
            this.resultSql.setFrom(this.tempTable);
            sql = new StringBuffer();
            if (this.isShowByPeriod) {
                sql.append("PERIODINFO,");
            }
            sql.append("SEQ");
            if (this.isShowDetail) {
                sql.append(", ISSUM");
            }
            this.resultSql.setOrder(sql.toString());
        }
    }

    private String buildQueryDetailSQL(int flag) throws BOSException {
        StringBuffer detail = new StringBuffer();
        if (flag == 1 || flag == 3) {
            detail.append(this.buildBeginAssetValueSQL(1));
            detail.append(" UNION ALL ");
            detail.append(this.buildChangedAssetValueSQL(2));
            detail.append(" UNION ALL ");
            detail.append(this.buildChangedAssetValueSQL(3));
            detail.append(" UNION ALL ");
            detail.append(this.buildEndAssetValueSQL(4));
            detail.append(" UNION ALL ");
            detail.append(this.buildBeginAssetValueSQL(5));
            detail.append(" UNION ALL ");
            detail.append(this.buildChangedAssetValueSQL(6));
            detail.append(" UNION ALL ");
            detail.append(this.buildChangedAssetValueSQL(7));
            detail.append(" UNION ALL ");
            detail.append(this.buildChangedAssetValueSQL(8));
            detail.append(" UNION ALL ");
            detail.append(this.buildEndAccuDepreSQL(9));
            detail.append(" UNION ALL ");
            detail.append(this.buildBeginAssetValueSQL(10));
            detail.append(" UNION ALL ");
            detail.append(this.buildChangedAssetValueSQL(11));
        }
        if (flag == 2 || flag == 3) {
            if (flag == 3) {
                detail.append(" UNION ALL ");
            }
            detail.append(this.buildChangedAssetValueSQL(12));
            detail.append(" UNION ALL ");
            detail.append(this.buildNeatValueSQL(13));
            detail.append(" UNION ALL ");
            detail.append(this.buildBeginAssetValueSQL(14));
            detail.append(" UNION ALL ");
            detail.append(this.buildChangedAssetValueSQL(15));
            detail.append(" UNION ALL ");
            detail.append(this.buildChangedAssetValueSQL(16));
            detail.append(" UNION ALL ");
            detail.append(this.buildEndDecValue(17));
            detail.append(" UNION ALL ");
            detail.append(this.buildBeginAssetValueSQL(18));
            detail.append(" UNION ALL ");
            detail.append(this.buildChangedAssetValueSQL(19));
            detail.append(" UNION ALL ");
            detail.append(this.buildChangedAssetValueSQL(20));
            detail.append(" UNION ALL ");
            detail.append(this.buildNeatAmt(21));
        }
        StringBuffer sql = new StringBuffer();
        if (flag != 4) {
            sql.append("SELECT newBOSID('00000000') AS FId, ");
            if (this.isShowByPeriod) {
                sql.append("DETAIL.PERIODINFO,");
            }
            if (this.isVirCompany && this.isShowCat) {
                sql.append(" ASSETNAME as ASSETNAME ,ASSETLongNumber as ASSETLongNumber, ");
            }
            if (this.isVirCompany || this.isShowCat) {
                sql.append(this.sumOption.getStrNameFields()).append(",");
            }
            sql.append("0 AS ISSUM, DETAIL.SEQ AS SEQ, DETAIL.AMOUNT AS amount");
            if (this.isShowDetail) {
                sql.append(", DETAIL.titleDetail AS titleDetail, DETAIL.titleNumber");
            }
            if (this.isVirCompany) {
                sql.append(", COMPANY.FLEVEL AS SumLevel, ");
                sql.append(this.sumOption.getStrLongNumberFields());
            } else if (this.isShowCat) {
                sql.append(", AssetCat.FLEVEL AS SumLevel, ");
                sql.append(this.sumOption.getStrLongNumberFields());
            }
            sql.append(" FROM (").append(detail.toString()).append(") DETAIL ");
        }
        if (this.isVirCompany) {
            sql.append(" INNER JOIN " + this.getSumItemJoinSql("orgArchitecture") + " COMPANY ON COMPANY.FID = DETAIL.COMPANYID ");
            sql.append(" WHERE ").append(this.getCompanyFilter(this.strCompanyInclude));
        } else if (this.isShowCat) {
            sql.append(" LEFT OUTER JOIN " + this.getSumItemJoinSql("assetCat") + " AssetCat ON AssetCat.FID = DETAIL.FASSETCATID");
        } else {
            if (flag != 3 && this.isShowDetail) {
                if (flag != 4) {
                    sql.append(" UNION ALL ");
                }
                sql.append(" SELECT newBOSID('00000000') AS FId, ");
                if (this.isShowByPeriod) {
                    sql.append(" CHANGE.PERIODINFO,");
                }
                sql.append("1 AS ISSUM, SEQ, SUM(amount) AS amount,");
                sql.append(" N'").append(this.subTotal).append("' AS titleDetail,");
                sql.append(" N'").append(LevelSumOption.MAXCODE).append("' AS titleNumber");
                sql.append(" FROM (");
                sql.append(this.buildChangedAssetValueSQL(2));
                sql.append(" UNION ALL ");
                sql.append(this.buildChangedAssetValueSQL(3));
                sql.append(" UNION ALL ");
                sql.append(this.buildChangedAssetValueSQL(6));
                sql.append(" UNION ALL ");
                sql.append(this.buildChangedAssetValueSQL(7));
                sql.append(" UNION ALL ");
                sql.append(this.buildChangedAssetValueSQL(8));
                sql.append(" UNION ALL ");
                sql.append(this.buildChangedAssetValueSQL(11));
                sql.append(" UNION ALL ");
                sql.append(this.buildChangedAssetValueSQL(12));
                sql.append(" UNION ALL ");
                sql.append(this.buildChangedAssetValueSQL(15));
                sql.append(" UNION ALL ");
                sql.append(this.buildChangedAssetValueSQL(16));
                sql.append(" UNION ALL ");
                sql.append(this.buildChangedAssetValueSQL(19));
                sql.append(" UNION ALL ");
                sql.append(this.buildChangedAssetValueSQL(20));
                sql.append(") CHANGE");
                sql.append(" GROUP BY ");
                if (this.isShowByPeriod) {
                    sql.append(" CHANGE.PERIODINFO,");
                }
                sql.append("SEQ");
            }
            String tempTable = sql.toString();
            sql = new StringBuffer();
            sql.append("SELECT FID, ");
            if (this.isShowByPeriod) {
                sql.append("PERIODINFO,");
            }
            sql.append(" ISSUM,SEQ,amount");
            if (this.isShowDetail) {
                sql.append(",titleDetail ");
            }
            sql.append(" FROM (").append(tempTable).append(") T ");
        }
        return sql.toString();
    }

    private String buildBeginAssetValueSQL(int type) {
        String beginBalanceFor;
        int startPeriod = this.startYear * 100 + this.startNumber;
        int endPeriod = this.endYear * 100 + this.endNumber;
        FaDaoSqlObject sql = new FaDaoSqlObject();
        String netValue = "(AccountBalance.FRealBeginBalanceFor - AccountBalance.FDepreBeginBalanceFor)";
        String netAmount = "(AccountBalance.FRealBeginBalanceFor - AccountBalance.FDepreBeginBalanceFor - AccountBalance.FDecValueBeginBalanceFor)";
        String string = type == 1 ? "AccountBalance.FRealBeginBalanceFor" : (type == 5 ? "AccountBalance.FDepreBeginBalanceFor" : (type == 10 ? netValue : (beginBalanceFor = type == 14 ? "AccountBalance.FDecValueBeginBalanceFor" : netAmount)));
        if (this.isVirCompany) {
            StringBuffer tmp = new StringBuffer();
            if (this.isShowCat) {
                tmp.append(" SELECT FAssetCatID,COMPANYID,SUM(amount) AS AMOUNT,PERIODINFO FROM(SELECT card.FAssetCatID AS FAssetCatID, ACCOUNTBALANCE.FCompanyOrgUnitID AS COMPANYID,");
                tmp.append(beginBalanceFor + " AS amount, PERIOD.FNumber PERIODINFO");
                tmp.append(" from ");
                tmp.append(this.buildFromCat());
            } else {
                tmp.append(" SELECT COMPANYID,SUM(amount) AS AMOUNT,PERIODINFO FROM(SELECT ACCOUNTBALANCE.FCompanyOrgUnitID AS COMPANYID,");
                tmp.append(beginBalanceFor + " AS amount, PERIOD.FNumber PERIODINFO");
                tmp.append(" FROM T_FA_FaAccountBalance ACCOUNTBALANCE LEFT OUTER JOIN T_BD_Period PERIOD ON ACCOUNTBALANCE.FPeriodID = PERIOD.FID");
            }
            if (this.isShowByPeriod) {
                tmp.append(" WHERE PERIOD.FNumber >= ").append(startPeriod);
                tmp.append(" AND PERIOD.FNumber <= ").append(endPeriod);
                tmp.append(" AND ABS(" + beginBalanceFor + ") > 0");
                tmp.append(") T ");
                tmp.append(" GROUP BY PERIODINFO,COMPANYID");
            } else {
                tmp.append(" WHERE PERIOD.FNumber = ").append(startPeriod);
                tmp.append(" AND ABS(" + beginBalanceFor + ") > 0");
                tmp.append(") T ");
                tmp.append(" GROUP BY COMPANYID,PERIODINFO");
            }
            if (this.isShowCat) {
                tmp.append(",FAssetCatID");
            }
            StringBuffer select = new StringBuffer();
            select.append(type + " AS SEQ,");
            if (this.isShowDetail) {
                select.append("TO_CHAR(NULL) AS titleDetail,TO_CHAR(NULL) AS titleNumber,");
            }
            if (this.isShowCat) {
                if (this.isShowByPeriod) {
                    select.append(" d.PERIODINFO,");
                }
                select.append(" tempCat.assetname as ASSETNAME,tempCat.assetLongNumber as ASSETLongNumber,d.COMPANYID AS COMPANYID, d.amount AS AMOUNT ");
                select.append("FROM (SELECT t2.COMPANYID COMPANYID, t2.FAssetCatID,t2.amount AMOUNT ");
                if (this.isShowByPeriod) {
                    select.append(",t2.PERIODINFO PERIODINFO");
                }
            } else {
                if (this.isShowByPeriod) {
                    select.append("t2.PERIODINFO PERIODINFO,");
                }
                select.append("t2.COMPANYID AS COMPANYID, t2.amount AS AMOUNT");
            }
            StringBuffer from = new StringBuffer();
            if (!this.isShowCat) {
                if (this.isShowByPeriod) {
                    from.append("(").append(tmp).append(") t2");
                } else {
                    from.append("(SELECT TMP.COMPANYID COMPANYID, MIN(PERIODINFO) PERIODINFO FROM(").append(tmp).append(") TMP");
                    from.append(" GROUP BY TMP.COMPANYID) t1 INNER JOIN (").append(tmp).append(") t2 ON t1.COMPANYID = t2.COMPANYID AND t1.PERIODINFO = t2.PERIODINFO ");
                }
            } else if (this.isShowByPeriod) {
                from.append("(").append(tmp).append(") t2");
                from.append(")d");
                from.append(" inner join ");
                from.append(this.buildTempCat());
                from.append("tempCat on d.FAssetCatID=tempCat.fid ");
            } else {
                from.append("(SELECT FAssetCatID,TMP.COMPANYID COMPANYID, MIN(PERIODINFO) PERIODINFO FROM(").append(tmp).append(") TMP");
                from.append(" GROUP BY TMP.COMPANYID,FAssetCatID) t1 INNER JOIN (").append(tmp).append(") t2 ON t1.COMPANYID = t2.COMPANYID AND t1.PERIODINFO = t2.PERIODINFO and t1.FAssetCatID=t2.FAssetCatID ");
                from.append(")d");
                from.append(" inner join ");
                from.append(this.buildTempCat());
                from.append("tempCat on d.FAssetCatID=tempCat.fid ");
            }
            sql.setSelect(select.toString());
            sql.setFrom(from.toString());
        } else {
            StringBuffer select = new StringBuffer();
            select.append(type + " AS SEQ,");
            if (this.isShowDetail) {
                select.append("TO_CHAR(NULL) AS titleDetail,TO_CHAR(NULL) AS titleNumber,");
            }
            if (this.isShowCat && this.isShowByPeriod) {
                select.append("card.FAssetCatID AS FAssetCatID,");
                select.append("SUM(" + beginBalanceFor + ") AS amount");
                select.append(",PERIOD.FNumber PERIODINFO");
            } else if (this.isShowCat) {
                select.append("card.FAssetCatID AS FAssetCatID,");
                select.append("SUM(" + beginBalanceFor + ") AS amount");
            } else if (this.isShowByPeriod) {
                select.append("SUM(" + beginBalanceFor + ") AS amount,");
                select.append("PERIOD.FNumber PERIODINFO");
            } else {
                select.append("SUM(" + beginBalanceFor + ") AS amount");
            }
            sql.setSelect(select.toString());
            if (this.isShowCat) {
                sql.setFrom(this.buildFromCat());
            } else {
                sql.setFrom(this.buildFrom());
            }
            if (this.isShowByPeriod) {
                sql.setWhere("PERIOD.FNumber >= " + startPeriod + " AND PERIOD.FNumber <= " + endPeriod);
            } else {
                sql.setWhere(this.buildWhere(this.startYear, this.startNumber, beginBalanceFor));
            }
            if (this.isShowByPeriod && this.isShowCat) {
                sql.setGroup(" card.FAssetCatID,PERIOD.FNumber ");
            } else if (this.isShowCat) {
                sql.setGroup(" card.FAssetCatID ");
            } else if (this.isShowByPeriod) {
                sql.setGroup(" PERIOD.FNumber ");
            }
        }
        return sql.getSql();
    }

    private String buildFromCat() {
        StringBuffer from = new StringBuffer();
        from.append("T_FA_FaAccountBalance ACCOUNTBALANCE ");
        from.append("left join T_BD_Period PERIOD on (PERIOD.FID=ACCOUNTBALANCE.FPeriodID )");
        from.append("inner join (");
        from.append(this.buildMonFromCurCard());
        from.append(" )card ON card.FFaPeriodID=PERIOD.FID AND card.FFaCurCardID=ACCOUNTBALANCE.FFaCurCardID ");
        return from.toString();
    }

    private String buildMonFromCurCard() {
        StringBuffer tempMonCard = new StringBuffer();
        tempMonCard.append(" select FFaCurCardID, FFaPeriodID, FAssetCatID, fcompanyid from T_FA_FAmonCARD WHERE fcompanyid in");
        if (!this.isVirCompany) {
            tempMonCard.append(" ('" + this.currCompanyInfo.getId().toString() + "')");
        } else {
            tempMonCard.append(" (" + this.currPeriodCompIds + ")");
        }
        tempMonCard.append(" union all");
        tempMonCard.append(" select cur.fid ffacurcardid,ssc.FCurrentPeriodID ffaperiodid,cur.fassetcatid,cur.fcompanyid");
        tempMonCard.append(" from t_fa_facurcard cur inner join t_bd_SystemStatusCtrol ssc on cur.FCompanyID = ssc.FCompanyID");
        tempMonCard.append(" inner join T_BD_SystemStatus ss on ss.fid = ssc.FSystemStatusID");
        tempMonCard.append(" where ss.FName = 14 and cur.fcompanyid in");
        if (!this.isVirCompany) {
            tempMonCard.append(" ('" + this.currCompanyInfo.getId().toString() + "')");
        } else {
            tempMonCard.append(" (" + this.currPeriodCompIds + ")");
        }
        tempMonCard.append(" and not exists (select 1 from T_FA_FAmonCARD mon where mon.FFaCurCardID = cur.fid and mon.FFaPeriodID = ssc.FCurrentPeriodID )");
        return tempMonCard.toString();
    }

    private String buildChangedAssetValueSQL(int type) throws BOSException {
        int startPeriod = this.startYear * 100 + this.startNumber;
        int endPeriod = this.endYear * 100 + this.endNumber;
        String deprSQL = "";
        boolean isShowTitle = false;
        if (type == 6 || type == 12 || type == 20) {
            if (type != 6) {
                isShowTitle = true;
            }
            if (!this.isVirCompany) {
                try {
                    PeriodInfo info = SystemStatusCtrolUtils.getCurrentPeriod((Context)this.ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)this.currCompanyInfo);
                    int periodNumber = info.getNumber();
                    if (periodNumber > startPeriod && periodNumber <= endPeriod) {
                        deprSQL = "((" + this.getDeprSQL(1, isShowTitle, startPeriod, periodNumber - 1) + ") UNION ALL (" + this.getDeprSQL(2, true, periodNumber, endPeriod) + "))";
                    }
                    if (periodNumber <= startPeriod) {
                        deprSQL = "(" + this.getDeprSQL(2, isShowTitle, startPeriod, endPeriod) + ")";
                    }
                    deprSQL = "(" + this.getDeprSQL(1, isShowTitle, startPeriod, endPeriod) + ")";
                }
                catch (EASBizException e) {
                    throw new BOSException(e.getMessage());
                }
            } else {
                deprSQL = "(" + this.getDeprSQL(2, isShowTitle, startPeriod, endPeriod) + ")";
            }
        }
        StringBuffer sql = new StringBuffer();
        if (this.isShowCat) {
            sql.append("SELECT " + type + " AS SEQ,");
            if (this.isShowDetail && this.isVirCompany) {
                sql.append("H.titleDetail,");
                sql.append("H.titleNumber,");
            } else if (this.isShowDetail) {
                sql.append("titleDetail,");
                sql.append("titleNumber,");
            }
            if (this.isShowByPeriod && this.isVirCompany) {
                sql.append("H.PERIODINFO, ");
            }
            if (this.isVirCompany) {
                sql.append(" tempCat.assetname as ASSETNAME,tempCat.assetLongNumber as ASSETLongNumber, H.COMPANYID COMPANYID,ABS(SUM(H.CHANGEVALUE)) AS AMOUNT");
            } else {
                sql.append(" H.FAssetCatID AS FAssetCatID, ABS(SUM(H.CHANGEVALUE)) AS AMOUNT");
            }
            if (this.isShowByPeriod && !this.isVirCompany) {
                sql.append(",H.PERIODINFO");
            }
            sql.append(" FROM (");
            sql.append(deprSQL);
            if (isShowTitle) {
                sql.append(" UNION ALL ");
            }
            if (type == 2 || type == 7 || type == 11 || type == 12 || type == 15 || type == 19 || type == 20) {
                sql.append(this.getNewCardSql(type));
                sql.append(" UNION ALL ");
            }
            if (type != 6) {
                sql.append(this.getChangeBillSql(type));
                sql.append(" UNION ALL ");
                sql.append(this.getCleanBillSql(type));
            }
            sql.append(") H ");
            if (this.isVirCompany) {
                sql.append("inner join ");
                sql.append(this.buildTempCat());
                sql.append("tempCat on H.FAssetCatID=tempCat.fid ");
            }
            sql.append(" WHERE H.COMPANYID in(");
            if (this.isVirCompany) {
                sql.append(this.currPeriodCompIds).append(")");
            } else {
                sql.append("'").append(this.currCompanyInfo.getId().toString()).append("')");
            }
            sql.append(" GROUP BY ");
            if (this.isShowByPeriod) {
                sql.append(" H.PERIODINFO,");
            }
            if (this.isShowDetail && this.isVirCompany) {
                sql.append("H.titleNumber,H.titleDetail,H.COMPANYID");
            } else if (this.isShowDetail) {
                sql.append("titleNumber,titleDetail");
            } else {
                sql.append("H.COMPANYID");
            }
            if (this.isVirCompany) {
                sql.append(",tempCat.assetname,tempCat.assetLongNumber");
            } else {
                sql.append(",H.FAssetCatID");
            }
        } else {
            sql.append("SELECT " + type + " AS SEQ,");
            if (this.isShowDetail) {
                sql.append("titleDetail,");
                sql.append("titleNumber,");
            }
            if (this.isShowByPeriod && this.isVirCompany) {
                sql.append("H.PERIODINFO, ");
            }
            if (this.isVirCompany) {
                sql.append("H.COMPANYID AS COMPANYID,");
            }
            sql.append("ABS(SUM(H.CHANGEVALUE)) AS amount");
            if (this.isShowByPeriod && !this.isVirCompany) {
                sql.append(",H.PERIODINFO ");
            }
            sql.append(" FROM (");
            sql.append(deprSQL);
            if (isShowTitle) {
                sql.append(" UNION ALL ");
            }
            if (type == 2 || type == 7 || type == 11 || type == 12 || type == 15 || type == 19 || type == 20) {
                sql.append(this.getNewCardSql(type));
                sql.append(" UNION ALL ");
            }
            if (type != 6) {
                sql.append(this.getChangeBillSql(type));
                sql.append(" UNION ALL ");
                sql.append(this.getCleanBillSql(type));
            }
            sql.append(") H ");
            if (!this.isVirCompany) {
                sql.append(" WHERE H.COMPANYID ='").append(this.currCompanyInfo.getId().toString() + "' ");
            }
            if (this.isVirCompany || this.isShowDetail || this.isShowByPeriod) {
                sql.append(" GROUP BY ");
                if (this.isShowByPeriod) {
                    sql.append("H.PERIODINFO,");
                }
                if (this.isShowDetail) {
                    sql.append("titleNumber,");
                    sql.append("titleDetail");
                    if (this.isVirCompany) {
                        sql.append(",H.COMPANYID");
                    }
                } else {
                    sql.append("H.COMPANYID");
                }
            }
        }
        return sql.toString();
    }

    private String getDeprSQL(int operaType, boolean isShowTitle, int startPeriod, int endPeriod) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT HEAD.FCompanyID AS COMPANYID,");
        if (this.isShowCat) {
            sql.append("CARD.FAssetCatID AS FASSETCATID,");
        }
        sql.append("ENTRY.FDepreciation AS CHANGEVALUE, ");
        if (this.isShowByPeriod) {
            sql.append("PERIOD.FNumber PERIODINFO,");
        }
        if (isShowTitle) {
            sql.append("N'" + ResourceBase.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"deprAdd", (Locale)this.ctx.getLocale()) + "' AS titleDetail,N'#fakeAlterModeNumber#' AS titleNumber FROM");
        } else {
            sql.append("N' ' AS titleDetail,N'#fakeAlterModeNumber#' AS titleNumber FROM");
        }
        sql.append(" T_FA_FaDepreciationEntry ENTRY ");
        sql.append(" INNER JOIN T_FA_FaDepreciation HEAD ON ENTRY.FLnkFaDepreEntry = HEAD.FID");
        sql.append(" INNER JOIN T_BD_Period PERIOD ON HEAD.Fperiod = PERIOD.FID");
        if (operaType == 1) {
            sql.append(" INNER JOIN T_FA_FAMONCARD CARD ON ENTRY.FFACURCARDID = CARD.FFACURCARDID AND CARD.FFAPERIODID = HEAD.Fperiod");
        } else if (operaType == 2) {
            sql.append(" INNER JOIN T_FA_FACURCARD CARD ON CARD.FID = ENTRY.FFaCurCardID");
        }
        sql.append(" WHERE PERIOD.FNumber >= ").append(startPeriod);
        sql.append(" AND PERIOD.FNumber <= ").append(endPeriod);
        sql.append(" AND ENTRY.FDepreciation > 0");
        return sql.toString();
    }

    private String getDeprSQL(boolean isShowTitle) {
        int startPeriod = this.startYear * 100 + this.startNumber;
        int endPeriod = this.endYear * 100 + this.endNumber;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT HEAD.FCompanyID AS COMPANYID,");
        if (this.isShowCat) {
            sql.append("CARD.FAssetCatID AS FASSETCATID,");
        }
        sql.append("ENTRY.FDepreciation AS CHANGEVALUE, ");
        if (this.isShowByPeriod) {
            sql.append("PERIOD.FNumber PERIODINFO,");
        }
        if (isShowTitle) {
            sql.append("N'" + ResourceBase.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"deprAdd", (Locale)this.ctx.getOriginLocale()) + "' AS titleDetail,N'#fakeAlterModeNumber#' AS titleNumber FROM");
        } else {
            sql.append("N' ' AS titleDetail,N'#fakeAlterModeNumber#' AS titleNumber FROM");
        }
        sql.append(" T_FA_FaDepreciationEntry ENTRY ");
        sql.append(" INNER JOIN T_FA_FaDepreciation HEAD ON ENTRY.FLnkFaDepreEntry = HEAD.FID");
        sql.append(" INNER JOIN T_BD_Period PERIOD ON HEAD.Fperiod = PERIOD.FID");
        sql.append(" INNER JOIN T_FA_FACURCARD CARD ON CARD.FID = ENTRY.FFaCurCardID");
        sql.append(" WHERE PERIOD.FNumber >= ").append(startPeriod);
        sql.append(" AND PERIOD.FNumber <= ").append(endPeriod);
        sql.append(" AND ENTRY.FDepreciation > 0");
        return sql.toString();
    }

    private String buildEndAssetValueSQL(int type) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT " + type + " SEQ,");
        if (this.isShowDetail) {
            sql.append("TO_CHAR(NULL) AS titleDetail,TO_CHAR(NULL) titleNumber,");
        }
        if (this.isVirCompany) {
            if (this.isShowByPeriod) {
                sql.append("d.PERIODINFO, ");
            }
            if (this.isShowCat) {
                sql.append(" tempCat.assetname as ASSETNAME,tempCat.assetLongNumber as ASSETLongNumber,");
            }
            sql.append(" d.COMPANYID COMPANYID, d.AMOUNT AMOUNT");
            sql.append(" FROM ");
            if (this.isShowNotAudit && this.currPeriodCompIds != null) {
                sql.append("(SELECT c.COMPANYID COMPANYID,sum(c.AMOUNT) AMOUNT ");
                if (this.isShowByPeriod) {
                    sql.append(",c.PERIODINFO ");
                }
                sql.append(" FROM ");
            }
            if (this.isShowCat) {
                sql.append("(SELECT t2.COMPANYID COMPANYID, t2.FAssetCatID,t2.amount AMOUNT ");
            } else {
                sql.append("(SELECT t2.COMPANYID COMPANYID, t2.amount AMOUNT ");
            }
            if (this.isShowByPeriod) {
                sql.append(",t2.PERIODINFO ");
            }
            sql.append(" FROM ");
            int startPeriod = this.startYear * 100 + this.startNumber;
            int endPeriod = this.endYear * 100 + this.endNumber;
            StringBuffer tmp = new StringBuffer();
            if (this.isShowCat) {
                tmp.append(" SELECT FAssetCatID,COMPANYID,SUM(amount) AMOUNT,PERIODINFO FROM(SELECT card.FAssetCatID AS FAssetCatID, ACCOUNTBALANCE.FCompanyOrgUnitID AS COMPANYID,");
                tmp.append(" ACCOUNTBALANCE.FRealEndBalanceFor amount, PERIOD.FNumber PERIODINFO");
                tmp.append(" FROM T_FA_FaAccountBalance ACCOUNTBALANCE LEFT OUTER JOIN T_BD_Period PERIOD ON ACCOUNTBALANCE.FPeriodID = PERIOD.FID ");
                tmp.append(" inner join (");
                tmp.append(this.buildMonFromCurCard());
                tmp.append(" ) card ON card.FFaPeriodID = PERIOD.FID AND card.FFaCurCardID = ACCOUNTBALANCE.FFaCurCardID ");
            } else {
                tmp.append(" SELECT COMPANYID,SUM(amount) AMOUNT,PERIODINFO FROM(SELECT ACCOUNTBALANCE.FCompanyOrgUnitID AS COMPANYID,");
                tmp.append(" ACCOUNTBALANCE.FRealEndBalanceFor amount, PERIOD.FNumber PERIODINFO");
                tmp.append(" FROM T_FA_FaAccountBalance ACCOUNTBALANCE LEFT OUTER JOIN T_BD_Period PERIOD ON ACCOUNTBALANCE.FPeriodID = PERIOD.FID");
            }
            tmp.append(" WHERE PERIOD.FNumber >= ").append(startPeriod);
            tmp.append(" AND PERIOD.FNumber <= ").append(endPeriod);
            tmp.append(") T ");
            if (this.isShowByPeriod) {
                tmp.append(" GROUP BY PERIODINFO,COMPANYID");
            } else {
                tmp.append(" GROUP BY COMPANYID,PERIODINFO");
            }
            if (this.isShowCat) {
                tmp.append(",FAssetCatID");
            }
            StringBuffer from = new StringBuffer();
            if (!this.isShowCat) {
                if (this.isShowByPeriod) {
                    from.append("(").append(tmp).append(") t2");
                } else {
                    from.append("(SELECT TMP.COMPANYID AS COMPANYID, MAX(TMP.PERIODINFO) PERIODINFO FROM(").append(tmp).append(") TMP");
                    from.append(" GROUP BY TMP.COMPANYID) t1 INNER JOIN (").append(tmp).append(") t2 ON t1.COMPANYID = t2.COMPANYID AND t1.PERIODINFO = t2.PERIODINFO");
                }
            } else if (this.isShowByPeriod) {
                from.append("(").append(tmp).append(") t2");
            } else {
                from.append("(SELECT FAssetCatID,TMP.COMPANYID AS COMPANYID, MAX(TMP.PERIODINFO) PERIODINFO FROM(").append(tmp).append(") TMP");
                from.append(" GROUP BY TMP.COMPANYID,FAssetCatID) t1 INNER JOIN (").append(tmp).append(") t2 ON t1.COMPANYID = t2.COMPANYID AND t1.PERIODINFO = t2.PERIODINFO and t1.FAssetCatID=t2.FAssetCatID");
            }
            sql.append(from);
            if (this.isShowNotAudit && this.currPeriodCompIds != null) {
                sql.append(" UNION ALL");
                sql.append(" SELECT CARD.FCompanyID COMPANYID, CARD.FAssetValue AMOUNT ");
                sql.append(" FROM T_FA_FaCurCard CARD");
                sql.append(" WHERE CARD.fcheckedstatus = 1 and CARD.feffectedstatus = 2");
                sql.append(" AND CARD.FCOMPANYID IN (").append(this.currPeriodCompIds).append(")");
                sql.append(" ) c GROUP BY c.COMPANYID");
            }
            sql.append(") d");
            if (this.isShowCat) {
                sql.append(" inner join ");
                sql.append(this.buildTempCat());
                sql.append("tempCat on d.FAssetCatID=tempCat.fid and d.amount <>0 ");
            }
        } else {
            if (this.isShowCat) {
                sql.append("card.FAssetCatID AS FASSETCATID,");
            }
            sql.append(" sum(ACCOUNTBALANCE.FRealEndBalanceFor) as AMOUNT ");
            if (this.isShowByPeriod) {
                sql.append(",Period.FNumber PERIODINFO ");
            }
            sql.append(" FROM ");
            if (this.isShowCat || this.isShowCat && this.isShowByPeriod) {
                sql.append(this.buildFromCat());
            } else {
                sql.append(this.buildFrom());
            }
            if (this.isShowByPeriod) {
                sql.append(" WHERE PERIOD.FNumber >= ").append(this.startYear * 100 + this.startNumber);
                sql.append(" AND PERIOD.FNumber <= ").append(this.endYear * 100 + this.endNumber);
                sql.append(" AND ACCOUNTBALANCE.FCompanyOrgUnitID = '").append(this.currCompanyInfo.getId().toString()).append("' ");
            } else {
                sql.append(" WHERE ").append(this.buildWhere(this.endYear, this.endNumber, "ACCOUNTBALANCE.FRealEndBalanceFor"));
            }
            if (this.isShowNotAudit && this.currPeriodCompIds != null) {
                sql.append(" UNION ALL");
                sql.append(" SELECT CARD.FAssetValue AMOUNT ");
                sql.append(" FROM T_FA_FaCurCard CARD");
                sql.append(" WHERE CARD.fcheckedstatus = 1 and CARD.feffectedstatus = 2");
                sql.append(" AND CARD.FCOMPANYID = ").append(this.currPeriodCompIds);
            }
            if (this.isShowCat && this.isShowByPeriod) {
                sql.append("GROUP BY card.FAssetCatID,PERIOD.FNumber ");
            } else if (this.isShowByPeriod) {
                sql.append("GROUP BY PERIOD.FNumber ");
            } else if (this.isShowCat) {
                sql.append("GROUP BY card.FAssetCatID ");
            }
        }
        return sql.toString();
    }

    private String buildTempCat() {
        StringBuffer tempCat = new StringBuffer();
        tempCat.append("(select table2.companyid,table2.fid,table2.assetname,table2.assetLongNumber from ");
        tempCat.append("( select uTable.fid, max(uTable.flevel) as flevel from (").append(this.buildTempMultiCat()).append(")uTable group by uTable.fid) table1 ");
        tempCat.append(this.buildTempMultiCat2()).append(" table2 on table2.fid=table1.fid where table1.fid is not null)");
        return tempCat.toString();
    }

    private String buildTempMultiCat() {
        StringBuffer tempCat = new StringBuffer();
        tempCat.append("(select catparent.fcompanyid as companyid,cat.fid,catparent.fname_l2 as assetname ,catparent.FLongNumber as assetLongNumber, catparent.flevel as flevel from t_fa_cat cat, t_fa_cat catparent where (");
        tempCat.append("(charindex(catparent.flongnumber, cat.flongnumber) = 1 and catparent.flevel <= ").append(this.defcatlevel).append(")");
        tempCat.append(" or ( catparent.flevel< ").append(this.defcatlevel).append(" AND cat.FNumber = catparent.FNumber)");
        String idStr = this.getCompanyListByVir(this.companyListByVir);
        tempCat.append(") and catparent.fcompanyid in (").append(idStr).append(") )");
        return tempCat.toString();
    }

    private String buildTempMultiCat2() {
        StringBuffer tempCat = new StringBuffer();
        tempCat.append(" right  JOIN (  select catparent.fcompanyid  as companyid, catparent.fid, catparent.fname_l2    as assetname,catparent.FLongNumber as assetLongNumber,catparent.flevel      as flevel from t_fa_cat catparent) ");
        return tempCat.toString();
    }

    private String getCompanyListByVir(List companyListByVir) {
        if (companyListByVir == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < companyListByVir.size(); ++i) {
            sb.append("'").append(companyListByVir.get(i).toString()).append("',");
        }
        return sb.substring(0, sb.lastIndexOf(","));
    }

    private String buildAccuDeprTermSQL(int type) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");
        if (this.isShowDetail) {
            sql.append(" TO_CHAR(NULL) AS titleDetail,TO_CHAR(NULL) AS titleNumber,");
        }
        sql.append(" CARD.FAssetCatID AS FASSETCATID,");
        sql.append(" endDepre.sumDepreEnd - beginDepre.sumDepreBegin as AMOUNT FROM ");
        sql.append(" (SELECT SUM(d.depreEnd) sumDepreEnd ,D.CARDID FROM ");
        sql.append(" (SELECT ACCOUNTBALANCE.FDepreEndBalanceFor AS depreEnd,ACCOUNTBALANCE.FFaCurCardID AS CARDID FROM T_FA_FaAccountBalance ACCOUNTBALANCE");
        sql.append(" INNER JOIN T_BD_Period PERIOD ON ACCOUNTBALANCE.FPeriodID = PERIOD.FID");
        sql.append(" WHERE PERIOD.FPeriodYear = ").append(this.endYear).append(" AND PERIOD.FPeriodNumber=").append(this.endNumber);
        sql.append(" AND ACCOUNTBALANCE.FCompanyOrgUnitID ='").append(this.currCompanyInfo.getId().toString()).append("'");
        sql.append(" ) d");
        sql.append(" GROUP BY D.CARDID) endDepre");
        sql.append(" INNER JOIN ( SELECT SUM(ACCOUNTBALANCE.FDepreBeginBalanceFor) AS SUMDEPREBEGIN,ACCOUNTBALANCE.FFaCurCardID AS CARDID FROM T_FA_FaAccountBalance ACCOUNTBALANCE");
        sql.append(" INNER JOIN T_BD_Period PERIOD ON ACCOUNTBALANCE.FPeriodID = PERIOD.FID");
        sql.append(" WHERE PERIOD.FPeriodYear = ").append(this.startYear).append(" AND PERIOD.FPeriodNumber=").append(this.startNumber);
        sql.append(" AND ACCOUNTBALANCE.FCompanyOrgUnitID = '").append(this.currCompanyInfo.getId().toString()).append("' GROUP BY ACCOUNTBALANCE.FFaCurCardID) beginDepre ON endDepre.CARDID =beginDepre.CARDID");
        sql.append(" INNER JOIN T_FA_FACURCARD CARD ON endDepre.CARDID = CARD.FID");
        sql.append(" WHERE endDepre.sumDepreEnd - beginDepre.sumDepreBegin <> 0");
        return sql.toString();
    }

    private String buildEndAccuDepreSQL(int type) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT " + type + " AS SEQ,");
        if (this.isShowDetail) {
            sql.append("TO_CHAR(NULL) titleDetail,TO_CHAR(NULL) titleNumber,");
        }
        if (this.isVirCompany) {
            if (this.isShowCat) {
                if (this.isShowByPeriod) {
                    sql.append("d.PERIODINFO, ");
                }
                sql.append("tempCat.assetname as ASSETNAME,tempCat.assetLongNumber as ASSETLongNumber,d.COMPANYID AS COMPANYID, d.amount AS AMOUNT ");
            } else {
                if (this.isShowByPeriod) {
                    sql.append("t2.PERIODINFO, ");
                }
                sql.append("t2.COMPANYID COMPANYID, t2.amount AMOUNT ");
            }
            sql.append(" FROM ");
            if (this.isShowCat) {
                sql.append("(SELECT t2.COMPANYID COMPANYID, t2.FAssetCatID,t2.amount AMOUNT ");
                if (this.isShowByPeriod) {
                    sql.append(",t2.PERIODINFO");
                }
                sql.append(" FROM");
            }
            int startPeriod = this.startYear * 100 + this.startNumber;
            int endPeriod = this.endYear * 100 + this.endNumber;
            StringBuffer tmp = new StringBuffer();
            if (this.isShowCat) {
                tmp.append(" SELECT FAssetCatID,COMPANYID,SUM(amount) AMOUNT,PERIODINFO FROM(SELECT card.FAssetCatID FAssetCatID, ACCOUNTBALANCE.FCompanyOrgUnitID COMPANYID,");
                tmp.append(" ACCOUNTBALANCE.FDepreEndBalanceFor amount, PERIOD.FNumber PERIODINFO");
                tmp.append(" FROM T_FA_FaAccountBalance ACCOUNTBALANCE LEFT OUTER JOIN T_BD_Period PERIOD ON ACCOUNTBALANCE.FPeriodID = PERIOD.FID");
                tmp.append(" inner join (");
                tmp.append(this.buildMonFromCurCard());
                tmp.append(" ) card ON card.FFaPeriodID = PERIOD.FID AND card.FFaCurCardID = ACCOUNTBALANCE.FFaCurCardID ");
            } else {
                tmp.append(" SELECT COMPANYID,SUM(amount) AMOUNT,PERIODINFO FROM(SELECT ACCOUNTBALANCE.FCompanyOrgUnitID COMPANYID,");
                tmp.append(" ACCOUNTBALANCE.FDepreEndBalanceFor amount, PERIOD.FNumber PERIODINFO");
                tmp.append(" FROM T_FA_FaAccountBalance ACCOUNTBALANCE LEFT OUTER JOIN T_BD_Period PERIOD ON ACCOUNTBALANCE.FPeriodID = PERIOD.FID");
            }
            tmp.append(" WHERE PERIOD.FNumber >= ").append(startPeriod);
            tmp.append(" AND PERIOD.FNumber <= ").append(endPeriod);
            tmp.append(") T ");
            if (!this.isShowCat) {
                if (this.isShowByPeriod) {
                    tmp.append(" GROUP BY PERIODINFO,COMPANYID");
                    sql.append(" (").append(tmp).append(") t2");
                } else {
                    tmp.append(" GROUP BY COMPANYID,PERIODINFO");
                    sql.append(" (SELECT TMP.COMPANYID COMPANYID, MAX(TMP.PERIODINFO) PERIODINFO FROM(").append(tmp).append(") TMP");
                    sql.append(" GROUP BY TMP.COMPANYID) t1 INNER JOIN (").append(tmp).append(") t2 ON t1.COMPANYID = t2.COMPANYID AND t1.PERIODINFO = t2.PERIODINFO");
                }
            } else {
                if (this.isShowByPeriod) {
                    tmp.append(" GROUP BY PERIODINFO,COMPANYID,FAssetCatID");
                    sql.append(" (").append(tmp).append(") t2");
                } else {
                    tmp.append(" GROUP BY COMPANYID,PERIODINFO,FAssetCatID");
                    sql.append(" (SELECT FAssetCatID,TMP.COMPANYID COMPANYID, MAX(TMP.PERIODINFO) PERIODINFO FROM(").append(tmp).append(") TMP");
                    sql.append(" GROUP BY TMP.COMPANYID,FAssetCatID) t1 INNER JOIN (").append(tmp).append(") t2 ON t1.COMPANYID = t2.COMPANYID AND t1.PERIODINFO = t2.PERIODINFO and t1.FAssetCatID=t2.FAssetCatID");
                }
                sql.append(")d");
                sql.append(" inner join ");
                sql.append(this.buildTempCat());
                sql.append("tempCat on d.FAssetCatID=tempCat.fid and d.amount <>0 ");
            }
            sql.toString();
        } else {
            if (this.isShowCat) {
                sql.append("card.FAssetCatID AS FASSETCATID,");
            }
            sql.append("sum(AccountBalance.FDepreEndBalanceFor) as amount ");
            if (this.isShowByPeriod) {
                sql.append(",PERIOD.FNumber PERIODINFO ");
            }
            sql.append(" FROM ");
            if (this.isShowCat) {
                sql.append(this.buildFromCat());
            } else {
                sql.append(this.buildFrom());
            }
            if (this.isShowByPeriod) {
                sql.append(" WHERE PERIOD.FNumber >= ").append(this.startYear * 100 + this.startNumber);
                sql.append(" AND PERIOD.FNumber <= ").append(this.endYear * 100 + this.endNumber);
                sql.append(" AND ACCOUNTBALANCE.FCompanyOrgUnitID = '").append(this.currCompanyInfo.getId().toString()).append("' ");
            } else {
                sql.append(" WHERE ").append(this.buildWhere(this.endYear, this.endNumber, "AccountBalance.FDepreEndBalanceFor"));
            }
            if (this.isShowCat && this.isShowByPeriod) {
                sql.append("GROUP BY card.FAssetCatID,PERIOD.FNumber ");
            } else if (this.isShowByPeriod) {
                sql.append("GROUP BY PERIOD.FNumber ");
            } else if (this.isShowCat) {
                sql.append("GROUP BY card.FAssetCatID ");
            }
        }
        return sql.toString();
    }

    private String buildNeatValueSQL(int type) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT " + type + " SEQ,");
        if (this.isShowDetail) {
            sql.append("TO_CHAR(NULL) titleDetail,TO_CHAR(NULL) titleNumber,");
        }
        if (this.isVirCompany) {
            if (this.isShowCat) {
                if (this.isShowByPeriod) {
                    sql.append("d.PERIODINFO,");
                }
                sql.append("tempCat.assetname as ASSETNAME,tempCat.assetLongNumber as ASSETLongNumber,d.COMPANYID AS COMPANYID, d.amount AS AMOUNT ");
            } else {
                if (this.isShowByPeriod) {
                    sql.append("t2.PERIODINFO, ");
                }
                sql.append("t2.COMPANYID COMPANYID, t2.amount AMOUNT ");
            }
            sql.append(" FROM ");
            if (this.isShowCat) {
                sql.append("(SELECT t2.COMPANYID COMPANYID, t2.FAssetCatID,t2.amount AMOUNT ");
                if (this.isShowByPeriod) {
                    sql.append(",t2.PERIODINFO");
                }
                sql.append(" FROM");
            }
            int startPeriod = this.startYear * 100 + this.startNumber;
            int endPeriod = this.endYear * 100 + this.endNumber;
            StringBuffer tmp = new StringBuffer();
            if (this.isShowCat) {
                tmp.append(" SELECT FAssetCatID, COMPANYID,SUM(amount) AMOUNT,PERIODINFO FROM(SELECT card.FAssetCatID FAssetCatID, ACCOUNTBALANCE.FCompanyOrgUnitID AS COMPANYID,");
                tmp.append(" AccountBalance.FRealEndBalanceFor - AccountBalance.FDepreEndBalanceFor AS amount, PERIOD.FNumber as PERIODINFO");
                tmp.append(" FROM T_FA_FaAccountBalance ACCOUNTBALANCE LEFT OUTER JOIN T_BD_Period PERIOD ON ACCOUNTBALANCE.FPeriodID = PERIOD.FID");
                tmp.append(" inner join (");
                tmp.append(this.buildMonFromCurCard());
                tmp.append(" ) card ON card.FFaPeriodID = PERIOD.FID AND card.FFaCurCardID = ACCOUNTBALANCE.FFaCurCardID ");
            } else {
                tmp.append(" SELECT COMPANYID,SUM(amount) AMOUNT,PERIODINFO FROM(SELECT ACCOUNTBALANCE.FCompanyOrgUnitID AS COMPANYID,");
                tmp.append(" AccountBalance.FRealEndBalanceFor - AccountBalance.FDepreEndBalanceFor AS amount, PERIOD.FNumber as PERIODINFO");
                tmp.append(" FROM T_FA_FaAccountBalance ACCOUNTBALANCE LEFT OUTER JOIN T_BD_Period PERIOD ON ACCOUNTBALANCE.FPeriodID = PERIOD.FID");
            }
            tmp.append(" WHERE PERIOD.FNumber >= ").append(startPeriod);
            tmp.append(" AND PERIOD.FNumber <= ").append(endPeriod);
            tmp.append(") T ");
            if (!this.isShowCat) {
                if (this.isShowByPeriod) {
                    tmp.append(" GROUP BY PERIODINFO,COMPANYID ");
                    sql.append(" (").append(tmp).append(") t2");
                } else {
                    tmp.append(" GROUP BY COMPANYID,PERIODINFO ");
                    sql.append(" (SELECT TMP.COMPANYID AS COMPANYID, MAX(TMP.PERIODINFO) PERIODINFO FROM(").append(tmp).append(") TMP");
                    sql.append(" GROUP BY TMP.COMPANYID) t1 INNER JOIN (").append(tmp).append(") t2 ON t1.COMPANYID = t2.COMPANYID AND t1.PERIODINFO = t2.PERIODINFO ");
                }
            } else {
                if (this.isShowByPeriod) {
                    tmp.append(" GROUP BY PERIODINFO,COMPANYID,FAssetCatID ");
                    sql.append(" (").append(tmp).append(") t2");
                } else {
                    tmp.append(" GROUP BY COMPANYID,PERIODINFO,FAssetCatID ");
                    sql.append(" (SELECT FAssetCatID,TMP.COMPANYID AS COMPANYID, MAX(TMP.PERIODINFO) PERIODINFO FROM(").append(tmp).append(") TMP");
                    sql.append(" GROUP BY TMP.COMPANYID,FAssetCatID) t1 INNER JOIN (").append(tmp).append(") t2 ON t1.COMPANYID = t2.COMPANYID AND t1.PERIODINFO = t2.PERIODINFO and t1.FAssetCatID=t2.FAssetCatID");
                }
                sql.append(")d");
                sql.append(" inner join ");
                sql.append(this.buildTempCat());
                sql.append("tempCat on d.FAssetCatID=tempCat.fid and d.amount <> 0 ");
            }
        } else {
            if (this.isShowCat) {
                sql.append("card.FAssetCatID AS FASSETCATID,");
            }
            sql.append("SUM(AccountBalance.FRealEndBalanceFor - AccountBalance.FDepreEndBalanceFor) AS AMOUNT");
            if (this.isShowByPeriod) {
                sql.append(",PERIOD.FNumber PERIODINFO ");
            }
            if (this.isShowCat) {
                sql.append(" FROM ").append(this.buildFromCat());
            } else {
                sql.append(" FROM ").append(this.buildFrom());
            }
            if (this.isShowByPeriod) {
                sql.append(" WHERE PERIOD.FNumber >= ").append(this.startYear * 100 + this.startNumber);
                sql.append(" AND PERIOD.FNumber <= ").append(this.endYear * 100 + this.endNumber);
                sql.append(" AND ACCOUNTBALANCE.FCompanyOrgUnitID = '").append(this.currCompanyInfo.getId().toString()).append("' ");
            } else {
                sql.append(" WHERE ").append(this.buildWhere(this.endYear, this.endNumber, "(AccountBalance.FRealEndBalanceFor - AccountBalance.FDepreEndBalanceFor)"));
            }
            if (this.isShowCat && this.isShowByPeriod) {
                sql.append("GROUP BY card.FAssetCatID,PERIOD.FNumber ");
            } else if (this.isShowByPeriod) {
                sql.append("GROUP BY PERIOD.FNumber ");
            } else if (this.isShowCat) {
                sql.append("GROUP BY card.FAssetCatID ");
            }
        }
        return sql.toString();
    }

    private String buildEndDecValue(int type) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT " + type + " AS SEQ,");
        if (this.isShowDetail) {
            sql.append("TO_CHAR(NULL) AS titleDetail,TO_CHAR(NULL) AS titleNumber,");
        }
        if (this.isVirCompany) {
            if (this.isShowCat) {
                if (this.isShowByPeriod) {
                    sql.append("d.PERIODINFO, ");
                }
                sql.append("tempCat.assetname as ASSETNAME,tempCat.assetLongNumber as ASSETLongNumber,d.COMPANYID AS COMPANYID, d.amount AS AMOUNT ");
            } else {
                if (this.isShowByPeriod) {
                    sql.append("t2.PERIODINFO, ");
                }
                sql.append("t2.COMPANYID AS COMPANYID, t2.amount AMOUNT");
            }
            sql.append(" FROM ");
            if (this.isShowCat) {
                sql.append("(SELECT t2.COMPANYID COMPANYID, t2.FAssetCatID,t2.amount AMOUNT ");
                if (this.isShowByPeriod) {
                    sql.append(",t2.PERIODINFO");
                }
                sql.append(" FROM");
            }
            int startPeriod = this.startYear * 100 + this.startNumber;
            int endPeriod = this.endYear * 100 + this.endNumber;
            StringBuffer tmp = new StringBuffer();
            if (this.isShowCat) {
                tmp.append(" SELECT FAssetCatID,COMPANYID,SUM(amount) AS AMOUNT,PERIODINFO FROM(SELECT card.FAssetCatID FAssetCatID,ACCOUNTBALANCE.FCompanyOrgUnitID COMPANYID,");
                tmp.append(" AccountBalance.FDecValueEndBalanceFor AS amount, PERIOD.FNumber as PERIODINFO ");
                tmp.append(" FROM T_FA_FaAccountBalance ACCOUNTBALANCE LEFT OUTER JOIN T_BD_Period PERIOD ON ACCOUNTBALANCE.FPeriodID = PERIOD.FID");
                tmp.append(" inner join (");
                tmp.append(this.buildMonFromCurCard());
                tmp.append(" ) card ON card.FFaPeriodID = PERIOD.FID AND card.FFaCurCardID = ACCOUNTBALANCE.FFaCurCardID ");
            } else {
                tmp.append(" SELECT COMPANYID,SUM(amount) AS AMOUNT,PERIODINFO FROM(SELECT ACCOUNTBALANCE.FCompanyOrgUnitID COMPANYID,");
                tmp.append(" AccountBalance.FDecValueEndBalanceFor AS amount, PERIOD.FNumber as PERIODINFO ");
                tmp.append(" FROM T_FA_FaAccountBalance ACCOUNTBALANCE LEFT OUTER JOIN T_BD_Period PERIOD ON ACCOUNTBALANCE.FPeriodID = PERIOD.FID");
            }
            tmp.append(" WHERE PERIOD.FNumber >= ").append(startPeriod);
            tmp.append(" AND PERIOD.FNumber <= ").append(endPeriod);
            tmp.append(") T ");
            if (!this.isShowCat) {
                if (this.isShowByPeriod) {
                    tmp.append(" GROUP BY PERIODINFO,COMPANYID");
                    sql.append(" (").append(tmp).append(") t2");
                } else {
                    tmp.append(" GROUP BY COMPANYID,PERIODINFO ");
                    sql.append(" (SELECT TMP.COMPANYID AS COMPANYID, MAX(TMP.PERIODINFO) PERIODINFO FROM(").append(tmp).append(") TMP");
                    sql.append(" GROUP BY TMP.COMPANYID) t1 INNER JOIN (").append(tmp).append(") t2 ON t1.COMPANYID = t2.COMPANYID AND t1.PERIODINFO = t2.PERIODINFO");
                }
            } else {
                if (this.isShowByPeriod) {
                    tmp.append(" GROUP BY PERIODINFO,COMPANYID,FAssetCatID");
                    sql.append(" (").append(tmp).append(") t2");
                } else {
                    tmp.append(" GROUP BY COMPANYID,PERIODINFO,FAssetCatID ");
                    sql.append(" (SELECT FAssetCatID, TMP.COMPANYID AS COMPANYID, MAX(TMP.PERIODINFO) PERIODINFO FROM(").append(tmp).append(") TMP");
                    sql.append(" GROUP BY TMP.COMPANYID,FAssetCatID) t1 INNER JOIN (").append(tmp).append(") t2 ON t1.COMPANYID = t2.COMPANYID AND t1.PERIODINFO = t2.PERIODINFO and t1.FAssetCatID=t2.FAssetCatID");
                }
                sql.append(")d");
                sql.append(" inner join ");
                sql.append(this.buildTempCat());
                sql.append("tempCat on d.FAssetCatID=tempCat.fid and d.amount <> 0 ");
            }
            sql.toString();
        } else {
            if (this.isShowCat) {
                sql.append("card.FAssetCatID AS FASSETCATID,");
            }
            sql.append("sum(AccountBalance.FDecValueEndBalanceFor) AS amount");
            if (this.isShowByPeriod) {
                sql.append(",PERIOD.FNumber PERIODINFO ");
            }
            if (this.isShowCat) {
                sql.append(" FROM ").append(this.buildFromCat());
            } else {
                sql.append(" FROM ").append(this.buildFrom());
            }
            if (this.isShowByPeriod) {
                sql.append(" WHERE PERIOD.FNumber >= ").append(this.startYear * 100 + this.startNumber);
                sql.append(" AND PERIOD.FNumber <= ").append(this.endYear * 100 + this.endNumber);
                sql.append(" AND ACCOUNTBALANCE.FCompanyOrgUnitID = '").append(this.currCompanyInfo.getId().toString()).append("' ");
            } else {
                sql.append(" WHERE ").append(this.buildWhere(this.endYear, this.endNumber, "AccountBalance.FDecValueEndBalanceFor"));
            }
            if (this.isShowCat && this.isShowByPeriod) {
                sql.append("GROUP BY card.FAssetCatID,PERIOD.FNumber ");
            } else if (this.isShowByPeriod) {
                sql.append("GROUP BY PERIOD.FNumber ");
            } else if (this.isShowCat) {
                sql.append("GROUP BY card.FAssetCatID ");
            }
        }
        return sql.toString();
    }

    private String buildNeatAmt(int type) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT " + type + " AS SEQ,");
        if (this.isShowDetail) {
            sql.append("TO_CHAR(NULL) AS titleDetail,TO_CHAR(NULL) AS titleNumber,");
        }
        if (this.isVirCompany) {
            if (this.isShowCat) {
                if (this.isShowByPeriod) {
                    sql.append("d.PERIODINFO, ");
                }
                sql.append("tempCat.assetname as ASSETNAME,tempCat.assetLongNumber as ASSETLongNumber,d.COMPANYID AS COMPANYID, d.amount AS AMOUNT ");
            } else {
                if (this.isShowByPeriod) {
                    sql.append("t2.PERIODINFO, ");
                }
                sql.append("t2.COMPANYID AS COMPANYID, t2.amount AS AMOUNT");
            }
            sql.append(" FROM ");
            if (this.isShowCat) {
                sql.append("(SELECT t2.COMPANYID COMPANYID, t2.FAssetCatID,t2.amount AMOUNT ");
                if (this.isShowByPeriod) {
                    sql.append(",t2.PERIODINFO");
                }
                sql.append(" FROM");
            }
            int startPeriod = this.startYear * 100 + this.startNumber;
            int endPeriod = this.endYear * 100 + this.endNumber;
            StringBuffer tmp = new StringBuffer();
            if (this.isShowCat) {
                tmp.append(" SELECT FAssetCatID,COMPANYID,SUM(amount) AS AMOUNT,PERIODINFO FROM(SELECT card.FAssetCatID FAssetCatID, ACCOUNTBALANCE.FCompanyOrgUnitID AS COMPANYID,");
                tmp.append(" AccountBalance.FRealEndBalanceFor - AccountBalance.FDepreEndBalanceFor - AccountBalance.FDecValueEndBalanceFor AS amount, PERIOD.FNumber as PERIODINFO");
                tmp.append(" FROM T_BD_Period PERIOD  LEFT OUTER JOIN T_FA_FaAccountBalance ACCOUNTBALANCE ON ACCOUNTBALANCE.FPeriodID = PERIOD.FID");
                tmp.append(" inner join (");
                tmp.append(this.buildMonFromCurCard());
                tmp.append(" ) card ON card.FFaPeriodID = PERIOD.FID AND card.FFaCurCardID = ACCOUNTBALANCE.FFaCurCardID ");
            } else {
                tmp.append(" SELECT COMPANYID,SUM(amount) AS AMOUNT,PERIODINFO FROM(SELECT ACCOUNTBALANCE.FCompanyOrgUnitID AS COMPANYID,");
                tmp.append(" AccountBalance.FRealEndBalanceFor - AccountBalance.FDepreEndBalanceFor - AccountBalance.FDecValueEndBalanceFor AS amount, PERIOD.FNumber as PERIODINFO");
                tmp.append(" FROM T_BD_Period PERIOD  LEFT OUTER JOIN T_FA_FaAccountBalance ACCOUNTBALANCE ON ACCOUNTBALANCE.FPeriodID = PERIOD.FID");
            }
            tmp.append(" WHERE PERIOD.FNumber >= ").append(startPeriod);
            tmp.append(" AND PERIOD.FNumber <= ").append(endPeriod);
            tmp.append(") T ");
            if (!this.isShowCat) {
                if (this.isShowByPeriod) {
                    tmp.append(" GROUP BY PERIODINFO,COMPANYID");
                    sql.append(" (").append(tmp).append(") t2");
                } else {
                    tmp.append(" GROUP BY COMPANYID,PERIODINFO");
                    sql.append(" (SELECT TMP.COMPANYID AS COMPANYID, MAX(TMP.PERIODINFO) as PERIODINFO FROM(").append(tmp).append(") TMP");
                    sql.append(" GROUP BY TMP.COMPANYID) t1 INNER JOIN (").append(tmp).append(") t2 ON t1.COMPANYID = t2.COMPANYID AND t1.PERIODINFO = t2.PERIODINFO ");
                }
            } else {
                if (this.isShowByPeriod) {
                    tmp.append(" GROUP BY PERIODINFO,COMPANYID,FAssetCatID");
                    sql.append(" (").append(tmp).append(") t2");
                } else {
                    tmp.append(" GROUP BY COMPANYID,PERIODINFO,FAssetCatID");
                    sql.append(" (SELECT FAssetCatID,TMP.COMPANYID AS COMPANYID, MAX(TMP.PERIODINFO) as PERIODINFO FROM(").append(tmp).append(") TMP");
                    sql.append(" GROUP BY TMP.COMPANYID,FAssetCatID) t1 INNER JOIN (").append(tmp).append(") t2 ON t1.COMPANYID = t2.COMPANYID AND t1.PERIODINFO = t2.PERIODINFO and t1.FAssetCatID=t2.FAssetCatID");
                }
                sql.append(")d");
                sql.append(" inner join ");
                sql.append(this.buildTempCat());
                sql.append("tempCat on d.FAssetCatID=tempCat.fid and d.amount <> 0 ");
            }
            sql.toString();
        } else {
            if (this.isShowCat) {
                sql.append("card.FAssetCatID AS FASSETCATID,");
            }
            sql.append("SUM(AccountBalance.FRealEndBalanceFor - AccountBalance.FDepreEndBalanceFor - AccountBalance.FDECVALUEENDBALANCEFOR) AS AMOUNT");
            if (this.isShowByPeriod) {
                sql.append(",PERIOD.FNumber PERIODINFO ");
            }
            if (this.isShowCat) {
                sql.append(" FROM ").append(this.buildFromCat());
            } else {
                sql.append(" FROM ").append(this.buildFrom());
            }
            if (this.isShowByPeriod) {
                sql.append(" WHERE PERIOD.FNumber >= ").append(this.startYear * 100 + this.startNumber);
                sql.append(" AND PERIOD.FNumber <= ").append(this.endYear * 100 + this.endNumber);
                sql.append(" AND ACCOUNTBALANCE.FCompanyOrgUnitID = '").append(this.currCompanyInfo.getId().toString()).append("' ");
            } else {
                sql.append(" WHERE ").append(this.buildWhere(this.endYear, this.endNumber, "(AccountBalance.FRealEndBalanceFor - AccountBalance.FDepreEndBalanceFor)"));
            }
            if (this.isShowCat && this.isShowByPeriod) {
                sql.append("GROUP BY card.FAssetCatID,PERIOD.FNumber ");
            } else if (this.isShowByPeriod) {
                sql.append("GROUP BY PERIOD.FNumber ");
            } else if (this.isShowCat) {
                sql.append("GROUP BY card.FAssetCatID ");
            }
        }
        return sql.toString();
    }

    private String buildBalanceForCompany(boolean isEndPeriod) {
        int startPeriod = this.startYear * 100 + this.startNumber;
        int endPeriod = this.endYear * 100 + this.endNumber;
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT COMPANYID, SUM(amount) AMOUNT, PERIOD FROM (SELECT ACCOUNTBALANCE.FCompanyOrgUnitID COMPANYID,");
        sql.append(isEndPeriod ? " ACCOUNTBALANCE.FDepreEndBalanceFor" : "ACCOUNTBALANCE.FDepreBeginBalanceFor");
        sql.append(" AMOUNT,(PERIOD.FNumber) PERIOD FROM T_FA_FaAccountBalance ACCOUNTBALANCE");
        sql.append(" INNER JOIN T_BD_Period PERIOD ON ACCOUNTBALANCE.FPeriodID = PERIOD.FID");
        sql.append(" WHERE PERIOD.FNumber>= ").append(startPeriod);
        sql.append(" AND PERIOD.FNumber <= ").append(endPeriod).append(") T");
        sql.append(" GROUP BY COMPANYID, PERIOD");
        return sql.toString();
    }

    private void buildCompanySumData() throws BOSException {
        StringBuffer sql = new StringBuffer();
        List sumGroup = this.sumOption.getSumInfoList();
        if (sumGroup.isEmpty()) {
            return;
        }
        int topLevel = this.currCompanyInfo.getLevel();
        StringBuffer selectNameFor = new StringBuffer();
        StringBuffer selectLongNumberFor = new StringBuffer();
        for (int k = 0; k < sumGroup.size(); ++k) {
            if (k > 0) {
                sql.append(" UNION ALL ");
            }
            sql.append(" SELECT newBOSID('00000000') AS FId");
            if (this.isShowByPeriod) {
                sql.append(",PERIODINFO ");
            }
            if (this.isVirCompany && this.isShowCat) {
                sql.append(",ASSETNAME as ASSETNAME ,ASSETLongNumber as ASSETLongNumber");
            }
            LevelSumSqlInfo sumSqlInfoFor = (LevelSumSqlInfo)sumGroup.get(k);
            if (k < sumGroup.size()) {
                selectNameFor.append(",NULL AS ").append(sumSqlInfoFor.getNameField());
                selectLongNumberFor.append(",NULL AS ").append(sumSqlInfoFor.getLongNumberField());
            } else {
                selectNameFor.append(",NULL AS ").append(sumSqlInfoFor.getNameField());
                selectLongNumberFor.append(",NULL AS ").append(sumSqlInfoFor.getLongNumberField());
            }
            StringBuffer selectName = new StringBuffer();
            StringBuffer selectLongNumber = new StringBuffer();
            StringBuffer groupName = new StringBuffer();
            StringBuffer groupLongNumber = new StringBuffer();
            LevelSumSqlInfo currSumInfo = null;
            int size = sumGroup.size();
            for (int i = 0; i < size; ++i) {
                LevelSumSqlInfo sumSqlInfo = (LevelSumSqlInfo)sumGroup.get(i);
                if (i <= k) {
                    selectName.append(",").append(sumSqlInfo.getNameField());
                    selectLongNumber.append(",").append(sumSqlInfo.getLongNumberField());
                    groupName.append(",").append(sumSqlInfo.getNameField());
                    groupLongNumber.append(",").append(sumSqlInfo.getLongNumberField());
                    currSumInfo = sumSqlInfo;
                    continue;
                }
                selectName.append(", NULL AS ").append(sumSqlInfo.getNameField());
                selectLongNumber.append(", N'").append("*").append("' AS ").append(sumSqlInfo.getLongNumberField());
            }
            sql.append(selectName.toString());
            sql.append(",2 AS ISSUM,SEQ, SUM(amount) AS amount, ");
            if (this.isShowDetail) {
                sql.append("titleDetail, titleNumber,");
            }
            if (currSumInfo == null) {
                sql.append(topLevel - 1).append(" AS SumLevel");
            } else {
                sql.append(currSumInfo.getLevel()).append(" AS SumLevel");
            }
            sql.append(selectLongNumber.toString());
            sql.append(" FROM ").append(this.tempTable);
            sql.append(" WHERE ");
            if (currSumInfo != null) {
                sql.append(currSumInfo.getLongNumberField()).append(" IS NOT NULL");
            } else {
                sql.append("titleDetail IS NOT NULL");
            }
            sql.append(" GROUP BY ");
            if (this.isShowByPeriod) {
                sql.append(" PERIODINFO,");
            }
            sql.append(" SEQ");
            if (this.isShowCat && this.isVirCompany) {
                sql.append(",ASSETNAME,ASSETLongNumber");
            }
            if (this.isShowDetail && currSumInfo != null) {
                sql.append(",titleNumber,titleDetail");
            }
            sql.append(groupLongNumber).append(groupName.toString());
            if (this.isShowDetail) {
                sql.append(" UNION ALL ");
                sql.append(" SELECT newBOSID('00000000') AS FId");
                if (this.isShowByPeriod) {
                    sql.append(" ,PERIODINFO");
                }
                if (this.isShowCat && this.isVirCompany) {
                    sql.append(", NULL AS ASSETNAME,NULL AS ASSETLongNumber");
                }
                sql.append(selectName.toString());
                sql.append(",1 AS ISSUM,SEQ, SUM(amount) AS amount, N'");
                sql.append(this.subTotal).append("' AS titleDetail, ");
                sql.append("N'").append(LevelSumOption.MAXCODE).append("' AS titleNumber,");
                if (currSumInfo == null) {
                    sql.append(topLevel - 1).append(" AS SumLevel");
                } else {
                    sql.append(currSumInfo.getLevel()).append(" AS SumLevel");
                }
                sql.append(selectLongNumber.toString());
                sql.append(" FROM ").append(this.tempTable);
                sql.append(" WHERE ");
                if (currSumInfo != null) {
                    sql.append(currSumInfo.getLongNumberField()).append(" IS NOT NULL AND titleDetail IS NOT NULL");
                } else {
                    sql.append("titleDetail IS NOT NULL");
                }
                sql.append(" GROUP BY ");
                if (this.isShowByPeriod) {
                    sql.append(" PERIODINFO,");
                }
                sql.append(" SEQ");
                sql.append(groupLongNumber).append(groupName.toString());
            }
            if (!this.isShowCat) continue;
            sql.append(" UNION ALL ");
            sql.append(" SELECT newBOSID('00000000') AS FId");
            if (this.isShowByPeriod) {
                sql.append(" ,PERIODINFO");
            }
            if (this.isShowCat && this.isVirCompany) {
                sql.append(", N'");
                sql.append(this.subTotal).append("' AS ASSETNAME, ");
                sql.append("N'").append(LevelSumOption.MAXCODE).append("' AS ASSETLongNumber");
            }
            sql.append(selectName.toString());
            sql.append(",1 AS ISSUM,SEQ, SUM(amount) AS amount, ");
            if (this.isShowDetail) {
                sql.append(" titleDetail,titleNumber,");
            }
            if (currSumInfo == null) {
                sql.append(topLevel - 1).append(" AS SumLevel");
            } else {
                sql.append(currSumInfo.getLevel()).append(" AS SumLevel");
            }
            sql.append(selectLongNumber.toString());
            sql.append(" FROM ").append(this.tempTable);
            sql.append(" WHERE ");
            if (currSumInfo != null) {
                sql.append(currSumInfo.getLongNumberField()).append(" IS NOT NULL AND ASSETNAME IS NOT NULL");
            } else {
                sql.append("ASSETNAME IS NOT NULL");
            }
            sql.append(" GROUP BY ");
            if (this.isShowByPeriod) {
                sql.append(" PERIODINFO,");
            }
            if (this.isShowDetail) {
                sql.append(" titleDetail,titleNumber,");
            }
            sql.append(" SEQ");
            sql.append(groupLongNumber).append(groupName.toString());
        }
        this.sumSql = "INSERT INTO " + this.tempTable + " SELECT * FROM (" + sql.toString() + ") tempTable";
    }

    private void buildCatSumData() {
        int i;
        StringBuffer sql = new StringBuffer();
        List sumGroup = this.sumOption.getSumInfoList();
        if (sumGroup.isEmpty()) {
            return;
        }
        StringBuffer strName = new StringBuffer();
        StringBuffer strNumber = new StringBuffer();
        StringBuffer caseCond = new StringBuffer();
        StringBuffer caseCondCat = new StringBuffer();
        for (i = 0; i < this.changeField.length; ++i) {
            if (i != 0) {
                caseCond.append(" OR ");
            }
            caseCond.append(" SEQ = " + this.changeField[i] + " ");
        }
        for (i = 0; i < this.beginEndField.length; ++i) {
            if (i != 0) {
                caseCondCat.append(" OR ");
            }
            caseCondCat.append(" SEQ = " + this.beginEndField[i] + " ");
        }
        for (int n = 0; n < sumGroup.size(); ++n) {
            LevelSumSqlInfo sqlInfo = (LevelSumSqlInfo)sumGroup.get(n);
            strName.append(",");
            strNumber.append(",");
            if (!this.isShowDetail && n == 0) {
                if (this.isShowCat) {
                    strName.append("CASE WHEN " + caseCond.toString() + " or " + caseCondCat.toString() + " THEN N'").append(this.subTotal).append("' ELSE NULL END");
                    strNumber.append("CASE WHEN " + caseCond.toString() + " or " + caseCondCat.toString() + " THEN N'").append(LevelSumOption.MAXCODE).append("' ELSE NULL END");
                }
            } else if (this.isShowDetail && this.isShowCat && n == 0) {
                strName.append("CASE WHEN " + caseCondCat.toString() + " THEN N'").append(this.subTotal).append("' ELSE NULL END");
                strNumber.append("CASE WHEN " + caseCondCat.toString() + " THEN N'").append(LevelSumOption.MAXCODE).append("' ELSE NULL END");
            } else {
                strName.append(" NULL");
                strNumber.append(" NULL");
            }
            strName.append(" AS ").append(sqlInfo.getNameField());
            strNumber.append(" AS ").append(sqlInfo.getLongNumberField());
        }
        int topLevel = 1;
        sql.append("SELECT newBOSID('00000000') AS FId");
        if (this.isShowByPeriod) {
            sql.append(" ,PERIODINFO ");
        }
        sql.append(strName).append(",");
        sql.append(" CASE WHEN " + caseCond.toString() + " or " + caseCondCat.toString() + " THEN 1 ELSE 2 END AS ISSUM, SEQ, SUM(amount) AMOUNT, ");
        if (this.isShowDetail) {
            sql.append("CASE WHEN " + caseCond.toString() + " THEN N'").append(this.subTotal).append("' ELSE NULL END").append(" AS titleDetail,");
            sql.append("CASE WHEN " + caseCond.toString() + " THEN N'").append(LevelSumOption.MAXCODE).append("' ELSE NULL END").append(" AS titleNumber,");
        }
        sql.append(topLevel - (this.isShowDetail ? 2 : 1)).append(" AS SUMLEVEL");
        sql.append(strNumber);
        sql.append(" FROM ").append(this.tempTable);
        sql.append(" WHERE ").append("isSum = 0");
        sql.append(" GROUP BY ");
        if (this.isShowByPeriod) {
            sql.append(" PERIODINFO,");
        }
        sql.append(" SEQ");
        if (this.isShowDetail) {
            sql.append(" UNION ALL ");
            sql.append("SELECT NEWBOSID('00000000') FID");
            if (this.isShowByPeriod) {
                sql.append(" ,PERIODINFO ");
            }
            strName = new StringBuffer();
            strNumber = new StringBuffer();
            for (int n = 0; n < sumGroup.size(); ++n) {
                LevelSumSqlInfo sqlInfo = (LevelSumSqlInfo)sumGroup.get(n);
                strName.append(",");
                strNumber.append(",");
                if (n == 0) {
                    strName.append("CASE WHEN " + caseCond.toString() + " THEN N'").append(this.subTotal).append("' ELSE NULL END");
                    strNumber.append("CASE WHEN " + caseCond.toString() + " THEN N'").append(LevelSumOption.MAXCODE).append("' ELSE NULL END");
                } else {
                    strName.append(" NULL");
                    strNumber.append(" NULL");
                }
                strName.append(" AS ").append(sqlInfo.getNameField());
                strNumber.append(" AS ").append(sqlInfo.getLongNumberField());
            }
            sql.append(strName).append(", 1 AS ISSUM,");
            sql.append(" SEQ, SUM(amount) AMOUNT, titleDetail,titleNumber,");
            sql.append(topLevel - 1).append(" AS SUMLEVEL");
            sql.append(strNumber);
            sql.append(" FROM ").append(this.tempTable);
            sql.append(" WHERE ").append("isSum = 0 AND titleDetail IS NOT NULL");
            sql.append(" GROUP BY ");
            if (this.isShowByPeriod) {
                sql.append(" PERIODINFO,");
            }
            sql.append(" SEQ, titleNumber, titleDetail");
        }
        StringBuffer selectNumber = new StringBuffer();
        StringBuffer selectName = new StringBuffer();
        StringBuffer groupNumber = new StringBuffer();
        StringBuffer groupName = new StringBuffer();
        StringBuffer group = new StringBuffer();
        if (this.isShowByPeriod) {
            group.append(" PERIODINFO, ");
        }
        group.append("SEQ,");
        if (this.isShowDetail) {
            group.append("titleNumber,titleDetail,");
        }
        FaDaoSqlObject sumSqlDao = new FaDaoSqlObject();
        sumSqlDao.setFrom(this.tempTable);
        int n = sumGroup.size();
        for (int i2 = 0; i2 < n; ++i2) {
            sql.append(" UNION ALL ");
            LevelSumSqlInfo groupInfo = (LevelSumSqlInfo)sumGroup.get(i2);
            selectNumber.append(", ").append(groupInfo.getLongNumberField());
            selectName.append(", ").append(groupInfo.getNameField());
            if (groupNumber.length() > 0) {
                groupNumber.append(", ");
            }
            if (groupName.length() > 0) {
                groupName.append(", ");
            }
            groupNumber.append(groupInfo.getLongNumberField());
            groupName.append(groupInfo.getNameField());
            sumSqlDao.setGroup(group.toString() + groupNumber + ", " + groupName);
            StringBuffer where = new StringBuffer();
            where.append("isSum = 0 and ").append(groupInfo.getNameField());
            where.append(" IS NOT NULL AND ").append(groupInfo.getNameField()).append(" <> ' '");
            sumSqlDao.setWhere(where.toString());
            StringBuffer name1 = new StringBuffer().append(selectName);
            StringBuffer number1 = new StringBuffer().append(selectNumber);
            for (int j = i2 + 1; j < n; ++j) {
                LevelSumSqlInfo sumInfo = (LevelSumSqlInfo)sumGroup.get(j);
                if (name1.length() > 0) {
                    name1.append(", ");
                    number1.append(", ");
                }
                if (j == i2 + 1) {
                    name1.append(" N'").append(this.subTotal).append("' AS ").append(sumInfo.getNameField());
                    number1.append(" N'").append(LevelSumOption.MAXCODE).append("' AS ").append(sumInfo.getLongNumberField());
                    continue;
                }
                name1.append(" NULL AS ").append(sumInfo.getNameField());
                number1.append(" NULL AS ").append(sumInfo.getLongNumberField());
            }
            StringBuffer select = new StringBuffer();
            select.append("newBOSID('00000000') AS FId ");
            if (this.isShowByPeriod) {
                select.append(" ,PERIODINFO");
            }
            select.append(name1);
            select.append(", 2 AS ISSUM, SEQ, SUM(amount) AMOUNT, ");
            if (this.isShowDetail) {
                select.append("titleDetail,titleNumber,");
            }
            select.append(i2 + 1).append(" AS SUMLEVEL");
            select.append(number1);
            sumSqlDao.setSelect(select.toString());
            sql.append(sumSqlDao.getSql());
        }
        this.sumSql = "INSERT INTO " + this.tempTable + " SELECT * FROM (" + sql.toString() + ") tempTable";
    }

    private String buildFrom() {
        StringBuffer from = new StringBuffer();
        from.append(" T_BD_Period PERIOD  ");
        from.append(" LEFT OUTER JOIN T_FA_FaAccountBalance ACCOUNTBALANCE ON (ACCOUNTBALANCE.FPeriodID = PERIOD.FID AND ACCOUNTBALANCE.FCompanyOrgUnitID = '" + this.currCompanyInfo.getId().toString() + "') ");
        return from.toString();
    }

    private String buildWhere(int periodYear, int periodNumber, String beginBalanceFor) {
        StringBuffer sql = new StringBuffer();
        if (!this.isVirCompany) {
            sql.append(" " + beginBalanceFor + "<>0 and ");
            sql.append(" ACCOUNTBALANCE.FCompanyOrgUnitID = '").append(this.currCompanyInfo.getId().toString()).append("' ");
            sql.append(" AND ");
        }
        sql.append(" PERIOD.FPeriodYear= ").append(periodYear);
        sql.append(" AND PERIOD.FPeriodNumber =").append(periodNumber);
        return sql.toString();
    }

    private String getCompanyFilter(String companyIds) throws BOSException {
        StringBuffer sbff = new StringBuffer();
        if (this.isVirCompany) {
            sbff.append(" COMPANY.FID IN (").append(companyIds).append(")");
        } else {
            sbff.append(" COMPANY.FID = ").append(companyIds);
        }
        return sbff.toString();
    }

    private String getCurrPeriodCompIds() throws BOSException {
        StringBuffer companyIds = new StringBuffer();
        if (this.isVirCompany) {
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT company.FID AS COMPANYID FROM T_BD_SystemStatusCtrol ssc");
            sql.append(" INNER JOIN T_BD_SystemStatus ss ON SSC.FSYSTEMSTATUSID = SS.FID");
            sql.append(" INNER JOIN T_ORG_Company company ON ssc.FCompanyID = company.FID");
            sql.append(" INNER JOIN T_BD_Period period ON ssc.FSTARTPERIODID = period.FID");
            sql.append(" WHERE period.FNumber <= ").append(this.endYear * 100 + this.endNumber);
            sql.append(" AND company.FID IN (").append(this.strCompanyInclude).append(") and ss.FName = 14 ");
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
            try {
                while (rs.next()) {
                    companyIds.append(",").append("'").append(rs.getString("COMPANYID")).append("'");
                }
            }
            catch (SQLException e) {
                throw new BOSException("Sql execute exception : " + sql, (Throwable)e);
            }
            if (companyIds.length() == 0) {
                return null;
            }
            return companyIds.substring(1);
        }
        if (this.currPeriod.getPeriodYear() == this.endYear && this.currPeriod.getPeriodNumber() == this.endNumber) {
            companyIds.append("'").append(this.currCompanyInfo.getId().toString()).append("'");
            return companyIds.toString();
        }
        return null;
    }

    private String getNewCardSql(int type) {
        String[] stringArray;
        if (type == 2 || type == 11 || type == 19) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "D.FAssetValue";
        } else if (type == 7 || type == 12) {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = "D.FAccuDepr";
        } else if (type == 15) {
            String[] stringArray4 = new String[1];
            stringArray = stringArray4;
            stringArray4[0] = "D.FDecValue";
        } else {
            String[] stringArray5 = new String[2];
            stringArray5[0] = "D.FAccuDepr";
            stringArray = stringArray5;
            stringArray5[1] = "D.FDecValue";
        }
        String[] fields = stringArray;
        StringBuffer sql = new StringBuffer();
        for (int i = fields.length - 1; i >= 0; --i) {
            if (i < fields.length - 1) {
                sql.append(" UNION ALL ");
            }
            sql.append("(SELECT ");
            sql.append(" D.FCompanyID AS COMPANYID,");
            if (this.isShowCat) {
                sql.append("D.FAssetCatID,");
            }
            sql.append(fields[i] + " AS CHANGEVALUE,");
            if (this.isShowByPeriod) {
                sql.append(" PERIOD.FNumber PERIODINFO,");
            }
            sql.append("AlterModeH.").append(this.fName).append(" AS titleDetail,");
            sql.append("AlterModeH.FLongNumber AS titleNumber");
            sql.append(" FROM T_FA_FABAKCARD D");
            sql.append(" LEFT OUTER JOIN T_BD_Period PERIOD");
            sql.append(" ON (D.FPeriodID = PERIOD.FID)");
            sql.append(" LEFT OUTER JOIN T_FA_AlterMode AlterModeH ON D.FORIGINMETHODID = AlterModeH.FID");
            sql.append(" WHERE (PERIOD.fperiodyear > ").append(this.startYear);
            sql.append(" OR (PERIOD.fperiodyear = ").append(this.startYear);
            sql.append(" AND PERIOD.fperiodnumber >= ").append(this.startNumber).append("))");
            sql.append(" AND (PERIOD.fperiodyear < ").append(this.endYear);
            sql.append(" OR (PERIOD.fperiodyear = ").append(this.endYear);
            sql.append(" AND PERIOD.fperiodnumber <= " + this.endNumber + "))");
            sql.append(" AND D.FCheckedStatus = 2 AND D.FBILLTYPE = 1");
            sql.append(" AND ").append(fields[i]).append(" > 0");
            sql.append(")");
        }
        return sql.toString();
    }

    private String getChangeBillSql(int type) {
        String changeField = type == 2 || type == 3 ? "B.TOriginChg" : (type == 7 || type == 8 ? "B.TAccuDeprChg" : (type == 15 || type == 16 ? "B.TDecValueChg" : ""));
        StringBuffer sql = new StringBuffer();
        if (changeField.trim().length() != 0) {
            sql.append("(SELECT ");
            sql.append("A.FCOMPANYID AS COMPANYID, ");
            if (this.isShowCat) {
                sql.append("C.FAssetCatID,");
            }
            if (type == 3 || type == 8 || type == 16) {
                sql.append("abs(" + changeField + ") AS CHANGEVALUE, ");
            } else {
                sql.append("" + changeField + " AS CHANGEVALUE, ");
            }
            if (this.isShowByPeriod) {
                sql.append(" PERIOD2.FNumber PERIODINFO,");
            }
            sql.append("AlterModeH.").append(this.fName).append(" AS titleDetail,");
            sql.append("AlterModeH.FLongNumber AS titleNumber ");
            sql.append("FROM T_FA_FACHANGEBILL A ");
            sql.append("LEFT OUTER JOIN T_FA_FACHANGEBILLENTRY B ON A.FID = B.FCHANGEBILLID ");
            sql.append("LEFT OUTER JOIN T_BD_Period PERIOD2 ON A.FPeriodID = PERIOD2.FID ");
            sql.append("LEFT OUTER JOIN T_FA_AlterMode AlterModeH ON A.FCHANGEMODEID = AlterModeH.FID ");
            if (this.isShowCat) {
                sql.append(" INNER JOIN T_FA_FABIZCARD C ON C.FID = B.FBizCardID ");
            }
            sql.append(" WHERE (PERIOD2.fperiodyear > " + this.startYear + " or (PERIOD2.fperiodyear = " + this.startYear + " and PERIOD2.fperiodnumber >= " + this.startNumber + "))");
            sql.append(" AND (PERIOD2.fperiodyear < " + this.endYear + " or (PERIOD2.fperiodyear = " + this.endYear + " and PERIOD2.fperiodnumber <= " + this.endNumber + "))");
            sql.append(" AND ").append(this.isShowNotAudit ? "A.FEffectedStatus" : "A.FCheckedStatus").append(" = 2");
            sql.append(" AND " + changeField + (type == 2 || type == 7 || type == 15 ? " > " : " < ") + "0)");
        } else {
            String[] stringArray;
            if (type == 11 || type == 12) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = "B.TOriginChg";
                stringArray = stringArray2;
                stringArray2[1] = "B.TAccuDeprChg";
            } else {
                String[] stringArray3 = new String[3];
                stringArray3[0] = "B.TOriginChg";
                stringArray3[1] = "B.TAccuDeprChg";
                stringArray = stringArray3;
                stringArray3[2] = "B.TDecValueChg";
            }
            String[] changeFields = stringArray;
            for (int i = changeFields.length - 1; i >= 0; --i) {
                if (i < changeFields.length - 1) {
                    sql.append(" UNION ALL ");
                }
                sql.append("(SELECT ");
                sql.append("A.FCOMPANYID AS COMPANYID, ");
                if (this.isShowCat) {
                    sql.append("C.FAssetCatID,");
                }
                sql.append(" ABS(" + changeFields[i] + ") AS CHANGEVALUE, ");
                if (this.isShowByPeriod) {
                    sql.append(" PERIOD2.FNumber PERIODINFO,");
                }
                sql.append("AlterModeH.").append(this.fName).append(" AS titleDetail,");
                sql.append("AlterModeH.FLongNumber AS titleNumber ");
                sql.append("FROM T_FA_FACHANGEBILL A ");
                sql.append("LEFT OUTER JOIN T_FA_FACHANGEBILLENTRY B ON A.FID = B.FCHANGEBILLID ");
                sql.append("LEFT OUTER JOIN T_BD_Period PERIOD2 ON A.FPeriodID = PERIOD2.FID ");
                sql.append("LEFT OUTER JOIN T_FA_AlterMode AlterModeH ON A.FCHANGEMODEID = AlterModeH.FID ");
                if (this.isShowCat) {
                    sql.append(" INNER JOIN T_FA_FABIZCARD C ON C.FID = B.FBizCardID ");
                }
                sql.append(" WHERE (PERIOD2.fperiodyear > " + this.startYear + " or (PERIOD2.fperiodyear = " + this.startYear + " and PERIOD2.fperiodnumber >= " + this.startNumber + "))");
                sql.append(" AND (PERIOD2.fperiodyear < " + this.endYear + " or (PERIOD2.fperiodyear = " + this.endYear + " and PERIOD2.fperiodnumber <= " + this.endNumber + "))");
                sql.append(" AND ").append(this.isShowNotAudit ? "A.FEffectedStatus" : "A.FCheckedStatus").append(" = 2");
                sql.append(" AND " + changeFields[i] + (type == 11 || type == 19 ? (i != 0 ? " <" : " >") : (i != 0 ? " >" : " <")) + " 0)");
            }
        }
        return sql.toString();
    }

    private String getCleanBillSql(int type) {
        String clearField = type == 2 || type == 3 ? "B.FClrOriginal" : (type == 7 || type == 8 ? "B.FClrAddupDep" : (type == 15 || type == 16 ? "B.FClrDecPrep" : ""));
        StringBuffer sql = new StringBuffer();
        if (clearField.trim().length() != 0) {
            sql.append("(SELECT ");
            sql.append("A.FCOMPANYID AS COMPANYID, ");
            if (this.isShowCat) {
                sql.append("C.FAssetCatID,");
            }
            sql.append("0 + " + clearField + " AS CHANGEVALUE, ");
            if (this.isShowByPeriod) {
                sql.append(" PERIOD3.FNumber PERIODINFO,");
            }
            sql.append("AlterModeH.").append(this.fName).append(" AS titleDetail,");
            sql.append("AlterModeH.FLongNumber AS titleNumber ");
            sql.append("FROM T_FA_CLEARBILL A ");
            sql.append("LEFT OUTER JOIN T_FA_CLEARBILLENTRY B ON A.FID = B.FENTRYID ");
            sql.append("LEFT OUTER JOIN T_FA_FABIZCARD C ON B.FBIZCARDID = C.FID ");
            sql.append("LEFT OUTER JOIN T_BD_Period PERIOD3 ON A.FPeriodID = PERIOD3.FID ");
            sql.append("LEFT OUTER JOIN T_FA_AlterMode AlterModeH ON A.FCLEARMODEID = AlterModeH.FID ");
            sql.append(" WHERE (PERIOD3.fperiodyear > " + this.startYear + " or (PERIOD3.fperiodyear = " + this.startYear + " and PERIOD3.fperiodnumber >= " + this.startNumber + "))");
            sql.append(" AND (PERIOD3.fperiodyear < " + this.endYear + " or (PERIOD3.fperiodyear = " + this.endYear + " and PERIOD3.fperiodnumber <= " + this.endNumber + "))");
            sql.append(" AND ").append(this.isShowNotAudit ? "A.FEffectedStatus" : "A.FCheckedStatus").append(" = 2");
            sql.append(" AND " + clearField + (type == 2 || type == 7 || type == 15 ? " < " : " > ") + " 0)");
        } else {
            String[] stringArray;
            if (type == 11) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "B.FClrAddupDep";
            } else if (type == 12) {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = "B.FClrOriginal";
            } else if (type == 19) {
                String[] stringArray4 = new String[2];
                stringArray4[0] = "B.FClrAddupDep";
                stringArray = stringArray4;
                stringArray4[1] = "B.FClrDecPrep";
            } else {
                String[] stringArray5 = new String[1];
                stringArray = stringArray5;
                stringArray5[0] = "B.FClrOriginal";
            }
            String[] clearFields = stringArray;
            for (int i = clearFields.length - 1; i >= 0; --i) {
                if (i < clearFields.length - 1) {
                    sql.append(" UNION ALL ");
                }
                sql.append("(SELECT ");
                sql.append("A.FCOMPANYID AS COMPANYID, ");
                if (this.isShowCat) {
                    sql.append("C.FAssetCatID,");
                }
                sql.append("0 + " + clearFields[i] + " AS CHANGEVALUE, ");
                if (this.isShowByPeriod) {
                    sql.append(" PERIOD3.FNumber PERIODINFO,");
                }
                sql.append("AlterModeH.").append(this.fName).append(" AS titleDetail,");
                sql.append("AlterModeH.FLongNumber AS titleNumber ");
                sql.append("FROM T_FA_CLEARBILL A ");
                sql.append("LEFT OUTER JOIN T_FA_CLEARBILLENTRY B ON A.FID = B.FENTRYID ");
                sql.append("LEFT OUTER JOIN T_FA_FABIZCARD C ON B.FBIZCARDID = C.FID ");
                sql.append("LEFT OUTER JOIN T_BD_Period PERIOD3 ON A.FPeriodID = PERIOD3.FID ");
                sql.append("LEFT OUTER JOIN T_FA_AlterMode AlterModeH ON A.FCLEARMODEID = AlterModeH.FID ");
                sql.append(" WHERE (PERIOD3.fperiodyear > " + this.startYear + " or (PERIOD3.fperiodyear = " + this.startYear + " and PERIOD3.fperiodnumber >= " + this.startNumber + "))");
                sql.append(" AND (PERIOD3.fperiodyear < " + this.endYear + " or (PERIOD3.fperiodyear = " + this.endYear + " and PERIOD3.fperiodnumber <= " + this.endNumber + "))");
                sql.append(" AND ").append(this.isShowNotAudit ? "A.FEffectedStatus" : "A.FCheckedStatus").append(" = 2");
                sql.append(" AND " + clearFields[i] + " != 0)");
            }
        }
        return sql.toString();
    }

    private boolean isExistSeq(int seq) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT SEQ FROM ");
        sql.append(this.tempTable);
        sql.append(" WHERE SEQ=").append(seq);
        IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
        try {
            return rowSet.next();
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
    }

    private void insertSeqData(int seq) throws BOSException {
        StringBuffer sql = new StringBuffer();
        if (this.isShowByPeriod) {
            sql.append("INSERT INTO ").append(this.tempTable).append("(FID,PERIODINFO,ISSUM,SEQ,SUMLEVEL) \n");
            sql.append(" SELECT newBOSID('00000000') FID ,t1.PERIODINFO ");
            sql.append(",2 ISSUM,").append(seq).append(" SEQ,").append(this.isVirCompany ? this.currCompanyInfo.getLevel() : 0).append(" SUMLEVEL FROM ( \n");
            sql.append(" SELECT PERIODINFO ");
            sql.append(" FROM (SELECT PERIODINFO ");
            sql.append(" FROM ").append(this.tempTable);
            sql.append(" GROUP BY PERIODINFO");
            sql.append(") t2 WHERE NOT EXISTS (");
            sql.append(" SELECT * FROM (SELECT PERIODINFO");
            sql.append(" FROM ").append(this.tempTable).append(" WHERE SEQ = ").append(seq);
            sql.append(" GROUP BY PERIODINFO ");
            sql.append(") t3 WHERE t3.PERIODINFO = t2.PERIODINFO ");
            sql.append(")) t1");
        } else {
            sql.append("INSERT INTO ").append(this.tempTable).append("(FID,ISSUM,SEQ,SUMLEVEL) \n");
            sql.append(" SELECT newBOSID('00000000') FID,2 ISSUM,").append(seq).append(" SEQ,");
            sql.append(this.isVirCompany ? this.currCompanyInfo.getLevel() : 0).append(" SUMLEVEL FROM ( \n");
            sql.append(" SELECT * FROM(");
            sql.append(" SELECT COUNT(fid) count ");
            sql.append(" FROM ").append(this.tempTable);
            sql.append(" WHERE SEQ = ").append(seq);
            sql.append(" ) tmp WHERE count = 0) T ");
        }
        DbUtil.execute((Context)this.ctx, (String)sql.toString());
    }

    private void insertVacantCompany() throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" INSERT INTO ").append(this.tempTable);
        sql.append(" SELECT newBOSID('00000000') AS FID,");
        if (this.isShowByPeriod) {
            sql.append(" T.PERIODINFO,");
        }
        sql.append(this.sumOption.getStrNameFields()).append(", ");
        sql.append("0 AS ISSUM, T.SEQ AS SEQ, 0 AS amount");
        if (this.isShowDetail) {
            sql.append(", T.titleDetail titleDetail, T.titleNumber titleNumber");
        }
        sql.append(", COMPANY.FLEVEL AS SumLevel, ");
        sql.append(this.sumOption.getStrLongNumberFields());
        sql.append(" FROM (SELECT DISTINCT ");
        if (this.isShowByPeriod) {
            sql.append(" PERIODINFO, ");
        }
        sql.append(this.sumOption.getStrNameFields()).append(", ");
        sql.append(this.sumOption.getStrLongNumberFields());
        sql.append(" ,SEQ ");
        if (this.isShowDetail) {
            sql.append(", titleDetail, titleNumber");
        }
        sql.append(" FROM ").append(this.tempTable).append(") T");
        sql.append(" INNER JOIN (SELECT * FROM T_ORG_Company WHERE FID IN (");
        sql.append(this.strCompanyInclude).append(" )) COMPANY ON 1=1");
        DbUtil.execute((Context)this.ctx, (String)FaLocalUtils.transformLocal((Context)this.ctx, (String)sql.toString()));
    }

    protected void deleteUnnecessaryData() throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("DELETE FROM ");
        sql.append(this.tempTable);
        sql.append(" WHERE ISSUM = 0");
        DbUtil.execute((Context)this.ctx, (String)sql.toString());
    }

    @Override
    protected boolean isCreateTempTable() {
        return true;
    }

    private String getNoCardCompanySelectSql() {
        StringBuffer sql = new StringBuffer();
        sql.append("0 AS ISSUM,tempTable.SEQ AS SEQ,0 AS amount");
        return sql.toString();
    }

    @Override
    public String insertVacantCompany(String tempTable, String select, String companyIds) {
        StringBuffer sql = new StringBuffer();
        StringBuffer numberField = new StringBuffer();
        StringBuffer nameField = new StringBuffer();
        StringBuffer nameFields = new StringBuffer();
        StringBuffer numberFields = new StringBuffer();
        List sumInfoList = this.sumOption.getSumInfoList();
        int n = sumInfoList.size();
        for (int i = 0; i < n; ++i) {
            LevelSumSqlInfo sumSqlInfo = (LevelSumSqlInfo)sumInfoList.get(i);
            if (sumInfoList.get(i) instanceof LevelSumCompany) {
                nameFields.append(",").append("orgArchitecture").append(".").append(sumSqlInfo.getNameFields());
                numberFields.append(",").append("orgArchitecture").append(".").append(sumSqlInfo.getLongNumberFields());
                continue;
            }
            nameField.append(",").append("tempTable.").append(sumSqlInfo.getNameField());
            numberField.append(",").append("tempTable.").append(sumSqlInfo.getLongNumberField());
        }
        sql.append("SELECT newBOSID('00000000') AS FId");
        if (this.isShowByPeriod) {
            sql.append(" ,tempTable.PERIODINFO ");
        }
        if (this.isShowCat) {
            sql.append(" ,tempTable.ASSETNAME ,tempTable.ASSETLongNumber");
        }
        sql.append(nameField).append(nameFields);
        sql.append(", ").append(select);
        if (this.isShowDetail) {
            sql.append(", tempTable.titleDetail, tempTable.titleNumber");
        }
        sql.append(", COMPANY.FLevel AS SUMLEVEL");
        sql.append(numberField).append(numberFields);
        sql.append(" FROM ");
        sql.append(tempTable).append(" AS tempTable,");
        sql.append(" T_ORG_Company COMPANY ");
        String tableName = this.getSumItemJoinSql("orgArchitecture");
        sql.append(" INNER JOIN ").append(tableName).append(" AS ").append("orgArchitecture");
        sql.append(" ON COMPANY.FID = ").append("orgArchitecture").append(".FID");
        sql.append(" WHERE COMPANY.FID IN (");
        sql.append(companyIds);
        sql.append(")");
        return "INSERT INTO " + tempTable + " " + sql.toString();
    }
}

