/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.fa.rpt.FaDBUtilConfig;
import com.kingdee.eas.fi.fa.rpt.FaDaoSqlObject;
import com.kingdee.eas.fi.fa.rpt.app.dao.FaDaoBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;

public class FaChangeList2Dao
extends FaDaoBase {
    private static final Logger logger = Logger.getLogger(FaChangeList2Dao.class);
    private boolean bNew;
    private boolean bChange;
    private boolean bPartclean;
    private boolean bCompleteclean;
    private String FACURCARDID;
    protected boolean isVirCompany = false;
    private static int seq = 0;

    @Override
    protected void initEvVar(EntityViewInfo ev) throws EASBizException, BOSException {
        Map cond = (Map)ev.get("customcond");
        Object company = cond.get("company");
        this.bNew = (Boolean)cond.get("new");
        this.bChange = (Boolean)cond.get("change");
        this.bPartclean = (Boolean)cond.get("partclean");
        this.bCompleteclean = (Boolean)cond.get("completeclean");
        this.FACURCARDID = cond.get("FACURCARDID") != null ? (String)cond.get("FACURCARDID") : null;
    }

    @Override
    protected void tableFieldConfig(FaDBUtilConfig cf) {
        cf.addFiledSize("bCostCenter", 800);
        cf.addFiledSize("CostCenter", 800);
        cf.addFiledSize("bUseDepartment", 800);
        cf.addFiledSize("UseDepartment", 800);
        cf.addFiledSize("bUsePerson", 800);
        cf.addFiledSize("UsePerson", 800);
        cf.addFiledSize("BORIGINUNIT", 800);
        cf.addFiledSize("ORIGINUNIT", 800);
        cf.addFiledSize("FNAME_L2", 800);
    }

    @Override
    protected void buildSql() throws BOSException {
        this.buildResultSql();
    }

    @Override
    protected void buildData() throws BOSException {
        String sql;
        this.addDataTempTable(this.getNewCardSql());
        if (this.bChange) {
            sql = "insert into " + this.tempTable + " SELECT * FROM (" + this.getChangeDetailSql() + ") tempTable";
            DbUtil.execute((Context)this.ctx, (String)FaLocalUtils.transformLocal((Context)this.ctx, (String)sql));
        }
        if (this.bPartclean || this.bCompleteclean) {
            sql = "insert into " + this.tempTable + " SELECT * FROM (" + this.getCleanCardSql() + ") tempTable";
            DbUtil.execute((Context)this.ctx, (String)FaLocalUtils.transformLocal((Context)this.ctx, (String)sql));
        }
        StringBuffer defSql = this.getPropertyValueFromNewCardSql();
        this.scTempTable = FaLocalUtils.addDataTempTable((Context)this.ctx, (String)defSql.toString());
        Connection con = null;
        Statement st = null;
        try {
            con = EJBFactory.getConnection((Context)this.ctx);
            st = con.createStatement();
            this.setCostCenter();
            st.addBatch(this.getUseDepartment(true, false));
            st.addBatch(this.getUseDepartment(false, false));
            st.addBatch(this.getUseDepartment(false, true));
            st.addBatch(this.getUpdateBakUseDSql());
            st.addBatch(this.getUsePerson(true, false));
            st.addBatch(this.getUsePerson(false, false));
            st.addBatch(this.getUsePerson(false, true));
            st.addBatch(this.getUpdateBakUsePSql());
            st.executeBatch();
        }
        catch (SQLException exc) {
            try {
                throw new BOSException((Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(st, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)st, (Connection)con);
    }

    private void setCostCenter() throws BOSException {
        FaDaoSqlObject tempCostDao = new FaDaoSqlObject();
        tempCostDao.setFrom(this.tempTable);
        tempCostDao.setSelect("fid,cardid,bakcardid,changetype");
        String sql = tempCostDao.getSql().toString();
        IRowSet row = DbUtil.executeQuery((Context)this.ctx, (String)sql);
        try {
            String updateSql = "UPDATE " + this.tempTable + " SET costCenter = ?, bCostCenter = ? WHERE fid = ?";
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
            while (row.next()) {
                String costCenterLName;
                String cardId;
                String id;
                int changeType = row.getInt("changetype");
                if (changeType == 1) {
                    id = row.getString("fid");
                    cardId = row.getString("cardid");
                    costCenterLName = FaLocalUtils.getCostCenterLNameByCardId((Context)this.ctx, (String)cardId, (int)3);
                    paramsList.add(new Object[]{costCenterLName, costCenterLName, id});
                    continue;
                }
                if (changeType == 2) {
                    id = row.getString("fid");
                    cardId = row.getString("cardid");
                    costCenterLName = FaLocalUtils.getCostCenterLNameByCardId((Context)this.ctx, (String)cardId, (int)2);
                    String bakCardId = row.getString("bakcardid");
                    String bCostCenterLName = FaLocalUtils.getCostCenterLNameByCardId((Context)this.ctx, (String)bakCardId, (int)3);
                    paramsList.add(new Object[]{costCenterLName, bCostCenterLName, id});
                    continue;
                }
                id = row.getString("fid");
                cardId = row.getString("cardid");
                costCenterLName = FaLocalUtils.getCostCenterLNameByCardId((Context)this.ctx, (String)cardId, (int)2);
                paramsList.add(new Object[]{costCenterLName, costCenterLName, id});
            }
            DbUtil.executeBatch((Context)this.ctx, (String)updateSql, paramsList);
        }
        catch (SQLException e) {
            throw new BOSException("Sql execute exception : " + sql, (Throwable)e);
        }
    }

    private String getCostCenter(boolean isBakCard, boolean isUpdateBak) throws BOSException {
        StringBuffer sql = new StringBuffer();
        FaDaoSqlObject costDao = new FaDaoSqlObject();
        String table = isBakCard || isUpdateBak ? "T_FA_FaBakCostCenter" : "T_FA_FaBizCostCenter";
        String column = isBakCard || isUpdateBak ? "FFaBakCardID" : "FFaBizCardID";
        sql.append("update ").append(this.tempTable).append(" SET ");
        sql.append(isUpdateBak ? "bCOSTCENTER" : "COSTCENTER").append(" = (");
        costDao.setSelect(" MAX(FSeq) AS maxSeq ");
        StringBuffer costFrom = new StringBuffer(table);
        costFrom.append(" cost INNER JOIN ").append(this.tempTable).append(" temp ON temp.").append(isUpdateBak ? "BakCardID" : "CardID").append(" = cost.").append(column);
        costDao.setFrom(costFrom.toString());
        IRowSet row = DbUtil.executeQuery((Context)this.ctx, (String)costDao.getSql());
        int n = 1;
        try {
            if (row != null && row.next()) {
                n = row.getInt("maxSeq");
            }
        }
        catch (SQLException e) {
            throw new BOSException("Sql execute exception : " + costDao.getSql(), (Throwable)e);
        }
        if (n > 10) {
            n = 10;
        }
        StringBuffer select = new StringBuffer();
        StringBuffer from = new StringBuffer();
        select.append("substring(account.FNumber ||'-'|| account." + this.fName + " || ' ' || TO_CHAR(facost.FApportionScale, 'NUMBER' ,2) || '%'|| ' ' || facost.FAsstActLName ");
        from.append(table + " facost ");
        from.append(" LEFT OUTER JOIN T_BD_AccountView AS account ON facost.FAccountViewID = account.FID ");
        for (int i = 2; i <= n; ++i) {
            select.append(" || ( case ISNULL(facost").append(i).append(".FAccountViewID ");
            select.append("  ,'null') when 'null' THEN '' ELSE ' ;  '||account").append(i).append(".FNumber ||'-'|| account").append(i).append("." + this.fName);
            select.append("   || ' ' || TO_CHAR(facost").append(i).append(".FApportionScale, 'NUMBER' , 2) || '%'|| ' ' ||facost").append(i).append(".FAsstActLName ");
            select.append(i == 10 ? "||' ; ...' END)" : " END) ");
            from.append(" LEFT OUTER JOIN ").append(table).append(" facost").append(i);
            from.append(" ON (facost").append(i).append(".FSeq = ").append(i).append(" AND facost.").append(column);
            from.append(" = facost").append(i).append(".").append(column).append(") ");
            from.append(" LEFT OUTER JOIN T_BD_AccountView").append(" AS account").append(i);
            from.append(" ON (facost").append(i).append(".FAccountViewID = account").append(i).append(".FID)");
        }
        select.append(",1,800)");
        costDao.setSelect(select.toString());
        costDao.setFrom(from.toString());
        StringBuffer where = new StringBuffer();
        where.append(this.tempTable).append(isUpdateBak ? ".BakCardId" : ".CardId ").append(" = facost.").append(column).append(" AND facost.FSeq = 1 ");
        costDao.setWhere(where.toString());
        sql.append(costDao.getSql()).append(")");
        sql.append(" WHERE CHANGETYPE ").append(isBakCard ? " = 1" : (isUpdateBak ? " = 2" : " != 1"));
        return sql.toString();
    }

    public static synchronized int seq() {
        if (seq == Short.MAX_VALUE) {
            seq = -1;
        }
        return ++seq;
    }

    private void buildResultSql() {
        StringBuffer sql = new StringBuffer();
        sql.append(this.getSelectResultSql());
        this.resultSql.setSelect(sql.toString());
        this.resultSql.setFrom(this.tempTable);
        this.resultSql.setSecondTable(this.scTempTable);
        this.resultSql.setOrder(this.sorter);
    }

    @Override
    public Map getResult() throws BOSException {
        this.buildSql();
        this.buildData();
        this.resultSql.setFrom(this.tempTable);
        this.resultSql.setSecondTable(this.scTempTable);
        this.dropTable(this.acctAsstTableName);
        this.acctAsstTableName = null;
        this.result.put("sumOption", this.sumOption);
        this.result.put("resultSql", this.resultSql);
        this.result.put("tempTableName", this.tempTable);
        this.result.put("pc", this.def.getPc());
        this.clearInnerTempTable();
        return this.result;
    }

    @Override
    protected String buildSorterSql(EntityViewInfo ev) {
        this.sorter = this.sorter == null || this.sorter.equals("") ? "CHANGEDATE" : this.sorter;
        this.sorter = this.sorter + ", BIZDATE, CHANGETYPE";
        return this.sorter;
    }

    private String getSelectResultSql() {
        StringBuffer sql = new StringBuffer();
        sql.append("FID, ");
        sql.append("bizNumber,");
        sql.append("voucherID,");
        sql.append("voucherNumber,");
        sql.append("CardID, ");
        sql.append("CHANGEDATE, ");
        sql.append("ALTERMETHOD_NAME, ");
        sql.append("bASSETNUMBER, ");
        sql.append("ASSETNUMBER, ");
        sql.append("bolderNUMBER, ");
        sql.append("olderNUMBER, ");
        sql.append("bGroupNumber, ");
        sql.append("GroupNumber, ");
        sql.append("bASSETNAME, ");
        sql.append("ASSETNAME, ");
        sql.append("bASSETCAT_NAME, ");
        sql.append("ASSETCAT_NAME, ");
        sql.append("bASSETAMT, ");
        sql.append("ASSETAMT, ");
        sql.append("bMEASUREUNIT_NAME, ");
        sql.append("MEASUREUNIT_NAME, ");
        sql.append("bUSESTATUS_NAME, ");
        sql.append("USESTATUS_NAME, ");
        sql.append("bECONOMICPURP_NAME, ");
        sql.append("ECONOMICPURP_NAME, ");
        sql.append("bSTORECITY_NAME, ");
        sql.append("STORECITY_NAME, ");
        sql.append("bUseDepartment, ");
        sql.append("UseDepartment, ");
        sql.append("bUsePerson, ");
        sql.append("UsePerson, ");
        sql.append("bCostCenter, ");
        sql.append("CostCenter, ");
        sql.append("bSPECS, ");
        sql.append("SPECS, ");
        sql.append("bPAREA, ");
        sql.append("PAREA, ");
        sql.append("bMFR, ");
        sql.append("MFR, ");
        sql.append("bLEVFRDATE, ");
        sql.append("LEVFRDATE, ");
        sql.append("bORIGINUNIT, ");
        sql.append("ORIGINUNIT, ");
        sql.append("PAPERNO, ");
        sql.append("bDEPRMETHOD_NAME, ");
        sql.append("DEPRMETHOD_NAME, ");
        sql.append("bMEASUREUNITWL_NAME, ");
        sql.append("MEASUREUNITWL_NAME, ");
        sql.append("bCURRENCY_NAME, ");
        sql.append("CURRENCY_NAME, ");
        sql.append("bEXRATE, ");
        sql.append("EXRATE, ");
        sql.append("bORIGINAMT, ");
        sql.append("ORIGINAMT, ");
        sql.append("bTAXORIGINAMT, ");
        sql.append("TAXORIGINAMT, ");
        sql.append("BInputTax, ");
        sql.append("InputTax, ");
        sql.append("bINPUTTAXRATE, ");
        sql.append("INPUTTAXRATE, ");
        sql.append("bISDEDUCT, ");
        sql.append("ISDEDUCT, ");
        sql.append("bADDONS, ");
        sql.append("ADDONS, ");
        sql.append("bTREATMENTINCOME, ");
        sql.append("TREATMENTINCOME, ");
        sql.append("bADDONFARE, ");
        sql.append("ADDONFARE, ");
        sql.append("bASSETVALUE, ");
        sql.append("ASSETVALUE, ");
        sql.append("ORIGINCHG, ");
        sql.append("bclrEvalValue,");
        sql.append("clrEvalValue,");
        sql.append("bBUYVALUE, ");
        sql.append("BUYVALUE, ");
        sql.append("bBUYACCUDEPR, ");
        sql.append("BUYACCUDEPR, ");
        sql.append("bDELIVERDATE, ");
        sql.append("DELIVERDATE, ");
        sql.append("STARTUSEDATE, ");
        sql.append("bUSEYEARS, ");
        sql.append("USEYEARS, ");
        sql.append("bUSETERMCOUNT, ");
        sql.append("USETERMCOUNT, ");
        sql.append("bDEPRTERMCOUNT, ");
        sql.append("DEPRTERMCOUNT, ");
        sql.append("bLEFTTERMCOUNT, ");
        sql.append("LEFTTERMCOUNT, ");
        sql.append("bACCUDEPR, ");
        sql.append("ACCUDEPR, ");
        sql.append("ACCUDEPRCHG,");
        sql.append("bACCUDEPRYEAR, ");
        sql.append("ACCUDEPRYEAR, ");
        sql.append("bNEATREMVALUE, ");
        sql.append("NEATREMVALUE, ");
        sql.append("bNEATLEFTRATE, ");
        sql.append("NEATLEFTRATE, ");
        sql.append("bNEATVALUE, ");
        sql.append("NEATVALUE, ");
        sql.append("bDECVALUE, ");
        sql.append("DECVALUE, ");
        sql.append("DECVALUECHG, ");
        sql.append("bNEATAMT, ");
        sql.append("NEATAMT, ");
        sql.append("COMPANY_NAME, ");
        sql.append("bDEPT_NAME, ");
        sql.append("DEPT_NAME, ");
        sql.append("bKEEPER_NAME, ");
        sql.append("KEEPER_NAME, ");
        sql.append("bREMARK, ");
        sql.append("REMARK, ");
        sql.append("CHANGETYPE, ");
        sql.append("bPREC, ");
        sql.append("PREC, ");
        sql.append("bEXRATEPREC, ");
        sql.append("EXRATEPREC, ");
        sql.append("bEvalAssetValue, ");
        sql.append("evalAssetValue, ");
        sql.append("bEvalReInAccountDate, ");
        sql.append("evalReInAccountDate, ");
        sql.append("bEvalDeprMethod_name, ");
        sql.append("evalDeprMethod_name, ");
        sql.append("bEvalUseTermCount, ");
        sql.append("evalUseTermCount, ");
        sql.append("bEvalMonthRate, ");
        sql.append("evalMonthRate, ");
        sql.append("bEvalTaxLeftPeriod, ");
        sql.append("evalTaxLeftPeriod, ");
        sql.append("bEvalNeatLeftRate, ");
        sql.append("evalNeatLeftRate, ");
        sql.append("bEvalDeprPeriodNum, ");
        sql.append("evalDeprPeriodNum, ");
        sql.append("bEvalRemValue, ");
        sql.append("evalRemValue, ");
        sql.append("bEvalAddDepr, ");
        sql.append("evalAddDepr, ");
        sql.append("bEvalDecValue, ");
        sql.append("evalDecValue, ");
        sql.append("bEvalYearDepr, ");
        sql.append("evalYearDepr, ");
        sql.append("bEvalNeatValue, ");
        sql.append("evalNeatValue, ");
        sql.append("evalMeasureUnit_name, ");
        sql.append("bEvalNeatAmt, ");
        sql.append("evalNeatAmt, ");
        sql.append("bACCOUNTASSET_DISPNAME,");
        sql.append("ACCOUNTASSET_DISPNAME,");
        sql.append("bACCOUNTDEVVALUE_DISPNAME,");
        sql.append("ACCOUNTDEVVALUE_DISPNAME,");
        sql.append("bACCOUNTACCUDEPR_DISPNAME,");
        sql.append("ACCOUNTACCUDEPR_DISPNAME,");
        sql.append("BASEPREC ");
        return sql.toString();
    }

    private String getCleanCardSql() {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT ");
        sql.append(" newBosId('00000000') AS FId  , ");
        sql.append(this.getDetailSelectSql());
        sql.append(" FROM (SELECT ");
        sql.append("A.CardID AS CardID, ");
        sql.append("A.CUR_CARD_ID AS  CUR_CARD_ID, ");
        sql.append("A.bizNumber as bizNumber,");
        sql.append("A.voucherID as VoucherID,");
        sql.append("A.voucherNumber as voucherNUmber,");
        sql.append("SUBSTRING(TO_CHAR(A.CHANGEDATE,'yyyy-mm-dd'),0,10) AS CHANGEDATE, ");
        sql.append("A.BizDate AS BIZDATE, ");
        sql.append("ALTERMETHOD." + this.fName + " AS ALTERMETHOD_NAME, ");
        sql.append("A.bASSETNUMBER AS bASSETNUMBER, ");
        sql.append("A.ASSETNUMBER AS ASSETNUMBER, ");
        sql.append("A.bolderNUMBER AS bolderNUMBER, ");
        sql.append("A.olderNUMBER AS olderNUMBER, ");
        sql.append("A.bGroupNumber AS bGroupNumber, ");
        sql.append("A.groupNumber AS GroupNumber, ");
        sql.append("A.bASSETNAME AS bASSETNAME, ");
        sql.append("A.ASSETNAME AS ASSETNAME, ");
        sql.append("ASSETCAT." + this.fName + " AS bASSETCAT_NAME, ");
        sql.append("ASSETCAT." + this.fName + " AS ASSETCAT_NAME, ");
        sql.append("A.bASSETAMT AS bASSETAMT, ");
        sql.append("A.ASSETAMT AS ASSETAMT, ");
        sql.append("MEASUREUNIT." + this.fName + " AS bMEASUREUNIT_NAME, ");
        sql.append("MEASUREUNIT." + this.fName + " AS MEASUREUNIT_NAME, ");
        sql.append("USESTATUS." + this.fName + " AS bUSESTATUS_NAME, ");
        sql.append("USESTATUS." + this.fName + " AS USESTATUS_NAME, ");
        sql.append("ECONOMICPURP." + this.fName + " AS bECONOMICPURP_NAME, ");
        sql.append("ECONOMICPURP." + this.fName + " AS ECONOMICPURP_NAME, ");
        sql.append("STORECITY." + this.fName + " AS bSTORECITY_NAME, ");
        sql.append("STORECITY." + this.fName + " AS STORECITY_NAME, ");
        sql.append("A.SPECS AS bUseDepartment, ");
        sql.append("A.SPECS AS UseDepartment, ");
        sql.append("A.SPECS AS bUsePerson, ");
        sql.append("A.SPECS AS UsePerson, ");
        sql.append("A.SPECS AS bCostCenter, ");
        sql.append("A.SPECS AS CostCenter, ");
        sql.append("A.bSPECS AS bSPECS, ");
        sql.append("A.SPECS AS SPECS, ");
        sql.append("A.bPAREA AS bPAREA, ");
        sql.append("A.PAREA AS PAREA, ");
        sql.append("A.bMFR AS bMFR, ");
        sql.append("A.MFR AS MFR, ");
        sql.append("A.bLEVFRDATE AS bLEVFRDATE, ");
        sql.append("A.LEVFRDATE AS LEVFRDATE, ");
        sql.append("A.bORIGINUNIT AS bORIGINUNIT, ");
        sql.append("A.ORIGINUNIT AS ORIGINUNIT, ");
        sql.append("A.PAPERNO AS PAPERNO, ");
        sql.append("DEPRMETHOD." + this.fName + " AS bDEPRMETHOD_NAME, ");
        sql.append("DEPRMETHOD." + this.fName + " AS DEPRMETHOD_NAME, ");
        sql.append("MEASUREUNITWL." + this.fName + " AS bMEASUREUNITWL_NAME, ");
        sql.append("MEASUREUNITWL." + this.fName + " AS MEASUREUNITWL_NAME, ");
        sql.append("A.bCurrencyID AS bCurrencyID, ");
        sql.append("CURRENCY." + this.fName + " AS bCURRENCY_NAME, ");
        sql.append("A.currencyID AS currencyID, ");
        sql.append("CURRENCY." + this.fName + " AS CURRENCY_NAME, ");
        sql.append("A.bEXRATE AS bEXRATE, ");
        sql.append("A.EXRATE AS EXRATE, ");
        sql.append("A.bORIGINAMT AS bORIGINAMT, ");
        sql.append("A.ORIGINAMT AS ORIGINAMT, ");
        sql.append("A.bTAXORIGINAMT AS bTAXORIGINAMT, ");
        sql.append("A.TAXORIGINAMT AS TAXORIGINAMT, ");
        sql.append("A.BInputTax AS BInputTax, ");
        sql.append("A.InputTax AS InputTax, ");
        sql.append("A.BInputTaxRate AS BInputTaxRate, ");
        sql.append("A.InputTaxRate AS InputTaxRate, ");
        sql.append("A.BIsDeduct AS BIsDeduct, ");
        sql.append("A.IsDeduct AS IsDeduct, ");
        sql.append("A.bADDONS AS bADDONS, ");
        sql.append("A.ADDONS AS ADDONS, ");
        sql.append("A.bTREATMENTINCOME AS bTREATMENTINCOME, ");
        sql.append("A.TREATMENTINCOME AS TREATMENTINCOME, ");
        sql.append("A.bADDONFARE AS bADDONFARE, ");
        sql.append("A.ADDONFARE AS ADDONFARE, ");
        sql.append("A.bASSETVALUE AS bASSETVALUE, ");
        sql.append("A.ASSETVALUE AS ASSETVALUE, ");
        sql.append("A.ORIGINCHG AS ORIGINCHG, ");
        sql.append("A.bclrEvalValue as bclrEvalValue,");
        sql.append("A.clrEvalValue as clrEvalValue,");
        sql.append("A.bBUYVALUE AS bBUYVALUE, ");
        sql.append("A.BUYVALUE AS BUYVALUE, ");
        sql.append("A.bBUYACCUDEPR AS bBUYACCUDEPR, ");
        sql.append("A.BUYACCUDEPR AS BUYACCUDEPR, ");
        sql.append("A.bDELIVERDATE AS bDELIVERDATE, ");
        sql.append("A.DELIVERDATE AS DELIVERDATE, ");
        sql.append("A.STARTUSEDATE AS STARTUSEDATE, ");
        sql.append("A.bUSEYEARS AS bUSEYEARS, ");
        sql.append("A.USEYEARS AS USEYEARS, ");
        sql.append("A.bUSETERMCOUNT AS bUSETERMCOUNT, ");
        sql.append("A.USETERMCOUNT AS USETERMCOUNT, ");
        sql.append("A.bDEPRTERMCOUNT AS bDEPRTERMCOUNT, ");
        sql.append("A.DEPRTERMCOUNT AS DEPRTERMCOUNT, ");
        sql.append("A.LEFTTERMCONT AS LEFTTERMCOUNT, ");
        sql.append("A.bLEFTTERMCONT AS bLEFTTERMCOUNT, ");
        sql.append("A.bACCUDEPR AS bACCUDEPR, ");
        sql.append("A.ACCUDEPR AS ACCUDEPR, ");
        sql.append("A.ACCUDEPRCHG AS ACCUDEPRCHG,");
        sql.append("A.bACCUDEPRYEAR AS bACCUDEPRYEAR, ");
        sql.append("A.ACCUDEPRYEAR AS ACCUDEPRYEAR, ");
        sql.append("A.bNEATREMVALUE AS bNEATREMVALUE, ");
        sql.append("A.NEATREMVALUE AS NEATREMVALUE, ");
        sql.append("A.bNEATLEFTRATE AS bNEATLEFTRATE, ");
        sql.append("A.NEATLEFTRATE AS NEATLEFTRATE, ");
        sql.append("A.bNEATVALUE AS bNEATVALUE, ");
        sql.append("A.NEATVALUE AS NEATVALUE, ");
        sql.append("A.bDECVALUE AS bDECVALUE, ");
        sql.append("A.DECVALUE AS DECVALUE, ");
        sql.append("A.DECVALUECHG AS DECVALUECHG, ");
        sql.append("A.bNEATAMT AS bNEATAMT, ");
        sql.append("A.NEATAMT AS NEATAMT, ");
        sql.append("DEPT." + this.fName + " AS bDEPT_NAME, ");
        sql.append("DEPT." + this.fName + " AS DEPT_NAME, ");
        sql.append("KEEPER." + this.fName + " AS bKEEPER_NAME, ");
        sql.append("KEEPER." + this.fName + " AS KEEPER_NAME, ");
        sql.append("A.bREMARK AS bREMARK, ");
        sql.append("A.REMARK AS REMARK, ");
        sql.append("A.bEvalAssetValue AS bEvalAssetValue,");
        sql.append("A.evalAssetValue AS evalAssetValue,");
        sql.append("A.bEvalReInAccountDate AS bEvalReInAccountDate,");
        sql.append("A.evalReInAccountDate AS evalReInAccountDate,");
        sql.append("EVALDEPRMETHOD." + this.fName + " AS bEVALDeprMethod_name, ");
        sql.append("EVALDEPRMETHOD." + this.fName + " AS evalDeprMethod_name, ");
        sql.append("A.bEvalUseTermCount AS bEvalUseTermCount,");
        sql.append("A.evalUseTermCount AS evalUseTermCount,");
        sql.append("A.bEvalMonthRate AS bEvalMonthRate,");
        sql.append("A.evalMonthRate AS evalMonthRate,");
        sql.append("A.bEvalTaxLeftPeriod AS bEvalTaxLeftPeriod,");
        sql.append("A.evalTaxLeftPeriod AS evalTaxLeftPeriod,");
        sql.append("A.bEvalNeatLeftRate AS bEvalNeatLeftRate,");
        sql.append("A.evalNeatLeftRate AS evalNeatLeftRate,");
        sql.append("A.bEvalDeprPeriodNum AS bEvalDeprPeriodNum,");
        sql.append("A.evalDeprPeriodNum AS evalDeprPeriodNum,");
        sql.append("A.bEvalRemValue AS bEvalRemValue,");
        sql.append("A.evalRemValue AS evalRemValue,");
        sql.append("A.bEvalAddDepr AS bEvalAddDepr,");
        sql.append("A.evalAddDepr AS evalAddDepr,");
        sql.append("A.bEvalDecValue AS bEvalDecValue,");
        sql.append("A.evalDecValue AS evalDecValue,");
        sql.append("A.bEvalYearDepr AS bEvalYearDepr,");
        sql.append("A.evalYearDepr AS evalYearDepr,");
        sql.append("A.bEvalNeatValue AS bEvalNeatValue,");
        sql.append("A.evalNeatValue AS evalNeatValue,");
        sql.append("EVALMEASUREUNIT." + this.fName + " AS evalMeasureUnit_name, ");
        sql.append("A.bEvalNeatAmt AS bEvalNeatAmt,");
        sql.append("A.evalNeatAmt AS evalNeatAmt,");
        sql.append("A.BAKCARDID AS BAKCARDID,");
        sql.append("A.CHANGETYPE AS CHANGETYPE,");
        sql.append("CURRENCY.FPrecision AS bPREC, ");
        sql.append("CURRENCY.FPrecision AS PREC, ");
        sql.append("A.FCompanyID AS FCompanyID,");
        sql.append(" ACCOUNTDECVALUE.FNumber bACCOUNTDECVALUEFNumber, ");
        sql.append(" ACCOUNTDECVALUE.FName_l2 bACCOUNTDECVALUEFName_l2, ");
        sql.append(" ACCOUNTDECVALUE.FNumber ACCOUNTDECVALUEFNumber, ");
        sql.append(" ACCOUNTDECVALUE.FName_l2 ACCOUNTDECVALUEFName_l2, ");
        sql.append(" ACCOUNTACCUDEPR.FNumber bACCOUNTACCUDEPRFNumber, ");
        sql.append(" ACCOUNTACCUDEPR.FName_l2 bACCOUNTACCUDEPRFName_l2,  ");
        sql.append(" ACCOUNTACCUDEPR.FNumber ACCOUNTACCUDEPRFNumber, ");
        sql.append(" ACCOUNTACCUDEPR.FName_l2 ACCOUNTACCUDEPRFName_l2, ");
        sql.append(" ACCOUNTASSET.FNumber bACCOUNTASSETFNumber, ");
        sql.append(" ACCOUNTASSET.FName_l2 bACCOUNTASSETFName_l2, ");
        sql.append(" ACCOUNTASSET.FNumber ACCOUNTASSETFNumber, ");
        sql.append(" ACCOUNTASSET.FName_l2 ACCOUNTASSETFName_l2   ");
        sql.append(",A.FPropertyValueID AS FPropertyValueID, ");
        sql.append("A.BFPropertyValueID AS BFPropertyValueID ");
        sql.append(" FROM (");
        sql.append(this.getCleanBillDetailSql());
        sql.append(") AS A ");
        sql.append(" LEFT OUTER JOIN T_FA_DepreciationMode AS EVALDEPRMETHOD ON A.evalDeprMethodID = EVALDEPRMETHOD.FID ");
        sql.append(" LEFT OUTER JOIN T_BD_MeasureUnit AS MEASUREUNITWL ON A.MeasureUnitWLID = MEASUREUNITWL.FID ");
        sql.append(" LEFT OUTER JOIN T_BD_AccountView AS ACCOUNTDECVALUE ON A.FAccountDecValueID = ACCOUNTDECVALUE.FID ");
        sql.append(" LEFT OUTER JOIN T_BD_AccountView AS ACCOUNTACCUDEPR ON A.FAccountAccuDeprID = ACCOUNTACCUDEPR.FID  ");
        sql.append(" LEFT OUTER JOIN T_BD_AccountView AS ACCOUNTASSET ON A.FAccountAssetID = ACCOUNTASSET.FID ");
        sql.append(" LEFT OUTER JOIN T_BD_Currency AS CURRENCY ON A.CurrencyID = CURRENCY.FID ");
        sql.append(" LEFT OUTER JOIN T_BD_Person AS KEEPER ON A.KeeperID = KEEPER.FID ");
        sql.append(" LEFT OUTER JOIN T_ORG_Admin AS DEPT ON A.DeptID = DEPT.FID ");
        sql.append(" LEFT OUTER JOIN V_FA_Cat AS ASSETCAT ON A.AssetCatID = ASSETCAT.FID ");
        sql.append(" LEFT OUTER JOIN T_BD_MeasureUnit AS MEASUREUNIT ON A.MeasureUnitID = MEASUREUNIT.FID ");
        sql.append(" LEFT JOIN T_BD_MeasureUnit AS EVALMEASUREUNIT ON A.evalMeasureUnitWL = EVALMEASUREUNIT.FID ");
        sql.append(" LEFT OUTER JOIN V_FA_AlterMode AS ALTERMETHOD ON A.CHANGEMODE = ALTERMETHOD.FID ");
        sql.append(" LEFT OUTER JOIN V_FA_UseStatus AS USESTATUS ON A.UseStatusID = USESTATUS.FID ");
        sql.append(" LEFT OUTER JOIN V_FA_FaEconomicPurp AS ECONOMICPURP ON A.EconomicPurpID = ECONOMICPURP.FID ");
        sql.append(" LEFT OUTER JOIN T_BD_Address AS STORECITY ON A.StoreCityID = STORECITY.FID ");
        sql.append(" LEFT OUTER JOIN T_FA_DepreciationMode AS DEPRMETHOD ON A.DeprMethodID = DEPRMETHOD.FID ");
        sql.append(" ) AS B ");
        sql.append(" LEFT OUTER JOIN T_ORG_Company AS COMPANY ON B.FCompanyID = COMPANY.FID ");
        sql.append(" LEFT OUTER JOIN T_BD_Currency AS BASECURRENCY ON COMPANY.FBaseCurrencyID = BASECURRENCY.FID ");
        sql.append(" LEFT OUTER JOIN T_BD_ExchangeTable AS EXTABLE on EXTABLE.fid = COMPANY.FBASEEXGTABLEID ");
        sql.append(" LEFT OUTER JOIN T_BD_ExchangeAux AS bEXAUX on bEXAUX.fexchangetableid = EXTABLE.fid AND bEXAUX.fsourcecurrencyid = B.bCurrencyID AND COMPANY.FbaseCurrencyID = bEXAUX.ftargetcurrencyid ");
        sql.append(" LEFT OUTER JOIN T_BD_ExchangeAux AS EXAUX on EXAUX.fexchangetableid = EXTABLE.fid AND EXAUX.fsourcecurrencyid = B.CurrencyID AND COMPANY.FbaseCurrencyID = EXAUX.ftargetcurrencyid ");
        return sql.toString();
    }

    private String getNewCardSql() {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT ");
        sql.append(" newBosId('00000000') AS FId  , ");
        if (this.isVirCompany) {
            sql.append(this.sumOption.getStrNameFields() + ", ");
        }
        sql.append(this.getDetailSelectSql());
        if (this.isVirCompany) {
            sql.append(", ").append(this.sumOption.getStrLongNumberFields());
        }
        sql.append(" FROM (SELECT ");
        if (this.filter != null && (this.filter.indexOf("asstActItem.fname_l2") != -1 || this.filter.indexOf("asstActType.fnumber") != -1 || this.filter.indexOf("useDepartment.fnumber") != -1)) {
            sql.append("DISTINCT ");
        }
        sql.append("A.CardID AS CardID, ");
        sql.append("A.CUR_CARD_ID AS  CUR_CARD_ID, ");
        sql.append("A.bizNumber as bizNumber,");
        sql.append("A.voucherID as VoucherID,");
        sql.append("A.voucherNumber as voucherNUmber,");
        sql.append("SUBSTRING(TO_CHAR(A.CHANGEDATE,'yyyy-mm-dd'),0,10) AS CHANGEDATE, ");
        sql.append("A.BizDate AS BIZDATE, ");
        sql.append("ALTERMETHOD." + this.fName + " AS ALTERMETHOD_NAME, ");
        sql.append("A.bASSETNUMBER AS bASSETNUMBER, ");
        sql.append("A.ASSETNUMBER AS ASSETNUMBER, ");
        sql.append("A.bolderNUMBER AS bolderNUMBER, ");
        sql.append("A.olderNUMBER AS olderNUMBER, ");
        sql.append("A.bGroupNumber AS bGroupNumber, ");
        sql.append("A.groupNumber AS GroupNumber, ");
        sql.append("A.bASSETNAME AS bASSETNAME, ");
        sql.append("A.ASSETNAME AS ASSETNAME, ");
        sql.append("ASSETCAT." + this.fName + " AS bASSETCAT_NAME, ");
        sql.append("ASSETCAT." + this.fName + " AS ASSETCAT_NAME, ");
        sql.append("A.bASSETAMT AS bASSETAMT, ");
        sql.append("A.ASSETAMT AS ASSETAMT, ");
        sql.append("MEASUREUNIT." + this.fName + " AS bMEASUREUNIT_NAME, ");
        sql.append("MEASUREUNIT." + this.fName + " AS MEASUREUNIT_NAME, ");
        sql.append("USESTATUS." + this.fName + " AS bUSESTATUS_NAME, ");
        sql.append("USESTATUS." + this.fName + " AS USESTATUS_NAME, ");
        sql.append("ECONOMICPURP." + this.fName + " AS bECONOMICPURP_NAME, ");
        sql.append("ECONOMICPURP." + this.fName + " AS ECONOMICPURP_NAME, ");
        sql.append("STORECITY." + this.fName + " AS bSTORECITY_NAME, ");
        sql.append("STORECITY." + this.fName + " AS STORECITY_NAME, ");
        sql.append("A.SPECS AS bUseDepartment, ");
        sql.append("A.SPECS AS UseDepartment, ");
        sql.append("A.SPECS AS bUsePerson, ");
        sql.append("A.SPECS AS UsePerson, ");
        sql.append("A.SPECS AS bCostCenter, ");
        sql.append("A.SPECS AS CostCenter, ");
        sql.append("A.bSPECS AS bSPECS, ");
        sql.append("A.SPECS AS SPECS, ");
        sql.append("A.bPAREA AS bPAREA, ");
        sql.append("A.PAREA AS PAREA, ");
        sql.append("A.bMFR AS bMFR, ");
        sql.append("A.MFR AS MFR, ");
        sql.append("A.bLEVFRDATE AS bLEVFRDATE, ");
        sql.append("A.LEVFRDATE AS LEVFRDATE, ");
        sql.append("A.bORIGINUNIT AS bORIGINUNIT, ");
        sql.append("A.ORIGINUNIT AS ORIGINUNIT, ");
        sql.append("A.PAPERNO AS PAPERNO, ");
        sql.append("DEPRMETHOD." + this.fName + " AS bDEPRMETHOD_NAME, ");
        sql.append("DEPRMETHOD." + this.fName + " AS DEPRMETHOD_NAME, ");
        sql.append("MEASUREUNITWL." + this.fName + " AS bMEASUREUNITWL_NAME, ");
        sql.append("MEASUREUNITWL." + this.fName + " AS MEASUREUNITWL_NAME, ");
        sql.append("A.bCurrencyID AS bCurrencyID, ");
        sql.append("CURRENCY." + this.fName + " AS bCURRENCY_NAME, ");
        sql.append("A.currencyID AS currencyID, ");
        sql.append("CURRENCY." + this.fName + " AS CURRENCY_NAME, ");
        sql.append("A.bEXRATE AS bEXRATE, ");
        sql.append("A.EXRATE AS EXRATE, ");
        sql.append("A.bORIGINAMT AS bORIGINAMT, ");
        sql.append("A.ORIGINAMT AS ORIGINAMT, ");
        sql.append("A.bTAXORIGINAMT AS bTAXORIGINAMT, ");
        sql.append("A.TAXORIGINAMT AS TAXORIGINAMT, ");
        sql.append("A.BInputTax AS BInputTax, ");
        sql.append("A.InputTax AS InputTax, ");
        sql.append("A.BInputTaxRate AS BInputTaxRate, ");
        sql.append("A.InputTaxRate AS InputTaxRate, ");
        sql.append("A.BIsDeduct AS BIsDeduct, ");
        sql.append("A.IsDeduct AS IsDeduct, ");
        sql.append("A.bADDONS AS bADDONS, ");
        sql.append("A.ADDONS AS ADDONS, ");
        sql.append("A.bTREATMENTINCOME AS bTREATMENTINCOME, ");
        sql.append("A.TREATMENTINCOME AS TREATMENTINCOME, ");
        sql.append("A.bADDONFARE AS bADDONFARE, ");
        sql.append("A.ADDONFARE AS ADDONFARE, ");
        sql.append("A.bASSETVALUE AS bASSETVALUE, ");
        sql.append("A.ASSETVALUE AS ASSETVALUE, ");
        sql.append("A.ORIGINCHG AS ORIGINCHG, ");
        sql.append("A.bclrEvalValue as bclrEvalValue,");
        sql.append("A.clrEvalValue as clrEvalValue,");
        sql.append("A.bBUYVALUE AS bBUYVALUE, ");
        sql.append("A.BUYVALUE AS BUYVALUE, ");
        sql.append("A.bBUYACCUDEPR AS bBUYACCUDEPR, ");
        sql.append("A.BUYACCUDEPR AS BUYACCUDEPR, ");
        sql.append("A.bDELIVERDATE AS bDELIVERDATE, ");
        sql.append("A.DELIVERDATE AS DELIVERDATE, ");
        sql.append("A.STARTUSEDATE AS STARTUSEDATE, ");
        sql.append("A.bUSEYEARS AS bUSEYEARS, ");
        sql.append("A.USEYEARS AS USEYEARS, ");
        sql.append("A.bUSETERMCOUNT AS bUSETERMCOUNT, ");
        sql.append("A.USETERMCOUNT AS USETERMCOUNT, ");
        sql.append("A.bDEPRTERMCOUNT AS bDEPRTERMCOUNT, ");
        sql.append("A.DEPRTERMCOUNT AS DEPRTERMCOUNT, ");
        sql.append("A.LEFTTERMCONT AS LEFTTERMCOUNT, ");
        sql.append("A.bLEFTTERMCONT AS bLEFTTERMCOUNT, ");
        sql.append("A.bACCUDEPR AS bACCUDEPR, ");
        sql.append("A.ACCUDEPR AS ACCUDEPR, ");
        sql.append("A.ACCUDEPRCHG AS ACCUDEPRCHG,");
        sql.append("A.bACCUDEPRYEAR AS bACCUDEPRYEAR, ");
        sql.append("A.ACCUDEPRYEAR AS ACCUDEPRYEAR, ");
        sql.append("A.bNEATREMVALUE AS bNEATREMVALUE, ");
        sql.append("A.NEATREMVALUE AS NEATREMVALUE, ");
        sql.append("A.bNEATLEFTRATE AS bNEATLEFTRATE, ");
        sql.append("A.NEATLEFTRATE AS NEATLEFTRATE, ");
        sql.append("A.bNEATVALUE AS bNEATVALUE, ");
        sql.append("A.NEATVALUE AS NEATVALUE, ");
        sql.append("A.bDECVALUE AS bDECVALUE, ");
        sql.append("A.DECVALUE AS DECVALUE, ");
        sql.append("A.DECVALUECHG AS DECVALUECHG, ");
        sql.append("A.bNEATAMT AS bNEATAMT, ");
        sql.append("A.NEATAMT AS NEATAMT, ");
        sql.append("DEPT." + this.fName + " AS bDEPT_NAME, ");
        sql.append("DEPT." + this.fName + " AS DEPT_NAME, ");
        sql.append("KEEPER." + this.fName + " AS bKEEPER_NAME, ");
        sql.append("KEEPER." + this.fName + " AS KEEPER_NAME, ");
        sql.append("A.bREMARK AS bREMARK, ");
        sql.append("A.REMARK AS REMARK, ");
        sql.append("A.bEvalAssetValue AS bEvalAssetValue,");
        sql.append("A.evalAssetValue AS evalAssetValue,");
        sql.append("A.bEvalReInAccountDate AS bEvalReInAccountDate,");
        sql.append("A.evalReInAccountDate AS evalReInAccountDate,");
        sql.append("EVALDEPRMETHOD." + this.fName + " AS bEVALDeprMethod_name, ");
        sql.append("EVALDEPRMETHOD." + this.fName + " AS evalDeprMethod_name, ");
        sql.append("A.bEvalUseTermCount AS bEvalUseTermCount,");
        sql.append("A.evalUseTermCount AS evalUseTermCount,");
        sql.append("A.bEvalMonthRate AS bEvalMonthRate,");
        sql.append("A.evalMonthRate AS evalMonthRate,");
        sql.append("A.bEvalTaxLeftPeriod AS bEvalTaxLeftPeriod,");
        sql.append("A.evalTaxLeftPeriod AS evalTaxLeftPeriod,");
        sql.append("A.bEvalNeatLeftRate AS bEvalNeatLeftRate,");
        sql.append("A.evalNeatLeftRate AS evalNeatLeftRate,");
        sql.append("A.bEvalDeprPeriodNum AS bEvalDeprPeriodNum,");
        sql.append("A.evalDeprPeriodNum AS evalDeprPeriodNum,");
        sql.append("A.bEvalRemValue AS bEvalRemValue,");
        sql.append("A.evalRemValue AS evalRemValue,");
        sql.append("A.bEvalAddDepr AS bEvalAddDepr,");
        sql.append("A.evalAddDepr AS evalAddDepr,");
        sql.append("A.bEvalDecValue AS bEvalDecValue,");
        sql.append("A.evalDecValue AS evalDecValue,");
        sql.append("A.bEvalYearDepr AS bEvalYearDepr,");
        sql.append("A.evalYearDepr AS evalYearDepr,");
        sql.append("A.bEvalNeatValue AS bEvalNeatValue,");
        sql.append("A.evalNeatValue AS evalNeatValue,");
        sql.append("EVALMEASUREUNIT." + this.fName + " AS evalMeasureUnit_name, ");
        sql.append("A.bEvalNeatAmt AS bEvalNeatAmt,");
        sql.append("A.evalNeatAmt AS evalNeatAmt,");
        sql.append("A.BAKCARDID AS BAKCARDID,");
        sql.append("A.CHANGETYPE AS CHANGETYPE,");
        sql.append("CURRENCY.FPrecision AS bPREC, ");
        sql.append("CURRENCY.FPrecision AS PREC, ");
        sql.append("A.FCompanyID AS FCompanyID,");
        sql.append(" ACCOUNTDECVALUE.FNumber bACCOUNTDECVALUEFNumber, ");
        sql.append(" ACCOUNTDECVALUE.FName_l2 bACCOUNTDECVALUEFName_l2, ");
        sql.append(" ACCOUNTDECVALUE.FNumber ACCOUNTDECVALUEFNumber, ");
        sql.append(" ACCOUNTDECVALUE.FName_l2 ACCOUNTDECVALUEFName_l2, ");
        sql.append(" ACCOUNTACCUDEPR.FNumber bACCOUNTACCUDEPRFNumber, ");
        sql.append(" ACCOUNTACCUDEPR.FName_l2 bACCOUNTACCUDEPRFName_l2,  ");
        sql.append(" ACCOUNTACCUDEPR.FNumber ACCOUNTACCUDEPRFNumber, ");
        sql.append(" ACCOUNTACCUDEPR.FName_l2 ACCOUNTACCUDEPRFName_l2, ");
        sql.append(" ACCOUNTASSET.FNumber bACCOUNTASSETFNumber, ");
        sql.append(" ACCOUNTASSET.FName_l2 bACCOUNTASSETFName_l2, ");
        sql.append(" ACCOUNTASSET.FNumber ACCOUNTASSETFNumber, ");
        sql.append(" ACCOUNTASSET.FName_l2 ACCOUNTASSETFName_l2   ");
        sql.append(",A.FPropertyValueID AS FPropertyValueID, ");
        sql.append("A.BFPropertyValueID AS BFPropertyValueID ");
        sql.append(" FROM (");
        sql.append(this.getNewCardDetailSql());
        sql.append(") AS A ");
        sql.append(" LEFT OUTER JOIN T_FA_DepreciationMode AS EVALDEPRMETHOD ON A.evalDeprMethodID = EVALDEPRMETHOD.FID ");
        sql.append(" LEFT OUTER JOIN T_BD_MeasureUnit AS MEASUREUNITWL ON A.MeasureUnitWLID = MEASUREUNITWL.FID ");
        sql.append(" LEFT OUTER JOIN T_BD_AccountView AS ACCOUNTDECVALUE ON A.FAccountDecValueID = ACCOUNTDECVALUE.FID ");
        sql.append(" LEFT OUTER JOIN T_BD_AccountView AS ACCOUNTACCUDEPR ON A.FAccountAccuDeprID = ACCOUNTACCUDEPR.FID  ");
        sql.append(" LEFT OUTER JOIN T_BD_AccountView AS ACCOUNTASSET ON A.FAccountAssetID = ACCOUNTASSET.FID ");
        sql.append(" LEFT OUTER JOIN T_BD_Currency AS CURRENCY ON A.CurrencyID = CURRENCY.FID ");
        sql.append(" LEFT OUTER JOIN T_BD_Person AS KEEPER ON A.KeeperID = KEEPER.FID ");
        sql.append(" LEFT OUTER JOIN T_ORG_Admin AS DEPT ON A.DeptID = DEPT.FID ");
        sql.append(" LEFT OUTER JOIN V_FA_Cat AS ASSETCAT ON A.AssetCatID = ASSETCAT.FID ");
        sql.append(" LEFT OUTER JOIN T_BD_MeasureUnit AS MEASUREUNIT ON A.MeasureUnitID = MEASUREUNIT.FID ");
        sql.append("LEFT JOIN T_BD_MeasureUnit AS EVALMEASUREUNIT ON A.evalMeasureUnitWL = EVALMEASUREUNIT.FID ");
        sql.append(" LEFT OUTER JOIN V_FA_AlterMode AS ALTERMETHOD ON A.CHANGEMODE = ALTERMETHOD.FID ");
        sql.append(" LEFT OUTER JOIN V_FA_UseStatus AS USESTATUS ON A.UseStatusID = USESTATUS.FID ");
        sql.append(" LEFT OUTER JOIN V_FA_FaEconomicPurp AS ECONOMICPURP ON A.EconomicPurpID = ECONOMICPURP.FID ");
        sql.append(" LEFT OUTER JOIN T_BD_Address AS STORECITY ON A.StoreCityID = STORECITY.FID ");
        sql.append(" LEFT OUTER JOIN T_FA_DepreciationMode AS DEPRMETHOD ON A.DeprMethodID = DEPRMETHOD.FID ");
        sql.append(" ) AS B ");
        sql.append("LEFT OUTER JOIN T_ORG_Company AS COMPANY ON B.FCompanyID = COMPANY.FID ");
        sql.append("LEFT OUTER JOIN T_BD_Currency AS BASECURRENCY ON COMPANY.FBaseCurrencyID = BASECURRENCY.FID ");
        sql.append("LEFT OUTER JOIN T_BD_ExchangeTable AS EXTABLE on EXTABLE.fid = COMPANY.FBASEEXGTABLEID ");
        sql.append("LEFT OUTER JOIN T_BD_ExchangeAux AS bEXAUX on bEXAUX.fexchangetableid = EXTABLE.fid AND bEXAUX.fsourcecurrencyid = B.bCurrencyID AND COMPANY.FbaseCurrencyID = bEXAUX.ftargetcurrencyid ");
        sql.append("LEFT OUTER JOIN T_BD_ExchangeAux AS EXAUX on EXAUX.fexchangetableid = EXTABLE.fid AND EXAUX.fsourcecurrencyid = B.CurrencyID AND COMPANY.FbaseCurrencyID = EXAUX.ftargetcurrencyid ");
        return sql.toString();
    }

    private String getChangeDetailSql() throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT ");
        sql.append(" newBosId('00000000') AS FId  , ");
        if (this.isVirCompany) {
            sql.append(this.sumOption.getStrNameFields() + ", ");
        }
        sql.append(this.getDetailSelectSql());
        if (this.isVirCompany) {
            sql.append(", ").append(this.sumOption.getStrLongNumberFields());
        }
        sql.append(" FROM (SELECT ");
        sql.append("A.CardID AS CardID, ");
        sql.append("A.CUR_CARD_ID AS  CUR_CARD_ID, ");
        sql.append("A.bizNumber as bizNumber,");
        sql.append("A.voucherID as VoucherID,");
        sql.append("A.voucherNumber as voucherNUmber,");
        sql.append("SUBSTRING(TO_CHAR(A.CHANGEDATE,'yyyy-mm-dd'),0,10) AS CHANGEDATE, ");
        sql.append("A.BizDate AS BIZDATE, ");
        sql.append("ALTERMETHOD." + this.fName + " AS ALTERMETHOD_NAME, ");
        sql.append("A.bASSETNUMBER AS bASSETNUMBER, ");
        sql.append("A.ASSETNUMBER AS ASSETNUMBER, ");
        sql.append("A.bolderNUMBER AS bolderNUMBER, ");
        sql.append("A.olderNUMBER AS olderNUMBER, ");
        sql.append("A.bGroupNumber AS bGroupNumber, ");
        sql.append("A.groupNumber AS GroupNumber, ");
        sql.append("A.bASSETNAME AS bASSETNAME, ");
        sql.append("A.ASSETNAME AS ASSETNAME, ");
        sql.append("bASSETCAT." + this.fName + " AS bASSETCAT_NAME, ");
        sql.append("ASSETCAT." + this.fName + " AS ASSETCAT_NAME, ");
        sql.append("A.bASSETAMT AS bASSETAMT, ");
        sql.append("A.ASSETAMT AS ASSETAMT, ");
        sql.append("bMEASUREUNIT." + this.fName + " AS bMEASUREUNIT_NAME, ");
        sql.append("MEASUREUNIT." + this.fName + " AS MEASUREUNIT_NAME, ");
        sql.append("bUSESTATUS." + this.fName + " AS bUSESTATUS_NAME, ");
        sql.append("USESTATUS." + this.fName + " AS USESTATUS_NAME, ");
        sql.append("bECONOMICPURP." + this.fName + " AS bECONOMICPURP_NAME, ");
        sql.append("ECONOMICPURP." + this.fName + " AS ECONOMICPURP_NAME, ");
        sql.append("bSTORECITY." + this.fName + " AS bSTORECITY_NAME, ");
        sql.append("STORECITY." + this.fName + " AS STORECITY_NAME, ");
        sql.append("A.SPECS AS bUseDepartment, ");
        sql.append("A.SPECS AS UseDepartment, ");
        sql.append("A.SPECS AS bUsePerson, ");
        sql.append("A.SPECS AS UsePerson, ");
        sql.append("A.SPECS AS bCostCenter, ");
        sql.append("A.SPECS AS CostCenter, ");
        sql.append("A.bSPECS AS bSPECS, ");
        sql.append("A.SPECS AS SPECS, ");
        sql.append("A.bPAREA AS bPAREA, ");
        sql.append("A.PAREA AS PAREA, ");
        sql.append("A.bMFR AS bMFR, ");
        sql.append("A.MFR AS MFR, ");
        sql.append("A.bLEVFRDATE AS bLEVFRDATE, ");
        sql.append("A.LEVFRDATE AS LEVFRDATE, ");
        sql.append("A.bORIGINUNIT AS bORIGINUNIT, ");
        sql.append("A.ORIGINUNIT AS ORIGINUNIT, ");
        sql.append("A.PAPERNO AS PAPERNO, ");
        sql.append("bDEPRMETHOD." + this.fName + " AS bDEPRMETHOD_NAME, ");
        sql.append("DEPRMETHOD." + this.fName + " AS DEPRMETHOD_NAME, ");
        sql.append("bMEASUREUNITWL." + this.fName + " AS bMEASUREUNITWL_NAME, ");
        sql.append("MEASUREUNITWL." + this.fName + " AS MEASUREUNITWL_NAME, ");
        sql.append("A.bCurrencyID AS bCurrencyID, ");
        sql.append("bCURRENCY." + this.fName + " AS bCURRENCY_NAME, ");
        sql.append("A.currencyID AS currencyID, ");
        sql.append("CURRENCY." + this.fName + " AS CURRENCY_NAME, ");
        sql.append("A.bEXRATE AS bEXRATE, ");
        sql.append("A.EXRATE AS EXRATE, ");
        sql.append("A.bORIGINAMT AS bORIGINAMT, ");
        sql.append("A.ORIGINAMT AS ORIGINAMT, ");
        sql.append("A.bTAXORIGINAMT AS bTAXORIGINAMT, ");
        sql.append("A.TAXORIGINAMT AS TAXORIGINAMT, ");
        sql.append("A.BInputTax AS BInputTax, ");
        sql.append("A.InputTax AS InputTax, ");
        sql.append("A.BInputTaxRate AS BInputTaxRate, ");
        sql.append("A.InputTaxRate AS InputTaxRate, ");
        sql.append("A.BIsDeduct AS BIsDeduct, ");
        sql.append("A.IsDeduct AS IsDeduct, ");
        sql.append("A.bADDONS AS bADDONS, ");
        sql.append("A.ADDONS AS ADDONS, ");
        sql.append("A.bTREATMENTINCOME AS bTREATMENTINCOME, ");
        sql.append("A.TREATMENTINCOME AS TREATMENTINCOME, ");
        sql.append("A.bADDONFARE AS bADDONFARE, ");
        sql.append("A.ADDONFARE AS ADDONFARE, ");
        sql.append("A.bASSETVALUE AS bASSETVALUE, ");
        sql.append("A.ASSETVALUE AS ASSETVALUE, ");
        sql.append("A.ORIGINCHG AS ORIGINCHG, ");
        sql.append("A.bclrEvalValue as bclrEvalValue,");
        sql.append("A.clrEvalValue as clrEvalValue,");
        sql.append("A.bBUYVALUE AS bBUYVALUE, ");
        sql.append("A.BUYVALUE AS BUYVALUE, ");
        sql.append("A.bBUYACCUDEPR AS bBUYACCUDEPR, ");
        sql.append("A.BUYACCUDEPR AS BUYACCUDEPR, ");
        sql.append("A.bDELIVERDATE AS bDELIVERDATE, ");
        sql.append("A.DELIVERDATE AS DELIVERDATE, ");
        sql.append("A.STARTUSEDATE AS STARTUSEDATE, ");
        sql.append("A.bUSEYEARS AS bUSEYEARS, ");
        sql.append("A.USEYEARS AS USEYEARS, ");
        sql.append("A.bUSETERMCOUNT AS bUSETERMCOUNT, ");
        sql.append("A.USETERMCOUNT AS USETERMCOUNT, ");
        sql.append("A.bDEPRTERMCOUNT AS bDEPRTERMCOUNT, ");
        sql.append("A.DEPRTERMCOUNT AS DEPRTERMCOUNT, ");
        sql.append("A.LEFTTERMCONT AS LEFTTERMCOUNT, ");
        sql.append("A.bLEFTTERMCONT AS bLEFTTERMCOUNT, ");
        sql.append("A.bACCUDEPR AS bACCUDEPR, ");
        sql.append("A.ACCUDEPR AS ACCUDEPR, ");
        sql.append("A.ACCUDEPRCHG AS ACCUDEPRCHG,");
        sql.append("A.bACCUDEPRYEAR AS bACCUDEPRYEAR, ");
        sql.append("A.ACCUDEPRYEAR AS ACCUDEPRYEAR, ");
        sql.append("A.bNEATREMVALUE AS bNEATREMVALUE, ");
        sql.append("A.NEATREMVALUE AS NEATREMVALUE, ");
        sql.append("A.bNEATLEFTRATE AS bNEATLEFTRATE, ");
        sql.append("A.NEATLEFTRATE AS NEATLEFTRATE, ");
        sql.append("A.bNEATVALUE AS bNEATVALUE, ");
        sql.append("A.NEATVALUE AS NEATVALUE, ");
        sql.append("A.bDECVALUE AS bDECVALUE, ");
        sql.append("A.DECVALUE AS DECVALUE, ");
        sql.append("A.DECVALUECHG AS DECVALUECHG, ");
        sql.append("A.bNEATAMT AS bNEATAMT, ");
        sql.append("A.NEATAMT AS NEATAMT, ");
        sql.append("bDEPT." + this.fName + " AS bDEPT_NAME, ");
        sql.append("DEPT." + this.fName + " AS DEPT_NAME, ");
        sql.append("bKEEPER." + this.fName + " AS bKEEPER_NAME, ");
        sql.append("KEEPER." + this.fName + " AS KEEPER_NAME, ");
        sql.append("A.bREMARK AS bREMARK, ");
        sql.append("A.REMARK AS REMARK, ");
        sql.append("A.bEvalAssetValue AS bEvalAssetValue,");
        sql.append("A.evalAssetValue AS evalAssetValue,");
        sql.append("A.bEvalReInAccountDate AS bEvalReInAccountDate,");
        sql.append("A.evalReInAccountDate AS evalReInAccountDate,");
        sql.append("bEVALDEPRMETHOD." + this.fName + " AS bEVALDeprMethod_name, ");
        sql.append("EVALDEPRMETHOD." + this.fName + " AS evalDeprMethod_name, ");
        sql.append("A.bEvalUseTermCount AS bEvalUseTermCount,");
        sql.append("A.evalUseTermCount AS evalUseTermCount,");
        sql.append("A.bEvalMonthRate AS bEvalMonthRate,");
        sql.append("A.evalMonthRate AS evalMonthRate,");
        sql.append("A.bEvalTaxLeftPeriod AS bEvalTaxLeftPeriod,");
        sql.append("A.evalTaxLeftPeriod AS evalTaxLeftPeriod,");
        sql.append("A.bEvalNeatLeftRate AS bEvalNeatLeftRate,");
        sql.append("A.evalNeatLeftRate AS evalNeatLeftRate,");
        sql.append("A.bEvalDeprPeriodNum AS bEvalDeprPeriodNum,");
        sql.append("A.evalDeprPeriodNum AS evalDeprPeriodNum,");
        sql.append("A.bEvalRemValue AS bEvalRemValue,");
        sql.append("A.evalRemValue AS evalRemValue,");
        sql.append("A.bEvalAddDepr AS bEvalAddDepr,");
        sql.append("A.evalAddDepr AS evalAddDepr,");
        sql.append("A.bEvalDecValue AS bEvalDecValue,");
        sql.append("A.evalDecValue AS evalDecValue,");
        sql.append("A.bEvalYearDepr AS bEvalYearDepr,");
        sql.append("A.evalYearDepr AS evalYearDepr,");
        sql.append("A.bEvalNeatValue AS bEvalNeatValue,");
        sql.append("A.evalNeatValue AS evalNeatValue,");
        sql.append("EVALMEASUREUNIT." + this.fName + " AS evalMeasureUnit_name, ");
        sql.append("A.bEvalNeatAmt AS bEvalNeatAmt,");
        sql.append("A.evalNeatAmt AS evalNeatAmt,");
        sql.append("A.BAKCARDID AS BAKCARDID,");
        sql.append("A.CHANGETYPE AS CHANGETYPE,");
        sql.append("bCURRENCY.FPrecision AS bPREC, ");
        sql.append("CURRENCY.FPrecision AS PREC, ");
        sql.append("A.FCompanyID AS FCompanyID,");
        sql.append(" bACCOUNTDECVALUE.FNumber bACCOUNTDECVALUEFNumber, ");
        sql.append(" bACCOUNTDECVALUE.FName_l2 bACCOUNTDECVALUEFName_l2, ");
        sql.append(" ACCOUNTDECVALUE.FNumber ACCOUNTDECVALUEFNumber, ");
        sql.append(" ACCOUNTDECVALUE.FName_l2 ACCOUNTDECVALUEFName_l2, ");
        sql.append(" bACCOUNTACCUDEPR.FNumber bACCOUNTACCUDEPRFNumber, ");
        sql.append(" bACCOUNTACCUDEPR.FName_l2 bACCOUNTACCUDEPRFName_l2,  ");
        sql.append(" ACCOUNTACCUDEPR.FNumber ACCOUNTACCUDEPRFNumber, ");
        sql.append(" ACCOUNTACCUDEPR.FName_l2 ACCOUNTACCUDEPRFName_l2, ");
        sql.append(" bACCOUNTASSET.FNumber bACCOUNTASSETFNumber, ");
        sql.append(" bACCOUNTASSET.FName_l2 bACCOUNTASSETFName_l2, ");
        sql.append(" ACCOUNTASSET.FNumber ACCOUNTASSETFNumber, ");
        sql.append(" ACCOUNTASSET.FName_l2 ACCOUNTASSETFName_l2   ");
        sql.append(",A.FPropertyValueID AS FPropertyValueID, ");
        sql.append("A.BFPropertyValueID AS BFPropertyValueID ");
        String innerTempSql = this.getChangeBillDetailSql();
        sql.append(" FROM (" + innerTempSql + ") as A ");
        sql.append(" LEFT OUTER JOIN T_FA_DepreciationMode AS EVALDEPRMETHOD ON A.evalDeprMethodID = EVALDEPRMETHOD.FID ");
        sql.append(" LEFT OUTER JOIN T_FA_DepreciationMode AS bEVALDEPRMETHOD ON A.bevalDeprMethodID = bEVALDEPRMETHOD.FID ");
        sql.append(" LEFT OUTER JOIN T_BD_MeasureUnit AS MEASUREUNITWL ON A.MeasureUnitWLID = MEASUREUNITWL.FID ");
        sql.append(" LEFT OUTER JOIN T_BD_MeasureUnit AS bMEASUREUNITWL ON A.bMeasureUnitWLID = bMEASUREUNITWL.FID ");
        sql.append(" LEFT OUTER JOIN T_BD_AccountView AS ACCOUNTDECVALUE ON A.FAccountDecValueID = ACCOUNTDECVALUE.FID ");
        sql.append(" LEFT OUTER JOIN T_BD_AccountView AS bACCOUNTDECVALUE ON A.bFAccountDecValueID = bACCOUNTDECVALUE.FID ");
        sql.append(" LEFT OUTER JOIN T_BD_AccountView AS ACCOUNTACCUDEPR ON A.FAccountAccuDeprID = ACCOUNTACCUDEPR.FID  ");
        sql.append(" LEFT OUTER JOIN T_BD_AccountView AS bACCOUNTACCUDEPR ON A.bFAccountAccuDeprID = bACCOUNTACCUDEPR.FID ");
        sql.append(" LEFT OUTER JOIN T_BD_AccountView AS ACCOUNTASSET ON A.FAccountAssetID = ACCOUNTASSET.FID ");
        sql.append(" LEFT OUTER JOIN T_BD_AccountView AS bACCOUNTASSET ON A.bFAccountAssetID = bACCOUNTASSET.FID ");
        sql.append(" LEFT OUTER JOIN T_BD_Currency AS CURRENCY ON A.CurrencyID = CURRENCY.FID ");
        sql.append(" LEFT OUTER JOIN T_BD_Currency AS bCURRENCY ON A.bCurrencyID = bCURRENCY.FID ");
        sql.append(" LEFT OUTER JOIN T_BD_Person AS KEEPER ON A.KeeperID = KEEPER.FID ");
        sql.append(" LEFT OUTER JOIN T_BD_Person AS bKEEPER ON A.bKeeperID = bKEEPER.FID ");
        sql.append(" LEFT OUTER JOIN T_ORG_Admin AS DEPT ON A.DeptID = DEPT.FID ");
        sql.append(" LEFT OUTER JOIN T_ORG_Admin AS bDEPT ON A.bDeptID = bDEPT.FID ");
        sql.append(" LEFT OUTER JOIN V_FA_Cat AS ASSETCAT ON A.AssetCatID = ASSETCAT.FID ");
        sql.append(" LEFT OUTER JOIN V_FA_Cat AS bASSETCAT ON A.bAssetCatID = bASSETCAT.FID ");
        sql.append(" LEFT OUTER JOIN T_BD_MeasureUnit AS MEASUREUNIT ON A.MeasureUnitID = MEASUREUNIT.FID ");
        sql.append(" LEFT OUTER JOIN T_BD_MeasureUnit AS bMEASUREUNIT ON A.bMeasureUnitID = bMEASUREUNIT.FID ");
        sql.append(" LEFT JOIN T_BD_MeasureUnit AS EVALMEASUREUNIT ON A.evalMeasureUnitWL = EVALMEASUREUNIT.FID ");
        sql.append(" LEFT OUTER JOIN V_FA_AlterMode AS ALTERMETHOD ON A.CHANGEMODE = ALTERMETHOD.FID ");
        sql.append(" LEFT OUTER JOIN V_FA_UseStatus AS USESTATUS ON A.UseStatusID = USESTATUS.FID ");
        sql.append(" LEFT OUTER JOIN V_FA_UseStatus AS bUSESTATUS ON A.bUseStatusID = bUSESTATUS.FID ");
        sql.append(" LEFT OUTER JOIN V_FA_FaEconomicPurp AS ECONOMICPURP ON A.EconomicPurpID = ECONOMICPURP.FID ");
        sql.append(" LEFT OUTER JOIN V_FA_FaEconomicPurp AS bECONOMICPURP ON A.bEconomicPurpID = bECONOMICPURP.FID ");
        sql.append(" LEFT OUTER JOIN T_BD_Address AS STORECITY ON A.StoreCityID = STORECITY.FID ");
        sql.append(" LEFT OUTER JOIN T_BD_Address AS bSTORECITY ON A.bStoreCityID = bSTORECITY.FID ");
        sql.append(" LEFT OUTER JOIN T_FA_DepreciationMode AS DEPRMETHOD ON A.DeprMethodID = DEPRMETHOD.FID ");
        sql.append(" LEFT OUTER JOIN T_FA_DepreciationMode AS bDEPRMETHOD ON A.bDeprMethodID = bDEPRMETHOD.FID ");
        sql.append(" ) AS B ");
        sql.append("LEFT OUTER JOIN T_ORG_Company AS COMPANY ON B.FCompanyID = COMPANY.FID ");
        sql.append("LEFT OUTER JOIN T_BD_Currency AS BASECURRENCY ON COMPANY.FBaseCurrencyID = BASECURRENCY.FID ");
        sql.append("LEFT OUTER JOIN T_BD_ExchangeTable AS EXTABLE on EXTABLE.fid = COMPANY.FBASEEXGTABLEID ");
        sql.append("LEFT OUTER JOIN T_BD_ExchangeAux AS bEXAUX on bEXAUX.fexchangetableid = EXTABLE.fid AND bEXAUX.fsourcecurrencyid = B.bCurrencyID AND COMPANY.FbaseCurrencyID = bEXAUX.ftargetcurrencyid ");
        sql.append("LEFT OUTER JOIN T_BD_ExchangeAux AS EXAUX on EXAUX.fexchangetableid = EXTABLE.fid AND EXAUX.fsourcecurrencyid = B.CurrencyID AND COMPANY.FbaseCurrencyID = EXAUX.ftargetcurrencyid ");
        return sql.toString();
    }

    private String getDetailSelectSql() {
        StringBuffer sqlSelect = new StringBuffer();
        sqlSelect.append("B.CardID AS CardID, ");
        sqlSelect.append("B.bizNumber AS bizNumber,");
        sqlSelect.append("B.voucherID AS voucherID,");
        sqlSelect.append("B.voucherNumber AS voucherNumber,");
        sqlSelect.append("B.CHANGEDATE AS CHANGEDATE, ");
        sqlSelect.append("CASE WHEN B.BizDate IS NULL THEN GETDATE() ELSE B.BizDate END AS BIZDATE, ");
        sqlSelect.append("B.ALTERMETHOD_NAME AS ALTERMETHOD_NAME, ");
        sqlSelect.append("B.bASSETNUMBER AS bASSETNUMBER, ");
        sqlSelect.append("B.ASSETNUMBER AS ASSETNUMBER, ");
        sqlSelect.append("B.bOlderNumber AS bOlderNumber, ");
        sqlSelect.append("B.OlderNumber AS OlderNumber, ");
        sqlSelect.append("B.bgroupNumber AS bGroupNumber, ");
        sqlSelect.append("B.groupNumber AS groupNumber, ");
        sqlSelect.append("B.bASSETNAME AS bASSETNAME, ");
        sqlSelect.append("B.ASSETNAME AS ASSETNAME, ");
        sqlSelect.append("B.bASSETCAT_NAME AS bASSETCAT_NAME, ");
        sqlSelect.append("B.ASSETCAT_NAME AS ASSETCAT_NAME, ");
        sqlSelect.append("B.bASSETAMT AS bASSETAMT, ");
        sqlSelect.append("B.ASSETAMT AS ASSETAMT, ");
        sqlSelect.append("B.bMEASUREUNIT_NAME AS bMEASUREUNIT_NAME, ");
        sqlSelect.append("B.MEASUREUNIT_NAME AS MEASUREUNIT_NAME, ");
        sqlSelect.append("B.bUSESTATUS_NAME AS bUSESTATUS_NAME, ");
        sqlSelect.append("B.USESTATUS_NAME AS USESTATUS_NAME, ");
        sqlSelect.append("B.bECONOMICPURP_NAME AS bECONOMICPURP_NAME, ");
        sqlSelect.append("B.ECONOMICPURP_NAME AS ECONOMICPURP_NAME,");
        sqlSelect.append("B.bSTORECITY_NAME AS bSTORECITY_NAME,");
        sqlSelect.append("B.STORECITY_NAME AS STORECITY_NAME, ");
        sqlSelect.append("B.bUseDepartment AS bUseDepartment, ");
        sqlSelect.append("B.UseDepartment AS UseDepartment, ");
        sqlSelect.append("B.bUsePerson AS bUsePerson, ");
        sqlSelect.append("B.UsePerson AS UsePerson, ");
        sqlSelect.append("B.bCostCenter AS bCostCenter, ");
        sqlSelect.append("B.SPECS AS CostCenter, ");
        sqlSelect.append("B.bSPECS AS bSPECS, ");
        sqlSelect.append("B.SPECS AS SPECS, ");
        sqlSelect.append("B.bPAREA AS bPAREA, ");
        sqlSelect.append("B.PAREA AS PAREA, ");
        sqlSelect.append("B.bMFR AS bMFR, ");
        sqlSelect.append("B.MFR AS MFR, ");
        sqlSelect.append("B.bLEVFRDATE AS bLEVFRDATE, ");
        sqlSelect.append("B.LEVFRDATE AS LEVFRDATE, ");
        sqlSelect.append("B.bORIGINUNIT AS bORIGINUNIT, ");
        sqlSelect.append("B.ORIGINUNIT AS ORIGINUNIT, ");
        sqlSelect.append("B.PAPERNO AS PAPERNO, ");
        sqlSelect.append("B.bDEPRMETHOD_NAME AS bDEPRMETHOD_NAME, ");
        sqlSelect.append("B.DEPRMETHOD_NAME AS DEPRMETHOD_NAME, ");
        sqlSelect.append("B.bMEASUREUNITWL_NAME AS bMEASUREUNITWL_NAME, ");
        sqlSelect.append("B.MEASUREUNITWL_NAME AS MEASUREUNITWL_NAME, ");
        sqlSelect.append("B.bCURRENCY_NAME AS bCURRENCY_NAME, ");
        sqlSelect.append("B.CURRENCY_NAME AS CURRENCY_NAME, ");
        sqlSelect.append("B.bEXRATE AS bEXRATE, ");
        sqlSelect.append("B.EXRATE AS EXRATE, ");
        sqlSelect.append("B.bORIGINAMT AS bORIGINAMT, ");
        sqlSelect.append("B.ORIGINAMT AS ORIGINAMT, ");
        sqlSelect.append("B.bTAXORIGINAMT AS bTAXORIGINAMT, ");
        sqlSelect.append("B.TAXORIGINAMT AS TAXORIGINAMT, ");
        sqlSelect.append("B.BInputTax AS BInputTax, ");
        sqlSelect.append("B.InputTax AS InputTax, ");
        sqlSelect.append("B.BInputTaxRate AS BInputTaxRate, ");
        sqlSelect.append("B.InputTaxRate AS InputTaxRate, ");
        sqlSelect.append("B.BIsDeduct AS BIsDeduct, ");
        sqlSelect.append("B.IsDeduct AS IsDeduct, ");
        sqlSelect.append("B.bADDONS AS bADDONS, ");
        sqlSelect.append("B.ADDONS AS ADDONS, ");
        sqlSelect.append("B.bTREATMENTINCOME AS bTREATMENTINCOME, ");
        sqlSelect.append("B.TREATMENTINCOME AS TREATMENTINCOME, ");
        sqlSelect.append("B.bADDONFARE AS bADDONFARE, ");
        sqlSelect.append("B.ADDONFARE AS ADDONFARE, ");
        sqlSelect.append("B.bASSETVALUE AS bASSETVALUE, ");
        sqlSelect.append("B.ASSETVALUE AS ASSETVALUE, ");
        sqlSelect.append("B.ORIGINCHG AS ORIGINCHG, ");
        sqlSelect.append("B.bclrEvalValue as bclrEvalValue,");
        sqlSelect.append("B.clrEvalValue as clrEvalValue,");
        sqlSelect.append("B.bBUYVALUE AS bBUYVALUE, ");
        sqlSelect.append("B.BUYVALUE AS BUYVALUE, ");
        sqlSelect.append("B.bBUYACCUDEPR AS bBUYACCUDEPR, ");
        sqlSelect.append("B.BUYACCUDEPR AS BUYACCUDEPR, ");
        sqlSelect.append("B.bDELIVERDATE AS bDELIVERDATE, ");
        sqlSelect.append("B.DELIVERDATE AS DELIVERDATE, ");
        sqlSelect.append("B.STARTUSEDATE AS STARTUSEDATE, ");
        sqlSelect.append("B.bUSEYEARS AS bUSEYEARS, ");
        sqlSelect.append("B.USEYEARS AS USEYEARS, ");
        sqlSelect.append("B.bUSETERMCOUNT AS bUSETERMCOUNT, ");
        sqlSelect.append("B.USETERMCOUNT AS USETERMCOUNT, ");
        sqlSelect.append("B.bDEPRTERMCOUNT AS bDEPRTERMCOUNT, ");
        sqlSelect.append("B.DEPRTERMCOUNT AS DEPRTERMCOUNT, ");
        sqlSelect.append("B.LEFTTERMCOUNT AS LEFTTERMCOUNT, ");
        sqlSelect.append("B.bLEFTTERMCOUNT AS bLEFTTERMCOUNT, ");
        sqlSelect.append("B.bACCUDEPR AS bACCUDEPR, ");
        sqlSelect.append("B.ACCUDEPR AS ACCUDEPR, ");
        sqlSelect.append("B.ACCUDEPRCHG AS ACCUDEPRCHG,");
        sqlSelect.append("B.bACCUDEPRYEAR AS bACCUDEPRYEAR, ");
        sqlSelect.append("B.ACCUDEPRYEAR AS ACCUDEPRYEAR, ");
        sqlSelect.append("B.bNEATREMVALUE AS bNEATREMVALUE, ");
        sqlSelect.append("B.NEATREMVALUE AS NEATREMVALUE, ");
        sqlSelect.append("B.bNEATLEFTRATE AS bNEATLEFTRATE, ");
        sqlSelect.append("B.NEATLEFTRATE AS NEATLEFTRATE, ");
        sqlSelect.append("B.bNEATVALUE AS bNEATVALUE, ");
        sqlSelect.append("B.NEATVALUE AS NEATVALUE, ");
        sqlSelect.append("B.bDECVALUE AS bDECVALUE, ");
        sqlSelect.append("B.DECVALUE AS DECVALUE, ");
        sqlSelect.append("B.DECVALUECHG AS DECVALUECHG, ");
        sqlSelect.append("B.bNEATAMT AS bNEATAMT, ");
        sqlSelect.append("B.NEATAMT AS NEATAMT, ");
        sqlSelect.append("COMPANY.").append(this.fName).append(" AS COMPANY_NAME, ");
        sqlSelect.append("B.bDEPT_NAME AS bDEPT_NAME, ");
        sqlSelect.append("B.DEPT_NAME AS DEPT_NAME, ");
        sqlSelect.append("B.bKEEPER_NAME AS bKEEPER_NAME, ");
        sqlSelect.append("B.KEEPER_NAME AS KEEPER_NAME, ");
        sqlSelect.append("B.bREMARK AS bREMARK, ");
        sqlSelect.append("B.REMARK AS REMARK, ");
        sqlSelect.append("B.BAKCARDID AS BAKCARDID,");
        sqlSelect.append("B.CHANGETYPE AS CHANGETYPE, ");
        sqlSelect.append("B.bPREC AS bPREC, ");
        sqlSelect.append("B.PREC AS PREC, ");
        sqlSelect.append("bEXAUX.fprecision AS bEXRATEPREC, ");
        sqlSelect.append("EXAUX.fprecision AS EXRATEPREC, ");
        sqlSelect.append("B.bEvalAssetValue as bEvalAssetValue, ");
        sqlSelect.append("B.evalAssetValue as evalAssetValue, ");
        sqlSelect.append("B.bEvalReInAccountDate as bEvalReInAccountDate, ");
        sqlSelect.append("B.evalReInAccountDate as evalReInAccountDate, ");
        sqlSelect.append("B.bEvalDeprMethod_name AS bEvalDeprMethod_name, ");
        sqlSelect.append("B.evalDeprMethod_name AS evalDeprMethod_name, ");
        sqlSelect.append("B.bEvalUseTermCount AS bEvalUseTermCount, ");
        sqlSelect.append("B.evalUseTermCount AS evalUseTermCount, ");
        sqlSelect.append("B.bEvalMonthRate AS bEvalMonthRate, ");
        sqlSelect.append("B.evalMonthRate AS evalMonthRate, ");
        sqlSelect.append("B.bEvalTaxLeftPeriod AS bEvalTaxLeftPeriod, ");
        sqlSelect.append("B.evalTaxLeftPeriod AS evalTaxLeftPeriod, ");
        sqlSelect.append("B.bEvalNeatLeftRate AS bEvalNeatLeftRate, ");
        sqlSelect.append("B.evalNeatLeftRate AS evalNeatLeftRate, ");
        sqlSelect.append("B.bEvalDeprPeriodNum AS bEvalDeprPeriodNum, ");
        sqlSelect.append("B.evalDeprPeriodNum AS evalDeprPeriodNum, ");
        sqlSelect.append("B.bEvalRemValue AS bEvalRemValue, ");
        sqlSelect.append("B.evalRemValue AS evalRemValue, ");
        sqlSelect.append("B.bEvalAddDepr AS bEvalAddDepr, ");
        sqlSelect.append("B.evalAddDepr AS evalAddDepr, ");
        sqlSelect.append("B.bEvalDecValue AS bEvalDecValue, ");
        sqlSelect.append("B.evalDecValue AS evalDecValue, ");
        sqlSelect.append("B.bEvalYearDepr AS bEvalYearDepr, ");
        sqlSelect.append("B.evalYearDepr AS evalYearDepr, ");
        sqlSelect.append("B.bEvalNeatValue AS bEvalNeatValue, ");
        sqlSelect.append("B.evalNeatValue AS evalNeatValue, ");
        sqlSelect.append("B.evalMeasureUnit_name AS evalMeasureUnit_name, ");
        sqlSelect.append("B.bEvalNeatAmt AS bEvalNeatAmt, ");
        sqlSelect.append("B.evalNeatAmt AS evalNeatAmt, ");
        sqlSelect.append("BASECURRENCY.FPrecision AS BASEPREC, ");
        sqlSelect.append("COMPANY.FID AS COMPANY_ID,");
        sqlSelect.append(" CASE  WHEN (bACCOUNTDECVALUEFName_l2 IS NULL) THEN NULL ELSE ((bACCOUNTDECVALUEFNumber || ' - ') ||bACCOUNTDECVALUEFName_l2) END AS bACCOUNTDEVVALUE_DISPNAME, ");
        sqlSelect.append(" CASE  WHEN (ACCOUNTDECVALUEFName_l2 IS NULL) THEN NULL ELSE ((ACCOUNTDECVALUEFNumber || ' - ') || ACCOUNTDECVALUEFName_l2) END AS ACCOUNTDEVVALUE_DISPNAME, ");
        sqlSelect.append(" CASE  WHEN (bACCOUNTACCUDEPRFName_l2 IS NULL) THEN NULL ELSE ((bACCOUNTACCUDEPRFNumber || ' - ') || bACCOUNTACCUDEPRFName_l2) END AS bACCOUNTACCUDEPR_DISPNAME,  ");
        sqlSelect.append(" CASE  WHEN (ACCOUNTACCUDEPRFName_l2 IS NULL) THEN NULL ELSE ((ACCOUNTACCUDEPRFNumber || ' - ') || ACCOUNTACCUDEPRFName_l2) END AS ACCOUNTACCUDEPR_DISPNAME, ");
        sqlSelect.append(" CASE  WHEN (bACCOUNTASSETFName_l2 IS NULL) THEN NULL ELSE ((bACCOUNTASSETFNumber || ' - ') || bACCOUNTASSETFName_l2) END AS bACCOUNTASSET_DISPNAME, ");
        sqlSelect.append(" CASE  WHEN (ACCOUNTASSETFName_l2 IS NULL) THEN NULL ELSE ((ACCOUNTASSETFNumber || ' - ') || ACCOUNTASSETFName_l2) END AS ACCOUNTASSET_DISPNAME , ");
        sqlSelect.append("0 AS isSum ");
        sqlSelect.append(",B.FPropertyValueID AS FPropertyValueID, ");
        sqlSelect.append("B.BFPropertyValueID AS BFPropertyValueID ");
        if (this.isVirCompany) {
            sqlSelect.append(",COMPANY.FLevel AS SumLevel");
        }
        return sqlSelect.toString();
    }

    private String getSumSelectSql() {
        StringBuffer sqlSelect = new StringBuffer();
        sqlSelect.append("TO_CHAR(NULL) AS bizNumber, ");
        sqlSelect.append("TO_CHAR(NULL) AS voucherID, ");
        sqlSelect.append("TO_CHAR(NULL) AS voucherNumber, ");
        sqlSelect.append("TO_CHAR(NULL) AS CardID, ");
        sqlSelect.append("TO_CHAR(NULL) AS CHANGEDATE, ");
        sqlSelect.append("TO_DATE(NULL) AS BIZDATE, ");
        sqlSelect.append("TO_CHAR(NULL) AS ALTERMETHOD_NAME, ");
        sqlSelect.append("TO_CHAR(NULL) AS bASSETNUMBER, ");
        sqlSelect.append("TO_CHAR(NULL) AS ASSETNUMBER, ");
        sqlSelect.append("TO_CHAR(NULL) AS bOLDERNUMBER, ");
        sqlSelect.append("TO_CHAR(NULL) AS OLDERNUMBER, ");
        sqlSelect.append("TO_CHAR(NULL) AS bGROUPNUMBER, ");
        sqlSelect.append("TO_CHAR(NULL) AS GROUPNUMBER, ");
        sqlSelect.append("TO_CHAR(NULL) AS bASSETNAME, ");
        sqlSelect.append("TO_CHAR(NULL) AS ASSETNAME, ");
        sqlSelect.append("TO_CHAR(NULL) AS bASSETCAT_NAME, ");
        sqlSelect.append("TO_CHAR(NULL) AS ASSETCAT_NAME, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS bASSETAMT, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS ASSETAMT, ");
        sqlSelect.append("TO_CHAR(NULL) AS bMEASUREUNIT_NAME, ");
        sqlSelect.append("TO_CHAR(NULL) AS MEASUREUNIT_NAME, ");
        sqlSelect.append("TO_CHAR(NULL) AS bUSESTATUS_NAME, ");
        sqlSelect.append("TO_CHAR(NULL) AS USESTATUS_NAME, ");
        sqlSelect.append("TO_CHAR(NULL) AS bECONOMICPURP_NAME, ");
        sqlSelect.append("TO_CHAR(NULL) AS ECONOMICPURP_NAME,");
        sqlSelect.append("TO_CHAR(NULL) AS bSTORECITY_NAME,");
        sqlSelect.append("TO_CHAR(NULL) AS STORECITY_NAME, ");
        sqlSelect.append("TO_CHAR(NULL) AS bUseDepartment, ");
        sqlSelect.append("TO_CHAR(NULL) AS UseDepartment, ");
        sqlSelect.append("TO_CHAR(NULL) AS bUsePerson, ");
        sqlSelect.append("TO_CHAR(NULL) AS UsePerson, ");
        sqlSelect.append("TO_CHAR(NULL) AS bCostCenter, ");
        sqlSelect.append("TO_CHAR(NULL) AS CostCenter, ");
        sqlSelect.append("TO_CHAR(NULL) AS bSPECS, ");
        sqlSelect.append("TO_CHAR(NULL) AS SPECS, ");
        sqlSelect.append("TO_CHAR(NULL) AS bPAREA, ");
        sqlSelect.append("TO_CHAR(NULL) AS PAREA, ");
        sqlSelect.append("TO_CHAR(NULL) AS bMFR, ");
        sqlSelect.append("TO_CHAR(NULL) AS MFR, ");
        sqlSelect.append("TO_DATE(NULL) AS bLEVFRDATE, ");
        sqlSelect.append("TO_DATE(NULL) AS LEVFRDATE, ");
        sqlSelect.append("TO_CHAR(NULL) AS bORIGINUNIT, ");
        sqlSelect.append("TO_CHAR(NULL) AS ORIGINUNIT, ");
        sqlSelect.append("TO_CHAR(NULL) AS PAPERNO, ");
        sqlSelect.append("TO_CHAR(NULL) AS bDEPRMETHOD_NAME, ");
        sqlSelect.append("TO_CHAR(NULL) AS DEPRMETHOD_NAME, ");
        sqlSelect.append("TO_CHAR(NULL) AS bMEASUREUNITWL_NAME, ");
        sqlSelect.append("TO_CHAR(NULL) AS MEASUREUNITWL_NAME, ");
        sqlSelect.append("TO_CHAR(NULL) AS bCURRENCY_NAME, ");
        sqlSelect.append("TO_CHAR(NULL) AS CURRENCY_NAME, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS bEXRATE, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS EXRATE, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS bORIGINAMT, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS ORIGINAMT, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS bTAXORIGINAMT, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS TAXORIGINAMT, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS BInputTax, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS InputTax, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS BInputTaxRate, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS InputTaxRate, ");
        sqlSelect.append("TO_INT(NULL) AS BIsDeduct, ");
        sqlSelect.append("TO_INT(NULL) AS IsDeduct, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS bADDONS, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS ADDONS, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS bTREATMENTINCOME, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS TREATMENTINCOME, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS bADDONFARE, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS ADDONFARE, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS bASSETVALUE, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS ASSETVALUE, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS ORIGINCHG, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS bclrEvalValue,");
        sqlSelect.append("TO_DECIMAL(NULL) AS clrEvalValue,");
        sqlSelect.append("TO_DECIMAL(NULL) AS bBUYVALUE, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS BUYVALUE, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS bBUYACCUDEPR, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS BUYACCUDEPR, ");
        sqlSelect.append("TO_DATE(NULL) AS bDELIVERDATE, ");
        sqlSelect.append("TO_DATE(NULL) AS DELIVERDATE, ");
        sqlSelect.append("TO_DATE(NULL) AS STARTUSEDATE, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS bUSEYEARS, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS USEYEARS, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS bUSETERMCOUNT, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS USETERMCOUNT, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS bDEPRTERMCOUNT, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS DEPRTERMCOUNT, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS LEFTTERMCOUNT, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS bLEFTTERMCOUNT, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS bACCUDEPR, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS ACCUDEPR, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS ACCUDEPRCHG,");
        sqlSelect.append("TO_DECIMAL(NULL) AS bACCUDEPRYEAR, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS ACCUDEPRYEAR, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS bNEATREMVALUE, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS NEATREMVALUE, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS bNEATLEFTRATE, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS NEATLEFTRATE, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS bNEATVALUE, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS NEATVALUE, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS bDECVALUE, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS DECVALUE, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS DECVALUECHG, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS bNEATAMT, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS NEATAMT, ");
        sqlSelect.append("TO_CHAR(NULL) AS COMPANY_NAME, ");
        sqlSelect.append("TO_CHAR(NULL) AS bDEPT_NAME, ");
        sqlSelect.append("TO_CHAR(NULL) AS DEPT_NAME, ");
        sqlSelect.append("TO_CHAR(NULL) AS bKEEPER_NAME, ");
        sqlSelect.append("TO_CHAR(NULL) AS KEEPER_NAME, ");
        sqlSelect.append("TO_CHAR(NULL) AS bREMARK, ");
        sqlSelect.append("TO_CHAR(NULL) AS REMARK, ");
        sqlSelect.append("TO_CHAR(NULL) AS BAKCARDID,");
        sqlSelect.append("TO_DECIMAL(NULL) AS CHANGETYPE, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS bPREC, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS PREC, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS bEXRATEPREC, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS EXRATEPREC, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS bEvalAssetValue, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS evalAssetValue, ");
        sqlSelect.append("TO_DATE(NULL) AS bEvalReInAccountDate, ");
        sqlSelect.append("TO_DATE(NULL) AS evalReInAccountDate, ");
        sqlSelect.append("TO_CHAR(NULL) AS bEvalDeprMethod_name, ");
        sqlSelect.append("TO_CHAR(NULL) AS evalDeprMethod_name, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS bEvalUseTermCount, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS evalUseTermCount, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS bEvalMonthRate, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS evalMonthRate, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS bEvalTaxLeftPeriod, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS evalTaxLeftPeriod, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS bEvalNeatLeftRate, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS evalNeatLeftRate, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS bEvalDeprPeriodNum, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS evalDeprPeriodNum, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS bEvalRemValue, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS evalRemValue, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS bEvalAddDepr, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS evalAddDepr, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS bEvalDecValue, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS evalDecValue, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS bEvalYearDepr, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS evalYearDepr, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS bEvalNeatValue, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS evalNeatValue, ");
        sqlSelect.append("TO_CHAR(NULL) AS evalMeasureUnit_name, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS bEvalNeatAmt, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS evalNeatAmt, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS BASEPREC, ");
        sqlSelect.append("TO_CHAR(null) AS COMPANY_ID,");
        sqlSelect.append("TO_CHAR(NULL)  AS bACCOUNTASSET_DISPNAME,");
        sqlSelect.append("TO_CHAR(NULL)  AS ACCOUNTASSET_DISPNAME,");
        sqlSelect.append("TO_CHAR(NULL)  AS bACCOUNTDEVVALUE_DISPNAME,");
        sqlSelect.append("TO_CHAR(NULL)  AS ACCOUNTDEVVALUE_DISPNAME,");
        sqlSelect.append("TO_CHAR(NULL)  AS bACCOUNTACCUDEPR_DISPNAME,");
        sqlSelect.append("TO_CHAR(NULL)  AS ACCOUNTACCUDEPR_DISPNAME, ");
        sqlSelect.append("1 AS isSum ");
        sqlSelect.append(",TO_CHAR(NULL)  AS FPropertyValueID, ");
        sqlSelect.append("TO_CHAR(NULL)  AS BFPropertyValueID ");
        return sqlSelect.toString();
    }

    private String getNewCardDetailSql() {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");
        sql.append(this.getCardSelecSQL("C", "FFaCurCardID"));
        sql.append("C.fnumber AS bizNumber,");
        sql.append("C.fvoucher AS voucherID,");
        sql.append("C.fvoucherNumber AS voucherNumber,");
        sql.append("C.FBILLTYPE,");
        sql.append("C.FCompanyID, ");
        sql.append("C.FREMARK AS CHGREASON, ");
        sql.append("C.FFIAccountDate AS CHANGEDATE, ");
        sql.append("C.FBizDate AS BIZDATE, ");
        sql.append("C.FORIGINMETHODID AS CHANGEMODE, ");
        sql.append("C.FAssetValue AS ORIGINCHG, ");
        sql.append("CASE  when (C.FIsEvaledBefore>0) then C.flastEvalValue else ( TO_DECIMAL(NULL) ) end as  bclrEvalValue, ");
        sql.append("CASE  when (C.FIsEvaledBefore>0) then C.finitevalvalue else ( TO_DECIMAL(NULL) ) end as  clrEvalValue, ");
        sql.append("C.FAccuDepr AS ACCUDEPRCHG, ");
        sql.append("C.FDecValue AS DECVALUECHG, ");
        sql.append("'' AS BAKCARDID,");
        sql.append("1 AS CHANGETYPE ");
        sql.append("FROM T_FA_FABAKCARD AS C ");
        sql.append(" WHERE C.FFACURCARDID = '" + this.FACURCARDID + "'");
        sql.append(" AND C.FBILLTYPE = 1");
        sql.append(" AND C.FCheckedStatus = 2");
        return sql.toString();
    }

    private String getChangeBillDetailSql() {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");
        sql.append(this.getCardSelecSQL("E", "FFaCurCardID"));
        sql.append("A.fnumber AS bizNumber,");
        sql.append("A.FVoucherID as voucherID,");
        sql.append("A.fvoucherNumber AS voucherNumber,");
        sql.append("C.FBILLTYPE,");
        sql.append("A.FCompanyID, ");
        sql.append("A.FDescription AS CHGREASON, ");
        sql.append("A.FCHANGEDATE AS CHANGEDATE, ");
        sql.append("A.FBIZDATE AS BIZDATE, ");
        sql.append("A.FCHANGEMODEID AS CHANGEMODE, ");
        sql.append("B.TORIGINCHG AS ORIGINCHG, ");
        sql.append("CASE  when (C.FIsEvaledBefore>0) then C.flastEvalValue else ( TO_DECIMAL(NULL) ) end as  bclrEvalValue, ");
        sql.append("CASE  when (C.FIsEvaledBefore>0) then C.finitevalvalue else ( TO_DECIMAL(NULL) ) end as  clrEvalValue, ");
        sql.append("B.TACCUDEPRCHG AS ACCUDEPRCHG, ");
        sql.append("B.TDECVALUECHG AS DECVALUECHG, ");
        sql.append("E.FID AS BAKCARDID,");
        sql.append("2 AS CHANGETYPE ");
        sql.append("FROM T_FA_FACHANGEBILL AS A ");
        sql.append("INNER JOIN T_FA_FACHANGEBILLENTRY AS B ON A.FID = B.FCHANGEBILLID ");
        sql.append("INNER JOIN T_FA_FABIZCARD AS C ON B.FBIZCARDID = C.FID ");
        sql.append(" INNER JOIN T_FA_FABAKCARD AS E ON C.FFaBakCardID = E.FID ");
        sql.append(" WHERE E.FFACURCARDID = '" + this.FACURCARDID + "'");
        sql.append(" AND E.FBILLTYPE = 2");
        sql.append(" AND A.FCheckedStatus = 2");
        return sql.toString();
    }

    private String getCleanBillDetailSql() {
        boolean b;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");
        sql.append(this.getCardSelecSQL("E", "FFaCurCardID"));
        sql.append("A.fnumber AS bizNumber,");
        sql.append("A.FvoucherID AS voucherID,");
        sql.append("A.fvoucherNumber AS voucherNumber,");
        sql.append("C.FBILLTYPE,");
        sql.append("A.FCompanyID, ");
        sql.append("B.FCOMMENT AS CHGREASON, ");
        sql.append("A.FCLEARDATE AS CHANGEDATE, ");
        sql.append("A.FBIZDATE AS BIZDATE, ");
        sql.append("A.FCLEARMODEID AS CHANGEMODE, ");
        sql.append("B.FCLRORIGINAL * -1 AS ORIGINCHG, ");
        sql.append("CASE  when (C.FIsEvaledBefore>0) then c.finitEvalValue else ( TO_DECIMAL(NULL) ) end as  bclrEvalValue, ");
        sql.append("CASE  when (C.FIsEvaledBefore>0) then C.finitevalvalue-B.fclrEvalValue else ( TO_DECIMAL(NULL) ) end as  clrEvalValue, ");
        sql.append("B.FCLRADDUPDEP * -1 AS ACCUDEPRCHG, ");
        sql.append("B.FCLRDECPREP * -1 AS DECVALUECHG, ");
        sql.append("'' AS BAKCARDID,");
        sql.append("CASE E.FASSETAMT WHEN B.FCLRQTY THEN 4 ELSE 3 END AS CHANGETYPE ");
        sql.append("FROM T_FA_CLEARBILL AS A ");
        sql.append("INNER JOIN T_FA_CLEARBILLENTRY AS B ON A.FID = B.FENTRYID ");
        sql.append("INNER JOIN T_FA_FABIZCARD AS C ON B.FBIZCARDID = C.FID ");
        sql.append("INNER JOIN T_FA_FACURCARD AS D ON B.FCURCARDID = D.FID");
        sql.append(" INNER JOIN T_FA_FABAKCARD AS E ON C.FFaBakCardID = E.FID");
        sql.append(" WHERE E.FFACURCARDID = '" + this.FACURCARDID + "'");
        sql.append(" AND A.FCheckedStatus = 2");
        boolean bl = b = this.bCompleteclean && this.bPartclean;
        if (!b) {
            if (this.bPartclean) {
                sql.append(" AND E.FASSETAMT != B.FCLRQTY");
            }
            if (this.bCompleteclean) {
                sql.append(" AND E.FASSETAMT = B.FCLRQTY");
            }
        }
        return sql.toString();
    }

    private String getUseDepartment(boolean isBakCard, boolean isUpdateBak) throws BOSException {
        boolean isDisplayLongName = false;
        isDisplayLongName = this.hmParam != null && this.hmParam.get("FA_025") != null && "true".equals(this.hmParam.get("FA_025"));
        StringBuffer sql = new StringBuffer();
        FaDaoSqlObject deptDao = new FaDaoSqlObject();
        String table = isBakCard || isUpdateBak ? "T_FA_FaBakDepartment" : "T_FA_FaBizDepartment";
        String column = isBakCard || isUpdateBak ? "FFaBakCardID" : "FFaBizCardID";
        sql.append("update ").append(this.tempTable).append(" SET ");
        sql.append(isUpdateBak ? "bUSEDEPARTMENT" : "USEDEPARTMENT").append(" = (");
        deptDao.setSelect(" MAX(FSeq) AS  maxSeq ");
        StringBuffer deptFrom = new StringBuffer(table);
        deptFrom.append(" dept INNER JOIN ").append(this.tempTable).append(" temp ON temp.").append(isUpdateBak ? "BakCardID" : "CardID").append(" = dept.").append(column);
        deptDao.setFrom(deptFrom.toString());
        IRowSet row = DbUtil.executeQuery((Context)this.ctx, (String)deptDao.getSql());
        int n = 1;
        try {
            if (row != null && row.next()) {
                n = row.getInt("maxSeq");
            }
        }
        catch (SQLException e) {
            throw new BOSException("Sql execute exception : " + deptDao.getSql(), (Throwable)e);
        }
        if (n > 10) {
            n = 10;
        }
        StringBuffer select = new StringBuffer();
        StringBuffer from = new StringBuffer();
        select.append("'{' || department.FNUMBER || '}' || department.").append(isDisplayLongName ? this.fDisplayName : this.fName).append("   ");
        from.append(table).append(" fadept ").append(" INNER JOIN T_ORG_Admin AS department ");
        from.append(" ON (fadept.FUseDepartmentID = department.FID  AND fadept.FSeq = 1) ");
        for (int i = 2; i <= n; ++i) {
            select.append(" || ( case ISNULL(department").append(i).append(".").append(isDisplayLongName ? this.fDisplayName : this.fName);
            select.append("  ,'') when '' THEN '' ELSE ' ;  ' ||'{' || department.FNUMBER || '}' || department").append(i).append(".").append(isDisplayLongName ? this.fDisplayName : this.fName);
            select.append(i == 10 ? "||' ; ...' END)" : " END) ");
            from.append(" LEFT OUTER JOIN ").append(table).append(" fadept").append(i);
            from.append(" ON (fadept").append(i).append(".FSeq = ").append(i).append(" AND fadept.");
            from.append(column).append(" = fadept").append(i).append(".").append(column).append(") ");
            from.append(" LEFT OUTER JOIN T_ORG_Admin AS department").append(i);
            from.append(" ON (fadept").append(i).append(".FUseDepartmentID = department").append(i).append(".FID ) ");
        }
        deptDao.setSelect(select.toString());
        deptDao.setFrom(from.toString());
        StringBuffer where = new StringBuffer(this.tempTable);
        where.append(isUpdateBak ? ".BakCardId" : ".CardId").append(" = fadept.").append(column).append(" AND fadept.FSeq = 1 ");
        deptDao.setWhere(where.toString());
        sql.append(deptDao.getSql()).append(")");
        sql.append(" WHERE CHANGETYPE ").append(isBakCard ? " = 1" : (isUpdateBak ? " = 2" : " != 1"));
        return sql.toString();
    }

    private String getCurUseDepartment() throws BOSException {
        boolean isDisplayLongName = false;
        isDisplayLongName = this.hmParam != null && this.hmParam.get("FA_025") != null && "true".equals(this.hmParam.get("FA_025"));
        StringBuffer sql = new StringBuffer();
        FaDaoSqlObject deptDao = new FaDaoSqlObject();
        sql.append("update ").append(this.tempTable).append(" SET USEDEPARTMENT = (");
        deptDao.setSelect(" MAX(FSeq) AS  maxSeq ");
        StringBuffer deptFrom = new StringBuffer("T_FA_FaCurDepartment");
        deptFrom.append(" dept INNER JOIN ").append(this.tempTable).append(" temp ON temp.").append("CardID").append(" = dept.FFaCurCardID");
        deptDao.setFrom(deptFrom.toString());
        IRowSet row = DbUtil.executeQuery((Context)this.ctx, (String)deptDao.getSql());
        int n = 1;
        try {
            if (row != null && row.next()) {
                n = row.getInt("maxSeq");
            }
        }
        catch (SQLException e) {
            throw new BOSException("Sql execute exception : " + deptDao.getSql(), (Throwable)e);
        }
        if (n > 10) {
            n = 10;
        }
        StringBuffer select = new StringBuffer();
        StringBuffer from = new StringBuffer();
        select.append("'{' || department.FNUMBER || '}' || department.").append(isDisplayLongName ? this.fDisplayName : this.fName).append("   ");
        from.append(" T_FA_FaCurDepartment fadept ").append(" INNER JOIN T_ORG_Admin AS department ");
        from.append(" ON (fadept.FUseDepartmentID = department.FID  AND fadept.FSeq = 1) ");
        for (int i = 2; i <= n; ++i) {
            select.append(" || ( case ISNULL(department").append(i).append(".").append(isDisplayLongName ? this.fDisplayName : this.fName);
            select.append("  ,'') when '' THEN '' ELSE ' ;  ' ||'{' || department.FNUMBER || '}' || department").append(i).append(".").append(isDisplayLongName ? this.fDisplayName : this.fName);
            select.append(i == 10 ? "||' ; ...' END)" : " END) ");
            from.append(" LEFT OUTER JOIN T_FA_FaCurDepartment fadept").append(i);
            from.append(" ON (fadept").append(i).append(".FSeq = ").append(i).append(" AND fadept.");
            from.append(" FFaCurCardID = fadept").append(i).append(".FFaCurCardID) ");
            from.append(" LEFT OUTER JOIN T_ORG_Admin AS department").append(i);
            from.append(" ON (fadept").append(i).append(".FUseDepartmentID = department").append(i).append(".FID ) ");
        }
        deptDao.setSelect(select.toString());
        deptDao.setFrom(from.toString());
        StringBuffer where = new StringBuffer(this.tempTable);
        where.append(".CardId").append(" = fadept.FFaCurCardID AND fadept.FSeq = 1 ");
        deptDao.setWhere(where.toString());
        sql.append(deptDao.getSql()).append(")");
        sql.append(" WHERE CHANGETYPE  = 1 AND USEDEPARTMENT IS NULL");
        return sql.toString();
    }

    private String getOriginUnitSql(String originTypeField, String originUnitId) {
        StringBuffer sql = new StringBuffer();
        sql.append("(CASE WHEN(").append(originTypeField).append(" = 2) ");
        sql.append("THEN (SELECT CP." + this.fName + " FROM T_ORG_BaseUnit AS CP WHERE CP.FID = ").append(originUnitId);
        sql.append(") WHEN(").append(originTypeField).append(" = 1) ");
        sql.append("THEN (SELECT CS." + this.fName + " FROM T_BD_Customer AS CS WHERE CS.FID = ").append(originUnitId);
        sql.append(") ELSE (").append("SELECT CS." + this.fName + " FROM T_BD_Supplier AS CS WHERE CS.FID = ").append(originUnitId);
        sql.append(") END)");
        return sql.toString();
    }

    private String getUpdateBakCostSql() {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE ").append(this.tempTable);
        sql.append(" SET bCostCenter = CostCenter");
        sql.append(" WHERE CHANGETYPE != 2");
        return sql.toString();
    }

    private String getUpdateBakUseDSql() {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE ").append(this.tempTable);
        sql.append(" SET bUseDepartment = UseDepartment");
        sql.append(" WHERE CHANGETYPE != 2");
        return sql.toString();
    }

    private String getUsePerson(boolean isBakCard, boolean isUpdateBak) throws BOSException {
        StringBuilder sql = new StringBuilder();
        FaDaoSqlObject deptDao = new FaDaoSqlObject();
        String table = isBakCard || isUpdateBak ? "T_FA_FaBakDepartment" : "T_FA_FaBizDepartment";
        String column = isBakCard || isUpdateBak ? "FFaBakCardID" : "FFaBizCardID";
        sql.append("update ").append(this.tempTable).append(" SET ");
        sql.append(isUpdateBak ? "bUSEPERSON" : "USEPERSON").append(" = (");
        deptDao.setSelect(" MAX(FSeq) AS  maxSeq ");
        StringBuilder deptFrom = new StringBuilder(table);
        deptFrom.append(" dept INNER JOIN ").append(this.tempTable).append(" temp ON temp.").append(isUpdateBak ? "BakCardID" : "CardID").append(" = dept.").append(column);
        deptDao.setFrom(deptFrom.toString());
        IRowSet row = DbUtil.executeQuery((Context)this.ctx, (String)deptDao.getSql());
        int n = 1;
        try {
            if (row.next()) {
                n = row.getInt("maxSeq");
            }
        }
        catch (SQLException e) {
            throw new BOSException("Sql execute exception : " + deptDao.getSql(), (Throwable)e);
        }
        if (n > 10) {
            n = 10;
        }
        StringBuffer select = new StringBuffer();
        StringBuffer from = new StringBuffer();
        select.append("person.").append(this.fName).append("   ");
        from.append(table).append(" fadept ").append(" INNER JOIN T_BD_Person AS person ");
        from.append(" ON (fadept.FUsePersonID = person.FID  AND fadept.FSeq = 1) ");
        for (int i = 2; i <= n; ++i) {
            select.append(" || ( case ISNULL(person").append(i).append(".").append(this.fName);
            select.append("  ,'') when '' THEN '' ELSE ' ;  ' || person").append(i).append(".").append(this.fName);
            select.append(i == 10 ? "||' ; ...' END)" : " END) ");
            from.append(" LEFT OUTER JOIN ").append(table).append(" fadept").append(i);
            from.append(" ON (fadept").append(i).append(".FSeq = ").append(i).append(" AND fadept.");
            from.append(column).append(" = fadept").append(i).append(".").append(column).append(") ");
            from.append(" LEFT OUTER JOIN T_BD_Person AS person").append(i);
            from.append(" ON (fadept").append(i).append(".FUsePersonID = person").append(i).append(".FID ) ");
        }
        deptDao.setSelect(select.toString());
        deptDao.setFrom(from.toString());
        StringBuffer where = new StringBuffer(this.tempTable);
        where.append(isUpdateBak ? ".BakCardId" : ".CardId").append(" = fadept.").append(column).append(" AND fadept.FSeq = 1 ");
        deptDao.setWhere(where.toString());
        sql.append(deptDao.getSql()).append(")");
        sql.append(" WHERE CHANGETYPE ").append(isBakCard ? " = 1" : (isUpdateBak ? " = 2" : " != 1"));
        return sql.toString();
    }

    private String getUpdateBakUsePSql() {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE ").append(this.tempTable);
        sql.append(" SET bUsePerson = UsePerson");
        sql.append(" WHERE CHANGETYPE != 2");
        return sql.toString();
    }

    private StringBuffer getCardSelecSQL(String alias, String FID) {
        StringBuffer sql = new StringBuffer();
        sql.append("C.FPropertyValueID, ");
        sql.append(alias).append(".FPropertyValueID as bFPropertyValueID, ");
        sql.append("C.FID AS CardID, ");
        sql.append(alias).append(".").append(FID).append(" AS  CUR_CARD_ID, ");
        sql.append(alias).append(".FNumber AS bASSETNUMBER, ");
        sql.append("C.FNumber AS ASSETNUMBER, ");
        sql.append(alias).append(".FoldNumber AS bOlderNumber, ");
        sql.append("C.FoldNumber AS OlderNumber, ");
        sql.append(alias).append(".FGroupNumber AS bGroupNumber, ");
        sql.append("C.FGroupNumber AS GroupNumber, ");
        sql.append(alias).append(".FAssetName AS bASSETNAME, ");
        sql.append("C.FAssetName AS ASSETNAME, ");
        sql.append(alias).append(".FAssetAmt AS bASSETAMT, ");
        sql.append("C.FAssetAmt AS ASSETAMT, ");
        sql.append("C.FFIAccountDate AS ACCOUNTDATE, ");
        sql.append(alias).append(".FEconomicPurpID AS bECONOMICPURPID, ");
        sql.append("C.FEconomicPurpID AS ECONOMICPURPID, ");
        sql.append(alias).append(".FSpecs AS bSPECS, ");
        sql.append("C.FSpecs AS SPECS, ");
        sql.append(alias).append(".FPArea AS bPAREA, ");
        sql.append("C.FPArea AS PAREA, ");
        sql.append(alias).append(".FMfr AS bMFR, ");
        sql.append("C.FMfr AS MFR, ");
        sql.append(alias).append(".FLevFrDate AS bLEVFRDATE, ");
        sql.append("C.FLevFrDate AS LEVFRDATE, ");
        sql.append(this.getOriginUnitSql(alias + ".FOriginType", alias + ".FORIGINUNIT") + " AS bORIGINUNIT, ");
        sql.append(this.getOriginUnitSql("C.FOriginType", "C.FORIGINUNIT") + " AS ORIGINUNIT, ");
        sql.append("C.FPaperNo AS PAPERNO, ");
        sql.append(alias).append(".FExRate AS bEXRATE, ");
        sql.append("C.FExRate AS EXRATE, ");
        sql.append(alias).append(".FOriginAmt AS bORIGINAMT, ");
        sql.append("C.FOriginAmt AS ORIGINAMT, ");
        sql.append(alias).append(".FTaxOriginAmt AS bTaxORIGINAMT, ");
        sql.append("C.FTaxOriginAmt AS TAXORIGINAMT, ");
        sql.append(alias).append(".FInputTax AS BInputTax, ");
        sql.append("C.FInputTax AS InputTax, ");
        sql.append(alias).append(".FInputTaxRate AS BInputTaxRate, ");
        sql.append("C.FInputTaxRate AS InputTaxRate, ");
        sql.append(alias).append(".FIsDeduct AS BIsDeduct, ");
        sql.append("C.FIsDeduct AS IsDeduct, ");
        sql.append(alias).append(".FAddons AS bADDONS, ");
        sql.append("C.FAddons AS ADDONS, ");
        sql.append(alias).append(".FTreatmentIncome AS bTREATMENTINCOME, ");
        sql.append("C.FTreatmentIncome AS TREATMENTINCOME, ");
        sql.append(alias).append(".FAddonFare AS bADDONFARE, ");
        sql.append("C.FAddonFare AS ADDONFARE, ");
        sql.append(alias).append(".FAssetValue AS bASSETVALUE, ");
        sql.append("C.FAssetValue AS ASSETVALUE, ");
        sql.append(alias).append(".FBuyValue AS bBUYVALUE, ");
        sql.append("C.FBuyValue AS BUYVALUE, ");
        sql.append(alias).append(".FBuyAccuDepr AS bBUYACCUDEPR, ");
        sql.append("C.FBuyAccuDepr AS BUYACCUDEPR, ");
        sql.append(alias).append(".FDeliverDate AS bDELIVERDATE, ");
        sql.append("C.FDeliverDate AS DELIVERDATE, ");
        sql.append("C.FStartUseDate AS STARTUSEDATE, ");
        sql.append(alias).append(".FUseYears AS bUSEYEARS, ");
        sql.append("C.FUseYears AS USEYEARS, ");
        sql.append(alias).append(".FUseTermCount AS bUSETERMCOUNT, ");
        sql.append("C.FUseTermCount AS USETERMCOUNT, ");
        sql.append(alias).append(".FDeprTermCount AS bDEPRTERMCOUNT, ");
        sql.append("C.FDeprTermCount AS DEPRTERMCOUNT, ");
        sql.append("(").append(alias).append(".FUseTermCount - ").append(alias).append(".FDeprTermCount) AS bLEFTTERMCONT, ");
        sql.append("(C.FUseTermCount - C.FDeprTermCount) AS LEFTTERMCONT, ");
        sql.append(alias).append(".FAccuDepr AS bACCUDEPR, ");
        sql.append("C.FAccuDepr AS ACCUDEPR, ");
        sql.append(alias).append(".FACCUDEPRTYEAR AS bACCUDEPRYEAR, ");
        sql.append("C.FACCUDEPRTYEAR AS ACCUDEPRYEAR, ");
        sql.append(alias).append(".FNeatRemValue AS bNEATREMVALUE, ");
        sql.append("C.FNeatRemValue AS NEATREMVALUE, ");
        sql.append(alias).append(".FNeatLeftRate AS bNEATLEFTRATE, ");
        sql.append("C.FNeatLeftRate AS NEATLEFTRATE, ");
        sql.append(alias).append(".FNeatValue AS bNEATVALUE, ");
        sql.append("C.FNeatValue AS NEATVALUE, ");
        sql.append(alias).append(".FDecValue AS bDECVALUE, ");
        sql.append("C.FDecValue AS DECVALUE, ");
        sql.append(alias).append(".FNeatAmt AS bNEATAMT, ");
        sql.append("C.FNeatAmt AS NEATAMT, ");
        sql.append(alias).append(".FRemark AS bREMARK, ");
        sql.append("C.FRemark AS REMARK, ");
        sql.append(alias).append(".FDeprMethodID AS bDeprMethodID,");
        sql.append("C.FDeprMethodID AS DeprMethodID,");
        sql.append(alias).append(".FMeasureUnitWLID AS bMeasureUnitWLID,");
        sql.append("C.FMeasureUnitWLID AS MeasureUnitWLID,");
        sql.append(alias).append(".FCurrencyID AS bCurrencyID,");
        sql.append("C.FCurrencyID AS  CurrencyID,");
        sql.append(alias).append(".FKeeperID AS bKeeperID, ");
        sql.append("C.FKeeperID AS KeeperID, ");
        sql.append(alias).append(".FDeptID AS bDeptID,");
        sql.append("C.FDeptID AS DeptID,");
        sql.append(alias).append(".FAssetCatID AS bAssetCatID,");
        sql.append("C.FAssetCatID AS AssetCatID,");
        sql.append(alias).append(".FMeasureUnitID AS bMeasureUnitID,");
        sql.append("C.FMeasureUnitID AS MeasureUnitID,");
        sql.append(alias).append(".FOriginMethodID AS bOriginMethodID,");
        sql.append("C.FOriginMethodID AS OriginMethodID, ");
        sql.append(alias).append(".FUseStatusID AS bUseStatusID,");
        sql.append("C.FUseStatusID AS UseStatusID,");
        sql.append(alias).append(".FStoreCityID AS bStoreCityID,");
        sql.append("C.FStoreCityID AS StoreCityID,");
        sql.append(alias).append(".FEvalAssetValue as bEvalAssetValue,");
        sql.append("C.FEvalAssetValue as evalAssetValue,");
        sql.append(alias).append(".FEvalReInAccountDate as bEvalReInAccountDate,");
        sql.append("C.FEvalReInAccountDate as evalReInAccountDate,");
        sql.append(alias).append(".FEvalDeprModeID as bEvalDeprMethodID,");
        sql.append("C.FEvalDeprModeID as evalDeprMethodID,");
        sql.append(alias).append(".FEvalUseTermCount as bEvalUseTermCount,");
        sql.append("C.FEvalUseTermCount as evalUseTermCount,");
        sql.append(alias).append(".FEvalMonthRate as bEvalMonthRate,");
        sql.append("C.FEvalMonthRate as evalMonthRate,");
        sql.append(alias).append(".FEvalTaxLeftPeriod as bEvalTaxLeftPeriod,");
        sql.append("C.FEvalTaxLeftPeriod as evalTaxLeftPeriod,");
        sql.append(alias).append(".FEvalNeatLeftRate as bEvalNeatLeftRate,");
        sql.append("C.FEvalNeatLeftRate as evalNeatLeftRate,");
        sql.append(alias).append(".FEvalDeprPeriodNum as bEvalDeprPeriodNum,");
        sql.append("C.FEvalDeprPeriodNum as evalDeprPeriodNum,");
        sql.append(alias).append(".FEvalRemValue as bEvalRemValue,");
        sql.append("C.FEvalRemValue as evalRemValue,");
        sql.append(alias).append(".FEvalAddDepr as bEvalAddDepr,");
        sql.append("C.FEvalAddDepr as evalAddDepr,");
        sql.append(alias).append(".FEvalDecValue as bEvalDecValue,");
        sql.append("C.FEvalDecValue as evalDecValue,");
        sql.append(alias).append(".FEvalYearDepr as bEvalYearDepr,");
        sql.append("C.FEvalYearDepr as evalYearDepr,");
        sql.append(alias).append(".FEvalNeatValue as bEvalNeatValue,");
        sql.append("C.FEvalNeatValue as evalNeatValue,");
        sql.append("C.FEvalMeasureUnitWL as evalMeasureUnitWL,");
        sql.append(alias).append(".FEvalNeatAmt as bEvalNeatAmt,");
        sql.append("C.FEvalNeatAmt as evalNeatAmt,");
        sql.append(alias).append(".FAccountDecValueID as bFAccountDecValueID,");
        sql.append("C.FAccountDecValueID as FAccountDecValueID,");
        sql.append(alias).append(".FAccountAccuDeprID as bFAccountAccuDeprID,");
        sql.append("C.FAccountAccuDeprID as FAccountAccuDeprID,");
        sql.append(alias).append(".FAccountAssetID as bFAccountAssetID,");
        sql.append(" C.FAccountAssetID as FAccountAssetID,");
        sql.append(alias).append(".FOriginType AS bOriginType,");
        sql.append("C.FOriginType AS OriginType,");
        return sql;
    }

    protected Connection getConnection(Context ctx) throws SQLDataException {
        try {
            return EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException sqle) {
            throw new SQLDataException(sqle);
        }
    }

    @Override
    protected boolean isCreateTempTable() {
        return true;
    }

    @Override
    protected boolean isCreateAcctAsstTable(EntityViewInfo ev) {
        return false;
    }

    private StringBuffer getPropertyValueFromNewCardSql() throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select A.FID AS FID, A.CARDID AS CARDID ");
        sql.append(this.def.getSelectPart(null));
        sql.append(this.def.getSelectPart(null, "B"));
        sql.append("From ").append(this.tempTable).append(" AS A ");
        try {
            sql.append(this.def.getJoinPart("A.FPropertyValueID"));
            sql.append(this.def.getJoinPart("A.bFPropertyValueID", "B"));
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        sql.append(" where A.FPROPERTYVALUEID IS NOT NULL OR A.bFPROPERTYVALUEID IS NOT NULL ");
        return sql;
    }
}

