/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.PermissionServiceProviderFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.fa.rpt.FaDBUtilConfig;
import com.kingdee.eas.fi.fa.rpt.FaDaoSqlObject;
import com.kingdee.eas.fi.fa.rpt.FaListRptObject;
import com.kingdee.eas.fi.fa.rpt.LevelSumSqlInfo;
import com.kingdee.eas.fi.fa.rpt.app.dao.FaShowNotAuditDao;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class FaChangeListDao
extends FaShowNotAuditDao {
    private static final Logger logger = Logger.getLogger(FaChangeListDao.class);
    private boolean bNew;
    private boolean bChange;
    private boolean bPartclean;
    private boolean bCompleteclean;
    private String select;
    protected Map customFilter;
    private Integer topLevel;
    private String companyId;
    private String sumSql;
    private boolean isListStyle;
    private boolean isListAll;
    private String FACURCARDID;
    private String insertCompanySql;
    private boolean isUserDefineSort;
    private Integer defCompanyLevel;
    private boolean isIncludeAllClear;
    private boolean isShowNoCardCompany;
    private boolean isFilterByFacility;
    private String total = "";
    private boolean isQueryDeprMethod;
    private boolean isQueryMeasureUnitWL;
    private boolean isQueryCurrency;
    private boolean isVirtualCompany;
    private boolean isQueryKeeper;
    private boolean isQueryDept;
    private boolean isQueryMeasureUnit;
    private boolean isQueryStoreCity;
    private boolean isQueryCompany;
    private boolean isQueryAcntAssetAccount;
    private boolean isQueryAcntDeprAccount;
    private boolean isQueryAcntDecAccount;
    private boolean isQueryAssetCat;
    private boolean isQueryOriginMethod;
    private boolean isQueryUseStatus;
    private boolean isQueryEconomicPurp;
    private boolean isQueryEvalDeprMethod;
    private boolean isQueryEvalMeasureUnit;
    private boolean isQueryCostCenter;
    private boolean isQueryUseDepartment;
    private boolean isQueryUsePerson;
    private boolean isQueryOriginUnit;
    private static int seq = 0;

    @Override
    protected void initEvVar(EntityViewInfo ev) throws EASBizException, BOSException {
        Map cond = (Map)ev.get("customcond");
        Object company = cond.get("company");
        this.bNew = (Boolean)cond.get("new");
        this.bChange = (Boolean)cond.get("change");
        this.bPartclean = (Boolean)cond.get("partclean");
        this.bCompleteclean = (Boolean)cond.get("completeclean");
        this.FACURCARDID = cond.get("FACURCARDID") != null ? (String)cond.get("FACURCARDID") : null;
        this.isListAll = cond.get("isListAll") == null ? true : (Boolean)cond.get("isListAll");
        super.initEvVar(ev);
    }

    @Override
    protected CompanyOrgUnitInfo getRptCompany(Context ctx, EntityViewInfo ev) throws EASBizException, BOSException {
        Map cond = (Map)ev.get("customcond");
        if (cond == null) {
            return ContextUtil.getCurrentFIUnit((Context)ctx);
        }
        Object companys = cond.get("company");
        if (companys != null && companys instanceof CompanyOrgUnitInfo[]) {
            CompanyOrgUnitInfo[] companyArray = (CompanyOrgUnitInfo[])companys;
            if (companyArray.length == 1) {
                return companyArray[0];
            }
            for (int i = 0; i < companyArray.length; ++i) {
                if (companyArray[i].isIsBizUnit()) continue;
                return companyArray[i];
            }
            return ContextUtil.getCurrentFIUnit((Context)ctx);
        }
        return ContextUtil.getCurrentFIUnit((Context)ctx);
    }

    @Override
    protected void tableFieldConfig(FaDBUtilConfig cf) {
        cf.addFiledSize("bCostCenter", 800);
        cf.addFiledSize("CostCenter", 800);
        cf.addFiledSize("bUseDepartment", 800);
        cf.addFiledSize("UseDepartment", 800);
        cf.addFiledSize("bUsePerson", 800);
        cf.addFiledSize("UsePerson", 800);
        cf.addFiledSize("BORIGINUNIT", 800);
        cf.addFiledSize("ORIGINUNIT", 800);
        cf.addFiledSize("FNAME_L2", 800);
        cf.addFiledSize("bSPECS", 800);
    }

    @Override
    protected void buildSql() throws BOSException {
        this.select = this.getSumSelectSql(true, false);
        this.buildResultSql();
    }

    @Override
    protected void buildData() throws BOSException {
        boolean b;
        boolean allFalse = this.bNew || this.bChange || this.bPartclean || this.bCompleteclean;
        boolean bl = b = this.bNew && this.bChange && (this.bPartclean || this.bCompleteclean);
        if (!allFalse || b) {
            this.addDataTempTable(this.getNewCardSql());
            String sql = "insert into " + this.tempTable + " SELECT * FROM (" + this.getChangeDetailSql() + ") tempTable";
            DbUtil.execute((Context)this.ctx, (String)FaLocalUtils.transformLocal((Context)this.ctx, (String)sql));
            sql = "insert into " + this.tempTable + " SELECT * FROM (" + this.getCleanCardSql() + ") tempTable";
            DbUtil.execute((Context)this.ctx, (String)FaLocalUtils.transformLocal((Context)this.ctx, (String)sql));
        } else if (this.bNew && this.bChange) {
            this.addDataTempTable(this.getNewCardSql());
            String sql = "insert into " + this.tempTable + " SELECT * FROM (" + this.getChangeDetailSql() + ") tempTable";
            DbUtil.execute((Context)this.ctx, (String)FaLocalUtils.transformLocal((Context)this.ctx, (String)sql));
        } else if (this.bNew && (this.bPartclean || this.bCompleteclean)) {
            this.addDataTempTable(this.getNewCardSql());
            String sql = "insert into " + this.tempTable + " SELECT * FROM (" + this.getCleanCardSql() + ") tempTable";
            DbUtil.execute((Context)this.ctx, (String)FaLocalUtils.transformLocal((Context)this.ctx, (String)sql));
        } else if (this.bChange && (this.bPartclean || this.bCompleteclean)) {
            this.addDataTempTable(this.getChangeDetailSql());
            String sql = "insert into " + this.tempTable + " SELECT * FROM (" + this.getCleanCardSql() + ") tempTable";
            DbUtil.execute((Context)this.ctx, (String)FaLocalUtils.transformLocal((Context)this.ctx, (String)sql));
        } else if (this.bNew) {
            this.addDataTempTable(this.getNewCardSql());
        } else if (this.bChange) {
            this.addDataTempTable(this.getChangeDetailSql());
        } else if (this.bPartclean || this.bCompleteclean) {
            this.addDataTempTable(this.getCleanCardSql());
        }
        StringBuffer defSql = this.getPropertyValueFromNewCardSql();
        this.scTempTable = FaLocalUtils.addDataTempTable((Context)this.ctx, (String)defSql.toString());
        Connection con = null;
        Statement st = null;
        try {
            String sumSql;
            con = EJBFactory.getConnection((Context)this.ctx);
            st = con.createStatement();
            this.setCostCenter();
            st.addBatch(this.getUseDepartment(true, false));
            st.addBatch(this.getUseDepartment(false, false));
            st.addBatch(this.getUseDepartment(false, true));
            if (this.isShowNotAudit) {
                st.addBatch(this.getCurUseDepartment());
            }
            st.addBatch(this.getUpdateBakUseDSql());
            st.addBatch(this.getUsePerson(true, false));
            st.addBatch(this.getUsePerson(false, false));
            st.addBatch(this.getUsePerson(false, true));
            if (this.isShowNotAudit) {
                st.addBatch(this.getCurUsePerson());
            }
            st.addBatch(this.getUpdateBakUsePSql());
            if (this.isVirCompany && (sumSql = this.sumOption.getSumSql(this.tempTable, this.getSumSelectSql(), null, null, null, true, false)) != null && sumSql.trim().length() > 0) {
                st.addBatch(sumSql);
            }
            st.executeBatch();
        }
        catch (SQLException exc) {
            try {
                throw new BOSException((Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(st, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)st, (Connection)con);
    }

    private void setCostCenter() throws BOSException {
        FaDaoSqlObject tempCostDao = new FaDaoSqlObject();
        tempCostDao.setFrom(this.tempTable);
        tempCostDao.setSelect("fid,cardid,bakcardid,changetype");
        String sql = tempCostDao.getSql().toString();
        IRowSet row = DbUtil.executeQuery((Context)this.ctx, (String)sql);
        try {
            String updateSql = "UPDATE " + this.tempTable + " SET costCenter = ?, bCostCenter = ? WHERE fid = ?";
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
            while (row.next()) {
                String costCenterLName;
                String cardId;
                String id;
                int changeType = row.getInt("changetype");
                if (changeType == 1) {
                    id = row.getString("fid");
                    cardId = row.getString("cardid");
                    if (this.isShowNotAudit) {
                        String bosType = BOSUuid.read((String)cardId).getType().toString();
                        if ("42AC39EC".equals(bosType)) {
                            String curCostCenterLName = FaLocalUtils.getCostCenterLNameByCardId((Context)this.ctx, (String)cardId, (int)1);
                            paramsList.add(new Object[]{curCostCenterLName, curCostCenterLName, id});
                            continue;
                        }
                        String costCenterLName2 = FaLocalUtils.getCostCenterLNameByCardId((Context)this.ctx, (String)cardId, (int)3);
                        paramsList.add(new Object[]{costCenterLName2, costCenterLName2, id});
                        continue;
                    }
                    costCenterLName = FaLocalUtils.getCostCenterLNameByCardId((Context)this.ctx, (String)cardId, (int)3);
                    paramsList.add(new Object[]{costCenterLName, costCenterLName, id});
                    continue;
                }
                if (changeType == 2) {
                    id = row.getString("fid");
                    cardId = row.getString("cardid");
                    costCenterLName = FaLocalUtils.getCostCenterLNameByCardId((Context)this.ctx, (String)cardId, (int)2);
                    String bakCardId = row.getString("bakcardid");
                    String bCostCenterLName = FaLocalUtils.getCostCenterLNameByCardId((Context)this.ctx, (String)bakCardId, (int)3);
                    paramsList.add(new Object[]{costCenterLName, bCostCenterLName, id});
                    continue;
                }
                id = row.getString("fid");
                cardId = row.getString("cardid");
                costCenterLName = FaLocalUtils.getCostCenterLNameByCardId((Context)this.ctx, (String)cardId, (int)2);
                paramsList.add(new Object[]{costCenterLName, costCenterLName, id});
            }
            DbUtil.executeBatch((Context)this.ctx, (String)updateSql, paramsList);
        }
        catch (SQLException e) {
            throw new BOSException("Sql execute exception : " + sql, (Throwable)e);
        }
    }

    private String getCostCenter(boolean isBakCard, boolean isUpdateBak) throws BOSException {
        StringBuffer sql = new StringBuffer();
        FaDaoSqlObject costDao = new FaDaoSqlObject();
        String table = isBakCard || isUpdateBak ? "T_FA_FaBakCostCenter" : "T_FA_FaBizCostCenter";
        String column = isBakCard || isUpdateBak ? "FFaBakCardID" : "FFaBizCardID";
        sql.append("update ").append(this.tempTable).append(" SET ");
        sql.append(isUpdateBak ? "bCOSTCENTER" : "COSTCENTER").append(" = (");
        costDao.setSelect(" MAX(FSeq) AS maxSeq ");
        StringBuffer costFrom = new StringBuffer(table);
        costFrom.append(" cost INNER JOIN ").append(this.tempTable).append(" temp ON temp.").append(isUpdateBak ? "BakCardID" : "CardID").append(" = cost.").append(column);
        costDao.setFrom(costFrom.toString());
        IRowSet row = DbUtil.executeQuery((Context)this.ctx, (String)costDao.getSql());
        int n = 1;
        try {
            if (row != null && row.next()) {
                n = row.getInt("maxSeq");
            }
        }
        catch (SQLException e) {
            throw new BOSException("Sql execute exception : " + costDao.getSql(), (Throwable)e);
        }
        if (n > 10) {
            n = 10;
        }
        StringBuffer select = new StringBuffer();
        StringBuffer from = new StringBuffer();
        select.append("substring(account.FNumber ||'-'|| account." + this.fName + " || ' ' || TO_CHAR(facost.FApportionScale, 'NUMBER' ,2) || '%'|| ' ' || facost.FAsstActLName ");
        from.append(table + " facost ");
        from.append(" LEFT OUTER JOIN T_BD_AccountView AS account ON facost.FAccountViewID = account.FID ");
        for (int i = 2; i <= n; ++i) {
            select.append(" || ( case ISNULL(facost").append(i).append(".FAccountViewID ");
            select.append("  ,'null') when 'null' THEN '' ELSE ' ;  '||account").append(i).append(".FNumber ||'-'|| account").append(i).append("." + this.fName);
            select.append("   || ' ' || TO_CHAR(facost").append(i).append(".FApportionScale, 'NUMBER' , 2) || '%'|| ' ' ||facost").append(i).append(".FAsstActLName ");
            select.append(i == 10 ? "||' ; ...' END)" : " END) ");
            from.append(" LEFT OUTER JOIN ").append(table).append(" facost").append(i);
            from.append(" ON (facost").append(i).append(".FSeq = ").append(i).append(" AND facost.").append(column);
            from.append(" = facost").append(i).append(".").append(column).append(") ");
            from.append(" LEFT OUTER JOIN T_BD_AccountView").append(" AS account").append(i);
            from.append(" ON (facost").append(i).append(".FAccountViewID = account").append(i).append(".FID)");
        }
        select.append(",1,800)");
        costDao.setSelect(select.toString());
        costDao.setFrom(from.toString());
        StringBuffer where = new StringBuffer();
        where.append(this.tempTable).append(isUpdateBak ? ".BakCardId" : ".CardId ").append(" = facost.").append(column).append(" AND facost.FSeq = 1 ");
        costDao.setWhere(where.toString());
        sql.append(costDao.getSql()).append(")");
        sql.append(" WHERE CHANGETYPE ").append(isBakCard ? " = 1" : (isUpdateBak ? " = 2" : " != 1"));
        return sql.toString();
    }

    protected void deleteUnnecessaryData() throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("DELETE FROM ");
        sql.append(this.tempTable).append(" WHERE ");
        sql.append("ISSUM=0 ");
        if (this.isListStyle && this.isShowNoCardCompany) {
            sql.append("AND CARDID IS NULL");
        }
        DbUtil.execute((Context)this.ctx, (String)sql.toString());
    }

    protected String getSumSqlDistinctSelect() {
        StringBuffer sql = new StringBuffer();
        sql.append("CardID, ");
        sql.append("cardNum,");
        sql.append("assetAmt,");
        sql.append("InputTax,");
        sql.append("ADDONS, ");
        sql.append("AddonFare, ");
        sql.append("treatmentIncome, ");
        sql.append("ASSETVALUE, ");
        sql.append("INITEVALVALUE, ");
        sql.append("EVALMINUSASSETVALUE, ");
        sql.append("BUYVALUE, ");
        sql.append("BUYACCUDEPR, ");
        sql.append("DEPRTTERM, ");
        sql.append("ACCUDEPR, ");
        sql.append("ACCUDEPRYEAR, ");
        sql.append("NEATREMVALUE, ");
        sql.append("NEATVALUE, ");
        sql.append("DECVALUE, ");
        sql.append("NEATAMT,");
        sql.append("fairValue");
        sql.append(this.def.getNumFieldForSumPart());
        sql.append(",EVALASSETVALUE, ");
        sql.append(" EVALADDDEPR, ");
        sql.append(" EVALYEARDEPR, ");
        sql.append(" EVALDEPRTTERM, ");
        sql.append(" EVALNEATVALUE, ");
        sql.append(" EVALREMVALUE, ");
        sql.append(" EVALDECVALUE, ");
        sql.append(" EVALNEATAMT ");
        return sql.toString();
    }

    private String getSumSelectSql(boolean isSum, boolean isListSum) {
        StringBuffer sql = new StringBuffer();
        if (this.isListStyle) {
            sql.append(isListSum ? "N'" + this.total + "' AS ASSETNUMBER, " : "TO_CHAR(null) AS ASSETNUMBER, ");
            sql.append("TO_CHAR(null) AS barCode, ");
            sql.append("TO_CHAR(null) AS oldernumber, ");
            sql.append("TO_CHAR(null) AS GROUPNUMBER, ");
            sql.append("TO_CHAR(null) AS ASSETNAME, ");
            if (this.isQueryAssetCat) {
                sql.append("TO_CHAR(null) AS ASSETCAT_NAME, ");
            }
        }
        sql.append("TO_CHAR(null) AS CardID, ");
        sql.append(isSum ? "sum(cardNum)" : "0").append(" AS cardNum, ");
        sql.append(isSum ? "sum(assetAmt)" : "0").append(" AS ASSETAMT, ");
        if (this.isListStyle) {
            if (this.isQueryMeasureUnit) {
                sql.append("TO_CHAR(null) AS MEASUREUNIT_NAME, ");
            }
            sql.append("CONVERT(DATETIME,null) AS ACCOUNTDATE, ");
            sql.append("CONVERT(DATETIME,null) AS FIACCOUNTDATE, ");
            if (this.isQueryOriginMethod) {
                sql.append("TO_CHAR(null) AS ORIGINMETHOD_NAME, ");
            }
            sql.append("TO_CHAR(null) AS OriginType, ");
            sql.append("TO_CHAR(null) AS OriginUnit, ");
            if (this.isQueryUseStatus) {
                sql.append("TO_CHAR(null) AS USESTATUS_NAME, ");
            }
            if (this.isQueryEconomicPurp) {
                sql.append("TO_CHAR(null) AS ECONOMICPURP_NAME, ");
            }
            if (this.isQueryStoreCity) {
                sql.append("TO_CHAR(null) AS STORECITY_NAME, ");
            }
            sql.append("TO_CHAR(null) AS USEDEPARTMENT, ");
            sql.append("TO_CHAR(null) AS USEPERSON, ");
            sql.append("TO_CHAR(null) AS CostCenter, ");
            sql.append("TO_CHAR(null) AS SPECS, ");
            sql.append("TO_CHAR(null) AS PAREA, ");
            sql.append("TO_CHAR(null) AS MFR, ");
            sql.append("CONVERT(DATETIME,null) AS LEVFRDATE, ");
            sql.append("TO_CHAR(null) AS PAPERNO, ");
            sql.append("TO_INT(null) AS ISOVERAGED, ");
            if (this.isQueryDeprMethod) {
                sql.append("TO_CHAR(null) AS DEPRMETHOD_NAME, ");
            }
            if (this.isQueryMeasureUnitWL) {
                sql.append("TO_CHAR(null) AS MEASUREUNITWL_NAME, ");
            }
            sql.append("TO_CHAR(null) AS CURRENCY_NAME, ");
            sql.append("TO_INT(null) AS PREC, ");
            sql.append("TO_INT(null) AS EXRATEPREC, ");
            sql.append("TO_INT(null) AS BASEPREC, ");
            sql.append("TO_DECIMAL(null) AS EXRATE, ");
            sql.append("TO_DECIMAL(null) AS ORIGINAMT, ");
            sql.append("TO_DECIMAL(null) AS TAXORIGINAMT, ");
            sql.append("TO_DECIMAL(null) AS INPUTTAXRATE, ");
            sql.append("TO_INT(null) AS ISDEDUCT, ");
        }
        if (isSum) {
            sql.append("sum(InputTax) AS InputTax, ");
            sql.append("sum(Addons) AS ADDONS, ");
            sql.append("sum(AddonFare) AS AddonFare, ");
            sql.append("sum(treatmentIncome) AS treatmentIncome, ");
            sql.append("sum(AssetValue) AS ASSETVALUE, ");
            sql.append("sum(INITEVALVALUE) AS INITEVALVALUE, ");
            sql.append("sum(EVALMINUSASSETVALUE) AS EVALMINUSASSETVALUE, ");
            sql.append("sum(BuyValue) AS BUYVALUE, ");
            sql.append("sum(BuyAccuDepr) AS BUYACCUDEPR, ");
        } else {
            sql.append("0 AS InputTax, ");
            sql.append("0 AS ADDONS, ");
            sql.append("0 AS AddonFare, ");
            sql.append("0 AS treatmentIncome, ");
            sql.append("0 AS ASSETVALUE, ");
            sql.append("TO_DECIMAL(null) AS INITEVALVALUE, ");
            sql.append("TO_DECIMAL(null) AS EVALMINUSASSETVALUE, ");
            sql.append("0 AS BUYVALUE, ");
            sql.append("0 AS BUYACCUDEPR, ");
        }
        if (this.isListStyle) {
            sql.append("CONVERT(DATETIME,null) AS DELIVERDATE, ");
            sql.append("CONVERT(DATETIME,null) AS STARTUSEDATE, ");
            sql.append("TO_DECIMAL(null) AS USEYEARS, ");
            sql.append("TO_INT(null) AS USETERMCOUNT, ");
            sql.append("TO_INT(null) AS DEPRTERMCOUNT, ");
            sql.append("TO_INT(null) AS LEFTTERMCONT, ");
            sql.append("TO_INT(null) AS EVALLEFTPERIOD, ");
            sql.append("TO_DECIMAL(null) AS MONTHDEPRERATE, ");
        }
        if (isSum) {
            sql.append("sum(DeprTTerm) AS DEPRTTERM, ");
            sql.append("sum(AccuDepr) AS ACCUDEPR, ");
            sql.append("sum(ACCUDEPRYEAR) AS ACCUDEPRYEAR, ");
            sql.append("sum(NeatRemValue) AS NEATREMVALUE, ");
        } else {
            sql.append("0 AS DEPRTTERM, ");
            sql.append("0 AS ACCUDEPR, ");
            sql.append("0 AS ACCUDEPRYEAR, ");
            sql.append("0 AS NEATREMVALUE, ");
        }
        if (this.isListStyle) {
            sql.append("TO_DECIMAL(null) AS NEATLEFTRATE, ");
        }
        if (isSum) {
            sql.append("sum(NeatValue) AS NEATVALUE, ");
            sql.append("sum(DecValue) AS DECVALUE, ");
            sql.append("sum(NeatAmt) AS NEATAMT, ");
            sql.append("sum(fairValue) AS fairValue, ");
        } else {
            sql.append("0 AS NEATVALUE, ");
            sql.append("0 AS DECVALUE, ");
            sql.append("0 AS NEATAMT,");
            sql.append("0 AS fairValue, ");
        }
        sql.append("TO_CHAR(null) AS COMPANY_ID");
        if (this.isListStyle) {
            if (this.isQueryAcntAssetAccount) {
                sql.append(", TO_CHAR(null) AS ACNTASSET_NAME ");
            }
            if (this.isQueryAcntDeprAccount) {
                sql.append(", TO_CHAR(null) AS ACNTACCDEPR_NAME ");
            }
            if (this.isQueryAcntDecAccount) {
                sql.append(", TO_CHAR(null) AS ACNTDECVAL ");
            }
            sql.append(", TO_CHAR(null) AS COMPANY_NAME, ");
            if (this.isQueryDept) {
                sql.append("TO_CHAR(null) AS DEPT_NAME, ");
            }
            if (this.isQueryKeeper) {
                sql.append("TO_CHAR(null) AS KEEPER_NAME, ");
            }
            sql.append("TO_DECIMAL(null) AS WRTYPERIOD,");
            sql.append("TO_CHAR(null) AS WRTYNUMBER ,");
            sql.append("TO_CHAR(null) AS REMARK");
        }
        if (isSum) {
            sql.append(", 1 AS isSum ");
        } else {
            sql.append(", 0 AS isSum ");
        }
        if (this.isVirCompany && !this.isInitPeriod) {
            sql.append(",-1 AS ISCURCARD");
        }
        if (isSum) {
            sql.append(this.def.getSelectSumPart(""));
        } else {
            String tempSql = this.def.getSelectPart("");
            if (!(isSum || isListSum || tempSql == null || "".equals(tempSql.trim()))) {
                String[] str = tempSql.split(",");
                StringBuffer bufferSql = new StringBuffer();
                for (int i = 0; i < str.length; ++i) {
                    if (str[i] == null || "".equals(str[i].trim())) continue;
                    bufferSql.append(", null AS " + str[i]);
                }
                tempSql = bufferSql.toString();
            }
            sql.append(tempSql);
        }
        if (isSum) {
            sql.append(", sum(EvalAssetValue) AS EVALASSETVALUE, ");
            sql.append("sum(EvalAddDepr) AS EVALADDDEPR, ");
            sql.append("sum(EvalYearDepr) AS EVALYEARDEPR, ");
            sql.append("sum(EvalDeprTTerm) AS EVALDEPRTTERM, ");
        } else {
            sql.append(", 0 AS EVALASSETVALUE, ");
            sql.append("0 AS EVALADDDEPR, ");
            sql.append("0 AS EVALYEARDEPR, ");
            sql.append("0 AS EVALDEPRTTERM, ");
        }
        if (this.isListStyle) {
            sql.append("TO_INT(null) AS EVALDEPRPERIODNUM, ");
        }
        if (isSum) {
            sql.append("sum(EvalNeatValue) AS EVALNEATVALUE, ");
        } else {
            sql.append("0 AS EVALNEATVALUE, ");
        }
        if (this.isListStyle) {
            sql.append("TO_DECIMAL(null) AS EVALNEATLEFTRATE, ");
        }
        if (isSum) {
            sql.append("sum(EvalRemValue) AS EVALREMVALUE, ");
            sql.append("sum(EvalDecValue) AS EVALDECVALUE, ");
            sql.append("sum(EvalNeatAmt) AS EVALNEATAMT ");
        } else {
            sql.append("0 AS EVALREMVALUE, ");
            sql.append("0 AS EVALDECVALUE, ");
            sql.append("0 AS EVALNEATAMT ");
        }
        if (this.isListStyle) {
            if (this.isQueryEvalDeprMethod) {
                sql.append(", TO_CHAR(null) AS EVALDEPRMODE ");
            }
            sql.append(", TO_DECIMAL(null) AS EVALMONTHRATE, ");
            sql.append("CONVERT(DATETIME,null) as EVALREINACCOUNTDATE, ");
            sql.append("TO_INT(null) AS EVALUSETERMCOUNT, ");
            sql.append("TO_INT(null) AS EVALTAXLEFTPERIOD ");
            if (this.isQueryEvalMeasureUnit) {
                sql.append(", TO_CHAR(null) AS EVALMEASUREUNITWL ");
            }
        }
        return sql.toString();
    }

    private String getMonCardSQL() throws BOSException {
        String sqlperm;
        FaDaoSqlObject sql = new FaDaoSqlObject();
        StringBuffer select = new StringBuffer();
        select.append("CARD.FPropertyValueID,");
        select.append("CARD.FID AS FID,CARD.FNumber,CARD.FBarCode,CARD.FoldNumber,CARD.fgroupNumber,CARD.FAssetName,CARD.FAssetAmt,CARD.FAccountDate,CARD.FFiAccountDate,CARD.FEconomicPurpID,CARD.FSpecs,CARD.FPArea,CARD.FMfr,CARD.FLevFrDate,");
        select.append("CARD.FPaperNo,CARD.FExRate, case when card.fbizStatus = '0499' or card.fbizStatus = '0599' then 0 else card.FOriginAmt end AS FOriginAmt,case when card.fbizStatus = '0499' or card.fbizStatus = '0599' then 0 else card.FInputTax end AS InputTax,case when card.fbizStatus = '0499' or card.fbizStatus = '0599' then 0 else CARD.FAddons end AS FAddons,case when card.fbizStatus = '0499' or card.fbizStatus = '0599' then 0 else CARD.FAddonFare end AS FAddonFare,case when card.fbizStatus = '0499' or card.fbizStatus = '0599' then 0 else CARD.FTreatmentIncome end AS FTreatmentIncome, case when card.fbizStatus = '0499' or card.fbizStatus = '0599' then 0 else card.FAssetValue end AS FAssetValue,CARD.FIsEvaledBefore,  case when card.fbizStatus = '0499' or card.fbizStatus = '0599' then 0 else card.FInitEvalValue end AS FInitEvalValue, case when card.fbizStatus = '0499' or card.fbizStatus = '0599' then 0 else card.FBuyValue end AS FBuyValue,case when card.fbizStatus = '0499' or card.fbizStatus = '0599' then 0 else CARD.FBuyAccuDepr end AS FBuyAccuDepr,CARD.FIsOveraged,");
        select.append("CARD.FDeliverDate,CARD.FStartUseDate,CARD.FUseYears,CARD.FUseTermCount,CARD.FDeprTermCount,CARD.FEvalLeftPeriod,CARD.FMonthDepreRate,  case when card.fbizStatus = '0499' or card.fbizStatus = '0599' then 0 else card.FAccuDepr end AS FAccuDepr, card.FDeprTTerm  AS FDeprTTerm,");
        select.append("CARD.fCheckedStatus,CARD.FEffectedStatus,CARD.fDeletedStatus, case when card.fbizStatus = '0499' or card.fbizStatus = '0599' then 0 else card.FACCUDEPRTYEAR end AS FACCUDEPRTYEAR, case when card.fbizStatus = '0499' or card.fbizStatus = '0599' then 0 else card.FNeatRemValue end AS FNeatRemValue,CARD.FNeatLeftRate, case when card.fbizStatus = '0499' or card.fbizStatus = '0599' then 0 else card.FNeatValue end AS FNeatValue,CARD.FDecValue, case when card.fbizStatus = '0499' or card.fbizStatus = '0599' then 0 else card.FNeatAmt end AS FNeatAmt,case when card.fbizStatus = '0499' or card.fbizStatus = '0599' then 0 else CARD.FFairValue end AS FFairValue,CARD.FRemark,");
        select.append("CARD.FAccountAssetID,CARD.FAccountAccuDeprID,CARD.FAccountDecValueID, ");
        select.append("CARD.FWrtyPeriod,CARD.FWrtyNumber,");
        select.append("CARD.FDeprMethodID,CARD.FMeasureUnitWLID,CARD.FCurrencyID,CARD.FKeeperID AS FKeeperID,CARD.FDeptID,CARD.FAssetCatID,CARD.FMeasureUnitID AS FMeasureUnitID,");
        select.append("CARD.FOriginType,CARD.FOriginUnit AS FOriginUnitID,CARD.FOriginMethodID,CARD.FUseStatusID,CARD.FStoreCityID,CARD.FCompanyID,CARD.fHasNew,CARD.fHasChanged,CARD.fHasCleared");
        if (this.isVirCompany && !this.isInitPeriod) {
            select.append(",0 as isCurCard");
        }
        select.append(",case when card.fbizStatus = '0499' or card.fbizStatus = '0599' then 0 else CARD.FEvalAssetValue end AS FEvalAssetValue,case when card.fbizStatus = '0499' or card.fbizStatus = '0599' then 0 else CARD.FEvalAddDepr end AS FEvalAddDepr,case when card.fbizStatus = '0499' or card.fbizStatus = '0599' then 0 else CARD.FEvalYearDepr end AS FEvalYearDepr,CARD.FEvalDeprTTerm,CARD.FEvalDeprPeriodNum,case when card.fbizStatus = '0499' or card.fbizStatus = '0599' then 0 else CARD.FEvalNeatValue end AS FEvalNeatValue,CARD.FEvalNeatLeftRate,case when card.fbizStatus = '0499' or card.fbizStatus = '0599' then 0 else CARD.FEvalRemValue end AS FEvalRemValue,CARD.FEvalDecValue,case when card.fbizStatus = '0499' or card.fbizStatus = '0599' then 0 else CARD.FEvalNeatAmt end AS FEvalNeatAmt,CARD.FEvalDeprModeID,CARD.FEvalMonthRate,CARD.FEvalReInAccountDate,CARD.FEvalUseTermCount,CARD.FEvalTaxLeftPeriod,CARD.FEvalMeasureUnitWL ");
        String join = this.isInitPeriod ? " LEFT OUTER JOIN " : " INNER JOIN ";
        StringBuffer from = new StringBuffer("T_FA_FaMonCard CARD").append(join).append("T_BD_Period PERIOD ON CARD.FFaPeriodID = PERIOD.FID");
        from.append(" left outer join t_fa_clearbillentry ce on ce.fcurcardid = card.ffacurcardid ");
        from.append(" left outer join t_fa_clearbill cb on cb.fid = ce.fentryid ");
        if (this.filter != null && (this.filter.indexOf("asstActItem.fname_l2") != -1 || this.filter.indexOf("asstActType.fnumber") != -1 || this.filter.indexOf("accountView1.fnumber") != -1) || this.sumOption.isHasAsstActItemSum()) {
            from.append(" INNER JOIN T_FA_FaMonCostCenter AS FACOSTCENTER ON CARD.FID = FACOSTCENTER.FFaMonCardID");
            from.append(" LEFT OUTER JOIN T_FA_FAMonASSTACTCOMPOSIT COMPOSIT ON COMPOSIT.FFAMonCOSTCENTERID = FACOSTCENTER.FID");
        }
        if (this.filter != null && (this.filter.indexOf("asstActItem.fname_l2") != -1 || this.filter.indexOf("asstActType.fnumber") != -1) || this.sumOption.isHasAsstActItemSum()) {
            select.append(",COMPOSIT.FAsstActItem AS FAsstActItem, COMPOSIT.FAsstActtype FAsstActtypeID");
        }
        if (this.filter != null && this.filter.indexOf("accountView1.fnumber") != -1) {
            select.append(",FACOSTCENTER.FAccountViewID AS FAccountViewID");
        }
        if ((sqlperm = this.getPermisionJoinSQL("FADEPARTMENT")).length() > 0 || this.filter != null && this.filter.indexOf("useDepartment.fnumber") != -1 || this.sumOption.isHasUseDepartmentSum()) {
            from.append(" INNER JOIN T_FA_FaMonDepartment AS FADEPARTMENT ON CARD.FID = FADEPARTMENT.FFaMonCardID ");
            select.append(",FADEPARTMENT.FUseDepartmentID AS FUseDepartmentID");
            from.append(this.getPermisionJoinSQL("FADEPARTMENT"));
        }
        if (this.isFilterByFacility) {
            from.append(" LEFT OUTER JOIN T_FA_FaMonFacility AS FACILITY ON CARD.FID = FACILITY.FFaMonCardID ");
            select.append(",FACILITY.FID AS FACILITYID");
        }
        if (this.isUserDefineSort || this.filter != null && this.filter.indexOf("userdefine.fnumber") != -1) {
            join = this.isUserDefineSort ? " INNER JOIN " : " LEFT OUTER JOIN ";
            from.append(join + " T_FA_UserDefineEntry AS userDefineEntry ON CARD.FFaCurCardID = userDefineEntry.FAssetCardID ");
            select.append(",userDefineEntry.FUserDefineSortID AS FUserDefineSortID");
        }
        StringBuffer where = new StringBuffer();
        where.append(this.getCompanyFilter(false));
        if (this.isInitPeriod) {
            where.append("AND CARD.FFaPeriodID IS NULL");
        } else {
            where.append("AND period.fperiodyear = ? AND period.fperiodnumber = ?");
            this.params.addInt(this.startYear);
            this.params.addInt(this.startNumber);
        }
        where.append(" AND CARD.FLaterPeriodData = 0");
        sql.setSelect(select.toString());
        sql.setFrom(from.toString());
        sql.setWhere(where.toString());
        return sql.getSql();
    }

    private String getPermisionJoinSQL(String tableName) throws BOSException {
        String userID = ContextUtil.getCurrentUserInfo((Context)this.ctx).getId().toString();
        String cuID = ContextUtil.getCurrentCtrlUnit((Context)this.ctx).getId().toString();
        String depPermissionJoinSQL = "";
        try {
            depPermissionJoinSQL = FaChangeListDao.innerJoinOUPermissionSql(tableName, userID, cuID, this.ctx);
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        return depPermissionJoinSQL;
    }

    public static String innerJoinOUPermissionSql(String joinTable, String userId, String orgId, Context ctx) throws EASBizException, BOSException {
        String sql = "";
        String rule = PermissionServiceProviderFactory.getLocalInstance((Context)ctx).getPermissionRule((IObjectPK)new ObjectUuidPK(userId), (IObjectPK)new ObjectUuidPK(orgId), "Admin_View");
        if (rule != null && !" WHERE ( id = '00000000-0000-0000-0000-00000000000013B7DE7F' OR id <> '00000000-0000-0000-0000-00000000000013B7DE7F' )".equalsIgnoreCase(rule)) {
            String adminViewSQL = PermissionFactory.getLocalInstance((Context)ctx).getQueryPermissionSQL((IObjectPK)new ObjectUuidPK(userId), (IObjectPK)new ObjectUuidPK(orgId), "Admin_View");
            String pt = "PT" + FaChangeListDao.seq();
            sql = " inner join \n(" + adminViewSQL + ")\n " + pt + " on " + pt + ".ID=" + joinTable + ".FUseDepartmentID  ";
        }
        return sql;
    }

    public static synchronized int seq() {
        if (seq == Short.MAX_VALUE) {
            seq = -1;
        }
        return ++seq;
    }

    @Override
    protected List buildLevelSumSqlList(List sumOption) throws BOSException {
        ArrayList<LevelSumSqlInfo> levelSumSqlList = new ArrayList<LevelSumSqlInfo>();
        if (this.isVirCompany) {
            levelSumSqlList.add(this.getLevelSumSqlInfo(this.ctx, "changeDate", 0, false));
        }
        levelSumSqlList.addAll(super.buildLevelSumSqlList(sumOption));
        return levelSumSqlList;
    }

    private StringBuffer getOriginUnitSql() {
        StringBuffer sql = new StringBuffer();
        sql.append("(select fid, fname_l2, fnumber from t_bd_supplier");
        sql.append(" union ");
        sql.append("select fid, fname_l2, fnumber from t_bd_customer");
        sql.append(" union ");
        sql.append("select fid, fname_l2, fnumber from t_org_company)");
        return sql;
    }

    private String getCurCardSQL() throws BOSException {
        String sqlperm;
        FaDaoSqlObject sql = new FaDaoSqlObject();
        StringBuffer select = new StringBuffer();
        select.append("CARD.FPropertyValueID,");
        select.append("CARD.FID AS FID,CARD.FNumber,CARD.FBarCode,CARD.FoldNumber,CARD.fgroupNumber ,CARD.FAssetName,CARD.FAssetAmt,CARD.FAccountDate,CARD.FFiAccountDate,CARD.FEconomicPurpID,CARD.FSpecs,CARD.FPArea,CARD.FMfr,CARD.FLevFrDate,");
        select.append("CARD.FPaperNo,CARD.FExRate,case when card.fbizStatus = '0499' or card.fbizStatus = '0599' then 0 else card.FOriginAmt end AS FOriginAmt,case when card.fbizStatus = '0499' or card.fbizStatus = '0599' then 0 else card.FInputTax end AS InputTax,case when card.fbizStatus = '0499' or card.fbizStatus = '0599' then 0 else CARD.FAddons end AS FAddons,case when card.fbizStatus = '0499' or card.fbizStatus = '0599' then 0 else CARD.FAddonFare end AS FAddonFare,case when card.fbizStatus = '0499' or card.fbizStatus = '0599' then 0 else CARD.FTreatmentIncome end AS FTreatmentIncome,case when card.fbizStatus = '0499' or card.fbizStatus = '0599' then 0 else card.FAssetValue end AS FAssetValue,CARD.FIsEvaledBefore,case when card.fbizStatus = '0499' or card.fbizStatus = '0599' then 0 else card.FInitEvalValue end AS FInitEvalValue,case when card.fbizStatus = '0499' or card.fbizStatus = '0599' then 0 else card.FBuyValue end AS FBuyValue, case when card.fbizStatus = '0499' or card.fbizStatus = '0599' then 0 else CARD.FBuyAccuDepr end AS FBuyAccuDepr,CARD.FIsOveraged,");
        select.append("CARD.FDeliverDate,CARD.FStartUseDate,CARD.FUseYears,CARD.FUseTermCount,CARD.FDeprTermCount,CARD.FEvalLeftPeriod,CARD.FMonthDepreRate,case when card.fbizStatus = '0499' or card.fbizStatus = '0599' then 0 else card.FAccuDepr end AS FAccuDepr,card.FDeprTTerm AS FDeprTTerm,");
        select.append("CARD.fCheckedStatus,CARD.FEffectedStatus,CARD.fDeletedStatus,case when card.fbizStatus = '0499' or card.fbizStatus = '0599' then 0 else card.FACCUDEPRTYEAR end AS FACCUDEPRTYEAR,case when card.fbizStatus = '0499' or card.fbizStatus = '0599' then 0 else card.FNeatRemValue end AS FNeatRemValue,CARD.FNeatLeftRate,case when card.fbizStatus = '0499' or card.fbizStatus = '0599' then 0 else card.FNeatValue end AS FNeatValue,CARD.FDecValue,case when card.fbizStatus = '0499' or card.fbizStatus = '0599' then 0 else card.FNeatAmt end AS FNeatAmt,case when card.fbizStatus = '0499' or card.fbizStatus = '0599' then 0 else CARD.FFairValue end AS FFairValue,CARD.FRemark,");
        select.append("CARD.FAccountAssetID,CARD.FAccountAccuDeprID,CARD.FAccountDecValueID, ");
        select.append("CARD.FWrtyPeriod,CARD.FWrtyNumber,");
        select.append("CARD.FDeprMethodID,CARD.FMeasureUnitWLID,CARD.FCurrencyID,CARD.FKeeperID AS FKeeperID,CARD.FDeptID,CARD.FAssetCatID,CARD.FMeasureUnitID AS FMeasureUnitID,");
        select.append("CARD.FOriginType,CARD.FOriginUnit AS FOriginUnitID,CARD.FOriginMethodID,CARD.FUseStatusID,CARD.FStoreCityID,CARD.FCompanyID,CARD.fHasNew,CARD.fHasChanged,CARD.fHasCleared");
        if (this.isVirCompany && !this.isInitPeriod) {
            select.append(",1 as isCurCard");
        }
        select.append(",case when card.fbizStatus = '0499' or card.fbizStatus = '0599' then 0 else CARD.FEvalAssetValue end AS FEvalAssetValue,case when card.fbizStatus = '0499' or card.fbizStatus = '0599' then 0 else CARD.FEvalAddDepr end AS FEvalAddDepr,case when card.fbizStatus = '0499' or card.fbizStatus = '0599' then 0 else CARD.FEvalYearDepr end AS FEvalYearDepr,CARD.FEvalDeprTTerm,CARD.FEvalDeprPeriodNum,case when card.fbizStatus = '0499' or card.fbizStatus = '0599' then 0 else CARD.FEvalNeatValue end AS FEvalNeatValue,CARD.FEvalNeatLeftRate,case when card.fbizStatus = '0499' or card.fbizStatus = '0599' then 0 else CARD.FEvalRemValue end AS FEvalRemValue,CARD.FEvalDecValue,case when card.fbizStatus = '0499' or card.fbizStatus = '0599' then 0 else CARD.FEvalNeatAmt end AS FEvalNeatAmt,CARD.FEvalDeprModeID,CARD.FEvalMonthRate,CARD.FEvalReInAccountDate,CARD.FEvalUseTermCount,CARD.FEvalTaxLeftPeriod,CARD.FEvalMeasureUnitWL ");
        StringBuffer from = new StringBuffer("T_FA_FaCurCard CARD");
        from.append(" left outer join t_fa_clearbillentry ce on ce.fcurcardid = card.fid ");
        from.append(" left outer join t_fa_clearbill cb on cb.fid = ce.fentryid ");
        if (this.filter != null && (this.filter.indexOf("asstActItem.fname_l2") != -1 || this.filter.indexOf("asstActType.fnumber") != -1 || this.filter.indexOf("accountView1.fnumber") != -1) || this.sumOption.isHasAsstActItemSum()) {
            from.append(" INNER JOIN T_FA_FaCurCostCenter AS FACOSTCENTER ON CARD.FID = FACOSTCENTER.FFaCurCardID");
            from.append(" LEFT OUTER JOIN T_FA_FACURASSTACTCOMPOSIT COMPOSIT ON COMPOSIT.FFACURCOSTCENTERID = FACOSTCENTER.FID");
        }
        if (this.filter != null && (this.filter.indexOf("asstActItem.fname_l2") != -1 || this.filter.indexOf("asstActType.fnumber") != -1) || this.sumOption.isHasAsstActItemSum()) {
            select.append(",COMPOSIT.FAsstActItem AS FAsstActItem, COMPOSIT.FAsstActtype FAsstActtypeID");
        }
        if (this.filter != null && this.filter.indexOf("accountView1.fnumber") != -1) {
            select.append(",FACOSTCENTER.FAccountViewID AS FAccountViewID");
        }
        if ((sqlperm = this.getPermisionJoinSQL("FADEPARTMENT")).length() > 0 || this.filter != null && this.filter.indexOf("useDepartment.fnumber") != -1 || this.sumOption.isHasUseDepartmentSum()) {
            from.append(" INNER JOIN T_FA_FaCurDepartment AS FADEPARTMENT ON CARD.FID = FADEPARTMENT.FFaCurCardID ");
            select.append(",FADEPARTMENT.FUseDepartmentID AS FUseDepartmentID");
            from.append(this.getPermisionJoinSQL("FADEPARTMENT"));
        }
        if (this.isFilterByFacility) {
            from.append(" LEFT OUTER JOIN T_FA_FaCurFacility AS FACILITY ON CARD.FID = FACILITY.FFaCurCardID ");
            select.append(",FACILITY.FID AS FACILITYID");
        }
        if (this.isUserDefineSort || this.filter != null && this.filter.indexOf("userdefine.fnumber") != -1) {
            String join = " LEFT OUTER JOIN";
            if (this.isUserDefineSort) {
                join = " INNER JOIN";
            }
            from.append(join + " T_FA_UserDefineEntry AS userDefineEntry ON CARD.FID = userDefineEntry.FAssetCardID ");
            select.append(",userDefineEntry.FUserDefineSortID AS FUserDefineSortID");
        }
        sql.setSelect(select.toString());
        sql.setFrom(from.toString());
        StringBuffer where = new StringBuffer();
        where.append(this.getCompanyFilter(true));
        where.append(" AND CARD.FLaterPeriodData = 0");
        sql.setWhere(where.toString());
        return sql.getSql();
    }

    private String getCardSelectSql() {
        StringBuffer sql = new StringBuffer();
        if (this.isListStyle) {
            sql.append("FACURCARD.FNumber AS ASSETNUMBER, ");
            sql.append("FACURCARD.FBarCode AS barCode, ");
            sql.append("FACURCARD.foldNumber AS oldernumber, ");
            sql.append("FACURCARD.fgroupNumber AS GROUPNUMBER, ");
            sql.append("FACURCARD.FAssetName AS ASSETNAME, ");
            if (this.isQueryAssetCat) {
                sql.append("ASSETCAT.").append(this.fName).append(" AS ASSETCAT_NAME, ");
            }
        }
        sql.append("FACURCARD.FID AS CardID, ");
        sql.append("1 AS cardNum, ");
        sql.append("FACURCARD.FAssetAmt AS ASSETAMT, ");
        if (this.isListStyle) {
            if (this.isQueryMeasureUnit) {
                sql.append("MEASUREUNIT.").append(this.fName).append(" AS MEASUREUNIT_NAME, ");
            }
            sql.append("FACURCARD.FAccountDate AS ACCOUNTDATE, ");
            sql.append("FACURCARD.FFiAccountDate AS FIACCOUNTDATE, ");
            if (this.isQueryOriginMethod) {
                sql.append("ORIGINMETHOD.").append(this.fName).append(" AS ORIGINMETHOD_NAME, ");
            }
            sql.append("TO_CHAR(FACURCARD.FOriginType) AS OriginType, ");
            sql.append("FACURCARD.FOriginUnitID AS OriginUnit, ");
            if (this.isQueryUseStatus) {
                sql.append("USESTATUS.").append(this.fName).append(" AS USESTATUS_NAME, ");
            }
            if (this.isQueryEconomicPurp) {
                sql.append("ECONOMICPURP.").append(this.fName).append(" AS ECONOMICPURP_NAME, ");
            }
            if (this.isQueryStoreCity) {
                sql.append("STORECITY.").append(this.fName).append(" AS STORECITY_NAME, ");
            }
            sql.append("FACURCARD.FSpecs AS USEDEPARTMENT, ");
            sql.append("FACURCARD.FSpecs AS USEPERSON, ");
            sql.append("FACURCARD.FSpecs AS CostCenter, ");
            sql.append("FACURCARD.FSpecs AS SPECS, ");
            sql.append("FACURCARD.FPArea AS PAREA, ");
            sql.append("FACURCARD.FMfr AS MFR, ");
            sql.append("FACURCARD.FLevFrDate AS LEVFRDATE, ");
            sql.append("FACURCARD.FPaperNo AS PAPERNO, ");
            sql.append("FACURCARD.FIsOveraged AS ISOVERAGED, ");
            if (this.isQueryDeprMethod) {
                sql.append("DEPRMETHOD.").append(this.fName).append(" AS DEPRMETHOD_NAME, ");
            }
            if (this.isQueryMeasureUnitWL) {
                sql.append("MEASUREUNITWL.").append(this.fName).append(" AS MEASUREUNITWL_NAME, ");
            }
            sql.append("CURRENCY.").append(this.fName).append(" AS CURRENCY_NAME, ");
            sql.append("CURRENCY.FPrecision AS PREC, ");
            sql.append("EXAUX.fprecision AS EXRATEPREC, ");
            sql.append("BASECURRENCY.FPrecision AS BASEPREC, ");
            sql.append("FACURCARD.FExRate AS EXRATE, ");
            sql.append("FACURCARD.FOriginAmt AS ORIGINAMT, ");
        }
        sql.append("FACURCARD.InputTax AS InputTax, ");
        sql.append("FACURCARD.FAddons AS ADDONS, ");
        sql.append("FACURCARD.FAddonFare AS AddonFare, ");
        sql.append("FACURCARD.FTreatmentIncome AS treatmentIncome, ");
        sql.append("FACURCARD.FAssetValue AS ASSETVALUE, ");
        sql.append("CASE FACURCARD.FIsEvaledBefore WHEN 1 THEN FACURCARD.FInitEvalValue ELSE TO_DECIMAL(NULL) END AS INITEVALVALUE,  ");
        sql.append("CASE FACURCARD.FIsEvaledBefore WHEN 1 THEN FACURCARD.FInitEvalValue - FACURCARD.FAssetValue ELSE TO_DECIMAL(NULL) END AS EVALMINUSASSETVALUE, ");
        sql.append("FACURCARD.FBuyValue AS BUYVALUE, ");
        sql.append("FACURCARD.FBuyAccuDepr AS BUYACCUDEPR, ");
        if (this.isListStyle) {
            sql.append("FACURCARD.FDeliverDate AS DELIVERDATE, ");
            sql.append("FACURCARD.FStartUseDate AS STARTUSEDATE, ");
            sql.append("FACURCARD.FUseYears AS USEYEARS, ");
            sql.append("FACURCARD.FUseTermCount AS USETERMCOUNT, ");
            sql.append("FACURCARD.FDeprTermCount AS DEPRTERMCOUNT, ");
            sql.append("(FACURCARD.FUseTermCount - FACURCARD.FDeprTermCount) AS LEFTTERMCONT, ");
            sql.append("CASE FACURCARD.FIsEvaledBefore WHEN 1 THEN FACURCARD.FEvalLeftPeriod ELSE TO_INT(NULL) END AS EVALLEFTPERIOD, ");
            sql.append("FACURCARD.FMonthDepreRate AS MONTHDEPRERATE, ");
        }
        sql.append("FACURCARD.FDeprTTerm AS DEPRTTERM, ");
        sql.append("FACURCARD.FAccuDepr AS ACCUDEPR, ");
        sql.append("FACURCARD.FACCUDEPRTYEAR AS ACCUDEPRYEAR, ");
        sql.append("FACURCARD.FNeatRemValue AS NEATREMVALUE, ");
        if (this.isListStyle) {
            sql.append("FACURCARD.FNeatLeftRate AS NEATLEFTRATE, ");
        }
        sql.append("FACURCARD.FNeatValue AS NEATVALUE, ");
        sql.append("FACURCARD.FDecValue AS DECVALUE, ");
        sql.append("FACURCARD.FNeatAmt AS NEATAMT, ");
        sql.append("FACURCARD.FFairValue AS fairValue, ");
        sql.append("COMPANY.FID AS COMPANY_ID");
        if (this.isListStyle) {
            if (this.isQueryAcntAssetAccount) {
                sql.append(", assetAccount.").append("FNumber||' '||").append("assetAccount.").append(this.fName).append(" AS ACNTASSET_NAME ");
            }
            if (this.isQueryAcntDeprAccount) {
                sql.append(", accDeprAccount.").append("FNumber||' '||").append("accDeprAccount.").append(this.fName).append(" AS ACNTACCDEPR_NAME ");
            }
            if (this.isQueryAcntDecAccount) {
                sql.append(", decAccount.").append("FNumber||' '||").append("decAccount.").append(this.fName).append(" AS ACNTDECVAL ");
            }
            sql.append(", COMPANY.").append(this.fName).append(" AS COMPANY_NAME, ");
            if (this.isQueryDept) {
                sql.append("DEPT.").append(this.fName).append(" AS DEPT_NAME, ");
            }
            if (this.isQueryKeeper) {
                sql.append("KEEPER.").append(this.fName).append(" AS KEEPER_NAME, ");
            }
            sql.append("FACURCARD.FWrtyPeriod AS WRTYPERIOD, ");
            sql.append("FACURCARD.FWrtyNumber AS WRTYNUMBER, ");
            sql.append("FACURCARD.FRemark AS REMARK ");
        }
        sql.append(",0 AS isSum ");
        if (this.isVirCompany && !this.isInitPeriod) {
            sql.append(",FACURCARD.isCurCard AS ISCURCARD");
        }
        sql.append(this.def.getSelectPart(null));
        sql.append(",FACURCARD.FEvalAssetValue AS EVALASSETVALUE, ");
        sql.append("case when FACURCARD.FEvalAssetValue is null then null else FACURCARD.FEvalAddDepr end AS EVALADDDEPR, ");
        sql.append("case when FACURCARD.FEvalAssetValue is null then null else FACURCARD.FEvalYearDepr end AS EVALYEARDEPR, ");
        sql.append("case when FACURCARD.FEvalAssetValue is null then null else FACURCARD.FEvalDeprTTerm end AS EVALDEPRTTERM, ");
        if (this.isListStyle) {
            sql.append("FACURCARD.FEvalDeprPeriodNum AS EVALDEPRPERIODNUM, ");
        }
        sql.append("case when FACURCARD.FEvalAssetValue is null then null else FACURCARD.FEvalNeatValue end AS EVALNEATVALUE, ");
        if (this.isListStyle) {
            sql.append("FACURCARD.FEvalNeatLeftRate AS EVALNEATLEFTRATE, ");
        }
        sql.append("case when FACURCARD.FEvalAssetValue is null then null else FACURCARD.FEvalRemValue end AS EVALREMVALUE, ");
        sql.append("case when FACURCARD.FEvalAssetValue is null then null else FACURCARD.FEvalDecValue end AS EVALDECVALUE, ");
        sql.append("case when FACURCARD.FEvalAssetValue is null then null else FACURCARD.FEvalNeatAmt end AS EVALNEATAMT ");
        if (this.isListStyle) {
            if (this.isQueryEvalDeprMethod) {
                sql.append(",EVALDEPRMETHOD.").append(this.fName).append(" AS EVALDEPRMODE ");
            }
            sql.append(", case when FACURCARD.FEvalAssetValue is null then null else FACURCARD.FEvalMonthRate end AS EVALMONTHRATE, ");
            sql.append("FACURCARD.FEvalReInAccountDate AS EVALREINACCOUNTDATE, ");
            sql.append("FACURCARD.FEvalUseTermCount AS EVALUSETERMCOUNT, ");
            sql.append("FACURCARD.FEvalTaxLeftPeriod AS EVALTAXLEFTPERIOD ");
            if (this.isQueryEvalMeasureUnit) {
                sql.append(", EVALMEASUREUNIT.").append(this.fName).append(" AS EVALMEASUREUNITWL ");
            }
        }
        if (this.isVirCompany) {
            sql.append(",COMPANY.FLevel AS SumLevel");
        }
        return sql.toString();
    }

    private void buildResultSql() {
        StringBuffer sql = new StringBuffer();
        if (this.sumOption != null && this.sumOption.isHasSum()) {
            sql.append(this.sumOption.getStrSelectResult() + ", ");
        }
        sql.append(this.getSelectResultSql());
        this.resultSql.setSelect(sql.toString());
        this.resultSql.setFrom(this.tempTable);
        this.resultSql.setSecondTable(this.scTempTable);
        this.resultSql.setOrder(this.sorter);
    }

    @Override
    public Map getResult() throws BOSException {
        Map result = super.getResult();
        if (!this.isListAll) {
            result.put("numberList", this.getCardNumberList());
        }
        return result;
    }

    @Override
    protected String buildSorterSql(EntityViewInfo ev) {
        String sorter;
        StringBuffer sorterSql = new StringBuffer();
        if (this.sumOption != null) {
            if (this.sumOption.isHasSum()) {
                sorterSql.append(this.sumOption.getOrderFields().toString()).append(", ");
            }
            if (this.isVirCompany) {
                sorterSql.append(" SumLevel , ").append(" isSum DESC");
            } else {
                sorterSql.append(" isSum");
            }
        }
        if (ev.getSorter() != null && ev.getSorter().toString() != null && ev.getSorter().toString().length() > 0) {
            SorterItemCollection itemColl = ev.getSorter();
            SorterItemCollection tempItemColl = (SorterItemCollection)itemColl.clone();
            int size = tempItemColl.size();
            for (int i = 0; i < size; ++i) {
                SorterItemInfo itemInfo = tempItemColl.get(i);
                if (itemInfo == null || itemInfo.getPropertyName() == null || itemInfo.getPropertyName().indexOf("PV.") == -1) continue;
                itemColl.remove(itemInfo);
            }
            if (ev.getSorter().toString() != null && ev.getSorter().toString().length() > 0 && sorterSql.length() > 0) {
                sorterSql.append(",");
            }
            sorterSql.append(ev.getSorter() != null ? ev.getSorter().toString() : null);
        }
        sorter = (sorter = sorterSql.toString()) == null || sorter.equals("") ? "CHANGEDATE" : sorter;
        if ((sorter = sorter + ", BIZDATE, CHANGETYPE") != null && sorter.indexOf("oldNumber") != -1) {
            sorter = sorter.replaceAll("oldNumber", "olderNUMBER").toString();
        }
        return sorter;
    }

    private String getUsePerson(boolean isCurrPeriod) throws BOSException {
        StringBuffer sql = new StringBuffer();
        FaDaoSqlObject deptDao = new FaDaoSqlObject();
        String table = isCurrPeriod ? "T_FA_FaCurDepartment" : "T_FA_FaMonDepartment";
        String column = isCurrPeriod ? "FFaCurCardID" : "FFaMonCardID";
        sql.append("update ").append(this.tempTable).append(" SET USEPERSON = (");
        deptDao.setSelect(" MAX(dept.FSeq) AS  maxSeq ");
        StringBuffer deptFrom = new StringBuffer(table);
        deptFrom.append(" dept INNER JOIN T_BD_Person person on dept.FUsePersonID = person.fid ");
        deptFrom.append(" INNER JOIN ").append(this.tempTable).append(" temp ON temp.CardID = dept.").append(column);
        deptDao.setFrom(deptFrom.toString());
        IRowSet row = DbUtil.executeQuery((Context)this.ctx, (String)deptDao.getSql());
        int n = 1;
        try {
            if (row != null && row.next()) {
                n = row.getInt("maxSeq");
            }
        }
        catch (SQLException e) {
            throw new BOSException("Sql execute exception : " + deptDao.getSql(), (Throwable)e);
        }
        if (n > 10) {
            n = 10;
        }
        StringBuffer select = new StringBuffer();
        StringBuffer from = new StringBuffer();
        select.append("person.").append(this.fName).append("   ");
        from.append(table).append(" fadept ").append(" INNER JOIN T_BD_Person AS person ");
        from.append(" ON (fadept.FUsePersonID = person.FID  AND fadept.FSeq = 1) ");
        for (int i = 2; i <= n; ++i) {
            select.append(" || ( case ISNULL(person").append(i).append(".").append(this.fName);
            select.append("  ,'') when '' THEN '' ELSE ' ;  ' || person").append(i).append(".").append(this.fName);
            select.append(i == 10 ? "||' ; ...' END)" : " END) ");
            from.append(" LEFT OUTER JOIN ").append(table).append(" fadept").append(i);
            from.append(" ON (fadept").append(i).append(".FSeq = ").append(i).append(" AND fadept.");
            from.append(column).append(" = fadept").append(i).append(".").append(column).append(") ");
            from.append(" LEFT OUTER JOIN T_BD_Person AS person").append(i);
            from.append(" ON (fadept").append(i).append(".FUsePersonID = person").append(i).append(".FID ) ");
        }
        deptDao.setSelect("substring(" + select.toString() + ", 1, 800)");
        deptDao.setFrom(from.toString());
        StringBuffer where = new StringBuffer(this.tempTable);
        where.append(".CardID = fadept.").append(column).append(" AND fadept.FSeq = 1 ");
        deptDao.setWhere(where.toString());
        sql.append(deptDao.getSql()).append(")");
        if (this.isVirCompany && !this.isInitPeriod) {
            sql.append(" WHERE ISCURCARD = ").append(isCurrPeriod ? 1 : 0);
        }
        return sql.toString();
    }

    private String getCondSql(boolean isCurrPeriod) {
        boolean b;
        StringBuffer condSql = new StringBuffer();
        boolean bl = b = this.bNew || this.bChange || this.bPartclean || this.bCompleteclean;
        if (b) {
            condSql.append(" (");
        } else {
            if (this.isShowNotAudit) {
                condSql.append(" FACURCARD.FEffectedStatus = 2");
            } else {
                condSql.append(" FACURCARD.fCheckedStatus = 2");
            }
            if (!this.isInitPeriod) {
                if (this.isIncludeAllClear) {
                    condSql.append(" AND (FACURCARD.fhasCleared = ").append(2);
                    condSql.append(" OR FACURCARD.fDeletedStatus != 2) ");
                } else {
                    condSql.append(" AND FACURCARD.fDeletedStatus != 2 ");
                }
            }
        }
        boolean flag = false;
        if (this.bNew) {
            condSql.append(" (FACURCARD.fHasNew = 1");
            if (this.isShowNotAudit) {
                condSql.append(" AND FACURCARD.FEffectedStatus = 2)");
            } else {
                condSql.append(" AND FACURCARD.fCheckedStatus = 2)");
            }
            if (this.isIncludeAllClear) {
                condSql.append(" AND (FACURCARD.fhasCleared = ").append(2);
                condSql.append(" OR FACURCARD.fDeletedStatus != 2) ");
            } else {
                condSql.append(" AND FACURCARD.fDeletedStatus != 2 ");
            }
            flag = true;
        }
        if (this.bChange) {
            if (flag) {
                condSql.append(" OR");
            }
            condSql.append(" (FACURCARD.fHasChanged <> 0");
            if (this.isShowNotAudit) {
                condSql.append(" AND FACURCARD.FEffectedStatus = 2)");
            } else {
                condSql.append(" AND FACURCARD.fCheckedStatus = 2)");
            }
            flag = true;
        }
        if (this.bPartclean) {
            if (flag) {
                condSql.append(" OR");
            }
            condSql.append(" (FACURCARD.fHasCleared = 1");
            if (this.isShowNotAudit) {
                condSql.append(" AND FACURCARD.FEffectedStatus = 2)");
            } else {
                condSql.append(" AND FACURCARD.fCheckedStatus = 2)");
            }
            flag = true;
        }
        if (this.bCompleteclean) {
            if (flag) {
                condSql.append("OR");
            }
            condSql.append(" (FACURCARD.fHasCleared = 2)");
        }
        if (b) {
            condSql.append(")");
        }
        if (this.filter != null) {
            if (this.filter.indexOf("wrtyNumber") != -1) {
                this.filter = this.filter.replaceAll("wrtyNumber", "FACURCARD.FwrtyNumber");
            }
            if (this.filter.indexOf("barCode") != -1) {
                this.filter = this.filter.replaceAll("barCode", "FACURCARD.FBarCode");
            }
            if (this.filter.indexOf("usePerson.number") != -1) {
                this.filter = this.filter.replaceAll("usePerson.number", "usePerson.fnumber");
            }
            if (this.filter.indexOf("faCurFacility.facilityNumber") != -1) {
                this.filter = this.filter.replaceAll("faCurFacility.facilityNumber", "faCurFacility.FFaCilityID");
            }
            if (this.filter.indexOf("faCurFacility.facilityName") != -1) {
                this.filter = this.filter.replaceAll("faCurFacility.facilityName", "faCurFacility.FfacilityName");
            }
            if (this.filter.indexOf("faCurFacility.facilityModel") != -1) {
                this.filter = this.filter.replaceAll("faCurFacility.facilityModel", "faCurFacility.FfacilityModel");
            }
            if (this.filter.indexOf("wrtyPeriod") != -1) {
                this.filter = this.filter.replaceAll("wrtyPeriod", "FACURCARD.FwrtyPeriod");
            }
            if (this.filter.indexOf("accountView1.fnumber") != -1) {
                this.filter = this.filter.replaceAll("accountView1.fnumber", "accountView.fnumber");
            }
            this.filter = this.def.property2FieldAtFilter(this.filter);
            condSql.append(" AND ").append(this.filter);
        }
        return condSql.toString();
    }

    private String getCompanyFilter(boolean isCurrPeriod) {
        StringBuffer sbff = new StringBuffer();
        if (this.isVirCompany) {
            StringBuffer companyQuery = new StringBuffer();
            companyQuery.append(" SELECT company.fid FROM t_bd_SystemStatusCtrol ssc");
            companyQuery.append(" INNER JOIN t_bd_period period ON ssc.fcurrentperiodid = period.fid");
            companyQuery.append(" INNER JOIN t_org_company company ON ssc.fcompanyid = company.fid");
            companyQuery.append(" INNER JOIN t_bd_SystemStatus ss on ss.fid=ssc.fsystemstatusid");
            companyQuery.append(" WHERE ss.fname= ").append(14);
            if (!this.isInitPeriod) {
                if (isCurrPeriod) {
                    companyQuery.append(" AND period.FPeriodYear = ?");
                    companyQuery.append(" AND period.fperiodnumber = ?");
                    this.params.addInt(this.startYear);
                    this.params.addInt(this.startNumber);
                } else {
                    companyQuery.append(" AND (period.FPeriodYear > ?");
                    companyQuery.append(" OR (period.FPeriodYear = ?");
                    companyQuery.append(" AND period.fperiodnumber > ?))");
                    this.params.addInt(this.startYear);
                    this.params.addInt(this.startYear);
                    this.params.addInt(this.startNumber);
                }
            }
            companyQuery.append(" AND company.fid IN (").append(this.strCompanyInclude).append(")");
            sbff.append(" CARD.FCOMPANYID IN (").append(companyQuery).append(")");
        } else {
            sbff.append(" CARD.FCOMPANYID = '" + this.currCompanyInfo.getId().toString() + "' ");
        }
        return sbff.toString();
    }

    private String getCostCenter(boolean isCurrPeriod) throws BOSException {
        StringBuffer sql = new StringBuffer();
        FaDaoSqlObject costDao = new FaDaoSqlObject();
        String table = isCurrPeriod ? "T_FA_FaCurCostCenter" : "T_FA_FaMonCostCenter";
        String column = isCurrPeriod ? "FFaCurCardID" : "FFaMonCardID";
        sql.append("update ").append(this.tempTable).append(" SET COSTCENTER = (");
        costDao.setSelect(" MAX(FSeq) AS maxSeq ");
        StringBuffer costFrom = new StringBuffer(table);
        costFrom.append(" cost INNER JOIN ").append(this.tempTable).append(" temp ON temp.CardID = cost.").append(column);
        costDao.setFrom(costFrom.toString());
        IRowSet row = DbUtil.executeQuery((Context)this.ctx, (String)costDao.getSql());
        int n = 1;
        try {
            if (row != null && row.next()) {
                n = row.getInt("maxSeq");
            }
        }
        catch (SQLException e) {
            throw new BOSException("Sql execute exception : " + costDao.getSql(), (Throwable)e);
        }
        if (n > 10) {
            n = 10;
        }
        StringBuffer select = new StringBuffer();
        StringBuffer from = new StringBuffer();
        select.append("account.FNumber ||'-'|| account." + this.fName + " || ' ' || TO_CHAR(facost.FApportionScale, 'NUMBER' ,2) || '%'|| ' ' || facost.FAsstActLName ");
        from.append(table + " facost ");
        from.append(" LEFT OUTER JOIN T_BD_AccountView AS account ON facost.FAccountViewID = account.FID ");
        for (int i = 2; i <= n; ++i) {
            select.append(" || ( case ISNULL(facost").append(i).append(".FAccountViewID ");
            select.append("  ,'') when '' THEN '' ELSE ' ;  '||account").append(i).append(".FNumber ||'-'|| account").append(i).append("." + this.fName);
            select.append("   || ' ' || TO_CHAR(facost").append(i).append(".FApportionScale, 'NUMBER' , 2) || '%'|| ' ' ||facost").append(i).append(".FAsstActLName");
            select.append(i == 10 ? "||' ; ...' END)" : " END) ");
            from.append(" LEFT OUTER JOIN ").append(table).append(" facost").append(i);
            from.append(" ON (facost").append(i).append(".FSeq = ").append(i).append(" AND facost.").append(column);
            from.append(" = facost").append(i).append(".").append(column).append(") ");
            from.append(" LEFT OUTER JOIN T_BD_AccountView").append(" AS account").append(i);
            from.append(" ON (facost").append(i).append(".FAccountViewID = account").append(i).append(".FID)");
        }
        costDao.setSelect("substring(" + select.toString() + ", 1, 800)");
        costDao.setFrom(from.toString());
        StringBuffer where = new StringBuffer();
        where.append(this.tempTable).append(".CardID = facost.").append(column).append(" AND facost.FSeq = 1 ");
        costDao.setWhere(where.toString());
        sql.append(costDao.getSql()).append(")");
        if (this.isVirCompany && !this.isInitPeriod) {
            sql.append(" WHERE ISCURCARD = ").append(isCurrPeriod ? 1 : 0);
        }
        return sql.toString();
    }

    private String getSelectResultSql() {
        StringBuffer sql = new StringBuffer();
        sql.append("FID, ");
        sql.append("bizNumber,");
        sql.append("voucherID,");
        sql.append("voucherNumber,");
        sql.append("CardID, ");
        sql.append("CHANGEDATE, ");
        sql.append("ALTERMETHOD_NAME, ");
        sql.append("bASSETNUMBER, ");
        sql.append("ASSETNUMBER, ");
        sql.append("bolderNUMBER, ");
        sql.append("olderNUMBER, ");
        sql.append("bGroupNumber, ");
        sql.append("GroupNumber, ");
        sql.append("bASSETNAME, ");
        sql.append("ASSETNAME, ");
        sql.append("bASSETCAT_NAME, ");
        sql.append("ASSETCAT_NAME, ");
        sql.append("bASSETAMT, ");
        sql.append("ASSETAMT, ");
        sql.append("bMEASUREUNIT_NAME, ");
        sql.append("MEASUREUNIT_NAME, ");
        sql.append("bUSESTATUS_NAME, ");
        sql.append("USESTATUS_NAME, ");
        sql.append("bECONOMICPURP_NAME, ");
        sql.append("ECONOMICPURP_NAME, ");
        sql.append("bSTORECITY_NAME, ");
        sql.append("STORECITY_NAME, ");
        sql.append("bUseDepartment, ");
        sql.append("UseDepartment, ");
        sql.append("bUsePerson, ");
        sql.append("UsePerson, ");
        sql.append("bCostCenter, ");
        sql.append("CostCenter, ");
        sql.append("bSPECS, ");
        sql.append("SPECS, ");
        sql.append("bPAREA, ");
        sql.append("PAREA, ");
        sql.append("bMFR, ");
        sql.append("MFR, ");
        sql.append("bLEVFRDATE, ");
        sql.append("LEVFRDATE, ");
        sql.append("bORIGINUNIT, ");
        sql.append("ORIGINUNIT, ");
        sql.append("PAPERNO, ");
        sql.append("bDEPRMETHOD_NAME, ");
        sql.append("DEPRMETHOD_NAME, ");
        sql.append("bMEASUREUNITWL_NAME, ");
        sql.append("MEASUREUNITWL_NAME, ");
        sql.append("bCURRENCY_NAME, ");
        sql.append("CURRENCY_NAME, ");
        sql.append("bEXRATE, ");
        sql.append("EXRATE, ");
        sql.append("bORIGINAMT, ");
        sql.append("ORIGINAMT, ");
        sql.append("bTAXORIGINAMT, ");
        sql.append("TAXORIGINAMT, ");
        sql.append("BInputTax, ");
        sql.append("InputTax, ");
        sql.append("bINPUTTAXRATE, ");
        sql.append("INPUTTAXRATE, ");
        sql.append("bISDEDUCT, ");
        sql.append("ISDEDUCT, ");
        sql.append("bADDONS, ");
        sql.append("ADDONS, ");
        sql.append("bTREATMENTINCOME, ");
        sql.append("TREATMENTINCOME, ");
        sql.append("bADDONFARE, ");
        sql.append("ADDONFARE, ");
        sql.append("bASSETVALUE, ");
        sql.append("ASSETVALUE, ");
        sql.append("ORIGINCHG, ");
        sql.append("bclrEvalValue,");
        sql.append("clrEvalValue,");
        sql.append("bBUYVALUE, ");
        sql.append("BUYVALUE, ");
        sql.append("bBUYACCUDEPR, ");
        sql.append("BUYACCUDEPR, ");
        sql.append("bDELIVERDATE, ");
        sql.append("DELIVERDATE, ");
        sql.append("STARTUSEDATE, ");
        sql.append("bUSEYEARS, ");
        sql.append("USEYEARS, ");
        sql.append("bUSETERMCOUNT, ");
        sql.append("USETERMCOUNT, ");
        sql.append("bDEPRTERMCOUNT, ");
        sql.append("DEPRTERMCOUNT, ");
        sql.append("bLEFTTERMCOUNT, ");
        sql.append("LEFTTERMCOUNT, ");
        sql.append("bACCUDEPR, ");
        sql.append("ACCUDEPR, ");
        sql.append("ACCUDEPRCHG,");
        sql.append("bACCUDEPRYEAR, ");
        sql.append("ACCUDEPRYEAR, ");
        sql.append("bNEATREMVALUE, ");
        sql.append("NEATREMVALUE, ");
        sql.append("bNEATLEFTRATE, ");
        sql.append("NEATLEFTRATE, ");
        sql.append("bNEATVALUE, ");
        sql.append("NEATVALUE, ");
        sql.append("bDECVALUE, ");
        sql.append("DECVALUE, ");
        sql.append("DECVALUECHG, ");
        sql.append("bNEATAMT, ");
        sql.append("NEATAMT, ");
        sql.append("COMPANY_NAME, ");
        sql.append("bDEPT_NAME, ");
        sql.append("DEPT_NAME, ");
        sql.append("bKEEPER_NAME, ");
        sql.append("KEEPER_NAME, ");
        sql.append("bREMARK, ");
        sql.append("REMARK, ");
        sql.append("CHGREASON, ");
        sql.append("CHANGETYPE, ");
        sql.append("bPREC, ");
        sql.append("PREC, ");
        sql.append("bEXRATEPREC, ");
        sql.append("EXRATEPREC, ");
        sql.append("bEvalAssetValue, ");
        sql.append("evalAssetValue, ");
        sql.append("bEvalReInAccountDate, ");
        sql.append("evalReInAccountDate, ");
        sql.append("bEvalDeprMethod_name, ");
        sql.append("evalDeprMethod_name, ");
        sql.append("bEvalUseTermCount, ");
        sql.append("evalUseTermCount, ");
        sql.append("bEvalMonthRate, ");
        sql.append("evalMonthRate, ");
        sql.append("bEvalTaxLeftPeriod, ");
        sql.append("evalTaxLeftPeriod, ");
        sql.append("bEvalNeatLeftRate, ");
        sql.append("evalNeatLeftRate, ");
        sql.append("bEvalDeprPeriodNum, ");
        sql.append("evalDeprPeriodNum, ");
        sql.append("bEvalRemValue, ");
        sql.append("evalRemValue, ");
        sql.append("bEvalAddDepr, ");
        sql.append("evalAddDepr, ");
        sql.append("bEvalDecValue, ");
        sql.append("evalDecValue, ");
        sql.append("bEvalYearDepr, ");
        sql.append("evalYearDepr, ");
        sql.append("bEvalNeatValue, ");
        sql.append("evalNeatValue, ");
        sql.append("evalMeasureUnit_name, ");
        sql.append("bEvalNeatAmt, ");
        sql.append("evalNeatAmt, ");
        sql.append("bACCOUNTASSET_DISPNAME,");
        sql.append("ACCOUNTASSET_DISPNAME,");
        sql.append("bACCOUNTDEVVALUE_DISPNAME,");
        sql.append("ACCOUNTDEVVALUE_DISPNAME,");
        sql.append("bACCOUNTACCUDEPR_DISPNAME,");
        sql.append("ACCOUNTACCUDEPR_DISPNAME,");
        sql.append("BASEPREC ");
        if (this.isVirCompany) {
            sql.append(",isSum");
        }
        if (this.isVirCompany) {
            sql.append(", SumLevel ");
        }
        return sql.toString();
    }

    private String getCleanCardSql() {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT ");
        sql.append(" newBosId('00000000') AS FId  , ");
        if (this.isVirCompany) {
            sql.append(this.sumOption.getStrNameFields() + ", ");
        }
        sql.append(this.getDetailSelectSql());
        if (this.isVirCompany) {
            sql.append(", ").append(this.sumOption.getStrLongNumberFields());
        }
        sql.append(" FROM (SELECT ");
        if (this.filter != null && (this.filter.indexOf("asstActItem.fname_l2") != -1 || this.filter.indexOf("asstActType.fnumber") != -1 || this.filter.indexOf("useDepartment.fnumber") != -1)) {
            sql.append("DISTINCT ");
        }
        sql.append("A.CardID AS CardID, ");
        sql.append("A.CUR_CARD_ID AS  CUR_CARD_ID, ");
        sql.append("A.bizNumber as bizNumber,");
        sql.append("A.voucherID as VoucherID,");
        sql.append("A.voucherNumber as voucherNUmber,");
        sql.append("SUBSTRING(TO_CHAR(A.CHANGEDATE,'yyyy-mm-dd'),0,10) AS CHANGEDATE, ");
        sql.append("A.BizDate AS BIZDATE, ");
        sql.append("ALTERMETHOD." + this.fName + " AS ALTERMETHOD_NAME, ");
        sql.append("A.bASSETNUMBER AS bASSETNUMBER, ");
        sql.append("A.ASSETNUMBER AS ASSETNUMBER, ");
        sql.append("A.bolderNUMBER AS bolderNUMBER, ");
        sql.append("A.olderNUMBER AS olderNUMBER, ");
        sql.append("A.bGroupNumber AS bGroupNumber, ");
        sql.append("A.groupNumber AS GroupNumber, ");
        sql.append("A.bASSETNAME AS bASSETNAME, ");
        sql.append("A.ASSETNAME AS ASSETNAME, ");
        sql.append("ASSETCAT." + this.fName + " AS bASSETCAT_NAME, ");
        sql.append("ASSETCAT." + this.fName + " AS ASSETCAT_NAME, ");
        sql.append("A.bASSETAMT AS bASSETAMT, ");
        sql.append("A.ASSETAMT AS ASSETAMT, ");
        sql.append("MEASUREUNIT." + this.fName + " AS bMEASUREUNIT_NAME, ");
        sql.append("MEASUREUNIT." + this.fName + " AS MEASUREUNIT_NAME, ");
        sql.append("USESTATUS." + this.fName + " AS bUSESTATUS_NAME, ");
        sql.append("USESTATUS." + this.fName + " AS USESTATUS_NAME, ");
        sql.append("ECONOMICPURP." + this.fName + " AS bECONOMICPURP_NAME, ");
        sql.append("ECONOMICPURP." + this.fName + " AS ECONOMICPURP_NAME, ");
        sql.append("STORECITY." + this.fName + " AS bSTORECITY_NAME, ");
        sql.append("STORECITY." + this.fName + " AS STORECITY_NAME, ");
        sql.append("A.SPECS AS bUseDepartment, ");
        sql.append("A.SPECS AS UseDepartment, ");
        sql.append("A.SPECS AS bUsePerson, ");
        sql.append("A.SPECS AS UsePerson, ");
        sql.append("A.SPECS AS bCostCenter, ");
        sql.append("A.SPECS AS CostCenter, ");
        sql.append("A.bSPECS AS bSPECS, ");
        sql.append("A.SPECS AS SPECS, ");
        sql.append("A.bPAREA AS bPAREA, ");
        sql.append("A.PAREA AS PAREA, ");
        sql.append("A.bMFR AS bMFR, ");
        sql.append("A.MFR AS MFR, ");
        sql.append("A.bLEVFRDATE AS bLEVFRDATE, ");
        sql.append("A.LEVFRDATE AS LEVFRDATE, ");
        sql.append("A.bORIGINUNIT AS bORIGINUNIT, ");
        sql.append("A.ORIGINUNIT AS ORIGINUNIT, ");
        sql.append("A.PAPERNO AS PAPERNO, ");
        sql.append("DEPRMETHOD." + this.fName + " AS bDEPRMETHOD_NAME, ");
        sql.append("DEPRMETHOD." + this.fName + " AS DEPRMETHOD_NAME, ");
        sql.append("MEASUREUNITWL." + this.fName + " AS bMEASUREUNITWL_NAME, ");
        sql.append("MEASUREUNITWL." + this.fName + " AS MEASUREUNITWL_NAME, ");
        sql.append("A.bCurrencyID AS bCurrencyID, ");
        sql.append("CURRENCY." + this.fName + " AS bCURRENCY_NAME, ");
        sql.append("A.currencyID AS currencyID, ");
        sql.append("CURRENCY." + this.fName + " AS CURRENCY_NAME, ");
        sql.append("A.bEXRATE AS bEXRATE, ");
        sql.append("A.EXRATE AS EXRATE, ");
        sql.append("A.bORIGINAMT AS bORIGINAMT, ");
        sql.append("A.ORIGINAMT AS ORIGINAMT, ");
        sql.append("A.bTAXORIGINAMT AS bTAXORIGINAMT, ");
        sql.append("A.TAXORIGINAMT AS TAXORIGINAMT, ");
        sql.append("A.BInputTax AS BInputTax, ");
        sql.append("A.InputTax AS InputTax, ");
        sql.append("A.BInputTaxRate AS BInputTaxRate, ");
        sql.append("A.InputTaxRate AS InputTaxRate, ");
        sql.append("A.BIsDeduct AS BIsDeduct, ");
        sql.append("A.IsDeduct AS IsDeduct, ");
        sql.append("A.bADDONS AS bADDONS, ");
        sql.append("A.ADDONS AS ADDONS, ");
        sql.append("A.bTREATMENTINCOME AS bTREATMENTINCOME, ");
        sql.append("A.TREATMENTINCOME AS TREATMENTINCOME, ");
        sql.append("A.bADDONFARE AS bADDONFARE, ");
        sql.append("A.ADDONFARE AS ADDONFARE, ");
        sql.append("A.bASSETVALUE AS bASSETVALUE, ");
        sql.append("A.ASSETVALUE AS ASSETVALUE, ");
        sql.append("A.ORIGINCHG AS ORIGINCHG, ");
        sql.append("A.bclrEvalValue as bclrEvalValue,");
        sql.append("A.clrEvalValue as clrEvalValue,");
        sql.append("A.bBUYVALUE AS bBUYVALUE, ");
        sql.append("A.BUYVALUE AS BUYVALUE, ");
        sql.append("A.bBUYACCUDEPR AS bBUYACCUDEPR, ");
        sql.append("A.BUYACCUDEPR AS BUYACCUDEPR, ");
        sql.append("A.bDELIVERDATE AS bDELIVERDATE, ");
        sql.append("A.DELIVERDATE AS DELIVERDATE, ");
        sql.append("A.STARTUSEDATE AS STARTUSEDATE, ");
        sql.append("A.bUSEYEARS AS bUSEYEARS, ");
        sql.append("A.USEYEARS AS USEYEARS, ");
        sql.append("A.bUSETERMCOUNT AS bUSETERMCOUNT, ");
        sql.append("A.USETERMCOUNT AS USETERMCOUNT, ");
        sql.append("A.bDEPRTERMCOUNT AS bDEPRTERMCOUNT, ");
        sql.append("A.DEPRTERMCOUNT AS DEPRTERMCOUNT, ");
        sql.append("A.LEFTTERMCONT AS LEFTTERMCOUNT, ");
        sql.append("A.bLEFTTERMCONT AS bLEFTTERMCOUNT, ");
        sql.append("A.bACCUDEPR AS bACCUDEPR, ");
        sql.append("A.ACCUDEPR AS ACCUDEPR, ");
        sql.append("A.ACCUDEPRCHG AS ACCUDEPRCHG,");
        sql.append("A.bACCUDEPRYEAR AS bACCUDEPRYEAR, ");
        sql.append("A.ACCUDEPRYEAR AS ACCUDEPRYEAR, ");
        sql.append("A.bNEATREMVALUE AS bNEATREMVALUE, ");
        sql.append("A.NEATREMVALUE AS NEATREMVALUE, ");
        sql.append("A.bNEATLEFTRATE AS bNEATLEFTRATE, ");
        sql.append("A.NEATLEFTRATE AS NEATLEFTRATE, ");
        sql.append("A.bNEATVALUE AS bNEATVALUE, ");
        sql.append("A.NEATVALUE AS NEATVALUE, ");
        sql.append("A.bDECVALUE AS bDECVALUE, ");
        sql.append("A.DECVALUE AS DECVALUE, ");
        sql.append("A.DECVALUECHG AS DECVALUECHG, ");
        sql.append("A.bNEATAMT AS bNEATAMT, ");
        sql.append("A.NEATAMT AS NEATAMT, ");
        sql.append("DEPT." + this.fName + " AS bDEPT_NAME, ");
        sql.append("DEPT." + this.fName + " AS DEPT_NAME, ");
        sql.append("KEEPER." + this.fName + " AS bKEEPER_NAME, ");
        sql.append("KEEPER." + this.fName + " AS KEEPER_NAME, ");
        sql.append("A.bREMARK AS bREMARK, ");
        sql.append("A.REMARK AS REMARK, ");
        sql.append("A.CHGREASON AS CHGREASON, ");
        sql.append("A.bEvalAssetValue AS bEvalAssetValue,");
        sql.append("A.evalAssetValue AS evalAssetValue,");
        sql.append("A.bEvalReInAccountDate AS bEvalReInAccountDate,");
        sql.append("A.evalReInAccountDate AS evalReInAccountDate,");
        sql.append("EVALDEPRMETHOD." + this.fName + " AS bEVALDeprMethod_name, ");
        sql.append("EVALDEPRMETHOD." + this.fName + " AS evalDeprMethod_name, ");
        sql.append("A.bEvalUseTermCount AS bEvalUseTermCount,");
        sql.append("A.evalUseTermCount AS evalUseTermCount,");
        sql.append("A.bEvalMonthRate AS bEvalMonthRate,");
        sql.append("A.evalMonthRate AS evalMonthRate,");
        sql.append("A.bEvalTaxLeftPeriod AS bEvalTaxLeftPeriod,");
        sql.append("A.evalTaxLeftPeriod AS evalTaxLeftPeriod,");
        sql.append("A.bEvalNeatLeftRate AS bEvalNeatLeftRate,");
        sql.append("A.evalNeatLeftRate AS evalNeatLeftRate,");
        sql.append("A.bEvalDeprPeriodNum AS bEvalDeprPeriodNum,");
        sql.append("A.evalDeprPeriodNum AS evalDeprPeriodNum,");
        sql.append("A.bEvalRemValue AS bEvalRemValue,");
        sql.append("A.evalRemValue AS evalRemValue,");
        sql.append("A.bEvalAddDepr AS bEvalAddDepr,");
        sql.append("A.evalAddDepr AS evalAddDepr,");
        sql.append("A.bEvalDecValue AS bEvalDecValue,");
        sql.append("A.evalDecValue AS evalDecValue,");
        sql.append("A.bEvalYearDepr AS bEvalYearDepr,");
        sql.append("A.evalYearDepr AS evalYearDepr,");
        sql.append("A.bEvalNeatValue AS bEvalNeatValue,");
        sql.append("A.evalNeatValue AS evalNeatValue,");
        sql.append("EVALMEASUREUNIT." + this.fName + " AS evalMeasureUnit_name, ");
        sql.append("A.bEvalNeatAmt AS bEvalNeatAmt,");
        sql.append("A.evalNeatAmt AS evalNeatAmt,");
        sql.append("A.BAKCARDID AS BAKCARDID,");
        sql.append("A.CHANGETYPE AS CHANGETYPE,");
        sql.append("CURRENCY.FPrecision AS bPREC, ");
        sql.append("CURRENCY.FPrecision AS PREC, ");
        sql.append("A.FCompanyID AS FCompanyID,");
        sql.append(" ACCOUNTDECVALUE.FNumber bACCOUNTDECVALUEFNumber, ");
        sql.append(" ACCOUNTDECVALUE.FName_l2 bACCOUNTDECVALUEFName_l2, ");
        sql.append(" ACCOUNTDECVALUE.FNumber ACCOUNTDECVALUEFNumber, ");
        sql.append(" ACCOUNTDECVALUE.FName_l2 ACCOUNTDECVALUEFName_l2, ");
        sql.append(" ACCOUNTACCUDEPR.FNumber bACCOUNTACCUDEPRFNumber, ");
        sql.append(" ACCOUNTACCUDEPR.FName_l2 bACCOUNTACCUDEPRFName_l2,  ");
        sql.append(" ACCOUNTACCUDEPR.FNumber ACCOUNTACCUDEPRFNumber, ");
        sql.append(" ACCOUNTACCUDEPR.FName_l2 ACCOUNTACCUDEPRFName_l2, ");
        sql.append(" ACCOUNTASSET.FNumber bACCOUNTASSETFNumber, ");
        sql.append(" ACCOUNTASSET.FName_l2 bACCOUNTASSETFName_l2, ");
        sql.append(" ACCOUNTASSET.FNumber ACCOUNTASSETFNumber, ");
        sql.append(" ACCOUNTASSET.FName_l2 ACCOUNTASSETFName_l2   ");
        sql.append(",A.FPropertyValueID AS FPropertyValueID, ");
        sql.append("A.BFPropertyValueID AS BFPropertyValueID ");
        sql.append(" FROM (");
        sql.append(this.getCleanBillDetailSql());
        sql.append(") AS A ");
        sql.append(" LEFT OUTER JOIN T_FA_DepreciationMode AS EVALDEPRMETHOD ON A.evalDeprMethodID = EVALDEPRMETHOD.FID ");
        sql.append(" LEFT OUTER JOIN T_BD_MeasureUnit AS MEASUREUNITWL ON A.MeasureUnitWLID = MEASUREUNITWL.FID ");
        sql.append(" LEFT OUTER JOIN T_BD_AccountView AS ACCOUNTDECVALUE ON A.FAccountDecValueID = ACCOUNTDECVALUE.FID ");
        sql.append(" LEFT OUTER JOIN T_BD_AccountView AS ACCOUNTACCUDEPR ON A.FAccountAccuDeprID = ACCOUNTACCUDEPR.FID  ");
        sql.append(" LEFT OUTER JOIN T_BD_AccountView AS ACCOUNTASSET ON A.FAccountAssetID = ACCOUNTASSET.FID ");
        sql.append(" LEFT OUTER JOIN T_BD_Currency AS CURRENCY ON A.CurrencyID = CURRENCY.FID ");
        sql.append(" LEFT OUTER JOIN T_BD_Person AS KEEPER ON A.KeeperID = KEEPER.FID ");
        sql.append(" LEFT OUTER JOIN T_ORG_Admin AS DEPT ON A.DeptID = DEPT.FID ");
        sql.append(" LEFT OUTER JOIN V_FA_Cat AS ASSETCAT ON A.AssetCatID = ASSETCAT.FID ");
        sql.append(" LEFT OUTER JOIN T_BD_MeasureUnit AS MEASUREUNIT ON A.MeasureUnitID = MEASUREUNIT.FID ");
        sql.append(" LEFT JOIN T_BD_MeasureUnit AS EVALMEASUREUNIT ON A.evalMeasureUnitWL = EVALMEASUREUNIT.FID ");
        sql.append(" LEFT OUTER JOIN V_FA_AlterMode AS ALTERMETHOD ON A.CHANGEMODE = ALTERMETHOD.FID ");
        sql.append(" LEFT OUTER JOIN V_FA_UseStatus AS USESTATUS ON A.UseStatusID = USESTATUS.FID ");
        sql.append(" LEFT OUTER JOIN V_FA_FaEconomicPurp AS ECONOMICPURP ON A.EconomicPurpID = ECONOMICPURP.FID ");
        sql.append(" LEFT OUTER JOIN T_BD_Address AS STORECITY ON A.StoreCityID = STORECITY.FID ");
        sql.append(" LEFT OUTER JOIN T_FA_DepreciationMode AS DEPRMETHOD ON A.DeprMethodID = DEPRMETHOD.FID ");
        if (this.filter != null && (this.filter.indexOf("asstActItem.fname_l2") != -1 || this.filter.indexOf("asstActType.fnumber") != -1)) {
            sql.append(" LEFT OUTER JOIN ").append(this.acctAsstTableName).append(" AS asstActItem ON A.FAsstActItem = asstActItem.FID AND A.fasstactTypeid = asstActItem.FAsstacttypeID");
            sql.append(" LEFT OUTER JOIN t_bd_asstacttype asstActType on asstActType.Fid = A.Fasstacttypeid");
        }
        if (this.filter != null && this.filter.indexOf("useDepartment.fnumber") != -1) {
            sql.append(" LEFT OUTER JOIN T_ORG_Admin AS USEDEPARTMENT ON A.FUseDepartmentID = USEDEPARTMENT.FID");
        }
        try {
            sql.append(this.def.getJoinPart("A.FPropertyValueID"));
            sql.append(this.def.getJoinPart("A.bFPropertyValueID", "b"));
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new RuntimeException(e);
        }
        String cond = this.getCondSql();
        if (cond != null && !cond.trim().equals("")) {
            sql.append(" WHERE ").append(cond);
        }
        sql.append(" ) AS B ");
        if (this.isVirCompany) {
            sql.append("INNER JOIN " + this.getSumItemJoinSql("orgArchitecture") + " AS COMP ON B.FCompanyID = COMP.FID ");
        }
        sql.append(" LEFT OUTER JOIN T_ORG_Company AS COMPANY ON B.FCompanyID = COMPANY.FID ");
        sql.append(" LEFT OUTER JOIN T_BD_Currency AS BASECURRENCY ON COMPANY.FBaseCurrencyID = BASECURRENCY.FID ");
        sql.append(" LEFT OUTER JOIN T_BD_ExchangeTable AS EXTABLE on EXTABLE.fid = COMPANY.FBASEEXGTABLEID ");
        sql.append(" LEFT OUTER JOIN T_BD_ExchangeAux AS bEXAUX on bEXAUX.fexchangetableid = EXTABLE.fid AND bEXAUX.fsourcecurrencyid = B.bCurrencyID AND COMPANY.FbaseCurrencyID = bEXAUX.ftargetcurrencyid ");
        sql.append(" LEFT OUTER JOIN T_BD_ExchangeAux AS EXAUX on EXAUX.fexchangetableid = EXTABLE.fid AND EXAUX.fsourcecurrencyid = B.CurrencyID AND COMPANY.FbaseCurrencyID = EXAUX.ftargetcurrencyid ");
        return sql.toString();
    }

    private String getNewCardSql() {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT ");
        sql.append(" newBosId('00000000') AS FId  , ");
        if (this.isVirCompany) {
            sql.append(this.sumOption.getStrNameFields() + ", ");
        }
        sql.append(this.getDetailSelectSql());
        if (this.isVirCompany) {
            sql.append(", ").append(this.sumOption.getStrLongNumberFields());
        }
        sql.append(" FROM (SELECT ");
        if (this.filter != null && (this.filter.indexOf("asstActItem.fname_l2") != -1 || this.filter.indexOf("asstActType.fnumber") != -1 || this.filter.indexOf("useDepartment.fnumber") != -1)) {
            sql.append("DISTINCT ");
        }
        sql.append("A.CardID AS CardID, ");
        sql.append("A.CUR_CARD_ID AS  CUR_CARD_ID, ");
        sql.append("A.bizNumber as bizNumber,");
        sql.append("A.voucherID as VoucherID,");
        sql.append("A.voucherNumber as voucherNUmber,");
        sql.append("SUBSTRING(TO_CHAR(A.CHANGEDATE,'yyyy-mm-dd'),0,10) AS CHANGEDATE, ");
        sql.append("A.BizDate AS BIZDATE, ");
        sql.append("ALTERMETHOD." + this.fName + " AS ALTERMETHOD_NAME, ");
        sql.append("A.bASSETNUMBER AS bASSETNUMBER, ");
        sql.append("A.ASSETNUMBER AS ASSETNUMBER, ");
        sql.append("A.bolderNUMBER AS bolderNUMBER, ");
        sql.append("A.olderNUMBER AS olderNUMBER, ");
        sql.append("A.bGroupNumber AS bGroupNumber, ");
        sql.append("A.groupNumber AS GroupNumber, ");
        sql.append("A.bASSETNAME AS bASSETNAME, ");
        sql.append("A.ASSETNAME AS ASSETNAME, ");
        sql.append("ASSETCAT." + this.fName + " AS bASSETCAT_NAME, ");
        sql.append("ASSETCAT." + this.fName + " AS ASSETCAT_NAME, ");
        sql.append("A.bASSETAMT AS bASSETAMT, ");
        sql.append("A.ASSETAMT AS ASSETAMT, ");
        sql.append("MEASUREUNIT." + this.fName + " AS bMEASUREUNIT_NAME, ");
        sql.append("MEASUREUNIT." + this.fName + " AS MEASUREUNIT_NAME, ");
        sql.append("USESTATUS." + this.fName + " AS bUSESTATUS_NAME, ");
        sql.append("USESTATUS." + this.fName + " AS USESTATUS_NAME, ");
        sql.append("ECONOMICPURP." + this.fName + " AS bECONOMICPURP_NAME, ");
        sql.append("ECONOMICPURP." + this.fName + " AS ECONOMICPURP_NAME, ");
        sql.append("STORECITY." + this.fName + " AS bSTORECITY_NAME, ");
        sql.append("STORECITY." + this.fName + " AS STORECITY_NAME, ");
        sql.append("A.SPECS AS bUseDepartment, ");
        sql.append("A.SPECS AS UseDepartment, ");
        sql.append("A.SPECS AS bUsePerson, ");
        sql.append("A.SPECS AS UsePerson, ");
        sql.append("A.SPECS AS bCostCenter, ");
        sql.append("A.SPECS AS CostCenter, ");
        sql.append("A.bSPECS AS bSPECS, ");
        sql.append("A.SPECS AS SPECS, ");
        sql.append("A.bPAREA AS bPAREA, ");
        sql.append("A.PAREA AS PAREA, ");
        sql.append("A.bMFR AS bMFR, ");
        sql.append("A.MFR AS MFR, ");
        sql.append("A.bLEVFRDATE AS bLEVFRDATE, ");
        sql.append("A.LEVFRDATE AS LEVFRDATE, ");
        sql.append("A.bORIGINUNIT AS bORIGINUNIT, ");
        sql.append("A.ORIGINUNIT AS ORIGINUNIT, ");
        sql.append("A.PAPERNO AS PAPERNO, ");
        sql.append("DEPRMETHOD." + this.fName + " AS bDEPRMETHOD_NAME, ");
        sql.append("DEPRMETHOD." + this.fName + " AS DEPRMETHOD_NAME, ");
        sql.append("MEASUREUNITWL." + this.fName + " AS bMEASUREUNITWL_NAME, ");
        sql.append("MEASUREUNITWL." + this.fName + " AS MEASUREUNITWL_NAME, ");
        sql.append("A.bCurrencyID AS bCurrencyID, ");
        sql.append("CURRENCY." + this.fName + " AS bCURRENCY_NAME, ");
        sql.append("A.currencyID AS currencyID, ");
        sql.append("CURRENCY." + this.fName + " AS CURRENCY_NAME, ");
        sql.append("A.bEXRATE AS bEXRATE, ");
        sql.append("A.EXRATE AS EXRATE, ");
        sql.append("A.bORIGINAMT AS bORIGINAMT, ");
        sql.append("A.ORIGINAMT AS ORIGINAMT, ");
        sql.append("A.bTAXORIGINAMT AS bTAXORIGINAMT, ");
        sql.append("A.TAXORIGINAMT AS TAXORIGINAMT, ");
        sql.append("A.BInputTax AS BInputTax, ");
        sql.append("A.InputTax AS InputTax, ");
        sql.append("A.BInputTaxRate AS BInputTaxRate, ");
        sql.append("A.InputTaxRate AS InputTaxRate, ");
        sql.append("A.BIsDeduct AS BIsDeduct, ");
        sql.append("A.IsDeduct AS IsDeduct, ");
        sql.append("A.bADDONS AS bADDONS, ");
        sql.append("A.ADDONS AS ADDONS, ");
        sql.append("A.bTREATMENTINCOME AS bTREATMENTINCOME, ");
        sql.append("A.TREATMENTINCOME AS TREATMENTINCOME, ");
        sql.append("A.bADDONFARE AS bADDONFARE, ");
        sql.append("A.ADDONFARE AS ADDONFARE, ");
        sql.append("A.bASSETVALUE AS bASSETVALUE, ");
        sql.append("A.ASSETVALUE AS ASSETVALUE, ");
        sql.append("A.ORIGINCHG AS ORIGINCHG, ");
        sql.append("A.bclrEvalValue as bclrEvalValue,");
        sql.append("A.clrEvalValue as clrEvalValue,");
        sql.append("A.bBUYVALUE AS bBUYVALUE, ");
        sql.append("A.BUYVALUE AS BUYVALUE, ");
        sql.append("A.bBUYACCUDEPR AS bBUYACCUDEPR, ");
        sql.append("A.BUYACCUDEPR AS BUYACCUDEPR, ");
        sql.append("A.bDELIVERDATE AS bDELIVERDATE, ");
        sql.append("A.DELIVERDATE AS DELIVERDATE, ");
        sql.append("A.STARTUSEDATE AS STARTUSEDATE, ");
        sql.append("A.bUSEYEARS AS bUSEYEARS, ");
        sql.append("A.USEYEARS AS USEYEARS, ");
        sql.append("A.bUSETERMCOUNT AS bUSETERMCOUNT, ");
        sql.append("A.USETERMCOUNT AS USETERMCOUNT, ");
        sql.append("A.bDEPRTERMCOUNT AS bDEPRTERMCOUNT, ");
        sql.append("A.DEPRTERMCOUNT AS DEPRTERMCOUNT, ");
        sql.append("A.LEFTTERMCONT AS LEFTTERMCOUNT, ");
        sql.append("A.bLEFTTERMCONT AS bLEFTTERMCOUNT, ");
        sql.append("A.bACCUDEPR AS bACCUDEPR, ");
        sql.append("A.ACCUDEPR AS ACCUDEPR, ");
        sql.append("A.ACCUDEPRCHG AS ACCUDEPRCHG,");
        sql.append("A.bACCUDEPRYEAR AS bACCUDEPRYEAR, ");
        sql.append("A.ACCUDEPRYEAR AS ACCUDEPRYEAR, ");
        sql.append("A.bNEATREMVALUE AS bNEATREMVALUE, ");
        sql.append("A.NEATREMVALUE AS NEATREMVALUE, ");
        sql.append("A.bNEATLEFTRATE AS bNEATLEFTRATE, ");
        sql.append("A.NEATLEFTRATE AS NEATLEFTRATE, ");
        sql.append("A.bNEATVALUE AS bNEATVALUE, ");
        sql.append("A.NEATVALUE AS NEATVALUE, ");
        sql.append("A.bDECVALUE AS bDECVALUE, ");
        sql.append("A.DECVALUE AS DECVALUE, ");
        sql.append("A.DECVALUECHG AS DECVALUECHG, ");
        sql.append("A.bNEATAMT AS bNEATAMT, ");
        sql.append("A.NEATAMT AS NEATAMT, ");
        sql.append("DEPT." + this.fName + " AS bDEPT_NAME, ");
        sql.append("DEPT." + this.fName + " AS DEPT_NAME, ");
        sql.append("KEEPER." + this.fName + " AS bKEEPER_NAME, ");
        sql.append("KEEPER." + this.fName + " AS KEEPER_NAME, ");
        sql.append("A.bREMARK AS bREMARK, ");
        sql.append("A.REMARK AS REMARK, ");
        sql.append("A.CHGREASON AS CHGREASON, ");
        sql.append("A.bEvalAssetValue AS bEvalAssetValue,");
        sql.append("A.evalAssetValue AS evalAssetValue,");
        sql.append("A.bEvalReInAccountDate AS bEvalReInAccountDate,");
        sql.append("A.evalReInAccountDate AS evalReInAccountDate,");
        sql.append("EVALDEPRMETHOD." + this.fName + " AS bEVALDeprMethod_name, ");
        sql.append("EVALDEPRMETHOD." + this.fName + " AS evalDeprMethod_name, ");
        sql.append("A.bEvalUseTermCount AS bEvalUseTermCount,");
        sql.append("A.evalUseTermCount AS evalUseTermCount,");
        sql.append("A.bEvalMonthRate AS bEvalMonthRate,");
        sql.append("A.evalMonthRate AS evalMonthRate,");
        sql.append("A.bEvalTaxLeftPeriod AS bEvalTaxLeftPeriod,");
        sql.append("A.evalTaxLeftPeriod AS evalTaxLeftPeriod,");
        sql.append("A.bEvalNeatLeftRate AS bEvalNeatLeftRate,");
        sql.append("A.evalNeatLeftRate AS evalNeatLeftRate,");
        sql.append("A.bEvalDeprPeriodNum AS bEvalDeprPeriodNum,");
        sql.append("A.evalDeprPeriodNum AS evalDeprPeriodNum,");
        sql.append("A.bEvalRemValue AS bEvalRemValue,");
        sql.append("A.evalRemValue AS evalRemValue,");
        sql.append("A.bEvalAddDepr AS bEvalAddDepr,");
        sql.append("A.evalAddDepr AS evalAddDepr,");
        sql.append("A.bEvalDecValue AS bEvalDecValue,");
        sql.append("A.evalDecValue AS evalDecValue,");
        sql.append("A.bEvalYearDepr AS bEvalYearDepr,");
        sql.append("A.evalYearDepr AS evalYearDepr,");
        sql.append("A.bEvalNeatValue AS bEvalNeatValue,");
        sql.append("A.evalNeatValue AS evalNeatValue,");
        sql.append("EVALMEASUREUNIT." + this.fName + " AS evalMeasureUnit_name, ");
        sql.append("A.bEvalNeatAmt AS bEvalNeatAmt,");
        sql.append("A.evalNeatAmt AS evalNeatAmt,");
        sql.append("A.BAKCARDID AS BAKCARDID,");
        sql.append("A.CHANGETYPE AS CHANGETYPE,");
        sql.append("CURRENCY.FPrecision AS bPREC, ");
        sql.append("CURRENCY.FPrecision AS PREC, ");
        sql.append("A.FCompanyID AS FCompanyID,");
        sql.append(" ACCOUNTDECVALUE.FNumber bACCOUNTDECVALUEFNumber, ");
        sql.append(" ACCOUNTDECVALUE.FName_l2 bACCOUNTDECVALUEFName_l2, ");
        sql.append(" ACCOUNTDECVALUE.FNumber ACCOUNTDECVALUEFNumber, ");
        sql.append(" ACCOUNTDECVALUE.FName_l2 ACCOUNTDECVALUEFName_l2, ");
        sql.append(" ACCOUNTACCUDEPR.FNumber bACCOUNTACCUDEPRFNumber, ");
        sql.append(" ACCOUNTACCUDEPR.FName_l2 bACCOUNTACCUDEPRFName_l2,  ");
        sql.append(" ACCOUNTACCUDEPR.FNumber ACCOUNTACCUDEPRFNumber, ");
        sql.append(" ACCOUNTACCUDEPR.FName_l2 ACCOUNTACCUDEPRFName_l2, ");
        sql.append(" ACCOUNTASSET.FNumber bACCOUNTASSETFNumber, ");
        sql.append(" ACCOUNTASSET.FName_l2 bACCOUNTASSETFName_l2, ");
        sql.append(" ACCOUNTASSET.FNumber ACCOUNTASSETFNumber, ");
        sql.append(" ACCOUNTASSET.FName_l2 ACCOUNTASSETFName_l2   ");
        sql.append(",A.FPropertyValueID AS FPropertyValueID, ");
        sql.append("A.BFPropertyValueID AS BFPropertyValueID ");
        sql.append(" FROM (");
        sql.append(this.getNewCardDetailSql());
        sql.append(") AS A ");
        sql.append(" LEFT OUTER JOIN T_FA_DepreciationMode AS EVALDEPRMETHOD ON A.evalDeprMethodID = EVALDEPRMETHOD.FID ");
        sql.append(" LEFT OUTER JOIN T_BD_MeasureUnit AS MEASUREUNITWL ON A.MeasureUnitWLID = MEASUREUNITWL.FID ");
        sql.append(" LEFT OUTER JOIN T_BD_AccountView AS ACCOUNTDECVALUE ON A.FAccountDecValueID = ACCOUNTDECVALUE.FID ");
        sql.append(" LEFT OUTER JOIN T_BD_AccountView AS ACCOUNTACCUDEPR ON A.FAccountAccuDeprID = ACCOUNTACCUDEPR.FID  ");
        sql.append(" LEFT OUTER JOIN T_BD_AccountView AS ACCOUNTASSET ON A.FAccountAssetID = ACCOUNTASSET.FID ");
        sql.append(" LEFT OUTER JOIN T_BD_Currency AS CURRENCY ON A.CurrencyID = CURRENCY.FID ");
        sql.append(" LEFT OUTER JOIN T_BD_Person AS KEEPER ON A.KeeperID = KEEPER.FID ");
        sql.append(" LEFT OUTER JOIN T_ORG_Admin AS DEPT ON A.DeptID = DEPT.FID ");
        sql.append(" LEFT OUTER JOIN V_FA_Cat AS ASSETCAT ON A.AssetCatID = ASSETCAT.FID ");
        sql.append(" LEFT OUTER JOIN T_BD_MeasureUnit AS MEASUREUNIT ON A.MeasureUnitID = MEASUREUNIT.FID ");
        sql.append("LEFT JOIN T_BD_MeasureUnit AS EVALMEASUREUNIT ON A.evalMeasureUnitWL = EVALMEASUREUNIT.FID ");
        sql.append(" LEFT OUTER JOIN V_FA_AlterMode AS ALTERMETHOD ON A.CHANGEMODE = ALTERMETHOD.FID ");
        sql.append(" LEFT OUTER JOIN V_FA_UseStatus AS USESTATUS ON A.UseStatusID = USESTATUS.FID ");
        sql.append(" LEFT OUTER JOIN V_FA_FaEconomicPurp AS ECONOMICPURP ON A.EconomicPurpID = ECONOMICPURP.FID ");
        sql.append(" LEFT OUTER JOIN T_BD_Address AS STORECITY ON A.StoreCityID = STORECITY.FID ");
        sql.append(" LEFT OUTER JOIN T_FA_DepreciationMode AS DEPRMETHOD ON A.DeprMethodID = DEPRMETHOD.FID ");
        if (this.filter != null && (this.filter.indexOf("asstActItem.fname_l2") != -1 || this.filter.indexOf("asstActType.fnumber") != -1)) {
            sql.append(" LEFT OUTER JOIN ").append(this.acctAsstTableName).append(" AS asstActItem ON A.FAsstActItem = asstActItem.FID AND A.fasstactTypeid = asstActItem.FAsstacttypeID");
            sql.append(" LEFT OUTER JOIN t_bd_asstacttype asstActType on asstActType.Fid = A.Fasstacttypeid");
        }
        if (this.filter != null && this.filter.indexOf("useDepartment.fnumber") != -1) {
            sql.append(" LEFT OUTER JOIN T_ORG_Admin AS USEDEPARTMENT ON A.FUseDepartmentID = USEDEPARTMENT.FID");
        }
        try {
            sql.append(this.def.getJoinPart("A.FPropertyValueID"));
            sql.append(this.def.getJoinPart("A.bFPropertyValueID", "b"));
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new RuntimeException(e);
        }
        String cond = this.getCondSql();
        if (cond != null && !cond.trim().equals("")) {
            sql.append(" WHERE ").append(cond);
        }
        sql.append(" ) AS B ");
        if (this.isVirCompany) {
            sql.append("LEFT OUTER JOIN " + this.getSumItemJoinSql("orgArchitecture") + " AS COMP ON B.FCompanyID = COMP.FID ");
        }
        sql.append("LEFT OUTER JOIN T_ORG_Company AS COMPANY ON B.FCompanyID = COMPANY.FID ");
        sql.append("LEFT OUTER JOIN T_BD_Currency AS BASECURRENCY ON COMPANY.FBaseCurrencyID = BASECURRENCY.FID ");
        sql.append("LEFT OUTER JOIN T_BD_ExchangeTable AS EXTABLE on EXTABLE.fid = COMPANY.FBASEEXGTABLEID ");
        sql.append("LEFT OUTER JOIN T_BD_ExchangeAux AS bEXAUX on bEXAUX.fexchangetableid = EXTABLE.fid AND bEXAUX.fsourcecurrencyid = B.bCurrencyID AND COMPANY.FbaseCurrencyID = bEXAUX.ftargetcurrencyid ");
        sql.append("LEFT OUTER JOIN T_BD_ExchangeAux AS EXAUX on EXAUX.fexchangetableid = EXTABLE.fid AND EXAUX.fsourcecurrencyid = B.CurrencyID AND COMPANY.FbaseCurrencyID = EXAUX.ftargetcurrencyid ");
        return sql.toString();
    }

    private String getChangeDetailSql() throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT ");
        sql.append(" newBosId('00000000') AS FId  , ");
        if (this.isVirCompany) {
            sql.append(this.sumOption.getStrNameFields() + ", ");
        }
        sql.append(this.getDetailSelectSql());
        if (this.isVirCompany) {
            sql.append(", ").append(this.sumOption.getStrLongNumberFields());
        }
        sql.append(" FROM (SELECT ");
        if (this.filter != null && (this.filter.indexOf("asstActItem.fname_l2") != -1 || this.filter.indexOf("asstActType.fnumber") != -1 || this.filter.indexOf("useDepartment.fnumber") != -1)) {
            sql.append("DISTINCT ");
        }
        sql.append("A.CardID AS CardID, ");
        sql.append("A.CUR_CARD_ID AS  CUR_CARD_ID, ");
        sql.append("A.bizNumber as bizNumber,");
        sql.append("A.voucherID as VoucherID,");
        sql.append("A.voucherNumber as voucherNUmber,");
        sql.append("SUBSTRING(TO_CHAR(A.CHANGEDATE,'yyyy-mm-dd'),0,10) AS CHANGEDATE, ");
        sql.append("A.BizDate AS BIZDATE, ");
        sql.append("ALTERMETHOD." + this.fName + " AS ALTERMETHOD_NAME, ");
        sql.append("A.bASSETNUMBER AS bASSETNUMBER, ");
        sql.append("A.ASSETNUMBER AS ASSETNUMBER, ");
        sql.append("A.bolderNUMBER AS bolderNUMBER, ");
        sql.append("A.olderNUMBER AS olderNUMBER, ");
        sql.append("A.bGroupNumber AS bGroupNumber, ");
        sql.append("A.groupNumber AS GroupNumber, ");
        sql.append("A.bASSETNAME AS bASSETNAME, ");
        sql.append("A.ASSETNAME AS ASSETNAME, ");
        sql.append("bASSETCAT." + this.fName + " AS bASSETCAT_NAME, ");
        sql.append("ASSETCAT." + this.fName + " AS ASSETCAT_NAME, ");
        sql.append("A.bASSETAMT AS bASSETAMT, ");
        sql.append("A.ASSETAMT AS ASSETAMT, ");
        sql.append("bMEASUREUNIT." + this.fName + " AS bMEASUREUNIT_NAME, ");
        sql.append("MEASUREUNIT." + this.fName + " AS MEASUREUNIT_NAME, ");
        sql.append("bUSESTATUS." + this.fName + " AS bUSESTATUS_NAME, ");
        sql.append("USESTATUS." + this.fName + " AS USESTATUS_NAME, ");
        sql.append("bECONOMICPURP." + this.fName + " AS bECONOMICPURP_NAME, ");
        sql.append("ECONOMICPURP." + this.fName + " AS ECONOMICPURP_NAME, ");
        sql.append("bSTORECITY." + this.fName + " AS bSTORECITY_NAME, ");
        sql.append("STORECITY." + this.fName + " AS STORECITY_NAME, ");
        sql.append("A.SPECS AS bUseDepartment, ");
        sql.append("A.SPECS AS UseDepartment, ");
        sql.append("A.SPECS AS bUsePerson, ");
        sql.append("A.SPECS AS UsePerson, ");
        sql.append("A.SPECS AS bCostCenter, ");
        sql.append("A.SPECS AS CostCenter, ");
        sql.append("A.bSPECS AS bSPECS, ");
        sql.append("A.SPECS AS SPECS, ");
        sql.append("A.bPAREA AS bPAREA, ");
        sql.append("A.PAREA AS PAREA, ");
        sql.append("A.bMFR AS bMFR, ");
        sql.append("A.MFR AS MFR, ");
        sql.append("A.bLEVFRDATE AS bLEVFRDATE, ");
        sql.append("A.LEVFRDATE AS LEVFRDATE, ");
        sql.append("A.bORIGINUNIT AS bORIGINUNIT, ");
        sql.append("A.ORIGINUNIT AS ORIGINUNIT, ");
        sql.append("A.PAPERNO AS PAPERNO, ");
        sql.append("bDEPRMETHOD." + this.fName + " AS bDEPRMETHOD_NAME, ");
        sql.append("DEPRMETHOD." + this.fName + " AS DEPRMETHOD_NAME, ");
        sql.append("bMEASUREUNITWL." + this.fName + " AS bMEASUREUNITWL_NAME, ");
        sql.append("MEASUREUNITWL." + this.fName + " AS MEASUREUNITWL_NAME, ");
        sql.append("A.bCurrencyID AS bCurrencyID, ");
        sql.append("bCURRENCY." + this.fName + " AS bCURRENCY_NAME, ");
        sql.append("A.currencyID AS currencyID, ");
        sql.append("CURRENCY." + this.fName + " AS CURRENCY_NAME, ");
        sql.append("A.bEXRATE AS bEXRATE, ");
        sql.append("A.EXRATE AS EXRATE, ");
        sql.append("A.bORIGINAMT AS bORIGINAMT, ");
        sql.append("A.ORIGINAMT AS ORIGINAMT, ");
        sql.append("A.bTAXORIGINAMT AS bTAXORIGINAMT, ");
        sql.append("A.TAXORIGINAMT AS TAXORIGINAMT, ");
        sql.append("A.BInputTax AS BInputTax, ");
        sql.append("A.InputTax AS InputTax, ");
        sql.append("A.BInputTaxRate AS BInputTaxRate, ");
        sql.append("A.InputTaxRate AS InputTaxRate, ");
        sql.append("A.BIsDeduct AS BIsDeduct, ");
        sql.append("A.IsDeduct AS IsDeduct, ");
        sql.append("A.bADDONS AS bADDONS, ");
        sql.append("A.ADDONS AS ADDONS, ");
        sql.append("A.bTREATMENTINCOME AS bTREATMENTINCOME, ");
        sql.append("A.TREATMENTINCOME AS TREATMENTINCOME, ");
        sql.append("A.bADDONFARE AS bADDONFARE, ");
        sql.append("A.ADDONFARE AS ADDONFARE, ");
        sql.append("A.bASSETVALUE AS bASSETVALUE, ");
        sql.append("A.ASSETVALUE AS ASSETVALUE, ");
        sql.append("A.ORIGINCHG AS ORIGINCHG, ");
        sql.append("A.bclrEvalValue as bclrEvalValue,");
        sql.append("A.clrEvalValue as clrEvalValue,");
        sql.append("A.bBUYVALUE AS bBUYVALUE, ");
        sql.append("A.BUYVALUE AS BUYVALUE, ");
        sql.append("A.bBUYACCUDEPR AS bBUYACCUDEPR, ");
        sql.append("A.BUYACCUDEPR AS BUYACCUDEPR, ");
        sql.append("A.bDELIVERDATE AS bDELIVERDATE, ");
        sql.append("A.DELIVERDATE AS DELIVERDATE, ");
        sql.append("A.STARTUSEDATE AS STARTUSEDATE, ");
        sql.append("A.bUSEYEARS AS bUSEYEARS, ");
        sql.append("A.USEYEARS AS USEYEARS, ");
        sql.append("A.bUSETERMCOUNT AS bUSETERMCOUNT, ");
        sql.append("A.USETERMCOUNT AS USETERMCOUNT, ");
        sql.append("A.bDEPRTERMCOUNT AS bDEPRTERMCOUNT, ");
        sql.append("A.DEPRTERMCOUNT AS DEPRTERMCOUNT, ");
        sql.append("A.LEFTTERMCONT AS LEFTTERMCOUNT, ");
        sql.append("A.bLEFTTERMCONT AS bLEFTTERMCOUNT, ");
        sql.append("A.bACCUDEPR AS bACCUDEPR, ");
        sql.append("A.ACCUDEPR AS ACCUDEPR, ");
        sql.append("A.ACCUDEPRCHG AS ACCUDEPRCHG,");
        sql.append("A.bACCUDEPRYEAR AS bACCUDEPRYEAR, ");
        sql.append("A.ACCUDEPRYEAR AS ACCUDEPRYEAR, ");
        sql.append("A.bNEATREMVALUE AS bNEATREMVALUE, ");
        sql.append("A.NEATREMVALUE AS NEATREMVALUE, ");
        sql.append("A.bNEATLEFTRATE AS bNEATLEFTRATE, ");
        sql.append("A.NEATLEFTRATE AS NEATLEFTRATE, ");
        sql.append("A.bNEATVALUE AS bNEATVALUE, ");
        sql.append("A.NEATVALUE AS NEATVALUE, ");
        sql.append("A.bDECVALUE AS bDECVALUE, ");
        sql.append("A.DECVALUE AS DECVALUE, ");
        sql.append("A.DECVALUECHG AS DECVALUECHG, ");
        sql.append("A.bNEATAMT AS bNEATAMT, ");
        sql.append("A.NEATAMT AS NEATAMT, ");
        sql.append("bDEPT." + this.fName + " AS bDEPT_NAME, ");
        sql.append("DEPT." + this.fName + " AS DEPT_NAME, ");
        sql.append("bKEEPER." + this.fName + " AS bKEEPER_NAME, ");
        sql.append("KEEPER." + this.fName + " AS KEEPER_NAME, ");
        sql.append("A.bREMARK AS bREMARK, ");
        sql.append("A.REMARK AS REMARK, ");
        sql.append("A.CHGREASON AS CHGREASON, ");
        sql.append("A.bEvalAssetValue AS bEvalAssetValue,");
        sql.append("A.evalAssetValue AS evalAssetValue,");
        sql.append("A.bEvalReInAccountDate AS bEvalReInAccountDate,");
        sql.append("A.evalReInAccountDate AS evalReInAccountDate,");
        sql.append("bEVALDEPRMETHOD." + this.fName + " AS bEVALDeprMethod_name, ");
        sql.append("EVALDEPRMETHOD." + this.fName + " AS evalDeprMethod_name, ");
        sql.append("A.bEvalUseTermCount AS bEvalUseTermCount,");
        sql.append("A.evalUseTermCount AS evalUseTermCount,");
        sql.append("A.bEvalMonthRate AS bEvalMonthRate,");
        sql.append("A.evalMonthRate AS evalMonthRate,");
        sql.append("A.bEvalTaxLeftPeriod AS bEvalTaxLeftPeriod,");
        sql.append("A.evalTaxLeftPeriod AS evalTaxLeftPeriod,");
        sql.append("A.bEvalNeatLeftRate AS bEvalNeatLeftRate,");
        sql.append("A.evalNeatLeftRate AS evalNeatLeftRate,");
        sql.append("A.bEvalDeprPeriodNum AS bEvalDeprPeriodNum,");
        sql.append("A.evalDeprPeriodNum AS evalDeprPeriodNum,");
        sql.append("A.bEvalRemValue AS bEvalRemValue,");
        sql.append("A.evalRemValue AS evalRemValue,");
        sql.append("A.bEvalAddDepr AS bEvalAddDepr,");
        sql.append("A.evalAddDepr AS evalAddDepr,");
        sql.append("A.bEvalDecValue AS bEvalDecValue,");
        sql.append("A.evalDecValue AS evalDecValue,");
        sql.append("A.bEvalYearDepr AS bEvalYearDepr,");
        sql.append("A.evalYearDepr AS evalYearDepr,");
        sql.append("A.bEvalNeatValue AS bEvalNeatValue,");
        sql.append("A.evalNeatValue AS evalNeatValue,");
        sql.append("EVALMEASUREUNIT." + this.fName + " AS evalMeasureUnit_name, ");
        sql.append("A.bEvalNeatAmt AS bEvalNeatAmt,");
        sql.append("A.evalNeatAmt AS evalNeatAmt,");
        sql.append("A.BAKCARDID AS BAKCARDID,");
        sql.append("A.CHANGETYPE AS CHANGETYPE,");
        sql.append("bCURRENCY.FPrecision AS bPREC, ");
        sql.append("CURRENCY.FPrecision AS PREC, ");
        sql.append("A.FCompanyID AS FCompanyID,");
        sql.append(" bACCOUNTDECVALUE.FNumber bACCOUNTDECVALUEFNumber, ");
        sql.append(" bACCOUNTDECVALUE.FName_l2 bACCOUNTDECVALUEFName_l2, ");
        sql.append(" ACCOUNTDECVALUE.FNumber ACCOUNTDECVALUEFNumber, ");
        sql.append(" ACCOUNTDECVALUE.FName_l2 ACCOUNTDECVALUEFName_l2, ");
        sql.append(" bACCOUNTACCUDEPR.FNumber bACCOUNTACCUDEPRFNumber, ");
        sql.append(" bACCOUNTACCUDEPR.FName_l2 bACCOUNTACCUDEPRFName_l2,  ");
        sql.append(" ACCOUNTACCUDEPR.FNumber ACCOUNTACCUDEPRFNumber, ");
        sql.append(" ACCOUNTACCUDEPR.FName_l2 ACCOUNTACCUDEPRFName_l2, ");
        sql.append(" bACCOUNTASSET.FNumber bACCOUNTASSETFNumber, ");
        sql.append(" bACCOUNTASSET.FName_l2 bACCOUNTASSETFName_l2, ");
        sql.append(" ACCOUNTASSET.FNumber ACCOUNTASSETFNumber, ");
        sql.append(" ACCOUNTASSET.FName_l2 ACCOUNTASSETFName_l2   ");
        sql.append(",A.FPropertyValueID AS FPropertyValueID, ");
        sql.append("A.BFPropertyValueID AS BFPropertyValueID ");
        String innerTempSql = this.getChangeBillDetailSql();
        String innerTempTable = this.addDataInnerTempTable(innerTempSql);
        sql.append(" FROM " + innerTempTable + " as A ");
        sql.append(" LEFT OUTER JOIN T_FA_DepreciationMode AS EVALDEPRMETHOD ON A.evalDeprMethodID = EVALDEPRMETHOD.FID ");
        sql.append(" LEFT OUTER JOIN T_FA_DepreciationMode AS bEVALDEPRMETHOD ON A.bevalDeprMethodID = bEVALDEPRMETHOD.FID ");
        sql.append(" LEFT OUTER JOIN T_BD_MeasureUnit AS MEASUREUNITWL ON A.MeasureUnitWLID = MEASUREUNITWL.FID ");
        sql.append(" LEFT OUTER JOIN T_BD_MeasureUnit AS bMEASUREUNITWL ON A.bMeasureUnitWLID = bMEASUREUNITWL.FID ");
        sql.append(" LEFT OUTER JOIN T_BD_AccountView AS ACCOUNTDECVALUE ON A.FAccountDecValueID = ACCOUNTDECVALUE.FID ");
        sql.append(" LEFT OUTER JOIN T_BD_AccountView AS bACCOUNTDECVALUE ON A.bFAccountDecValueID = bACCOUNTDECVALUE.FID ");
        sql.append(" LEFT OUTER JOIN T_BD_AccountView AS ACCOUNTACCUDEPR ON A.FAccountAccuDeprID = ACCOUNTACCUDEPR.FID  ");
        sql.append(" LEFT OUTER JOIN T_BD_AccountView AS bACCOUNTACCUDEPR ON A.bFAccountAccuDeprID = bACCOUNTACCUDEPR.FID ");
        sql.append(" LEFT OUTER JOIN T_BD_AccountView AS ACCOUNTASSET ON A.FAccountAssetID = ACCOUNTASSET.FID ");
        sql.append(" LEFT OUTER JOIN T_BD_AccountView AS bACCOUNTASSET ON A.bFAccountAssetID = bACCOUNTASSET.FID ");
        sql.append(" LEFT OUTER JOIN T_BD_Currency AS CURRENCY ON A.CurrencyID = CURRENCY.FID ");
        sql.append(" LEFT OUTER JOIN T_BD_Currency AS bCURRENCY ON A.bCurrencyID = bCURRENCY.FID ");
        sql.append(" LEFT OUTER JOIN T_BD_Person AS KEEPER ON A.KeeperID = KEEPER.FID ");
        sql.append(" LEFT OUTER JOIN T_BD_Person AS bKEEPER ON A.bKeeperID = bKEEPER.FID ");
        sql.append(" LEFT OUTER JOIN T_ORG_Admin AS DEPT ON A.DeptID = DEPT.FID ");
        sql.append(" LEFT OUTER JOIN T_ORG_Admin AS bDEPT ON A.bDeptID = bDEPT.FID ");
        sql.append(" LEFT OUTER JOIN V_FA_Cat AS ASSETCAT ON A.AssetCatID = ASSETCAT.FID ");
        sql.append(" LEFT OUTER JOIN V_FA_Cat AS bASSETCAT ON A.bAssetCatID = bASSETCAT.FID ");
        sql.append(" LEFT OUTER JOIN T_BD_MeasureUnit AS MEASUREUNIT ON A.MeasureUnitID = MEASUREUNIT.FID ");
        sql.append(" LEFT OUTER JOIN T_BD_MeasureUnit AS bMEASUREUNIT ON A.bMeasureUnitID = bMEASUREUNIT.FID ");
        sql.append(" LEFT JOIN T_BD_MeasureUnit AS EVALMEASUREUNIT ON A.evalMeasureUnitWL = EVALMEASUREUNIT.FID ");
        sql.append(" LEFT OUTER JOIN V_FA_AlterMode AS ALTERMETHOD ON A.CHANGEMODE = ALTERMETHOD.FID ");
        sql.append(" LEFT OUTER JOIN V_FA_UseStatus AS USESTATUS ON A.UseStatusID = USESTATUS.FID ");
        sql.append(" LEFT OUTER JOIN V_FA_UseStatus AS bUSESTATUS ON A.bUseStatusID = bUSESTATUS.FID ");
        sql.append(" LEFT OUTER JOIN V_FA_FaEconomicPurp AS ECONOMICPURP ON A.EconomicPurpID = ECONOMICPURP.FID ");
        sql.append(" LEFT OUTER JOIN V_FA_FaEconomicPurp AS bECONOMICPURP ON A.bEconomicPurpID = bECONOMICPURP.FID ");
        sql.append(" LEFT OUTER JOIN T_BD_Address AS STORECITY ON A.StoreCityID = STORECITY.FID ");
        sql.append(" LEFT OUTER JOIN T_BD_Address AS bSTORECITY ON A.bStoreCityID = bSTORECITY.FID ");
        sql.append(" LEFT OUTER JOIN T_FA_DepreciationMode AS DEPRMETHOD ON A.DeprMethodID = DEPRMETHOD.FID ");
        sql.append(" LEFT OUTER JOIN T_FA_DepreciationMode AS bDEPRMETHOD ON A.bDeprMethodID = bDEPRMETHOD.FID ");
        if (this.filter != null && (this.filter.indexOf("asstActItem.fname_l2") != -1 || this.filter.indexOf("asstActType.fnumber") != -1)) {
            sql.append(" LEFT OUTER JOIN ").append(this.acctAsstTableName).append(" AS asstActItem ON A.FAsstActItem = asstActItem.FID AND A.fasstactTypeid = asstActItem.FAsstacttypeID");
            sql.append(" LEFT OUTER JOIN t_bd_asstacttype asstActType on asstActType.Fid = A.Fasstacttypeid");
        }
        if (this.filter != null && this.filter.indexOf("useDepartment.fnumber") != -1) {
            sql.append(" LEFT OUTER JOIN T_ORG_Admin AS USEDEPARTMENT ON A.FUseDepartmentID = USEDEPARTMENT.FID");
        }
        try {
            sql.append(this.def.getJoinPart("A.FPropertyValueID"));
            sql.append(this.def.getJoinPart("A.bFPropertyValueID", "b"));
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new RuntimeException(e);
        }
        String cond = this.getCondSql();
        if (cond != null && !cond.trim().equals("")) {
            sql.append(" WHERE ").append(cond);
        }
        sql.append(" ) AS B ");
        if (this.isVirCompany) {
            sql.append("LEFT OUTER JOIN " + this.getSumItemJoinSql("orgArchitecture") + " AS COMP ON B.FCompanyID = COMP.FID ");
        }
        sql.append("LEFT OUTER JOIN T_ORG_Company AS COMPANY ON B.FCompanyID = COMPANY.FID ");
        sql.append("LEFT OUTER JOIN T_BD_Currency AS BASECURRENCY ON COMPANY.FBaseCurrencyID = BASECURRENCY.FID ");
        sql.append("LEFT OUTER JOIN T_BD_ExchangeTable AS EXTABLE on EXTABLE.fid = COMPANY.FBASEEXGTABLEID ");
        sql.append("LEFT OUTER JOIN T_BD_ExchangeAux AS bEXAUX on bEXAUX.fexchangetableid = EXTABLE.fid AND bEXAUX.fsourcecurrencyid = B.bCurrencyID AND COMPANY.FbaseCurrencyID = bEXAUX.ftargetcurrencyid ");
        sql.append("LEFT OUTER JOIN T_BD_ExchangeAux AS EXAUX on EXAUX.fexchangetableid = EXTABLE.fid AND EXAUX.fsourcecurrencyid = B.CurrencyID AND COMPANY.FbaseCurrencyID = EXAUX.ftargetcurrencyid ");
        return sql.toString();
    }

    private String getDetailSelectSql() {
        StringBuffer sqlSelect = new StringBuffer();
        sqlSelect.append("B.CardID AS CardID, ");
        sqlSelect.append("B.bizNumber AS bizNumber,");
        sqlSelect.append("B.voucherID AS voucherID,");
        sqlSelect.append("B.voucherNumber AS voucherNumber,");
        sqlSelect.append("B.CHANGEDATE AS CHANGEDATE, ");
        sqlSelect.append("CASE WHEN B.BizDate IS NULL THEN GETDATE() ELSE B.BizDate END AS BIZDATE, ");
        sqlSelect.append("B.ALTERMETHOD_NAME AS ALTERMETHOD_NAME, ");
        sqlSelect.append("B.bASSETNUMBER AS bASSETNUMBER, ");
        sqlSelect.append("B.ASSETNUMBER AS ASSETNUMBER, ");
        sqlSelect.append("B.bOlderNumber AS bOlderNumber, ");
        sqlSelect.append("B.OlderNumber AS OlderNumber, ");
        sqlSelect.append("B.bgroupNumber AS bGroupNumber, ");
        sqlSelect.append("B.groupNumber AS groupNumber, ");
        sqlSelect.append("B.bASSETNAME AS bASSETNAME, ");
        sqlSelect.append("B.ASSETNAME AS ASSETNAME, ");
        sqlSelect.append("B.bASSETCAT_NAME AS bASSETCAT_NAME, ");
        sqlSelect.append("B.ASSETCAT_NAME AS ASSETCAT_NAME, ");
        sqlSelect.append("B.bASSETAMT AS bASSETAMT, ");
        sqlSelect.append("B.ASSETAMT AS ASSETAMT, ");
        sqlSelect.append("B.bMEASUREUNIT_NAME AS bMEASUREUNIT_NAME, ");
        sqlSelect.append("B.MEASUREUNIT_NAME AS MEASUREUNIT_NAME, ");
        sqlSelect.append("B.bUSESTATUS_NAME AS bUSESTATUS_NAME, ");
        sqlSelect.append("B.USESTATUS_NAME AS USESTATUS_NAME, ");
        sqlSelect.append("B.bECONOMICPURP_NAME AS bECONOMICPURP_NAME, ");
        sqlSelect.append("B.ECONOMICPURP_NAME AS ECONOMICPURP_NAME,");
        sqlSelect.append("B.bSTORECITY_NAME AS bSTORECITY_NAME,");
        sqlSelect.append("B.STORECITY_NAME AS STORECITY_NAME, ");
        sqlSelect.append("B.bUseDepartment AS bUseDepartment, ");
        sqlSelect.append("B.UseDepartment AS UseDepartment, ");
        sqlSelect.append("B.bUsePerson AS bUsePerson, ");
        sqlSelect.append("B.UsePerson AS UsePerson, ");
        sqlSelect.append("B.bCostCenter AS bCostCenter, ");
        sqlSelect.append("B.SPECS AS CostCenter, ");
        sqlSelect.append("B.bSPECS AS bSPECS, ");
        sqlSelect.append("B.SPECS AS SPECS, ");
        sqlSelect.append("B.bPAREA AS bPAREA, ");
        sqlSelect.append("B.PAREA AS PAREA, ");
        sqlSelect.append("B.bMFR AS bMFR, ");
        sqlSelect.append("B.MFR AS MFR, ");
        sqlSelect.append("B.bLEVFRDATE AS bLEVFRDATE, ");
        sqlSelect.append("B.LEVFRDATE AS LEVFRDATE, ");
        sqlSelect.append("B.bORIGINUNIT AS bORIGINUNIT, ");
        sqlSelect.append("B.ORIGINUNIT AS ORIGINUNIT, ");
        sqlSelect.append("B.PAPERNO AS PAPERNO, ");
        sqlSelect.append("B.bDEPRMETHOD_NAME AS bDEPRMETHOD_NAME, ");
        sqlSelect.append("B.DEPRMETHOD_NAME AS DEPRMETHOD_NAME, ");
        sqlSelect.append("B.bMEASUREUNITWL_NAME AS bMEASUREUNITWL_NAME, ");
        sqlSelect.append("B.MEASUREUNITWL_NAME AS MEASUREUNITWL_NAME, ");
        sqlSelect.append("B.bCURRENCY_NAME AS bCURRENCY_NAME, ");
        sqlSelect.append("B.CURRENCY_NAME AS CURRENCY_NAME, ");
        sqlSelect.append("B.bEXRATE AS bEXRATE, ");
        sqlSelect.append("B.EXRATE AS EXRATE, ");
        sqlSelect.append("B.bORIGINAMT AS bORIGINAMT, ");
        sqlSelect.append("B.ORIGINAMT AS ORIGINAMT, ");
        sqlSelect.append("B.bTAXORIGINAMT AS bTAXORIGINAMT, ");
        sqlSelect.append("B.TAXORIGINAMT AS TAXORIGINAMT, ");
        sqlSelect.append("B.BInputTax AS BInputTax, ");
        sqlSelect.append("B.InputTax AS InputTax, ");
        sqlSelect.append("B.BInputTaxRate AS BInputTaxRate, ");
        sqlSelect.append("B.InputTaxRate AS InputTaxRate, ");
        sqlSelect.append("B.BIsDeduct AS BIsDeduct, ");
        sqlSelect.append("B.IsDeduct AS IsDeduct, ");
        sqlSelect.append("B.bADDONS AS bADDONS, ");
        sqlSelect.append("B.ADDONS AS ADDONS, ");
        sqlSelect.append("B.bTREATMENTINCOME AS bTREATMENTINCOME, ");
        sqlSelect.append("B.TREATMENTINCOME AS TREATMENTINCOME, ");
        sqlSelect.append("B.bADDONFARE AS bADDONFARE, ");
        sqlSelect.append("B.ADDONFARE AS ADDONFARE, ");
        sqlSelect.append("B.bASSETVALUE AS bASSETVALUE, ");
        sqlSelect.append("B.ASSETVALUE AS ASSETVALUE, ");
        sqlSelect.append("B.ORIGINCHG AS ORIGINCHG, ");
        sqlSelect.append("B.bclrEvalValue as bclrEvalValue,");
        sqlSelect.append("B.clrEvalValue as clrEvalValue,");
        sqlSelect.append("B.bBUYVALUE AS bBUYVALUE, ");
        sqlSelect.append("B.BUYVALUE AS BUYVALUE, ");
        sqlSelect.append("B.bBUYACCUDEPR AS bBUYACCUDEPR, ");
        sqlSelect.append("B.BUYACCUDEPR AS BUYACCUDEPR, ");
        sqlSelect.append("B.bDELIVERDATE AS bDELIVERDATE, ");
        sqlSelect.append("B.DELIVERDATE AS DELIVERDATE, ");
        sqlSelect.append("B.STARTUSEDATE AS STARTUSEDATE, ");
        sqlSelect.append("B.bUSEYEARS AS bUSEYEARS, ");
        sqlSelect.append("B.USEYEARS AS USEYEARS, ");
        sqlSelect.append("B.bUSETERMCOUNT AS bUSETERMCOUNT, ");
        sqlSelect.append("B.USETERMCOUNT AS USETERMCOUNT, ");
        sqlSelect.append("B.bDEPRTERMCOUNT AS bDEPRTERMCOUNT, ");
        sqlSelect.append("B.DEPRTERMCOUNT AS DEPRTERMCOUNT, ");
        sqlSelect.append("B.LEFTTERMCOUNT AS LEFTTERMCOUNT, ");
        sqlSelect.append("B.bLEFTTERMCOUNT AS bLEFTTERMCOUNT, ");
        sqlSelect.append("B.bACCUDEPR AS bACCUDEPR, ");
        sqlSelect.append("B.ACCUDEPR AS ACCUDEPR, ");
        sqlSelect.append("B.ACCUDEPRCHG AS ACCUDEPRCHG,");
        sqlSelect.append("B.bACCUDEPRYEAR AS bACCUDEPRYEAR, ");
        sqlSelect.append("B.ACCUDEPRYEAR AS ACCUDEPRYEAR, ");
        sqlSelect.append("B.bNEATREMVALUE AS bNEATREMVALUE, ");
        sqlSelect.append("B.NEATREMVALUE AS NEATREMVALUE, ");
        sqlSelect.append("B.bNEATLEFTRATE AS bNEATLEFTRATE, ");
        sqlSelect.append("B.NEATLEFTRATE AS NEATLEFTRATE, ");
        sqlSelect.append("B.bNEATVALUE AS bNEATVALUE, ");
        sqlSelect.append("B.NEATVALUE AS NEATVALUE, ");
        sqlSelect.append("B.bDECVALUE AS bDECVALUE, ");
        sqlSelect.append("B.DECVALUE AS DECVALUE, ");
        sqlSelect.append("B.DECVALUECHG AS DECVALUECHG, ");
        sqlSelect.append("B.bNEATAMT AS bNEATAMT, ");
        sqlSelect.append("B.NEATAMT AS NEATAMT, ");
        sqlSelect.append("COMPANY.").append(this.fName).append(" AS COMPANY_NAME, ");
        sqlSelect.append("B.bDEPT_NAME AS bDEPT_NAME, ");
        sqlSelect.append("B.DEPT_NAME AS DEPT_NAME, ");
        sqlSelect.append("B.bKEEPER_NAME AS bKEEPER_NAME, ");
        sqlSelect.append("B.KEEPER_NAME AS KEEPER_NAME, ");
        sqlSelect.append("B.bREMARK AS bREMARK, ");
        sqlSelect.append("B.REMARK AS REMARK, ");
        sqlSelect.append("B.CHGREASON AS CHGREASON, ");
        sqlSelect.append("B.BAKCARDID AS BAKCARDID,");
        sqlSelect.append("B.CHANGETYPE AS CHANGETYPE, ");
        sqlSelect.append("B.bPREC AS bPREC, ");
        sqlSelect.append("B.PREC AS PREC, ");
        sqlSelect.append("bEXAUX.fprecision AS bEXRATEPREC, ");
        sqlSelect.append("EXAUX.fprecision AS EXRATEPREC, ");
        sqlSelect.append("B.bEvalAssetValue as bEvalAssetValue, ");
        sqlSelect.append("B.evalAssetValue as evalAssetValue, ");
        sqlSelect.append("B.bEvalReInAccountDate as bEvalReInAccountDate, ");
        sqlSelect.append("B.evalReInAccountDate as evalReInAccountDate, ");
        sqlSelect.append("B.bEvalDeprMethod_name AS bEvalDeprMethod_name, ");
        sqlSelect.append("B.evalDeprMethod_name AS evalDeprMethod_name, ");
        sqlSelect.append("B.bEvalUseTermCount AS bEvalUseTermCount, ");
        sqlSelect.append("B.evalUseTermCount AS evalUseTermCount, ");
        sqlSelect.append("B.bEvalMonthRate AS bEvalMonthRate, ");
        sqlSelect.append("B.evalMonthRate AS evalMonthRate, ");
        sqlSelect.append("B.bEvalTaxLeftPeriod AS bEvalTaxLeftPeriod, ");
        sqlSelect.append("B.evalTaxLeftPeriod AS evalTaxLeftPeriod, ");
        sqlSelect.append("B.bEvalNeatLeftRate AS bEvalNeatLeftRate, ");
        sqlSelect.append("B.evalNeatLeftRate AS evalNeatLeftRate, ");
        sqlSelect.append("B.bEvalDeprPeriodNum AS bEvalDeprPeriodNum, ");
        sqlSelect.append("B.evalDeprPeriodNum AS evalDeprPeriodNum, ");
        sqlSelect.append("B.bEvalRemValue AS bEvalRemValue, ");
        sqlSelect.append("B.evalRemValue AS evalRemValue, ");
        sqlSelect.append("B.bEvalAddDepr AS bEvalAddDepr, ");
        sqlSelect.append("B.evalAddDepr AS evalAddDepr, ");
        sqlSelect.append("B.bEvalDecValue AS bEvalDecValue, ");
        sqlSelect.append("B.evalDecValue AS evalDecValue, ");
        sqlSelect.append("B.bEvalYearDepr AS bEvalYearDepr, ");
        sqlSelect.append("B.evalYearDepr AS evalYearDepr, ");
        sqlSelect.append("B.bEvalNeatValue AS bEvalNeatValue, ");
        sqlSelect.append("B.evalNeatValue AS evalNeatValue, ");
        sqlSelect.append("B.evalMeasureUnit_name AS evalMeasureUnit_name, ");
        sqlSelect.append("B.bEvalNeatAmt AS bEvalNeatAmt, ");
        sqlSelect.append("B.evalNeatAmt AS evalNeatAmt, ");
        sqlSelect.append("BASECURRENCY.FPrecision AS BASEPREC, ");
        sqlSelect.append("COMPANY.FID AS COMPANY_ID,");
        sqlSelect.append(" CASE  WHEN (bACCOUNTDECVALUEFName_l2 IS NULL) THEN NULL ELSE ((bACCOUNTDECVALUEFNumber || ' - ') ||bACCOUNTDECVALUEFName_l2) END AS bACCOUNTDEVVALUE_DISPNAME, ");
        sqlSelect.append(" CASE  WHEN (ACCOUNTDECVALUEFName_l2 IS NULL) THEN NULL ELSE ((ACCOUNTDECVALUEFNumber || ' - ') || ACCOUNTDECVALUEFName_l2) END AS ACCOUNTDEVVALUE_DISPNAME, ");
        sqlSelect.append(" CASE  WHEN (bACCOUNTACCUDEPRFName_l2 IS NULL) THEN NULL ELSE ((bACCOUNTACCUDEPRFNumber || ' - ') || bACCOUNTACCUDEPRFName_l2) END AS bACCOUNTACCUDEPR_DISPNAME,  ");
        sqlSelect.append(" CASE  WHEN (ACCOUNTACCUDEPRFName_l2 IS NULL) THEN NULL ELSE ((ACCOUNTACCUDEPRFNumber || ' - ') || ACCOUNTACCUDEPRFName_l2) END AS ACCOUNTACCUDEPR_DISPNAME, ");
        sqlSelect.append(" CASE  WHEN (bACCOUNTASSETFName_l2 IS NULL) THEN NULL ELSE ((bACCOUNTASSETFNumber || ' - ') || bACCOUNTASSETFName_l2) END AS bACCOUNTASSET_DISPNAME, ");
        sqlSelect.append(" CASE  WHEN (ACCOUNTASSETFName_l2 IS NULL) THEN NULL ELSE ((ACCOUNTASSETFNumber || ' - ') || ACCOUNTASSETFName_l2) END AS ACCOUNTASSET_DISPNAME , ");
        sqlSelect.append("0 AS isSum ");
        sqlSelect.append(",B.FPropertyValueID AS FPropertyValueID, ");
        sqlSelect.append("B.BFPropertyValueID AS BFPropertyValueID ");
        if (this.isVirCompany) {
            sqlSelect.append(",COMPANY.FLevel AS SumLevel");
        }
        return sqlSelect.toString();
    }

    private String getSumSelectSql() {
        StringBuffer sqlSelect = new StringBuffer();
        sqlSelect.append("TO_CHAR(NULL) AS bizNumber, ");
        sqlSelect.append("TO_CHAR(NULL) AS voucherID, ");
        sqlSelect.append("TO_CHAR(NULL) AS voucherNumber, ");
        sqlSelect.append("TO_CHAR(NULL) AS CardID, ");
        sqlSelect.append("TO_CHAR(NULL) AS CHANGEDATE, ");
        sqlSelect.append("TO_DATE(NULL) AS BIZDATE, ");
        sqlSelect.append("TO_CHAR(NULL) AS ALTERMETHOD_NAME, ");
        sqlSelect.append("TO_CHAR(NULL) AS bASSETNUMBER, ");
        sqlSelect.append("TO_CHAR(NULL) AS ASSETNUMBER, ");
        sqlSelect.append("TO_CHAR(NULL) AS bOLDERNUMBER, ");
        sqlSelect.append("TO_CHAR(NULL) AS OLDERNUMBER, ");
        sqlSelect.append("TO_CHAR(NULL) AS bGROUPNUMBER, ");
        sqlSelect.append("TO_CHAR(NULL) AS GROUPNUMBER, ");
        sqlSelect.append("TO_CHAR(NULL) AS bASSETNAME, ");
        sqlSelect.append("TO_CHAR(NULL) AS ASSETNAME, ");
        sqlSelect.append("TO_CHAR(NULL) AS bASSETCAT_NAME, ");
        sqlSelect.append("TO_CHAR(NULL) AS ASSETCAT_NAME, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS bASSETAMT, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS ASSETAMT, ");
        sqlSelect.append("TO_CHAR(NULL) AS bMEASUREUNIT_NAME, ");
        sqlSelect.append("TO_CHAR(NULL) AS MEASUREUNIT_NAME, ");
        sqlSelect.append("TO_CHAR(NULL) AS bUSESTATUS_NAME, ");
        sqlSelect.append("TO_CHAR(NULL) AS USESTATUS_NAME, ");
        sqlSelect.append("TO_CHAR(NULL) AS bECONOMICPURP_NAME, ");
        sqlSelect.append("TO_CHAR(NULL) AS ECONOMICPURP_NAME,");
        sqlSelect.append("TO_CHAR(NULL) AS bSTORECITY_NAME,");
        sqlSelect.append("TO_CHAR(NULL) AS STORECITY_NAME, ");
        sqlSelect.append("TO_CHAR(NULL) AS bUseDepartment, ");
        sqlSelect.append("TO_CHAR(NULL) AS UseDepartment, ");
        sqlSelect.append("TO_CHAR(NULL) AS bUsePerson, ");
        sqlSelect.append("TO_CHAR(NULL) AS UsePerson, ");
        sqlSelect.append("TO_CHAR(NULL) AS bCostCenter, ");
        sqlSelect.append("TO_CHAR(NULL) AS CostCenter, ");
        sqlSelect.append("TO_CHAR(NULL) AS bSPECS, ");
        sqlSelect.append("TO_CHAR(NULL) AS SPECS, ");
        sqlSelect.append("TO_CHAR(NULL) AS bPAREA, ");
        sqlSelect.append("TO_CHAR(NULL) AS PAREA, ");
        sqlSelect.append("TO_CHAR(NULL) AS bMFR, ");
        sqlSelect.append("TO_CHAR(NULL) AS MFR, ");
        sqlSelect.append("TO_DATE(NULL) AS bLEVFRDATE, ");
        sqlSelect.append("TO_DATE(NULL) AS LEVFRDATE, ");
        sqlSelect.append("TO_CHAR(NULL) AS bORIGINUNIT, ");
        sqlSelect.append("TO_CHAR(NULL) AS ORIGINUNIT, ");
        sqlSelect.append("TO_CHAR(NULL) AS PAPERNO, ");
        sqlSelect.append("TO_CHAR(NULL) AS bDEPRMETHOD_NAME, ");
        sqlSelect.append("TO_CHAR(NULL) AS DEPRMETHOD_NAME, ");
        sqlSelect.append("TO_CHAR(NULL) AS bMEASUREUNITWL_NAME, ");
        sqlSelect.append("TO_CHAR(NULL) AS MEASUREUNITWL_NAME, ");
        sqlSelect.append("TO_CHAR(NULL) AS bCURRENCY_NAME, ");
        sqlSelect.append("TO_CHAR(NULL) AS CURRENCY_NAME, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS bEXRATE, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS EXRATE, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS bORIGINAMT, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS ORIGINAMT, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS bTAXORIGINAMT, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS TAXORIGINAMT, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS BInputTax, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS InputTax, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS BInputTaxRate, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS InputTaxRate, ");
        sqlSelect.append("TO_INT(NULL) AS BIsDeduct, ");
        sqlSelect.append("TO_INT(NULL) AS IsDeduct, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS bADDONS, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS ADDONS, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS bTREATMENTINCOME, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS TREATMENTINCOME, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS bADDONFARE, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS ADDONFARE, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS bASSETVALUE, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS ASSETVALUE, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS ORIGINCHG, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS bclrEvalValue,");
        sqlSelect.append("TO_DECIMAL(NULL) AS clrEvalValue,");
        sqlSelect.append("TO_DECIMAL(NULL) AS bBUYVALUE, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS BUYVALUE, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS bBUYACCUDEPR, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS BUYACCUDEPR, ");
        sqlSelect.append("TO_DATE(NULL) AS bDELIVERDATE, ");
        sqlSelect.append("TO_DATE(NULL) AS DELIVERDATE, ");
        sqlSelect.append("TO_DATE(NULL) AS STARTUSEDATE, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS bUSEYEARS, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS USEYEARS, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS bUSETERMCOUNT, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS USETERMCOUNT, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS bDEPRTERMCOUNT, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS DEPRTERMCOUNT, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS LEFTTERMCOUNT, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS bLEFTTERMCOUNT, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS bACCUDEPR, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS ACCUDEPR, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS ACCUDEPRCHG,");
        sqlSelect.append("TO_DECIMAL(NULL) AS bACCUDEPRYEAR, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS ACCUDEPRYEAR, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS bNEATREMVALUE, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS NEATREMVALUE, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS bNEATLEFTRATE, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS NEATLEFTRATE, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS bNEATVALUE, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS NEATVALUE, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS bDECVALUE, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS DECVALUE, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS DECVALUECHG, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS bNEATAMT, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS NEATAMT, ");
        sqlSelect.append("TO_CHAR(NULL) AS COMPANY_NAME, ");
        sqlSelect.append("TO_CHAR(NULL) AS bDEPT_NAME, ");
        sqlSelect.append("TO_CHAR(NULL) AS DEPT_NAME, ");
        sqlSelect.append("TO_CHAR(NULL) AS bKEEPER_NAME, ");
        sqlSelect.append("TO_CHAR(NULL) AS KEEPER_NAME, ");
        sqlSelect.append("TO_CHAR(NULL) AS bREMARK, ");
        sqlSelect.append("TO_CHAR(NULL) AS REMARK, ");
        sqlSelect.append("TO_CHAR(NULL) AS CHGREASON, ");
        sqlSelect.append("TO_CHAR(NULL) AS BAKCARDID,");
        sqlSelect.append("TO_DECIMAL(NULL) AS CHANGETYPE, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS bPREC, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS PREC, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS bEXRATEPREC, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS EXRATEPREC, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS bEvalAssetValue, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS evalAssetValue, ");
        sqlSelect.append("TO_DATE(NULL) AS bEvalReInAccountDate, ");
        sqlSelect.append("TO_DATE(NULL) AS evalReInAccountDate, ");
        sqlSelect.append("TO_CHAR(NULL) AS bEvalDeprMethod_name, ");
        sqlSelect.append("TO_CHAR(NULL) AS evalDeprMethod_name, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS bEvalUseTermCount, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS evalUseTermCount, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS bEvalMonthRate, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS evalMonthRate, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS bEvalTaxLeftPeriod, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS evalTaxLeftPeriod, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS bEvalNeatLeftRate, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS evalNeatLeftRate, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS bEvalDeprPeriodNum, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS evalDeprPeriodNum, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS bEvalRemValue, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS evalRemValue, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS bEvalAddDepr, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS evalAddDepr, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS bEvalDecValue, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS evalDecValue, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS bEvalYearDepr, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS evalYearDepr, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS bEvalNeatValue, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS evalNeatValue, ");
        sqlSelect.append("TO_CHAR(NULL) AS evalMeasureUnit_name, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS bEvalNeatAmt, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS evalNeatAmt, ");
        sqlSelect.append("TO_DECIMAL(NULL) AS BASEPREC, ");
        sqlSelect.append("TO_CHAR(null) AS COMPANY_ID,");
        sqlSelect.append("TO_CHAR(NULL)  AS bACCOUNTASSET_DISPNAME,");
        sqlSelect.append("TO_CHAR(NULL)  AS ACCOUNTASSET_DISPNAME,");
        sqlSelect.append("TO_CHAR(NULL)  AS bACCOUNTDEVVALUE_DISPNAME,");
        sqlSelect.append("TO_CHAR(NULL)  AS ACCOUNTDEVVALUE_DISPNAME,");
        sqlSelect.append("TO_CHAR(NULL)  AS bACCOUNTACCUDEPR_DISPNAME,");
        sqlSelect.append("TO_CHAR(NULL)  AS ACCOUNTACCUDEPR_DISPNAME, ");
        sqlSelect.append("1 AS isSum ");
        sqlSelect.append(",TO_CHAR(NULL)  AS FPropertyValueID, ");
        sqlSelect.append("TO_CHAR(NULL)  AS BFPropertyValueID ");
        return sqlSelect.toString();
    }

    private String getNewCardDetailSql() {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");
        sql.append(this.getCardSelecSQL("C", "FFaCurCardID"));
        sql.append("C.fnumber AS bizNumber,");
        sql.append("C.fvoucher AS voucherID,");
        sql.append("C.fvoucherNumber AS voucherNumber,");
        sql.append("C.FBILLTYPE,");
        sql.append("C.FCompanyID, ");
        sql.append("C.FREMARK AS CHGREASON, ");
        sql.append("C.FFIAccountDate AS CHANGEDATE, ");
        sql.append("C.FBizDate AS BIZDATE, ");
        sql.append("C.FORIGINMETHODID AS CHANGEMODE, ");
        sql.append("C.FAssetValue AS ORIGINCHG, ");
        sql.append("CASE  when (C.FIsEvaledBefore>0) then C.flastEvalValue else ( TO_DECIMAL(NULL) ) end as  bclrEvalValue, ");
        sql.append("CASE  when (C.FIsEvaledBefore>0) then C.finitevalvalue else ( TO_DECIMAL(NULL) ) end as  clrEvalValue, ");
        sql.append("C.FAccuDepr AS ACCUDEPRCHG, ");
        sql.append("C.FDecValue AS DECVALUECHG, ");
        sql.append("'' AS BAKCARDID,");
        if (this.filter != null && (this.filter.indexOf("asstActItem.fname_l2") != -1 || this.filter.indexOf("asstActType.fnumber") != -1)) {
            sql.append("COMPOSIT.FAsstActItem AS FAsstActItem, COMPOSIT.Fasstacttype AS fasstactTypeid,");
        }
        if (this.filter != null && this.filter.indexOf("useDepartment.fnumber") != -1) {
            sql.append("FADEPARTMENT.FUseDepartmentID AS FUseDepartmentID, ");
        }
        sql.append("1 AS CHANGETYPE ");
        sql.append("FROM T_FA_FABAKCARD AS C ");
        sql.append("INNER JOIN T_FA_FACURCARD AS E ON C.FFACURCARDID = E.FID ");
        if (this.filter != null && (this.filter.indexOf("asstActItem.fname_l2") != -1 || this.filter.indexOf("asstActType.fnumber") != -1)) {
            sql.append(" INNER JOIN T_FA_FaBakCostCenter AS FACOSTCENTER ON C.FID = FACOSTCENTER.FFABakCARDID");
            sql.append(" LEFT OUTER JOIN T_FA_FABakASSTACTCOMPOSIT COMPOSIT ON COMPOSIT.FFABakCOSTCENTERID = FACOSTCENTER.FID");
            sql.append(" LEFT OUTER JOIN t_bd_asstacttype asstType on asstType.Fid = COMPOSIT.FAsstActType");
        }
        if (this.filter != null && this.filter.indexOf("useDepartment.fnumber") != -1) {
            sql.append(" INNER JOIN T_FA_FaBakDepartment AS FADEPARTMENT ON C.FID = FADEPARTMENT.FFABAKCARDID");
        }
        sql.append(" INNER JOIN T_BD_Period AS PERIOD ON C.FPeriodID = PERIOD.FID");
        sql.append(" WHERE C.FCOMPANYID IN (").append(this.strCompanyInclude).append(") ");
        sql.append(this.getPeriodCond());
        sql.append(" AND C.FBILLTYPE = 1");
        sql.append(" AND C.FCheckedStatus = 2");
        if (this.isShowNotAudit) {
            sql.append(" UNION ALL ");
            sql.append("SELECT ");
            sql.append(this.getCardSelecSQL("C", "FID"));
            sql.append("C.fnumber AS bizNumber,");
            sql.append("C.fvoucher AS voucherID,");
            sql.append("C.fvoucherNumber AS voucherNumber,");
            sql.append(1).append(" AS FBILLTYPE,");
            sql.append("C.FCompanyID, ");
            sql.append("C.FREMARK AS CHGREASON, ");
            sql.append("C.FFIAccountDate AS CHANGEDATE, ");
            sql.append("C.FBizDate AS BIZDATE, ");
            sql.append("C.FORIGINMETHODID AS CHANGEMODE, ");
            sql.append("C.FAssetValue AS ORIGINCHG, ");
            sql.append("C.flastEvalValue AS bclrEvalValue,");
            sql.append("C.finitevalvalue AS clrEvalValue,");
            sql.append("C.FAccuDepr AS ACCUDEPRCHG, ");
            sql.append("C.FDecValue AS DECVALUECHG, ");
            sql.append("'' AS BAKCARDID,");
            if (this.filter != null && (this.filter.indexOf("asstActItem.fname_l2") != -1 || this.filter.indexOf("asstActType.fnumber") != -1)) {
                sql.append("COMPOSIT.FAsstActItem AS FAsstActItem, COMPOSIT.Fasstacttype AS fasstactTypeid,");
            }
            if (this.filter != null && this.filter.indexOf("useDepartment.fnumber") != -1) {
                sql.append("FADEPARTMENT.FUseDepartmentID AS FUseDepartmentID, ");
            }
            sql.append("1 AS CHANGETYPE ");
            sql.append("FROM T_FA_FACURCARD AS C ");
            if (this.filter != null && (this.filter.indexOf("asstActItem.fname_l2") != -1 || this.filter.indexOf("asstActType.fnumber") != -1)) {
                sql.append(" INNER JOIN T_FA_FaCurCostCenter AS FACOSTCENTER ON C.FID = FACOSTCENTER.FFACURCARDID");
                sql.append(" LEFT OUTER JOIN T_FA_FACurASSTACTCOMPOSIT COMPOSIT ON COMPOSIT.FFACurCOSTCENTERID = FACOSTCENTER.FID");
                sql.append(" LEFT OUTER JOIN t_bd_asstacttype asstType on asstType.Fid = COMPOSIT.FAsstActType");
            }
            if (this.filter != null && this.filter.indexOf("useDepartment.fnumber") != -1) {
                sql.append(" INNER JOIN T_FA_FaCurDepartment AS FADEPARTMENT ON C.FID = FADEPARTMENT.FFACURCARDID");
            }
            sql.append(" INNER JOIN T_BD_Period AS PERIOD ON C.FPeriodID = PERIOD.FID");
            sql.append(" WHERE C.FCOMPANYID IN (").append(this.strCompanyInclude).append(") ");
            sql.append(this.getPeriodCond());
            sql.append(" AND C.FEffectedStatus = 2 AND C.FCheckedStatus = 1");
        }
        return sql.toString();
    }

    private String getChangeBillDetailSql() {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");
        sql.append(this.getCardSelecSQL("E", "FFaCurCardID"));
        sql.append("A.fnumber AS bizNumber,");
        sql.append("A.FVoucherID as voucherID,");
        sql.append("A.fvoucherNumber AS voucherNumber,");
        sql.append("C.FBILLTYPE,");
        sql.append("A.FCompanyID, ");
        sql.append("A.FDescription AS CHGREASON, ");
        sql.append("A.FCHANGEDATE AS CHANGEDATE, ");
        sql.append("A.FBIZDATE AS BIZDATE, ");
        sql.append("A.FCHANGEMODEID AS CHANGEMODE, ");
        sql.append("B.TORIGINCHG AS ORIGINCHG, ");
        sql.append("CASE  when (C.FIsEvaledBefore>0) then C.flastEvalValue else ( TO_DECIMAL(NULL) ) end as  bclrEvalValue, ");
        sql.append("CASE  when (C.FIsEvaledBefore>0) then C.finitevalvalue else ( TO_DECIMAL(NULL) ) end as  clrEvalValue, ");
        sql.append("B.TACCUDEPRCHG AS ACCUDEPRCHG, ");
        sql.append("B.TDECVALUECHG AS DECVALUECHG, ");
        sql.append("E.FID AS BAKCARDID,");
        if (this.filter != null && (this.filter.indexOf("asstActItem.fname_l2") != -1 || this.filter.indexOf("asstActType.fnumber") != -1)) {
            sql.append("COMPOSIT.FAsstActItem AS FAsstActItem, COMPOSIT.Fasstacttype AS fasstactTypeid,");
        }
        if (this.filter != null && this.filter.indexOf("useDepartment.fnumber") != -1) {
            sql.append("FADEPARTMENT.FUseDepartmentID AS FUseDepartmentID, ");
        }
        sql.append("2 AS CHANGETYPE ");
        sql.append("FROM T_FA_FACHANGEBILL AS A ");
        sql.append("INNER JOIN T_FA_FACHANGEBILLENTRY AS B ON A.FID = B.FCHANGEBILLID ");
        sql.append("INNER JOIN T_FA_FABIZCARD AS C ON B.FBIZCARDID = C.FID ");
        sql.append("INNER JOIN T_FA_FACURCARD AS D ON B.FCURCARDID = D.FID");
        if (this.filter != null && (this.filter.indexOf("asstActItem.fname_l2") != -1 || this.filter.indexOf("asstActType.fnumber") != -1)) {
            sql.append(" INNER JOIN T_FA_FaBizCostCenter AS FACOSTCENTER ON C.FID = FACOSTCENTER.FFABIZCARDID");
            sql.append(" LEFT OUTER JOIN T_FA_FABizASSTACTCOMPOSIT COMPOSIT ON COMPOSIT.FFABizCOSTCENTERID = FACOSTCENTER.FID");
            sql.append(" LEFT OUTER JOIN t_bd_asstacttype asstType on asstType.Fid = COMPOSIT.FAsstActType");
        }
        if (this.filter != null && this.filter.indexOf("useDepartment.fnumber") != -1) {
            sql.append(" INNER JOIN T_FA_FaBizDepartment AS FADEPARTMENT ON C.FID = FADEPARTMENT.FFABIZCARDID");
        }
        sql.append(" INNER JOIN T_FA_FABAKCARD AS E ON C.FFaBakCardID = E.FID ");
        sql.append(" INNER JOIN T_BD_Period AS PERIOD ON A.FPeriodID = PERIOD.FID");
        sql.append(" WHERE A.FCOMPANYID IN (").append(this.strCompanyInclude).append(") ");
        sql.append(this.getPeriodCond());
        sql.append(this.isShowNotAudit ? " AND A.FEffectedStatus = 2" : " AND A.FCheckedStatus = 2");
        return sql.toString();
    }

    private String getCleanBillDetailSql() {
        boolean b;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");
        sql.append(this.getCardSelecSQL("E", "FFaCurCardID"));
        sql.append("A.fnumber AS bizNumber,");
        sql.append("A.FvoucherID AS voucherID,");
        sql.append("A.fvoucherNumber AS voucherNumber,");
        sql.append("C.FBILLTYPE,");
        sql.append("A.FCompanyID, ");
        sql.append("B.FCOMMENT AS CHGREASON, ");
        sql.append("A.FCLEARDATE AS CHANGEDATE, ");
        sql.append("A.FBIZDATE AS BIZDATE, ");
        sql.append("A.FCLEARMODEID AS CHANGEMODE, ");
        sql.append("B.FCLRORIGINAL * -1 AS ORIGINCHG, ");
        sql.append("CASE  when (C.FIsEvaledBefore>0) then c.finitEvalValue else ( TO_DECIMAL(NULL) ) end as  bclrEvalValue, ");
        sql.append("CASE  when (C.FIsEvaledBefore>0) then C.finitevalvalue-B.fclrEvalValue else ( TO_DECIMAL(NULL) ) end as  clrEvalValue, ");
        sql.append("B.FCLRADDUPDEP * -1 AS ACCUDEPRCHG, ");
        sql.append("B.FCLRDECPREP * -1 AS DECVALUECHG, ");
        sql.append("'' AS BAKCARDID,");
        if (this.filter != null && (this.filter.indexOf("asstActItem.fname_l2") != -1 || this.filter.indexOf("asstActType.fnumber") != -1)) {
            sql.append("COMPOSIT.FAsstActItem AS FAsstActItem, COMPOSIT.Fasstacttype AS fasstactTypeid,");
        }
        if (this.filter != null && this.filter.indexOf("useDepartment.fnumber") != -1) {
            sql.append("FADEPARTMENT.FUseDepartmentID AS FUseDepartmentID, ");
        }
        sql.append("CASE E.FASSETAMT WHEN B.FCLRQTY THEN 4 ELSE 3 END AS CHANGETYPE ");
        sql.append("FROM T_FA_CLEARBILL AS A ");
        sql.append("INNER JOIN T_FA_CLEARBILLENTRY AS B ON A.FID = B.FENTRYID ");
        sql.append("INNER JOIN T_FA_FABIZCARD AS C ON B.FBIZCARDID = C.FID ");
        sql.append("INNER JOIN T_FA_FACURCARD AS D ON B.FCURCARDID = D.FID");
        sql.append(" INNER JOIN T_FA_FABAKCARD AS E ON C.FFaBakCardID = E.FID");
        if (this.filter != null && (this.filter.indexOf("asstActItem.fname_l2") != -1 || this.filter.indexOf("asstActType.fnumber") != -1)) {
            sql.append(" INNER JOIN T_FA_FaBizCostCenter AS FACOSTCENTER ON C.FID = FACOSTCENTER.FFABIZCARDID");
            sql.append(" LEFT OUTER JOIN T_FA_FABizASSTACTCOMPOSIT COMPOSIT ON COMPOSIT.FFABizCOSTCENTERID = FACOSTCENTER.FID");
            sql.append(" LEFT OUTER JOIN t_bd_asstacttype asstType on asstType.Fid = COMPOSIT.FAsstActType");
        }
        if (this.filter != null && this.filter.indexOf("useDepartment.fnumber") != -1) {
            sql.append(" INNER JOIN T_FA_FaBizDepartment AS FADEPARTMENT ON C.FID = FADEPARTMENT.FFABIZCARDID");
        }
        sql.append(" INNER JOIN T_BD_Period AS PERIOD ON A.FPeriodID = PERIOD.FID");
        sql.append(" WHERE A.FCOMPANYID IN (").append(this.strCompanyInclude).append(") ");
        sql.append(this.getPeriodCond());
        sql.append(this.isShowNotAudit ? " AND A.FEffectedStatus = 2" : " AND A.FCheckedStatus = 2");
        boolean bl = b = this.bCompleteclean && this.bPartclean;
        if (!b) {
            if (this.bPartclean) {
                sql.append(" AND E.FASSETAMT != B.FCLRQTY");
            }
            if (this.bCompleteclean) {
                sql.append(" AND E.FASSETAMT = B.FCLRQTY");
            }
        }
        return sql.toString();
    }

    private String getPeriodCond() {
        StringBuffer sql = new StringBuffer();
        if (this.startYear == this.endYear) {
            sql.append(" AND period.FPeriodYear = " + this.startYear + " ");
            if (this.startNumber == this.endNumber) {
                sql.append(" AND period.FPeriodNumber = " + this.startNumber + " ");
            } else {
                sql.append(" AND period.FPeriodNumber >= " + this.startNumber + " and period.FPeriodNumber <= " + this.endNumber + " ");
            }
        } else {
            sql.append(" AND (period.FPeriodYear > " + this.startYear + " or (period.FPeriodYear = " + this.startYear + " and period.FPeriodNumber >= " + this.startNumber + "))");
            sql.append(" AND (period.FPeriodYear < " + this.endYear + " or (period.FPeriodYear = " + this.endYear + " and period.FPeriodNumber <= " + this.endNumber + "))");
        }
        return sql.toString();
    }

    private String getCurCostCenter() throws BOSException {
        StringBuffer sql = new StringBuffer();
        FaDaoSqlObject costDao = new FaDaoSqlObject();
        sql.append("update ").append(this.tempTable).append(" SET COSTCENTER = (");
        costDao.setSelect(" MAX(FSeq) AS maxSeq ");
        StringBuffer costFrom = new StringBuffer("T_FA_FaCurCostCenter");
        costFrom.append(" cost INNER JOIN ").append(this.tempTable).append(" temp ON temp.").append("CardID").append(" = cost.FFaCurCardID");
        costDao.setFrom(costFrom.toString());
        IRowSet row = DbUtil.executeQuery((Context)this.ctx, (String)costDao.getSql());
        int n = 1;
        try {
            if (row != null && row.next()) {
                n = row.getInt("maxSeq");
            }
        }
        catch (SQLException e) {
            throw new BOSException("Sql execute exception : " + costDao.getSql(), (Throwable)e);
        }
        if (n > 10) {
            n = 10;
        }
        StringBuffer select = new StringBuffer();
        StringBuffer from = new StringBuffer();
        select.append("account.FNumber ||'-'|| account." + this.fName + " || ' ' || TO_CHAR(facost.FApportionScale, 'NUMBER' ,2) || '%'|| ' ' || facost.FAsstActLName ");
        from.append("T_FA_FaCurCostCenter facost ");
        from.append(" LEFT OUTER JOIN T_BD_AccountView AS account ON facost.FAccountViewID = account.FID ");
        for (int i = 2; i <= n; ++i) {
            select.append(" || ( case ISNULL(facost").append(i).append(".FAccountViewID ");
            select.append("  ,'') when '' THEN '' ELSE ' ;  '||account").append(i).append(".FNumber ||'-'|| account").append(i).append("." + this.fName);
            select.append("   || ' ' || TO_CHAR(facost").append(i).append(".FApportionScale, 'NUMBER' , 2) || '%'|| ' ' ||facost").append(i).append(".FAsstActLName ");
            select.append(i == 10 ? "||' ; ...' END)" : " END) ");
            from.append(" LEFT OUTER JOIN ").append("T_FA_FaCurCostCenter").append(" facost").append(i);
            from.append(" ON (facost").append(i).append(".FSeq = ").append(i).append(" AND facost.FFaCurCardID");
            from.append(" = facost").append(i).append(".FFaCurCardID").append(") ");
            from.append(" LEFT OUTER JOIN T_BD_AccountView").append(" AS account").append(i);
            from.append(" ON (facost").append(i).append(".FAccountViewID = account").append(i).append(".FID)");
        }
        costDao.setSelect(select.toString());
        costDao.setFrom(from.toString());
        StringBuffer where = new StringBuffer();
        where.append(this.tempTable).append(".CardId = facost.FFaCurCardID AND facost.FSeq = 1 ");
        costDao.setWhere(where.toString());
        sql.append(costDao.getSql()).append(")");
        sql.append(" WHERE CHANGETYPE  = 1 AND COSTCENTER IS NULL");
        return sql.toString();
    }

    private String getUseDepartment(boolean isBakCard, boolean isUpdateBak) throws BOSException {
        boolean isDisplayLongName = false;
        isDisplayLongName = this.hmParam != null && this.hmParam.get("FA_025") != null && "true".equals(this.hmParam.get("FA_025"));
        StringBuffer sql = new StringBuffer();
        FaDaoSqlObject deptDao = new FaDaoSqlObject();
        String table = isBakCard || isUpdateBak ? "T_FA_FaBakDepartment" : "T_FA_FaBizDepartment";
        String column = isBakCard || isUpdateBak ? "FFaBakCardID" : "FFaBizCardID";
        sql.append("update ").append(this.tempTable).append(" SET ");
        sql.append(isUpdateBak ? "bUSEDEPARTMENT" : "USEDEPARTMENT").append(" = (");
        deptDao.setSelect(" MAX(FSeq) AS  maxSeq ");
        StringBuffer deptFrom = new StringBuffer(table);
        deptFrom.append(" dept INNER JOIN ").append(this.tempTable).append(" temp ON temp.").append(isUpdateBak ? "BakCardID" : "CardID").append(" = dept.").append(column);
        deptDao.setFrom(deptFrom.toString());
        IRowSet row = DbUtil.executeQuery((Context)this.ctx, (String)deptDao.getSql());
        int n = 1;
        try {
            if (row != null && row.next()) {
                n = row.getInt("maxSeq");
            }
        }
        catch (SQLException e) {
            throw new BOSException("Sql execute exception : " + deptDao.getSql(), (Throwable)e);
        }
        if (n > 10) {
            n = 10;
        }
        StringBuffer select = new StringBuffer();
        StringBuffer from = new StringBuffer();
        select.append("'{' || department.FNUMBER || '}' || department.").append(isDisplayLongName ? this.fDisplayName : this.fName).append("   ");
        from.append(table).append(" fadept ").append(" INNER JOIN T_ORG_Admin AS department ");
        from.append(" ON (fadept.FUseDepartmentID = department.FID  AND fadept.FSeq = 1) ");
        for (int i = 2; i <= n; ++i) {
            select.append(" || ( case ISNULL(department").append(i).append(".").append(isDisplayLongName ? this.fDisplayName : this.fName);
            select.append("  ,'') when '' THEN '' ELSE ' ;  ' ||'{' || department.FNUMBER || '}' || department").append(i).append(".").append(isDisplayLongName ? this.fDisplayName : this.fName);
            select.append(i == 10 ? "||' ; ...' END)" : " END) ");
            from.append(" LEFT OUTER JOIN ").append(table).append(" fadept").append(i);
            from.append(" ON (fadept").append(i).append(".FSeq = ").append(i).append(" AND fadept.");
            from.append(column).append(" = fadept").append(i).append(".").append(column).append(") ");
            from.append(" LEFT OUTER JOIN T_ORG_Admin AS department").append(i);
            from.append(" ON (fadept").append(i).append(".FUseDepartmentID = department").append(i).append(".FID ) ");
        }
        deptDao.setSelect(select.toString());
        deptDao.setFrom(from.toString());
        StringBuffer where = new StringBuffer(this.tempTable);
        where.append(isUpdateBak ? ".BakCardId" : ".CardId").append(" = fadept.").append(column).append(" AND fadept.FSeq = 1 ");
        deptDao.setWhere(where.toString());
        sql.append(deptDao.getSql()).append(")");
        sql.append(" WHERE CHANGETYPE ").append(isBakCard ? " = 1" : (isUpdateBak ? " = 2" : " != 1"));
        return sql.toString();
    }

    private String getCurUseDepartment() throws BOSException {
        boolean isDisplayLongName = false;
        isDisplayLongName = this.hmParam != null && this.hmParam.get("FA_025") != null && "true".equals(this.hmParam.get("FA_025"));
        StringBuffer sql = new StringBuffer();
        FaDaoSqlObject deptDao = new FaDaoSqlObject();
        sql.append("update ").append(this.tempTable).append(" SET USEDEPARTMENT = (");
        deptDao.setSelect(" MAX(FSeq) AS  maxSeq ");
        StringBuffer deptFrom = new StringBuffer("T_FA_FaCurDepartment");
        deptFrom.append(" dept INNER JOIN ").append(this.tempTable).append(" temp ON temp.").append("CardID").append(" = dept.FFaCurCardID");
        deptDao.setFrom(deptFrom.toString());
        IRowSet row = DbUtil.executeQuery((Context)this.ctx, (String)deptDao.getSql());
        int n = 1;
        try {
            if (row != null && row.next()) {
                n = row.getInt("maxSeq");
            }
        }
        catch (SQLException e) {
            throw new BOSException("Sql execute exception : " + deptDao.getSql(), (Throwable)e);
        }
        if (n > 10) {
            n = 10;
        }
        StringBuffer select = new StringBuffer();
        StringBuffer from = new StringBuffer();
        select.append("'{' || department.FNUMBER || '}' || department.").append(isDisplayLongName ? this.fDisplayName : this.fName).append("   ");
        from.append(" T_FA_FaCurDepartment fadept ").append(" INNER JOIN T_ORG_Admin AS department ");
        from.append(" ON (fadept.FUseDepartmentID = department.FID  AND fadept.FSeq = 1) ");
        for (int i = 2; i <= n; ++i) {
            select.append(" || ( case ISNULL(department").append(i).append(".").append(isDisplayLongName ? this.fDisplayName : this.fName);
            select.append("  ,'') when '' THEN '' ELSE ' ;  ' ||'{' || department.FNUMBER || '}' || department").append(i).append(".").append(isDisplayLongName ? this.fDisplayName : this.fName);
            select.append(i == 10 ? "||' ; ...' END)" : " END) ");
            from.append(" LEFT OUTER JOIN T_FA_FaCurDepartment fadept").append(i);
            from.append(" ON (fadept").append(i).append(".FSeq = ").append(i).append(" AND fadept.");
            from.append(" FFaCurCardID = fadept").append(i).append(".FFaCurCardID) ");
            from.append(" LEFT OUTER JOIN T_ORG_Admin AS department").append(i);
            from.append(" ON (fadept").append(i).append(".FUseDepartmentID = department").append(i).append(".FID ) ");
        }
        deptDao.setSelect(select.toString());
        deptDao.setFrom(from.toString());
        StringBuffer where = new StringBuffer(this.tempTable);
        where.append(".CardId").append(" = fadept.FFaCurCardID AND fadept.FSeq = 1 ");
        deptDao.setWhere(where.toString());
        sql.append(deptDao.getSql()).append(")");
        sql.append(" WHERE CHANGETYPE  = 1 AND USEDEPARTMENT IS NULL");
        return sql.toString();
    }

    private String getOriginUnitSql(String originTypeField, String originUnitId) {
        StringBuffer sql = new StringBuffer();
        sql.append("(CASE WHEN(").append(originTypeField).append(" = 2) ");
        sql.append("THEN (SELECT CP." + this.fName + " FROM T_ORG_BaseUnit AS CP WHERE CP.FID = ").append(originUnitId);
        sql.append(") WHEN(").append(originTypeField).append(" = 1) ");
        sql.append("THEN (SELECT CS." + this.fName + " FROM T_BD_Customer AS CS WHERE CS.FID = ").append(originUnitId);
        sql.append(") ELSE (").append("SELECT CS." + this.fName + " FROM T_BD_Supplier AS CS WHERE CS.FID = ").append(originUnitId);
        sql.append(") END)");
        return sql.toString();
    }

    private String getUpdateBakCostSql() {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE ").append(this.tempTable);
        sql.append(" SET bCostCenter = CostCenter");
        sql.append(" WHERE CHANGETYPE != 2");
        return sql.toString();
    }

    private String getUpdateBakUseDSql() {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE ").append(this.tempTable);
        sql.append(" SET bUseDepartment = UseDepartment");
        sql.append(" WHERE CHANGETYPE != 2");
        return sql.toString();
    }

    private String getUsePerson(boolean isBakCard, boolean isUpdateBak) throws BOSException {
        StringBuilder sql = new StringBuilder();
        FaDaoSqlObject deptDao = new FaDaoSqlObject();
        String table = isBakCard || isUpdateBak ? "T_FA_FaBakDepartment" : "T_FA_FaBizDepartment";
        String column = isBakCard || isUpdateBak ? "FFaBakCardID" : "FFaBizCardID";
        sql.append("update ").append(this.tempTable).append(" SET ");
        sql.append(isUpdateBak ? "bUSEPERSON" : "USEPERSON").append(" = (");
        deptDao.setSelect(" MAX(FSeq) AS  maxSeq ");
        StringBuilder deptFrom = new StringBuilder(table);
        deptFrom.append(" dept INNER JOIN ").append(this.tempTable).append(" temp ON temp.").append(isUpdateBak ? "BakCardID" : "CardID").append(" = dept.").append(column);
        deptDao.setFrom(deptFrom.toString());
        IRowSet row = DbUtil.executeQuery((Context)this.ctx, (String)deptDao.getSql());
        int n = 1;
        try {
            if (row.next()) {
                n = row.getInt("maxSeq");
            }
        }
        catch (SQLException e) {
            throw new BOSException("Sql execute exception : " + deptDao.getSql(), (Throwable)e);
        }
        if (n > 10) {
            n = 10;
        }
        StringBuffer select = new StringBuffer();
        StringBuffer from = new StringBuffer();
        select.append("person.").append(this.fName).append("   ");
        from.append(table).append(" fadept ").append(" INNER JOIN T_BD_Person AS person ");
        from.append(" ON (fadept.FUsePersonID = person.FID  AND fadept.FSeq = 1) ");
        for (int i = 2; i <= n; ++i) {
            select.append(" || ( case ISNULL(person").append(i).append(".").append(this.fName);
            select.append("  ,'') when '' THEN '' ELSE ' ;  ' || person").append(i).append(".").append(this.fName);
            select.append(i == 10 ? "||' ; ...' END)" : " END) ");
            from.append(" LEFT OUTER JOIN ").append(table).append(" fadept").append(i);
            from.append(" ON (fadept").append(i).append(".FSeq = ").append(i).append(" AND fadept.");
            from.append(column).append(" = fadept").append(i).append(".").append(column).append(") ");
            from.append(" LEFT OUTER JOIN T_BD_Person AS person").append(i);
            from.append(" ON (fadept").append(i).append(".FUsePersonID = person").append(i).append(".FID ) ");
        }
        deptDao.setSelect(select.toString());
        deptDao.setFrom(from.toString());
        StringBuffer where = new StringBuffer(this.tempTable);
        where.append(isUpdateBak ? ".BakCardId" : ".CardId").append(" = fadept.").append(column).append(" AND fadept.FSeq = 1 ");
        deptDao.setWhere(where.toString());
        sql.append(deptDao.getSql()).append(")");
        sql.append(" WHERE CHANGETYPE ").append(isBakCard ? " = 1" : (isUpdateBak ? " = 2" : " != 1"));
        return sql.toString();
    }

    private String getCurUsePerson() throws BOSException {
        StringBuffer sql = new StringBuffer();
        FaDaoSqlObject deptDao = new FaDaoSqlObject();
        sql.append("update ").append(this.tempTable).append(" SET USEPERSON = (");
        deptDao.setSelect(" MAX(FSeq) AS  maxSeq ");
        StringBuffer deptFrom = new StringBuffer("T_FA_FaCurDepartment");
        deptFrom.append(" dept INNER JOIN ").append(this.tempTable).append(" temp ON temp.").append("CardID").append(" = dept.FFaCurCardID");
        deptDao.setFrom(deptFrom.toString());
        IRowSet row = DbUtil.executeQuery((Context)this.ctx, (String)deptDao.getSql());
        int n = 1;
        try {
            if (row.next()) {
                n = row.getInt("maxSeq");
            }
        }
        catch (SQLException e) {
            throw new BOSException("Sql execute exception : " + deptDao.getSql(), (Throwable)e);
        }
        if (n > 10) {
            n = 10;
        }
        StringBuffer select = new StringBuffer();
        StringBuffer from = new StringBuffer();
        select.append("person.").append(this.fName).append("   ");
        from.append(" T_FA_FaCurDepartment fadept ").append(" INNER JOIN T_BD_Person AS person ");
        from.append(" ON (fadept.FUsePersonID = person.FID  AND fadept.FSeq = 1) ");
        for (int i = 2; i <= n; ++i) {
            select.append(" || ( case ISNULL(person").append(i).append(".").append(this.fName);
            select.append("  ,'') when '' THEN '' ELSE ' ;  ' || person").append(i).append(".").append(this.fName);
            select.append(i == 10 ? "||' ; ...' END)" : " END) ");
            from.append(" LEFT OUTER JOIN T_FA_FaCurDepartment fadept").append(i);
            from.append(" ON (fadept").append(i).append(".FSeq = ").append(i).append(" AND fadept.");
            from.append(" FFaCurCardID = fadept").append(i).append(".FFaCurCardID) ");
            from.append(" LEFT OUTER JOIN T_BD_Person AS person").append(i);
            from.append(" ON (fadept").append(i).append(".FUsePersonID = person").append(i).append(".FID ) ");
        }
        deptDao.setSelect(select.toString());
        deptDao.setFrom(from.toString());
        StringBuffer where = new StringBuffer(this.tempTable);
        where.append(".CardId").append(" = fadept.FFaCurCardID AND fadept.FSeq = 1 ");
        deptDao.setWhere(where.toString());
        sql.append(deptDao.getSql()).append(")");
        sql.append(" WHERE CHANGETYPE  = 1 AND USEPERSON IS NULL");
        return sql.toString();
    }

    private String getUpdateBakUsePSql() {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE ").append(this.tempTable);
        sql.append(" SET bUsePerson = UsePerson");
        sql.append(" WHERE CHANGETYPE != 2");
        return sql.toString();
    }

    private StringBuffer getCardSelecSQL(String alias, String FID) {
        StringBuffer sql = new StringBuffer();
        sql.append("C.FPropertyValueID, ");
        sql.append(alias).append(".FPropertyValueID as bFPropertyValueID, ");
        sql.append("C.FID AS CardID, ");
        sql.append(alias).append(".").append(FID).append(" AS  CUR_CARD_ID, ");
        sql.append(alias).append(".FNumber AS bASSETNUMBER, ");
        sql.append("C.FNumber AS ASSETNUMBER, ");
        sql.append(alias).append(".FoldNumber AS bOlderNumber, ");
        sql.append("C.FoldNumber AS OlderNumber, ");
        sql.append(alias).append(".FGroupNumber AS bGroupNumber, ");
        sql.append("C.FGroupNumber AS GroupNumber, ");
        sql.append(alias).append(".FAssetName AS bASSETNAME, ");
        sql.append("C.FAssetName AS ASSETNAME, ");
        sql.append(alias).append(".FAssetAmt AS bASSETAMT, ");
        sql.append("C.FAssetAmt AS ASSETAMT, ");
        sql.append("C.FFIAccountDate AS ACCOUNTDATE, ");
        sql.append(alias).append(".FEconomicPurpID AS bECONOMICPURPID, ");
        sql.append("C.FEconomicPurpID AS ECONOMICPURPID, ");
        sql.append(alias).append(".FSpecs AS bSPECS, ");
        sql.append("C.FSpecs AS SPECS, ");
        sql.append(alias).append(".FPArea AS bPAREA, ");
        sql.append("C.FPArea AS PAREA, ");
        sql.append(alias).append(".FMfr AS bMFR, ");
        sql.append("C.FMfr AS MFR, ");
        sql.append(alias).append(".FLevFrDate AS bLEVFRDATE, ");
        sql.append("C.FLevFrDate AS LEVFRDATE, ");
        sql.append(this.getOriginUnitSql(alias + ".FOriginType", alias + ".FORIGINUNIT") + " AS bORIGINUNIT, ");
        sql.append(this.getOriginUnitSql("C.FOriginType", "C.FORIGINUNIT") + " AS ORIGINUNIT, ");
        sql.append("C.FPaperNo AS PAPERNO, ");
        sql.append(alias).append(".FExRate AS bEXRATE, ");
        sql.append("C.FExRate AS EXRATE, ");
        sql.append(alias).append(".FOriginAmt AS bORIGINAMT, ");
        sql.append("C.FOriginAmt AS ORIGINAMT, ");
        sql.append(alias).append(".FTaxOriginAmt AS bTaxORIGINAMT, ");
        sql.append("C.FTaxOriginAmt AS TAXORIGINAMT, ");
        sql.append(alias).append(".FInputTax AS BInputTax, ");
        sql.append("C.FInputTax AS InputTax, ");
        sql.append(alias).append(".FInputTaxRate AS BInputTaxRate, ");
        sql.append("C.FInputTaxRate AS InputTaxRate, ");
        sql.append(alias).append(".FIsDeduct AS BIsDeduct, ");
        sql.append("C.FIsDeduct AS IsDeduct, ");
        sql.append(alias).append(".FAddons AS bADDONS, ");
        sql.append("C.FAddons AS ADDONS, ");
        sql.append(alias).append(".FTreatmentIncome AS bTREATMENTINCOME, ");
        sql.append("C.FTreatmentIncome AS TREATMENTINCOME, ");
        sql.append(alias).append(".FAddonFare AS bADDONFARE, ");
        sql.append("C.FAddonFare AS ADDONFARE, ");
        sql.append(alias).append(".FAssetValue AS bASSETVALUE, ");
        sql.append("C.FAssetValue AS ASSETVALUE, ");
        sql.append(alias).append(".FBuyValue AS bBUYVALUE, ");
        sql.append("C.FBuyValue AS BUYVALUE, ");
        sql.append(alias).append(".FBuyAccuDepr AS bBUYACCUDEPR, ");
        sql.append("C.FBuyAccuDepr AS BUYACCUDEPR, ");
        sql.append(alias).append(".FDeliverDate AS bDELIVERDATE, ");
        sql.append("C.FDeliverDate AS DELIVERDATE, ");
        sql.append("C.FStartUseDate AS STARTUSEDATE, ");
        sql.append(alias).append(".FUseYears AS bUSEYEARS, ");
        sql.append("C.FUseYears AS USEYEARS, ");
        sql.append(alias).append(".FUseTermCount AS bUSETERMCOUNT, ");
        sql.append("C.FUseTermCount AS USETERMCOUNT, ");
        sql.append(alias).append(".FDeprTermCount AS bDEPRTERMCOUNT, ");
        sql.append("C.FDeprTermCount AS DEPRTERMCOUNT, ");
        sql.append("(").append(alias).append(".FUseTermCount - ").append(alias).append(".FDeprTermCount) AS bLEFTTERMCONT, ");
        sql.append("(C.FUseTermCount - C.FDeprTermCount) AS LEFTTERMCONT, ");
        sql.append(alias).append(".FAccuDepr AS bACCUDEPR, ");
        sql.append("C.FAccuDepr AS ACCUDEPR, ");
        sql.append(alias).append(".FACCUDEPRTYEAR AS bACCUDEPRYEAR, ");
        sql.append("C.FACCUDEPRTYEAR AS ACCUDEPRYEAR, ");
        sql.append(alias).append(".FNeatRemValue AS bNEATREMVALUE, ");
        sql.append("C.FNeatRemValue AS NEATREMVALUE, ");
        sql.append(alias).append(".FNeatLeftRate AS bNEATLEFTRATE, ");
        sql.append("C.FNeatLeftRate AS NEATLEFTRATE, ");
        sql.append(alias).append(".FNeatValue AS bNEATVALUE, ");
        sql.append("C.FNeatValue AS NEATVALUE, ");
        sql.append(alias).append(".FDecValue AS bDECVALUE, ");
        sql.append("C.FDecValue AS DECVALUE, ");
        sql.append(alias).append(".FNeatAmt AS bNEATAMT, ");
        sql.append("C.FNeatAmt AS NEATAMT, ");
        sql.append(alias).append(".FRemark AS bREMARK, ");
        sql.append("C.FRemark AS REMARK, ");
        sql.append(alias).append(".FDeprMethodID AS bDeprMethodID,");
        sql.append("C.FDeprMethodID AS DeprMethodID,");
        sql.append(alias).append(".FMeasureUnitWLID AS bMeasureUnitWLID,");
        sql.append("C.FMeasureUnitWLID AS MeasureUnitWLID,");
        sql.append(alias).append(".FCurrencyID AS bCurrencyID,");
        sql.append("C.FCurrencyID AS  CurrencyID,");
        sql.append(alias).append(".FKeeperID AS bKeeperID, ");
        sql.append("C.FKeeperID AS KeeperID, ");
        sql.append(alias).append(".FDeptID AS bDeptID,");
        sql.append("C.FDeptID AS DeptID,");
        sql.append(alias).append(".FAssetCatID AS bAssetCatID,");
        sql.append("C.FAssetCatID AS AssetCatID,");
        sql.append(alias).append(".FMeasureUnitID AS bMeasureUnitID,");
        sql.append("C.FMeasureUnitID AS MeasureUnitID,");
        sql.append(alias).append(".FOriginMethodID AS bOriginMethodID,");
        sql.append("C.FOriginMethodID AS OriginMethodID, ");
        sql.append(alias).append(".FUseStatusID AS bUseStatusID,");
        sql.append("C.FUseStatusID AS UseStatusID,");
        sql.append(alias).append(".FStoreCityID AS bStoreCityID,");
        sql.append("C.FStoreCityID AS StoreCityID,");
        sql.append(alias).append(".FEvalAssetValue as bEvalAssetValue,");
        sql.append("C.FEvalAssetValue as evalAssetValue,");
        sql.append(alias).append(".FEvalReInAccountDate as bEvalReInAccountDate,");
        sql.append("C.FEvalReInAccountDate as evalReInAccountDate,");
        sql.append(alias).append(".FEvalDeprModeID as bEvalDeprMethodID,");
        sql.append("C.FEvalDeprModeID as evalDeprMethodID,");
        sql.append(alias).append(".FEvalUseTermCount as bEvalUseTermCount,");
        sql.append("C.FEvalUseTermCount as evalUseTermCount,");
        sql.append(alias).append(".FEvalMonthRate as bEvalMonthRate,");
        sql.append("C.FEvalMonthRate as evalMonthRate,");
        sql.append(alias).append(".FEvalTaxLeftPeriod as bEvalTaxLeftPeriod,");
        sql.append("C.FEvalTaxLeftPeriod as evalTaxLeftPeriod,");
        sql.append(alias).append(".FEvalNeatLeftRate as bEvalNeatLeftRate,");
        sql.append("C.FEvalNeatLeftRate as evalNeatLeftRate,");
        sql.append(alias).append(".FEvalDeprPeriodNum as bEvalDeprPeriodNum,");
        sql.append("C.FEvalDeprPeriodNum as evalDeprPeriodNum,");
        sql.append(alias).append(".FEvalRemValue as bEvalRemValue,");
        sql.append("C.FEvalRemValue as evalRemValue,");
        sql.append(alias).append(".FEvalAddDepr as bEvalAddDepr,");
        sql.append("C.FEvalAddDepr as evalAddDepr,");
        sql.append(alias).append(".FEvalDecValue as bEvalDecValue,");
        sql.append("C.FEvalDecValue as evalDecValue,");
        sql.append(alias).append(".FEvalYearDepr as bEvalYearDepr,");
        sql.append("C.FEvalYearDepr as evalYearDepr,");
        sql.append(alias).append(".FEvalNeatValue as bEvalNeatValue,");
        sql.append("C.FEvalNeatValue as evalNeatValue,");
        sql.append("C.FEvalMeasureUnitWL as evalMeasureUnitWL,");
        sql.append(alias).append(".FEvalNeatAmt as bEvalNeatAmt,");
        sql.append("C.FEvalNeatAmt as evalNeatAmt,");
        sql.append(alias).append(".FAccountDecValueID as bFAccountDecValueID,");
        sql.append("C.FAccountDecValueID as FAccountDecValueID,");
        sql.append(alias).append(".FAccountAccuDeprID as bFAccountAccuDeprID,");
        sql.append("C.FAccountAccuDeprID as FAccountAccuDeprID,");
        sql.append(alias).append(".FAccountAssetID as bFAccountAssetID,");
        sql.append(" C.FAccountAssetID as FAccountAssetID,");
        sql.append(alias).append(".FOriginType AS bOriginType,");
        sql.append("C.FOriginType AS OriginType,");
        return sql;
    }

    @Override
    protected StringBuffer getUsedAsstActItemSql() {
        StringBuffer usedSql = this.getUsedAsstActItemSqlNew();
        return usedSql;
    }

    protected StringBuffer getUsedAsstActItemSqlNew() {
        StringBuffer cardSql = new StringBuffer();
        StringBuffer monCardSql = new StringBuffer();
        StringBuffer currCardSql = new StringBuffer();
        if (this.isVirCompany || this.currPeriod != null && this.startYear * 100 + this.startNumber < this.currPeriod.getPeriodYear() * 100 + this.currPeriod.getPeriodNumber()) {
            monCardSql.append(" select composit.FAsstActType AS FASSTACTTYPEID, composit.FAsstActItem ");
            monCardSql.append(" from t_fa_famoncard mc");
            monCardSql.append(" inner join t_fa_famoncostcenter cost on cost.ffamoncardid = mc.fid");
            monCardSql.append(" inner join T_FA_FamonAsstActComposit composit on composit.FFamonCostCenterID = cost.fid");
            if (this.startYear == 0 && this.startNumber == 0) {
                monCardSql.append(" where mc.fperiodid is null ");
            } else {
                monCardSql.append(" inner join t_bd_period p on p.fid = mc.ffaperiodid");
                monCardSql.append(" where p.FNumber >=").append(this.startYear * 100 + this.startNumber);
                monCardSql.append(" and p.FNumber <=").append(this.endYear * 100 + this.endNumber);
            }
            monCardSql.append(" and mc.fcompanyid ");
            monCardSql.append(this.getSplitInSql(this.strCompanyInclude, 999, "mc.fcompanyid"));
            if (!StringUtils.isEmpty((String)this.FACURCARDID)) {
                monCardSql.append(" and mc.ffacurcardid in ('").append(this.FACURCARDID).append("') ");
            }
            monCardSql.append(" union all ");
            monCardSql.append(" select composit.FAsstActType AS FASSTACTTYPEID,composit.FAsstActItem ");
            monCardSql.append(" from t_fa_fabakcard bc");
            monCardSql.append(" inner join t_fa_fabakcostcenter cost on cost.FFaBakCardID = bc.fid");
            monCardSql.append(" inner join T_FA_FabakAsstActComposit composit on composit.FFabakCostCenterID = cost.fid");
            if (this.startYear == 0 && this.startNumber == 0) {
                monCardSql.append(" where bc.fperiodid is null ");
            } else {
                monCardSql.append(" inner join t_bd_period p on p.fid = bc.FBakPeriodID");
                monCardSql.append(" where p.FNumber >=").append(this.startYear * 100 + this.startNumber);
                monCardSql.append(" and p.FNumber <=").append(this.endYear * 100 + this.endNumber);
            }
            monCardSql.append(" and bc.fcompanyid ");
            monCardSql.append(this.getSplitInSql(this.strCompanyInclude, 999, "bc.fcompanyid"));
            if (!StringUtils.isEmpty((String)this.FACURCARDID)) {
                monCardSql.append(" and bc.ffacurcardid in ('").append(this.FACURCARDID).append("') ");
            }
            monCardSql.append(" union all ");
            monCardSql.append("select composit.FAsstActType AS FASSTACTTYPEID,composit.FAsstActItem ");
            monCardSql.append(" from t_fa_fabizcard biz ");
            monCardSql.append(" inner join t_fa_fabizcostcenter cost on cost.ffabizcardid = biz.fid");
            monCardSql.append(" inner join T_FA_FabizAsstActComposit composit on composit.FFaBizCostCenterID = cost.fid");
            monCardSql.append(" inner join t_fa_fabakcard bak on bak.fid = biz.ffabakcardid ");
            if (this.startYear == 0 && this.startNumber == 0) {
                monCardSql.append(" where biz.fperiodid is null ");
            } else {
                monCardSql.append(" inner join t_bd_period p on p.fid = bak.FBakPeriodID");
                monCardSql.append(" where p.FNumber >=").append(this.startYear * 100 + this.startNumber);
                monCardSql.append(" and p.FNumber <=").append(this.endYear * 100 + this.endNumber);
            }
            monCardSql.append(" and biz.fcompanyid ");
            monCardSql.append(this.getSplitInSql(this.strCompanyInclude, 999, "biz.fcompanyid"));
            if (!StringUtils.isEmpty((String)this.FACURCARDID)) {
                monCardSql.append(" and bak.ffacurcardid in ('").append(this.FACURCARDID).append("') ");
            }
        }
        if (this.isVirCompany || this.currPeriod != null && this.endYear == this.currPeriod.getPeriodYear() && this.endNumber == this.currPeriod.getPeriodNumber()) {
            currCardSql.append(" select composit.FAsstActType AS FASSTACTTYPEID,composit.FAsstActItem ");
            currCardSql.append(" from t_fa_facurcard c");
            currCardSql.append(" inner join t_fa_facurcostcenter cost on cost.ffacurcardid = c.fid");
            currCardSql.append(" inner join T_FA_FacurAsstActComposit composit on composit.FFacurCostCenterID = cost.fid");
            currCardSql.append(" where c.fcompanyid ");
            currCardSql.append(this.getSplitInSql(this.strCompanyInclude, 999, "bc.fcompanyid"));
            if (!StringUtils.isEmpty((String)this.FACURCARDID)) {
                currCardSql.append(" and c.fid in ('").append(this.FACURCARDID).append("') ");
            }
        }
        if (!this.isVirCompany && this.currPeriod != null && this.startYear * 100 + this.startNumber > this.currPeriod.getPeriodYear() * 100 + this.currPeriod.getPeriodNumber()) {
            currCardSql.append(" select composit.FAsstActType AS FASSTACTTYPEID,composit.FAsstActItem ");
            currCardSql.append(" from t_fa_facurcard c");
            currCardSql.append(" inner join t_fa_facurcostcenter cost on cost.ffacurcardid = c.fid");
            currCardSql.append(" inner join T_FA_FacurAsstActComposit composit on composit.FFacurCostCenterID = cost.fid");
            currCardSql.append(" where c.fcompanyid ");
            currCardSql.append(this.getSplitInSql(this.strCompanyInclude, 999, "bc.fcompanyid"));
            if (!StringUtils.isEmpty((String)this.FACURCARDID)) {
                currCardSql.append(" and c.fid in ('").append(this.FACURCARDID).append("') ");
            }
        }
        if (monCardSql.length() > 0 && currCardSql.length() > 0) {
            monCardSql.append(" union all ");
        }
        cardSql.append(" select asstItem.fasstacttypeid,asstItem.fasstactitem from (");
        cardSql.append(monCardSql).append(currCardSql);
        cardSql.append(") as asstItem ");
        return cardSql;
    }

    private String getCondSql() {
        StringBuffer condSql = new StringBuffer();
        if (this.filter != null && this.filter.indexOf("oldNumber") != -1) {
            this.filter = this.filter.replaceAll("oldNumber", "A.olderNUMBER");
        }
        if (this.filter != null && this.filter.indexOf("leftTermCount") != -1) {
            this.filter = this.filter.replaceAll("leftTermCount", "A.leftTermCont");
        }
        if (this.filter != null) {
            condSql.append(this.filter);
        }
        return condSql.toString();
    }

    private List getCardNumberList() throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT DISTINCT ASSETNUMBER ");
        sql.append(" FROM ").append(this.tempTable);
        sql.append(" ORDER BY ASSETNUMBER");
        Connection conn = this.getConnection(this.ctx);
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<String> numberList = new ArrayList<String>();
        try {
            stmt = conn.prepareStatement(sql.toString());
            rs = stmt.executeQuery();
            while (rs.next()) {
                numberList.add(rs.getString("ASSETNUMBER"));
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return numberList;
    }

    protected Connection getConnection(Context ctx) throws SQLDataException {
        try {
            return EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException sqle) {
            throw new SQLDataException(sqle);
        }
    }

    @Override
    protected boolean isCreateTempTable() {
        return true;
    }

    @Override
    protected boolean isCreateAcctAsstTable(EntityViewInfo ev) {
        return true;
    }

    @Override
    public void init(Context ctx, EntityViewInfo ev) throws EASBizException, BOSException {
        ObjectUuidPK pk = new ObjectUuidPK(ContextUtil.getCurrentOrgUnit((Context)ctx).getId());
        HashMap<String, ObjectUuidPK> paramKeyMap = new HashMap<String, ObjectUuidPK>();
        paramKeyMap.put("FA_025", pk);
        this.hmParam = ParamManager.getParamHashMap((Context)ctx, paramKeyMap);
        super.init(ctx, ev);
    }

    private StringBuffer getPropertyValueFromNewCardSql() throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select A.FID AS FID, A.CARDID AS CARDID ");
        sql.append(this.def.getSelectPart(null));
        sql.append(this.def.getSelectPart(null, "B"));
        sql.append("From ").append(this.tempTable).append(" AS A ");
        try {
            sql.append(this.def.getJoinPart("A.FPropertyValueID"));
            sql.append(this.def.getJoinPart("A.bFPropertyValueID", "B"));
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        sql.append(" where A.FPROPERTYVALUEID IS NOT NULL OR A.bFPROPERTYVALUEID IS NOT NULL ");
        return sql;
    }

    private boolean isQueryField(List selOption, String filter, String field, String filterString) {
        boolean isQuery = false;
        if (filter != null && filter.indexOf(filterString) != -1) {
            return true;
        }
        for (int i = 0; i < selOption.size(); ++i) {
            FaListRptObject flo = (FaListRptObject)selOption.get(i);
            if (flo == null) continue;
            String selField = flo.getColumnKey();
            boolean isSelected = flo.isSelected();
            if (!field.equals(selField) || !isSelected) continue;
            return true;
        }
        return isQuery;
    }
}

