/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.rpt.app.FaRptLocalUtils;
import com.kingdee.eas.fi.fa.rpt.app.dao.FaDaoBase;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Date;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class FaEvaluateRptDao
extends FaDaoBase {
    protected String sumSql;
    protected String strToTmpTblSql;
    private List dateList;
    private String startDate;
    private String endDate;
    private boolean byBenchmarkDate;

    @Override
    protected void initEvVar(EntityViewInfo ev) throws EASBizException, BOSException {
        FaRptLocalUtils.chgNumberKeyWord(ev);
        Map cond = (Map)ev.get("customcond");
        this.byBenchmarkDate = (Boolean)cond.get("byBenchmarkDate");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        this.startDate = dateFormat.format((java.util.Date)cond.get("startDate"));
        this.endDate = dateFormat.format(cond.get("endDate"));
        this.dateList = this.getDateList();
    }

    protected List getDateList() throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT DISTINCT ");
        sql.append(this.byBenchmarkDate ? "FBenchmarkDate" : "FAdjustDate");
        sql.append(" FROM T_FA_FAEvaluateBill WHERE ");
        sql.append(this.byBenchmarkDate ? "FBenchmarkDate" : "FAdjustDate").append(">= TO_DATE('").append(this.startDate).append("')");
        sql.append(" AND ").append(this.byBenchmarkDate ? "FBenchmarkDate" : "FAdjustDate").append("<= TO_DATE('").append(this.endDate).append("')");
        sql.append(" AND FCheckedStatus = 2");
        sql.append(" AND FCompanyID = '").append(this.currCompanyInfo.getId().toString()).append("'");
        IRowSet periodRowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
        ArrayList<Date> periodList = new ArrayList<Date>();
        try {
            while (periodRowSet.next()) {
                periodList.add(periodRowSet.getDate(1));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return periodList;
    }

    @Override
    protected void buildSql() throws BOSException {
    }

    private String builtToTmpTblSql() throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT NEWBOSID('00000000') AS FId , ");
        if (this.sumOption.isHasSum()) {
            sql.append(this.sumOption.getStrNameFields()).append(",");
        }
        sql.append("A.AssetNumber, ");
        sql.append("A.OlderNumber, ");
        sql.append("A.EvalDate, ");
        sql.append("A.AssetName, ");
        sql.append("A.ASSETCAT_NAME, ");
        sql.append("A.Specs, ");
        sql.append("A.assetValue, ");
        sql.append("A.initEvalValue, ");
        sql.append("A.evaValue, ");
        sql.append("\n");
        Iterator it = this.dateList.iterator();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        while (it.hasNext()) {
            java.util.Date date = (java.util.Date)it.next();
            sql.append(" case when A.EvalDate = to_date('").append(dateFormat.format(date)).append("')");
            sql.append(" then A.evaValue else to_decimal(null) end AS F" + date.getTime() + " ,");
            sql.append("\n");
        }
        sql.append(" 0 AS isSum ");
        if (this.sumOption.isHasSum()) {
            sql.append(", ").append(this.sumOption.getStrLongNumberFields());
        }
        sql.append("\n");
        sql.append(" FROM ");
        sql.append(" (select ");
        if (this.sumOption.isHasSum()) {
            sql.append(this.sumOption.getStrNameFields()).append(",");
        }
        sql.append("card .FNumber AS AssetNumber, ");
        sql.append("card .FoldNumber AS OlderNumber, ");
        sql.append("bill.").append(this.byBenchmarkDate ? "FBenchmarkDate" : "FAdjustDate").append(" AS EvalDate,");
        sql.append("card .FAssetName AS assetName, ");
        sql.append("assetCat." + this.fName + " AS ASSETCAT_NAME, ");
        sql.append("card.FSpecs AS specs, ");
        sql.append("card.FAssetvalue AS assetValue, ");
        sql.append("case bc.FIsEvaledBefore when 1 then bc.FInitEvalValue else to_decimal(null) end as initEvalValue,");
        sql.append("value.FEvaValue AS evaValue , ");
        sql.append("assetcat.fid assetcatid ");
        if (this.sumOption.isHasSum()) {
            sql.append(",").append(this.sumOption.getStrLongNumberFields());
        }
        sql.append("from t_fa_faevaluatebill AS bill ");
        sql.append("inner join t_fa_faevaluatebillentry AS entry on entry.FFaEvaluateBillID = bill.FID ");
        sql.append("inner join t_fa_facurCard AS card on entry.FCurCardID = card.FID ");
        sql.append("inner join T_Fa_FaEvaValue  AS value on value.FEvaEntryID = entry.FID ");
        sql.append("left outer join t_fa_fabakcard as bc on bc.FFaCurCardID = card.FID and bc.FBillType = ").append(1);
        sql.append(" left outer join T_BD_MeasureUnit AS MEASUREUNIT on CARD.FMeasureUnitID = MEASUREUNIT.FID");
        String tableName = this.isLevelSum("assetCat") ? this.getSumItemJoinSql("assetCat") : this.getSumItemTableName("assetCat");
        sql.append(" INNER JOIN ").append(tableName).append(" AS ").append("assetCat");
        sql.append(" ON card.FAssetCatID = ").append("assetCat").append(".FID");
        sql.append(" where value.fmaintype = 1 and value.fsubtype ='00'  ");
        sql.append("and bill.fcheckedstatus =2 and ");
        sql.append("bill.").append(this.byBenchmarkDate ? "FBenchmarkDate" : "FAdjustDate").append(">= TO_DATE('").append(this.startDate).append("')");
        sql.append(" and ").append(this.byBenchmarkDate ? "FBenchmarkDate" : "FAdjustDate").append("<= TO_DATE('").append(this.endDate).append("')");
        sql.append(" and bill.fcompanyid='" + this.currCompanyInfo.getId().toString() + "'");
        sql.append(" ) AS A ");
        sql.append("inner join t_fa_cat assetcat ON a.assetcatid = assetcat.fid ");
        if (this.filter != null && this.filter != null && this.filter.trim().length() > 0) {
            String tmpFilter = this.filter.replaceAll("oldNumber", "OlderNumber");
            sql.append(" where " + tmpFilter);
        }
        return sql.toString();
    }

    private void getResultSql() {
        this.resultSql.setSelect(" * ");
        this.resultSql.setFrom(this.tempTable);
        this.resultSql.setOrder(this.sorter);
    }

    private String getNoSumSql() {
        StringBuffer sql = new StringBuffer();
        sql.append("update " + this.tempTable + " set assetnumber=null ,ASSETCAT_NAME='");
        sql.append(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.basedata.FaResource", (String)"total", (Locale)this.ctx.getOriginLocale()));
        sql.append("' where assetnumber='");
        sql.append(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.basedata.FaResource", (String)"total", (Locale)this.ctx.getOriginLocale())).append("' ");
        return sql.toString();
    }

    private void updateInitEvalValue() throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" UPDATE ").append(this.tempTable).append(" SET initEvalValue = ");
        sql.append(" (SELECT CASE card.FIsEvaledBefore WHEN 1 THEN card.FInitEvalValue ELSE TO_DECIMAL(NULL) END INITEVALVALUE");
        sql.append(" FROM t_fa_famoncard CARD ");
        sql.append(" WHERE FPeriodID IS NULL");
        sql.append(" AND CARD.fcompanyid = '").append(this.currCompanyInfo.getId().toString()).append("'");
        sql.append(" AND ").append(this.tempTable).append(".AssetNumber = CARD.FNUMBER)");
        sql.append(" WHERE ").append(this.tempTable).append(".initEvalValue IS NULL");
        DbUtil.execute((Context)this.ctx, (String)sql.toString());
    }

    @Override
    protected void buildData() throws BOSException {
        this.getResultSql();
        this.strToTmpTblSql = this.builtToTmpTblSql();
        this.addDataTempTable(this.strToTmpTblSql);
        StringBuffer sql = new StringBuffer();
        sql.append(" NULL AS AssetNumber , ");
        sql.append(" NULL AS OLDERNUMBER , ");
        String strDbType = ContextUtil.getDbType((Context)this.ctx);
        sql.append(" now() AS EvalDate , ");
        sql.append(" NULL AS AssetName , ");
        sql.append(" NULL AS ASSETCAT_NAME , ");
        sql.append(" NULL AS Specs , ");
        sql.append(" SUM(assetValue) AS assetValue,");
        sql.append(" SUM(initEvalValue) AS initEvalValue,");
        sql.append(" SUM(evaValue) AS evaValue, ");
        for (java.util.Date date : this.dateList) {
            sql.append(" sum(F").append(date.getTime()).append(") as F").append(date.getTime()).append(",");
        }
        sql.append(" 1 AS isSum ");
        String select = sql.toString();
        this.sumSql = this.sumOption.getSumSql(this.tempTable, select, null, null, null, true, false);
        this.updateInitEvalValue();
        if (this.sumSql != null && this.sumSql.trim().length() > 0) {
            DbUtil.execute((Context)this.ctx, (String)this.sumSql);
        }
        if (!this.sumOption.isHasSum()) {
            DbUtil.execute((Context)this.ctx, (String)this.getNoSumSql());
        }
        this.result.put("dataList", this.dateList);
    }

    @Override
    protected String buildSorterSql(EntityViewInfo ev) {
        String sql = super.buildSorterSql(ev);
        sql = sql.replaceAll("oldNumber", "olderNumber");
        return sql;
    }
}

