/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.fa.rpt.app.dao.FaDaoBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.DateTimeUtils;
import java.util.Date;
import java.util.Map;

public class FaLeaseStatusDao
extends FaDaoBase {
    private static final String WORK_NUMBER = "001";
    private static final String FINANCING_NUMBER = "002";
    private static final String BEGIN_DATE_FROM = "beginDateFrom";
    private static final String BEGIN_DATE_TO = "beginDateTo";
    private static final String END_DATE_FROM = "endDateFrom";
    private static final String END_DATE_TO = "endDateTo";
    private static final String INCLUDE_FI_LEASEIN = "fiLeaseIn";
    private static final String INCLUDE_FI_LEASEOUT = "fiLeaseOut";
    private static final String INCLUDE_WR_LEASEIN = "wrLeaseIn";
    private static final String INCLUDE_WR_LEASEOUT = "wrLeaseOut";
    private String sumSql;
    private String select;
    private Date beginDateFrom;
    private Date beginDateTo;
    private Date endDateFrom;
    private Date endDateTo;
    private boolean includeFiLeaseIn = false;
    private boolean includeFiLeaseOut = false;
    private boolean includeWrLeaseIn = false;
    private boolean includeWrLeaseOut = false;

    @Override
    protected void initEvVar(EntityViewInfo ev) throws EASBizException, BOSException {
        Map m = (Map)ev.get("customcond");
        this.includeFiLeaseIn = (Boolean)m.get(INCLUDE_FI_LEASEIN);
        this.includeFiLeaseOut = (Boolean)m.get(INCLUDE_FI_LEASEOUT);
        this.includeWrLeaseIn = (Boolean)m.get(INCLUDE_WR_LEASEIN);
        this.includeWrLeaseOut = (Boolean)m.get(INCLUDE_WR_LEASEOUT);
        this.beginDateFrom = (Date)m.get(BEGIN_DATE_FROM);
        this.beginDateTo = (Date)m.get(BEGIN_DATE_TO);
        this.endDateFrom = (Date)m.get(END_DATE_FROM);
        this.endDateTo = (Date)m.get(END_DATE_TO);
        super.initEvVar(ev);
    }

    @Override
    protected void buildSql() throws BOSException {
        this.select = this.getSumSelectSql();
        this.buildResultSql();
    }

    @Override
    protected void buildData() throws BOSException {
        this.addDataTempTable(FaLocalUtils.transformLocal((Context)this.ctx, (String)this.buildQueryLeaseStatusSQL()));
        this.sumSql = this.sumOption.getSumSql(this.tempTable, this.select, null, null, null, true, false);
        if (this.sumSql != null && this.sumSql.trim().length() > 0) {
            DbUtil.execute((Context)this.ctx, (String)this.sumSql);
        }
    }

    private String buildQueryLeaseStatusSQL() {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT newBosId('00000000') AS FId  , ");
        if (this.sumOption.isHasSum() && this.sumOption.getStrNameFields() != null && this.sumOption.getStrNameFields().trim().length() > 0) {
            sql.append(this.sumOption.getStrNameFields() + ", ");
        }
        sql.append(this.getLeaseStatusSelectSql());
        if (this.sumOption.isHasSum() && this.sumOption.getStrLongNumberFields() != null && this.sumOption.getStrLongNumberFields().trim().length() > 0) {
            sql.append(", ").append(this.sumOption.getStrLongNumberFields());
        }
        sql.append(" FROM ").append(this.getJoinSql(this.isCurrPeriod));
        sql.append(" WHERE ").append(this.getCondSql(this.isCurrPeriod));
        return sql.toString();
    }

    private String getLeaseStatusSelectSql() {
        StringBuffer sql = new StringBuffer();
        sql.append(" b.ASSETNUMBER, ");
        sql.append(" b.OLDERNUMBER, ");
        sql.append(" b.ASSETNAME, ");
        sql.append(" assetCat.").append(this.fName).append(" AS ASSETCAT_NAME, ");
        sql.append(" b.specs, ");
        sql.append(" measureUnit.").append(this.fName).append(" AS MEASUREUNIT_NAME, ");
        sql.append(" b.leaseAmt, ");
        sql.append(" b.bargainNum, ");
        sql.append(" b.signatureDate, ");
        sql.append(" b.leasor, ");
        sql.append(" b.leasee, ");
        sql.append(" leaseType.").append(this.fName).append(" AS LEASETYPE_NAME, ");
        sql.append(" b.beginDate, ");
        sql.append(" b.endDate, ");
        sql.append(" b.bargainTime, ");
        sql.append(" b.measureUnit, ");
        sql.append(" settlType.").append(this.fName).append(" AS SETTLTYPE_NAME, ");
        sql.append(" b.payMode, ");
        sql.append(" hireCurrency.").append(this.fName).append(" AS HIRECURRENCY_NAME, ");
        sql.append(" b.hireOriginAmt, ");
        sql.append(" b.hireLocalAmt, ");
        sql.append(" b.deliverDate, ");
        sql.append(" b.deliverPlace,");
        sql.append(" b.cautioner, ");
        sql.append(" hireCurrency.FPrecision AS hireCurPre, ");
        sql.append(" b.disc, ");
        sql.append(" b.leasedTime, ");
        sql.append(" b.remainTime, ");
        sql.append(" b.billID, ");
        sql.append(" 0 AS isSum ");
        return sql.toString();
    }

    private String getSumSelectSql() {
        StringBuffer sql = new StringBuffer();
        sql.append(" TO_CHAR(NULL) AS ASSETNUMBER, ");
        sql.append(" TO_CHAR(NULL) AS OLDERNUMBER, ");
        sql.append(" TO_CHAR(NULL) AS ASSETNAME, ");
        sql.append(" TO_CHAR(NULL) AS ASSETCAT_NAME, ");
        sql.append(" TO_CHAR(NULL) AS specs, ");
        sql.append(" TO_CHAR(NULL) AS MEASUREUNIT_NAME, ");
        sql.append(" TO_DECIMAL(NULL) AS leaseAmt, ");
        sql.append(" TO_CHAR(NULL) AS bargainNum, ");
        sql.append(" TO_DATE(NULL) AS signatureDate, ");
        sql.append(" TO_CHAR(NULL) AS leasor, ");
        sql.append(" TO_CHAR(NULL) AS leasee, ");
        sql.append(" TO_CHAR(NULL) AS LEASETYPE_NAME, ");
        sql.append(" TO_DATE(NULL) AS beginDate, ");
        sql.append(" TO_DATE(NULL) AS endDate, ");
        sql.append(" TO_DECIMAL(NULL) AS bargainTime, ");
        sql.append(" TO_DECIMAL(NULL) AS measureUnit, ");
        sql.append(" TO_CHAR(NULL) AS SETTLTYPE_NAME, ");
        sql.append(" TO_INT(NULL) AS payMode, ");
        sql.append(" TO_CHAR(NULL) AS HIRECURRENCY_NAME, ");
        sql.append(" TO_DECIMAL(NULL) AS hireOriginAmt, ");
        sql.append(" sum(hireLocalAmt) AS hireLocalAmt, ");
        sql.append(" TO_DATE(NULL) AS deliverDate, ");
        sql.append(" TO_CHAR(NULL) AS deliverPlace,");
        sql.append(" TO_CHAR(NULL) AS cautioner, ");
        sql.append(" TO_INT(NULL) AS hireCurPre, ");
        sql.append(" TO_INT(NULL) AS disc, ");
        sql.append(" TO_DECIMAL(NULL) AS leasedTime, ");
        sql.append(" TO_DECIMAL(NULL) AS remainTime, ");
        sql.append(" TO_CHAR(NULL) AS billID, ");
        sql.append(" 1 AS isSum ");
        return sql.toString();
    }

    private String getSelectResultSql() {
        StringBuffer sql = new StringBuffer();
        sql.append(" ASSETNUMBER, ");
        sql.append(" OLDERNUMBER, ");
        sql.append(" ASSETNAME, ");
        sql.append(" ASSETCAT_NAME, ");
        sql.append(" specs, ");
        sql.append(" MEASUREUNIT_NAME, ");
        sql.append(" leaseAmt, ");
        sql.append(" bargainNum, ");
        sql.append(" signatureDate, ");
        sql.append(" leasor, ");
        sql.append(" leasee, ");
        sql.append(" LEASETYPE_NAME, ");
        sql.append(" beginDate, ");
        sql.append(" endDate, ");
        sql.append(" bargainTime, ");
        sql.append(" measureUnit, ");
        sql.append(" SETTLTYPE_NAME, ");
        sql.append(" payMode, ");
        sql.append(" HIRECURRENCY_NAME, ");
        sql.append(" hireOriginAmt, ");
        sql.append(" hireLocalAmt, ");
        sql.append(" deliverDate, ");
        sql.append(" deliverPlace,");
        sql.append(" cautioner, ");
        sql.append(" hireCurPre, ");
        sql.append(" disc,");
        sql.append(" leasedTime, ");
        sql.append(" remainTime, ");
        sql.append(" billID,");
        sql.append(" isSum");
        return sql.toString();
    }

    private void buildResultSql() {
        StringBuffer sql = new StringBuffer();
        if (this.sumOption.isHasSum()) {
            sql.append(this.sumOption.getStrSelectResult() + ", ");
        }
        sql.append(this.getSelectResultSql());
        this.resultSql.setSelect(sql.toString());
        this.resultSql.setFrom(this.tempTable);
        this.resultSql.setOrder(this.sorter);
    }

    private String getJoinSql(boolean isCurPeriod) {
        StringBuffer sql = new StringBuffer("(");
        if (this.includeFiLeaseIn || this.includeWrLeaseIn) {
            sql.append(this.getLeaseInSQL());
            if (this.includeFiLeaseOut || this.includeWrLeaseOut) {
                sql.append(" UNION ALL ");
            }
        }
        if (this.includeFiLeaseOut || this.includeWrLeaseOut) {
            sql.append(this.getLeaseOutSQL());
        }
        sql.append(") AS b ");
        sql.append("LEFT OUTER JOIN T_BD_MeasureUnit AS measureUnit ON b.measureUnitID = measureUnit.FID ");
        sql.append("INNER JOIN T_FA_FaLeaseType AS leaseType ON b.leaseTypeID = leaseType.FID ");
        sql.append("LEFT OUTER JOIN T_BD_SettlementType AS settlType ON b.settlTypeID = settlType.FID ");
        sql.append("LEFT OUTER JOIN T_BD_Currency AS hireCurrency ON b.hireCurrencyID = hireCurrency.FID ");
        sql.append("INNER JOIN T_ORG_Company AS COMPANY ON b.FCompanyID = COMPANY.FID ");
        String tableName = this.isLevelSum("assetCat") ? this.getSumItemJoinSql("assetCat") : this.getSumItemTableName("assetCat");
        sql.append(" INNER JOIN ").append(tableName).append(" AS ").append("assetCat");
        sql.append(" ON b.FAssetCatID = ").append("assetCat").append(".FID");
        return sql.toString();
    }

    private StringBuffer getLeaseInSQL() {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT card.FNumber AS ASSETNUMBER,card.foldNumber as OLDERNUMBER, card.FAssetName AS ASSETNAME, card.FAssetCatID AS FAssetCatID,card.FSpecs AS specs, card.FMeasureUnitID AS measureUnitID,");
        sql.append("billEntry.fquantity AS leaseAmt, bill.fbargainNum AS bargainNum,bill.fsignatureDate AS signatureDate, bill.fleasor AS leasor, bill.fleasee AS leasee,");
        sql.append("bill.FLeaseTypeID AS leaseTypeID,bill.FBeginDate AS beginDate, bill.FEndDate AS endDate, bill.FBargainTime AS bargainTime, bill.FMeasureUnit AS measureUnit,");
        sql.append("bill.FSettlTypeID AS settlTypeID, bill.FPayMode AS payMode,bill.FCheckedStatus AS  FCheckedStatus, 0 AS disc, bill.FID AS billID,");
        sql.append("bill.FHireCurrencyID AS hireCurrencyID,billEntry.FHireOriginAmt AS hireOriginAmt, billEntry.FHirelocalamt AS hireLocalAmt,");
        sql.append("bill.FDeliverDate AS deliverDate, bill.FDeliverPlace AS deliverPlace, bill.FCautioner AS cautioner, bill.FCompanyID AS FCompanyID,");
        sql.append("case when DATEDIFF (dd, bill.FBeginDate, CURDATE()) < 0 then 0 when DATEDIFF (dd, bill.FEndDate,CURDATE()) >= 0 then bill.FBargainTime");
        sql.append(" else floor(case bill.FMeasureUnit when 0 then (DATEDIFF(mm, bill.FBeginDate, CURDATE()) - case when DAYOFMONTH (CURDATE())-DAYOFMONTH (bill.FBeginDate) < 0 then 1 else 0 end )/12");
        sql.append(" when 1 then DATEDIFF(mm, bill.FBeginDate, CURDATE()) - case when DAYOFMONTH (CURDATE())-DAYOFMONTH (bill.FBeginDate) < 0 then 1 else 0 end");
        sql.append(" else DATEDIFF (dd, bill.FBeginDate, CURDATE()) end) end as leasedTime,");
        sql.append(" bill.FBargainTime - case when DATEDIFF (dd, bill.FBeginDate, CURDATE()) < 0 then 0 when DATEDIFF (dd, bill.FEndDate,CURDATE()) >= 0 then bill.FBargainTime");
        sql.append(" else floor(case bill.FMeasureUnit when 0 then (DATEDIFF(mm, bill.FBeginDate, CURDATE()) - case when DAYOFMONTH (CURDATE())-DAYOFMONTH (bill.FBeginDate) < 0 then 1 else 0 end )/12");
        sql.append(" when 1 then DATEDIFF(mm, bill.FBeginDate, CURDATE()) - case when DAYOFMONTH (CURDATE())-DAYOFMONTH (bill.FBeginDate) < 0 then 1 else 0 end");
        sql.append(" else DATEDIFF (dd, bill.FBeginDate, CURDATE()) end) end as remainTime ");
        sql.append(" from T_FA_FaLeaseInBill bill inner join T_FA_FaLeaseInBillEntry billEntry on bill.fid = billEntry.FHeadID ");
        sql.append(" inner join T_FA_FaLeaseType AS leaseType ON bill.fleaseTypeID = leaseType.FID ");
        sql.append(" inner join T_FA_FaCurCard card on billEntry.fCurCardID = card.fid");
        if (!this.includeFiLeaseIn || !this.includeWrLeaseIn) {
            if (this.includeFiLeaseIn) {
                sql.append(" where leaseType.fnumber = '").append(FINANCING_NUMBER).append("'");
            } else if (this.includeWrLeaseIn) {
                sql.append(" where leaseType.fnumber = '").append(WORK_NUMBER).append("'");
            }
        }
        sql.append(" UNION ALL ");
        sql.append("SELECT billEntry.FCardNumber AS ASSETNUMBER, TO_CHAR(NULL) AS OLDERNUMBER,billEntry.FCardName AS ASSETNAME, billEntry.FAssetCatID AS FAssetCatID,billEntry.FSpecs AS specs, billEntry.FMeasureUnitID AS measureUnitID,");
        sql.append("billEntry.fquantity AS leaseAmt, bill.fbargainNum AS bargainNum,bill.fsignatureDate AS signatureDate, bill.fleasor AS leasor, bill.fleasee AS leasee,");
        sql.append("bill.FLeaseTypeID AS leaseTypeID,bill.FBeginDate AS beginDate, bill.FEndDate AS endDate, bill.FBargainTime AS bargainTime, bill.FMeasureUnit AS measureUnit,");
        sql.append("bill.FSettlTypeID AS settlTypeID, bill.FPayMode AS payMode, bill.FCheckedStatus AS  FCheckedStatus,0 AS disc,bill.FID AS billID,");
        sql.append("bill.FHireCurrencyID AS hireCurrencyID,billEntry.FHireOriginAmt AS hireOriginAmt, billEntry.FHirelocalamt AS hireLocalAmt,");
        sql.append("bill.FDeliverDate AS deliverDate, bill.FDeliverPlace AS deliverPlace, bill.FCautioner AS cautioner,bill.FCompanyID AS FCompanyID,");
        sql.append("case when DATEDIFF (dd, bill.FBeginDate, CURDATE()) < 0 then 0 when DATEDIFF (dd, bill.FEndDate,CURDATE()) >= 0 then bill.FBargainTime");
        sql.append(" else floor(case bill.FMeasureUnit when 0 then (DATEDIFF(mm, bill.FBeginDate, CURDATE()) - case when DAYOFMONTH (CURDATE())-DAYOFMONTH (bill.FBeginDate) < 0 then 1 else 0 end )/12");
        sql.append(" when 1 then DATEDIFF(mm, bill.FBeginDate, CURDATE()) - case when DAYOFMONTH (CURDATE())-DAYOFMONTH (bill.FBeginDate) < 0 then 1 else 0 end");
        sql.append(" else DATEDIFF (dd, bill.FBeginDate, CURDATE()) end) end as leasedTime, ");
        sql.append(" bill.FBargainTime - case when DATEDIFF (dd, bill.FBeginDate, CURDATE()) < 0 then 0 when DATEDIFF (dd, bill.FEndDate,CURDATE()) >= 0 then bill.FBargainTime");
        sql.append(" else floor(case bill.FMeasureUnit when 0 then (DATEDIFF(mm, bill.FBeginDate, CURDATE()) - case when DAYOFMONTH (CURDATE())-DAYOFMONTH (bill.FBeginDate) < 0 then 1 else 0 end )/12");
        sql.append(" when 1 then DATEDIFF(mm, bill.FBeginDate, CURDATE()) - case when DAYOFMONTH (CURDATE())-DAYOFMONTH (bill.FBeginDate) < 0 then 1 else 0 end");
        sql.append(" else DATEDIFF (dd, bill.FBeginDate, CURDATE()) end) end as remainTime ");
        sql.append(" from T_FA_FaLeaseInBill bill inner join T_FA_FaLeaseInBillEntry billEntry on bill.fid = billEntry.FHeadID ");
        sql.append(" inner join T_FA_FaLeaseType AS leaseType ON bill.fleaseTypeID = leaseType.FID ");
        sql.append(" where bill.FCheckedStatus = ").append(2).append(" AND billEntry.fCurCardID IS NULL");
        if (!this.includeFiLeaseIn || !this.includeWrLeaseIn) {
            if (this.includeFiLeaseIn) {
                sql.append(" and leaseType.fnumber = '").append(FINANCING_NUMBER).append("'");
            } else if (this.includeWrLeaseIn) {
                sql.append(" and leaseType.fnumber = '").append(WORK_NUMBER).append("'");
            }
        }
        return sql;
    }

    private StringBuffer getLeaseOutSQL() {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT card.FNumber AS ASSETNUMBER, card.foldNumber AS OLDERNUMBER,card.FAssetName AS ASSETNAME, card.FAssetCatID AS FAssetCatID,card.FSpecs AS specs, card.FMeasureUnitID AS measureUnitID,");
        sql.append("outBillEntry.fquantity AS leaseAmt, bill.fbargainNum AS bargainNum,bill.fsignatureDate AS signatureDate, bill.FHireCompany AS leasor, bill.FLeaseCompany AS leasee,");
        sql.append("bill.FFaLeaseTypeID AS leaseTypeID,bill.FBeginDate AS beginDate, bill.FEndDate AS endDate, bill.FBargainTime AS bargainTime,bill.FMeasureUnit AS measureUnit,");
        sql.append("bill.FHireBalanceTypeID AS settlTypeID, bill.FPayMode AS payMode, bill.FCheckedStatus AS  FCheckedStatus,1 AS disc,bill.FID AS billID,");
        sql.append("bill.FHireCurrencyID AS hireCurrencyID,outBillEntry.FHireOriginAmt AS hireOriginAmt, outBillEntry.FHirelocalamt AS hireLocalAmt, ");
        sql.append("bill.FDeliverDate AS deliverDate,bill.FDeliverPlace AS deliverPlace, bill.FCautioner AS cautioner,bill.FCompanyID AS FCompanyID,");
        sql.append("case when DATEDIFF (dd, bill.FBeginDate, CURDATE()) < 0 then 0 when DATEDIFF (dd, bill.FEndDate,CURDATE()) >= 0 then bill.FBargainTime");
        sql.append(" else floor(case bill.FMeasureUnit when 0 then (DATEDIFF(mm, bill.FBeginDate, CURDATE()) - case when DAYOFMONTH (CURDATE())-DAYOFMONTH (bill.FBeginDate) < 0 then 1 else 0 end )/12");
        sql.append(" when 1 then DATEDIFF(mm, bill.FBeginDate, CURDATE()) - case when DAYOFMONTH (CURDATE())-DAYOFMONTH (bill.FBeginDate) < 0 then 1 else 0 end");
        sql.append(" else DATEDIFF (dd, bill.FBeginDate, CURDATE()) end) end as leasedTime, ");
        sql.append(" bill.FBargainTime - case when DATEDIFF (dd, bill.FBeginDate, CURDATE()) < 0 then 0 when DATEDIFF (dd, bill.FEndDate,CURDATE()) >= 0 then bill.FBargainTime");
        sql.append(" else floor(case bill.FMeasureUnit when 0 then (DATEDIFF(mm, bill.FBeginDate, CURDATE()) - case when DAYOFMONTH (CURDATE())-DAYOFMONTH (bill.FBeginDate) < 0 then 1 else 0 end )/12");
        sql.append(" when 1 then DATEDIFF(mm, bill.FBeginDate, CURDATE()) - case when DAYOFMONTH (CURDATE())-DAYOFMONTH (bill.FBeginDate) < 0 then 1 else 0 end");
        sql.append(" else DATEDIFF (dd, bill.FBeginDate, CURDATE()) end) end as remainTime ");
        sql.append(" from T_FA_FaLeaseBill bill inner join T_FA_FaLeaseBillEntry outBillEntry on bill.fid = outBillEntry.FFaleaseBillID ");
        sql.append(" inner join T_FA_FaCurCard card on outBillEntry.fCurCardID = card.fid ");
        sql.append(" inner join T_FA_FaLeaseType AS leaseType ON bill.ffaleaseTypeID = leaseType.FID ");
        if (!this.includeFiLeaseOut || !this.includeWrLeaseOut) {
            if (this.includeFiLeaseOut) {
                sql.append(" where leaseType.fnumber = '").append(FINANCING_NUMBER).append("'");
            } else if (this.includeWrLeaseOut) {
                sql.append(" where leaseType.fnumber = '").append(WORK_NUMBER).append("'");
            }
        }
        return sql;
    }

    private String getCondSql(boolean isCurrPeriod) {
        StringBuffer condSql = new StringBuffer();
        condSql.append(" b.fcheckedStatus = ").append(2);
        if (this.beginDateFrom != null) {
            condSql.append(" AND b.beginDate >= ?");
            this.params.addDate(new java.sql.Date(DateTimeUtils.truncateDate((Date)this.beginDateFrom).getTime()));
        }
        if (this.beginDateTo != null) {
            condSql.append(" AND b.beginDate <= ?");
            this.params.addDate(new java.sql.Date(DateTimeUtils.truncateDate((Date)this.beginDateTo).getTime()));
        }
        if (this.endDateFrom != null) {
            condSql.append(" AND b.endDate >= ?");
            this.params.addDate(new java.sql.Date(DateTimeUtils.truncateDate((Date)this.endDateFrom).getTime()));
        }
        if (this.endDateTo != null) {
            condSql.append(" AND b.endDate <= ?");
            this.params.addDate(new java.sql.Date(DateTimeUtils.truncateDate((Date)this.endDateTo).getTime()));
        }
        condSql.append(" AND COMPANY.FID = ? ");
        this.params.addString(ContextUtil.getCurrentFIUnit((Context)this.ctx).getId().toString());
        if (this.filter != null) {
            condSql.append(" AND ").append(this.filter);
        }
        return condSql.toString();
    }

    @Override
    protected String buildFilterSql(EntityViewInfo ev) {
        FilterInfo filterInfo = ev.getFilter();
        if (filterInfo == null || filterInfo.getFilterItems() == null || filterInfo.getFilterItems().isEmpty()) {
            return null;
        }
        for (int i = 0; i < ev.getFilter().getFilterItems().size(); ++i) {
            FilterItemInfo fitemInfo = ev.getFilter().getFilterItems().get(i);
            if (!fitemInfo.getPropertyName().equals("measureUnit") && !fitemInfo.getPropertyName().equals("payMode")) continue;
            fitemInfo.setCompareValue((Object)new Integer(fitemInfo.getCompareValue().toString()));
        }
        return ev.getFilter().toString();
    }

    @Override
    protected String getFirstDisplayField() {
        return "ASSETNUMBER";
    }
}

