/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.rpt.app.faleasestrategy.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.basedata.DepreciationMethodEnum;
import com.kingdee.eas.fi.fa.manage.FaLeaseInBillNewInfo;
import com.kingdee.eas.fi.fa.manage.FaLeaseTypeEnum;
import com.kingdee.eas.fi.fa.manage.FaLiabilitiesCvMethodEnum;
import com.kingdee.eas.fi.fa.rpt.FaAmortizedCostRptEntryCollection;
import com.kingdee.eas.fi.fa.rpt.FaAmortizedCostRptEntryInfo;
import com.kingdee.eas.fi.fa.rpt.FaAmortizedCostRptFactory;
import com.kingdee.eas.fi.fa.rpt.FaAmortizedCostRptInfo;
import com.kingdee.eas.fi.fa.rpt.app.faleasestrategy.impl.AbstractFaAmortizedCostRptStrategy;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Statement;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class FLDecValueAmortizedCostRptStrategy
extends AbstractFaAmortizedCostRptStrategy {
    private static final Logger logger = Logger.getLogger(FLDecValueAmortizedCostRptStrategy.class);
    private Date decValueDate;
    private Date decPreValueDate;
    private int count;
    private int monthCount;
    private BigDecimal initialAssetDecValue = BigDecimal.ZERO;

    @Override
    public FaAmortizedCostRptInfo calcACRData(Context ctx, FaLeaseInBillNewInfo billInfo, FaAmortizedCostRptInfo curACRpt, FaAmortizedCostRptEntryCollection curACERptCol) throws EASBizException, BOSException {
        this.initField(ctx, billInfo);
        this.initDecValueDate(ctx, billInfo);
        this.initPreDecValueDate(ctx, billInfo);
        this.count = 0;
        curACRpt = FaAmortizedCostRptFactory.getLocalInstance(ctx).getFaAmortizedCostRptInfo("where leaseInBill = '" + billInfo.getId().toString() + "'");
        curACRpt.getEntry().sort("date");
        curACERptCol = curACRpt.getEntry();
        this.calcStartEntriesMethod(ctx, billInfo, curACRpt, curACERptCol);
        double[][] entries = this.calcAfterStartEntriesUseArray(ctx, billInfo, curACRpt, curACERptCol);
        this.setEntries(ctx, billInfo, entries, this.payDateList, this.newLeasePolicy.getTranslationMethod(), curACRpt, curACERptCol);
        return curACRpt;
    }

    @Override
    protected void initPayDateAndPayArr(Context ctx, FaLeaseInBillNewInfo billInfo) throws EASBizException, BOSException {
    }

    @Override
    protected void calcStartEntriesMethod(Context ctx, FaLeaseInBillNewInfo billInfo, FaAmortizedCostRptInfo curACRpt, FaAmortizedCostRptEntryCollection curACERptCol) throws EASBizException, BOSException {
        this.count = 0;
        int perIndex = 0;
        while (this.count <= curACERptCol.size() && this.decValueDate.compareTo(curACERptCol.get(this.count).getDate()) != 0) {
            if (this.decPreValueDate.compareTo(curACERptCol.get(this.count).getDate()) == 0) {
                this.initialAssetDecValue = curACERptCol.get(this.count).getInitialAssetDecValue();
            }
            ++this.count;
        }
        while (perIndex < curACERptCol.size() - 1 && this.getPreMinMonthDate(this.decValueDate).compareTo(curACERptCol.get(perIndex).getDate()) != 0) {
            ++perIndex;
        }
        if (this.count <= curACERptCol.size()) {
            int remainDprTimes;
            double tmpOne = this.BD2db(curACERptCol.get(perIndex).getEndRightOfUseAsset()) - this.BD2db(this.initialAssetDecValue);
            curACERptCol.get(this.count).setInitRightOfUseAsset(this.formatBD4Save(this.db2BD(tmpOne), this.amountScale));
            int timeCycle = 1;
            if (billInfo.getLeaseType() == FaLeaseTypeEnum.FINANCE_LEASE) {
                remainDprTimes = billInfo.getRemainingDepreciationPeriod();
                timeCycle = remainDprTimes - this.subMonth(this.decValueDate, curACERptCol.get(0).getDate());
            } else if (this.newLeasePolicy.getDepreciationMethod() == DepreciationMethodEnum.First) {
                timeCycle = curACERptCol.size() - this.count;
            } else {
                remainDprTimes = billInfo.getBeginDate().compareTo(billInfo.getDpInitCfmDate()) < 0 ? billInfo.getTimeCycle() - this.subMonth(billInfo.getDpInitCfmDate(), billInfo.getBeginDate()) : billInfo.getTimeCycle();
                timeCycle = remainDprTimes - this.subMonth(this.decValueDate, curACERptCol.get(0).getDate());
            }
            BigDecimal cDpr = this.formatBD4Save(this.db2BD(tmpOne), this.amountScale).divide(this.db2BD(new Double(String.valueOf(timeCycle))), this.amountScale);
            if (this.initialAssetDecValue == null || BigDecimal.ZERO.compareTo(this.initialAssetDecValue) == 0) {
                cDpr = curACERptCol.get(perIndex).getCurDepreciation();
            }
            curACERptCol.get(this.count).setCurDepreciation(cDpr);
            double tmpTwo = this.BD2db(curACERptCol.get(perIndex).getCurAccDepreciation()) + this.BD2db(cDpr);
            curACERptCol.get(this.count).setCurAccDepreciation(this.formatBD4Save(this.db2BD(tmpTwo), this.amountScale));
            double tmpThree = tmpOne - this.BD2db(cDpr);
            curACERptCol.get(this.count).setEndRightOfUseAsset(this.formatBD4Save(this.db2BD(tmpThree), this.amountScale));
        }
    }

    @Override
    protected double[][] calcAfterStartEntriesUseArray(Context ctx, FaLeaseInBillNewInfo billInfo, FaAmortizedCostRptInfo curACRpt, FaAmortizedCostRptEntryCollection curACERptCol) throws EASBizException, BOSException {
        int remainDprTimes;
        int leaseTimeCycle;
        boolean isDepLessThanOrEqualToLease;
        double[][] entries = new double[curACRpt.getEntry().size() - this.count][5];
        FaAmortizedCostRptEntryInfo firstEntry = curACERptCol.get(this.count);
        int endDateIndex = 0;
        int depTimeCycle = billInfo.getTimeCycle();
        boolean bl = isDepLessThanOrEqualToLease = depTimeCycle <= (leaseTimeCycle = this.getLeaseCycle(billInfo.getBeginDate(), billInfo.getEndDate()));
        if (billInfo.getLeaseType() == FaLeaseTypeEnum.FINANCE_LEASE) {
            remainDprTimes = billInfo.getRemainingDepreciationPeriod();
            endDateIndex = remainDprTimes - this.subMonth(this.decValueDate, curACERptCol.get(0).getDate()) - 1;
        } else if (this.newLeasePolicy.getDepreciationMethod() == DepreciationMethodEnum.First) {
            endDateIndex = curACRpt.getEntry().size() - this.count;
        } else {
            remainDprTimes = billInfo.getBeginDate().compareTo(billInfo.getDpInitCfmDate()) < 0 ? billInfo.getTimeCycle() - this.subMonth(billInfo.getDpInitCfmDate(), billInfo.getBeginDate()) : billInfo.getTimeCycle();
            endDateIndex = remainDprTimes - this.subMonth(this.decValueDate, curACERptCol.get(0).getDate()) - 1;
        }
        Date lastDate = null;
        entries[0][1] = this.BD2db(firstEntry.getInitRightOfUseAsset());
        entries[0][2] = this.BD2db(firstEntry.getCurDepreciation());
        entries[0][3] = this.BD2db(firstEntry.getCurAccDepreciation());
        entries[0][4] = this.BD2db(firstEntry.getEndRightOfUseAsset());
        double depreciation = this.BD2db(firstEntry.getCurDepreciation());
        double accDepreciationTmp = this.BD2db(firstEntry.getCurAccDepreciation());
        for (int i = this.count + 1; i < curACERptCol.size(); ++i) {
            int index = i - this.count;
            entries[index][1] = entries[index - 1][4];
            if (this.newLeasePolicy.getDepreciationMethod() == DepreciationMethodEnum.Second) {
                if (lastDate == null) {
                    lastDate = this.decValueDate;
                }
                if (this.compareYearMonth(lastDate, curACERptCol.get(i).getDate())) {
                    lastDate = curACERptCol.get(i).getDate();
                    ++this.monthCount;
                    if (this.monthCount <= endDateIndex) {
                        entries[index][2] = depreciation;
                        entries[index][3] = depreciation + accDepreciationTmp;
                        accDepreciationTmp = entries[index][3];
                        if (this.monthCount == endDateIndex && isDepLessThanOrEqualToLease) {
                            entries[index][2] = entries[index][1];
                            entries[index][3] = this.BD2db(curACERptCol.get(0).getInitRightOfUseAsset()) - this.BD2db(billInfo.getInitialAssetDecValue()) + this.BD2db(curACERptCol.get(0).getInitialAssetDecValue());
                        }
                    } else if (!isDepLessThanOrEqualToLease) {
                        entries[index][2] = depreciation;
                        entries[index][3] = depreciation + accDepreciationTmp;
                        accDepreciationTmp = entries[index][3];
                    } else {
                        entries[index][2] = new Double("0");
                        entries[index][3] = this.BD2db(curACERptCol.get(0).getInitRightOfUseAsset()) - this.BD2db(billInfo.getInitialAssetDecValue()) + this.BD2db(curACERptCol.get(0).getInitialAssetDecValue());
                    }
                } else {
                    entries[index][2] = new Double("0");
                    entries[index][3] = entries[index - 1][3];
                }
            } else if (i <= endDateIndex) {
                entries[index][2] = depreciation;
                entries[index][3] = depreciation + accDepreciationTmp;
                accDepreciationTmp = entries[index][3];
                if (i == endDateIndex) {
                    entries[index][2] = entries[index][1];
                    entries[index][3] = this.BD2db(curACERptCol.get(0).getInitRightOfUseAsset()) - this.BD2db(billInfo.getInitialAssetDecValue()) + this.BD2db(curACERptCol.get(0).getInitialAssetDecValue());
                }
            } else {
                entries[index][2] = new Double("0");
                entries[index][3] = entries[index - 1][3];
            }
            entries[index][4] = entries[index][1] - entries[index][2];
        }
        return entries;
    }

    @Override
    protected FaAmortizedCostRptEntryCollection setEntries(Context ctx, FaLeaseInBillNewInfo billInfo, double[][] entries, List<Date> payDateList, FaLiabilitiesCvMethodEnum cvMethod, FaAmortizedCostRptInfo curACRpt, FaAmortizedCostRptEntryCollection curACERptCol) throws EASBizException, BOSException {
        FaAmortizedCostRptEntryCollection curACERptColNew = new FaAmortizedCostRptEntryCollection();
        Statement st = null;
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            st = conn.createStatement();
            for (int i = this.count; i < curACRpt.getEntry().size(); ++i) {
                int index = i - this.count;
                StringBuilder updateFaAmortizedEntrySQL = new StringBuilder("update T_FA_FaAmortizedCostRptEntry ");
                updateFaAmortizedEntrySQL.append("set FInitRightOfUseAsset = ").append(this.formatBD4Save(this.db2BD(entries[index][1]), this.amountScale));
                updateFaAmortizedEntrySQL.append(",FCurDepreciation = ").append(this.formatBD4Save(this.db2BD(entries[index][2]), this.amountScale));
                updateFaAmortizedEntrySQL.append(",FCurAccDepreciation = ").append(this.formatBD4Save(this.db2BD(entries[index][3]), this.amountScale));
                updateFaAmortizedEntrySQL.append(",FEndRightOfUseAsset = ").append(this.formatBD4Save(this.db2BD(entries[index][4]), this.amountScale));
                updateFaAmortizedEntrySQL.append(" where FID='" + curACRpt.getEntry().get(i).getId().toString() + "'");
                st.addBatch(updateFaAmortizedEntrySQL.toString());
                logger.debug((Object)("Execute sql:" + updateFaAmortizedEntrySQL.toString()));
            }
            st.executeBatch();
        }
        catch (Exception e) {
            try {
                logger.error((Object)"bactch update error!");
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(st, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)st, (Connection)conn);
        return curACERptColNew;
    }

    private void initDecValueDate(Context ctx, FaLeaseInBillNewInfo billInfo) throws EASBizException, BOSException {
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
        PeriodInfo currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.getEnum((int)2001), (CompanyOrgUnitInfo)aCompanyOrgUnitInfo);
        Calendar currentPeriodDate = Calendar.getInstance();
        currentPeriodDate.setTime(billInfo.getBeginDate());
        currentPeriodDate.set(currentPeriodInfo.getPeriodYear(), currentPeriodInfo.getPeriodNumber(), 1, 0, 0, 0);
        this.decValueDate = currentPeriodDate.getTime();
    }

    private Date getPreMinMonthDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(calendar.get(1), calendar.get(2) - 1, calendar.get(5), 0, 0, 0);
        calendar.set(5, calendar.getActualMinimum(5));
        return calendar.getTime();
    }

    private void initPreDecValueDate(Context ctx, FaLeaseInBillNewInfo billInfo) throws EASBizException, BOSException {
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
        PeriodInfo currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.getEnum((int)2001), (CompanyOrgUnitInfo)aCompanyOrgUnitInfo);
        Calendar currentPeriodDate = Calendar.getInstance();
        currentPeriodDate.setTime(billInfo.getBeginDate());
        currentPeriodDate.set(currentPeriodInfo.getPeriodYear(), currentPeriodInfo.getPeriodNumber() - 1, 1, 0, 0, 0);
        this.decPreValueDate = currentPeriodDate.getTime();
    }
}

